/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.simulatorSNMPAgent.service;

import org.apache.commons.cli.ParseException;
import org.snmp4j.smi.OctetString;

public final class DateParser {
    private static final String LEVEL_1_SPLITTER = ",";
    private static final String DATE_SPLITTER = "-";
    private static final String TIME_SPLITTER = ":";
    private static final String TIME_SUBSPLITTER_REGEXP = "\\.";
    private static final String TIME_SUBSPLITTER = ".";
    private static final int OCTETS_DOUBLE = 2;
    private static final int OCTETS_SINGLE = 1;
    private static final int DATE_INDEX = 0;
    private static final int TIME_INDEX = 1;
    private static final int TIMEZONE_INDEX = 2;
    private static final int PARTS_REQUIRED = 2;
    private static final int PARTS_OPTIONAL = 1;
    private static final int DATE_PARTS_COUNT = 3;
    private static final int YEAR_INDEX = 0;
    private static final int MONTH_INDEX = 1;
    private static final int DAY_INDEX = 2;
    private static final int TIME_PARTS_COUNT = 3;
    private static final int HOUR_INDEX = 0;
    private static final int MINUTE_INDEX = 1;
    private static final int SECONDS_DECISECONDS_INDEX = 2;
    private static final int SECONDS_INDEX = 0;
    private static final int DECISECONDS_INDEX = 1;
    private static final int TIMEZONE_PARTS_COUNT = 2;
    private static final int TZ_HOURS_INDEX = 0;
    private static final int TZ_MINUTES_INDEX = 1;
    private static final int MASK_BASE = 255;
    private static final int OCTET_SIZE = 8;

    private DateParser() {
    }

    public static OctetString parseDate(String snmpDate) throws ParseException {
        String[] parts = snmpDate.split(LEVEL_1_SPLITTER);
        if (parts.length != 3 && parts.length != 2) {
            throw new ParseException("Invalid date format");
        }
        String date = parts[0];
        String time = parts[1];
        String tz = null;
        if (parts.length == 3) {
            tz = parts[2];
        }
        String[] dateParts = DateParser.splitDate(date);
        int year = Integer.parseInt(dateParts[0]);
        int month = Integer.parseInt(dateParts[1]);
        int day = Integer.parseInt(dateParts[2]);
        String[] timeParts = DateParser.splitTime(time);
        int hour = Integer.parseInt(timeParts[0]);
        int minute = Integer.parseInt(timeParts[1]);
        String[] sDs = timeParts[2].split(TIME_SUBSPLITTER_REGEXP);
        int seconds = Integer.parseInt(sDs[0]);
        int deciSeconds = Integer.parseInt(sDs[1]);
        String mod = null;
        int hTz = 0;
        int mTz = 0;
        if (tz != null) {
            String[] tzParts = DateParser.splitTimezone(tz);
            mod = tzParts[0].substring(0, 1);
            hTz = Integer.parseInt(tzParts[0].substring(1));
            mTz = Integer.parseInt(tzParts[1]);
        }
        OctetString result = DateParser.prepareOutput(tz, year, month, day, hour, minute, seconds, deciSeconds, mod, hTz, mTz);
        return result;
    }

    private static String[] splitTime(String time) throws ParseException {
        String[] timeParts = time.split(TIME_SPLITTER);
        if (timeParts.length != 3 || !timeParts[2].contains(TIME_SUBSPLITTER)) {
            throw new ParseException("Invalid time format");
        }
        return timeParts;
    }

    private static String[] splitDate(String date) throws ParseException {
        String[] dateParts = date.split(DATE_SPLITTER);
        if (dateParts.length != 3) {
            throw new ParseException("Invalid date format");
        }
        return dateParts;
    }

    private static String[] splitTimezone(String tz) throws ParseException {
        String[] tzParts = tz.split(TIME_SPLITTER);
        if (tzParts.length != 2 || !tz.startsWith("+") && !tz.startsWith(DATE_SPLITTER)) {
            throw new ParseException("Invalid timezone format");
        }
        return tzParts;
    }

    private static OctetString prepareOutput(String tz, int year, int month, int day, int hour, int minute, int seconds, int deciSeconds, String mod, int hTz, int mTz) {
        OctetString result = new OctetString();
        DateParser.appendField(result, year, 2);
        DateParser.appendField(result, month, 1);
        DateParser.appendField(result, day, 1);
        DateParser.appendField(result, hour, 1);
        DateParser.appendField(result, minute, 1);
        DateParser.appendField(result, seconds, 1);
        DateParser.appendField(result, deciSeconds, 1);
        if (tz != null) {
            result.append(mod);
            DateParser.appendField(result, hTz, 1);
            DateParser.appendField(result, mTz, 1);
        }
        return result;
    }

    private static void appendField(OctetString octet, int field, int octets) {
        for (int i = 0; i < octets; ++i) {
            int mask = 255;
            int maskedOctet = field & (mask <<= 8 * (octets - i - 1));
            octet.append((byte)(maskedOctet >>= 8 * (octets - i - 1)));
        }
    }

    public static boolean isDate(String string) {
        return string.matches("^[0-9].*") && string.matches("^[0-9]{4}?-[0-9]{1,2}-[0-9]{1,2},[0-9]{1,2}:[0-9]{1,2}:[0-9]{1,2}\\.[0-9](,[+\\-][0-9]{1,2}:[0-9]{1,2})?$");
    }
}

