/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.simulatorSNMPAgent.service;

import com.veraxsystems.simulatorSNMPAgent.dao.IOidDataDao;
import com.veraxsystems.simulatorSNMPAgent.model.IOIDModel;
import com.veraxsystems.simulatorSNMPAgent.service.IOidDataService;
import java.util.ArrayList;
import java.util.List;

public class OidDataService
implements IOidDataService {
    private List<IOIDModel> errors;
    private IOidDataDao dataDAO;

    public OidDataService(IOidDataDao dataDAO) {
        this.dataDAO = dataDAO;
        this.errors = new ArrayList<IOIDModel>();
    }

    @Override
    public IOIDModel find(String oid, int repetitions) {
        List<IOIDModel> list = null;
        list = this.dataDAO.getCurrentBlock(oid, repetitions);
        if (list.isEmpty()) {
            return null;
        }
        IOIDModel model = list.get(0);
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i).isError()) {
                this.errors.add(model);
            }
            if (i < list.size() - 1) {
                list.get(i).setNextOid(list.get(i + 1));
                continue;
            }
            list.get(i).setNextOid(null);
        }
        return model;
    }

    @Override
    public List<IOIDModel> getErrors() {
        ArrayList<IOIDModel> list = new ArrayList<IOIDModel>(this.errors);
        this.errors.clear();
        return list;
    }

    @Override
    public void setValue(String oid, String value) {
        this.dataDAO.updateOid(oid, value);
    }
}

