/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.MaxBytesExceededException;
import org.bouncycastle.crypto.StreamCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.Strings;

public class Salsa20Engine
implements StreamCipher {
    private static final int stateSize = 16;
    private static final byte[] sigma = Strings.toByteArray("expand 32-byte k");
    private static final byte[] tau = Strings.toByteArray("expand 16-byte k");
    private int index = 0;
    private int[] engineState = null;
    private byte[] keyStream = new byte[4];
    private byte[] workingKey = null;
    private byte[] workingIV = null;
    private boolean initialised = false;
    private int cW0;
    private int cW1;
    private int cW2;

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        CipherParameters cipherParameters2 = cipherParameters;
        if (cipherParameters instanceof ParametersWithIV) {
            this.workingIV = ((ParametersWithIV)cipherParameters).getIV();
            cipherParameters2 = ((ParametersWithIV)cipherParameters).getParameters();
        }
        if (cipherParameters2 instanceof KeyParameter) {
            this.workingKey = ((KeyParameter)cipherParameters2).getKey();
            this.setKey(this.workingKey, this.workingIV);
            return;
        }
        throw new IllegalArgumentException("invalid parameter passed to Salsa20 init - " + cipherParameters.getClass().getName());
    }

    @Override
    public String getAlgorithmName() {
        return "Salsa20";
    }

    @Override
    public byte returnByte(byte by) {
        if (this.limitExceeded()) {
            throw new MaxBytesExceededException("2^70 byte limit per IV; Change IV");
        }
        if (this.index == 0) {
            this.keyStream = this.salsa20WordToByte(this.engineState);
            this.engineState[8] = this.engineState[8] + 1;
            if (this.engineState[8] == 0) {
                this.engineState[9] = this.engineState[9] + 1;
            }
        }
        byte by2 = (byte)(this.keyStream[this.index] ^ by);
        this.index = this.index + 1 & 0x3F;
        return by2;
    }

    @Override
    public void processBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (!this.initialised) {
            throw new IllegalStateException(this.getAlgorithmName() + " not initialised");
        }
        if (n + n2 > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (n3 + n2 > byArray2.length) {
            throw new DataLengthException("output buffer too short");
        }
        for (int i = 0; i < n2; ++i) {
            if (this.limitExceeded()) {
                throw new MaxBytesExceededException("2^70 byte limit per IV; Change IV");
            }
            if (this.index == 0) {
                this.keyStream = this.salsa20WordToByte(this.engineState);
                this.engineState[8] = this.engineState[8] + 1;
                if (this.engineState[8] == 0) {
                    this.engineState[9] = this.engineState[9] + 1;
                }
            }
            byArray2[i + n3] = (byte)(this.keyStream[this.index] ^ byArray[i + n]);
            this.index = this.index + 1 & 0x3F;
        }
    }

    @Override
    public void reset() {
        this.setKey(this.workingKey, this.workingIV);
    }

    private void setKey(byte[] byArray, byte[] byArray2) {
        byte[] byArray3;
        this.workingKey = byArray;
        this.workingIV = byArray2;
        this.index = 0;
        this.resetCounter();
        if (this.engineState == null) {
            this.engineState = new int[16];
        }
        int n = 0;
        this.engineState[1] = this.byteToIntLittle(this.workingKey, 0);
        this.engineState[2] = this.byteToIntLittle(this.workingKey, 4);
        this.engineState[3] = this.byteToIntLittle(this.workingKey, 8);
        this.engineState[4] = this.byteToIntLittle(this.workingKey, 12);
        if (this.workingKey.length == 32) {
            byArray3 = sigma;
            n = 16;
        } else {
            byArray3 = tau;
        }
        this.engineState[11] = this.byteToIntLittle(this.workingKey, n);
        this.engineState[12] = this.byteToIntLittle(this.workingKey, n + 4);
        this.engineState[13] = this.byteToIntLittle(this.workingKey, n + 8);
        this.engineState[14] = this.byteToIntLittle(this.workingKey, n + 12);
        this.engineState[0] = this.byteToIntLittle(byArray3, 0);
        this.engineState[5] = this.byteToIntLittle(byArray3, 4);
        this.engineState[10] = this.byteToIntLittle(byArray3, 8);
        this.engineState[15] = this.byteToIntLittle(byArray3, 12);
        this.engineState[6] = this.byteToIntLittle(this.workingIV, 0);
        this.engineState[7] = this.byteToIntLittle(this.workingIV, 4);
        this.engineState[9] = 0;
        this.engineState[8] = 0;
        this.initialised = true;
    }

    private byte[] salsa20WordToByte(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        int n = 0;
        while (n++ < 10) {
            nArray2[4] = nArray2[4] ^ this.rotl(nArray2[0] + nArray2[12], 7);
            nArray2[8] = nArray2[8] ^ this.rotl(nArray2[4] + nArray2[0], 9);
            nArray2[12] = nArray2[12] ^ this.rotl(nArray2[8] + nArray2[4], 13);
            nArray2[0] = nArray2[0] ^ this.rotl(nArray2[12] + nArray2[8], 18);
            nArray2[9] = nArray2[9] ^ this.rotl(nArray2[5] + nArray2[1], 7);
            nArray2[13] = nArray2[13] ^ this.rotl(nArray2[9] + nArray2[5], 9);
            nArray2[1] = nArray2[1] ^ this.rotl(nArray2[13] + nArray2[9], 13);
            nArray2[5] = nArray2[5] ^ this.rotl(nArray2[1] + nArray2[13], 18);
            nArray2[14] = nArray2[14] ^ this.rotl(nArray2[10] + nArray2[6], 7);
            nArray2[2] = nArray2[2] ^ this.rotl(nArray2[14] + nArray2[10], 9);
            nArray2[6] = nArray2[6] ^ this.rotl(nArray2[2] + nArray2[14], 13);
            nArray2[10] = nArray2[10] ^ this.rotl(nArray2[6] + nArray2[2], 18);
            nArray2[3] = nArray2[3] ^ this.rotl(nArray2[15] + nArray2[11], 7);
            nArray2[7] = nArray2[7] ^ this.rotl(nArray2[3] + nArray2[15], 9);
            nArray2[11] = nArray2[11] ^ this.rotl(nArray2[7] + nArray2[3], 13);
            nArray2[15] = nArray2[15] ^ this.rotl(nArray2[11] + nArray2[7], 18);
            nArray2[1] = nArray2[1] ^ this.rotl(nArray2[0] + nArray2[3], 7);
            nArray2[2] = nArray2[2] ^ this.rotl(nArray2[1] + nArray2[0], 9);
            nArray2[3] = nArray2[3] ^ this.rotl(nArray2[2] + nArray2[1], 13);
            nArray2[0] = nArray2[0] ^ this.rotl(nArray2[3] + nArray2[2], 18);
            nArray2[6] = nArray2[6] ^ this.rotl(nArray2[5] + nArray2[4], 7);
            nArray2[7] = nArray2[7] ^ this.rotl(nArray2[6] + nArray2[5], 9);
            nArray2[4] = nArray2[4] ^ this.rotl(nArray2[7] + nArray2[6], 13);
            nArray2[5] = nArray2[5] ^ this.rotl(nArray2[4] + nArray2[7], 18);
            nArray2[11] = nArray2[11] ^ this.rotl(nArray2[10] + nArray2[9], 7);
            nArray2[8] = nArray2[8] ^ this.rotl(nArray2[11] + nArray2[10], 9);
            nArray2[9] = nArray2[9] ^ this.rotl(nArray2[8] + nArray2[11], 13);
            nArray2[10] = nArray2[10] ^ this.rotl(nArray2[9] + nArray2[8], 18);
            nArray2[12] = nArray2[12] ^ this.rotl(nArray2[15] + nArray2[14], 7);
            nArray2[13] = nArray2[13] ^ this.rotl(nArray2[12] + nArray2[15], 9);
            nArray2[14] = nArray2[14] ^ this.rotl(nArray2[13] + nArray2[12], 13);
            nArray2[15] = nArray2[15] ^ this.rotl(nArray2[14] + nArray2[13], 18);
        }
        for (n = 0; n < 16; ++n) {
            int n2 = n;
            nArray2[n2] = nArray2[n2] + nArray[n];
        }
        return this.intToByteLittle(nArray2);
    }

    private byte[] intToByteLittle(int n) {
        byte[] byArray = new byte[]{(byte)n, (byte)(n >>> 8), (byte)(n >>> 16), (byte)(n >>> 24)};
        return byArray;
    }

    private byte[] intToByteLittle(int[] nArray) {
        byte[] byArray = new byte[4 * nArray.length];
        int n = 0;
        int n2 = 0;
        while (n < nArray.length) {
            System.arraycopy(this.intToByteLittle(nArray[n]), 0, byArray, n2, 4);
            ++n;
            n2 += 4;
        }
        return byArray;
    }

    private int rotl(int n, int n2) {
        return n << n2 | n >>> 32 - n2;
    }

    private int byteToIntLittle(byte[] byArray, int n) {
        return byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | byArray[n] << 24;
    }

    private void resetCounter() {
        this.cW0 = 0;
        this.cW1 = 0;
        this.cW2 = 0;
    }

    private boolean limitExceeded() {
        ++this.cW0;
        if (this.cW0 == 0) {
            ++this.cW1;
            if (this.cW1 == 0) {
                ++this.cW2;
                return (this.cW2 & 0x20) != 0;
            }
        }
        return false;
    }
}

