/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo.snmp;

import java.util.List;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOGroup;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.mo.DefaultMOMutableRow2PC;
import org.snmp4j.agent.mo.DefaultMOMutableRow2PCFactory;
import org.snmp4j.agent.mo.DefaultMOMutableTableModel;
import org.snmp4j.agent.mo.DefaultMOTable;
import org.snmp4j.agent.mo.MOAccessImpl;
import org.snmp4j.agent.mo.MOColumn;
import org.snmp4j.agent.mo.MOMutableColumn;
import org.snmp4j.agent.mo.MOTable;
import org.snmp4j.agent.mo.MOTableIndex;
import org.snmp4j.agent.mo.MOTableRowFactory;
import org.snmp4j.agent.mo.MOTableRowFilter;
import org.snmp4j.agent.mo.MOTableSubIndex;
import org.snmp4j.agent.mo.MOValueValidationEvent;
import org.snmp4j.agent.mo.MOValueValidationListener;
import org.snmp4j.agent.mo.snmp.Enumerated;
import org.snmp4j.agent.mo.snmp.RowStatus;
import org.snmp4j.agent.mo.snmp.StorageType;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;

public class SnmpProxyMIB
implements MOGroup {
    public static final OID oidSnmpProxyEntry = new OID(new int[]{1, 3, 6, 1, 6, 3, 14, 1, 2, 1});
    public static final int colSnmpProxyType = 2;
    public static final int colSnmpProxyContextEngineID = 3;
    public static final int colSnmpProxyContextName = 4;
    public static final int colSnmpProxyTargetParamsIn = 5;
    public static final int colSnmpProxySingleTargetOut = 6;
    public static final int colSnmpProxyMultipleTargetOut = 7;
    public static final int colSnmpProxyStorageType = 8;
    public static final int colSnmpProxyRowStatus = 9;
    public static final int idxSnmpProxyType = 0;
    public static final int idxSnmpProxyContextEngineID = 1;
    public static final int idxSnmpProxyContextName = 2;
    public static final int idxSnmpProxyTargetParamsIn = 3;
    public static final int idxSnmpProxySingleTargetOut = 4;
    public static final int idxSnmpProxyMultipleTargetOut = 5;
    public static final int idxSnmpProxyStorageType = 6;
    public static final int idxSnmpProxyRowStatus = 7;
    private static MOTableSubIndex[] snmpProxyEntryIndexes = new MOTableSubIndex[]{new MOTableSubIndex(4, 1, 32)};
    private static MOTableIndex snmpProxyEntryIndex = new MOTableIndex(snmpProxyEntryIndexes, true);
    private DefaultMOTable snmpProxyEntry;
    private DefaultMOMutableTableModel snmpProxyEntryModel;

    public SnmpProxyMIB() {
        this.createSnmpProxyEntry();
    }

    private void createSnmpProxyEntry() {
        MOColumn[] snmpProxyEntryColumns = new MOColumn[8];
        snmpProxyEntryColumns[0] = new Enumerated<Object>(2, 2, MOAccessImpl.ACCESS_READ_CREATE, null, true, new int[]{1, 2, 3, 4});
        snmpProxyEntryColumns[1] = new MOMutableColumn(3, 4, MOAccessImpl.ACCESS_READ_CREATE, null, true);
        ((MOMutableColumn)snmpProxyEntryColumns[1]).addMOValueValidationListener(new SnmpProxyContextEngineIDValidator());
        snmpProxyEntryColumns[2] = new MOMutableColumn(4, 4, MOAccessImpl.ACCESS_READ_CREATE, null, true);
        ((MOMutableColumn)snmpProxyEntryColumns[2]).addMOValueValidationListener(new SnmpProxyContextNameValidator());
        snmpProxyEntryColumns[3] = new MOMutableColumn(5, 4, MOAccessImpl.ACCESS_READ_CREATE, null, true);
        ((MOMutableColumn)snmpProxyEntryColumns[3]).addMOValueValidationListener(new SnmpProxyTargetParamsInValidator());
        snmpProxyEntryColumns[4] = new MOMutableColumn(6, 4, MOAccessImpl.ACCESS_READ_CREATE, null, true);
        ((MOMutableColumn)snmpProxyEntryColumns[4]).addMOValueValidationListener(new SnmpProxySingleTargetOutValidator());
        snmpProxyEntryColumns[5] = new MOMutableColumn(7, 4, MOAccessImpl.ACCESS_READ_CREATE, null, true);
        ((MOMutableColumn)snmpProxyEntryColumns[5]).addMOValueValidationListener(new SnmpProxyMultipleTargetOutValidator());
        snmpProxyEntryColumns[6] = new StorageType(8, MOAccessImpl.ACCESS_READ_CREATE, new Integer32(3), true);
        snmpProxyEntryColumns[7] = new RowStatus(9);
        this.snmpProxyEntry = new DefaultMOTable(oidSnmpProxyEntry, snmpProxyEntryIndex, snmpProxyEntryColumns);
        this.snmpProxyEntryModel = new DefaultMOMutableTableModel();
        this.snmpProxyEntry.setModel(this.snmpProxyEntryModel);
        this.snmpProxyEntryModel.setRowFactory((MOTableRowFactory)new SnmpProxyRowFactory());
    }

    @Override
    public void registerMOs(MOServer server, OctetString context) throws DuplicateRegistrationException {
        server.register(this.snmpProxyEntry, context);
    }

    @Override
    public void unregisterMOs(MOServer server, OctetString context) {
        server.unregister(this.snmpProxyEntry, context);
    }

    public MOTable getSnmpProxyEntry() {
        return this.snmpProxyEntry;
    }

    public boolean addProxyEntry(OctetString name, int type, OctetString contextEngineId, OctetString contextName, OctetString targetParamsIn, OctetString singleTargetOut, OctetString multipleTargetOut, int storageType) {
        Variable[] var = new Variable[this.snmpProxyEntry.getColumnCount()];
        OID index = name.toSubIndex(true);
        var[0] = new Integer32(type);
        var[1] = contextEngineId;
        var[2] = contextName;
        var[3] = targetParamsIn;
        var[4] = singleTargetOut;
        var[5] = multipleTargetOut;
        var[6] = new Integer32(storageType);
        var[7] = new Integer32(1);
        Object row = this.snmpProxyEntry.createRow(index, var);
        return this.snmpProxyEntry.addRow(row);
    }

    public SnmpProxyRow removeProxyEntry(OctetString name) {
        OID index = name.toSubIndex(true);
        SnmpProxyRow removedRow = (SnmpProxyRow)this.snmpProxyEntry.removeRow(index);
        return removedRow;
    }

    public List<SnmpProxyRow> getProxyRows(final int proxyType, final OctetString contextEngineID, final OctetString context) {
        MOTableRowFilter<SnmpProxyRow> filter = new MOTableRowFilter<SnmpProxyRow>(){

            @Override
            public boolean passesFilter(SnmpProxyRow row) {
                int rowStatus = row.getSnmpProxyRowStatus().getValue();
                if (rowStatus != 1) {
                    return false;
                }
                int type = row.getSnmpProxyType().getValue();
                if (type != proxyType) {
                    return false;
                }
                OctetString cengineID = row.getSnmpProxyContextEngineID();
                if (!cengineID.equals(contextEngineID)) {
                    return false;
                }
                OctetString cname = row.getSnmpProxyContextName();
                return cname == null || cname.equals(context);
            }
        };
        return this.snmpProxyEntryModel.getRows(null, null, filter);
    }

    public class SnmpProxyRow
    extends DefaultMOMutableRow2PC {
        public SnmpProxyRow(OID index, Variable[] values) {
            super(index, values);
        }

        public Integer32 getSnmpProxyType() {
            return (Integer32)this.getValue(0);
        }

        public void setSnmpProxyType(Integer32 newValue) {
            this.setValue(0, newValue);
        }

        public OctetString getSnmpProxyContextEngineID() {
            return (OctetString)this.getValue(1);
        }

        public void setSnmpProxyContextEngineID(OctetString newValue) {
            this.setValue(1, newValue);
        }

        public OctetString getSnmpProxyContextName() {
            return (OctetString)this.getValue(2);
        }

        public void setSnmpProxyContextName(OctetString newValue) {
            this.setValue(2, newValue);
        }

        public OctetString getSnmpProxyTargetParamsIn() {
            return (OctetString)this.getValue(3);
        }

        public void setSnmpProxyTargetParamsIn(OctetString newValue) {
            this.setValue(3, newValue);
        }

        public OctetString getSnmpProxySingleTargetOut() {
            return (OctetString)this.getValue(4);
        }

        public void setSnmpProxySingleTargetOut(OctetString newValue) {
            this.setValue(4, newValue);
        }

        public OctetString getSnmpProxyMultipleTargetOut() {
            return (OctetString)this.getValue(5);
        }

        public void setSnmpProxyMultipleTargetOut(OctetString newValue) {
            this.setValue(5, newValue);
        }

        public Integer32 getSnmpProxyStorageType() {
            return (Integer32)this.getValue(6);
        }

        public void setSnmpProxyStorageType(Integer32 newValue) {
            this.setValue(6, newValue);
        }

        public Integer32 getSnmpProxyRowStatus() {
            return (Integer32)this.getValue(7);
        }

        public void setSnmpProxyRowStatus(Integer32 newValue) {
            this.setValue(7, newValue);
        }
    }

    class SnmpProxyRowFactory
    extends DefaultMOMutableRow2PCFactory<SnmpProxyRow> {
        @Override
        public SnmpProxyRow createRow(OID index, Variable[] values) throws UnsupportedOperationException {
            return new SnmpProxyRow(index, values);
        }
    }

    public static final class SnmpProxyTypeEnum {
        public static final int read = 1;
        public static final int write = 2;
        public static final int trap = 3;
        public static final int inform = 4;
    }

    static class SnmpProxyMultipleTargetOutValidator
    implements MOValueValidationListener {
        SnmpProxyMultipleTargetOutValidator() {
        }

        @Override
        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
            OctetString os = (OctetString)newValue;
            if (os.length() < 0 || os.length() > 255) {
                validationEvent.setValidationStatus(8);
                return;
            }
        }
    }

    static class SnmpProxySingleTargetOutValidator
    implements MOValueValidationListener {
        SnmpProxySingleTargetOutValidator() {
        }

        @Override
        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
            OctetString os = (OctetString)newValue;
            if (os.length() < 0 || os.length() > 255) {
                validationEvent.setValidationStatus(8);
                return;
            }
        }
    }

    static class SnmpProxyTargetParamsInValidator
    implements MOValueValidationListener {
        SnmpProxyTargetParamsInValidator() {
        }

        @Override
        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
            OctetString os = (OctetString)newValue;
            if (os.length() < 0 || os.length() > 255) {
                validationEvent.setValidationStatus(8);
                return;
            }
        }
    }

    static class SnmpProxyContextNameValidator
    implements MOValueValidationListener {
        SnmpProxyContextNameValidator() {
        }

        @Override
        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
            OctetString os = (OctetString)newValue;
            if (os.length() < 0 || os.length() > 255) {
                validationEvent.setValidationStatus(8);
                return;
            }
        }
    }

    static class SnmpProxyContextEngineIDValidator
    implements MOValueValidationListener {
        SnmpProxyContextEngineIDValidator() {
        }

        @Override
        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
            OctetString os = (OctetString)newValue;
            if (os.length() < 5 || os.length() > 32) {
                validationEvent.setValidationStatus(8);
                return;
            }
        }
    }
}

