/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo.snmp4j.example;

import java.io.IOException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimerTask;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOAccess;
import org.snmp4j.agent.MOGroup;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.NotificationOriginator;
import org.snmp4j.agent.io.MOInput;
import org.snmp4j.agent.io.MOOutput;
import org.snmp4j.agent.mo.DefaultMOFactory;
import org.snmp4j.agent.mo.DefaultMOMutableRow2PC;
import org.snmp4j.agent.mo.DefaultMOMutableRow2PCFactory;
import org.snmp4j.agent.mo.DefaultMOMutableTableModel;
import org.snmp4j.agent.mo.DefaultMOTable;
import org.snmp4j.agent.mo.MOAccessImpl;
import org.snmp4j.agent.mo.MOColumn;
import org.snmp4j.agent.mo.MOFactory;
import org.snmp4j.agent.mo.MOMutableColumn;
import org.snmp4j.agent.mo.MOMutableTableModel;
import org.snmp4j.agent.mo.MOScalar;
import org.snmp4j.agent.mo.MOTable;
import org.snmp4j.agent.mo.MOTableIndex;
import org.snmp4j.agent.mo.MOTableRowEvent;
import org.snmp4j.agent.mo.MOTableRowListener;
import org.snmp4j.agent.mo.MOTableSubIndex;
import org.snmp4j.agent.mo.MOValueValidationEvent;
import org.snmp4j.agent.mo.MOValueValidationListener;
import org.snmp4j.agent.mo.snmp.DateAndTime;
import org.snmp4j.agent.mo.snmp.DateAndTimeScalar;
import org.snmp4j.agent.mo.snmp.RowStatus;
import org.snmp4j.agent.mo.snmp.RowStatusEvent;
import org.snmp4j.agent.mo.snmp.RowStatusListener;
import org.snmp4j.agent.mo.snmp.StorageType;
import org.snmp4j.agent.mo.snmp.SysUpTime;
import org.snmp4j.agent.mo.snmp.smi.Constraint;
import org.snmp4j.agent.mo.snmp.smi.ConstraintsImpl;
import org.snmp4j.agent.mo.snmp.smi.EnumerationConstraint;
import org.snmp4j.agent.mo.snmp.smi.ValueConstraintValidator;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Counter64;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.UnsignedInteger32;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.util.CommonTimer;

public class Snmp4jHeartbeatMib
implements MOGroup,
RowStatusListener,
MOTableRowListener {
    private static final LogAdapter LOGGER = LogFactory.getLogger(Snmp4jHeartbeatMib.class);
    private static MOFactory moFactory = DefaultMOFactory.getInstance();
    public static final OID oidSnmp4jAgentHBRefTime = new OID(new int[]{1, 3, 6, 1, 4, 1, 4976, 10, 1, 1, 42, 2, 1, 1, 0});
    public static final OID oidSnmp4jAgentHBEvent = new OID(new int[]{1, 3, 6, 1, 4, 1, 4976, 10, 1, 1, 42, 2, 2, 0, 1});
    public static final OID oidTrapVarSnmp4jAgentHBCtrlEvents = new OID(new int[]{1, 3, 6, 1, 4, 1, 4976, 10, 1, 1, 42, 2, 1, 2, 1, 6});
    private static final String TC_MODULE_SNMPV2_TC = "SNMPv2-TC";
    private static final String TC_DATEANDTIME = "DateAndTime";
    private MOScalar snmp4jAgentHBRefTime;
    public static final OID oidSnmp4jAgentHBCtrlEntry = new OID(new int[]{1, 3, 6, 1, 4, 1, 4976, 10, 1, 1, 42, 2, 1, 2, 1});
    public static final int colSnmp4jAgentHBCtrlStartTime = 2;
    public static final int colSnmp4jAgentHBCtrlDelay = 3;
    public static final int colSnmp4jAgentHBCtrlPeriod = 4;
    public static final int colSnmp4jAgentHBCtrlMaxEvents = 5;
    public static final int colSnmp4jAgentHBCtrlEvents = 6;
    public static final int colSnmp4jAgentHBCtrlLastChange = 7;
    public static final int colSnmp4jAgentHBCtrlStorageType = 8;
    public static final int colSnmp4jAgentHBCtrlRowStatus = 9;
    public static final int idxSnmp4jAgentHBCtrlStartTime = 0;
    public static final int idxSnmp4jAgentHBCtrlDelay = 1;
    public static final int idxSnmp4jAgentHBCtrlPeriod = 2;
    public static final int idxSnmp4jAgentHBCtrlMaxEvents = 3;
    public static final int idxSnmp4jAgentHBCtrlEvents = 4;
    public static final int idxSnmp4jAgentHBCtrlLastChange = 5;
    public static final int idxSnmp4jAgentHBCtrlStorageType = 6;
    public static final int idxSnmp4jAgentHBCtrlRowStatus = 7;
    private static final MOTableSubIndex[] snmp4jAgentHBCtrlEntryIndexes = new MOTableSubIndex[]{moFactory.createSubIndex(null, 4, 1, 32)};
    private static final MOTableIndex snmp4jAgentHBCtrlEntryIndex = moFactory.createIndex(snmp4jAgentHBCtrlEntryIndexes, true);
    private MOTable snmp4jAgentHBCtrlEntry;
    private MOMutableTableModel snmp4jAgentHBCtrlEntryModel;
    private static final int[] PROTECTED_COLS = new int[]{0, 1, 2};
    private CommonTimer heartbeatTimer = SNMP4JSettings.getTimerFactory().createTimer();
    private int heartbeatOffset = 0;
    private NotificationOriginator notificationOriginator;
    private OctetString context;
    private SysUpTime sysUpTime;

    private Snmp4jHeartbeatMib() {
        this.snmp4jAgentHBRefTime = new Snmp4jAgentHBRefTime(oidSnmp4jAgentHBRefTime, MOAccessImpl.ACCESS_READ_WRITE);
        this.snmp4jAgentHBRefTime.addMOValueValidationListener(new Snmp4jAgentHBRefTimeValidator());
        this.createSnmp4jAgentHBCtrlEntry();
        ((RowStatus)this.snmp4jAgentHBCtrlEntry.getColumn(7)).addRowStatusListener(this);
        this.snmp4jAgentHBCtrlEntry.addMOTableRowListener(this);
    }

    public Snmp4jHeartbeatMib(NotificationOriginator notificationOriginator, OctetString context, SysUpTime upTime) {
        this();
        this.notificationOriginator = notificationOriginator;
        this.context = context;
        this.sysUpTime = upTime;
        for (int i = 0; i < PROTECTED_COLS.length; ++i) {
            ((MOMutableColumn)this.snmp4jAgentHBCtrlEntry.getColumn(i)).setMutableInService(false);
        }
    }

    public MOTable getSnmp4jAgentHBCtrlEntry() {
        return this.snmp4jAgentHBCtrlEntry;
    }

    private void createSnmp4jAgentHBCtrlEntry() {
        MOColumn[] snmp4jAgentHBCtrlEntryColumns = new MOColumn[8];
        snmp4jAgentHBCtrlEntryColumns[0] = new DateAndTime(2, MOAccessImpl.ACCESS_READ_CREATE, null);
        ConstraintsImpl snmp4jAgentHBCtrlStartTimeVC = new ConstraintsImpl();
        snmp4jAgentHBCtrlStartTimeVC.add(new Constraint(8L, 8L));
        snmp4jAgentHBCtrlStartTimeVC.add(new Constraint(11L, 11L));
        ((MOMutableColumn)snmp4jAgentHBCtrlEntryColumns[0]).addMOValueValidationListener(new ValueConstraintValidator(snmp4jAgentHBCtrlStartTimeVC));
        ((MOMutableColumn)snmp4jAgentHBCtrlEntryColumns[0]).setMandatory(false);
        ((MOMutableColumn)snmp4jAgentHBCtrlEntryColumns[0]).addMOValueValidationListener(new Snmp4jAgentHBCtrlStartTimeValidator());
        snmp4jAgentHBCtrlEntryColumns[1] = new MOMutableColumn(3, 66, MOAccessImpl.ACCESS_READ_CREATE, new UnsignedInteger32(1000));
        snmp4jAgentHBCtrlEntryColumns[2] = new MOMutableColumn(4, 66, MOAccessImpl.ACCESS_READ_CREATE, new UnsignedInteger32(60000));
        snmp4jAgentHBCtrlEntryColumns[3] = new MOMutableColumn(5, 66, MOAccessImpl.ACCESS_READ_CREATE, new UnsignedInteger32(0));
        snmp4jAgentHBCtrlEntryColumns[4] = moFactory.createColumn(6, 70, MOAccessImpl.ACCESS_READ_ONLY);
        snmp4jAgentHBCtrlEntryColumns[5] = moFactory.createColumn(7, 67, MOAccessImpl.ACCESS_READ_ONLY);
        snmp4jAgentHBCtrlEntryColumns[4] = moFactory.createColumn(6, 70, MOAccessImpl.ACCESS_READ_ONLY);
        snmp4jAgentHBCtrlEntryColumns[6] = new StorageType(8, MOAccessImpl.ACCESS_READ_CREATE, new Integer32(3));
        EnumerationConstraint snmp4jAgentHBCtrlStorageTypeVC = new EnumerationConstraint(new int[]{1, 2, 3, 4, 5});
        ((MOMutableColumn)snmp4jAgentHBCtrlEntryColumns[6]).addMOValueValidationListener(new ValueConstraintValidator(snmp4jAgentHBCtrlStorageTypeVC));
        snmp4jAgentHBCtrlEntryColumns[7] = new RowStatus(9);
        EnumerationConstraint snmp4jAgentHBCtrlRowStatusVC = new EnumerationConstraint(new int[]{1, 2, 3, 4, 5, 6});
        ((MOMutableColumn)snmp4jAgentHBCtrlEntryColumns[7]).addMOValueValidationListener(new ValueConstraintValidator(snmp4jAgentHBCtrlRowStatusVC));
        this.snmp4jAgentHBCtrlEntryModel = new DefaultMOMutableTableModel();
        this.snmp4jAgentHBCtrlEntryModel.setRowFactory(new Snmp4jAgentHBCtrlEntryRowFactory());
        this.snmp4jAgentHBCtrlEntry = moFactory.createTable(oidSnmp4jAgentHBCtrlEntry, snmp4jAgentHBCtrlEntryIndex, snmp4jAgentHBCtrlEntryColumns, this.snmp4jAgentHBCtrlEntryModel);
    }

    @Override
    public void registerMOs(MOServer server, OctetString context) throws DuplicateRegistrationException {
        server.register(this.snmp4jAgentHBRefTime, context);
        server.register(this.snmp4jAgentHBCtrlEntry, context);
    }

    @Override
    public void unregisterMOs(MOServer server, OctetString context) {
        server.unregister(this.snmp4jAgentHBRefTime, context);
        server.unregister(this.snmp4jAgentHBCtrlEntry, context);
    }

    public void snmp4jAgentHBEvent(NotificationOriginator notificationOriginator, OctetString context, VariableBinding[] vbs) {
        if (vbs.length < 1) {
            throw new IllegalArgumentException("Too few notification objects: " + vbs.length + "<1");
        }
        if (!vbs[0].getOid().startsWith(oidTrapVarSnmp4jAgentHBCtrlEvents)) {
            throw new IllegalArgumentException("Variable 0 has wrong OID: " + vbs[0].getOid() + " does not start with " + oidTrapVarSnmp4jAgentHBCtrlEvents);
        }
        if (!snmp4jAgentHBCtrlEntryIndex.isValidIndex(this.snmp4jAgentHBCtrlEntry.getIndexPart(vbs[0].getOid()))) {
            throw new IllegalArgumentException("Illegal index for variable 0 specified: " + this.snmp4jAgentHBCtrlEntry.getIndexPart(vbs[0].getOid()));
        }
        notificationOriginator.notify(context, oidSnmp4jAgentHBEvent, vbs);
    }

    @Override
    public void rowStatusChanged(RowStatusEvent event) {
        Snmp4jAgentHBCtrlEntryRow row;
        HeartbeatTask task;
        if (event.isDeniable()) {
            Snmp4jAgentHBCtrlEntryRow row2;
            if (event.isRowActivated() && (row2 = (Snmp4jAgentHBCtrlEntryRow)event.getRow()).getSnmp4jAgentHBCtrlDelay().getValue() == 0L && (row2.getSnmp4jAgentHBCtrlStartTime() == null || DateAndTime.makeCalendar(row2.getSnmp4jAgentHBCtrlStartTime()).getTimeInMillis() <= System.currentTimeMillis())) {
                event.setDenyReason(12);
            }
        } else if (event.isRowActivated()) {
            Snmp4jAgentHBCtrlEntryRow row3 = (Snmp4jAgentHBCtrlEntryRow)event.getRow();
            HeartbeatTask task2 = new HeartbeatTask(row3);
            if (row3.getSnmp4jAgentHBCtrlDelay().getValue() == 0L) {
                long startTime = DateAndTime.makeCalendar(row3.getSnmp4jAgentHBCtrlStartTime()).getTimeInMillis() - (long)this.heartbeatOffset;
                this.heartbeatTimer.schedule((TimerTask)task2, new Date(startTime), row3.getSnmp4jAgentHBCtrlPeriod().getValue());
            } else {
                this.heartbeatTimer.schedule((TimerTask)task2, row3.getSnmp4jAgentHBCtrlDelay().getValue(), row3.getSnmp4jAgentHBCtrlPeriod().getValue());
            }
            row3.setUserObject(task2);
        } else if (event.isRowDeactivated() && (task = (HeartbeatTask)(row = (Snmp4jAgentHBCtrlEntryRow)event.getRow()).getUserObject()) != null) {
            task.cancel();
        }
    }

    @Override
    public void rowChanged(MOTableRowEvent event) {
        Snmp4jAgentHBCtrlEntryRow row;
        if (event.getRow() != null && (row = (Snmp4jAgentHBCtrlEntryRow)event.getRow()).getSnmp4jAgentHBCtrlLastChange() != null) {
            row.getSnmp4jAgentHBCtrlLastChange().setValue(this.sysUpTime.get().getValue());
        }
    }

    class HeartbeatTask
    extends TimerTask {
        private Snmp4jAgentHBCtrlEntryRow configRow;

        public HeartbeatTask(Snmp4jAgentHBCtrlEntryRow configRow) {
            this.configRow = configRow;
        }

        @Override
        public void run() {
            if (this.configRow.getSnmp4jAgentHBCtrlRowStatus().getValue() == 1) {
                long maxEvents = this.configRow.getSnmp4jAgentHBCtrlMaxEvents().getValue();
                if (maxEvents > 0L && this.configRow.getSnmp4jAgentHBCtrlEvents().getValue() < maxEvents) {
                    this.configRow.getSnmp4jAgentHBCtrlEvents().increment();
                    OID instanceOID = ((DefaultMOTable)Snmp4jHeartbeatMib.this.snmp4jAgentHBCtrlEntry).getCellOID(this.configRow.getIndex(), 4);
                    VariableBinding eventVB = new VariableBinding(instanceOID, this.configRow.getSnmp4jAgentHBCtrlEvents());
                    Snmp4jHeartbeatMib.this.snmp4jAgentHBEvent(Snmp4jHeartbeatMib.this.notificationOriginator, Snmp4jHeartbeatMib.this.context, new VariableBinding[]{eventVB});
                } else {
                    this.cancel();
                    this.configRow.getSnmp4jAgentHBCtrlRowStatus().setValue(2);
                }
            } else {
                this.cancel();
            }
        }
    }

    class Snmp4jAgentHBCtrlEntryRowFactory
    extends DefaultMOMutableRow2PCFactory<Snmp4jAgentHBCtrlEntryRow> {
        Snmp4jAgentHBCtrlEntryRowFactory() {
        }

        @Override
        public synchronized Snmp4jAgentHBCtrlEntryRow createRow(OID index, Variable[] values) throws UnsupportedOperationException {
            Snmp4jAgentHBCtrlEntryRow row = new Snmp4jAgentHBCtrlEntryRow(index, values);
            row.setSnmp4jAgentHBCtrlLastChange(Snmp4jHeartbeatMib.this.sysUpTime.get());
            row.setSnmp4jAgentHBCtrlEvents(new Counter64(0L));
            return row;
        }

        @Override
        public synchronized void freeRow(Snmp4jAgentHBCtrlEntryRow row) {
        }
    }

    public class Snmp4jAgentHBCtrlEntryRow
    extends DefaultMOMutableRow2PC {
        public Snmp4jAgentHBCtrlEntryRow(OID index, Variable[] values) {
            super(index, values);
        }

        public OctetString getSnmp4jAgentHBCtrlStartTime() {
            return (OctetString)this.getValue(0);
        }

        public void setSnmp4jAgentHBCtrlStartTime(OctetString newValue) {
            this.setValue(0, newValue);
        }

        public UnsignedInteger32 getSnmp4jAgentHBCtrlDelay() {
            return (UnsignedInteger32)this.getValue(1);
        }

        public void setSnmp4jAgentHBCtrlDelay(UnsignedInteger32 newValue) {
            this.setValue(1, newValue);
        }

        public UnsignedInteger32 getSnmp4jAgentHBCtrlPeriod() {
            return (UnsignedInteger32)this.getValue(2);
        }

        public void setSnmp4jAgentHBCtrlPeriod(UnsignedInteger32 newValue) {
            this.setValue(2, newValue);
        }

        public UnsignedInteger32 getSnmp4jAgentHBCtrlMaxEvents() {
            return (UnsignedInteger32)this.getValue(3);
        }

        public void setSnmp4jAgentHBCtrlMaxEvents(UnsignedInteger32 newValue) {
            this.setValue(3, newValue);
        }

        public Counter64 getSnmp4jAgentHBCtrlEvents() {
            return (Counter64)this.getValue(4);
        }

        public void setSnmp4jAgentHBCtrlEvents(Counter64 newValue) {
            this.setValue(4, newValue);
        }

        public TimeTicks getSnmp4jAgentHBCtrlLastChange() {
            return (TimeTicks)this.getValue(5);
        }

        public void setSnmp4jAgentHBCtrlLastChange(TimeTicks newValue) {
            this.setValue(5, newValue);
        }

        public Integer32 getSnmp4jAgentHBCtrlStorageType() {
            return (Integer32)this.getValue(6);
        }

        public void setSnmp4jAgentHBCtrlStorageType(Integer32 newValue) {
            this.setValue(6, newValue);
        }

        public Integer32 getSnmp4jAgentHBCtrlRowStatus() {
            return (Integer32)this.getValue(7);
        }

        public void setSnmp4jAgentHBCtrlRowStatus(Integer32 newValue) {
            this.setValue(7, newValue);
        }
    }

    static class Snmp4jAgentHBCtrlStartTimeValidator
    implements MOValueValidationListener {
        Snmp4jAgentHBCtrlStartTimeValidator() {
        }

        @Override
        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
            OctetString os = (OctetString)newValue;
            if (!(os.length() >= 8 && os.length() <= 8 || os.length() >= 11 && os.length() <= 11)) {
                validationEvent.setValidationStatus(8);
                return;
            }
        }
    }

    static class Snmp4jAgentHBRefTimeValidator
    implements MOValueValidationListener {
        Snmp4jAgentHBRefTimeValidator() {
        }

        @Override
        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
            OctetString os = (OctetString)newValue;
            if (!(os.length() >= 8 && os.length() <= 8 || os.length() >= 11 && os.length() <= 11)) {
                validationEvent.setValidationStatus(8);
                return;
            }
        }
    }

    public class Snmp4jAgentHBRefTime
    extends DateAndTimeScalar<OctetString> {
        Snmp4jAgentHBRefTime(OID oid, MOAccess access) {
            super(oid, access, new OctetString());
        }

        @Override
        public int isValueOK(SubRequest request) {
            Variable newValue = request.getVariableBinding().getVariable();
            int valueOK = super.isValueOK(request);
            if (valueOK != 0) {
                return valueOK;
            }
            OctetString os = (OctetString)newValue;
            if (!(os.length() >= 8 && os.length() <= 8 || os.length() >= 11 && os.length() <= 11)) {
                valueOK = 8;
            }
            return valueOK;
        }

        @Override
        public OctetString getValue() {
            GregorianCalendar gc = new GregorianCalendar();
            gc.add(14, Snmp4jHeartbeatMib.this.heartbeatOffset);
            super.setValue(DateAndTime.makeDateAndTime(gc));
            return super.getValue();
        }

        @Override
        public int setValue(OctetString newValue) {
            GregorianCalendar gc = DateAndTime.makeCalendar(newValue);
            GregorianCalendar curGC = new GregorianCalendar();
            Snmp4jHeartbeatMib.this.heartbeatOffset = (int)(gc.getTimeInMillis() - curGC.getTimeInMillis());
            return super.setValue(newValue);
        }

        @Override
        public void load(MOInput input) throws IOException {
            Snmp4jHeartbeatMib.this.heartbeatOffset = ((Integer32)input.readVariable()).getValue();
        }

        @Override
        public void save(MOOutput output) throws IOException {
            output.writeVariable(new Integer32(Snmp4jHeartbeatMib.this.heartbeatOffset));
        }
    }

    public static final class Snmp4jAgentHBCtrlRowStatusEnum {
        public static final int active = 1;
        public static final int notInService = 2;
        public static final int notReady = 3;
        public static final int createAndGo = 4;
        public static final int createAndWait = 5;
        public static final int destroy = 6;
    }

    public static final class Snmp4jAgentHBCtrlStorageTypeEnum {
        public static final int other = 1;
        public static final int _volatile = 2;
        public static final int nonVolatile = 3;
        public static final int permanent = 4;
        public static final int readOnly = 5;
    }
}

