@ECHO OFF
REM Startup script for Verax SNMP Agent Simulator (for Windows).
REM Copyright (c) Verax Systems.  All Rights Reserved.

REM Path to the configuration file. 
REM Make sure the configuration file has been copied to this location.
set CONF=%SYSTEMROOT%\etc\verax.d\simulator.conf

set VS_SIMULATOR_HOME=
set VS_SERVER_PORT=
set VS_PRIMARY_INTERFACE=
set VS_SIMULATOR_CONFIG_FILE=
set VS_JRE_HOME=
set VS_JDK_HOME=
set VS_CREATE_INTERFACES=
set VS_WEB_CLIENT_CONTEXT=/SnmpAgentSimulator

set SIMULATOR_JAR=snmp-simulator-server.jar
set SIMULATOR_RMI_CLIENT_JAR=snmp-simulator-rmi-client.jar
set SIMULATOR_WEB_CLIENT_JAR=SnmpAgentSimulator-jetty-console.war


for /f "usebackq eol=# tokens=1,2 delims==" %%a in (%CONF%) do (
	set VS_%%a=%%~b
)

IF NOT "%1"=="" ( GOTO LAB_%1 )
GOTO LAB_MENU


:LAB_START
	CD /d %VS_SIMULATOR_HOME%
	if NOT EXIST conf MKDIR conf
	ECHO Verax SNMP Agent Simulator. Copyright (c) Verax Systems. All rights reserved.
	
	@START /MIN %VS_JRE_HOME%JAVA -jar jar\%SIMULATOR_JAR%

	ECHO Simulator started successfully.
	
	CD /d %~dp0
    GOTO END

:LAB_STOP

	set PORT=43500
    if not "%VS_SERVER_PORT%"=="" set PORT=%VS_SERVER_PORT%

	CD /d %VS_SIMULATOR_HOME%
	%VS_JRE_HOME%JAVA -jar jar\%SIMULATOR_RMI_CLIENT_JAR% -c END -p %PORT%
	
    GOTO END

:LAB_CONSOLE
	set PORT=43500
    if not "%VS_SERVER_PORT%"=="" set PORT=%VS_SERVER_PORT%
	
	CD /d %VS_SIMULATOR_HOME%
	echo CLI Console is starting...
	%VS_JRE_HOME%JAVA -jar jar\%SIMULATOR_RMI_CLIENT_JAR% -p %PORT%

	CD /d %~dp0
    GOTO END

:LAB_STATUS

	set PORT=43500
    if not "%VS_SERVER_PORT%"=="" set PORT=%VS_SERVER_PORT%	
	
    %VS_JRE_HOME%JAVA -jar jar\%SIMULATOR_RMI_CLIENT_JAR% -s -p %PORT%
	
    GOTO END
	
:LAB_SITE_RUN

	set WEB_PORT=8080
    if not "%VS_WEBCONSOLE_PORT%"=="" set WEB_PORT=%VS_WEBCONSOLE_PORT%
	
	ECHO Web Console is starting... This may take a while.	
	START CMD /k %VS_JDK_HOME%JAVA -jar jar\%SIMULATOR_WEB_CLIENT_JAR% --headless --contextPath %VS_WEB_CLIENT_CONTEXT% --port %WEB_PORT%
	
    GOTO END
	
:LAB_SITE_SHOW

	set WEB_PORT=8080
    if not "%VS_WEBCONSOLE_PORT%"=="" set WEB_PORT=%VS_WEBCONSOLE_PORT%
	
	START http://localhost:%WEB_PORT%/SnmpAgentSimulator/
	
    GOTO END

:LAB_MENU

	echo What do you want to do?
	echo 1 Start Agent Simulator
	echo 2 Stop Agent Simulator
	echo 3 Start Web Console
	echo 4 Open Web Console page
	echo 5 Open CLI Console
	echo 6 Show Agent Simulator status
	echo 7 Quit

	set /P C=[1,2,3,4,5,6,7]?
	if "%C%"=="7" goto END_NOW
	if "%C%"=="6" goto LAB_STATUS
	if "%C%"=="5" goto LAB_CONSOLE
	if "%C%"=="4" goto LAB_SITE_SHOW
	if "%C%"=="3" goto LAB_SITE_RUN
	if "%C%"=="2" goto LAB_STOP
	if "%C%"=="1" goto LAB_START
	
	ECHO Incorrect choice. Try again.
	GOTO LAB_MENU


:END
    ECHO ---
	goto LAB_MENU	
:END_NOW