unit CadTypes;
{$H+}
interface

 const

 lay_TOP=1;
 lay_BOTTOM =2;
 lay_ALL=3;
 lay_SILKSCREEN_TOP =4;
 lay_SILKSCREEN_BOTTOM =5;
 lay_SOLDERMASK_TOP =6;
 lay_SOLDERMASK_BOTTOM =7;
 lay_SOLDERPASTE_TOP =8;
 lay_SOLDERPASTE_BOTTOM =9;
 lay_INNER = 10;
 lay_GROUND=100;
 lay_POWER =200;


     g_line= 1001; // X1, Y1, X2,Y2,
     g_arc = 1002; //X1, Y1, X2,Y2, Xc, Xc
     g_cir = 1003; //Xc, Xc, R
     g_Rect= 1004;//X1, X1, X2,X2


 type////////// subtypes

     Geotype = Record
                    soort :integer;
                    params : array[1..6] of integer;
               End;

     Geoarray = array of Geotype;

Attributestype = Array Of String;

     Cutouttype = Record
                         co_name: string;
                         coGeos : Geoarray;
                         coAttributes :Attributestype;
                     End;

     Masktype = Record
                         MskName : string;
                         MskLayer: integer;
                         MskGeos :Geoarray;
                         MskAttributes :Attributestype;
                     End;




HEADERtype =Record
                     //     Gencad: Integer;//Version X1000
                User :String;
                Drawing :String;
                Revision :String;
                Cadid: string;
                Units : String;
                Origin_X:Integer; Origin_Y:Integer;
                Intertrack : Integer;
                Attributes :Attributestype;
             End;

     Trackdef =Record
                   Name:String;
                   Width:Integer;
               End;

 TRACKStype =      Array Of Trackdef;

 LAYERstype =      Record
                    End;//Optional
                    
 BOARDtype     = Record
                    Thickness :integer;
                    Geos : Geoarray;
                    Attributes :Attributestype;
                    Cutouts: array of Cutouttype;
                    Masks: array of Masktype;
                 End;


 TextType =RECORD
                    x,y          :integer;
                    size          :integer;
                    rotation     :integer;
                    mirror     :integer;
                    layer          :integer;
                    text           : string;
                    xrect, yrect:integer;
            END;

      Artworktype = RECORD
                         Name : string;
                         Layer: integer;
                         FILLED:boolean;
                         TrackIndex:integer;
                         Geos :Geoarray;
                         Attributes :Attributestype;
                         Text: TextType;
                    END;


 ARTWORKStype= array of artworktype;

const
 p_FINGER           =1;// a solid rectangular pad with semicircular ends (obround).
 p_ROUND            =2;// a solid circle.
 p_ANNULAR          =3;// any shape ring of copper (width unspecified).
 p_BULLET           =4;// a solid rectangular pad with one semicircular end.
 p_RECTANGULAR      =5;//a solid rectangle or square.
 p_HEXAGON          =6;// a solid hexagonal pad with equal length sides.
 p_OCTAGON          =7;// a solid octagonal pad with equal length sides.
 p_POLYGON          =8;// a solid polygon defined with LINES and ARCS.
 p_UNKNOWN          =9;//

 mirr0 = 0;
 mirrx = 1;
 mirry=2;
 noflip=0;
 flip =1;

 type

            PADtype=record
                         pad_name : string;
                         pad_type: integer;
                         drill_size:integer;
                         Geos :Geoarray;
                         Attributes :Attributestype;
                    end;


 PADStype = array of PADtype;

            padspostype=record
                              //pad_index:integer;
                              pad_name:string;
                              layer:integer;
                              rot : integer;
                              mirror :integer;
                        end;
       padsposarray = array of padspostype;

      PADstacktype =record
                         padstack_name: string;
                         drill_size: integer;
                         pos:padsposarray;
                    end;

PADSTACKStype = array of PADstacktype;

          pintype = record
                         name:string;
                         padstack_name:string;
                        // padstack_index:integer;
                         x, y:integer;
                         layer:integer;
                         rot : integer;
                         mirror:integer;
                    end;

         pinarraytype = array of pintype;

     ARTPOStype = record
                         artwork_name:string;
                         artwork_index:integer;
                         x,y:integer;
                         rot, mirror:integer; 
                    end; 



     SHAPEtype =record
                    shape_name:string;
                    Attributes :Attributestype; 
                    geos:Geoarray; 
                    //fiducial_x,fiducial_y:integer; not reccommended
                    insert:string;
                    Height:integer;
                    fid:pinarraytype;
                    pins:pinarraytype;
                    arts: array of ARTPOStype;
                end;

SHAPEStype = ARRAY OF SHAPEtype;



          pininfotype = record
                            pin_name:string;
                            pindesc:string;
                            pinfunct:string;
                        end;

     DEVICEtype=     record
                         device :string;
                         part_name:string;
                         comptype:string;
                         value:string;
                         style:string;
                         ntol:string;
                         ptol:string;
                         volts:string;
                         desc:string;
                         package:string;
                         pincount:integer;
                         pininfo: array of pininfotype;
                         Attributes :Attributestype;
                     end;

DEVICEStype=ARRAY OF DEVICEtype;

     COMPONENTtype =record
                         component_refdes:string;
                         part_name:string;
                         part_index:integer;
                         PLACE_x, PLACE_y:integer;
                         LAYER :integer;
                         ROTATION :integer;
                         shape_name:string;
                         shape_index:integer;
                         shape_mirror:integer;
                         shape_flip:integer;
                         arts: array of ARTPOStype;
                         fid:  array of pintype; 
                         Text: TextType; 
                         sheet :string;
                         Attributes :Attributestype;
                    end;

 COMPONENTStype =ARRAY OF COMPONENTtype;

        nodetype = record
                    component_refdes:string;
                    pin_name:string;
                   end;

 SIGNALtype= record
                  sig_name:string;
                  nodes:array of nodetype
               end;

 SIGNALStype =ARRAY OF SIGNALtype;

               rout=record
                        track_name :string; //  track_index:integer;
                        track_width:integer;
                        layer: integer;
                        Geos :Geoarray;
                    end;

               via =record
                     //VIA <pad_name> <x_y_ref> <layer> <drill_size> <via_name>
                       pad_name:string;
                       x,y, layer, drill_size: integer;
                       via_name:string;
                    end;

     routnettype = record
                         sig_name: string; //sig_index:integer;
                         routs: array of rout;
                         vias :array of via;
                    end;


 ROUTESNETStype =ARRAY OF routnettype;


    TESTPINtype =record

                 end;

 TESTPINStype =ARRAY OF TESTPINtype;


 POWERPINtype= record
 
               end;

 POWERPINStype=ARRAY OF POWERPINtype ;

 MECHtype    = record

               end;

 MECHStype =ARRAY OF MECHtype;

     GencadType = record
                         HEADER: HEADERtype;
                         TRACKS: TRACKStype;
                         LAYERS: LAYERStype;
                         BOARD: BOARDtype;
                         ARTWORKS: ARTWORKStype;
                         PADS: PADStype;
                         PADSTACKS: PADSTACKStype;
                         SHAPES: SHAPEStype;
                         DEVICES: DEVICEStype;
                         COMPONENTS: COMPONENTStype;
                         SIGNALS: SIGNALStype;
                         ROUTESNETS: ROUTESNETStype;
                         TESTPINS: TESTPINStype;
                         POWERPINS: POWERPINStype;
                         MECH: MECHtype;
                    end;





implementation

end.
