unit Fpcb2Cad;
{$H+}
interface
uses
  SysUtils,
  FpcbIO,
  FpcbTypes,
  CadTypes,gencad_IO,TextStr ;

var  gencad: GencadType;

procedure _Fpcb2cad( fpcb_filename,TinyCad_filename, gencad_filename:string);

implementation


function addgeos(geo1, geo2:geoarray):geoarray;
var n, L1,L2:integer;
begin
  L1:=length(geo1);
  L2:=length(geo2);
  setlength(geo1, L1+L2);
  for n:=0 to L2-1 do
   geo1[n+L1]:=geo2[n];
  result:=geo1;
end;


procedure findcentre( style:integer; dx,dy:integer; var xc, yc:integer );
begin
 // writeln(sqr(dx-xc),' ',)
   xc:=0;
   yc:=0;
   if  style>0  //arc
   then
        BEGIN
           if style=1 //cw
           then
             begin
               if dx>0
               then begin
                      if dy>0
                      then begin   //kw 1
                              xc:=dx;
                              yc:=0;
                           end
                      else begin   //kw 4
                              xc:=0;
                              yc:=dy;
                           end
                    end
               else begin    // dx<0
                      if dy>0
                      then begin   //kw 2
                              xc:=0;
                              yc:=dy;
                           end
                      else begin   //kw 3
                              xc:=dx;
                              yc:=0;
                           end
                    end
             end //cw
           else  //style =2
             begin //ccw
               if dx>0
               then begin
                      if dy>0
                      then begin   //kw 1
                             xc:=0;
                             yc:=dy;
                           end
                      else begin   //kw 4
                              xc:=dx;
                              yc:=0;
                           end
                    end
               else begin    // dx<0
                      if dy>0
                      then begin   //kw 2
                             xc:=dx;
                             yc:=0;
                           end
                      else begin   //kw 3
                              xc:=0;
                              yc:=dy;
                            end
                    end
             end; //ccw
    END;
end;


procedure checkarc(var g:Geotype);
var x1,y1, x2,y2:integer;
    xr1,yr1, xr2,yr2:real;
    xp, yp:integer;
    ok:integer;
begin
 if g.soort=g_arc
 then
  begin
   x1:=g.params[1]-g.params[5];
   y1:=g.params[2]-g.params[6];
   x2:=g.params[3]-g.params[5];
   y2:=g.params[4]-g.params[6];

   xr1:=x1;
   yr1:=y1;
   xr2:=x2;
   yr2:=y2;

   //writeln( sqr(xr1)+sqr(yr1), ' ',sqr(xr2)+sqr(yr2) );
   if sqr(xr1)+sqr(yr1) <> sqr(xr2)+sqr(yr2)
   then begin
         g.soort:=g_Line; //  centre position  nok => line
         g.params[5]:=0;
         g.params[6]:=0;
        end
   else
    BEGIN       //check if ccw arc
     ok:=0;
     if ( ok=0) and (y1>=0) and (y2>=0)
     then begin
            if (x1>x2)
            then ok:= 1
            else ok:= -1
          end;
     if ( ok=0) and  (x1<=0) and (x2<=0)
     then begin
             if (y2<y1)
             then ok:=1
             else ok:=-1
          end;
     if ( ok=0) and  (y1<=0) and (y2<=0)
     then begin
             if (x1<x2)
             then ok:=1
             else ok:=-1
          end;
     if ( ok=0) and  (x1>=0) and (x2>=0)
     then begin
             if (y1<y2)
             then ok:=1
             else ok:=-1
          end;
     if ok=-1
     then begin //swap parameters => make ccw arc
            xp:= g.params[1];
            yp:= g.params[2];
            g.params[1]:=g.params[3];
            g.params[2]:=g.params[4];
            g.params[3]:= xp;
            g.params[4]:= yp;
          end;
    END;
 end;
end;




PROCEDURE corners2geo( corners : cornerstype; var geo:geoarray );
var n: integer;
    x0, y0, x1, y1, dx, dy,  xc,yc, style :integer;
    xstart, ystart:integer;

begin
 if length( corners)>0
 then
  begin
    setlength(geo, length( corners));
    x0:=corners[0].x;
    y0:=corners[0].y;
    xstart:=x0; ystart:=y0;
    for n:=0 to length( corners)-1 do
     begin
       if n<length( corners)-1
       then
        begin
          x1:= corners[n+1].x;
          y1:= corners[n+1].y;
        end
       else  // n=length( corners)
        begin
          x1:= xstart;
          y1:= ystart;   // weer terug naar start
        end;
       geo[n].params[1]:=x0;
       geo[n].params[2]:=y0;
       geo[n].params[3]:=x1;
       geo[n].params[4]:=y1;
       geo[n].params[5]:=0;
       geo[n].params[6]:=0;

       style:= corners[n].last_side_style;
       //writeln('style ',style);
       if style>0
        then
         begin
          geo[n].soort:=g_arc;
          dx:= x1-x0;
          dy:= y1-y0;
          findcentre( style, dx,dy,xc, yc );
          geo[n].params[5]:=x0+xc;
          geo[n].params[6]:=y0+yc;
          checkarc(geo[n]);
         end
        else begin
               geo[n].soort:=g_line;
               geo[n].params[5]:=0;
               geo[n].params[6]:=0;

             end;
       x0:= x1; y0:=y1;   // store old value
     end; //for with corners[n]
 end;
end;

PROCEDURE split_corners2geo( corners : cornerstype; var geo:geoarray );
var corns: cornerstype;
    n,m :integer;
    ge:geoarray;

begin
 setlength(geo,0);
 if length( corners)>0
 then
  BEGIN
    m:=0;                              // split corners
    for n:=0 to length( corners)-1 do
    begin
      setlength( corns,m+1);
      corns[m]:=corners[n];
      if corners[n].end_cont=1
      then
       begin
           corners2geo( corns,  ge );
           geo:=addgeos(geo, ge);
           m:=-1;
       end;
      inc(m);
    end;
  END;
end;

procedure fpcPAD2geos( fp:FPpadtype ; VAR geo:geoarray; VAR padstr:string; VAR cpadtype:integer);
var  x1,y1, e,v,r:integer;
begin
  padstr:='';
  cpadtype:=0;
  setlength(geo, 0);
  if (fp.shape=PAD_OVAL) and (fp.left+fp.right= fp.width )
  then fp.shape:= PAD_ROUND;

  case fp.shape of

    PAD_NONE      : BEGIN
                     //setlength(geo, 0);
                    END;
    PAD_ROUND     : BEGIN
                     setlength(geo, 1);
                     geo[0].soort:=g_cir;
                     geo[0].params[1]:=0;          //Xc, Xc, R
                     geo[0].params[2]:=0;
                     geo[0].params[3]:=fp.width div 2;
                     geo[0].params[4]:=0;
                     padstr:='r'+stri(fp.width div 1000 );
                     cpadtype:=p_ROUND;
                    END;
    PAD_SQUARE     :BEGIN
                     y1:= -fp.width div 2;
                     x1:= y1;
                     setlength(geo, 1);
                     geo[0].soort:= g_Rect;        //x1, y1, xdim, ydim
                     geo[0].params[1]:=x1;
                     geo[0].params[2]:=y1;
                     geo[0].params[3]:=fp.width;
                     geo[0].params[4]:=fp.width;
                     padstr:='sqr'+stri(fp.width div 1000 );
                     cpadtype:=p_RECTANGULAR;
                    END;
         PAD_RECT : BEGIN
                     x1:= -fp.left;
                     y1:= -fp.width div 2;
                     setlength(geo, 1);
                     geo[0].soort:= g_Rect;        //x1, y1, xdim, ydim
                     geo[0].params[1]:=x1;
                     geo[0].params[2]:=y1;
                     geo[0].params[3]:=fp.left+fp.right;
                     geo[0].params[4]:=fp.width;
                     padstr:='rect'+stri(fp.width div 1000  )+'x'+
                                    stri((fp.left+fp.right) div 1000  )+'_'+
                                    stri(fp.left div 1000  ) ;
                     cpadtype:=p_RECTANGULAR;
                    END; //PAD_RECT
        PAD_RRECT  : BEGIN
                     e:= (fp.left+fp.right) div 2;
                     v:= fp.width div 2;
                     r:= fp.corner_rad;
                     setlength(geo, 8);

                     geo[0].soort:= g_line;      //X1, Y1, X2,Y2,
                     geo[0].params[1]:=-e+r;
                     geo[0].params[2]:=-v;
                     geo[0].params[3]:=e-r;
                     geo[0].params[4]:=-v;

                     geo[1].soort:= g_arc;     //  X1, Y1, X2,Y2, Xc, Xc
                     geo[1].params[1]:=e-r;
                     geo[1].params[2]:=-v;
                     geo[1].params[3]:=e;
                     geo[1].params[4]:=-v+r;
                     geo[1].params[5]:=e-r;
                     geo[1].params[6]:=-v+r;
                  //   checkarc(geo[1]);

                     geo[2].soort:= g_line;      //X1, Y1, X2,Y2,
                     geo[2].params[1]:=e;
                     geo[2].params[2]:=-v+r;
                     geo[2].params[3]:=e;
                     geo[2].params[4]:=v-r;

                     geo[3].soort:= g_arc;     //  X1, Y1, X2,Y2, Xc, Xc
                     geo[3].params[1]:=e;
                     geo[3].params[2]:=v-r;
                     geo[3].params[3]:=e-r;
                     geo[3].params[4]:=v;
                     geo[3].params[5]:=e-r;
                     geo[3].params[6]:=v-r;

                     geo[4].soort:= g_line;      //X1, Y1, X2,Y2,
                     geo[4].params[1]:=e-r;
                     geo[4].params[2]:=v;
                     geo[4].params[3]:=-e+r;
                     geo[4].params[4]:=v;

                     geo[5].soort:= g_arc;     //  X1, Y1, X2,Y2, Xc, Xc
                     geo[5].params[1]:=-e+r;
                     geo[5].params[2]:=v;
                     geo[5].params[3]:=-e;
                     geo[5].params[4]:=v-r;
                     geo[5].params[5]:=-e+r;
                     geo[5].params[6]:=v-r;

                     geo[6].soort:= g_line;      //X1, Y1, X2,Y2,
                     geo[6].params[1]:=-e;
                     geo[6].params[2]:=v-r;
                     geo[6].params[3]:=-e;
                     geo[6].params[4]:=-v+r;

                     geo[7].soort:= g_arc;     //  X1, Y1, X2,Y2, Xc, Xc
                     geo[7].params[1]:=-e;
                     geo[7].params[2]:=-v+r;
                     geo[7].params[3]:=-e+r;
                     geo[7].params[4]:=-v;
                     geo[7].params[5]:=-e+r;
                     geo[7].params[6]:=-v+r;

                     padstr:='rrect'+stri(fp.width div 1000  )+'x'+
                                    stri((fp.left+fp.right) div 1000  )+'_'+
                                    stri(fp.left div 1000  ) ;
                     cpadtype:=p_POLYGON;
                    END;//PAD_RRECT

        PAD_OVAL : BEGIN
                     e:= (fp.left+fp.right) div 2;
                     v:= fp.width div 2;
                     setlength(geo, 4);
                     IF v<e
                     THEN
                      BEGIN
                        geo[0].soort:= g_line;      //X1, Y1, X2,Y2,
                        geo[0].params[1]:=v-e;
                        geo[0].params[2]:=-v;
                        geo[0].params[3]:=e-v;
                        geo[0].params[4]:=-v;

                        geo[1].soort:= g_arc;     //  X1, Y1, X2,Y2, Xc, Xc
                        geo[1].params[1]:=e-v;
                        geo[1].params[2]:=-v;
                        geo[1].params[3]:=e-v;
                        geo[1].params[4]:=v;
                        geo[1].params[5]:=e-v;
                        geo[1].params[6]:=0;
                          //   checkarc(geo[1]);

                        geo[2].soort:= g_line;      //X1, Y1, X2,Y2,
                        geo[2].params[1]:=e-v;
                        geo[2].params[2]:=v;
                        geo[2].params[3]:=v-e;
                        geo[2].params[4]:=v;

                        geo[3].soort:= g_arc;     //  X1, Y1, X2,Y2, Xc, Xc
                        geo[3].params[1]:=v-e;
                        geo[3].params[2]:=v;
                        geo[3].params[3]:=v-e;
                        geo[3].params[4]:=-v;
                        geo[3].params[5]:=v-e;
                        geo[3].params[6]:=0;
                       END
                     ELSE
                      BEGIN
                        geo[0].soort:= g_line;      //X1, Y1, X2,Y2,
                        geo[0].params[1]:=e;
                        geo[0].params[2]:=e-v;
                        geo[0].params[3]:=e;
                        geo[0].params[4]:=v-e;

                        geo[1].soort:= g_arc;     //  X1, Y1, X2,Y2, Xc, Xc
                        geo[1].params[1]:=e;
                        geo[1].params[2]:=v-e;
                        geo[1].params[3]:=-e;
                        geo[1].params[4]:=v-e;
                        geo[1].params[5]:=0;
                        geo[1].params[6]:=v-e;

                        geo[2].soort:= g_line;      //X1, Y1, X2,Y2,
                        geo[2].params[1]:=-e;
                        geo[2].params[2]:=v-e;
                        geo[2].params[3]:=-e;
                        geo[2].params[4]:=e-v;

                        geo[3].soort:= g_arc;     //  X1, Y1, X2,Y2, Xc, Xc
                        geo[3].params[1]:=-e;
                        geo[3].params[2]:=e-v;
                        geo[3].params[3]:=e;
                        geo[3].params[4]:=e-v;
                        geo[3].params[5]:=0;
                        geo[3].params[6]:=e-v;
                       END;


                     padstr:='oval'+stri(fp.width div 1000  )+'x'+
                                    stri((fp.left+fp.right) div 1000  )+'_'+
                                    stri(fp.left div 1000  ) ;
                     cpadtype:=p_FINGER;
                   END; //PAD_OVAL

        PAD_OCT  : BEGIN
                     e:= fp.width div 2;
                     v:= e;
                     r:= round( e*(( sqrt(2)/ (1+sqrt(2)))));
                     setlength(geo, 8);

                     geo[0].soort:= g_line;      //X1, Y1, X2,Y2,
                     geo[0].params[1]:=-e+r;
                     geo[0].params[2]:=-v;
                     geo[0].params[3]:=e-r;
                     geo[0].params[4]:=-v;

                     geo[1].soort:= g_line;     //  X1, Y1, X2,Y2, Xc, Xc
                     geo[1].params[1]:=e-r;
                     geo[1].params[2]:=-v;
                     geo[1].params[3]:=e;
                     geo[1].params[4]:=-v+r;

                     geo[2].soort:= g_line;      //X1, Y1, X2,Y2,
                     geo[2].params[1]:=e;
                     geo[2].params[2]:=-v+r;
                     geo[2].params[3]:=e;
                     geo[2].params[4]:=v-r;

                     geo[3].soort:= g_line;     //  X1, Y1, X2,Y2, Xc, Xc
                     geo[3].params[1]:=e;
                     geo[3].params[2]:=v-r;
                     geo[3].params[3]:=e-r;
                     geo[3].params[4]:=v;

                     geo[4].soort:= g_line;      //X1, Y1, X2,Y2,
                     geo[4].params[1]:=e-r;
                     geo[4].params[2]:=v;
                     geo[4].params[3]:=-e+r;
                     geo[4].params[4]:=v;

                     geo[5].soort:= g_line;     //  X1, Y1, X2,Y2, Xc, Xc
                     geo[5].params[1]:=-e+r;
                     geo[5].params[2]:=v;
                     geo[5].params[3]:=-e;
                     geo[5].params[4]:=v-r;

                     geo[6].soort:= g_line;      //X1, Y1, X2,Y2,
                     geo[6].params[1]:=-e;
                     geo[6].params[2]:=v-r;
                     geo[6].params[3]:=-e;
                     geo[6].params[4]:=-v+r;

                     geo[7].soort:= g_line;     //  X1, Y1, X2,Y2, Xc, Xc
                     geo[7].params[1]:=-e;
                     geo[7].params[2]:=-v+r;
                     geo[7].params[3]:=-e+r;
                     geo[7].params[4]:=-v;


                     padstr:='oct'+stri(fp.width div 1000  )+'x'+
                                    stri((fp.left+fp.right) div 1000  )+'_'+
                                    stri(fp.left div 1000  ) ;
                     cpadtype:=p_OCTAGON ;
                    END; //PAD_OCT
   end; //case
end;

function strokes2goes(strokes:strokesarray):Geoarray;
var geo:Geoarray;
    n, dx,dy, xc,yc:integer;
begin
 setlength(geo, length(strokes));
 for n:=0 to length(strokes)-1 do
 with strokes[n]do
  begin
    //         0       1        2
    //     STRAIGHT, ARC_CW, ARC_CCW
    //  writeln(style);
    geo[n].params[1]:=x1;
    geo[n].params[2]:=y1;
    geo[n].params[3]:=x2;
    geo[n].params[4]:=y2;
    if style=0 // STRAIGHT
    then begin
           geo[n].soort:= g_line; // X1, X1, X2,X2
           geo[n].params[5]:=0;
           geo[n].params[6]:=0;
         end
    else begin   //ARC_CW, ARC_CCW
           geo[n].soort:= g_arc; // X1, X1, X2,X2 , xc, yc
           dx:= x2-x1;
           dy:= y2-y1;
           findcentre( style, dx,dy,xc, yc );
           geo[n].params[5]:=x1+xc;
           geo[n].params[6]:=y1+yc;
           checkarc(geo[n]);
         end
  end;
  result:=geo;
end;

procedure conv_HEADER(fpcb_filename:string) ;
BEGIN
  write('>converting header section...');
  with gencad.HEADER do
   begin
      User :='"Username"';
      Drawing :='FreePCB-Design->'+fpcb_filename;
      Revision :='"'+DateTimeToStr(FileDateToDateTime(FileAge(fpcb_filename)))+'"';
      getoption('project_name:', Cadid);
      Units:='THOU';
      Origin_X:=0;
      Origin_Y:=0;
      Intertrack :=0;
      setlength(Attributes,0)
   end;
   writeln(' done.')
END;

procedure conv_BOARD;
var n:integer;
    vs:string;
    geos:geoarray;

begin
 write('>converting boardsection...');
 getoption( 'board_outline_width:',vs);
 //Out_width:=vali(vs); //  writeln(Out_width);

// n:=0;
 setlength(gencad.BOARD.Geos,0);
 for n:=0 to length( boardoutlines)-1 do
 with  boardoutlines[n] do
 begin
     corners2geo( corners,geos );
     gencad.BOARD.Geos:= addgeos(gencad.BOARD.Geos, geos);
 end;
 writeln('done.')
               {   Thickness :integer;
                   Geos : Geoarray;
                   Attributes :Attributestype;
                   Cutouts: array of Cutouttype;
                   Masks: array of Masktype;}
end;


procedure addpad(ges: geoarray; padstr:string; cpadtype:integer);
var n, len:integer;
    found:boolean;
begin
 found:=false;
 len:=length(gencad.PADS);
 for n:= 0 to len-1 do
  if  gencad.PADS[n].pad_name=padstr
  then found:=true;
 if not found
 then begin
       setlength(gencad.PADS,len+1 );
       gencad.PADS[len].pad_type:=cpadtype;
       gencad.PADS[len].pad_name:=padstr;
       gencad.PADS[len].Geos:=ges;
      end;
end;

type strarray3= array[1..3] of string;

function samepadspos(pos1, pos2:padsposarray):boolean;
var n:integer;
    gelijk:boolean;
begin
   if length(pos1)=length(pos2)
   then begin
         gelijk:=true;
         for n:=0 to length(pos1)-1 do
          if NOT  (
             (pos1[n].pad_name= pos2[n].pad_name) AND
             (pos1[n].layer= pos2[n].layer) AND
             (pos1[n].rot= pos2[n].rot) AND
             (pos1[n].mirror= pos2[n].mirror) )
           then gelijk:=false;
        end
   else gelijk:=false;
   result:=gelijk
end;

procedure padstr2padpos(ncu_layers:integer;padstr3:strarray3; var posits:padsposarray);
var  nlays,m:integer;
begin
      nlays:=0;
      if padstr3[1]<>''
      then
         begin
             inc(nlays);
             setlength(posits,nlays);
             with posits[nlays-1] do
              begin
                pad_name:= padstr3[1];
                layer:=lay_TOP;
                rot:=0; mirror:=0;
              end
         end;
      if padstr3[3]<>''
      then
         begin
             inc(nlays);
             setlength(posits,nlays);
             with posits[nlays-1] do
              begin
                pad_name:= padstr3[3];
                layer:=lay_BOTTOM;
                rot:=0; mirror:=0;
              end
         end;
      if padstr3[2]<>''
      then
         begin
           for m:=1 to ncu_layers-2 do
            begin
             inc(nlays);
             setlength(posits,nlays);
             with posits[nlays-1] do
              begin
                pad_name:= padstr3[2];
                layer:=lay_INNER+m;
                rot:=0; mirror:=0;
              end
           end;
         end;
end;


procedure addpadstack(ncu_layers:integer; padstr3:strarray3;
                      hole_diam:integer; var padstacknaam:string );
var n, len:integer;
    found:boolean;
    posits:padsposarray;
begin
 padstr2padpos(ncu_layers,padstr3,posits);
 found:=false;
 len:=length(gencad.PADSTACKS);
 for n:= 0 to len-1 do
 with gencad.PADSTACKS[n] do
   if (drill_size=hole_diam) and samepadspos(pos,posits)
   then begin
         found:=true;
         padstacknaam:=padstack_name;
        end;
 if not found
 then
  begin
    //writeln('PADSTACKS len:', len);
    setlength(gencad.PADSTACKS,len+1 );
    with gencad.PADSTACKS[len] do
     begin
      padstack_name:='padstack'+stri(len);
      padstacknaam:=padstack_name;
     // writeln('padstack_name:', padstack_name);
      drill_size:=hole_diam;
      pos:=posits;
     end;
  end;
end;

function makepin(pin_id, padstacknaam:string; x, y, rot:integer):pintype;
var  pin:pintype;
begin
  pin.name:=pin_id;
  pin.padstack_name:= padstacknaam;
  pin.x:=x;
  pin.y:=y;
  pin.rot:=rot;
  pin.layer:=lay_TOP;
  pin.mirror:=mirr0;
  result:=pin;
end;



function makeshape(name:string;outline_stroke:strokesarray; pins_:pinarraytype ):SHAPEtype;
var shape:SHAPEtype;

begin
      shape.shape_name:=space2_(name);
      setlength( shape.Attributes,0);
      shape.geos:=strokes2goes(outline_stroke);
      shape.insert:='';
      shape.Height:=0;
      setlength( shape.fid,0);
      shape.pins:=pins_;
      setlength( shape.arts,0);
      result:=shape;
end;


procedure  conv_FOOTS;
var nf, ps, pa:integer;
    goes: geoarray;
    padstr3:strarray3;
    cpadtype:integer;
    s:string;
    ncu_layers:integer;
    padstacknaam:string;
    pins_:pinarraytype;
    //;
begin
   write('>converting footprints...');
   getoption( 'n_copper_layers:', s);
   ncu_layers:=vali(s);
  // writeln(ncu_layers);
  // readln;

   setlength( gencad.SHAPES,length(footprints));
   FOR nf:=0 TO  length(footprints)-1 DO
   with footprints[nf] do
   begin
     //writeln('footprint :',name);
     setlength(pins_,length( padstack ));
     for ps:=0 to length( padstack )-1 do
     with padstack[ps] do
      begin
      // writeln('pin id :',pin_id);
       padstr3[1]:='';padstr3[2]:='';padstr3[3]:='';
       for pa:=1 to 3 do       //top_pad, inner_pad, bottom_pad
       if pads[pa].shape in [PAD_ROUND..PAD_OCT]
       then
        begin
          // writeln('shape :',pads[pa].shape);
          // fp:FPpadtype ; VAR geo:geoarray; VAR padstr:string; VAR cpadtype:integer
           fpcPAD2geos(  pads[pa], goes,padstr3[pa], cpadtype);
           //addpad
           //writeln('>',padstr3[pa],'<',cpadtype );
           addpad(goes,padstr3[pa],cpadtype);
        end;
       addpadstack(ncu_layers,  padstr3,hole_diam, padstacknaam ); //padstack[ps]
       //writeln('padstacknaam :',padstacknaam,' x:',x,' y:',y, ' rot:',rot);
       pins_[ps]:=makepin(pin_id, padstacknaam, x, y, rot);
      end; //with padstack

      gencad.SHAPES[nf]:= makeshape(name,outline_stroke , pins_ );
   end;
   writeln(' done.')
end;




function devicename(refdes,pack,value, shape:string):string;
  var s :string;
begin
   if value=''
   then s:=refdes
   else s:=value;
   if pack=''
   then s:=s+'_'+shape
   else s:=s+'_'+pack;
   result:=s;
end;



PROCEDURE add_device(refdes,pack,value, shape:string);
var s :string;
    n,len:integer;
    found:boolean;
begin
// writeln(refdes,'*',pack,'*',value,'*', shape);

 s:=devicename(refdes,pack,value, shape);
 found:=false;
 len:=length(gencad.DEVICES);
 for n:=0 to len-1 do
   if s=gencad.DEVICES[n].device
   then found:=true;
 if not found
 then begin
       setlength(gencad.DEVICES, len+1);
       gencad.DEVICES[len].device:=s;
       gencad.DEVICES[len].part_name:=s;
       gencad.DEVICES[len].value :=value;
       gencad.DEVICES[len].package:=pack;
       gencad.DEVICES[len].comptype:=refdes[1];
       gencad.DEVICES[len].ntol:='';
       gencad.DEVICES[len].ptol:='';
       gencad.DEVICES[len].volts:='';
       gencad.DEVICES[len].style:='';
       gencad.DEVICES[len].desc:='';
       gencad.DEVICES[len].pincount:=0;
      end;
end;

PROCEDURE conv_DEVICES;
var np:integer;
begin
 write('>converting devices...');
  FOR np:=0 TO  length(parts)-1 DO
  with parts[np] do
  begin
     add_device(refdes,pack,value, shape);
  end;
  writeln('done.')
end;

PROCEDURE conv_PARTS;
var np:integer;
begin
 write('>converting parts...');
 setlength(gencad.COMPONENTS, length(parts)  );
 FOR np:=0 TO  length(parts)-1 DO
  with parts[np] do
  BEGIN
                (*  refdes,shape:string;
                   side:integer;
                   xpos1, ypos1    :real;  //positie eerste pin
                   rot_f:integer;             //part rotatie FPC file
                   //////////////////////////////////////////////////////////
                   X0,Y0:integer;             //positie centroid
                   rot_pp:integer            //rotatie pick and place machine*)

    gencad.COMPONENTS[np].component_refdes:=refdes;
    gencad.COMPONENTS[np].part_name       :=devicename( refdes,pack,value, shape );
    gencad.COMPONENTS[np].PLACE_x         :=xpos1;
    gencad.COMPONENTS[np].PLACE_y         :=ypos1;
    if side =0
    then
     BEGIN
       gencad.COMPONENTS[np].LAYER:= lay_TOP;
       gencad.COMPONENTS[np].shape_mirror:= mirr0;
       gencad.COMPONENTS[np].ROTATION    := to360(-rot_f);
       gencad.COMPONENTS[np].shape_flip      :=noflip;
     END
    else
     BEGIN
      if  (rot_f=90) OR (rot_f=270)
      then
       begin
        gencad.COMPONENTS[np].LAYER:= lay_BOTTOM;
        gencad.COMPONENTS[np].shape_mirror:=mirrx;//mirry;
        gencad.COMPONENTS[np].ROTATION    :=rot_f;//to360( rot_f+180);
        gencad.COMPONENTS[np].shape_flip      :=flip;
       end else
      if  (rot_f=0) OR (rot_f=180)
      then
       begin
        gencad.COMPONENTS[np].LAYER:= lay_BOTTOM;
        gencad.COMPONENTS[np].shape_mirror:=mirry;
        gencad.COMPONENTS[np].ROTATION    :=rot_f;//to360( rot_f+180);
        gencad.COMPONENTS[np].shape_flip  :=flip;
       end
     END;
    gencad.COMPONENTS[np].shape_name      :=space2_(shape);

    //GENCAD.DEVICES[NP].
  END;
  writeln('done.')
end;






procedure addsignals(net_name:string; pins: pin_array);
var len_s, n:integer;
begin
   len_s:=length(gencad.SIGNALS);
   setlength( gencad.SIGNALS, len_s+1);  // add signal
   with gencad.SIGNALS[len_s] do
   begin
     sig_name:=net_name;
     setlength(nodes,length(pins) );
     for n:=0 to length(pins)-1 do
     begin
        nodes[n].component_refdes:=pins[n].ref_str;
        nodes[n].pin_name        :=pins[n].pin_num_str;
      // writeln(' ', n, ' ',nodes[n].component_refdes,' ',nodes[n].pin_name )
     end;
   end;
 //  gencad.SIGNALS[lens].nodes
end;

             (*
                   net: "net2" 2 1 0 203200 711200 355600 1
                  ...}
                  net_name:string;		// net name
			            npins         :integer;
			            nconnects     :integer;
			            nareas        :integer;
			            def_width     :integer;
			            def_via_w     :integer;
			            def_via_hole_w:integer;
			            visible       :integer;
                  connects: connectarray;
                  areas:    area_array;
                  pins:     pin_array;*)

procedure addtrack(width:integer; var trackname:string);
var len_s, n:integer;
    found:boolean;
    name:string;

begin
   len_s:=length(gencad.TRACKS);
   found:=false;
   name:= 'LD'+stri(width div 1000);
   for n:=0 to len_s-1 do
    if name =gencad.TRACKS[n].Name
    then  found:=true;
   if not found
   then
    begin
     setlength( gencad.TRACKS, len_s+1);  // add track
     gencad.TRACKS[len_s].Name:=name;
     gencad.TRACKS[len_s].Width:=width
    end;
   trackname:=name;
end;

procedure AddVertex2Geo(vert1,vert2:vertextype; VAR Geos:Geoarray );
var len:integer;
begin
   len:=length(Geos);
   setlength(Geos,len+1 );
   with Geos[len] do
   begin
      soort := g_line;
      params[1]:= vert1.x ;
      params[2]:= vert1.y;
      params[3]:= vert2.x;
      params[4]:= vert2.y;
   end;
end;

function cadlayer(fpcblayer:integer):integer;
var a:integer;
begin
  a:=-1;
  case fpcblayer of
   fp_top_copper:         a:= lay_TOP;
   fp_bot_copper:         a:= lay_BOTTOM;
   fp_top_silk:           a:= lay_SILKSCREEN_TOP;
   fp_bottom_silk:        a:= lay_SILKSCREEN_BOTTOM;
   fp_top_solder_mask:    a:= lay_SOLDERMASK_TOP ;
   fp_bottom_solder_mask: a:= lay_SOLDERMASK_BOTTOM  ;
   fp_drilled_hole:       a:= lay_ALL;
   else
    if   fpcblayer>=fp_inner1
    then a:= fpcblayer+ lay_INNER+1 - fp_inner1;
  end;
  result:=a;
end;

procedure ADDroutes(net_name:string; connects:connectarray; VAR  routnet: routnettype);
var nc,ns,len_r, lay:integer;
    trackname,_trackname:string;
begin
 setlength( routnet.routs,0);
 FOR nc:=0 TO  length(connects)-1 DO
 with connects[nc] do
  begin
    routnet.sig_name:= net_name;
 //   writeln('***',net_name);
//    gencad.ROUTES[nc].sig_index:=nc;
    trackname:='';
    lay:=-1;
    for ns:=0 to length(segs)-1 DO
    if segs[ns].width> 0
    then
     begin
       _trackname:=trackname;
       addTrack( segs[ns].width, trackname ); //get trackwidth name
     //  writeln(trackname);
       if ((_trackname<> trackname) or
           ( lay      <>segs[ns].file_layer ))     // other width or layer (or first time)
       then begin
             len_r:= length(routnet.routs);
             setlength( routnet.routs, len_r+1);  //create new route
             with routnet.routs[len_r] do
                begin
                   track_name :=trackname; //  track_index:integer;
                   track_width:=segs[ns].width;
                   lay       :=segs[ns].file_layer;
                   layer:= cadlayer(lay);
                   addvertex2Geo(verts[ns],verts[ns+1], Geos);
                end;
            end
       else                 // equal width
             with routnet.routs[len_r] do
                begin
                  addvertex2Geo(verts[ns],verts[ns+1], Geos);
                end;
     end;// ns = nsegs-1
  end;//with connects[nc]
end;

function  ADDviatype( via_w, hole_diam:integer):string;
var pa:integer;
    goes: geoarray;
    padstr3:strarray3;
    cpadtype:integer;
    s:string;
    ncu_layers:integer;
    padstacknaam:string;
    fp:FPpadtype;
    //;
begin
   getoption( 'n_copper_layers:', s);
   ncu_layers:=vali(s);
   begin
       padstr3[1]:='';padstr3[2]:='';padstr3[3]:='';
       for pa:=1 to 3 do       //top_pad, inner_pad, bottom_pad
        begin
          // writeln('shape :',pads[pa].shape);
          // fp:FPpadtype ; VAR geo:geoarray; VAR padstr:string; VAR cpadtype:integer
           fp.shape:=PAD_ROUND;
           fp.width:= via_w;    fp.left:=0; fp.left:=0; fp.corner_rad:=0;
           fpcPAD2geos(  fp, goes,padstr3[pa], cpadtype);
         //  writeln('>',padstr3[pa],'<',cpadtype );

           addpad(goes,padstr3[pa],cpadtype);
        end;
       addpadstack(ncu_layers,  padstr3,hole_diam, padstacknaam ); //padstack[ps]
     //  writeln('ncu_layers :',ncu_layers);
     //  writeln('padstacknaam :',padstacknaam);
     //  writeln('hole_diam :',hole_diam);

      end; //with padstack
   result:=padstacknaam;

end;

PROCEDURE ADDvias( connects:connectarray; VAR vianr:integer;VAR  routnet: routnettype);
var nc,nv,len_v:integer;
BEGIN
  FOR nc:=0 TO  length(connects)-1 DO
   with connects[nc] do
   begin
     for nv:=0 to length(verts)-1 DO
     if  verts[nv].via_w>0
     then begin
           // writeln('vw, hw :',verts[nv].via_w,' ',verts[nv].via_hole_w );
            len_v:=length( routnet.vias );
            setlength( routnet.vias, len_v+1 );
            routnet.vias[ len_v].x          := verts[nv].x;
            routnet.vias[ len_v].y          := verts[nv].y;
            routnet.vias[ len_v].layer      := lay_ALL;
            routnet.vias[ len_v].drill_size := verts[nv].via_hole_w;
            inc(vianr);
            routnet.vias[ len_v].via_name   := 'via'+stri(vianr);
            routnet.vias[ len_v].pad_name := ADDviatype(verts[nv].via_w,verts[nv].via_hole_w )
          end
   end;
END;

PROCEDURE  ADDareas(net_name:string; n_areas:integer; areas: area_array; VAR routnet: routnettype  );
var  na, len_r:integer;
     trackname:string;
BEGIN
 if n_areas> 0
 then
 begin
  addTrack( 10000, trackname);
 // writeln(trackname);
  FOR na:=0 TO  n_areas-1 DO
   with areas[na] do  //   ncorners, file_layer, hatch :integer;  corners : cornerstype;
   begin
     routnet.sig_name:= net_name;
     len_r:= length(routnet.routs);
     setlength( routnet.routs, len_r+1);  //create new route
      with routnet.routs[len_r] do
         begin
           //
           track_name :=trackname; //  track_index:integer;
           track_width:=10000;
           layer:= cadlayer(file_layer);
           split_corners2geo( corners,geos );
         end;
   end;
 end;
END;

PROCEDURE conv_NETS;
VAR n, vianr:integer; // net counter; via counter
BEGIN
  write('>converting nets...');
 vianr:=0;
 setlength(gencad.ROUTESNETS,length(nets) );
 FOR n:=0 TO  length(nets)-1 DO
  BEGIN
   //WRITELN(n,' ',nets[n].net_name );
    addsignals(nets[n].net_name, nets[n].pins);
    ADDroutes( nets[n].net_name,nets[n].connects,  gencad.ROUTESNETS[n]  );
    ADDvias( nets[n].connects, vianr,              gencad.ROUTESNETS[n]);
    ADDareas( nets[n].net_name, nets[n].nareas,  nets[n].areas,     gencad.ROUTESNETS[n] );
    //
  END;
  writeln(' done.')
END;

procedure _Fpcb2cad( fpcb_filename,TinyCad_filename, gencad_filename:string);
begin

  readFreePCBfile( fpcb_filename  ); //write('*');readln;

  conv_HEADER(fpcb_filename); //write('*');readln;

  conv_BOARD;//  write('*');readln;

  conv_FOOTS; // write('*');readln;

  conv_DEVICES;

  conv_PARTS;// write('*');readln;

  conv_NETS;// write('*');readln;


  //readln;
  writeCad(gencad, gencad_filename);

end;

begin

end.
