unit FpcbIO;
{$H+}
interface
 uses   SysUtils,StrUtils, FPCBTypes, textstr;



 var //ncomps, nfoots:integer;
     boardoutlines:   array of areatype;
     footprints:footprintsarray;
     parts:     partsarray ;
     nets:      netsarray;
     options:   string;
     errstr:    string;

 (*

  function nmStrtoInch( s_nm:string):real;
  function nmStrtoMM( s_nm:string):real;
  procedure roteer( x,y, fi : real; VAR x1,y1:real);*)

  PROCEDURE readFreePCBfile(  FileName: TFileName);
  PROCEDURE read_board(PCB:string);
  PROCEDURE read_footprints( PCB:string);
  PROCEDURE read_parts( PCB:string);
  PROCEDURE read_options( PCB:string);
  procedure Read_Nets( PCB:string);
  function  to360( hoek:integer):integer;

  FUNCTION getoption( option_name : string; var opt:string):string;

implementation

//************** common procedures*************

 var    tempstr:string;


function nmStrtoInch( s_nm:string):real;
var v1,v2:real; code:integer;

begin
   val( s_nm,v1,code);
   v2:=v1/25.4e6;
   result:=v2;
end;

function nmStrtoMM( s_nm:string):real;
var v1,v2:real; code:integer;

begin
   val( s_nm,v1,code);
   v2:=v1*1e-6;
   result:=v2;
end;

FUNCTION angle( x,y:real):real;
var a:REAL;
BEGIN
  IF X=0
  THEN
    BEGIN
     IF Y=0
     THEN a:=0
     ELSE IF Y>0
          THEN a:=90
          ELSE a:=270;
    END
  ELSE a:=180/PI*arctan( y/x);
  IF (x>0) and (y<0)
  THEN a:=360+a
  ELSE
   IF x<0
   THEN  a:=a+180;
  angle:=a;
END;


procedure roteer( x,y, fi : real; VAR x1,y1:real);
begin
 fi:=-fi*pi/180;
 x1:= x*cos( fi) - y*sin(fi);
 y1:= x*sin( fi) + y*cos(fi);
end;

procedure clearpad( var pad:FPpadtype);
begin
 pad.shape:=     0;
 pad.width:=     0;
 pad.left:=      0;
 pad.right:=     0;
 pad.corner_rad:=0;
end;


PROCEDURE read_options( PCB:string);
var p1, p2:integer;
begin
  write('>reading options...');
    p1:=PosEx( '[options]', PCB, 1);
    p2:=PosEx( '[footprints]', PCB, 1)-1;
	if p2>p1
	then options:= MidStr(PCB,p1, p2)
  else options:='';
  writeln('done.')
end;

FUNCTION getoption( option_name : string; var opt:string):string;
var p, p2,i:integer;
    sa:stringarray;
    s:string;


begin
    p:=PosEx( option_name, options);
    s:=regel( options, p ,p2);
    splits(s, ':', sa,i);
    opt:=sa[2];
    result:=s
end;



function padstr2pad( fac:integer;  padstr:string):FPpadtype;
var pad :FPpadtype;
    sa:stringarray;
    i:integer;
begin
 splits(padstr ,' ', sa, i);
 pad.shape:=     vali(sa[2]);
 pad.width:=     round( fac * valr(sa[3]));
 pad.left:=      round( fac * valr(sa[4]));
 pad.right:=     round( fac * valr(sa[5]));
 pad.corner_rad:=round( fac * valr(sa[6]));
 result:=pad;
end;


function poly2stroke( fac:integer; polystr:string ): strokesarray;
var stroke:  strokesarray;
    p,i,ns, ep:integer;
    sa:stringarray;
    _width,_x1,_y1:integer;
    _start:integer;


begin
 ns:=0;
 setlength(stroke,0);
 p:=PosEx( 'outline_polyline:', polystr);
 if p>0
 then
  begin
   splits( regel(polystr,p, ep),' ', sa, i);
   _width:=round( fac*valr(sa[2]));
   _x1   :=round( fac*valr(sa[3]));
   _y1   :=round( fac*valr(sa[4]));
   _start:=0;
    repeat
         p:=PosEx( chr(13), polystr, p+1);
         splits( regel(polystr,p+1, ep), ' ', sa, i);
         IF sa[1]= 'next_corner:'
         THEN BEGIN
                inc(ns);
                setlength(stroke, ns);
                with stroke[ns-1] do
                begin
                   width:=_width;
                   x1:=_x1;
                   y1:=_y1;
                   x2:=round( fac*valr(sa[2]));
                   y2:=round( fac*valr(sa[3]));
                   style:=vali(sa[4]);    //STRAIGHT, ARC_CW, ARC_CCW
                   _x1:=x2;    //als vorige was 'next corner' dan vorige eindpunt opslaan
                   _y1:=y2;
                end;

              END
         ELSE IF sa[1]= 'close_polyline:'
         THEN BEGIN
                inc(ns);
                setlength(stroke, ns);
                stroke[ns-1].width:=_width;
                stroke[ns-1].x1:= _x1;
                stroke[ns-1].y1:= _y1;
                stroke[ns-1].x2:= stroke[ _start].x1;
                stroke[ns-1].y2:= stroke[ _start].y1;
                stroke[ns-1].style:=vali(sa[2]);    //STRAIGHT, ARC_CW, ARC_CCW
              END
         ELSE IF sa[1]= 'outline_polyline:'
         THEN BEGIN
                _width:=round( fac*valr(sa[2]));
                _x1   :=round( fac*valr(sa[3]));
                _y1   :=round( fac*valr(sa[4]));
                _start:=ns;
              END;
    until (p=0);
 end;
 result:=stroke
end;



PROCEDURE read_footprints( PCB:string);
var  p,p_,p__, p0,i, er:integer;
     ni:integer;      //pin array index
     endfoots:boolean;
     sa:stringarray;
     fac:integer;
     nfoots:integer;
     stackstring, padstring: string;
     nk:integer;
     units:string;
     polystring:string;
begin
    write('>reading footprints...');
    p:=PosEx( '[footprints]', PCB, 1);
    nfoots:=0;
    endfoots:=false;

    repeat
      p:=PosEx( 'name: "', PCB, p+1);
      if p=0
      then endfoots:=true
      else
       begin
         inc(nfoots);
         setlength( footprints,nfoots);
         with footprints[nfoots-1] do     //lezen pinnen
         begin
            splits( regel(PCB,p, er),'"', sa, i);
            name:=  clrspace( sa[2] );
           // writeln('naam: ',name);
            p_:=PosEx( 'units:', PCB, p+1);
            splits( regel(PCB,p_, er),':', sa, i);
            units:=  sa[2];
            //writeln('units: >',units,'<');
           { if units='NM'            THEN }
            fac:=1;
            IF units='MIL'
			      THEN fac:=25400;
            p_:=PosEx( 'sel_rect:', PCB, p+1);
            splits( regel(PCB,p_, er),':', sa, i);
            splits( sa[2],' ', sa, i);
            //writeln('sel_rect: sa[1]', sa[1], ' sa[2]',sa[2], ' sa[3]',sa[3], ' sa[4]',sa[4]  );
            sel_x:=round( fac*valr(sa[1]));
            sel_y:=round( fac*valr(sa[2]));
            sel_w:=round( fac*valr(sa[3]));
            sel_h:=round( fac*valr(sa[4]));

            p_:=PosEx( 'ref_text:', PCB, p+1);
            splits( regel(PCB,p_, er),':', sa, i);
            splits( sa[2],' ', sa, i);
            //writeln('sel_rect: sa[1]', sa[1], ' sa[2]',sa[2], ' sa[3]',sa[3], ' sa[4]',sa[4]  );
            ref_size:= round( fac*valr(sa[1]));
            ref_xi:=   round( fac*valr(sa[2]));
            ref_yi:=   round( fac*valr(sa[3]));
            ref_angle:=round( fac*valr(sa[4]));
            ref_width:=round( fac*valr(sa[5]));
            p0:=p_;
            p_:=PosEx( 'n_pins:', PCB, p_+1);
            polystring:= MidStr(PCB,p0,p_-p0);
            outline_stroke:=poly2stroke( fac, polystring);   // read_ silkscreen outlines

            splits( regel(PCB,p_, er),':', sa, i);
            num_pins:= vali( clrspace( sa[2] ));
            // writeln('npins',num_pins);
            if num_pins>0
            then
            BEGIN
            setlength(padstack,num_pins);
            ni:=-1;
            repeat
              p_:=PosEx( 'pin: "', PCB, p_+1);
              if p_<>0 then
              begin
               inc(ni);
               splits( regel(PCB,p_, er),'"', sa, i);
              // writeln(sa[1],'*',sa[2],'*',sa[3]);
               with padstack[ni] do
               begin
                pin_id:=sa[2];
                splits(sa[3] ,' ', sa, i);
                hole_diam:=round( fac*valr(sa[1]));
                x:=        round( fac*valr(sa[2]));
                y:=        round( fac*valr(sa[3]));
                rot:=      vali(sa[4]);
                nk:=p_+12;
                stackstring:='';
                while (PCB[nk]<> '"') and (nk<length( PCB)) do
                begin
                  inc( nk);
                  stackstring:=stackstring+ PCB[nk];  //copy part until next pin
                end;
                p__:=PosEx( 'top_pad:', stackstring);
                padstring:=regel( stackstring, p__ , er);
                clearpad(pads[1]);
                if p__<>0 then pads[1]:= padstr2pad(fac,padstring);

                p__:=PosEx( 'inner_pad:', stackstring);
                padstring:=regel( stackstring, p__ ,er);
                clearpad(pads[2]);
                if p__<>0 then pads[2]:= padstr2pad(fac,padstring);
                p__:=PosEx( 'bottom_pad:', stackstring);
                padstring:=regel( stackstring, p__ ,er);
                clearpad(pads[3]);
                if p__<>0 then pads[3]:= padstr2pad(fac,padstring);
               end;
             end;
         until (ni>=num_pins-1) or (p_=0);  // alle pinnen gelezen or eof??
         END;

         end; //end with
       end;  //endif
    until endfoots; // geen footprints namen meer
    writeln('done. ',nfoots,' footprints found. ')
end;


PROCEDURE read_parts( PCB:string);
var  p,p1,p2,i,  er:integer;
     sa:stringarray;
     rd,spos:string;
     ncomps:integer;
begin
    write('>reading parts...');
    p:=PosEx( '[parts]', PCB, 1);
    ncomps:=0;
    repeat
       p:=PosEx( 'part:', PCB, p+1);
       splits( regel(PCB,p, er),':', sa, i);
       rd:=  clrspace( sa[2] );
       if p<>0
       then
        begin
          inc( ncomps);
          setlength(parts,ncomps);
          with parts[ncomps-1] do     //lezen pinnen
           begin
            refdes:=rd;

            p2:=PosEx( 'pos:', PCB, p+1);
            splits( regel(PCB,p2, er),':', sa, i);
            spos:=  clrspace( sa[2] );
            splits( spos,' ', sa, i);
            xpos1:=vali(sa[1]);
            ypos1:=vali(sa[2]);
            side:=vali(sa[3]);
            rot_f:= vali(sa[4]);

            p1:=PosEx( 'package:', PCB, p+1);
            if (p1<>0) and (p1<p2)
            then
             begin
                  splits( regel(PCB,p1, er),':', sa, i);
                  pack:=  clrspace( sa[2] );
                  delete( pack,1,1);   delete( pack, length( pack),1);   // verwijder "
             end
            else pack:='';

            p1:=PosEx( 'value:', PCB, p+1);
            if (p1<>0) and (p1<p2)
            then
             begin
                  splits( regel(PCB,p1, er),':', sa, i);
                  splits(sa[2],'"',sa,i);
                  //writeln(sa[2]);
                  value:=  clrspace( sa[2] );
                 // delete( value,1,1);   delete( value, length( value),1);   // verwijder "
             end
            else value:='';

            p1:=PosEx( 'shape:', PCB, p+1);
            if (p1<>0) and (p1<p2)
            then
             begin
               splits( regel(PCB,p1, er),':', sa, i);
               shape:=  clrspace( sa[2] );
               delete( shape,1,1);   delete( shape, length( shape),1);   // verwijder "
             end
            else shape:='';
           end;
        end;
    until p=0;
    writeln('done. ',ncomps,' parts found.')
end;


function Str_pins(  s:string ):pin_array;
var pa:pin_array;
    p,i,j, er:integer;
    sa:stringarray;
    aant:integer;
    t:integer;


begin
  aant:=0;
  setlength(pa,0);
  p:=0;
  repeat
    p:=PosEx('pin:',s, p+1);
    if p>0
    then
     begin
      splits( regel(s,p, er),':', sa, i);
      splits(sa[2], ' ',sa,i);
      splits(sa[2], '.',sa,j);
      if i=2
      then begin
             inc(aant);
             setlength(pa,aant);
             with pa[aant-1] do
              begin
                             //     part_index: integer;
                  ref_str :=sa[1];
                  pin_num_str :=sa[2];
                  // findpart
                  part_index:=-1;
                  for t:=0 to  length(parts)-1 do
                   if parts[t].refdes= ref_str
                   then part_index:=t;
                 // writeln(' >',part_index )
              end;
           end;
     end;
  until p=0;
  result:=pa;
end;


function str_connects( PCB:string; p1:integer;  var p2:integer; var nc:integer):connectarray;
var conn:connectarray;
    p_,p__, nve, nse  ,ns:integer;
    r:string;
    sa,sb:stringarray;
    endcon, einde:boolean;

begin

   p_:=p1;
   nc:=0;
   einde:=false;
   repeat
    r:=regel( PCB, p_ , p_);


     splits(r, ':', sa , ns);
     if sa[1]='connect'
     then
        begin
           inc(nc);
           setlength(conn, nc );
           with  conn[nc-1] do
            begin
             splits(sa[2], ' ', sb, ns);
             start_pin:=vali(sb[2]);
             end_pin:=  vali(sb[3]);
             nsegs:=    vali(sb[4]);
             locked:=   vali(sb[5]);   //ok
             nve:=0; setlength(verts,nve);
             nse:=0; setlength(segs,nse);
             endcon:=false;
             p__:=p_;


             repeat
               p_:=p__; // save old read position before reading and evalating new line
               p2:=p_;
               r:=regel( PCB, p__ , p__);
               splits(r, ':', sa , ns);
               if sa[1]= 'vtx'
               then
                 begin
                    // addvertex
                  inc(nve); setlength(verts,nve);
                  with verts[nve-1]do
                  begin
                    splits(sa[2], ' ', sb , ns);
                   // show_sa('verts ',sb,8 );
                    x:=             vali(sb[2]);
							      y:=             vali(sb[3]);               // coords
							      file_layer:=    vali(sb[4]);
							     // pad_layer:=     vali(sb[5]);   // layer of pad if this is first or last vertex
							      force_via_flag:=vali(sb[5]);  // force a via even if no layer change
							      via_w:=         vali(sb[6]);
							      via_hole_w:=    vali(sb[7]);  // via width and hole width (via_w==0 means no via)
							      tee_ID  :=      0; // identifier for t-connection
                    if ns=9
                    then tee_ID:=   vali(sb[9]);
                  end;
                 end
               else if sa[1]= 'seg'
               then
                 begin
                  //addseg
                  inc(nse); setlength(segs,nse);
                  with segs[nse-1]do
                   begin
                    splits(sa[2], ' ', sb , ns);
                    file_layer:= vali(sb[2]);
							      width :=     vali(sb[3]);
                   end;
                 end
               else endcon:=true;
            until endcon;
            if (r='') or (sa[1]= 'area')
            then einde :=true;
            if (nsegs<>nse) or (nsegs<>nve-1)
            then errstr:= 'Error reading nets: number segments/ vertices does not match in net :'+ tempstr;
           end // with connect
        end
   until einde;
  result:= conn
end;

function str_areas( PCB:string; p1:integer; var p2:integer;  var na:integer ):area_array;
var area:area_array;
    p_,p__, ncnr,ns ,i:integer;
    r:string;
    sa,sb:stringarray;
    endarea, einde:boolean;
begin
 na:=0;
 setlength(area, na );
 if (regel( PCB, p1 , i )<>'') //einde net
 then
 begin
   p_:=p1;
   einde:=false;
   repeat
     r:=regel( PCB, p_ , p_);
     splits(r, ':', sa , ns);
    if sa[1]='area'
     then
        begin
           inc(na);
           setlength(area, na );
           with  area[na-1] do
            begin
             splits(sa[2], ' ', sb, ns);
             ncorners:=     vali(sb[2]);
             file_layer:=   vali(sb[3]);
             hatch:=        vali(sb[4]);
             ncnr:=0; setlength(corners,ncnr);
             endarea:=false;
             p__:=p_;
             repeat
               //writeln('connect');
               p_:=p__; // save old read position before reading and evalating new line
               p2:=p_;
               r:=regel( PCB, p__ , p__);
               splits(r, ':', sa , ns);
               if sa[1]= 'corner'
               then
                 begin
                    // addvertex
                  inc(ncnr); setlength(corners,ncnr);
                  with corners[ncnr-1]do
                   begin
                    splits(sa[2], ' ', sb , ns);
                   // show_sa('coners ', sb, 5);
                    x:= vali(sb[2]);
							      y:= vali(sb[3]);
							      last_side_style   := vali(sb[4]);
                    end_cont          := vali(sb[5]);
                  end;
                 end
               else endarea:=true;
            until endarea;
            if (r='')
            then einde :=true;
            if (ncorners<>ncnr)
            then errstr:= 'Error reading copper areas : number areas does not match in net :'+ tempstr;
          end // with connect
        end
   until einde;
 end;
 result:= area ;
end;

procedure Read_Nets( PCB:string);
var p,p1,i,er, pe, pendnets:integer;
    nc,na:integer;
    endnets:boolean;
    nnets:integer;
    sa, sb:stringarray;
begin
  write('>reading nets...');
  nnets:=0;
  endnets:=false;
  p:=PosEx( '[nets]', PCB, 1);
  pendnets:= PosEx( '[texts]', PCB, 1);
   repeat
   p:=PosEx( 'net: "', PCB, p+1);
   pe:= PosEx( 'net: "', PCB, p+1);   // einde van net
   if pe=0
   then pe:=pendnets;   // last net
   if p=0
   then endnets:=true
   else
    begin
     splits( regel(PCB,p, er),'"', sa, i);
      //writeln(sa[1],'*',sa[2],'*',sa[3]);
     //  writeln(i);
    // writeln('nets: sa[1]', sa[1], ' sa[2]',sa[2], ' sa[3]',sa[3], ' sa[4]',sa[4]  );
     splits(sa[3],' ', sb,i );
    // writeln('    sb[1]', sb[1], ' sb[2]',sb[2], ' sb[3]',sb[3], ' sb[4]',sb[4], '  i',i  );

     if (sa[2]<>'') and (sa[3]<>'') and (i=7) //and (vali(sb[1])>0) //npins>0
     then
      begin
       inc(nnets);
       setlength(nets,nnets);
       with nets[nnets-1] do     //lezen pinnen
         begin
           net_name:=sa[2];        tempstr:= net_name; //for error message
           //writeln('NET :',net_name);

           //writeln(i);
 			     npins         := vali(sb[1]);
			     nconnects     := vali(sb[2]);
			     nareas        := vali(sb[3]);
			     def_width     := vali(sb[4]);
			     def_via_w     := vali(sb[5]);
			     def_via_hole_w:= vali(sb[6]);
			     visible       := vali(sb[7]);
           setlength(areas,    nareas);
           setlength(connects, nconnects );
           p1:= PosEx( chr(13), PCB, p+1)+2;    //volgende regel na net: "

           if (p1>0) and (p1<pe)
             then
              begin
             //  writeln('Str_pins ');
               pins:=   Str_pins( midstr(PCB,p1, pe-p1) );  // get pinlist first
               //writeln('str_connects ');
               //writeln('nconnects',nconnects, ' p2',p2,' p3',p3);
               if (nconnects>0)
               then  connects:=  str_connects( PCB, p1, pe, nc)
               else nc:=0;
               if (nc<> nconnects) or (nc<> length(connects))
               then errstr:= 'Error reading nets: number of connections does not match in net :'+ net_name;
               //writeln('str_areas');
               if (nareas>0)
               then  areas   :=  str_areas( PCB, p1,pe, na )
               else na:=0;
               if (na<> nareas) or (na<> length(areas ))
               then errstr:= 'Error reading nets: number of areas does not match in net :'+ net_name;
              end;
          // writeln(nareas,'=', na, '=',length(areas ) )
         end;  // with nets
      end;
    end;
  until endnets=true;
  writeln('done. ', nnets,' nets found');
  //readln
end;


//////////////////  placement position procedures/////////////////////

procedure calc_center( pa: padstackarray; var xc,yc:real);
var n:integer;
    xmin,xmax,ymin,ymax:real;

begin
 IF Length( pa) >0
 THEN
 BEGIN
   with pa[0] do
    begin
      xmax:=x;
      ymax:=y;
      xmin:=x;
      ymin:=y;
    end;
   for n:=1 to Length( pa)-1 do
   with pa[n] do
    begin
      if x>xmax   then xmax:=x;
      if y>ymax   then ymax:=y;
      if x<xmin   then xmin:=x;
      if y<ymin   then ymin:=y;
     // writeln(' id', pin_id , ' x:',x:10:3,' y:',y:10:3) ;

    end;
   xc:= (xmin+xmax)/2 ;
   yc:= (ymin+ymax)/2 ;
  END
  ELSE
   BEGIN
     xc:=0; yc:=0;
   END;
end;

procedure footprintpin1pos( pa: padstackarray; VAR x1,y1: real);
var n:integer;
begin
 IF Length( pa) >0
 THEN
  BEGIN
   x1:=pa[0].x;
   y1:=pa[0].y;  //default
   for n:=0 to Length( pa)-1 do
    with pa[n] do
    begin
     //writeln( 'pin_id >',pin_id,'<' );
     if  pin_id ='1'
     then begin
             x1:=x;
             y1:=y;
          end;
    end;
  END
 ELSE BEGIN
        x1:=0;
        y1:=0;
      END;
end;

function to360( hoek:integer):integer;
begin
  while hoek<0 do
   hoek:=hoek+360;
  while hoek>=360 do
   hoek:=hoek-360;
  result:=hoek
end;


procedure rotate( x,y, fi : real; VAR x1,y1:real);
begin
 fi:=-fi*pi/180;
 x1:= x*cos( fi) - y*sin(fi);
 y1:= x*sin( fi) + y*cos(fi);
end;
             (*
procedure calc_placement;
var nf, nc:integer;
    xp1,yp1,x,y, x1,y1,r1:real;
    a:real;
begin
    writeln('calculating placement... ');
    for nf:=0 to length( footprints)-1 do
     with  footprints[nf] do
      begin
          calc_center( padstack, Xcenter,Ycenter);
          //bereken rotatie t.o.v. centre - pin1
          footprintpin1pos(  padstack,xp1,yp1);
          if  (xp1 - Xcenter=0)  and (yp1 - Ycenter = 0)   //center=pin1
          then rot1:=0
          else
           BEGIN
               a:=angle( xp1 - Xcenter, yp1 - Ycenter);
               //writeln( name,' ',a:5:1);
               if (a >=90)  and (a<180)
               then  rot1:=0
               else if (a>=180) and (a<270)
                    then rot1:=90
                    else if (a>=270)
                         then rot1:=180
                         else if (a >=0)  and (a<90)
                              then rot1:=270;

               if num_pins=2
               then rot1:=rot1-90;         //IPC
           END;
      end;

    for nc:=0 to length( parts)-1 do
     with parts[nc] do
       if (refdes<>'')  AND ((side=0) or (side=1))
       then
         begin
           //zoekshape
            //writeln(side);
            x:=0; y:=0; r1:=0;
            for nf:=0 to length( footprints)-1 do
             with footprints[nf] do
             if name=shape
             then
                begin
                   x:=Xcenter;
                   y:=Ycenter;
                   r1:=rot1;
                 end;
            rotate( x,y, rot_f , x1,y1);
            X0:=round( Xpos1 + x1) ;
            Y0:=round( Ypos1 + y1);
            rot_pp:=   to360( round(r1)-rot_f);

            //
         end;
  writeln(' done.')
end;
               *)
////////////////// end  placement position procedures/////////////////////


PROCEDURE read_board(PCB:string);
var  p1,  p2 , p_,p__, ncnr, ns:integer;
     endarea, einde:boolean;
     r:string;
     sa, sb:stringarray;
     nboard:integer;
begin
  write('>reading boardsection...');
  einde:=false;
  nboard:=0;
  p1:=PosEx( '[board]', PCB, 1);
  p2:=PosEx( '[solder_mask_cutouts]', PCB, p1)-1;
  repeat
   p1:=PosEx( 'outline:', PCB, p1);
   if (p1<p2) and (p1<>0)
   then
    begin
      inc(nboard);
      setlength( boardoutlines,nboard);
      p1:=PosEx( 'corner:', PCB, p1);
      p_:=p1;
	    if (p2>p1) and (p1<>0)
      then
       with  boardoutlines[nboard-1] do
          begin
             ncnr:=0; setlength(corners,ncnr);
             endarea:=false;
             p__:=p_;
             repeat
               //writeln('connect');
              // p_:=p__; // save old read position before reading and evalating new line
               r:=regel( PCB, p__ , p__);
              // writeln('->',r);
               splits(r, ':', sa , ns);
               if sa[1]= 'corner'
               then
                 begin
                    // addvertex
                  inc(ncnr); setlength(corners,ncnr);
                  with corners[ncnr-1]do
                   begin
                    splits(sa[2], ' ', sb , ns);
                    x:= vali(sb[2]);
							      y:= vali(sb[3]);
							      last_side_style   := vali(sb[4]);
                    end_cont          := 0;
                  end;
                 end
               else endarea:=true;
            until endarea;
            ncorners:=ncnr;
            file_layer:=0;
            hatch:=0;
        end;
        //writeln;
    end
   else einde:=true;
  until einde;
  writeln('done. ',nboard , ' outline(s) found.')
end;



PROCEDURE readFreePCBfile(  FileName: TFileName);
var PCB:string;
begin
   writeln('>Reading '+FileName+'...');
   errstr:='';
   PCB:=LoadFile( FileName);
   read_options(PCB);
   read_footprints( PCB );
   read_board(PCB );
   read_parts( PCB);
   read_nets(PCB);
   if errstr=''
   then writeln('>File loaded, no errors found.')
   else writeln('>Error(s) found in file : '+errstr);
  // calc_placement;


end;

end.

