unit Unit1;
//{$APPTYPE CONSOLE}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    OpenDialog1: TOpenDialog;
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses
Fpcb2Cad;


{$R *.dfm}


function GetConInputHandle : THandle;
begin
Result := GetStdHandle(STD_INPUT_HANDLE)
end;


procedure TForm1.FormCreate(Sender: TObject);
var
  FPCBfilename, GENCADfilename: string;

begin
  writeln('');
  SetConsoleTextAttribute(GetStdHandle(  STD_OUTPUT_HANDLE),  159);
  write('     FreePCB to GenCad           ');
  SetConsoleTextAttribute(GetStdHandle(  STD_OUTPUT_HANDLE),  155);
  writeln('   by Edwin de Held  2010 v2.01.24            ');
  writeln;
  SetConsoleTextAttribute(GetStdHandle(  STD_OUTPUT_HANDLE),  3);
  writeln('  ');
  writeln(' This program can also be run from the commandline:');
  writeln(' FPCB2CAD filename.fpc filename.cad  or FPCB2CAD filename.fpc');
  writeln('  ');
  writeln('( Freeware Disclaimer:');
  writeln('  The author, of this software accepts no responsibility for damages resulting');
  writeln('  from the use of this product and makes no warranty or representation, either');
  writeln('  expressor implied, including but not limited to, any implied warranty of ');
  writeln('  merchantability or fitness for a particular purpose. This software is ');
  writeln('  provided "AS IS", and you, its user, assume all risks when using it.)');


  GENCADfilename:='';
  if (ParamCount > 0) and fileexists(ParamStr(1))
  then
    begin
      FPCBfilename:= ParamStr(1);
      if (ParamCount> 1)
      then
       begin
          GENCADfilename:= ParamStr(2);
       end;
    end
  else
  begin
    SetConsoleTextAttribute(GetStdHandle(  STD_OUTPUT_HANDLE),  10);
    writeln('');
    writeln(' Chose a FreePCB (.fpc) file to convert to GenCad 1.4');
    writeln(' Output file name will be : <filename .CAD )');
    writeln(' ');
    OpenDialog1.Options := [ofFileMustExist];
    OpenDialog1.Filter := 'FreePCB File (*.fpc)|*.fpc|All files (*.*)|*.*';
    OpenDialog1.FilterIndex := 1;

    if OpenDialog1.Execute
    then FPCBfilename:=OpenDialog1.FileName  { Display Open dialog box }
    else FPCBfilename:=''
  end;
 /////
  if fileexists(FPCBfilename)
  then begin
              
         if GENCADfilename=''
         then GENCADfilename:=FPCBfilename;
        // else GENCADfilename := ExtractFileName(GENCADfilename);
         GENCADfilename := ChangeFileExt(GENCADfilename, '.CAD');
         writeln(' ');
         SetConsoleTextAttribute(GetStdHandle(  STD_OUTPUT_HANDLE),  14);
         writeln('>Starting');
        _Fpcb2cad(FPCBfilename,'', GENCADfilename);
         writeln('>Finished');
         //readln;
       end;
 SetConsoleTextAttribute(GetStdHandle(  STD_OUTPUT_HANDLE),  7);
//write('Press enter to close window...');
 //readln;
 Application.Terminate;
end;

end.
