unit Unit2;

{$mode objfpc}{$H+}
{$APPTYPE CONSOLE}

interface

uses
  Classes, SysUtils, FileUtil, LResources, Forms, Controls, Graphics, Dialogs,
  StdCtrls, crt;

type

  { TForm1 }

  TForm1 = class(TForm)
    OpenDialog1: TOpenDialog;
    procedure FormCreate(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
  end; 

var
  Form1: TForm1; 

implementation
uses
 Fpcb2Cad;

{ TForm1 }


procedure TForm1.FormCreate(Sender: TObject);

VAR   FPCBfilename, GENCADfilename: string;
begin
  writeln;
  Textbackground( Blue);   Textcolor( White);
  write('     FreePCB to GenCad           ');
  Textcolor( Cyan);
  writeln('   by Edwin de Held  2010 v2.01.24            ');
  Textbackground( Black);   Textcolor( Cyan);
  writeln('                                                                                ');
  writeln(' This program can also be run from the commandline:');
  writeln(' FPCB2CAD filename.fpc filename.cad  or FPCB2CAD filename.fpc');
  writeln('  ');
  writeln('( Freeware Disclaimer:');
  writeln('  The author, of this software accepts no responsibility for damages resulting');
  writeln('  from the use of this product and makes no warranty or representation, either');
  writeln('  expressor implied, including but not limited to, any implied warranty of ');
  writeln('  merchantability or fitness for a particular purpose. This software is ');
  writeln('  provided "AS IS", and you, its user, assume all risks when using it.)');


  GENCADfilename:='';
  if (ParamCount > 0) and fileexists(ParamStr(1))
  then
    begin
      FPCBfilename:= ParamStr(1);
      if (ParamCount> 1)
      then
       begin
          GENCADfilename:= ParamStr(2);
       end;
    end
  else
  begin
    Textcolor(LightGreen);
    writeln('');
    writeln(' Chose a FreePCB (.fpc) file to convert to GenCad 1.4');
    writeln(' Output file name will be : <filename .CAD )');
    writeln(' ');
    OpenDialog1.Options := [ofFileMustExist];
    OpenDialog1.Filter := 'FreePCB File (*.fpc)|*.fpc|All files (*.*)|*.*';
    OpenDialog1.FilterIndex := 1;

    if OpenDialog1.Execute
    then FPCBfilename:=OpenDialog1.FileName  { Display Open dialog box }
    else FPCBfilename:=''
  end;
 /////
  if fileexists(FPCBfilename)
  then begin

         if GENCADfilename=''
         then GENCADfilename:=FPCBfilename;
        // else GENCADfilename := ExtractFileName(GENCADfilename);
         GENCADfilename := ChangeFileExt(GENCADfilename, '.CAD');
         writeln(' ');
         Textcolor(Yellow);
         writeln('>Starting');
        _Fpcb2cad(FPCBfilename,'', GENCADfilename);
         writeln('>Finished');
         //readln;
       end;
 Textcolor(LightGray);
//write('Press enter to close window...');
// readln;
 Application.Terminate;

end;

initialization
  {$I Unit2.lrs}

end.

