unit gencad_IO;
{$H+}
interface
 uses   SysUtils,StrUtils,  TextStr, CadTypes;

procedure setdefaults(var gencad: GencadType);
procedure writeCad( gencad: GencadType; filename:string );


implementation
// locals
var t:text;
    dim_factor  : real;
    dim_decimals: integer;

function sdim(nm:integer):string;
var v:real; s:string;
begin
  v:=nm/ dim_factor;
  str( v: 1: dim_decimals,s);
  result:=s;
end;


procedure setdefaults(var gencad: gencadtype);
begin
   gencad.HEADER.User:= 'USERNAME';
   gencad.HEADER.Units:='THOU';
   gencad.HEADER.Origin_X:=1;
   dim_factor :=  2.54e4;
   dim_decimals:= 3;
end;


///////////////////////   export cad file          ///////////////////////////////
procedure write_HEADER(gencad: gencadtype);
var n: integer;
begin

 with gencad.HEADER do
 begin



    if Units ='INCH'  then
                              BEGIN
                               dim_factor :=  2.54e7;
                               dim_decimals:= 6;
                              END

    else if Units ='THOU'  then
                              BEGIN
                               dim_factor :=  2.54e4;
                               dim_decimals:= 3;
                              END
    else if Units ='MM'    then
                              BEGIN
                               dim_factor :=  1e6;
                               dim_decimals:= 5;
                              END
    else if Units ='MM100' then
                              BEGIN
                               dim_factor :=  1E4;
                               dim_decimals:= 2;
                              END;

  writeln(t,'$HEADER');
  writeln(t,'GENCAD 1.4');
  writeln(t,'USER '+User );
  writeln(t,'DRAWING ' +Drawing);
  writeln(t,'REVISION '+Revision);
  writeln(t,'CADID '+Cadid);
  writeln(t,'UNITS '+Units );
  writeln(t,'ORIGIN '+sdim(Origin_X)+' '+sdim(Origin_Y));
  writeln(t,'INTERTRACK ', Intertrack );
  for n:=0 to length(Attributes)-1 do
    writeln(t,'ATTRIBUTE '+Attributes[n] );
  writeln(t, '$ENDHEADER');
  writeln(t);

 end;
end;

procedure write_TRACKS(gencad: gencadtype);
var n:integer;
begin
  writeln(t, '$TRACKS');
     for n:=0 to length(gencad.TRACKS)-1 do
     with gencad.TRACKS[n] do
     begin
        writeln(t,'TRACK '+ name+' ', sdim(Width) )
     end;
  writeln(t, '$ENDTRACKS');
  writeln(t);
end;

procedure write_LAYERS(gencad: gencadtype);
begin
 with gencad.LAYERS do
 begin
  writeln(t, '$LAYERS');
  writeln(t, '$ENDLAYERS');
  writeln(t);
 end;
end;
(*
  g_line      = 1001;   // X1, X1, X2,X2
 	g_arc       = 1002;   //X1, X1, X2,X2, Xc, Xc
	g_cir       = 1003;   //Xc, Xc, R
	g_Rect      = 1004;    //X1, X1, X2,X2*)

function geostr(geo:geotype):string;
var s:string;
    n:integer;
begin
 with geo do
  case soort of
  g_Line :   begin
                s:='LINE';
                for n:=1 to 4 do
                  s:= s+' '+sdim(params[n])
             end;
  g_Arc :    begin
                s:='ARC';
                for n:=1 to 6 do
                  s:= s+' '+sdim(params[n])
             end;
  g_Cir :    begin
                s:='CIRCLE';
                for n:=1 to 3 do
                  s:= s+' '+sdim(params[n])
             end;
  g_Rect:    begin
                s:='RECTANGLE';
                for n:=1 to 4 do
                  s:= s+' '+sdim(params[n])
             end;
  end;
  result:=s;
end;

function layerstr(lay:integer):string;
var s:string;
    n:integer;
begin
  case lay of
   lay_ALL    : s:= 'ALL';
   lay_TOP    : s:= 'TOP';
   lay_BOTTOM : s:= 'BOTTOM';
   lay_SILKSCREEN_TOP    : s:= 'SILKSCREEN_TOP';
   lay_SILKSCREEN_BOTTOM : s:= 'SILKSCREEN_BOTTOM';
   lay_SOLDERMASK_TOP    : s:= 'SOLDERMASK_TOP';
   lay_SOLDERMASK_BOTTOM : s:= 'SOLDERMASK_BOTTOM';
   lay_SOLDERPASTE_TOP   : s:= 'SOLDERPASTE_TOP';
   lay_SOLDERPASTE_BOTTOM: s:= 'SOLDERPASTE_BOTTOM';
   lay_INNER   : s:= 'INNER';
   else
      if lay< lay_GROUND
      then
        begin
           s:='INNER';
           n:=lay- lay_INNER;      //11  12   13
           s:=s+stri(n);
        end
      else if lay< lay_POWER  //ground layers
        then
         begin
           s:='GROUND';
           n:=lay- lay_GROUND;      //101  102   103
           s:=s+stri(n);
         end
      else
       begin
          s:='POWER';
          n:=lay- lay_POWER;      //201  202   203
          s:=s+stri(n);
       end;

  end;  //case
 result:=s
end;

function drillstr(drill_size: integer):string;
var s:string;
begin
  if drill_size<=0
  then result:=stri(drill_size)       //-1 =unknown; -2 =hole size is that defined by the pad or pad stack
  else result:=sdim(drill_size);
end;

function padstr(i:integer):string;
var s:string;
begin
   case i of
     p_FINGER   :s:='FINGER';
     p_ROUND    :s:='ROUND';
     p_ANNULAR  :s:='ANNULAR';
     p_BULLET   :s:='BULLET';
     p_RECTANGULAR :s:='RECTANGULAR';
     p_HEXAGON     :s:='HEXAGON';
     p_OCTAGON     :s:='OCTAGON';
     p_POLYGON     :s:='POLYGON';
     p_UNKNOWN     :s:='UNKNOWN';
   end;
  result:=s
end;

function mirrstr(i:integer):string;
var s:string;
begin
  case i of
    mirr0:s:='0';
    mirrx:s:='MIRRORX';
    mirry:s:='MIRRORY';
  end;
  result:=s
end;

function flipstr(i:integer):string;
var s:string;
begin
  case i of
    noflip:s:='0';
    flip:s:='FLIP';
  end;
  result:=s
end;


procedure write_BOARD(gencad: gencadtype);
var n,m:integer;
begin
 with gencad.BOARD do
 begin
  writeln(t, '$BOARD');
  if Thickness>0   then writeln(t, 'THICKNESS '+sdim(Thickness));

  for n:=0 to length(Geos)-1 do
   writeln(t, geostr(Geos[n]));

  for n:=0 to length(Attributes)-1 do
   writeln(t, 'ATTRIBUTE '+Attributes[n]);

  for n:=0 to length(Cutouts)-1 do
  with Cutouts[n] do
   begin
     writeln(t, 'CUTOUT '+ co_name);
     for m:=0 to length(coGeos)-1 do
        writeln(t, geostr(coGeos[m]));
     for m:=0 to length(coAttributes)-1 do
      writeln(t, 'ATTRIBUTE '+coAttributes[m]);
   end;

  for n:=0 to length(Masks)-1 do
  with Masks[n] do
   begin
     writeln(t, 'MASK '+MskName+' '+layerstr(MskLayer));
     for m:=0 to length(MskGeos)-1 do
        writeln(t, geostr(MskGeos[m]));
     for m:=0 to length(MskAttributes)-1 do
      writeln(t, 'ATTRIBUTE '+MskAttributes[m]);
   end;
  writeln(t, '$ENDBOARD');
  writeln(t);
 end;
 //writeln(layerstr( lay_INNER + 60 ))
end;

procedure write_ARTWORKS(gencad: gencadtype);
var n,m:integer;
begin
 writeln(t, '$ARTWORKS');
 for n:=0 to length(gencad.ARTWORKS)-1 do
 with gencad.ARTWORKS[n] do
 begin
     writeln(t, 'ARTWORK '+Name);
     writeln(t, 'LAYER '+layerstr( Layer));
     writeln(t, 'TRACK '+gencad.TRACKS[TrackIndex].Name);
     if FILLED then write(t, 'FILLED YES')
               else write(t, 'FILLED 0');
     for m:=0 to length(Geos)-1 do
       writeln(t, geostr(Geos[m]));
     for m:=0 to length(Attributes)-1 do
      writeln(t, 'ATTRIBUTE '+Attributes[m]);
     //////TextType  parameters  toevoegen ///////// !!!!!
  end;
 writeln(t, '$ENDARTWORKS');
 writeln(t);
end;

procedure write_PADS(gencad: gencadtype);
var n,m:integer;
begin
 writeln(t, '$PADS');
 for n:=0 to length(gencad.PADS)-1 do
 with gencad.PADS[n] do
 begin
    writeln(t,'PAD '+pad_name+' '+padstr(pad_type)+' '+stri(drill_size));
    for m:=0 to length(Geos)-1 do
       writeln(t, geostr(Geos[m]));
    for m:=0 to length(Attributes)-1 do
       writeln(t, 'ATTRIBUTE '+Attributes[m]);
 end;
 writeln(t, '$ENDPADS');
 writeln(t);
end;





procedure write_PADSTACKS(gencad: gencadtype);
var n,m:integer;
begin
 writeln(t, '$PADSTACKS');
 for n:=0 to length(gencad.PADSTACKS)-1 do
 with gencad.PADSTACKS[n] do
 begin
    writeln(t,'PADSTACK '+padstack_name+ ' '+ sdim( drill_size) );
    for m:=0 to length(pos)-1 do
     with pos[m] do
       writeln(t,'PAD '+pad_name+' '+layerstr( Layer)+' '+stri(rot)  + ' '+mirrstr(mirror));
 end;
 writeln(t, '$ENDPADSTACKS');
 writeln(t);
end;

procedure write_SHAPES(gencad: gencadtype);
var n,m:integer;
begin
 writeln(t, '$SHAPES');
 for n:=0 to length(gencad.SHAPES)-1 do
 with gencad.SHAPES[n] do
 begin
   writeln(t, 'SHAPE '+shape_name);
   for m:=0 to length(Attributes)-1 do
     writeln(t, 'ATTRIBUTE '+Attributes[m]);
   for m:=0 to length(Geos)-1 do
     writeln(t, geostr(Geos[m]));
   if insert<>'' then writeln(t,'INSERT '+ insert);
   if Height>0   then writeln(t,'HEIGHT '+ strr(Height/1E6,1) + 'MM' );
   for m:=0 to length(fid)-1 do
    with fid[m] do    //FID <fid_name> <pad_name> <x_y_ref> <layer> <rot> <mirror>
     writeln(t, 'FID '+name+ ' '+padstack_name+ ' '+ sdim(x)+ ' '+ sdim(y) +' '+layerstr(layer)+ ' '+ stri(rot)+ ' '+ mirrstr(mirror));
   for m:=0 to length(pins)-1 do
    with pins[m] do    //PIN <pin_name> <pad_name> <x_y_ref> <layer> <rot> <mirror>
     writeln(t, 'PIN '+name+ ' '+padstack_name+ ' '+ sdim(x)+ ' '+ sdim(y) +' '+layerstr(layer)+ ' '+ stri(rot)+ ' '+ mirrstr(mirror));
   for m:=0 to length(arts)-1 do
    with arts[m] do   //ARTWORK <artwork_name> <x_y_ref> <rot> <mirror>
     writeln(t, 'ARTWORK '+artwork_name+ ' '+ sdim(x)+ ' '+ sdim(y)+' '+ stri(rot)+ ' '+ mirrstr(mirror));
 end;
 writeln(t, '$ENDSHAPES');
 writeln(t);
end;



procedure write_DEVICES(gencad: gencadtype);
var n,m:integer;
begin
 writeln(t, '$DEVICES');
 for n:=0 to length(gencad.DEVICES)-1 do
 with gencad.DEVICES[n] do
 begin
  writeln(t, 'DEVICE '+device);
  IF part_name<>'' THEN writeln(t, 'PART '+part_name);
  IF comptype<>'' THEN writeln(t, 'TYPE '+comptype);
  IF value<>'' THEN writeln(t, 'VALUE '+value);
  IF style<>'' THEN writeln(t, 'STYLE '+style);
  IF ntol<>'' THEN writeln(t, 'NTOL '+ntol);
  IF ptol<>'' THEN writeln(t, 'PTOL '+ptol);
  IF volts<>'' THEN writeln(t, 'VOLTS '+volts);
  IF desc<>'' THEN writeln(t, 'DESC '+desc);
  IF package<>'' THEN writeln(t, 'PACKAGE '+package);
  IF pincount<>0 THEN writeln(t, 'PINCOUNT '+stri(pincount));
  for m:=0 to length(pininfo)-1 do
    with pininfo[m] do
    begin
      if pindesc<>''  THEN writeln(t, 'PINDESC ' +pin_name + ' '+pindesc);
      if pinfunct<>'' THEN writeln(t, 'PINFUNCT '+pin_name + ' '+pinfunct);
    end;
 end;
 writeln(t, '$ENDDEVICES');
 writeln(t);
end;

procedure write_COMPONENTS(gencad: gencadtype);
var n,m:integer;
begin
 writeln(t, '$COMPONENTS');
 for n:=0 to length(gencad.COMPONENTS)-1 do
 with gencad.COMPONENTS[n] do
  begin
   writeln(t, 'COMPONENT '+component_refdes);
   writeln(t, 'DEVICE '   +part_name);
   writeln(t, 'LAYER '    +layerstr(layer ));
   writeln(t, 'ROTATION ' +stri(rotation ));
   writeln(t, 'PLACE '    +sdim(place_x )+' '+sdim(place_y ));
   writeln(t, 'SHAPE '    +shape_name+ ' '+mirrstr(shape_mirror)+ ' '+flipstr(shape_flip));
   for m:=0 to length(arts)-1 do
    with arts[m] do   //ARTWORK <artwork_name> <x_y_ref> <rot> <mirror>
     writeln(t, 'ARTWORK '+artwork_name+ ' '+ sdim(x)+ ' '+ sdim(y)+' '+ stri(rot)+ ' '+ mirrstr(mirror));
   for m:=0 to length(fid)-1 do
    with fid[m] do    //FID <fid_name> <pad_name> <x_y_ref> <layer> <rot> <mirror>
     writeln(t, 'FID '+name+ ' '+padstack_name+ ' '+ sdim(x)+ ' '+ sdim(y) +' '+layerstr(layer)+ ' '+ stri(rot)+ ' '+ mirrstr(mirror));
   //
   //////TextType  parameters  toevoegen ///////// !!!!!
   //
   for m:=0 to length(Attributes)-1 do
       writeln(t, 'ATTRIBUTE '+Attributes[m]);

  end;
  writeln(t, '$ENDCOMPONENTS');
  writeln(t);
end;

procedure write_SIGNALS(gencad: gencadtype);
var n,m:integer;
begin
 writeln(t, '$SIGNALS');
 for n:=0 to length(gencad.SIGNALS)-1 do
 with gencad.SIGNALS[n] do
 begin
    writeln(t, 'SIGNAL '+sig_name);
    for m:=0 to length(nodes)-1 do
     with nodes[m] do
      writeln(t, 'NODE '+ component_refdes+' '+pin_name);
 end;
 writeln(t, '$ENDSIGNALS');
 writeln(t);
end;

procedure write_ROUTES(gencad: gencadtype);
var n,m,i:integer;
begin
 writeln(t, '$ROUTES');
 for n:=0 to length(gencad.ROUTESNETS)-1 do
 with gencad.ROUTESNETS[n] do
 if (length(routs)>0)
 then
 begin
    writeln(t, 'ROUTE '+sig_name);

    for m:=0 to length(routs)-1 do
     with routs[m] do
     begin
      writeln(t, 'LAYER '+layerstr(layer));
      writeln(t, 'TRACK '+track_name);//gencad.TRACKS[track_index].name);
      for i:=0 to length(Geos)-1 do
         writeln(t, geostr(Geos[i]));
     end;

    for m:=0 to length(vias)-1 do
     with vias[m] do
    writeln(t, 'VIA '+pad_name+ ' '+sdim( x)+' ',sdim(y)+' ' +layerstr( layer)+' '+drillstr( drill_size)+' '+ via_name);

 end;
 writeln(t, '$ENDROUTES');
 writeln(t);
end;

procedure write_TESTPINS(gencad: gencadtype);
var n:integer;
begin
 writeln(t, '$TESTPINS');
 for n:=0 to length(gencad.TESTPINS)-1 do
 with gencad.TESTPINS[n] do
 begin

 end;
 writeln(t, '$ENDTESTPINS');
 writeln(t);
end;

procedure write_POWERPINS(gencad: gencadtype);
var n:integer;
begin
 writeln(t, '$POWERPINS');
 for n:=0 to length(gencad.POWERPINS)-1 do
 with gencad.POWERPINS[n] do
 begin



 end;
 writeln(t, '$ENDPOWERPINS');
 writeln(t);
end;

procedure write_MECH(gencad: gencadtype);
begin
 writeln(t, '$MECH');
 with gencad.MECH do
 begin
   

 end;
 writeln(t, '$ENDMECH');
 writeln(t);
end; 

  
procedure writeCad( gencad: GencadType; filename:string );

begin
 write('>writing GENCAD file....');
 assignfile(t, filename);
 rewrite(t);
 write_HEADER(gencad);
 write_TRACKS(gencad);
 write_LAYERS(gencad);
 write_BOARD(gencad);
 write_ARTWORKS(gencad);
 write_PADS(gencad);
 write_PADSTACKS(gencad);
 write_SHAPES(gencad);
 write_DEVICES(gencad);
 write_COMPONENTS(gencad);
 write_SIGNALS(gencad);
 write_ROUTES(gencad);
 write_TESTPINS(gencad);
 write_POWERPINS(gencad);
 write_MECH(gencad);
 close(t);
 writeln('done.');
end;

begin


end.
