/*
 * Decompiled with CFR 0.152.
 */
package com.kodebot.friendlybot;

import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.TextAlignment;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;

public class CustomDialog {
    private Stage stage;
    private String title;
    private String message;
    private double width;
    private double height;
    private ConfirmClickListener confirmClickListener;
    private ActionOnePerformed actionOneClickListener;
    private ActionTwoPerformed actionTwoClickListener;
    public static final int DIALOG_TYPE_INFO = 1;
    public static final double DIALOG_WIDTH_HALF = 500.0;
    public static final double DIALOG_HEIGHT_HALF = 300.0;

    public CustomDialog(String title, String message, double width, double height) {
        this.setTitle(title);
        this.setWidth(width);
        this.setHeight(height);
        this.setMessage(message);
    }

    public void createInformationDialog() {
        BorderPane root = new BorderPane();
        root.setBackground(this.setGradient(Color.rgb((int)118, (int)118, (int)118), Color.rgb((int)38, (int)38, (int)38)));
        VBox topLayout = new VBox();
        topLayout.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.rgb((int)84, (int)84, (int)84), CornerRadii.EMPTY, new Insets(2.0))}));
        topLayout.setAlignment(Pos.CENTER);
        VBox centerLayout = new VBox();
        centerLayout.setAlignment(Pos.CENTER);
        VBox bottomLayout = new VBox();
        bottomLayout.setAlignment(Pos.CENTER);
        Label lblTitle = this.makeLabel(this.getTitle());
        Label lblMessage = this.makeLabel(this.getMessage());
        Button btnOk = this.makeButton("OK");
        btnOk.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                CustomDialog.this.confirmClickListener.onClick();
            }
        });
        topLayout.getChildren().add((Object)lblTitle);
        centerLayout.getChildren().add((Object)lblMessage);
        bottomLayout.getChildren().add((Object)btnOk);
        root.setTop((Node)topLayout);
        root.setCenter((Node)centerLayout);
        root.setBottom((Node)bottomLayout);
        Scene scene = new Scene((Parent)root);
        this.stage = this.makeStage(scene, this.getTitle());
    }

    public void createActionDialog(String button1, String button2) {
        BorderPane root = new BorderPane();
        root.setBackground(this.setGradient(Color.rgb((int)118, (int)118, (int)118), Color.rgb((int)38, (int)38, (int)38)));
        VBox topLayout = new VBox();
        topLayout.setAlignment(Pos.CENTER);
        topLayout.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.rgb((int)84, (int)84, (int)84), CornerRadii.EMPTY, new Insets(2.0))}));
        VBox centerLayout = new VBox(10.0);
        centerLayout.setAlignment(Pos.CENTER);
        HBox bottomLayout = new HBox(10.0);
        bottomLayout.setAlignment(Pos.CENTER);
        Label lblTitle = this.makeLabel(this.getTitle());
        Label lblMessage = this.makeLabel(this.getMessage());
        Button btnOption1 = this.makeButton(button1);
        HBox.setMargin((Node)btnOption1, (Insets)new Insets(10.0));
        Button btnOption2 = this.makeButton(button2);
        HBox.setMargin((Node)btnOption2, (Insets)new Insets(10.0));
        btnOption1.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                CustomDialog.this.actionOneClickListener.onClick();
            }
        });
        btnOption2.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                CustomDialog.this.actionTwoClickListener.onClick();
            }
        });
        topLayout.getChildren().add((Object)lblTitle);
        centerLayout.getChildren().add((Object)lblMessage);
        bottomLayout.getChildren().addAll((Object[])new Node[]{btnOption1, btnOption2});
        root.setTop((Node)topLayout);
        root.setCenter((Node)centerLayout);
        root.setBottom((Node)bottomLayout);
        Scene scene = new Scene((Parent)root);
        this.stage = this.makeStage(scene, this.getTitle());
    }

    private Background setGradient(Color startColor, Color endColor) {
        Stop[] stops = new Stop[]{new Stop(0.0, startColor), new Stop(1.0, endColor)};
        LinearGradient linearGradient = new LinearGradient(0.0, 0.0, 0.0, 1.0, true, CycleMethod.NO_CYCLE, stops);
        BackgroundFill backgroundFill = new BackgroundFill((Paint)linearGradient, CornerRadii.EMPTY, new Insets(0.0));
        return new Background(new BackgroundFill[]{backgroundFill});
    }

    private DropShadow getShadow(Color color) {
        DropShadow dropShadow = new DropShadow();
        dropShadow.setOffsetX(0.0);
        dropShadow.setOffsetY(1.0);
        dropShadow.setColor(color);
        return dropShadow;
    }

    private Label makeLabel(String text) {
        Label lblMessage = new Label(text);
        lblMessage.setPadding(new Insets(10.0));
        lblMessage.setWrapText(true);
        lblMessage.setTextAlignment(TextAlignment.CENTER);
        lblMessage.setFont(Font.font((String)"Helvetica", (FontWeight)FontWeight.MEDIUM, (double)20.0));
        lblMessage.setTextFill((Paint)Color.WHITE);
        lblMessage.setEffect((Effect)this.getShadow(Color.rgb((int)0, (int)0, (int)0, (double)0.5)));
        return lblMessage;
    }

    private Button makeButton(String name) {
        Button button = new Button(name);
        button.setFont(Font.font((String)"Helvetica", (FontWeight)FontWeight.BOLD, (double)20.0));
        button.setTextFill((Paint)Color.INDIANRED);
        button.setEffect((Effect)this.getShadow(Color.rgb((int)0, (int)0, (int)0, (double)0.2)));
        button.setPadding(new Insets(10.0));
        button.setMinWidth(100.0);
        VBox.setMargin((Node)button, (Insets)new Insets(5.0));
        return button;
    }

    private Stage makeStage(Scene scene, String title) {
        Stage stage = new Stage();
        stage.setTitle(title);
        stage.setResizable(true);
        stage.setWidth(this.getWidth());
        stage.setHeight(this.getHeight());
        stage.initStyle(StageStyle.UNDECORATED);
        stage.initModality(Modality.APPLICATION_MODAL);
        stage.setScene(scene);
        return stage;
    }

    public void show() {
        this.stage.show();
    }

    public void close() {
        this.stage.close();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setConfirmClickListener(ConfirmClickListener confirmClickListener) {
        this.confirmClickListener = confirmClickListener;
    }

    public ConfirmClickListener getConfirmClickListener() {
        return this.confirmClickListener;
    }

    public ActionOnePerformed getActionOneClickListener() {
        return this.actionOneClickListener;
    }

    public void setActionOneClickListener(ActionOnePerformed actionOneClickListener) {
        this.actionOneClickListener = actionOneClickListener;
    }

    public ActionTwoPerformed getActionTwoClickListener() {
        return this.actionTwoClickListener;
    }

    public void setActionTwoClickListener(ActionTwoPerformed actionTwoClickListener) {
        this.actionTwoClickListener = actionTwoClickListener;
    }

    public static interface ActionTwoPerformed {
        public void onClick();
    }

    public static interface ActionOnePerformed {
        public void onClick();
    }

    public static interface ConfirmClickListener {
        public void onClick();
    }
}

