/*
 * Decompiled with CFR 0.152.
 */
package com.kodebot.friendlybot;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.ListView;

public class FileHelper {
    private String path;

    public FileHelper(String path) {
        this.path = path;
    }

    public void saveTwitterCredsToFile(String consumerKey, String consumerSecret) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.path));
            writer.write(consumerKey);
            writer.newLine();
            writer.write(consumerSecret);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getSavedConsumerKey() {
        String consumerKey = "";
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.path));
            try {
                consumerKey = bufferedReader.readLine();
                bufferedReader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return consumerKey;
    }

    public String getSavedConsumerSecret() {
        String consumerSecret = "";
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.path));
            try {
                bufferedReader.readLine();
                consumerSecret = bufferedReader.readLine();
                bufferedReader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return consumerSecret;
    }

    public void saveArrayFile(ArrayList<String> contents) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.path));
            for (String content : contents) {
                writer.write(content);
                writer.newLine();
            }
            System.out.println("File written to " + this.path);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadFileToView(ListView<String> lstContents, ArrayList<String> storedArrayData) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(this.path));
            while ((line = reader.readLine()) != null) {
                arrayList.add(line);
                storedArrayData.add(line);
            }
            reader.close();
            ObservableList list = FXCollections.observableArrayList(arrayList);
            lstContents.setItems(list);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public void readFileToArray(ArrayList<String> arrayList) {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(this.path));
            while ((line = reader.readLine()) != null) {
                arrayList.add(line);
            }
            reader.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }
}

