/*
 * Decompiled with CFR 0.152.
 */
package com.kodebot.friendlybot;

import com.kodebot.friendlybot.AppHelper;
import com.kodebot.friendlybot.CustomDialog;
import com.kodebot.friendlybot.Debugger;
import com.kodebot.friendlybot.FileHelper;
import com.kodebot.friendlybot.GetHelper;
import com.kodebot.friendlybot.Icon;
import com.kodebot.friendlybot.Output;
import com.kodebot.friendlybot.PostHelper;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.ResourceBundle;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Worker;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.text.Font;
import javafx.scene.web.WebView;
import javafx.stage.FileChooser;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterFactory;
import twitter4j.auth.AccessToken;
import twitter4j.auth.RequestToken;
import twitter4j.conf.ConfigurationBuilder;

public class Main
extends Application
implements Debugger {
    private WebView webView;
    private TextField txtWebViewUrl;
    private TextField txtPinCode;
    private Button btnConfirmPin;
    private Twitter twitter;
    private TwitterFactory twitterFactory;
    private GetHelper searchHelper;
    private RequestToken requestToken;
    private ListView<String> listViewSearchResult;
    private ListView<String> listViewFollowDisplay;
    private ListView<String> listViewMessages;
    private ProgressBar progressBar;
    private ArrayList<String> screenNameIds = new ArrayList();
    private ArrayList<String> atReplyUsers = new ArrayList();
    private ArrayList<String> postArrayData = new ArrayList();
    private ArrayList<String> customMessages = new ArrayList();
    private PostHelper postHelper;
    private TextArea txtFollowOutput;
    private TextArea textAreaSearchOutput;
    private HBox bottomLoginLayout;
    private TextField txtSearchQuery;
    private String twitterUsername = "not_loggedin";
    private TextField txtStartInterval;
    private TextField txtEndInterval;
    private Button btnLoadUsersToTweet;
    private TextField txtConsumerKey;
    private TextField txtConsumerSecret;
    private Label lblDataToSave;
    private ResourceBundle resourceBundle;
    private TabPane tabPane;
    private VBox loginLayout;
    private VBox searchLayout;
    private BorderPane followLayout;
    private BorderPane messagesRootContainer;
    private BorderPane configurationRootContainer;
    private ChoiceBox<String> searchOption;
    private Label lblIntervalTimeOption;
    private Icon iconHelper;
    private FileHelper configFile;
    Label lblFollowTitleMessage;
    Label lblNumberOfCustomMessages;
    private Button btnPostStart;
    private Button btnPostLoadFile;
    private Button btnPostStop;
    private Button btnPostClear;
    private ChoiceBox<String> postOptions;
    private Button btnGetStart;
    private static final int SMALL_TEXTFIELD_WIDTH = 60;
    private double screenWidth = 0.0;
    private double screenHeight = 0.0;

    public static void main(String[] args) throws Exception {
        Application.launch((String[])args);
    }

    public void start(Stage primaryStage) throws Exception {
        this.initHelpers();
        this.createUI(primaryStage);
        this.showPinUI(false);
    }

    private void initHelpers() {
        this.resourceBundle = ResourceBundle.getBundle("strings", Locale.getDefault());
        this.configFile = new FileHelper("config.txt");
        this.iconHelper = new Icon();
    }

    private void createUI(Stage stage) {
        this.setStageSettings(stage);
        BorderPane rootLayout = new BorderPane();
        rootLayout.setBackground(this.setGradient(AppHelper.APP_BACKGROUND, AppHelper.APP_BACKGROUND));
        Scene scene = new Scene((Parent)rootLayout);
        String cssFile = this.getClass().getResource("/style.css").toExternalForm();
        scene.getStylesheets().add((Object)cssFile);
        this.setUpLoginLayout();
        this.setUpSearchLayout(stage);
        this.setupPostSectionTab(stage);
        this.setUpMessagesTab(stage);
        this.setUpConfigurationTab(stage);
        this.createTabs();
        HBox topLayout = new HBox();
        HBox.setHgrow((Node)topLayout, (Priority)Priority.ALWAYS);
        rootLayout.setTop((Node)topLayout);
        rootLayout.setCenter((Node)this.tabPane);
        stage.setScene(scene);
        stage.show();
    }

    private String getString(String name) {
        return this.resourceBundle.getString(name);
    }

    private void createTabs() {
        Tab loginTab = this.createTab(this.getString("home"), (Parent)this.loginLayout, this.getString("home_tooltip"));
        loginTab.setGraphic((Node)this.iconHelper.getIconWithName("ic_home.png"));
        Tab searchTab = this.createTab(this.getString("grab"), (Parent)this.searchLayout, this.getString("search_tooltip"));
        searchTab.setGraphic((Node)this.iconHelper.getIconWithName("ic_get.png"));
        Tab followTab = this.createTab(this.getString("post"), (Parent)this.followLayout, this.getString("post_tooltip"));
        followTab.setGraphic((Node)this.iconHelper.getIconWithName("ic_post.png"));
        Tab messagesTab = this.createTab(this.getString("messages_creator"), (Parent)this.messagesRootContainer, this.getString("messages_creator_tooltip"));
        messagesTab.setGraphic((Node)this.iconHelper.getIconWithName("ic_messages.png"));
        Tab configTab = this.createTab(this.getString("configuration"), (Parent)this.configurationRootContainer, this.getString("configuration_tooltip"));
        configTab.setGraphic((Node)this.iconHelper.getIconWithName("ic_settings.png"));
        this.tabPane = new TabPane();
        this.tabPane.setId("tab-pane");
        this.tabPane.getTabs().addAll((Object[])new Tab[]{loginTab, searchTab, followTab, messagesTab, configTab});
    }

    private void setUpLoginLayout() {
        this.loginLayout = new VBox(5.0);
        this.txtWebViewUrl = new TextField();
        VBox.setMargin((Node)this.txtWebViewUrl, (Insets)new Insets(0.0, 20.0, 0.0, 20.0));
        this.loadWebView();
        this.bottomLoginLayout = new HBox(10.0);
        this.bottomLoginLayout.setAlignment(Pos.CENTER);
        this.bottomLoginLayout.setPadding(new Insets(10.0));
        this.bottomLoginLayout.setBackground(this.setGradient(Color.rgb((int)255, (int)210, (int)0), Color.rgb((int)255, (int)156, (int)0)));
        Label lblPinMessage = this.makeLabel(this.getString("enter_pin"), Color.BLACK, 22);
        this.txtPinCode = new TextField();
        this.txtPinCode.setMaxWidth(200.0);
        this.txtPinCode.setFont(this.getAppFont(18));
        this.btnConfirmPin = this.makeButton(this.getString("confirm_pin"));
        this.btnConfirmPin.setOnAction(e -> this.connectToTwitterApp());
        this.bottomLoginLayout.getChildren().addAll((Object[])new Node[]{lblPinMessage, this.txtPinCode, this.btnConfirmPin});
        this.loginLayout.getChildren().addAll((Object[])new Node[]{this.webView, this.txtWebViewUrl, this.progressBar, this.bottomLoginLayout});
    }

    private void setUpSearchLayout(final Stage stage) {
        this.searchLayout = new VBox(5.0);
        this.searchLayout.setPadding(new Insets(10.0));
        this.searchLayout.setAlignment(Pos.CENTER);
        this.txtSearchQuery = this.makeTextField(this.getString("enter_search_query"), 500.0, 60.0, 10);
        this.txtSearchQuery.setId("text-field-big");
        this.searchOption = this.makeChoiceBox();
        this.searchOption.getStyleClass().add((Object)"choice-box");
        this.searchOption.getItems().addAll((Object[])new String[]{this.getString("grab_users"), this.getString("get_following"), this.getString("get_followers"), this.getString("get_tweets"), this.getString("get_mentions"), this.getString("get_dms")});
        this.searchOption.getSelectionModel().selectFirst();
        this.searchOption.getSelectionModel().selectedIndexProperty().addListener(this::onSearchOptionChanged);
        this.btnGetStart = this.makeButton(this.getString("start"));
        this.btnGetStart.setId("btn-start");
        this.lblDataToSave = this.makeLabel(this.getString("data_save_opt1"), Color.WHITE, 18);
        this.lblDataToSave.setGraphic((Node)this.iconHelper.getIconWithName("ic_info.png"));
        VBox.setMargin((Node)this.lblDataToSave, (Insets)new Insets(10.0));
        HBox optionsLayout = new HBox(10.0, new Node[]{this.searchOption, this.btnGetStart});
        optionsLayout.setAlignment(Pos.CENTER);
        GridPane centerGridPane = new GridPane();
        centerGridPane.setAlignment(Pos.CENTER);
        centerGridPane.setPadding(new Insets(20.0));
        centerGridPane.setVgap(10.0);
        centerGridPane.setHgap(10.0);
        this.listViewSearchResult = new ListView();
        this.listViewSearchResult.setEffect((Effect)this.getShadow());
        this.listViewSearchResult.getStyleClass().add((Object)"list-view");
        this.listViewSearchResult.setMinHeight(100.0);
        this.listViewSearchResult.setMinWidth(300.0);
        this.textAreaSearchOutput = this.makeTextArea(100);
        this.textAreaSearchOutput.setMinWidth(300.0);
        Label lblOutput = this.makeLabel(this.getString("output"), Color.WHITE, 18);
        this.createLabelTitle(lblOutput);
        Label lblResult = this.makeLabel("Result", Color.WHITE, 18);
        this.createLabelTitle(lblResult);
        HBox searchListBottomLayout = new HBox(10.0);
        searchListBottomLayout.setAlignment(Pos.TOP_RIGHT);
        Button btnSaveToFile = this.makeButton("Save To File");
        btnSaveToFile.setId("btn-save");
        Button btnClearSearch = this.makeButton("Clear");
        btnClearSearch.setId("btn-clear");
        searchListBottomLayout.getChildren().addAll((Object[])new Node[]{btnSaveToFile, btnClearSearch});
        GridPane.setHalignment((Node)lblResult, (HPos)HPos.CENTER);
        GridPane.setHalignment((Node)lblOutput, (HPos)HPos.CENTER);
        centerGridPane.add((Node)lblResult, 0, 0);
        centerGridPane.add((Node)lblOutput, 1, 0);
        centerGridPane.add(this.listViewSearchResult, 0, 1);
        centerGridPane.add((Node)this.textAreaSearchOutput, 1, 1);
        centerGridPane.add((Node)searchListBottomLayout, 0, 2);
        this.searchLayout.getChildren().addAll((Object[])new Node[]{this.txtSearchQuery, optionsLayout, this.lblDataToSave, centerGridPane});
        btnSaveToFile.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (Main.this.searchHelper != null) {
                    Main.this.saveFile(Main.this.searchHelper.getFileName(), stage, Main.this.screenNameIds);
                }
            }
        });
        btnClearSearch.setOnAction(e -> this.clearList(1));
        this.btnGetStart.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                int choiceIndex = Main.this.searchOption.getSelectionModel().getSelectedIndex();
                String searchQuery = Main.this.txtSearchQuery.getText().trim();
                if (choiceIndex == 0 && searchQuery.length() <= 3) {
                    return;
                }
                Main.this.runGetOption(choiceIndex, searchQuery);
            }
        });
    }

    private void setupPostSectionTab(final Stage stage) {
        this.followLayout = new BorderPane();
        this.followLayout.setPadding(new Insets(20.0));
        GridPane gridPane = new GridPane();
        gridPane.setAlignment(Pos.CENTER);
        gridPane.setVgap(10.0);
        gridPane.setHgap(10.0);
        gridPane.setPadding(new Insets(10.0));
        gridPane.setMinWidth(this.screenWidth / 3.0);
        HBox mediumLayout = new HBox(5.0);
        mediumLayout.setPadding(new Insets(10.0));
        mediumLayout.setAlignment(Pos.TOP_RIGHT);
        this.btnPostLoadFile = this.makeButton(this.getString("load_user_list"));
        this.btnPostLoadFile.setId("btn-load-file");
        this.btnPostClear = this.makeButton(this.getString("clear_list"));
        this.btnPostClear.setId("btn-clear");
        mediumLayout.getChildren().addAll((Object[])new Node[]{this.btnPostLoadFile, this.btnPostClear});
        VBox centerLayout = new VBox(5.0);
        this.listViewFollowDisplay = new ListView();
        VBox.setMargin(this.listViewFollowDisplay, (Insets)new Insets(10.0));
        this.txtFollowOutput = new TextArea();
        this.txtFollowOutput.setStyle("-fx-background-color: gray; -fx-font-family: Courier; -fx-font-size: 16px;");
        VBox.setVgrow((Node)this.txtFollowOutput, (Priority)Priority.ALWAYS);
        VBox.setMargin((Node)this.txtFollowOutput, (Insets)new Insets(0.0, 10.0, 0.0, 10.0));
        Label lblOutput = this.makeLabel(this.getString("output"), Color.WHITE, 18);
        this.setMargin(1, (Parent)lblOutput, 10);
        centerLayout.getChildren().addAll((Object[])new Node[]{this.listViewFollowDisplay, mediumLayout, lblOutput, this.txtFollowOutput});
        HBox intervalBottom = new HBox(15.0);
        intervalBottom.setAlignment(Pos.CENTER);
        Label lblSelectOption = this.makeLabel("Select Option", Color.WHITE, 18);
        this.lblFollowTitleMessage = this.makeLabel(this.getString("post_opt_1"), Color.WHITE, 18);
        this.lblFollowTitleMessage.setGraphic((Node)this.iconHelper.getIconWithName("ic_info.png"));
        Label lblInterval = this.makeLabel("Interval", Color.WHITE, 18);
        lblInterval.setId("interval-icon");
        this.txtStartInterval = this.makeTextField("8", 60.0, 50.0, 0);
        this.txtStartInterval.setId("text-field-big");
        this.txtStartInterval.setText("8");
        this.txtEndInterval = this.makeTextField("12", 60.0, 50.0, 0);
        this.txtEndInterval.setText("12");
        this.txtEndInterval.setId("text-field-big");
        Label lblFollowType = this.makeLabel("Every", Color.WHITE, 18);
        Label lblIntervalStart = this.makeLabel("", Color.WHITESMOKE, 22);
        lblIntervalStart.setWrapText(true);
        lblIntervalStart.textProperty().bind((ObservableValue)this.txtStartInterval.textProperty());
        Label lblIntervalEnd = this.makeLabel("", Color.WHITESMOKE, 22);
        lblIntervalEnd.setWrapText(true);
        lblIntervalEnd.textProperty().bind((ObservableValue)this.txtEndInterval.textProperty());
        this.lblIntervalTimeOption = this.makeLabel("Minutes", Color.WHITE, 18);
        this.postOptions = new ChoiceBox();
        this.postOptions.setMaxHeight(70.0);
        this.postOptions.getItems().addAll((Object[])new String[]{"Follow", "Unfollow (1)", "Unfollow (2)", "Post Tweets", this.getString("post_at_replies"), "Delete Tweets"});
        this.postOptions.getSelectionModel().selectFirst();
        this.postOptions.getSelectionModel().selectedIndexProperty().addListener(this::selectedPostOption);
        this.btnPostStart = this.makeButton("Start");
        this.btnPostStart.setId("btn-start");
        this.btnLoadUsersToTweet = this.makeButton("Load Users");
        this.btnLoadUsersToTweet.setId("btn-load-users");
        this.btnPostStop = this.makeButton("Stop");
        this.btnPostStop.setId("btn-stop");
        this.disableButton(true, this.btnPostStop, "Stop");
        this.disableButton(true, this.btnLoadUsersToTweet, "...");
        HBox intervalMinutes = new HBox();
        intervalMinutes.setAlignment(Pos.CENTER);
        intervalMinutes.getChildren().addAll((Object[])new Node[]{lblFollowType, lblIntervalStart, this.makeLabel("and", Color.WHITE, 14), lblIntervalEnd, this.lblIntervalTimeOption});
        GridPane.setHalignment((Node)lblSelectOption, (HPos)HPos.RIGHT);
        GridPane.setHalignment((Node)this.lblFollowTitleMessage, (HPos)HPos.CENTER);
        GridPane.setHalignment((Node)lblInterval, (HPos)HPos.RIGHT);
        GridPane.setHalignment(this.postOptions, (HPos)HPos.RIGHT);
        GridPane.setHalignment((Node)this.btnLoadUsersToTweet, (HPos)HPos.LEFT);
        GridPane.setHalignment((Node)this.txtStartInterval, (HPos)HPos.RIGHT);
        GridPane.setHalignment((Node)this.btnPostStart, (HPos)HPos.RIGHT);
        GridPane.setHalignment((Node)intervalMinutes, (HPos)HPos.RIGHT);
        gridPane.add((Node)lblSelectOption, 0, 0);
        gridPane.add(this.postOptions, 1, 0);
        gridPane.add((Node)this.btnLoadUsersToTweet, 2, 0);
        gridPane.add((Node)lblInterval, 0, 1);
        gridPane.add((Node)this.txtStartInterval, 1, 1);
        gridPane.add((Node)this.txtEndInterval, 2, 1);
        gridPane.add((Node)intervalMinutes, 0, 2, 3, 1);
        gridPane.add((Node)this.btnPostStart, 1, 3);
        gridPane.add((Node)this.btnPostStop, 2, 3);
        gridPane.add((Node)this.lblFollowTitleMessage, 0, 4, 3, 1);
        this.btnPostLoadFile.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Main.this.readFileToView(stage, (ListView<String>)Main.this.listViewFollowDisplay, Main.this.postArrayData, 2);
            }
        });
        this.btnLoadUsersToTweet.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Main.this.openAndSaveToArray(stage, "Choose list of user to Tweet", Main.this.atReplyUsers, true);
            }
        });
        this.btnPostClear.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Main.this.clearList(2);
            }
        });
        this.btnPostStart.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            /*
             * Enabled aggressive block sorting
             */
            public void handle(ActionEvent event) {
                int currentSelection = Main.this.postOptions.getSelectionModel().getSelectedIndex();
                if (Main.this.postHelper == null) {
                    Main.this.showInfoDialog("Not logged in", Main.this.resourceBundle.getString("not_loggedin"));
                    return;
                }
                Main.this.postHelper.setPostOption(currentSelection);
                if (Main.this.postArrayData.size() < 1) {
                    Main.this.showInfoDialog("Empty", Main.this.resourceBundle.getString("follow_array_empty"));
                    return;
                }
                Main.this.postHelper.setMinimumInterval(Main.this.txtStartInterval);
                Main.this.postHelper.setMaximumInterval(Main.this.txtEndInterval);
                if (!Main.this.postHelper.isIntervalIsValid()) {
                    Main.this.showInfoDialog("Invalid Interval", Main.this.resourceBundle.getString("invalid_intervals"));
                    return;
                }
                if (currentSelection == 4 && Main.this.atReplyUsers.size() <= 0) {
                    Main.this.showInfoDialog(Main.this.getString("empty_at_users_title"), Main.this.getString("empty_at_users"));
                    return;
                }
                Main.this.postHelper.runScheduledOperation(currentSelection);
                Main.this.disablePostUI();
            }
        });
        this.btnPostStop.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (Main.this.postHelper != null) {
                    Main.this.restoreDisabledPostUI();
                    Main.this.postHelper.stopOperation();
                }
            }
        });
        this.followLayout.setCenter((Node)centerLayout);
        this.followLayout.setRight((Node)gridPane);
    }

    private void setUpMessagesTab(final Stage stage) {
        this.messagesRootContainer = new BorderPane();
        this.messagesRootContainer.setPadding(new Insets(10.0));
        VBox centerLayout = new VBox(10.0);
        centerLayout.setAlignment(Pos.CENTER);
        VBox rightLayout = new VBox(10.0);
        rightLayout.setAlignment(Pos.CENTER);
        rightLayout.setMaxWidth(this.screenWidth / 3.0);
        this.createVBoxModule(rightLayout);
        Label lblMessage = this.makeLabel("Enter your message", Color.WHITE, 20);
        this.createLabelTitle(lblMessage);
        final TextArea txtMessages = this.makeTextArea(100);
        txtMessages.setId("text-area");
        HBox charLayout = new HBox();
        charLayout.setAlignment(Pos.CENTER);
        Label lblCharCount = this.makeLabel("", Color.WHITE, 25);
        lblCharCount.textProperty().bind((ObservableValue)txtMessages.textProperty().length().asString());
        Label lblCharacters = this.makeLabel("Characters: ", Color.WHITE, 20);
        charLayout.getChildren().addAll((Object[])new Node[]{lblCharacters, lblCharCount});
        Button btnAddMessage = this.makeButton("Add");
        btnAddMessage.setId("btn-add");
        rightLayout.getChildren().addAll((Object[])new Node[]{lblMessage, txtMessages, charLayout, btnAddMessage});
        HBox bottomLayout = new HBox(10.0);
        bottomLayout.setPadding(new Insets(10.0));
        bottomLayout.setAlignment(Pos.CENTER_RIGHT);
        this.lblNumberOfCustomMessages = this.makeLabel("Number of messages: 0", Color.WHITE, 20);
        this.lblNumberOfCustomMessages.setPadding(new Insets(10.0));
        this.listViewMessages = new ListView();
        this.listViewMessages.setEffect((Effect)this.getShadow());
        this.setMargin(1, (Parent)this.listViewMessages, 10);
        Button btnLoadFile = this.makeButton("Load Messages");
        btnLoadFile.setId("btn-load-file");
        Button btnClear = this.makeButton("Clear List");
        btnClear.setId("btn-clear");
        Button btnSaveFile = this.makeButton("Save List");
        btnSaveFile.setId("btn-save");
        bottomLayout.getChildren().addAll((Object[])new Node[]{btnLoadFile, btnClear, btnSaveFile});
        centerLayout.getChildren().addAll((Object[])new Node[]{this.lblNumberOfCustomMessages, this.listViewMessages, bottomLayout});
        btnAddMessage.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                String message = txtMessages.getText();
                if (message.length() < 1) {
                    return;
                }
                this.addCustomMessage(message);
            }

            private void addCustomMessage(String message) {
                Main.this.customMessages.add(message);
                ObservableList obs = FXCollections.observableArrayList((Collection)Main.this.customMessages);
                Main.this.listViewMessages.setItems(obs);
                Main.this.lblNumberOfCustomMessages.setText(Main.this.getString("number_of_messages") + ": " + Main.this.customMessages.size());
            }
        });
        btnLoadFile.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Main.this.readFileToView(stage, (ListView<String>)Main.this.listViewMessages, Main.this.customMessages, 3);
            }
        });
        btnSaveFile.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Main.this.saveFile("Custom_Messages", stage, Main.this.customMessages);
            }
        });
        btnClear.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Main.this.clearList(3);
            }
        });
        this.messagesRootContainer.setCenter((Node)centerLayout);
        this.messagesRootContainer.setRight((Node)rightLayout);
    }

    private void setUpConfigurationTab(Stage stage) {
        this.configurationRootContainer = new BorderPane();
        this.configurationRootContainer.setPadding(new Insets(10.0));
        GridPane gridPane = new GridPane();
        gridPane.setAlignment(Pos.CENTER);
        gridPane.setVgap(10.0);
        gridPane.setHgap(10.0);
        Label lblConsumeKey = this.makeLabel("Consumer Key", Color.WHITE, 20);
        Label lblConsumerSecret = this.makeLabel("Consumer Secret", Color.WHITE, 20);
        this.txtConsumerKey = this.makeTextField("Consumer Key", 700.0, 70.0, 10);
        this.txtConsumerKey.setText(this.configFile.getSavedConsumerKey());
        this.txtConsumerKey.setEditable(false);
        this.txtConsumerKey.setId("text-field-big");
        this.txtConsumerSecret = this.makeTextField("Consumer Secret", 700.0, 70.0, 10);
        this.txtConsumerSecret.setText(this.configFile.getSavedConsumerSecret());
        this.txtConsumerSecret.setEditable(false);
        this.txtConsumerSecret.setId("text-field-big");
        final Button btnSaveConfig = this.makeButton("Save");
        btnSaveConfig.setId("btn-save");
        btnSaveConfig.setDisable(true);
        Button btnEditConfig = this.makeButton("Edit");
        btnEditConfig.setId("btn-edit");
        Button btnConnect = this.makeButton("Connect to Twitter");
        btnConnect.setId("btn-twitter-connect");
        btnEditConfig.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Main.this.txtConsumerKey.setEditable(true);
                Main.this.txtConsumerSecret.setEditable(true);
                btnSaveConfig.setDisable(false);
            }
        });
        btnSaveConfig.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                String consumerKey = Main.this.txtConsumerKey.getText().trim();
                String consumerSecret = Main.this.txtConsumerSecret.getText().trim();
                if (consumerKey.length() <= 5 || consumerSecret.length() <= 5) {
                    Main.this.showInfoDialog("Invalid Information", Main.this.getString("error_consumer_empty"));
                    Main.this.txtConsumerKey.setText(Main.this.configFile.getSavedConsumerKey());
                    Main.this.txtConsumerSecret.setText(Main.this.configFile.getSavedConsumerSecret());
                    return;
                }
                Main.this.twitter = null;
                Main.this.configFile.saveTwitterCredsToFile(consumerKey, consumerSecret);
                Main.this.buildTwitterConfiguration();
                Main.this.txtConsumerKey.setEditable(false);
                Main.this.txtConsumerSecret.setEditable(false);
                btnSaveConfig.setDisable(true);
            }
        });
        btnConnect.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (Main.this.twitter == null) {
                    if (!Main.this.requestToken()) {
                        Main.this.showInfoDialog("Error", Main.this.getString("error_consumer_empty"));
                        return;
                    }
                    if (!btnSaveConfig.isDisabled()) {
                        Main.this.showInfoDialog("Oops!", "You are in EDIT mode, please click SAVE Button before continuing");
                        return;
                    }
                    Main.this.tabPane.getSelectionModel().select(0);
                } else {
                    Main.this.tabPane.getSelectionModel().select(0);
                }
            }
        });
        gridPane.add((Node)btnEditConfig, 1, 0);
        GridPane.setHalignment((Node)btnEditConfig, (HPos)HPos.RIGHT);
        gridPane.add((Node)lblConsumeKey, 0, 1);
        gridPane.add((Node)lblConsumerSecret, 0, 2);
        gridPane.add((Node)this.txtConsumerKey, 1, 1);
        gridPane.add((Node)this.txtConsumerSecret, 1, 2);
        GridPane.setHalignment((Node)btnSaveConfig, (HPos)HPos.RIGHT);
        gridPane.add((Node)btnSaveConfig, 1, 3);
        gridPane.add((Node)btnConnect, 1, 4);
        this.configurationRootContainer.setCenter((Node)gridPane);
    }

    private void setMargin(int type, Parent view, int margin) {
        if (type == 1) {
            VBox.setMargin((Node)view, (Insets)new Insets((double)margin));
        } else {
            HBox.setMargin((Node)view, (Insets)new Insets((double)margin));
        }
    }

    private void clearList(final int option) {
        if (option == 1 && this.searchHelper == null) {
            return;
        }
        final CustomDialog dialog = new CustomDialog("Delete List", this.resourceBundle.getString("delete_list_msg"), 500.0, 300.0);
        dialog.createActionDialog("Yes", "Cancel");
        dialog.setActionOneClickListener(new CustomDialog.ActionOnePerformed(){

            @Override
            public void onClick() {
                if (option == 1) {
                    Main.this.searchHelper.setSearched(false);
                    Main.this.clearSearchedData();
                } else if (option == 2) {
                    Main.this.clearPostData();
                } else if (option == 3) {
                    Main.this.clearMessagesData();
                }
                dialog.close();
            }
        });
        dialog.setActionTwoClickListener(new CustomDialog.ActionTwoPerformed(){

            @Override
            public void onClick() {
                dialog.close();
            }
        });
        dialog.show();
    }

    private void clearPostData() {
        if (this.postHelper != null) {
            this.postHelper.clear();
        } else {
            this.postArrayData.clear();
            this.listViewFollowDisplay.setItems(null);
        }
    }

    private void clearSearchedData() {
        if (this.screenNameIds.size() >= 1) {
            this.screenNameIds.clear();
            this.listViewSearchResult.setItems(null);
        }
    }

    private void clearMessagesData() {
        if (this.customMessages.size() >= 1) {
            this.customMessages.clear();
            this.listViewMessages.setItems(null);
            this.lblNumberOfCustomMessages.setText("");
        }
    }

    private void enableTextField(TextField textField, boolean value) {
        textField.setEditable(value);
    }

    private void onSearchOptionChanged(ObservableValue<? extends Number> observableValue, Number oldValue, Number newValue) {
        int selected = (Integer)newValue;
        this.onGrabOptionSelected(selected);
    }

    private void selectedPostOption(ObservableValue<? extends Number> observableValue, Number oldValue, Number newValue) {
        int selected = (Integer)newValue;
        this.onPostOptionSelected(selected);
    }

    private void onGrabOptionSelected(int option) {
        String msgOption = option == 1 ? "Get users you follow" : "Get users that follow you";
        String textFieldTextMsg = null;
        if (option == 1) {
            textFieldTextMsg = msgOption;
            this.txtSearchQuery.setDisable(true);
            this.lblDataToSave.setText(this.getString("data_save_opt2"));
            this.setFileName("my_friends_userIds");
        } else if (option == 2) {
            textFieldTextMsg = msgOption;
            this.txtSearchQuery.setDisable(true);
            this.lblDataToSave.setText(this.getString("data_save_opt3"));
            this.setFileName("my_followers_userIds");
        } else if (option == 3) {
            textFieldTextMsg = "Get all tweets from @" + this.twitterUsername;
            this.txtSearchQuery.setDisable(true);
            this.lblDataToSave.setText(this.getString("data_save_opt4"));
            this.setFileName("my_tweets");
        } else if (option == 4) {
            textFieldTextMsg = "Get all mentions of @" + this.twitterUsername;
            this.txtSearchQuery.setDisable(true);
            this.lblDataToSave.setText(this.getString("data_save_opt5"));
            this.setFileName("my_mentions");
        } else if (option == 5) {
            textFieldTextMsg = "Get all DMs sent to @" + this.twitterUsername;
            this.txtSearchQuery.setDisable(true);
            this.lblDataToSave.setText(this.getString("data_save_opt6"));
            this.setFileName("my_direct_messages");
        } else {
            textFieldTextMsg = "";
            this.txtSearchQuery.setDisable(false);
            this.lblDataToSave.setText(this.getString("data_save_opt1"));
            this.setFileName("random_userIds");
        }
        this.txtSearchQuery.setText(textFieldTextMsg);
    }

    private void setFileName(String fileName) {
        if (this.searchHelper != null) {
            this.searchHelper.setFileName(fileName);
        }
    }

    private void onPostOptionSelected(int option) {
        String unfollowTitle;
        String string = unfollowTitle = option == 1 ? this.getString("post_opt_2") : this.getString("post_opt_3");
        if (option == 1 || option == 2) {
            this.txtStartInterval.setText("1");
            this.txtEndInterval.setText("2");
            this.lblFollowTitleMessage.setText(unfollowTitle);
            this.lblIntervalTimeOption.setText("Minutes");
            this.disableButton(true, this.btnLoadUsersToTweet, "...");
            this.btnPostLoadFile.setText(this.getString("load_userIds"));
        } else if (option == 3) {
            this.txtStartInterval.setText("8");
            this.txtEndInterval.setText("12");
            this.lblFollowTitleMessage.setText(this.getString("post_opt_4"));
            this.lblIntervalTimeOption.setText("Minutes");
            this.disableButton(true, this.btnLoadUsersToTweet, "...");
            this.btnPostLoadFile.setText(this.getString("load_messages_list"));
        } else if (option == 4) {
            this.txtStartInterval.setText("8");
            this.txtEndInterval.setText("12");
            this.lblFollowTitleMessage.setText(this.getString("post_opt_5"));
            this.lblIntervalTimeOption.setText("Minutes");
            this.disableButton(false, this.btnLoadUsersToTweet, this.getString("load_users"));
            this.btnPostLoadFile.setText(this.getString("load_messages_list"));
        } else if (option == 5) {
            this.txtStartInterval.setText("15");
            this.txtEndInterval.setText("30");
            this.lblFollowTitleMessage.setText(this.getString("post_opt_6"));
            this.lblIntervalTimeOption.setText("Seconds");
            this.disableButton(true, this.btnLoadUsersToTweet, "...");
            this.btnPostLoadFile.setText(this.getString("load_messages_list"));
        } else {
            this.lblFollowTitleMessage.setText(this.getString("post_opt_1"));
            this.txtStartInterval.setText("8");
            this.txtEndInterval.setText("12");
            this.lblIntervalTimeOption.setText("Minutes");
            this.disableButton(true, this.btnLoadUsersToTweet, "...");
            this.btnPostLoadFile.setText(this.getString("load_userIds"));
        }
    }

    private TextField makeTextField(String placeholder, double width, double height, int margin) {
        TextField textField = new TextField();
        textField.setPromptText(placeholder);
        textField.setEffect((Effect)this.getShadow());
        textField.setMinWidth(width);
        textField.setMaxWidth(width);
        textField.setMinHeight(height);
        VBox.setMargin((Node)textField, (Insets)new Insets((double)margin));
        return textField;
    }

    private TextArea makeTextArea(int maxHeight) {
        TextArea textArea = new TextArea();
        textArea.setMinHeight((double)maxHeight);
        textArea.setEffect((Effect)this.getShadow());
        return textArea;
    }

    private void setUpPostHelper(String me) {
        this.postHelper = new PostHelper();
        this.postHelper.setMainListArray(this.postArrayData);
        this.postHelper.setAtReplyUsersArray(this.atReplyUsers);
        this.postHelper.setMainListView(this.listViewFollowDisplay);
        this.postHelper.configure(3000, this.twitter, me);
        this.postHelper.setTxtOutput(this.txtFollowOutput);
    }

    private void setUpSearchHelper(Twitter twitter, String oAuthAccessToken) {
        this.searchHelper = new GetHelper(twitter, oAuthAccessToken);
        this.searchHelper.setTextAreaOutput(this.textAreaSearchOutput);
        this.searchHelper.setFileName("random_userIds");
    }

    private Tab createTab(String title, Parent parent, String tooltip) {
        Tab tab = new Tab(title);
        tab.setContent((Node)parent);
        tab.setStyle("-fx-focus-color: transparent; -fx-padding: 10px; -fx-font-family: Helevtica; -fx-font-size: 16px;");
        tab.setTooltip(new Tooltip(tooltip));
        tab.setClosable(false);
        return tab;
    }

    private void runGetOption(int option, String keyword) {
        Runnable task = () -> this.grab(option, keyword);
        Thread backgroundThread = new Thread(task);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    private void grab(int option, String keyword) {
        if (this.searchHelper != null) {
            try {
                if (this.searchHelper.isSearched()) {
                    this.showInfoDialog("Clear", this.resourceBundle.getString("search_list_nonempty"));
                    this.searchHelper.setSearched(false);
                    return;
                }
                this.disableButton(true, this.btnGetStart, "Searching...");
                this.searchHelper.searchOrGrab(keyword, option);
            }
            catch (TwitterException e) {
                return;
            }
        } else {
            this.showInfoDialog("Not Connected!", this.resourceBundle.getString("not_loggedin"));
            return;
        }
        if (this.searchHelper.getTweets() != null && this.searchHelper.getUserIds() != null && this.searchHelper.getTweets().size() >= 1) {
            ObservableList obsList = FXCollections.observableArrayList(this.searchHelper.getTweets());
            this.listViewSearchResult.setItems(obsList);
            this.screenNameIds = this.searchHelper.getUserIds();
        }
        this.disableButton(false, this.btnGetStart, "Start");
    }

    private void disableButton(final boolean disabled, final Button button, final String text) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                button.setDisable(disabled);
                button.setText(text);
            }
        });
    }

    private void loadWebView() {
        this.webView = new WebView();
        this.webView.setEffect((Effect)this.getShadow());
        VBox.setMargin((Node)this.webView, (Insets)new Insets(30.0, 20.0, 0.0, 20.0));
        VBox.setVgrow((Node)this.webView, (Priority)Priority.ALWAYS);
        this.progressBar = new ProgressBar();
        this.progressBar.setMaxWidth(Double.MAX_VALUE);
        this.progressBar.progressProperty().bind((ObservableValue)this.webView.getEngine().getLoadWorker().progressProperty());
        this.webView.getEngine().getLoadWorker().stateProperty().addListener((obs, oldValue, newValue) -> {
            if (newValue == Worker.State.SUCCEEDED) {
                this.txtWebViewUrl.setText(this.webView.getEngine().getLocation());
                if (this.webView.getEngine().getLocation().equals("https://api.twitter.com/oauth/authorize")) {
                    this.showPinUI(true);
                }
            }
        });
        URL localUrl = this.getClass().getResource("/start.html");
        this.webView.getEngine().load(localUrl.toExternalForm());
    }

    private boolean requestToken() {
        this.buildTwitterConfiguration();
        this.twitter = this.twitterFactory.getInstance();
        try {
            this.requestToken = this.twitter.getOAuthRequestToken();
            this.print("Obtained requestToken: " + this.requestToken);
            this.webView.getEngine().load(this.requestToken.getAuthorizationURL());
            this.print("Loading Auth URL: " + this.requestToken.getAuthorizationURL());
            return true;
        }
        catch (Exception e) {
            this.print(e.getMessage());
            this.twitter = null;
            return false;
        }
    }

    private void buildTwitterConfiguration() {
        this.twitterFactory = new TwitterFactory(this.getConfiguration().build());
    }

    private void connectToTwitterApp() {
        String pin = this.txtPinCode.getText().trim();
        AccessToken accessToken = null;
        if (this.twitter != null && this.requestToken != null) {
            try {
                accessToken = pin.length() > 0 ? this.twitter.getOAuthAccessToken(this.requestToken, pin) : this.twitter.getOAuthAccessToken();
                if (accessToken.getToken().length() > 1) {
                    this.webView.getEngine().load("http://www.twitter.com");
                    String me = this.twitter.getId() + "";
                    this.twitterUsername = this.twitter.getAccountSettings().getScreenName();
                    String oAuthAccessToken = this.twitter.getOAuthAccessToken().getToken();
                    this.setUpPostHelper(me);
                    this.setUpSearchHelper(this.twitter, oAuthAccessToken);
                    this.searchHelper.setLoggedInUser(this.twitterUsername);
                    this.showInfoDialog("Successfully Connected!", "Hello @" + this.twitterUsername + this.resourceBundle.getString("connected_successfully"));
                    this.showPinUI(false);
                }
                this.showInfoDialog("Error", this.resourceBundle.getString("not_authenticated"));
                this.twitter = null;
            }
            catch (Exception e) {
                this.print("Check this error " + e.getMessage());
                this.showInfoDialog("Error", this.resourceBundle.getString("invalid_pin"));
                this.twitter = null;
                return;
            }
        } else {
            this.showInfoDialog("Error", this.resourceBundle.getString("retry_request_token"));
            this.requestToken();
        }
    }

    private void setStageSettings(Stage stage) {
        Screen primaryScreen = Screen.getPrimary();
        this.screenWidth = primaryScreen.getVisualBounds().getWidth();
        this.screenHeight = primaryScreen.getVisualBounds().getHeight();
        stage.setTitle("FriendlyBot V.10");
        stage.setWidth(this.screenWidth - 200.0);
        stage.setHeight(this.screenHeight - 100.0);
    }

    private void restoreDisabledPostUI() {
        this.enableTextField(this.txtStartInterval, true);
        this.enableTextField(this.txtEndInterval, true);
        this.disableButton(false, this.btnPostStart, "Start");
        this.disableButton(false, this.btnPostLoadFile, "Load File");
        this.disableButton(true, this.btnPostStop, "Stop");
        this.disableButton(false, this.btnPostClear, "Clear");
        this.postOptions.setDisable(false);
        if (this.postOptions.getSelectionModel().getSelectedIndex() == 4) {
            this.disableButton(false, this.btnLoadUsersToTweet, this.getString("load_users"));
        }
    }

    private void createVBoxModule(VBox container) {
        container.setBackground(this.setGradient(AppHelper.APP_MODULE, AppHelper.APP_MODULE));
        container.setPadding(new Insets(10.0));
        container.setEffect((Effect)this.getShadow());
    }

    private void createLabelTitle(Label label) {
        label.setBackground(this.setGradient(AppHelper.APP_BACKGROUND_DARKER, AppHelper.APP_BACKGROUND_DARKER));
        label.setEffect((Effect)this.getShadow());
    }

    private void disablePostUI() {
        this.enableTextField(this.txtStartInterval, false);
        this.enableTextField(this.txtEndInterval, false);
        this.disableButton(true, this.btnPostStart, "Running...");
        this.disableButton(false, this.btnPostStop, "Stop");
        this.disableButton(true, this.btnPostLoadFile, "...");
        this.disableButton(true, this.btnPostClear, "...");
        this.disableButton(true, this.btnLoadUsersToTweet, "...");
        this.postOptions.setDisable(true);
    }

    private ConfigurationBuilder getConfiguration() {
        FileHelper fileHelper = new FileHelper("config.txt");
        ConfigurationBuilder confBuilder = new ConfigurationBuilder();
        confBuilder.setDebugEnabled(true);
        confBuilder.setOAuthConsumerKey(fileHelper.getSavedConsumerKey());
        confBuilder.setOAuthConsumerSecret(fileHelper.getSavedConsumerSecret());
        confBuilder.setOAuthAccessToken(null);
        confBuilder.setOAuthAccessTokenSecret(null);
        return confBuilder;
    }

    private Label makeLabel(String title, Color color, int size) {
        Label label = new Label(title);
        label.setFont(this.getAppFont(size));
        label.setPadding(new Insets(10.0));
        label.setTextFill((Paint)color);
        label.setWrapText(true);
        return label;
    }

    private Button makeButton(String name) {
        Button button = new Button(name);
        button.setMinWidth(100.0);
        button.setMinHeight(50.0);
        button.getStyleClass().add((Object)"button");
        return button;
    }

    private ChoiceBox<String> makeChoiceBox() {
        ChoiceBox choiceBox = new ChoiceBox();
        choiceBox.setMaxHeight(50.0);
        return choiceBox;
    }

    private void showPinUI(boolean show) {
        this.bottomLoginLayout.setVisible(show);
        this.txtPinCode.setText("");
    }

    private Font getAppFont(int size) {
        Font font = new Font("Helvetica", (double)size);
        return font;
    }

    private DropShadow getShadow() {
        DropShadow dropShadow = new DropShadow();
        dropShadow.setOffsetX(1.0);
        dropShadow.setOffsetY(1.0);
        dropShadow.setColor(Color.rgb((int)0, (int)0, (int)0, (double)0.2));
        return dropShadow;
    }

    private Background setGradient(Color startColor, Color endColor) {
        Stop[] stops = new Stop[]{new Stop(0.0, startColor), new Stop(1.0, endColor)};
        LinearGradient linearGradient = new LinearGradient(0.0, 0.0, 0.0, 1.0, true, CycleMethod.NO_CYCLE, stops);
        BackgroundFill backgroundFill = new BackgroundFill((Paint)linearGradient, CornerRadii.EMPTY, new Insets(0.0));
        return new Background(new BackgroundFill[]{backgroundFill});
    }

    private void saveFile(String fileName, Stage stage, ArrayList<String> contents) {
        if (contents.size() <= 0) {
            this.showInfoDialog("Empty List", this.getString("empty_list_message"));
        } else {
            long milis = System.currentTimeMillis();
            FileChooser fileChooser = new FileChooser();
            fileChooser.setTitle("Save File");
            fileChooser.setInitialFileName(fileName + "_" + milis + ".txt");
            File file = fileChooser.showSaveDialog((Window)stage);
            if (file != null) {
                FileHelper fileHelper = new FileHelper(file.getAbsolutePath());
                fileHelper.saveArrayFile(contents);
            }
        }
    }

    private void readFileToView(Stage stage, ListView<String> listView, ArrayList<String> arrayList, int option) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Choose File");
        File file = fileChooser.showOpenDialog((Window)stage);
        if (file != null) {
            arrayList.clear();
            FileHelper fileHelper = new FileHelper(file.getAbsolutePath());
            fileHelper.loadFileToView(listView, arrayList);
            if (option == 2) {
                this.writeOutput("File: " + file.getName() + " loaded with " + arrayList.size() + " records");
            } else if (option == 3) {
                this.lblNumberOfCustomMessages.setText(this.getString("number_of_messages") + ": " + arrayList.size());
            }
        }
    }

    private void openAndSaveToArray(Stage stage, String title, ArrayList<String> arrayList, boolean showOutput) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(title);
        File file = fileChooser.showOpenDialog((Window)stage);
        if (file != null) {
            arrayList.clear();
            FileHelper fileHelper = new FileHelper(file.getAbsolutePath());
            fileHelper.readFileToArray(arrayList);
            if (showOutput) {
                this.writeOutput("You added " + arrayList.size() + " users");
            }
        }
    }

    private void writeOutput(String text) {
        Output output = new Output(this.txtFollowOutput);
        output.write(text);
        output.display();
    }

    private void showInfoDialog(final String title, final String message) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                final CustomDialog dialog = new CustomDialog(title, message, 500.0, 300.0);
                dialog.setConfirmClickListener(new CustomDialog.ConfirmClickListener(){

                    @Override
                    public void onClick() {
                        dialog.close();
                    }
                });
                dialog.createInformationDialog();
                dialog.show();
            }
        });
    }

    @Override
    public void print(String message) {
        System.out.println("Main.class: " + message);
    }
}

