/*
 * Decompiled with CFR 0.152.
 */
package com.kodebot.friendlybot;

import com.kodebot.friendlybot.AppHelper;
import com.kodebot.friendlybot.Option;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.TimerTask;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.ListView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import twitter4j.JSONException;
import twitter4j.JSONObject;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.User;

public class PostHelper {
    private ArrayList<String> listArray;
    private ArrayList<String> atReplyUsersArray;
    private ListView<String> mainListView;
    private TimerTask timerTask;
    private Timer timer;
    private long delay;
    private int randomIndex;
    private TextArea txtOutput;
    private Twitter twitterInstance;
    private ResourceBundle resources = ResourceBundle.getBundle("strings", Locale.getDefault());
    private String loggedinScreenName;
    private String loggedInUserId;
    private int randomInterval;
    private int startInterval;
    private int endInterval;
    private int minimumIntervalMinutes;
    private int maximumIntervalMinutes;
    private int postOption;
    private static final int MINUTE_IN_MILLIS = 60000;
    private static final int SECONDS_IN_MILLIS = 1000;
    private static final int MAX_FOLLOWERS = 2000;
    private static final int MAX_CHARS = 140;

    public void configure(int delay, Twitter twitter, String meUserId) {
        this.setDelay(delay);
        this.setTwitterInstance(twitter);
        this.setLoggedInUserId(meUserId);
    }

    public void runScheduledOperation(final int option) {
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                PostHelper.this.runOperationWithOption(option);
            }
        };
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate(this.timerTask, this.getDelay(), (long)this.getRandomInterval());
        this.showOutput(this.getTxtOutput(), AppHelper.getDate() + " - " + Option.postOptionStr(option) + " operation will start in: " + this.getSeconds(this.getDelay()) + " seconds");
    }

    private void runOperationWithOption(int option) {
        if (this.getTwitterInstance() != null) {
            this.setRandomIndex(this.getRandomInt(0, this.getMainListArray().size() - 1));
            String targetDataStr = this.getMainListArray().get((int)this.getRandomIndex());
            JSONObject friendship = null;
            boolean friend = false;
            boolean follower = false;
            String targetScreenName = null;
            int randomIndexAtReplies = 0;
            String atUserIds = null;
            if (option == 3) {
                this.postTweet(targetDataStr);
            } else if (option == 4) {
                randomIndexAtReplies = this.getRandomInt(0, this.getAtReplyUsersArray().size() - 1);
                atUserIds = this.getAtReplyUsersArray().get(randomIndexAtReplies);
                this.postAtReplies(atUserIds, targetDataStr);
            } else {
                long target = Long.valueOf(targetDataStr);
                long source = Long.valueOf(this.getLoggedInUserId());
                if (option == 0 || option == 1 || option == 2) {
                    friendship = this.getTwitterFriendship(source, target);
                    try {
                        friend = friendship.getBoolean("sourceFollowingTarget");
                        follower = friendship.getBoolean("targetFollowingSource");
                        targetScreenName = "@" + friendship.getString("targetUserScreenName");
                        System.out.println("Information: \nTarget: " + targetScreenName + "\nFollows me: " + follower + "\nI follow: " + friend);
                    }
                    catch (JSONException e) {
                        this.showOutput(this.getTxtOutput(), "En error has occurred, please stop the operation and try again");
                    }
                }
                if (option == 0) {
                    this.follow(source, target, targetScreenName, friend);
                }
                if (option == 1) {
                    this.unfollowAll(target, targetScreenName, friend);
                }
                if (option == 2) {
                    this.unfollowNotFollowing(target, targetScreenName, follower, friend);
                }
                if (option == 5) {
                    this.deleteTweet(target);
                }
            }
            if (option == 4) {
                this.getAtReplyUsersArray().remove(randomIndexAtReplies);
            } else {
                this.getMainListArray().remove((int)this.getRandomIndex());
                this.reloadUIListView();
            }
            this.checkStatus(option);
        } else {
            this.showOutput(this.getTxtOutput(), this.resources.getString("not_authenticated"));
            this.stopOperation();
        }
    }

    private void checkStatus(int option) {
        if (option == 4) {
            if (this.getAtReplyUsersArray().size() <= 0) {
                this.stopOperation();
            }
        } else if (this.getMainListArray().size() <= 0) {
            this.stopOperation();
        }
    }

    private JSONObject getTwitterFriendship(long source, long target) {
        JSONObject friendship = null;
        try {
            friendship = new JSONObject(this.getTwitterInstance().showFriendship(source, target));
        }
        catch (TwitterException e) {
            this.showErrorMessage(e.getErrorMessage());
        }
        return friendship;
    }

    private void deleteTweet(long target) {
        try {
            this.getTwitterInstance().destroyStatus(target);
        }
        catch (TwitterException e) {
            this.showErrorMessage(e.getErrorMessage());
        }
        this.showOutput(this.getTxtOutput(), AppHelper.getDate() + " Deleted Tweet with ID " + target + " Left: " + (this.getMainListArray().size() - 1));
    }

    private void postTweet(String tweet) {
        try {
            this.getTwitterInstance().updateStatus(tweet);
        }
        catch (TwitterException e) {
            this.showErrorMessage(e.getErrorMessage());
        }
        this.showOutput(this.getTxtOutput(), AppHelper.getDate() + " Tweet Posted: " + tweet + " Left: " + (this.getMainListArray().size() - 1));
    }

    private void postAtReplies(String userId, String tweet) {
        try {
            long id = Long.parseLong(userId);
            User user = this.getTwitterInstance().showUser(id);
            String reply = "@" + user.getScreenName() + " " + tweet;
            if (reply.length() > 140) {
                this.showOutput(this.getTxtOutput(), "Message: " + reply + "\nhas " + reply.length() + " characters, it's too long.");
            } else {
                this.getTwitterInstance().updateStatus(reply);
                this.showOutput(this.getTxtOutput(), AppHelper.getDate() + " @ Reply Posted: " + reply + " Left: " + (this.getAtReplyUsersArray().size() - 1));
            }
        }
        catch (TwitterException e) {
            this.showErrorMessage(e.getErrorMessage());
        }
    }

    private void follow(long source, long target, String targetScreenName, boolean friend) {
        String output;
        if (!friend) {
            if (!this.followingIsBalanced(source)) {
                String string = this.resources.getString("following_alert");
            }
            try {
                this.getTwitterInstance().createFriendship(target);
            }
            catch (TwitterException e) {
                this.showErrorMessage(e.getErrorMessage());
            }
            output = AppHelper.getDate() + " Followed user: " + targetScreenName + " left: " + (this.getMainListArray().size() - 1);
        } else {
            output = "You already follow: " + targetScreenName + " Left: " + (this.getMainListArray().size() - 1);
        }
        this.showOutput(this.getTxtOutput(), output);
    }

    private void unfollowAll(long target, String targetScreenName, boolean friend) {
        String output;
        if (friend) {
            try {
                this.getTwitterInstance().destroyFriendship(target);
            }
            catch (TwitterException e) {
                this.showErrorMessage(e.getErrorMessage());
            }
            output = AppHelper.getDate() + " Unfollowed user: " + targetScreenName + " Left: " + (this.getMainListArray().size() - 1);
        } else {
            output = AppHelper.getDate() + " You are not following " + targetScreenName;
        }
        this.showOutput(this.getTxtOutput(), output);
    }

    private void unfollowNotFollowing(long target, String targetScreenName, boolean follower, boolean friend) {
        String output = "";
        if (!follower) {
            try {
                this.getTwitterInstance().destroyFriendship(target);
            }
            catch (TwitterException e) {
                this.showErrorMessage(e.getErrorMessage());
            }
            output = AppHelper.getDate() + " Unfollowed " + targetScreenName + ", user wasn't a follower. Left: " + (this.getMainListArray().size() - 1);
        } else {
            output = !follower && !friend ? AppHelper.getDate() + targetScreenName + " wasn't a follower and you were not following either" : AppHelper.getDate() + " " + targetScreenName + " is following you.";
        }
        this.showOutput(this.getTxtOutput(), output);
    }

    private void showErrorMessage(String message) {
        this.showOutput(this.getTxtOutput(), "Error: " + message);
        this.stopOperation();
    }

    private void reloadUIListView() {
        final ObservableList obsList = FXCollections.observableArrayList(this.getMainListArray());
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                PostHelper.this.getMainListView().setItems(null);
                PostHelper.this.getMainListView().setItems(obsList);
            }
        });
    }

    private boolean followingIsBalanced(long source) {
        User user = null;
        long following = 0L;
        long followers = 0L;
        try {
            user = this.getTwitterInstance().showUser(source);
            following = user.getFriendsCount();
            followers = user.getFollowersCount();
        }
        catch (TwitterException twitterException) {
            // empty catch block
        }
        return followers > 2000L || following < 2000L;
    }

    private int getRandomInt(int min, int max) {
        Random rand = new Random();
        int random = rand.nextInt(max - min + 1) + min;
        return random;
    }

    private void showOutput(final TextArea view, final String output) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                view.appendText(output + "\n");
            }
        });
    }

    public void stopOperation() {
        this.timerTask.cancel();
        this.timerTask = null;
        this.timer.cancel();
        this.timer = null;
        this.showOutput(this.getTxtOutput(), AppHelper.getDate() + " - Operation stopped, you have to click the Stop button to start a new operation.");
    }

    public TimerTask getTimerTask() {
        return this.timerTask;
    }

    public void setTimerTask(TimerTask timerTask) {
        this.timerTask = timerTask;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public void setTimer(Timer timer) {
        this.timer = timer;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public ArrayList<String> getMainListArray() {
        return this.listArray;
    }

    public void setMainListArray(ArrayList<String> listArray) {
        this.listArray = listArray;
    }

    public ListView<String> getMainListView() {
        return this.mainListView;
    }

    public void setMainListView(ListView<String> mainListView) {
        this.mainListView = mainListView;
    }

    private long getRandomIndex() {
        return this.randomIndex;
    }

    private void setRandomIndex(int randomIndex) {
        this.randomIndex = randomIndex;
    }

    public TextArea getTxtOutput() {
        return this.txtOutput;
    }

    public void setTxtOutput(TextArea txtOutput) {
        this.txtOutput = txtOutput;
    }

    public Twitter getTwitterInstance() {
        return this.twitterInstance;
    }

    public void setTwitterInstance(Twitter twitterInstance) {
        this.twitterInstance = twitterInstance;
    }

    public String getLoggedinScreenName() {
        return this.loggedinScreenName;
    }

    public void setLoggedinScreenName(String loggedinScreenName) {
        this.loggedinScreenName = loggedinScreenName;
    }

    public void clear() {
        this.getMainListArray().clear();
        this.getMainListView().setItems(null);
    }

    public int getRandomInterval() {
        Random random = new Random();
        int randomTime = random.nextInt(this.getEndInterval() - this.getStartInterval() + 1) + this.getStartInterval();
        int millis = 0;
        millis = this.getPostOption() == 5 ? this.convertSecondsToMilliseconds(randomTime) : this.convertMinutesToMilliseconds(randomTime);
        this.randomInterval = millis;
        return this.randomInterval;
    }

    private int convertMinutesToMilliseconds(int minute) {
        return minute * 60000;
    }

    private int convertSecondsToMilliseconds(int seconds) {
        return seconds * 1000;
    }

    private int convertMillisecondsToMinutes(int millis) {
        return millis / 60000;
    }

    private long getSeconds(long millis) {
        return millis / 1000L;
    }

    public boolean isIntervalIsValid() {
        return this.getMinimumInterval() < this.getMaximumInterval() && this.getMinimumInterval() >= 1 && this.getMaximumInterval() >= 2;
    }

    public int getStartInterval() {
        return this.startInterval;
    }

    public void setStartInterval(int startInterval) {
        this.startInterval = startInterval;
    }

    public int getEndInterval() {
        return this.endInterval;
    }

    public void setEndInterval(int endInterval) {
        this.endInterval = endInterval;
    }

    public int getMinimumInterval() {
        return this.minimumIntervalMinutes;
    }

    public void setMinimumInterval(TextField textFieldInterval) {
        int interval = Integer.parseInt(textFieldInterval.getText().trim());
        this.setStartInterval(interval);
        this.minimumIntervalMinutes = interval;
    }

    public int getMaximumInterval() {
        return this.maximumIntervalMinutes;
    }

    public void setMaximumInterval(TextField textFieldInterval) {
        int max = Integer.parseInt(textFieldInterval.getText().trim());
        this.setEndInterval(max);
        this.maximumIntervalMinutes = max;
    }

    public String getLoggedInUserId() {
        return this.loggedInUserId.trim();
    }

    public void setLoggedInUserId(String loggedInUserId) {
        this.loggedInUserId = loggedInUserId;
    }

    public ArrayList<String> getAtReplyUsersArray() {
        return this.atReplyUsersArray;
    }

    public void setAtReplyUsersArray(ArrayList<String> atReplyUsersArray) {
        this.atReplyUsersArray = atReplyUsersArray;
    }

    public int getPostOption() {
        return this.postOption;
    }

    public void setPostOption(int postOption) {
        this.postOption = postOption;
    }
}

