/*
 * Decompiled with CFR 0.152.
 */
package com.kodebot.friendlybot;

import twitter4j.JSONObject;
import twitter4j.Twitter;

public class RateLimit {
    private Twitter twitter;
    private String resource;
    private int resourceOption;
    private String resourceOptionStr;
    private int method;
    private int remaining;
    private static final String REMAINING = "remaining";

    public RateLimit(Twitter twitter, int resourceOption, int method) {
        this.setTwitter(twitter);
        this.setMethod(method);
        this.setResourceOption(resourceOption);
    }

    public int getRemainingRequests() {
        this.setRemaining(0);
        try {
            JSONObject jsonData = new JSONObject(this.getTwitter().getRateLimitStatus(this.getResource()).get(this.getResourceOptionStr()));
            this.setRemaining(jsonData.getInt(REMAINING));
        }
        catch (Exception e) {
            System.out.println("En error occurred: " + e.getMessage());
        }
        return this.getRemaining();
    }

    public Twitter getTwitter() {
        return this.twitter;
    }

    public void setTwitter(Twitter twitter) {
        this.twitter = twitter;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public int getResourceOption() {
        return this.resourceOption;
    }

    public void setResourceOption(int resourceOption) {
        if (this.getMethod() == 201) {
            if (resourceOption == 0) {
                this.setResourceOptionStr("/search/tweets");
                this.setResource("search");
            } else if (resourceOption == 1) {
                this.setResourceOptionStr("/friends/ids");
                this.setResource("friends");
            } else if (resourceOption == 2) {
                this.setResourceOptionStr("/followers/ids");
                this.setResource("followers");
            } else if (resourceOption == 3) {
                this.setResourceOptionStr("/statuses/user_timeline");
                this.setResource("statuses");
            } else if (resourceOption == 4) {
                this.setResourceOptionStr("/statuses/mentions_timeline");
                this.setResource("statuses");
            } else if (resourceOption == 5) {
                this.setResourceOptionStr("/direct_messages/show");
                this.setResource("direct_messages");
            }
        }
        this.resourceOption = resourceOption;
    }

    public String getResourceOptionStr() {
        return this.resourceOptionStr;
    }

    public void setResourceOptionStr(String resourceOptionStr) {
        this.resourceOptionStr = resourceOptionStr;
    }

    public int getMethod() {
        return this.method;
    }

    public void setMethod(int method) {
        this.method = method;
    }

    public int getRemaining() {
        return this.remaining;
    }

    public void setRemaining(int remaining) {
        this.remaining = remaining;
    }
}

