Imports System
Imports System.Collections
Imports System.ComponentModel
Imports System.Drawing
Imports System.Data
Imports System.Windows.Forms

Public Enum SizeMode
    Scrollable
    RatioStretch
End Enum

Public Class Viewer
    Inherits System.Windows.Forms.UserControl

#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call
        ImageSizeMode = sizeMode.RatioStretch

    End Sub

    'UserControl overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    'Required by the Windows Form Designer
    Private components As System.ComponentModel.IContainer

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    Friend WithEvents pbxViewer As System.Windows.Forms.PictureBox
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.pbxViewer = New System.Windows.Forms.PictureBox
        Me.SuspendLayout()
        '
        'pbxViewer
        '
        Me.pbxViewer.Location = New System.Drawing.Point(24, 24)
        Me.pbxViewer.Name = "pbxViewer"
        Me.pbxViewer.Size = New System.Drawing.Size(136, 80)
        Me.pbxViewer.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage
        Me.pbxViewer.TabIndex = 0
        Me.pbxViewer.TabStop = False
        '
        'Viewer
        '
        Me.AutoScroll = True
        Me.BackColor = System.Drawing.Color.Black
        Me.Controls.Add(Me.pbxViewer)
        Me.ForeColor = System.Drawing.SystemColors.ControlText
        Me.Name = "Viewer"
        Me.Size = New System.Drawing.Size(184, 128)
        Me.ResumeLayout(False)

    End Sub

#End Region


    'Dim pbxViewer As PictureBox
    'Dim components As IContainer
    Dim sizeMode As sizeMode


    Public Property Image() As Image
        Get
            Return pbxViewer.Image
        End Get

        Set(ByVal Value As Image)
            pbxViewer.Image = Value
            SetLayout()
        End Set
    End Property


    Public Property ImageSizeMode() As sizeMode
        Get
            Return sizeMode
        End Get

        Set(ByVal Value As sizeMode)
            sizeMode = Value
            AutoScroll = (sizeMode = sizeMode.Scrollable)
            SetLayout()
        End Set
    End Property


    Private Sub RatioStretch()

        Dim pRatio As Single
        Dim imRatio As Single

        pRatio = CSng(Width / Height)
        imRatio = CSng(pbxViewer.Image.Width / pbxViewer.Image.Height)

        If (Width >= pbxViewer.Image.Width And Height >= pbxViewer.Image.Height) Then
            pbxViewer.Width = pbxViewer.Image.Width
            pbxViewer.Height = pbxViewer.Image.Height
        Else
            If (Width > pbxViewer.Image.Width And Height < pbxViewer.Image.Height) Then
                pbxViewer.Height = Height
                pbxViewer.Width = CInt(Height * imRatio)
            Else
                If (Width < pbxViewer.Image.Width And Height > pbxViewer.Image.Height) Then
                    pbxViewer.Width = Width
                    pbxViewer.Height = CInt(Width / imRatio)
                Else
                    If (Width < pbxViewer.Image.Width And Height < pbxViewer.Image.Height) Then
                        If (Width >= Height) Then
                            ' width image
                            If (pbxViewer.Image.Width >= pbxViewer.Image.Height And imRatio >= pRatio) Then
                                pbxViewer.Width = Width
                                pbxViewer.Height = CInt(Width / imRatio)
                            Else
                                pbxViewer.Height = Height
                                pbxViewer.Width = CInt(Height * imRatio)
                            End If
                        Else
                            ' width image
                            If (pbxViewer.Image.Width < pbxViewer.Image.Height And imRatio < pRatio) Then
                                pbxViewer.Height = Height
                                pbxViewer.Width = CInt(Height * imRatio)
                            Else ' height image
                                pbxViewer.Width = Width
                                pbxViewer.Height = CInt(Width / imRatio)
                            End If
                        End If
                    End If
                End If
            End If
        End If

        CenterImage()

    End Sub


    Private Sub Scrollable()
        pbxViewer.Width = pbxViewer.Image.Width
        pbxViewer.Height = pbxViewer.Image.Height
        CenterImage()
    End Sub


    Private Sub SetLayout()
        If (pbxViewer.Image Is Nothing) Then
            Return
        End If

        If (sizeMode = sizeMode.RatioStretch) Then
            RatioStretch()
        Else
            AutoScroll = False
            Scrollable()
            AutoScroll = True
        End If
    End Sub


    Private Sub CenterImage()

        Dim top As Integer
        Dim left As Integer

        top = CInt((Height - pbxViewer.Height) / 2.0)
        left = CInt((Width - pbxViewer.Width) / 2.0)

        If (top < 0) Then
            top = 0
        End If

        If (left < 0) Then
            left = 0
        End If

        pbxViewer.Top = top
        pbxViewer.Left = left

    End Sub


    Private Sub Viewer_Load(ByVal sender As System.Object, ByVal e As System.EventArgs)
        pbxViewer.Width = 0
        pbxViewer.Height = 0
        SetLayout()
    End Sub


    Private Sub Viewer_Resize(ByVal sender As System.Object, ByVal e As System.EventArgs)
        SetLayout()
    End Sub


End Class
