Imports System.Threading
Imports MySql.Data.MySqlClient

Public Class frmDB
    Inherits System.Windows.Forms.Form

#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call

        InitializeExtendedStatusBar()

        Control.CheckForIllegalCrossThreadCalls = False

        Dim myToolTip As New ToolTip
        myToolTip.InitialDelay = 500
        myToolTip.AutoPopDelay = 8000
        myToolTip.ReshowDelay = 500
        ' ToolTip text to be displayed whether form is active or not.
        myToolTip.ShowAlways = True

        'Wrong here, just a straight copy is made of the table
        'myToolTip.SetToolTip(Me.btnCopySpecial, _
        '    "Copy movie filenames that dont exist in collection to a new table. " + _
        '    "These are filenames without path info in database. " + _
        '    "You never want to erase these because they are info about duplicates never downloaded.")

        myToolTip.SetToolTip(Me.btnEraseSpecial, _
            "Erase info about movies that really exist in collection. " + _
            "Dont erase info about duplicates. " + _
            "You never want to erase these because they help avoid unnecessary downloads.")

    End Sub

    'Form overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    'Required by the Windows Form Designer
    Private components As System.ComponentModel.IContainer

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    Friend WithEvents TabControl1 As System.Windows.Forms.TabControl
    Friend WithEvents tabDB As System.Windows.Forms.TabPage
    Friend WithEvents tabDBLog As System.Windows.Forms.TabPage
    Friend WithEvents statusBar As System.Windows.Forms.StatusBar
    Friend WithEvents lvwDBLog As System.Windows.Forms.ListView
    Friend WithEvents btnDBLogExit As System.Windows.Forms.Button
    Friend WithEvents GroupBox3 As System.Windows.Forms.GroupBox
    Friend WithEvents tbxMySQLDatabase As System.Windows.Forms.TextBox
    Friend WithEvents Label25 As System.Windows.Forms.Label
    Friend WithEvents tbxMySQLPassword As System.Windows.Forms.TextBox
    Friend WithEvents Label21 As System.Windows.Forms.Label
    Friend WithEvents tbxMySQLUser As System.Windows.Forms.TextBox
    Friend WithEvents Label20 As System.Windows.Forms.Label
    Friend WithEvents tbxMySQLPort As System.Windows.Forms.TextBox
    Friend WithEvents Label19 As System.Windows.Forms.Label
    Friend WithEvents Label18 As System.Windows.Forms.Label
    Friend WithEvents tbxMySQLServer As System.Windows.Forms.TextBox
    Friend WithEvents btnCheckIfDBIsOnline As System.Windows.Forms.Button
    Friend WithEvents btnCreateTable As System.Windows.Forms.Button
    Friend WithEvents btnCreateCollection As System.Windows.Forms.Button
    Friend WithEvents btnCountRecords As System.Windows.Forms.Button
    Friend WithEvents btnClearTable As System.Windows.Forms.Button
    Friend WithEvents btnDBExit As System.Windows.Forms.Button
    Friend WithEvents btnSaveSettings As System.Windows.Forms.Button
    Friend WithEvents cbTableSelection As System.Windows.Forms.ComboBox
    Friend WithEvents groupbox4 As System.Windows.Forms.GroupBox
    Friend WithEvents ColumnHeader1 As System.Windows.Forms.ColumnHeader
    Friend WithEvents btnDeleteTable As System.Windows.Forms.Button
    Friend WithEvents Label1 As System.Windows.Forms.Label
    Friend WithEvents btnExecuteCommand As System.Windows.Forms.Button
    Friend WithEvents btnShowAllDatabases As System.Windows.Forms.Button
    Friend WithEvents cbDBCommand As System.Windows.Forms.ComboBox
    Friend WithEvents gbMovieSpecial As System.Windows.Forms.GroupBox
    Friend WithEvents btnCopySpecial As System.Windows.Forms.Button
    Friend WithEvents tbxToTable As System.Windows.Forms.TextBox
    Friend WithEvents Label3 As System.Windows.Forms.Label
    Friend WithEvents btnEraseSpecial As System.Windows.Forms.Button
    Friend WithEvents btnShowAllTables As System.Windows.Forms.Button
    Friend WithEvents tbxTable As System.Windows.Forms.TextBox
    Friend WithEvents gbCopyTable As System.Windows.Forms.GroupBox
    Friend WithEvents Label2 As System.Windows.Forms.Label
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Dim resources As System.ComponentModel.ComponentResourceManager = New System.ComponentModel.ComponentResourceManager(GetType(frmDB))
        Me.TabControl1 = New System.Windows.Forms.TabControl
        Me.tabDB = New System.Windows.Forms.TabPage
        Me.btnDBExit = New System.Windows.Forms.Button
        Me.btnSaveSettings = New System.Windows.Forms.Button
        Me.GroupBox3 = New System.Windows.Forms.GroupBox
        Me.btnShowAllDatabases = New System.Windows.Forms.Button
        Me.tbxMySQLPassword = New System.Windows.Forms.TextBox
        Me.Label21 = New System.Windows.Forms.Label
        Me.tbxMySQLUser = New System.Windows.Forms.TextBox
        Me.Label20 = New System.Windows.Forms.Label
        Me.tbxMySQLPort = New System.Windows.Forms.TextBox
        Me.Label19 = New System.Windows.Forms.Label
        Me.Label18 = New System.Windows.Forms.Label
        Me.tbxMySQLServer = New System.Windows.Forms.TextBox
        Me.tbxMySQLDatabase = New System.Windows.Forms.TextBox
        Me.Label25 = New System.Windows.Forms.Label
        Me.btnCheckIfDBIsOnline = New System.Windows.Forms.Button
        Me.groupbox4 = New System.Windows.Forms.GroupBox
        Me.gbMovieSpecial = New System.Windows.Forms.GroupBox
        Me.Label3 = New System.Windows.Forms.Label
        Me.tbxToTable = New System.Windows.Forms.TextBox
        Me.btnCopySpecial = New System.Windows.Forms.Button
        Me.btnEraseSpecial = New System.Windows.Forms.Button
        Me.Label2 = New System.Windows.Forms.Label
        Me.Label1 = New System.Windows.Forms.Label
        Me.btnDeleteTable = New System.Windows.Forms.Button
        Me.cbTableSelection = New System.Windows.Forms.ComboBox
        Me.btnCountRecords = New System.Windows.Forms.Button
        Me.btnClearTable = New System.Windows.Forms.Button
        Me.btnCreateTable = New System.Windows.Forms.Button
        Me.btnCreateCollection = New System.Windows.Forms.Button
        Me.tabDBLog = New System.Windows.Forms.TabPage
        Me.cbDBCommand = New System.Windows.Forms.ComboBox
        Me.btnExecuteCommand = New System.Windows.Forms.Button
        Me.btnDBLogExit = New System.Windows.Forms.Button
        Me.lvwDBLog = New System.Windows.Forms.ListView
        Me.ColumnHeader1 = New System.Windows.Forms.ColumnHeader
        Me.statusBar = New System.Windows.Forms.StatusBar
        Me.btnShowAllTables = New System.Windows.Forms.Button
        Me.tbxTable = New System.Windows.Forms.TextBox
        Me.gbCopyTable = New System.Windows.Forms.GroupBox
        Me.TabControl1.SuspendLayout()
        Me.tabDB.SuspendLayout()
        Me.GroupBox3.SuspendLayout()
        Me.groupbox4.SuspendLayout()
        Me.gbMovieSpecial.SuspendLayout()
        Me.tabDBLog.SuspendLayout()
        Me.gbCopyTable.SuspendLayout()
        Me.SuspendLayout()
        '
        'TabControl1
        '
        Me.TabControl1.Anchor = CType((((System.Windows.Forms.AnchorStyles.Top Or System.Windows.Forms.AnchorStyles.Bottom) _
                    Or System.Windows.Forms.AnchorStyles.Left) _
                    Or System.Windows.Forms.AnchorStyles.Right), System.Windows.Forms.AnchorStyles)
        Me.TabControl1.Controls.Add(Me.tabDB)
        Me.TabControl1.Controls.Add(Me.tabDBLog)
        Me.TabControl1.Location = New System.Drawing.Point(0, 0)
        Me.TabControl1.Name = "TabControl1"
        Me.TabControl1.SelectedIndex = 0
        Me.TabControl1.Size = New System.Drawing.Size(744, 544)
        Me.TabControl1.TabIndex = 0
        '
        'tabDB
        '
        Me.tabDB.Controls.Add(Me.btnDBExit)
        Me.tabDB.Controls.Add(Me.btnSaveSettings)
        Me.tabDB.Controls.Add(Me.GroupBox3)
        Me.tabDB.Controls.Add(Me.groupbox4)
        Me.tabDB.Location = New System.Drawing.Point(4, 22)
        Me.tabDB.Name = "tabDB"
        Me.tabDB.Size = New System.Drawing.Size(736, 518)
        Me.tabDB.TabIndex = 0
        Me.tabDB.Text = "Database"
        '
        'btnDBExit
        '
        Me.btnDBExit.Location = New System.Drawing.Point(624, 472)
        Me.btnDBExit.Name = "btnDBExit"
        Me.btnDBExit.Size = New System.Drawing.Size(88, 32)
        Me.btnDBExit.TabIndex = 38
        Me.btnDBExit.Text = "Exit"
        '
        'btnSaveSettings
        '
        Me.btnSaveSettings.FlatStyle = System.Windows.Forms.FlatStyle.System
        Me.btnSaveSettings.Location = New System.Drawing.Point(27, 472)
        Me.btnSaveSettings.Name = "btnSaveSettings"
        Me.btnSaveSettings.Size = New System.Drawing.Size(88, 32)
        Me.btnSaveSettings.TabIndex = 16
        Me.btnSaveSettings.Text = "Save settings"
        '
        'GroupBox3
        '
        Me.GroupBox3.Controls.Add(Me.btnShowAllTables)
        Me.GroupBox3.Controls.Add(Me.btnShowAllDatabases)
        Me.GroupBox3.Controls.Add(Me.tbxMySQLPassword)
        Me.GroupBox3.Controls.Add(Me.btnCheckIfDBIsOnline)
        Me.GroupBox3.Controls.Add(Me.Label21)
        Me.GroupBox3.Controls.Add(Me.tbxMySQLUser)
        Me.GroupBox3.Controls.Add(Me.Label20)
        Me.GroupBox3.Controls.Add(Me.tbxMySQLPort)
        Me.GroupBox3.Controls.Add(Me.Label19)
        Me.GroupBox3.Controls.Add(Me.Label18)
        Me.GroupBox3.Controls.Add(Me.tbxMySQLServer)
        Me.GroupBox3.Controls.Add(Me.tbxMySQLDatabase)
        Me.GroupBox3.Controls.Add(Me.Label25)
        Me.GroupBox3.FlatStyle = System.Windows.Forms.FlatStyle.System
        Me.GroupBox3.Location = New System.Drawing.Point(8, 8)
        Me.GroupBox3.Name = "GroupBox3"
        Me.GroupBox3.Size = New System.Drawing.Size(720, 144)
        Me.GroupBox3.TabIndex = 4
        Me.GroupBox3.TabStop = False
        Me.GroupBox3.Text = "MySQL database"
        '
        'btnShowAllDatabases
        '
        Me.btnShowAllDatabases.FlatStyle = System.Windows.Forms.FlatStyle.System
        Me.btnShowAllDatabases.Location = New System.Drawing.Point(626, 56)
        Me.btnShowAllDatabases.Name = "btnShowAllDatabases"
        Me.btnShowAllDatabases.Size = New System.Drawing.Size(88, 32)
        Me.btnShowAllDatabases.TabIndex = 44
        Me.btnShowAllDatabases.Text = "Show all databases"
        '
        'tbxMySQLPassword
        '
        Me.tbxMySQLPassword.Location = New System.Drawing.Point(304, 64)
        Me.tbxMySQLPassword.Name = "tbxMySQLPassword"
        Me.tbxMySQLPassword.Size = New System.Drawing.Size(100, 20)
        Me.tbxMySQLPassword.TabIndex = 10
        '
        'Label21
        '
        Me.Label21.Location = New System.Drawing.Point(248, 72)
        Me.Label21.Name = "Label21"
        Me.Label21.Size = New System.Drawing.Size(56, 23)
        Me.Label21.TabIndex = 9
        Me.Label21.Text = "Password"
        '
        'tbxMySQLUser
        '
        Me.tbxMySQLUser.Location = New System.Drawing.Point(304, 32)
        Me.tbxMySQLUser.Name = "tbxMySQLUser"
        Me.tbxMySQLUser.Size = New System.Drawing.Size(100, 20)
        Me.tbxMySQLUser.TabIndex = 8
        '
        'Label20
        '
        Me.Label20.Location = New System.Drawing.Point(248, 40)
        Me.Label20.Name = "Label20"
        Me.Label20.Size = New System.Drawing.Size(40, 23)
        Me.Label20.TabIndex = 7
        Me.Label20.Text = "User"
        '
        'tbxMySQLPort
        '
        Me.tbxMySQLPort.Location = New System.Drawing.Point(80, 64)
        Me.tbxMySQLPort.Name = "tbxMySQLPort"
        Me.tbxMySQLPort.Size = New System.Drawing.Size(48, 20)
        Me.tbxMySQLPort.TabIndex = 6
        '
        'Label19
        '
        Me.Label19.Location = New System.Drawing.Point(24, 72)
        Me.Label19.Name = "Label19"
        Me.Label19.Size = New System.Drawing.Size(32, 16)
        Me.Label19.TabIndex = 5
        Me.Label19.Text = "Port"
        '
        'Label18
        '
        Me.Label18.Location = New System.Drawing.Point(24, 40)
        Me.Label18.Name = "Label18"
        Me.Label18.Size = New System.Drawing.Size(56, 23)
        Me.Label18.TabIndex = 4
        Me.Label18.Text = "Server"
        '
        'tbxMySQLServer
        '
        Me.tbxMySQLServer.Location = New System.Drawing.Point(80, 32)
        Me.tbxMySQLServer.Name = "tbxMySQLServer"
        Me.tbxMySQLServer.Size = New System.Drawing.Size(144, 20)
        Me.tbxMySQLServer.TabIndex = 3
        '
        'tbxMySQLDatabase
        '
        Me.tbxMySQLDatabase.Location = New System.Drawing.Point(79, 96)
        Me.tbxMySQLDatabase.Name = "tbxMySQLDatabase"
        Me.tbxMySQLDatabase.Size = New System.Drawing.Size(120, 20)
        Me.tbxMySQLDatabase.TabIndex = 12
        '
        'Label25
        '
        Me.Label25.Location = New System.Drawing.Point(24, 100)
        Me.Label25.Name = "Label25"
        Me.Label25.Size = New System.Drawing.Size(56, 16)
        Me.Label25.TabIndex = 11
        Me.Label25.Text = "Database"
        '
        'btnCheckIfDBIsOnline
        '
        Me.btnCheckIfDBIsOnline.FlatStyle = System.Windows.Forms.FlatStyle.System
        Me.btnCheckIfDBIsOnline.Location = New System.Drawing.Point(626, 14)
        Me.btnCheckIfDBIsOnline.Name = "btnCheckIfDBIsOnline"
        Me.btnCheckIfDBIsOnline.Size = New System.Drawing.Size(88, 32)
        Me.btnCheckIfDBIsOnline.TabIndex = 15
        Me.btnCheckIfDBIsOnline.Text = "OnlineCheck"
        '
        'groupbox4
        '
        Me.groupbox4.Controls.Add(Me.gbCopyTable)
        Me.groupbox4.Controls.Add(Me.tbxTable)
        Me.groupbox4.Controls.Add(Me.gbMovieSpecial)
        Me.groupbox4.Controls.Add(Me.Label2)
        Me.groupbox4.Controls.Add(Me.Label1)
        Me.groupbox4.Controls.Add(Me.btnDeleteTable)
        Me.groupbox4.Controls.Add(Me.cbTableSelection)
        Me.groupbox4.Controls.Add(Me.btnCountRecords)
        Me.groupbox4.Controls.Add(Me.btnClearTable)
        Me.groupbox4.Controls.Add(Me.btnCreateTable)
        Me.groupbox4.Controls.Add(Me.btnCreateCollection)
        Me.groupbox4.Location = New System.Drawing.Point(8, 160)
        Me.groupbox4.Name = "groupbox4"
        Me.groupbox4.Size = New System.Drawing.Size(720, 304)
        Me.groupbox4.TabIndex = 17
        Me.groupbox4.TabStop = False
        Me.groupbox4.Text = "Database tables"
        '
        'gbMovieSpecial
        '
        Me.gbMovieSpecial.Controls.Add(Me.btnEraseSpecial)
        Me.gbMovieSpecial.Location = New System.Drawing.Point(304, 190)
        Me.gbMovieSpecial.Name = "gbMovieSpecial"
        Me.gbMovieSpecial.Size = New System.Drawing.Size(188, 74)
        Me.gbMovieSpecial.TabIndex = 43
        Me.gbMovieSpecial.TabStop = False
        Me.gbMovieSpecial.Text = "Special for movies"
        '
        'Label3
        '
        Me.Label3.Location = New System.Drawing.Point(119, 16)
        Me.Label3.Name = "Label3"
        Me.Label3.Size = New System.Drawing.Size(48, 16)
        Me.Label3.TabIndex = 43
        Me.Label3.Text = "To table"
        '
        'tbxToTable
        '
        Me.tbxToTable.Location = New System.Drawing.Point(122, 36)
        Me.tbxToTable.Name = "tbxToTable"
        Me.tbxToTable.Size = New System.Drawing.Size(135, 20)
        Me.tbxToTable.TabIndex = 21
        '
        'btnCopySpecial
        '
        Me.btnCopySpecial.FlatStyle = System.Windows.Forms.FlatStyle.System
        Me.btnCopySpecial.Location = New System.Drawing.Point(12, 28)
        Me.btnCopySpecial.Name = "btnCopySpecial"
        Me.btnCopySpecial.Size = New System.Drawing.Size(88, 32)
        Me.btnCopySpecial.TabIndex = 20
        Me.btnCopySpecial.Text = "Copy"
        '
        'btnEraseSpecial
        '
        Me.btnEraseSpecial.FlatStyle = System.Windows.Forms.FlatStyle.System
        Me.btnEraseSpecial.Location = New System.Drawing.Point(21, 27)
        Me.btnEraseSpecial.Name = "btnEraseSpecial"
        Me.btnEraseSpecial.Size = New System.Drawing.Size(88, 32)
        Me.btnEraseSpecial.TabIndex = 19
        Me.btnEraseSpecial.Text = "Erase only real movies"
        '
        'Label2
        '
        Me.Label2.Location = New System.Drawing.Point(16, 80)
        Me.Label2.Name = "Label2"
        Me.Label2.Size = New System.Drawing.Size(48, 16)
        Me.Label2.TabIndex = 42
        Me.Label2.Text = "Table"
        '
        'Label1
        '
        Me.Label1.Location = New System.Drawing.Point(16, 42)
        Me.Label1.Name = "Label1"
        Me.Label1.Size = New System.Drawing.Size(32, 16)
        Me.Label1.TabIndex = 41
        Me.Label1.Text = "Type"
        '
        'btnDeleteTable
        '
        Me.btnDeleteTable.FlatStyle = System.Windows.Forms.FlatStyle.System
        Me.btnDeleteTable.Location = New System.Drawing.Point(188, 232)
        Me.btnDeleteTable.Name = "btnDeleteTable"
        Me.btnDeleteTable.Size = New System.Drawing.Size(88, 32)
        Me.btnDeleteTable.TabIndex = 40
        Me.btnDeleteTable.Text = "Delete"
        '
        'cbTableSelection
        '
        Me.cbTableSelection.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList
        Me.cbTableSelection.Items.AddRange(New Object() {"Movies", "Pictures"})
        Me.cbTableSelection.Location = New System.Drawing.Point(78, 37)
        Me.cbTableSelection.Name = "cbTableSelection"
        Me.cbTableSelection.Size = New System.Drawing.Size(121, 21)
        Me.cbTableSelection.TabIndex = 18
        '
        'btnCountRecords
        '
        Me.btnCountRecords.FlatStyle = System.Windows.Forms.FlatStyle.System
        Me.btnCountRecords.Location = New System.Drawing.Point(188, 123)
        Me.btnCountRecords.Name = "btnCountRecords"
        Me.btnCountRecords.Size = New System.Drawing.Size(88, 32)
        Me.btnCountRecords.TabIndex = 19
        Me.btnCountRecords.Text = "Count records"
        '
        'btnClearTable
        '
        Me.btnClearTable.FlatStyle = System.Windows.Forms.FlatStyle.System
        Me.btnClearTable.Location = New System.Drawing.Point(188, 177)
        Me.btnClearTable.Name = "btnClearTable"
        Me.btnClearTable.Size = New System.Drawing.Size(88, 32)
        Me.btnClearTable.TabIndex = 18
        Me.btnClearTable.Text = "Erase all records"
        '
        'btnCreateTable
        '
        Me.btnCreateTable.FlatStyle = System.Windows.Forms.FlatStyle.System
        Me.btnCreateTable.Location = New System.Drawing.Point(78, 123)
        Me.btnCreateTable.Name = "btnCreateTable"
        Me.btnCreateTable.Size = New System.Drawing.Size(88, 32)
        Me.btnCreateTable.TabIndex = 17
        Me.btnCreateTable.Text = "Create"
        '
        'btnCreateCollection
        '
        Me.btnCreateCollection.FlatStyle = System.Windows.Forms.FlatStyle.System
        Me.btnCreateCollection.Location = New System.Drawing.Point(80, 177)
        Me.btnCreateCollection.Name = "btnCreateCollection"
        Me.btnCreateCollection.Size = New System.Drawing.Size(88, 32)
        Me.btnCreateCollection.TabIndex = 18
        Me.btnCreateCollection.Text = "Add collection info to table"
        '
        'tabDBLog
        '
        Me.tabDBLog.Controls.Add(Me.cbDBCommand)
        Me.tabDBLog.Controls.Add(Me.btnExecuteCommand)
        Me.tabDBLog.Controls.Add(Me.btnDBLogExit)
        Me.tabDBLog.Controls.Add(Me.lvwDBLog)
        Me.tabDBLog.Location = New System.Drawing.Point(4, 22)
        Me.tabDBLog.Name = "tabDBLog"
        Me.tabDBLog.Size = New System.Drawing.Size(736, 518)
        Me.tabDBLog.TabIndex = 1
        Me.tabDBLog.Text = "Log"
        '
        'cbDBCommand
        '
        Me.cbDBCommand.Anchor = CType((System.Windows.Forms.AnchorStyles.Bottom Or System.Windows.Forms.AnchorStyles.Left), System.Windows.Forms.AnchorStyles)
        Me.cbDBCommand.FormattingEnabled = True
        Me.cbDBCommand.Location = New System.Drawing.Point(128, 479)
        Me.cbDBCommand.Name = "cbDBCommand"
        Me.cbDBCommand.Size = New System.Drawing.Size(449, 21)
        Me.cbDBCommand.TabIndex = 4
        '
        'btnExecuteCommand
        '
        Me.btnExecuteCommand.Anchor = CType((System.Windows.Forms.AnchorStyles.Bottom Or System.Windows.Forms.AnchorStyles.Left), System.Windows.Forms.AnchorStyles)
        Me.btnExecuteCommand.Location = New System.Drawing.Point(23, 472)
        Me.btnExecuteCommand.Name = "btnExecuteCommand"
        Me.btnExecuteCommand.Size = New System.Drawing.Size(88, 32)
        Me.btnExecuteCommand.TabIndex = 2
        Me.btnExecuteCommand.Text = "SQL Command"
        '
        'btnDBLogExit
        '
        Me.btnDBLogExit.Anchor = CType((System.Windows.Forms.AnchorStyles.Bottom Or System.Windows.Forms.AnchorStyles.Right), System.Windows.Forms.AnchorStyles)
        Me.btnDBLogExit.Location = New System.Drawing.Point(624, 472)
        Me.btnDBLogExit.Name = "btnDBLogExit"
        Me.btnDBLogExit.Size = New System.Drawing.Size(88, 32)
        Me.btnDBLogExit.TabIndex = 1
        Me.btnDBLogExit.Text = "Exit"
        '
        'lvwDBLog
        '
        Me.lvwDBLog.Anchor = CType((((System.Windows.Forms.AnchorStyles.Top Or System.Windows.Forms.AnchorStyles.Bottom) _
                    Or System.Windows.Forms.AnchorStyles.Left) _
                    Or System.Windows.Forms.AnchorStyles.Right), System.Windows.Forms.AnchorStyles)
        Me.lvwDBLog.Columns.AddRange(New System.Windows.Forms.ColumnHeader() {Me.ColumnHeader1})
        Me.lvwDBLog.HeaderStyle = System.Windows.Forms.ColumnHeaderStyle.None
        Me.lvwDBLog.Location = New System.Drawing.Point(8, 8)
        Me.lvwDBLog.Name = "lvwDBLog"
        Me.lvwDBLog.Size = New System.Drawing.Size(720, 448)
        Me.lvwDBLog.TabIndex = 0
        Me.lvwDBLog.UseCompatibleStateImageBehavior = False
        Me.lvwDBLog.View = System.Windows.Forms.View.Details
        '
        'ColumnHeader1
        '
        Me.ColumnHeader1.Width = 660
        '
        'statusBar
        '
        Me.statusBar.Location = New System.Drawing.Point(0, 552)
        Me.statusBar.Name = "statusBar"
        Me.statusBar.Size = New System.Drawing.Size(744, 22)
        Me.statusBar.TabIndex = 1
        '
        'btnShowAllTables
        '
        Me.btnShowAllTables.FlatStyle = System.Windows.Forms.FlatStyle.System
        Me.btnShowAllTables.Location = New System.Drawing.Point(626, 96)
        Me.btnShowAllTables.Name = "btnShowAllTables"
        Me.btnShowAllTables.Size = New System.Drawing.Size(88, 32)
        Me.btnShowAllTables.TabIndex = 45
        Me.btnShowAllTables.Text = "Show all tables"
        '
        'tbxTable
        '
        Me.tbxTable.Location = New System.Drawing.Point(78, 71)
        Me.tbxTable.Name = "tbxTable"
        Me.tbxTable.Size = New System.Drawing.Size(120, 20)
        Me.tbxTable.TabIndex = 45
        '
        'gbCopyTable
        '
        Me.gbCopyTable.Controls.Add(Me.btnCopySpecial)
        Me.gbCopyTable.Controls.Add(Me.Label3)
        Me.gbCopyTable.Controls.Add(Me.tbxToTable)
        Me.gbCopyTable.Location = New System.Drawing.Point(304, 99)
        Me.gbCopyTable.Name = "gbCopyTable"
        Me.gbCopyTable.Size = New System.Drawing.Size(275, 83)
        Me.gbCopyTable.TabIndex = 46
        Me.gbCopyTable.TabStop = False
        Me.gbCopyTable.Text = "Copy table"
        '
        'frmDB
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.ClientSize = New System.Drawing.Size(744, 574)
        Me.Controls.Add(Me.statusBar)
        Me.Controls.Add(Me.TabControl1)
        Me.Icon = CType(resources.GetObject("$this.Icon"), System.Drawing.Icon)
        Me.Name = "frmDB"
        Me.TabControl1.ResumeLayout(False)
        Me.tabDB.ResumeLayout(False)
        Me.GroupBox3.ResumeLayout(False)
        Me.GroupBox3.PerformLayout()
        Me.groupbox4.ResumeLayout(False)
        Me.groupbox4.PerformLayout()
        Me.gbMovieSpecial.ResumeLayout(False)
        Me.tabDBLog.ResumeLayout(False)
        Me.gbCopyTable.ResumeLayout(False)
        Me.gbCopyTable.PerformLayout()
        Me.ResumeLayout(False)

    End Sub

#End Region

    Public Shared parentRef As frmMain

    Public sbDB As New ExtendedStatusBar

    Public myConnectionString As String
    Public mySQLCommandString As String
    Public myConnection As MySqlConnection
    Public myConnection2 As MySqlConnection
    Public myCommand As MySqlCommand
    Public myCommand2 As MySqlCommand

    'MySQL parameters
    Public connServer As String
    Public connPort As String
    Public connUserId As String
    Public connPassword As String
    Public connDatabase As String
    Public collectionTableName As String

    Public CountButtonPressed As Boolean
    Public DBCommandSuccessful As Boolean
    Public collectionRowCount As Integer
    Public integerFormatString As String

    Public StopDatabaseUpdate As Boolean
    Public myListViewItem As ListViewItem
    Public exceptionType As String

    Public exString As String
    Public excounter As Integer
    Dim exArray As String()

    Public LineFeed = Chr(10)
    Public CarriageReturn = Chr(13)

    Public DatabaseUndefined As Boolean

    Public result As Integer

    Public OpenSuccessful As Boolean

    Public outputString As String

    Public DatabaseExists As Boolean
    Public TableExists As Boolean
    Public stringToSearchFor As String

    Public foundCount As Integer

    'Maybe more elegant solution exists
    Public StopFirstTime As Boolean = True


    '----------------------------------------------------------

    Private Sub btnDBExit_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnDBExit.Click
        Me.Dispose()
    End Sub


    Private Sub btnDBLogExit_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnDBLogExit.Click
        Me.Dispose()
    End Sub



    Private Sub btnSaveSettings_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnSaveSettings.Click

        SaveDataBaseOptions()
        sbDB.Panels(0).Text = "Database settings saved"

        SetControlsAvailability()

    End Sub



    Private Sub btnCheckIfDBIsOnline_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnCheckIfDBIsOnline.Click

        'If user forgets to save any changes in the fields we do it anyway
        'Remove save button or keep it?

        SaveDataBaseOptions()
        sbDB.Panels(0).Text = "Database settings saved"

        lvwDBLog.Items.Clear()

        sbDB.Panels(0).Text = "Trying to connect to MySQL server"
        sbDB.progressBar.Value = 0
        sbDB.progressBar.Update()

        If tbxMySQLDatabase.Text = "" Then

            OpenConnectionToServer()
            If OpenSuccessful Then
                sbDB.Panels(0).Text = "Connect to MySQL server successful"
            Else
                sbDB.Panels(0).Text = "Connect to MySQL server failed"
            End If
            CloseConnection()
        Else

            OpenConnectionToDatabase()

            If OpenSuccessful Then
                sbDB.Panels(0).Text = "Connect to database " + tbxMySQLDatabase.Text + _
                " successful"
                CloseConnection()
            Else
                'connection.state will be closed if database is missing

                If DatabaseUndefined Then

                    sbDB.Panels(0).Text = ""

                    Dim msg As String
                    Dim title As String
                    Dim style As MsgBoxStyle
                    Dim response As MsgBoxResult

                    msg = "Database " + connDatabase + _
                        " doesnt exist. Do you want to create it?"
                    style = MsgBoxStyle.YesNo
                    title = "Missing database"
                    response = MsgBox(msg, style, title)

                    If response = MsgBoxResult.Yes Then

                        'The old one which is in state.closed
                        CloseConnection()

                        lvwDBLog.Items.Clear()

                        OpenConnectionToServer()
                        If OpenSuccessful Then

                            mySQLCommandString = "CREATE DATABASE " + connDatabase + ";"

                            DBCommandSuccessful = True
                            DoExecuteNonQuery()
                            CloseConnection()

                            If DBCommandSuccessful = True Then
                                sbDB.Panels(0).Text = "Database " + connDatabase + " created"
                            Else
                                sbDB.Panels(0).Text = "Database " + connDatabase + " creation failed"
                            End If

                            cbTableSelection.Enabled = True
                            tbxTable.Enabled = True
                            btnCreateTable.Enabled = True


                        Else
                            sbDB.Panels(0).Text = "Database creation failed"
                        End If
                    Else
                        sbDB.Panels(0).Text = "Creation of database cancelled"
                        cbTableSelection.Enabled = False
                        tbxTable.Enabled = False
                        btnCreateTable.Enabled = False
                        btnCreateCollection.Enabled = False
                        btnCountRecords.Enabled = False
                        btnDeleteTable.Enabled = False
                        btnClearTable.Enabled = False
                    End If

                Else
                    sbDB.Panels(0).Text = "Connect to MySQL database failed"
                End If

            End If

        End If


    End Sub


    Private Sub btnClearTable_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnClearTable.Click

        If tbxTable.Text = "" Then
            Exit Sub
        End If

        lvwDBLog.Items.Clear()

        OpenConnectionToDatabase()
        If Not OpenSuccessful Then
            sbDB.Panels(0).Text = "Connect to MySQL server failed"
            Exit Sub
        End If

        Dim msg As String
        Dim title As String
        Dim style As MsgBoxStyle
        Dim response As MsgBoxResult

        msg = "Do you want to delete all records from table " + tbxTable.Text + "?"
        style = MsgBoxStyle.YesNo
        title = "Warning - Deleting all records from table"
        response = MsgBox(msg, style, title)
        If response = MsgBoxResult.Yes Then

            msg = "Are you really, really sure you want to erase all records from table " + tbxTable.Text + "?"
            style = MsgBoxStyle.YesNo
            title = "Warning - DELETE ALL RECORDS"
            response = MsgBox(msg, style, title)
            If response = MsgBoxResult.Yes Then

                mySQLCommandString = "DROP TABLE " + tbxTable.Text + ";"

                DBCommandSuccessful = True
                DoExecuteNonQuery()


                If DBCommandSuccessful = False Then
                    sbDB.Panels(0).Text = "Failed to delete records from table " + tbxTable.Text
                    Exit Sub
                End If

                mySQLCommandString = "CREATE TABLE " + tbxTable.Text + " (  " + _
                " filename varchar(255) NOT NULL, " + _
                " filesize bigint(20) NOT NULL, " + _
                " filepath varchar(255) NOT NULL, " + _
                " filetime varchar(255) NOT NULL, " + _
                " fileMD5 varchar(255) default NULL, " + _
                " KEY indexPicture (filename,filesize), " + _
                " KEY indexMD5 (fileMD5)  ) ;"

                DBCommandSuccessful = True
                DoExecuteNonQuery()
                CloseConnection()


                If DBCommandSuccessful = True Then
                    sbDB.Panels(0).Text = "All records deleted from table " + tbxTable.Text
                End If

                CloseConnection()
            Else
                sbDB.Panels(0).Text = "No records deleted"
            End If

        Else
            sbDB.Panels(0).Text = "No records deleted"
        End If

    End Sub


    Private Sub btnDeleteTable_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnDeleteTable.Click

        If tbxTable.Text = "" Then
            Exit Sub
        End If

        lvwDBLog.Items.Clear()

        OpenConnectionToDatabase()
        If Not OpenSuccessful Then
            sbDB.Panels(0).Text = "Connect to MySQL server failed"
            Exit Sub
        End If

        Dim msg As String
        Dim title As String
        Dim style As MsgBoxStyle
        Dim response As MsgBoxResult

        msg = "Do you want to delete table " + tbxTable.Text + "?"
        style = MsgBoxStyle.YesNo
        title = "Warning - Deleting table"
        response = MsgBox(msg, style, title)
        If response = MsgBoxResult.Yes Then

            msg = "Are you really, really sure you want to DELETE table " + tbxTable.Text + "?"
            style = MsgBoxStyle.YesNo
            title = "Warning - DELETE OF TABLE"
            response = MsgBox(msg, style, title)
            If response = MsgBoxResult.Yes Then

                mySQLCommandString = "DROP TABLE IF EXISTS " + tbxTable.Text + ";"

                DBCommandSuccessful = True
                DoExecuteNonQuery()

                If DBCommandSuccessful = True Then
                    sbDB.Panels(0).Text = "Table " + tbxTable.Text + " deleted"

                    tbxTable.Text = ""

                    parentRef.SaveOptions()

                End If

                CloseConnection()

            Else
                sbDB.Panels(0).Text = "No table deleted"
            End If

        Else
            sbDB.Panels(0).Text = "No table deleted"
        End If

        SetControlsAvailability()

    End Sub


    Private Sub btnCountRecords_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnCountRecords.Click

        If tbxTable.Text = "" Then
            Exit Sub
        End If

        lvwDBLog.Items.Clear()

        OpenConnectionToDatabase()
        If Not OpenSuccessful Then
            sbDB.Panels(0).Text = "Connect to MySQL server failed"
            Exit Sub
        End If

        CountButtonPressed = True
        Dim workerThread As New Thread(New ThreadStart(AddressOf GetCollectionCount))
        workerThread.Start()
        sbDB.Panels(0).Text = "Counting records. Wait"

    End Sub


    Private Sub GetCollectionCount()

        collectionTableName = tbxTable.Text

        Try
            mySQLCommandString = "SELECT COUNT(*) FROM " + collectionTableName + ";"

            myListViewItem = lvwDBLog.Items.Add(mySQLCommandString)
            myListViewItem.EnsureVisible()
            myListViewItem.ForeColor = Color.Blue

            myCommand = New MySqlCommand(mySQLCommandString)
            myCommand.Connection = myConnection

            'myCommand.ExecuteNonQuery() returns integer with rows AFFECTED            
            result = myCommand.ExecuteScalar

            myListViewItem = lvwDBLog.Items.Add("SQL command processed")
            myListViewItem.EnsureVisible()
            myListViewItem.ForeColor = Color.Green

            collectionRowCount = result

            integerFormatString = Format(CInt(result), "###,###,###,###,##0")

            If CountButtonPressed = True Then
                CountButtonPressed = False
                'If we are doing the database update, we don't display this on the status bar
                'If we press the button to count the records, this is the wanted response

                outputString = "Table " + collectionTableName + _
                " contains " + integerFormatString + " records"

                sbDB.Panels(0).Text = outputString

                myListViewItem = lvwDBLog.Items.Add(outputString)
                myListViewItem.EnsureVisible()
                myListViewItem.ForeColor = Color.Black

            End If

            CloseConnection()

        Catch ex As MySqlException
            sbDB.Panels(0).Text = "Failed to count records in table"
            exceptionType = "MySqlException"
            ExceptionToListView(exceptionType, ex)
        Catch ex As System.Net.Sockets.SocketException
            'Port errors
            sbDB.Panels(0).Text = "Failed to count records in table"
            exceptionType = "System.Net.Sockets.SocketException"
            ExceptionToListView(exceptionType, ex)
        Catch ex As Exception
            'Syntax errors
            sbDB.Panels(0).Text = "Failed to count records in table"
            exceptionType = "Exception"
            ExceptionToListView(exceptionType, ex)
        End Try

    End Sub


    Private Sub btnCreateTable_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnCreateTable.Click

        If tbxTable.Text = "" Then
            Exit Sub
        End If

        SaveDataBaseOptions()

        lvwDBLog.Items.Clear()

        OpenConnectionToDatabase()
        If Not OpenSuccessful Then
            sbDB.Panels(0).Text = "Connect to MySQL server failed"
            Exit Sub
        End If

        Dim msg As String
        Dim title As String
        Dim style As MsgBoxStyle
        Dim response As MsgBoxResult
        msg = "Do you want to create a new table named " + tbxTable.Text + "?"
        style = MsgBoxStyle.YesNo
        title = "Warning - Creation of new table"
        response = MsgBox(msg, style, title)
        If response = MsgBoxResult.Yes Then

            mySQLCommandString = "CREATE TABLE " + tbxTable.Text + " (  " + _
            " filename varchar(255) NOT NULL, " + _
            " filesize bigint(20) NOT NULL, " + _
            " filepath varchar(255) NOT NULL, " + _
            " filetime varchar(255) NOT NULL, " + _
            " fileMD5 varchar(255) default NULL, " + _
            " KEY indexPicture (filename,filesize), " + _
            " KEY indexMD5 (fileMD5)  ) ;"

            DBCommandSuccessful = True
            DoExecuteNonQuery()
            CloseConnection()
            If DBCommandSuccessful = True Then
                sbDB.Panels(0).Text = "Creation of table " + tbxTable.Text + _
                " successful"

                If cbTableSelection.SelectedIndex = 0 Then
                    parentRef.htOptions.Item("mysqlmovietable") = tbxTable.Text
                Else
                    parentRef.htOptions.Item("mysqlpicturetable") = tbxTable.Text
                End If

                parentRef.SaveOptions()
            Else
                sbDB.Panels(0).Text = "Table creation failed"
            End If
        Else
            sbDB.Panels(0).Text = "Creation of table cancelled"

        End If

        SetControlsAvailability()

    End Sub


    Private Sub btnCreateCollection_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnCreateCollection.Click

        If tbxTable.Text = "" Then
            Exit Sub
        End If

        sbDB.Panels(0).Text = ""

        lvwDBLog.Items.Clear()

        Dim frmNewListFrame As New frmNewList

        'Sending over movie and picture definitions
        frmNewListFrame.htOptions = parentRef.htOptions

        connServer = parentRef.htOptions.Item("mysqlserver")
        connPort = parentRef.htOptions.Item("mysqlport")
        connUserId = parentRef.htOptions.Item("mysqluser")
        connPassword = parentRef.htOptions.Item("mysqlpassword")
        connDatabase = parentRef.htOptions.Item("mysqldatabase")

        myConnectionString = "Data Source=" + connServer + ";" + _
        "Port=" + connPort + ";" + _
        "User Id=" + connUserId + ";" + _
        "Password=" + connPassword + ";" + _
        "Database=" + connDatabase
        frmNewListFrame.myConnectionString = myConnectionString

        collectionTableName = tbxTable.Text
        frmNewListFrame.collectionTablename = collectionTableName

        If cbTableSelection.SelectedIndex = 0 Then
            'MOVIES
            frmNewListFrame.Text = "Select directories for movie database update"
            frmNewListFrame.WantedFileType = "MOVIE"
        Else
            'PICTURES
            frmNewListFrame.Text = "Select directories for picture database update"
            frmNewListFrame.WantedFileType = "PICTURE"
        End If

        frmNewListFrame.Show()

    End Sub


    Private Sub OpenConnectionToServer()

        OpenSuccessful = False

        'If we forgot to close any old connection, do it now, and open a fresh one
        If Not myConnection Is Nothing Then
            Try
                myConnection.Close()
                myConnection.Dispose()
            Catch ex As Exception
                DBCommandSuccessful = False
                exceptionType = "Exception"
                ExceptionToListView(exceptionType, ex)
                Exit Sub
            End Try
        End If

        connServer = parentRef.htOptions.Item("mysqlserver")
        connPort = parentRef.htOptions.Item("mysqlport")
        connUserId = parentRef.htOptions.Item("mysqluser")
        connPassword = parentRef.htOptions.Item("mysqlpassword")

        myConnectionString = "Data Source=" + connServer + ";" + _
        "Port=" + connPort + ";" + _
        "User Id=" + connUserId + ";" + _
        "Password=" + connPassword

        myListViewItem = lvwDBLog.Items.Add(myConnectionString)
        myListViewItem.EnsureVisible()
        myListViewItem.ForeColor = Color.Blue

        Try
            myConnection = New MySqlConnection(myConnectionString)
            myConnection.Open()

            myListViewItem = lvwDBLog.Items.Add("Connection opened to server")
            myListViewItem.EnsureVisible()
            myListViewItem.ForeColor = Color.Green
        Catch ex As MySqlException
            exceptionType = "MySqlException"
            ExceptionToListView(exceptionType, ex)
        Catch ex As System.Net.Sockets.SocketException
            'Port errors
            exceptionType = "System.Net.Sockets.SocketException"
            ExceptionToListView(exceptionType, ex)
        Catch ex As Exception
            'Syntax errors
            exceptionType = "Exception"
            ExceptionToListView(exceptionType, ex)
        End Try

        If Not myConnection Is Nothing Then
            If myConnection.State = ConnectionState.Open Then
                OpenSuccessful = True
            End If
        End If

    End Sub


    Private Sub OpenConnectionToDatabase()

        OpenSuccessful = False

        'If we forgot to close any old connection, do it now, and open a fresh one
        If Not myConnection Is Nothing Then
            Try
                myConnection.Close()
                myConnection.Dispose()
            Catch ex As Exception
                DBCommandSuccessful = False
                exceptionType = "Exception"
                ExceptionToListView(exceptionType, ex)
                Exit Sub
            End Try
        End If

        DatabaseUndefined = False

        connServer = parentRef.htOptions.Item("mysqlserver")
        connPort = parentRef.htOptions.Item("mysqlport")
        connUserId = parentRef.htOptions.Item("mysqluser")
        connPassword = parentRef.htOptions.Item("mysqlpassword")
        connDatabase = parentRef.htOptions.Item("mysqldatabase")

        myConnectionString = "Data Source=" + connServer + ";" + _
        "Port=" + connPort + ";" + _
        "User Id=" + connUserId + ";" + _
        "Password=" + connPassword + ";" + _
        "Database=" + connDatabase

        myListViewItem = lvwDBLog.Items.Add(myConnectionString)
        myListViewItem.EnsureVisible()
        myListViewItem.ForeColor = Color.Blue

        Try
            myConnection = New MySqlConnection(myConnectionString)
            myConnection.Open()

            myListViewItem = lvwDBLog.Items.Add("Connection opened to database")
            myListViewItem.EnsureVisible()
            myListViewItem.ForeColor = Color.Green

        Catch ex As MySqlException
            exceptionType = "MySqlException"
            ExceptionToListView(exceptionType, ex)

            'The database doesnt exist
            'connection.state will be closed in this instance
            If ex.Message.LastIndexOf("Unknown database") > 0 Then
                DatabaseUndefined = True
            End If

        Catch ex As System.Net.Sockets.SocketException
            'Port errors
            exceptionType = "System.Net.Sockets.SocketException"
            ExceptionToListView(exceptionType, ex)
        Catch ex As Exception
            'Syntax errors
            exceptionType = "Exception"
            ExceptionToListView(exceptionType, ex)
        End Try

        If Not myConnection Is Nothing Then
            If myConnection.State = ConnectionState.Open Then
                OpenSuccessful = True
            End If
        End If

    End Sub


    Private Sub OpenConnectionToDatabaseWithNoLogging()

        OpenSuccessful = False

        If Not myConnection Is Nothing Then
            Try
                myConnection.Close()
                myConnection.Dispose()
            Catch ex As Exception
                DBCommandSuccessful = False
                exceptionType = "Exception"
                ExceptionToListView(exceptionType, ex)
                Exit Sub
            End Try
        End If

        connServer = parentRef.htOptions.Item("mysqlserver")
        connPort = parentRef.htOptions.Item("mysqlport")
        connUserId = parentRef.htOptions.Item("mysqluser")
        connPassword = parentRef.htOptions.Item("mysqlpassword")
        connDatabase = parentRef.htOptions.Item("mysqldatabase")

        myConnectionString = "Data Source=" + connServer + ";" + _
        "Port=" + connPort + ";" + _
        "User Id=" + connUserId + ";" + _
        "Password=" + connPassword + ";" + _
        "Database=" + connDatabase

        Try
            myConnection = New MySqlConnection(myConnectionString)
            myConnection.Open()
        Catch ex As MySqlException
            exceptionType = "MySqlException"
            ExceptionToListView(exceptionType, ex)
        Catch ex As System.Net.Sockets.SocketException
            exceptionType = "System.Net.Sockets.SocketException"
            ExceptionToListView(exceptionType, ex)
        Catch ex As Exception
            exceptionType = "Exception"
            ExceptionToListView(exceptionType, ex)
        End Try

        If Not myConnection Is Nothing Then
            If myConnection.State = ConnectionState.Open Then
                OpenSuccessful = True
            End If
        End If

    End Sub


    Private Sub CloseConnection()

        Try
            If Not myConnection Is Nothing Then

                myListViewItem = lvwDBLog.Items.Add("Close connection")
                myListViewItem.EnsureVisible()
                myListViewItem.ForeColor = Color.Blue

                myConnection.Close()
                myConnection.Dispose()
                myConnection = Nothing

                myListViewItem = lvwDBLog.Items.Add("Connection closed")
                myListViewItem.EnsureVisible()
                myListViewItem.ForeColor = Color.Green
            End If

        Catch ex As MySqlException
            exceptionType = "MySqlException"
            ExceptionToListView(exceptionType, ex)
        Catch ex As System.Net.Sockets.SocketException
            'Port errors
            exceptionType = "System.Net.Sockets.SocketException"
            ExceptionToListView(exceptionType, ex)
        Catch ex As Exception
            'Syntax errors
            exceptionType = "Exception"
            ExceptionToListView(exceptionType, ex)
        End Try

    End Sub



    Private Sub DoExecuteNonQuery()

        Try
            If Not myConnection Is Nothing Then
                If myConnection.State = ConnectionState.Open Then
                    myCommand = New MySqlCommand(mySQLCommandString)

                    'Keeping lines within reasonable length
                    Dim smallString As String
                    Dim startposition As Integer
                    Dim endposition As Integer = 99
                    Dim stringLength As Integer = mySQLCommandString.Length
                    While startposition < stringLength
                        If startposition + endposition > stringLength Then
                            endposition = ((stringLength - startposition))
                        End If
                        smallString = mySQLCommandString.Substring(startposition, endposition)
                        startposition += 100

                        myListViewItem = lvwDBLog.Items.Add(smallString)
                        myListViewItem.EnsureVisible()
                        myListViewItem.ForeColor = Color.Blue

                    End While

                    myCommand.Connection = myConnection
                    result = myCommand.ExecuteNonQuery

                    myListViewItem = lvwDBLog.Items.Add("SQL command processed")
                    myListViewItem.EnsureVisible()
                    myListViewItem.ForeColor = Color.Green

                End If
            End If

        Catch ex As MySqlException
            exceptionType = "MySqlException"
            ExceptionToListView(exceptionType, ex)
            DBCommandSuccessful = False
        Catch ex As System.Net.Sockets.SocketException
            'Port errors
            exceptionType = "System.Net.Sockets.SocketException"
            ExceptionToListView(exceptionType, ex)
            DBCommandSuccessful = False
        Catch ex As Exception
            'Syntax errors
            exceptionType = "Exception"
            ExceptionToListView(exceptionType, ex)
            DBCommandSuccessful = False
        End Try

    End Sub


    Private Sub DoExecuteReader()

        'Perform a database read and dump result in log

        foundCount = 0

        Dim DBOutputString As String

        If Not myConnection Is Nothing Then
            Try
                myConnection.Close()
                myConnection.Dispose()
            Catch ex As Exception
                DBCommandSuccessful = False
                exceptionType = "Exception"
                ExceptionToListView(exceptionType, ex)
            End Try
        End If

        Try
            OpenConnectionToDatabase()

            If Not myConnection Is Nothing Then
                If myConnection.State = ConnectionState.Open Then
                    myCommand = New MySqlCommand(mySQLCommandString)

                    'Keeping lines withing reasonable length
                    Dim smallString As String
                    Dim startposition As Integer
                    Dim endposition As Integer = 99
                    Dim stringLength As Integer = mySQLCommandString.Length
                    While startposition < stringLength
                        If startposition + endposition > stringLength Then
                            endposition = ((stringLength - startposition))
                        End If
                        smallString = mySQLCommandString.Substring(startposition, endposition)
                        startposition += 100

                        myListViewItem = lvwDBLog.Items.Add(smallString)
                        myListViewItem.EnsureVisible()
                        myListViewItem.ForeColor = Color.Blue

                    End While

                    myCommand.Connection = myConnection

                    Dim fieldType As Type
                    Dim fieldCount As Integer
                    Dim fieldPos As Integer
                    Dim HeaderNotWritten As Boolean
                    HeaderNotWritten = True

                    Dim myReader As MySqlDataReader
                    myReader = myCommand.ExecuteReader()
                    While myReader.Read()

                        foundCount += 1
                        fieldCount = myReader.FieldCount

                        'Write the field names on top
                        If HeaderNotWritten Then
                            HeaderNotWritten = False

                            fieldPos = 0
                            DBOutputString = ""
                            While fieldPos < fieldCount
                                DBOutputString = DBOutputString + myReader.GetName(fieldPos) + " "
                                fieldPos += 1
                            End While
                            myListViewItem = lvwDBLog.Items.Add(DBOutputString + "   ")
                            myListViewItem.EnsureVisible()
                            myListViewItem.ForeColor = Color.Black

                        End If

                        'Write the column data
                        fieldPos = 0
                        DBOutputString = ""
                        While fieldPos < fieldCount

                            fieldType = myReader.GetFieldType(fieldPos)

                            If fieldType.Name = "String" Then
                                DBOutputString = DBOutputString + myReader.GetString(fieldPos) + " "
                            End If

                            If fieldType.Name = "Int64" Then
                                DBOutputString = DBOutputString + myReader.GetInt64(fieldPos).ToString + " "
                            End If

                            fieldPos += 1
                        End While
                        'Strange, seems we lose a few characters at end if we dont do this
                        myListViewItem = lvwDBLog.Items.Add(DBOutputString + "   ")
                        myListViewItem.EnsureVisible()
                        myListViewItem.ForeColor = Color.Black
                    End While

                    'To resize the listview so all data is seen
                    lvwDBLog.Focus()
                    SendKeys.Send("^{+}")

                    myReader.Close()

                    CloseConnection()
                End If
            End If

        Catch ex As MySqlException
            exceptionType = "MySqlException"
            ExceptionToListView(exceptionType, ex)
            DBCommandSuccessful = False
        Catch ex As System.Net.Sockets.SocketException
            'Port errors
            exceptionType = "System.Net.Sockets.SocketException"
            ExceptionToListView(exceptionType, ex)
            DBCommandSuccessful = False
        Catch ex As Exception
            'Syntax errors
            exceptionType = "Exception"
            ExceptionToListView(exceptionType, ex)
            DBCommandSuccessful = False
        End Try

    End Sub



    Public Sub BuildInitialForm()
        If parentRef.htOptions.ContainsKey("mysqlserver") Then
            tbxMySQLServer.Text = parentRef.htOptions.Item("mysqlserver")
        Else
            tbxMySQLServer.Text = "localhost"
            parentRef.htOptions.Item("mysqlserver") = tbxMySQLServer.Text
        End If

        If parentRef.htOptions.ContainsKey("mysqlport") Then
            tbxMySQLPort.Text = parentRef.htOptions.Item("mysqlport")
        Else
            tbxMySQLPort.Text = "3306"
            parentRef.htOptions.Item("mysqlport") = tbxMySQLPort.Text
        End If

        If parentRef.htOptions.ContainsKey("mysqluser") Then
            tbxMySQLUser.Text = parentRef.htOptions.Item("mysqluser")
        Else
            tbxMySQLUser.Text = "root"
            parentRef.htOptions.Item("mysqluser") = tbxMySQLUser.Text
        End If

        If parentRef.htOptions.ContainsKey("mysqlpassword") Then
            tbxMySQLPassword.Text = parentRef.htOptions.Item("mysqlpassword")
        Else
            tbxMySQLPassword.Text = ""
            parentRef.htOptions.Item("mysqlpassword") = tbxMySQLPassword.Text
        End If

        If parentRef.htOptions.ContainsKey("mysqldatabase") Then
            tbxMySQLDatabase.Text = parentRef.htOptions.Item("mysqldatabase")
        Else
            tbxMySQLDatabase.Text = "myDB"
            parentRef.htOptions.Item("mysqldatabase") = tbxMySQLDatabase.Text
        End If

        If parentRef.htOptions.Item("mysqldatabase") <> "" Then
            If parentRef.htOptions.ContainsKey("mysqlmovietable") Then
                cbTableSelection.SelectedIndex = 0
                tbxTable.Text = parentRef.htOptions.Item("mysqlmovietable")
            Else
                If parentRef.htOptions.ContainsKey("mysqlpicturetable") Then
                    cbTableSelection.SelectedIndex = 1
                    tbxTable.Text = parentRef.htOptions.Item("mysqlpicturetable")
                Else
                    cbTableSelection.SelectedIndex = 0
                    tbxTable.Text = ""
                End If
            End If
        End If

        SetControlsAvailability()

    End Sub


    Private Sub cbTableSelection_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles cbTableSelection.SelectedIndexChanged

        If StopFirstTime Then
            StopFirstTime = False
            Exit Sub
        End If

        SetTableValues()

        SetControlsAvailability()

    End Sub


    Private Sub SetTableValues()

        If cbTableSelection.SelectedIndex = 0 Then
            If parentRef.htOptions.ContainsKey("mysqlmovietable") Then
                tbxTable.Text = parentRef.htOptions.Item("mysqlmovietable")

                If tbxTable.Text = "" Then
                    gbMovieSpecial.Visible = False
                Else
                    gbMovieSpecial.Visible = True
                End If
            Else
                tbxTable.Text = ""
                gbMovieSpecial.Visible = False
            End If
        Else
            gbMovieSpecial.Visible = False
            If parentRef.htOptions.ContainsKey("mysqlpicturetable") Then
                tbxTable.Text = parentRef.htOptions.Item("mysqlpicturetable")
            Else
                tbxTable.Text = ""
            End If
        End If

    End Sub


    Private Sub SaveDataBaseOptions()

        lvwDBLog.Items.Clear()
        sbDB.Panels(0).Text = ""
        sbDB.progressBar.Value = 0
        sbDB.progressBar.Update()

        parentRef.htOptions.Item("mysqlserver") = tbxMySQLServer.Text
        parentRef.htOptions.Item("mysqlport") = tbxMySQLPort.Text
        parentRef.htOptions.Item("mysqluser") = tbxMySQLUser.Text
        parentRef.htOptions.Item("mysqlpassword") = tbxMySQLPassword.Text
        parentRef.htOptions.Item("mysqldatabase") = tbxMySQLDatabase.Text

        If cbTableSelection.SelectedIndex = 0 Then
            parentRef.htOptions.Item("mysqlmovietable") = tbxTable.Text
        Else
            parentRef.htOptions.Item("mysqlpicturetable") = tbxTable.Text
        End If

        tbxTable.Text = ""

        FillCBTables()
        SetTableValues()

        parentRef.SaveOptions()

    End Sub

    Private Sub InitializeExtendedStatusBar()

        'TODO Problems to insert and position extra panels, can it be fixed?

        Dim sbText = New System.Windows.Forms.StatusBarPanel
        Dim sbProgress = New System.Windows.Forms.StatusBarPanel

        sbText.AutoSize = _
           System.Windows.Forms.StatusBarPanelAutoSize.Spring
        sbProgress.Width = 200

        With sbDB
            .Panels.Add(sbText)
            .Panels.Add(sbProgress)

            .ShowPanels = True

            'Initial settings for custom progressbar
            .setProgressBar = 1
            .progressBar.Minimum = 0
            .progressBar.Value = 0

            'Give a stylish look to this control which we don't use
            '.progressBar.BackColorStyle = SPB.SmoothProgressBar.ColorStyle.Gradient
            '.progressBar.BackGradientMode = Drawing2D.LinearGradientMode.Vertical
            '.progressBar.BackSigmaMode = SPB.SmoothProgressBar.SigmaMode.SigmaBell
            '.progressBar.BarColorStyle = SPB.SmoothProgressBar.ColorStyle.Gradient
            '.progressBar.BarGradientMode = Drawing2D.LinearGradientMode.Vertical
            '.progressBar.BarSigmaMode = SPB.SmoothProgressBar.SigmaMode.SigmaBell

            .progressBar.TabStop = False
            .progressBar.BorderStyle = BorderStyle.None

        End With

        Me.Controls.Add(sbDB)

    End Sub


    Public Sub ExceptionToListView(ByVal exceptionType As String, ByVal ex As Exception)

        exArray = ex.ToString.Split(LineFeed)
        excounter = 0
        While excounter < exArray.Length
            exString = exArray(excounter)
            exString = exString.Replace(CarriageReturn, " ")
            exString = exString.Replace(LineFeed, " ")
            If exString.Length < 2 Then
                Exit While
            End If

            myListViewItem = lvwDBLog.Items.Add(exString)
            myListViewItem.EnsureVisible()
            myListViewItem.ForeColor = Color.Red

            excounter += 1
        End While

    End Sub


    Private Sub btnShowAllDatabases_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnShowAllDatabases.Click

        lvwDBLog.Items.Clear()

        mySQLCommandString = "SHOW DATABASES ;"

        DBCommandSuccessful = True
        DoExecuteReader()
        If DBCommandSuccessful = True Then
            If foundCount > 0 Then
                sbDB.Panels(0).Text = "Databases listed in log"
            Else
                sbDB.Panels(0).Text = "No databases found"
            End If
        Else
            sbDB.Panels(0).Text = "Failed to list databases"
        End If

    End Sub


    Private Sub btnShowAllTables_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnShowAllTables.Click

        lvwDBLog.Items.Clear()

        mySQLCommandString = "SHOW TABLES ;"

        DBCommandSuccessful = True
        DoExecuteReader()
        If DBCommandSuccessful = True Then
            If foundCount > 0 Then
                sbDB.Panels(0).Text = "Tables listed in log"
            Else
                sbDB.Panels(0).Text = "No tables found"
            End If
        Else
            sbDB.Panels(0).Text = "Failed to list tables"
        End If


    End Sub


    Private Sub btnExecuteCommand_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnExecuteCommand.Click
        'Executing your own MySQL command from with results returned in log window

        If cbDBCommand.Text = "" Then
            sbDB.Panels(0).Text = "Enter SQL command"
            Exit Sub
        End If

        lvwDBLog.Items.Clear()

        mySQLCommandString = cbDBCommand.Text

        cbDBCommand.Items.Add(mySQLCommandString)

        DBCommandSuccessful = True
        DoExecuteReader()

    End Sub


    Private Sub btnEraseSpecial_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnEraseSpecial.Click

        If tbxTable.Text = "" Then
            Exit Sub
        End If

        lvwDBLog.Items.Clear()

        OpenConnectionToDatabase()
        If Not OpenSuccessful Then
            sbDB.Panels(0).Text = "Connect to MySQL server failed"
            Exit Sub
        End If

        sbDB.Panels(0).Text = "Processing erase. Wait"

        Dim eraseSpecialThread As New Thread(New ThreadStart(AddressOf EraseSpecial))
        eraseSpecialThread.Start()
        Exit Sub

    End Sub


    Private Sub EraseSpecial()

        collectionTableName = tbxTable.Text

        Try
            mySQLCommandString = "DELETE FROM " + collectionTableName + _
            " WHERE FILEPATH <> """" ;"

            myListViewItem = lvwDBLog.Items.Add(mySQLCommandString)
            myListViewItem.EnsureVisible()
            myListViewItem.ForeColor = Color.Blue

            myCommand = New MySqlCommand(mySQLCommandString)
            myCommand.Connection = myConnection

            'ExecuteNonQuery returns integer with rows AFFECTED 

            'ExecuteScalar returns the first column of the first row in the result set, 
            'or a null reference if the result set is empty.

            result = myCommand.ExecuteNonQuery

            myListViewItem = lvwDBLog.Items.Add("SQL command processed")
            myListViewItem.EnsureVisible()
            myListViewItem.ForeColor = Color.Green

            collectionRowCount = result

            integerFormatString = Format(CInt(result), "###,###,###,###,##0")

            outputString = integerFormatString + " records deleted"

            sbDB.Panels(0).Text = outputString

            myListViewItem = lvwDBLog.Items.Add(outputString)
            myListViewItem.EnsureVisible()
            myListViewItem.ForeColor = Color.Black

            CloseConnection()

        Catch ex As MySqlException
            sbDB.Panels(0).Text = "Failed to delete records in table"
            exceptionType = "MySqlException"
            ExceptionToListView(exceptionType, ex)
        Catch ex As System.Net.Sockets.SocketException
            'Port errors
            sbDB.Panels(0).Text = "Failed to delete records in table"
            exceptionType = "System.Net.Sockets.SocketException"
            ExceptionToListView(exceptionType, ex)
        Catch ex As Exception
            'Syntax errors
            sbDB.Panels(0).Text = "Failed to delete records in table"
            exceptionType = "Exception"
            ExceptionToListView(exceptionType, ex)
        End Try


    End Sub


    Private Sub btnCopySpecial_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnCopySpecial.Click

        If tbxTable.Text = "" Then
            Exit Sub
        End If

        If tbxToTable.Text = "" Then
            sbDB.Panels(0).Text = "Enter name of table to which records should be copied"
            tbxToTable.Focus()
            Exit Sub
        End If

        lvwDBLog.Items.Clear()

        OpenConnectionToDatabase()
        If Not OpenSuccessful Then
            sbDB.Panels(0).Text = "Connect to MySQL server failed"
            Exit Sub
        End If

        sbDB.Panels(0).Text = "Processing copy. Wait"

        Dim copySpecialThread As New Thread(New ThreadStart(AddressOf CopySpecial))
        copySpecialThread.Start()
        Exit Sub
    End Sub


    Private Sub CopySpecial()

        collectionTableName = tbxTable.Text

        Dim toTable As String
        toTable = tbxToTable.Text

        Try
            mySQLCommandString = "INSERT INTO " + toTable + _
            " SELECT * FROM " + collectionTableName + _
            " WHERE FILEPATH = """" ;"

            myListViewItem = lvwDBLog.Items.Add(mySQLCommandString)
            myListViewItem.EnsureVisible()
            myListViewItem.ForeColor = Color.Blue

            myCommand = New MySqlCommand(mySQLCommandString)
            myCommand.Connection = myConnection

            tbxToTable.Text = ""

            'ExecuteNonQuery returns integer with rows AFFECTED 

            'ExecuteScalar returns the first column of the first row in the result set, 
            'or a null reference if the result set is empty.

            result = myCommand.ExecuteNonQuery

            myListViewItem = lvwDBLog.Items.Add("SQL command processed")
            myListViewItem.EnsureVisible()
            myListViewItem.ForeColor = Color.Green

            collectionRowCount = result

            integerFormatString = Format(CInt(result), "###,###,###,###,##0")

            outputString = integerFormatString + " records copied from " + _
            collectionTableName + " to " + toTable

            sbDB.Panels(0).Text = outputString

            myListViewItem = lvwDBLog.Items.Add(outputString)
            myListViewItem.EnsureVisible()
            myListViewItem.ForeColor = Color.Black

            CloseConnection()

        Catch ex As MySqlException
            sbDB.Panels(0).Text = "Failed to copy records in table"
            exceptionType = "MySqlException"
            ExceptionToListView(exceptionType, ex)
        Catch ex As System.Net.Sockets.SocketException
            'Port errors
            sbDB.Panels(0).Text = "Failed to copy records in table"
            exceptionType = "System.Net.Sockets.SocketException"
            ExceptionToListView(exceptionType, ex)
        Catch ex As Exception
            'Syntax errors
            sbDB.Panels(0).Text = "Failed to copy records in table"
            exceptionType = "Exception"
            ExceptionToListView(exceptionType, ex)
        End Try


    End Sub



    Private Sub SetControlsAvailability()

        'Depending on if database and table exists, different controls are available 

        If parentRef.htOptions.Item("mysqldatabase") = "" Then
            'Lock all input
            cbTableSelection.Enabled = False
            cbTableSelection.Text = ""
            tbxTable.Enabled = False
            tbxTable.Text = ""
            btnCreateTable.Enabled = False
            btnCreateCollection.Enabled = False
            btnCountRecords.Enabled = False
            btnDeleteTable.Enabled = False
            btnClearTable.Enabled = False
            gbCopyTable.Visible = False
            gbMovieSpecial.Visible = False
        Else
            CheckIfDatabaseExists()
            If DatabaseExists Then

                cbTableSelection.Enabled = True
                tbxTable.Enabled = True

                If cbTableSelection.SelectedIndex = 0 Then
                    cbTableSelection.Text = "Movies"

                    gbCopyTable.Visible = True
                    gbMovieSpecial.Visible = True

                    If parentRef.htOptions.Item("mysqlmovietable") = "" Then
                        btnCreateTable.Enabled = True
                        btnCreateCollection.Enabled = False
                        btnCountRecords.Enabled = False
                        btnDeleteTable.Enabled = False
                        btnClearTable.Enabled = False
                        gbMovieSpecial.Enabled = False
                        gbCopyTable.Enabled = False

                    Else
                        stringToSearchFor = parentRef.htOptions.Item("mysqlmovietable")
                        CheckIfTableExists()
                        If TableExists Then
                            btnCreateTable.Enabled = True
                            'btnCreateTable.Enabled = False
                            btnCreateCollection.Enabled = True
                            btnCountRecords.Enabled = True
                            btnDeleteTable.Enabled = True
                            btnClearTable.Enabled = True
                            gbMovieSpecial.Enabled = True
                            gbCopyTable.Enabled = True
                        Else
                            btnCreateTable.Enabled = True
                            btnCreateCollection.Enabled = False
                            btnCountRecords.Enabled = False
                            btnDeleteTable.Enabled = False
                            btnClearTable.Enabled = False
                            gbCopyTable.Enabled = False
                            gbMovieSpecial.Enabled = False
                        End If
                    End If
                Else
                    cbTableSelection.Text = "Pictures"

                    gbMovieSpecial.Visible = False

                    If parentRef.htOptions.Item("mysqlpicturetable") = "" Then

                        btnCreateTable.Enabled = True
                        btnCreateCollection.Enabled = False
                        btnCountRecords.Enabled = False
                        btnDeleteTable.Enabled = False
                        btnClearTable.Enabled = False
                        gbCopyTable.Enabled = False
                        gbMovieSpecial.Visible = False
                    Else
                        stringToSearchFor = parentRef.htOptions.Item("mysqlpicturetable")
                        CheckIfTableExists()
                        If TableExists Then
                            btnCreateTable.Enabled = True
                            btnCreateCollection.Enabled = True
                            btnCountRecords.Enabled = True
                            btnDeleteTable.Enabled = True
                            btnClearTable.Enabled = True
                            gbCopyTable.Enabled = True
                            gbMovieSpecial.Visible = False
                        Else
                            btnCreateTable.Enabled = True
                            btnCreateCollection.Enabled = False
                            btnCountRecords.Enabled = False
                            btnDeleteTable.Enabled = False
                            btnClearTable.Enabled = False
                            gbCopyTable.Enabled = False
                            gbMovieSpecial.Visible = False
                        End If
                    End If
                End If
            Else
                cbTableSelection.Enabled = False
                tbxTable.Enabled = False
                btnCreateTable.Enabled = False
                btnCreateCollection.Enabled = False
                btnCountRecords.Enabled = False
                btnDeleteTable.Enabled = False
                btnClearTable.Enabled = False
                gbCopyTable.Enabled = False
                If cbTableSelection.Text = "Movies" Then
                    gbMovieSpecial.Enabled = False
                Else
                    gbMovieSpecial.Visible = False
                End If
            End If
        End If

    End Sub


    Private Sub CheckIfDatabaseExists()

        DatabaseExists = False

        stringToSearchFor = parentRef.htOptions.Item("mysqldatabase")
        stringToSearchFor = stringToSearchFor.ToLower

        mySQLCommandString = "SHOW DATABASES ;"

        Dim DBOutputString As String

        Try
            OpenConnectionToDatabaseWithNoLogging()

            If Not myConnection Is Nothing Then
                If myConnection.State = ConnectionState.Open Then
                    myCommand = New MySqlCommand(mySQLCommandString)

                    myCommand.Connection = myConnection

                    Dim myReader As MySqlDataReader
                    myReader = myCommand.ExecuteReader()
                    While myReader.Read()
                        DBOutputString = myReader.GetString(0)
                        DBOutputString = DBOutputString.ToLower

                        If DBOutputString = stringToSearchFor Then
                            DatabaseExists = True
                            Exit Sub
                        End If

                    End While
                    myReader.Close()
                End If
            End If

        Catch ex As MySqlException
            exceptionType = "MySqlException"
            ExceptionToListView(exceptionType, ex)
            DBCommandSuccessful = False
        Catch ex As System.Net.Sockets.SocketException
            exceptionType = "System.Net.Sockets.SocketException"
            ExceptionToListView(exceptionType, ex)
            DBCommandSuccessful = False
        Catch ex As Exception
            exceptionType = "Exception"
            ExceptionToListView(exceptionType, ex)
            DBCommandSuccessful = False
        End Try

    End Sub


    Private Sub CheckIfTableExists()
        TableExists = False

        mySQLCommandString = "SHOW TABLES FROM " + parentRef.htOptions.Item("mysqldatabase") + _
        " ;"

        stringToSearchFor = stringToSearchFor.ToLower

        Dim DBOutputString As String

        Try
            OpenConnectionToDatabaseWithNoLogging()

            If Not myConnection Is Nothing Then
                If myConnection.State = ConnectionState.Open Then
                    myCommand = New MySqlCommand(mySQLCommandString)

                    myCommand.Connection = myConnection

                    Dim myReader As MySqlDataReader
                    myReader = myCommand.ExecuteReader()
                    While myReader.Read()
                        DBOutputString = myReader.GetString(0)
                        DBOutputString = DBOutputString.ToLower

                        If DBOutputString = stringToSearchFor Then
                            TableExists = True
                            Exit Sub
                        End If

                    End While
                    myReader.Close()

                End If
            End If

        Catch ex As MySqlException
            exceptionType = "MySqlException"
            ExceptionToListView(exceptionType, ex)
            DBCommandSuccessful = False
        Catch ex As System.Net.Sockets.SocketException
            exceptionType = "System.Net.Sockets.SocketException"
            ExceptionToListView(exceptionType, ex)
            DBCommandSuccessful = False
        Catch ex As Exception
            exceptionType = "Exception"
            ExceptionToListView(exceptionType, ex)
            DBCommandSuccessful = False
        End Try

    End Sub



    Private Sub FillCBTables()

        TableExists = False

        mySQLCommandString = "SHOW TABLES FROM " + parentRef.htOptions.Item("mysqldatabase") + _
        " ;"

        Dim DBOutputString As String

        Try
            OpenConnectionToDatabaseWithNoLogging()

            If Not myConnection Is Nothing Then
                If myConnection.State = ConnectionState.Open Then
                    myCommand = New MySqlCommand(mySQLCommandString)

                    myCommand.Connection = myConnection

                    Dim myReader As MySqlDataReader
                    myReader = myCommand.ExecuteReader()
                    While myReader.Read()
                        DBOutputString = myReader.GetString(0)
                    End While
                    myReader.Close()

                End If
            End If

        Catch ex As MySqlException
            exceptionType = "MySqlException"
            ExceptionToListView(exceptionType, ex)
            DBCommandSuccessful = False
        Catch ex As System.Net.Sockets.SocketException
            exceptionType = "System.Net.Sockets.SocketException"
            ExceptionToListView(exceptionType, ex)
            DBCommandSuccessful = False
        Catch ex As Exception
            exceptionType = "Exception"
            ExceptionToListView(exceptionType, ex)
            DBCommandSuccessful = False
        End Try

    End Sub


End Class
