Imports System
Imports System.IO
Imports System.Globalization


Public Class frmFTP
    Inherits System.Windows.Forms.Form

    Public Shared parentRef As frmMain

    Public ReportSpecialError As Boolean

    Dim outputMessage As String

    Public FieldDelimiter As String = "|"
    Public SpecialFieldDelimiter As String = ":"
    Public fieldSplit As String()

    Public FTPServerName As String
    Public FTPServer As String
    Public FTPUsername As String
    Public FTPPassword As String
    Public FTPServerPort As Integer
    Public FTPPassive As Boolean
    Public useSSL As Boolean

    Public exString As String
    Public excounter As Integer

    Dim counter As Integer = 0
    Dim exArray As String()

    Public FTPLogString As String
    Public currentDirectory As String

    Public ContinueFTPAccess As Boolean

    Public startFolder As String

    Public FTPinvoke As Dart.PowerTCP.SecureFtp.Invoke
    Public FTPlisting As Dart.PowerTCP.SecureFtp.Listing

    Public FTPSecureinvoke As Dart.PowerTCP.SecureFtp.Invoke
    Public FTPSecurelisting As Dart.PowerTCP.SecureFtp.Listing

    Public HorizontalTab = Chr(9)
    Public LineFeed = Chr(10)
    Public CarriageReturn = Chr(13)

    Public FTPCommandString As String

    Public exceptionType As String

    Friend WithEvents Ftp2 As Dart.PowerTCP.SecureFtp.Ftp

    Public myListViewItem As ListViewItem


#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()

        miClearLog.Visible = False


    End Sub

    'Form overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    'Required by the Windows Form Designer
    Private components As System.ComponentModel.IContainer

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    Friend WithEvents MainMenu1 As System.Windows.Forms.MainMenu
    Friend WithEvents MenuItem1 As System.Windows.Forms.MenuItem
    Friend WithEvents btnUpFTP As System.Windows.Forms.Button
    Friend WithEvents Label8 As System.Windows.Forms.Label
    Friend WithEvents sbFTP As System.Windows.Forms.StatusBar
    Friend WithEvents lvwFTP As System.Windows.Forms.ListView
    Friend WithEvents btnFTPExit As System.Windows.Forms.Button
    Friend WithEvents miFTPLogin As System.Windows.Forms.MenuItem
    Friend WithEvents clhName As System.Windows.Forms.ColumnHeader
    Friend WithEvents clhSize As System.Windows.Forms.ColumnHeader
    Friend WithEvents ImageList1 As System.Windows.Forms.ImageList
    Friend WithEvents tbxCurrentDirectory As System.Windows.Forms.TextBox
    Friend WithEvents chlType As System.Windows.Forms.ColumnHeader
    Friend WithEvents btnStartFolder As System.Windows.Forms.Button
    Friend WithEvents tbxFTPCommandInput As System.Windows.Forms.TextBox
    Friend WithEvents btnFTPCommandExecute As System.Windows.Forms.Button
    Friend WithEvents tbxStartFolder As System.Windows.Forms.TextBox
    Friend WithEvents TabControl1 As System.Windows.Forms.TabControl
    Friend WithEvents TabFTPLogin As System.Windows.Forms.TabPage
    Friend WithEvents TabFTPLoginLog As System.Windows.Forms.TabPage
    Friend WithEvents tbxAvoidPictureFolders As System.Windows.Forms.TextBox
    Friend WithEvents tbxAvoidMovieFolders As System.Windows.Forms.TextBox
    Friend WithEvents GroupBox1 As System.Windows.Forms.GroupBox
    Friend WithEvents Label1 As System.Windows.Forms.Label
    Friend WithEvents btnFTPCommandExecute2 As System.Windows.Forms.Button
    Friend WithEvents tbxFTPCommandInput2 As System.Windows.Forms.TextBox
    Friend WithEvents btnFTPLogExit As System.Windows.Forms.Button
    Friend WithEvents ContextMenu1 As System.Windows.Forms.ContextMenu
    Friend WithEvents miFTPLogout As System.Windows.Forms.MenuItem
    Friend WithEvents miFTPExit As System.Windows.Forms.MenuItem
    Friend WithEvents lvwFTPServerMessages As System.Windows.Forms.ListView
    Friend WithEvents ColumnHeader1 As System.Windows.Forms.ColumnHeader
    Friend WithEvents miCopy As System.Windows.Forms.MenuItem
    Friend WithEvents miClearlog As System.Windows.Forms.MenuItem
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.components = New System.ComponentModel.Container
        Dim resources As System.ComponentModel.ComponentResourceManager = New System.ComponentModel.ComponentResourceManager(GetType(frmFTP))
        Me.MainMenu1 = New System.Windows.Forms.MainMenu(Me.components)
        Me.MenuItem1 = New System.Windows.Forms.MenuItem
        Me.miFTPLogin = New System.Windows.Forms.MenuItem
        Me.miFTPLogout = New System.Windows.Forms.MenuItem
        Me.miFTPExit = New System.Windows.Forms.MenuItem
        Me.btnUpFTP = New System.Windows.Forms.Button
        Me.lvwFTP = New System.Windows.Forms.ListView
        Me.clhName = New System.Windows.Forms.ColumnHeader
        Me.clhSize = New System.Windows.Forms.ColumnHeader
        Me.chlType = New System.Windows.Forms.ColumnHeader
        Me.ImageList1 = New System.Windows.Forms.ImageList(Me.components)
        Me.tbxAvoidPictureFolders = New System.Windows.Forms.TextBox
        Me.btnFTPExit = New System.Windows.Forms.Button
        Me.tbxCurrentDirectory = New System.Windows.Forms.TextBox
        Me.Label8 = New System.Windows.Forms.Label
        Me.sbFTP = New System.Windows.Forms.StatusBar
        Me.btnStartFolder = New System.Windows.Forms.Button
        Me.tbxFTPCommandInput = New System.Windows.Forms.TextBox
        Me.btnFTPCommandExecute = New System.Windows.Forms.Button
        Me.tbxStartFolder = New System.Windows.Forms.TextBox
        Me.TabControl1 = New System.Windows.Forms.TabControl
        Me.ContextMenu1 = New System.Windows.Forms.ContextMenu
        Me.miCopy = New System.Windows.Forms.MenuItem
        Me.miClearlog = New System.Windows.Forms.MenuItem
        Me.TabFTPLogin = New System.Windows.Forms.TabPage
        Me.GroupBox1 = New System.Windows.Forms.GroupBox
        Me.Label1 = New System.Windows.Forms.Label
        Me.tbxAvoidMovieFolders = New System.Windows.Forms.TextBox
        Me.TabFTPLoginLog = New System.Windows.Forms.TabPage
        Me.lvwFTPServerMessages = New System.Windows.Forms.ListView
        Me.ColumnHeader1 = New System.Windows.Forms.ColumnHeader
        Me.btnFTPLogExit = New System.Windows.Forms.Button
        Me.tbxFTPCommandInput2 = New System.Windows.Forms.TextBox
        Me.btnFTPCommandExecute2 = New System.Windows.Forms.Button
        Me.Ftp2 = New Dart.PowerTCP.SecureFtp.Ftp(Me.components)
        Me.TabControl1.SuspendLayout()
        Me.TabFTPLogin.SuspendLayout()
        Me.GroupBox1.SuspendLayout()
        Me.TabFTPLoginLog.SuspendLayout()
        Me.SuspendLayout()
        '
        'MainMenu1
        '
        Me.MainMenu1.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.MenuItem1})
        '
        'MenuItem1
        '
        Me.MenuItem1.Index = 0
        Me.MenuItem1.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.miFTPLogin, Me.miFTPLogout, Me.miFTPExit})
        Me.MenuItem1.Text = "FTP"
        '
        'miFTPLogin
        '
        Me.miFTPLogin.Index = 0
        Me.miFTPLogin.Text = "Login"
        '
        'miFTPLogout
        '
        Me.miFTPLogout.Index = 1
        Me.miFTPLogout.Text = "Logout"
        '
        'miFTPExit
        '
        Me.miFTPExit.Index = 2
        Me.miFTPExit.Text = "Exit"
        '
        'btnUpFTP
        '
        Me.btnUpFTP.Anchor = CType((System.Windows.Forms.AnchorStyles.Bottom Or System.Windows.Forms.AnchorStyles.Left), System.Windows.Forms.AnchorStyles)
        Me.btnUpFTP.FlatStyle = System.Windows.Forms.FlatStyle.System
        Me.btnUpFTP.Location = New System.Drawing.Point(8, 294)
        Me.btnUpFTP.Name = "btnUpFTP"
        Me.btnUpFTP.Size = New System.Drawing.Size(88, 32)
        Me.btnUpFTP.TabIndex = 70
        Me.btnUpFTP.Text = "Up one folder"
        '
        'lvwFTP
        '
        Me.lvwFTP.Anchor = CType((((System.Windows.Forms.AnchorStyles.Top Or System.Windows.Forms.AnchorStyles.Bottom) _
                    Or System.Windows.Forms.AnchorStyles.Left) _
                    Or System.Windows.Forms.AnchorStyles.Right), System.Windows.Forms.AnchorStyles)
        Me.lvwFTP.Columns.AddRange(New System.Windows.Forms.ColumnHeader() {Me.clhName, Me.clhSize, Me.chlType})
        Me.lvwFTP.Location = New System.Drawing.Point(8, 56)
        Me.lvwFTP.MultiSelect = False
        Me.lvwFTP.Name = "lvwFTP"
        Me.lvwFTP.Size = New System.Drawing.Size(384, 230)
        Me.lvwFTP.SmallImageList = Me.ImageList1
        Me.lvwFTP.TabIndex = 5
        Me.lvwFTP.UseCompatibleStateImageBehavior = False
        Me.lvwFTP.View = System.Windows.Forms.View.Details
        '
        'clhName
        '
        Me.clhName.Text = "Name"
        Me.clhName.Width = 200
        '
        'clhSize
        '
        Me.clhSize.Text = "Size"
        Me.clhSize.Width = 100
        '
        'chlType
        '
        Me.chlType.Text = "Type"
        Me.chlType.Width = 80
        '
        'ImageList1
        '
        Me.ImageList1.ImageStream = CType(resources.GetObject("ImageList1.ImageStream"), System.Windows.Forms.ImageListStreamer)
        Me.ImageList1.TransparentColor = System.Drawing.Color.Transparent
        Me.ImageList1.Images.SetKeyName(0, "")
        Me.ImageList1.Images.SetKeyName(1, "")
        '
        'tbxAvoidPictureFolders
        '
        Me.tbxAvoidPictureFolders.Anchor = CType(((System.Windows.Forms.AnchorStyles.Top Or System.Windows.Forms.AnchorStyles.Bottom) _
                    Or System.Windows.Forms.AnchorStyles.Left), System.Windows.Forms.AnchorStyles)
        Me.tbxAvoidPictureFolders.Location = New System.Drawing.Point(128, 32)
        Me.tbxAvoidPictureFolders.Multiline = True
        Me.tbxAvoidPictureFolders.Name = "tbxAvoidPictureFolders"
        Me.tbxAvoidPictureFolders.ScrollBars = System.Windows.Forms.ScrollBars.Vertical
        Me.tbxAvoidPictureFolders.Size = New System.Drawing.Size(112, 190)
        Me.tbxAvoidPictureFolders.TabIndex = 6
        '
        'btnFTPExit
        '
        Me.btnFTPExit.Anchor = CType((System.Windows.Forms.AnchorStyles.Bottom Or System.Windows.Forms.AnchorStyles.Right), System.Windows.Forms.AnchorStyles)
        Me.btnFTPExit.FlatStyle = System.Windows.Forms.FlatStyle.System
        Me.btnFTPExit.Location = New System.Drawing.Point(568, 294)
        Me.btnFTPExit.Name = "btnFTPExit"
        Me.btnFTPExit.Size = New System.Drawing.Size(88, 32)
        Me.btnFTPExit.TabIndex = 80
        Me.btnFTPExit.Text = "Exit"
        '
        'tbxCurrentDirectory
        '
        Me.tbxCurrentDirectory.Location = New System.Drawing.Point(8, 16)
        Me.tbxCurrentDirectory.Name = "tbxCurrentDirectory"
        Me.tbxCurrentDirectory.Size = New System.Drawing.Size(288, 20)
        Me.tbxCurrentDirectory.TabIndex = 40
        '
        'Label8
        '
        Me.Label8.Anchor = CType((System.Windows.Forms.AnchorStyles.Top Or System.Windows.Forms.AnchorStyles.Right), System.Windows.Forms.AnchorStyles)
        Me.Label8.FlatStyle = System.Windows.Forms.FlatStyle.System
        Me.Label8.Location = New System.Drawing.Point(8, 16)
        Me.Label8.Name = "Label8"
        Me.Label8.Size = New System.Drawing.Size(88, 16)
        Me.Label8.TabIndex = 15
        Me.Label8.Text = "movie download"
        '
        'sbFTP
        '
        Me.sbFTP.Location = New System.Drawing.Point(0, 369)
        Me.sbFTP.Name = "sbFTP"
        Me.sbFTP.Size = New System.Drawing.Size(688, 22)
        Me.sbFTP.TabIndex = 16
        '
        'btnStartFolder
        '
        Me.btnStartFolder.FlatStyle = System.Windows.Forms.FlatStyle.System
        Me.btnStartFolder.Location = New System.Drawing.Point(320, 8)
        Me.btnStartFolder.Name = "btnStartFolder"
        Me.btnStartFolder.Size = New System.Drawing.Size(88, 32)
        Me.btnStartFolder.TabIndex = 19
        Me.btnStartFolder.Text = "Set startfolder"
        '
        'tbxFTPCommandInput
        '
        Me.tbxFTPCommandInput.Anchor = CType((System.Windows.Forms.AnchorStyles.Bottom Or System.Windows.Forms.AnchorStyles.Left), System.Windows.Forms.AnchorStyles)
        Me.tbxFTPCommandInput.Location = New System.Drawing.Point(224, 302)
        Me.tbxFTPCommandInput.Name = "tbxFTPCommandInput"
        Me.tbxFTPCommandInput.Size = New System.Drawing.Size(168, 20)
        Me.tbxFTPCommandInput.TabIndex = 50
        '
        'btnFTPCommandExecute
        '
        Me.btnFTPCommandExecute.Anchor = CType((System.Windows.Forms.AnchorStyles.Bottom Or System.Windows.Forms.AnchorStyles.Left), System.Windows.Forms.AnchorStyles)
        Me.btnFTPCommandExecute.FlatStyle = System.Windows.Forms.FlatStyle.System
        Me.btnFTPCommandExecute.Location = New System.Drawing.Point(120, 294)
        Me.btnFTPCommandExecute.Name = "btnFTPCommandExecute"
        Me.btnFTPCommandExecute.Size = New System.Drawing.Size(88, 32)
        Me.btnFTPCommandExecute.TabIndex = 60
        Me.btnFTPCommandExecute.Text = "Execute command"
        '
        'tbxStartFolder
        '
        Me.tbxStartFolder.Location = New System.Drawing.Point(416, 16)
        Me.tbxStartFolder.Name = "tbxStartFolder"
        Me.tbxStartFolder.Size = New System.Drawing.Size(240, 20)
        Me.tbxStartFolder.TabIndex = 81
        '
        'TabControl1
        '
        Me.TabControl1.Anchor = CType((((System.Windows.Forms.AnchorStyles.Top Or System.Windows.Forms.AnchorStyles.Bottom) _
                    Or System.Windows.Forms.AnchorStyles.Left) _
                    Or System.Windows.Forms.AnchorStyles.Right), System.Windows.Forms.AnchorStyles)
        Me.TabControl1.ContextMenu = Me.ContextMenu1
        Me.TabControl1.Controls.Add(Me.TabFTPLogin)
        Me.TabControl1.Controls.Add(Me.TabFTPLoginLog)
        Me.TabControl1.Location = New System.Drawing.Point(0, 0)
        Me.TabControl1.Name = "TabControl1"
        Me.TabControl1.SelectedIndex = 0
        Me.TabControl1.Size = New System.Drawing.Size(680, 358)
        Me.TabControl1.TabIndex = 82
        '
        'ContextMenu1
        '
        Me.ContextMenu1.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.miCopy, Me.miClearlog})
        '
        'miCopy
        '
        Me.miCopy.Index = 0
        Me.miCopy.Text = "Copy"
        '
        'miClearlog
        '
        Me.miClearlog.Index = 1
        Me.miClearlog.Text = "Clear log"
        '
        'TabFTPLogin
        '
        Me.TabFTPLogin.Controls.Add(Me.GroupBox1)
        Me.TabFTPLogin.Controls.Add(Me.btnUpFTP)
        Me.TabFTPLogin.Controls.Add(Me.tbxCurrentDirectory)
        Me.TabFTPLogin.Controls.Add(Me.lvwFTP)
        Me.TabFTPLogin.Controls.Add(Me.btnStartFolder)
        Me.TabFTPLogin.Controls.Add(Me.tbxStartFolder)
        Me.TabFTPLogin.Controls.Add(Me.btnFTPExit)
        Me.TabFTPLogin.Controls.Add(Me.btnFTPCommandExecute)
        Me.TabFTPLogin.Controls.Add(Me.tbxFTPCommandInput)
        Me.TabFTPLogin.Location = New System.Drawing.Point(4, 22)
        Me.TabFTPLogin.Name = "TabFTPLogin"
        Me.TabFTPLogin.Size = New System.Drawing.Size(672, 332)
        Me.TabFTPLogin.TabIndex = 0
        Me.TabFTPLogin.Text = "FTP"
        '
        'GroupBox1
        '
        Me.GroupBox1.Anchor = CType(((System.Windows.Forms.AnchorStyles.Top Or System.Windows.Forms.AnchorStyles.Bottom) _
                    Or System.Windows.Forms.AnchorStyles.Right), System.Windows.Forms.AnchorStyles)
        Me.GroupBox1.Controls.Add(Me.Label1)
        Me.GroupBox1.Controls.Add(Me.Label8)
        Me.GroupBox1.Controls.Add(Me.tbxAvoidMovieFolders)
        Me.GroupBox1.Controls.Add(Me.tbxAvoidPictureFolders)
        Me.GroupBox1.FlatStyle = System.Windows.Forms.FlatStyle.System
        Me.GroupBox1.Location = New System.Drawing.Point(408, 56)
        Me.GroupBox1.Name = "GroupBox1"
        Me.GroupBox1.Size = New System.Drawing.Size(248, 230)
        Me.GroupBox1.TabIndex = 83
        Me.GroupBox1.TabStop = False
        Me.GroupBox1.Text = "Avoid these folders during"
        '
        'Label1
        '
        Me.Label1.FlatStyle = System.Windows.Forms.FlatStyle.System
        Me.Label1.Location = New System.Drawing.Point(128, 16)
        Me.Label1.Name = "Label1"
        Me.Label1.Size = New System.Drawing.Size(100, 16)
        Me.Label1.TabIndex = 83
        Me.Label1.Text = "picture download"
        '
        'tbxAvoidMovieFolders
        '
        Me.tbxAvoidMovieFolders.Anchor = CType(((System.Windows.Forms.AnchorStyles.Top Or System.Windows.Forms.AnchorStyles.Bottom) _
                    Or System.Windows.Forms.AnchorStyles.Left), System.Windows.Forms.AnchorStyles)
        Me.tbxAvoidMovieFolders.Location = New System.Drawing.Point(8, 32)
        Me.tbxAvoidMovieFolders.Multiline = True
        Me.tbxAvoidMovieFolders.Name = "tbxAvoidMovieFolders"
        Me.tbxAvoidMovieFolders.ScrollBars = System.Windows.Forms.ScrollBars.Vertical
        Me.tbxAvoidMovieFolders.Size = New System.Drawing.Size(112, 190)
        Me.tbxAvoidMovieFolders.TabIndex = 82
        '
        'TabFTPLoginLog
        '
        Me.TabFTPLoginLog.Controls.Add(Me.lvwFTPServerMessages)
        Me.TabFTPLoginLog.Controls.Add(Me.btnFTPLogExit)
        Me.TabFTPLoginLog.Controls.Add(Me.tbxFTPCommandInput2)
        Me.TabFTPLoginLog.Controls.Add(Me.btnFTPCommandExecute2)
        Me.TabFTPLoginLog.Location = New System.Drawing.Point(4, 22)
        Me.TabFTPLoginLog.Name = "TabFTPLoginLog"
        Me.TabFTPLoginLog.Size = New System.Drawing.Size(672, 332)
        Me.TabFTPLoginLog.TabIndex = 1
        Me.TabFTPLoginLog.Text = "Log"
        '
        'lvwFTPServerMessages
        '
        Me.lvwFTPServerMessages.Anchor = CType((((System.Windows.Forms.AnchorStyles.Top Or System.Windows.Forms.AnchorStyles.Bottom) _
                    Or System.Windows.Forms.AnchorStyles.Left) _
                    Or System.Windows.Forms.AnchorStyles.Right), System.Windows.Forms.AnchorStyles)
        Me.lvwFTPServerMessages.Columns.AddRange(New System.Windows.Forms.ColumnHeader() {Me.ColumnHeader1})
        Me.lvwFTPServerMessages.HeaderStyle = System.Windows.Forms.ColumnHeaderStyle.None
        Me.lvwFTPServerMessages.Location = New System.Drawing.Point(8, 8)
        Me.lvwFTPServerMessages.Name = "lvwFTPServerMessages"
        Me.lvwFTPServerMessages.Size = New System.Drawing.Size(656, 270)
        Me.lvwFTPServerMessages.TabIndex = 82
        Me.lvwFTPServerMessages.UseCompatibleStateImageBehavior = False
        Me.lvwFTPServerMessages.View = System.Windows.Forms.View.Details
        '
        'ColumnHeader1
        '
        Me.ColumnHeader1.Text = ""
        Me.ColumnHeader1.Width = 600
        '
        'btnFTPLogExit
        '
        Me.btnFTPLogExit.Anchor = CType((System.Windows.Forms.AnchorStyles.Bottom Or System.Windows.Forms.AnchorStyles.Right), System.Windows.Forms.AnchorStyles)
        Me.btnFTPLogExit.FlatStyle = System.Windows.Forms.FlatStyle.System
        Me.btnFTPLogExit.Location = New System.Drawing.Point(568, 294)
        Me.btnFTPLogExit.Name = "btnFTPLogExit"
        Me.btnFTPLogExit.Size = New System.Drawing.Size(88, 32)
        Me.btnFTPLogExit.TabIndex = 81
        Me.btnFTPLogExit.Text = "Exit"
        '
        'tbxFTPCommandInput2
        '
        Me.tbxFTPCommandInput2.Anchor = CType((System.Windows.Forms.AnchorStyles.Bottom Or System.Windows.Forms.AnchorStyles.Left), System.Windows.Forms.AnchorStyles)
        Me.tbxFTPCommandInput2.Location = New System.Drawing.Point(120, 302)
        Me.tbxFTPCommandInput2.Name = "tbxFTPCommandInput2"
        Me.tbxFTPCommandInput2.Size = New System.Drawing.Size(168, 20)
        Me.tbxFTPCommandInput2.TabIndex = 62
        '
        'btnFTPCommandExecute2
        '
        Me.btnFTPCommandExecute2.Anchor = CType((System.Windows.Forms.AnchorStyles.Bottom Or System.Windows.Forms.AnchorStyles.Left), System.Windows.Forms.AnchorStyles)
        Me.btnFTPCommandExecute2.FlatStyle = System.Windows.Forms.FlatStyle.System
        Me.btnFTPCommandExecute2.Location = New System.Drawing.Point(16, 294)
        Me.btnFTPCommandExecute2.Name = "btnFTPCommandExecute2"
        Me.btnFTPCommandExecute2.Size = New System.Drawing.Size(88, 32)
        Me.btnFTPCommandExecute2.TabIndex = 61
        Me.btnFTPCommandExecute2.Text = "FTP command"
        '
        'Ftp2
        '
        Me.Ftp2.ClientDataPort = ""
        '
        '
        '
        Me.Ftp2.Connection.DoEvents = False
        Me.Ftp2.Editor = Me.Ftp2
        Me.Ftp2.Password = ""
        Me.Ftp2.Server = ""
        Me.Ftp2.Username = ""
        '
        'frmFTP
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.ClientSize = New System.Drawing.Size(688, 391)
        Me.Controls.Add(Me.TabControl1)
        Me.Controls.Add(Me.sbFTP)
        Me.Icon = CType(resources.GetObject("$this.Icon"), System.Drawing.Icon)
        Me.Menu = Me.MainMenu1
        Me.Name = "frmFTP"
        Me.TabControl1.ResumeLayout(False)
        Me.TabFTPLogin.ResumeLayout(False)
        Me.TabFTPLogin.PerformLayout()
        Me.GroupBox1.ResumeLayout(False)
        Me.GroupBox1.PerformLayout()
        Me.TabFTPLoginLog.ResumeLayout(False)
        Me.TabFTPLoginLog.PerformLayout()
        Me.ResumeLayout(False)

    End Sub

#End Region


    Private Sub miFTPLogin_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles miFTPLogin.Click

        If Ftp2.Connected Then
            outputMessage = "Already connected to FTP"
            myListViewItem = lvwFTPServerMessages.Items.Add(outputMessage)
            myListViewItem.EnsureVisible()

        Else
            PrepareLogin()
            ListFTP()
        End If

    End Sub

    Private Sub miFTPLogout_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles miFTPLogout.Click
        Ftp2Close()
    End Sub

    Private Sub miFTPExit_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles miFTPExit.Click
        Ftp2Close()
        Me.Dispose()
    End Sub

    Private Sub btnFTPLogin_Click(ByVal sender As System.Object, ByVal e As System.EventArgs)
        PrepareLogin()
        ListFTP()
    End Sub

    Private Sub btnFTPExit_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnFTPExit.Click
        FinishUp()
        Me.Dispose()
    End Sub

    Private Sub btnFTPLogExit_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnFTPLogExit.Click
        FinishUp()
        Me.Dispose()
    End Sub


    Private Sub FinishUp()

        If tbxStartFolder.Text <> "" Then
            parentRef.tbxStartFolder.Text = tbxStartFolder.Text
        End If

        parentRef.tbxAvoidMovieFolders.Lines = tbxAvoidMovieFolders.Lines
        parentRef.tbxAvoidPictureFolders.Lines = tbxAvoidPictureFolders.Lines

        parentRef.SaveFieldsTohtFTPSiteFTPLogin()

        parentRef.SaveFTPSite()

        Ftp2Close()

    End Sub


    Private Sub btnStartFolder_Click_1(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnStartFolder.Click
        Dim selecteditems As ListView.SelectedListViewItemCollection = _
            lvwFTP.SelectedItems
        Dim item As ListViewItem
        Dim selectedCount As Integer = 0

        For Each item In selecteditems
            selectedCount += 1
        Next

        If selectedCount = 0 Then
            sbFTP.Text = "Select a directory in list, then press this button to save it as " + _
                "start directory"
        Else
            If item.SubItems(2).Text = "file" Then
                sbFTP.Text = "Select a directory in the list to be starting directory"
            Else
                If tbxCurrentDirectory.Text.Length > 1 Then
                    startFolder = tbxCurrentDirectory.Text + "/" + item.SubItems(0).Text
                Else
                    startFolder = "/" + item.SubItems(0).Text
                End If
                tbxStartFolder.Text = startFolder
                sbFTP.Text = "startFolder set to " + startFolder
            End If
        End If

    End Sub


    Private Sub btnUpFTP_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnUpFTP.Click

        Try
            FTPSecureinvoke = Ftp2.Invoke(Dart.PowerTCP.SecureFtp.FtpCommand.ChangeDirUp, tbxCurrentDirectory.Text)
            currentDirectory = Ftp2.GetDirectory
            tbxCurrentDirectory.Text = currentDirectory
        Catch ex As Exception
            outputMessage = "Change directory up command failed"
            myListViewItem = lvwFTPServerMessages.Items.Add(outputMessage)
            myListViewItem.EnsureVisible()
            myListViewItem.ForeColor = Color.Red

        End Try

        ListFTP()

    End Sub


    Private Sub lvwFTP_DoubleClick(ByVal sender As Object, ByVal e As System.EventArgs) Handles lvwFTP.DoubleClick

        Dim selecteditems As ListView.SelectedListViewItemCollection = _
            lvwFTP.SelectedItems
        Dim item As ListViewItem
        Dim selectedCount As Integer = 0

        Dim selectedDirectory As String
        Dim completePath As String

        For Each item In selecteditems
            selectedDirectory = item.SubItems(0).Text
            selectedCount += 1
        Next

        'Unix uses "/" and DOS uses "\" for path names. Is there a problem here?
        'Will this work everywhere or is it necessary to extract proper path divider
        '   in home directory and use it everywhere?
        If currentDirectory.Length > 1 Then
            completePath = currentDirectory + "/" + selectedDirectory
        Else
            completePath = "/" + selectedDirectory
        End If

        Try
            FTPSecureinvoke = Ftp2.Invoke(Dart.PowerTCP.SecureFtp.FtpCommand.ChangeDir, completePath)
        Catch ex As System.Net.ProtocolViolationException
            'Better handling later
            outputMessage = "Probably OK. We try to list  " + completePath
            myListViewItem = lvwFTPServerMessages.Items.Add(outputMessage)
            myListViewItem.EnsureVisible()
            myListViewItem.ForeColor = Color.Red

        Catch ex As Exception
            outputMessage = "Failed to change directory to  " + completePath
            myListViewItem = lvwFTPServerMessages.Items.Add(outputMessage)
            myListViewItem.EnsureVisible()
            myListViewItem.ForeColor = Color.Red

            Exit Sub
        End Try


        ListFTP()

    End Sub


    Public Sub ListFTP()
        Dim SuccessfulListing As Boolean = True

        Try
            FTPSecurelisting = Ftp2.List("", True)
        Catch ex As System.Net.ProtocolViolationException
            exceptionType = "System.Net.ProtocolViolationException"
            FTPException(exceptionType, ex)
            SuccessfulListing = False
            sbFTP.Text = "Login failed"
        Catch ex As System.Net.Sockets.SocketException
            exceptionType = "System.Net.Sockets.SocketException"
            FTPException(exceptionType, ex)
            SuccessfulListing = False
            sbFTP.Text = "Login failed. Check ip number and port"
        Catch ex As Exception
            exceptionType = "Exception"
            FTPException(exceptionType, ex)
            SuccessfulListing = False
            sbFTP.Text = "Login failed"
        End Try


        If SuccessfulListing Then
            MoveResultToListView()
            sbFTP.Text = ""
        End If

    End Sub


    Public Sub MoveResultToListView()

        Dim cString As String
        Dim lvwItem As ListViewItem
        lvwFTP.Items.Clear()

        If FTPSecurelisting.Format <> Dart.PowerTCP.SecureFtp.ListingFormat.Unknown Then

            currentDirectory = Ftp2.GetDirectory
            tbxCurrentDirectory.Text = currentDirectory

            Dim le As Dart.PowerTCP.SecureFtp.ListEntry

            For Each le In FTPSecurelisting
                If le.Type = Dart.PowerTCP.SecureFtp.EntryType.File Then
                    '1 is file icon
                    lvwItem = lvwFTP.Items.Add(le.Name, 1)
                    cString = Format(le.Size, "###,###,###,###,###")
                    lvwItem.SubItems.Add(cString)
                    lvwItem.SubItems.Add("file")
                End If

                If le.Type = Dart.PowerTCP.SecureFtp.EntryType.Directory Then
                    '0 is folder icon
                    lvwItem = lvwFTP.Items.Add(le.Name, 0)
                    lvwItem.SubItems.Add("")
                    lvwItem.SubItems.Add("folder")
                End If

                If le.Type = Dart.PowerTCP.SecureFtp.EntryType.Link Then
                    '0 is folder icon
                    lvwItem = lvwFTP.Items.Add(le.Destination, 0)
                    lvwItem.SubItems.Add("")
                    lvwItem.SubItems.Add("link")
                End If

            Next
        Else
            outputMessage = "Format of FTP response unknown."
            myListViewItem = lvwFTPServerMessages.Items.Add(outputMessage)
            myListViewItem.EnsureVisible()


            Dim le As Dart.PowerTCP.SecureFtp.ListEntry
            For Each le In FTPlisting
                myListViewItem = lvwFTPServerMessages.Items.Add(le.Text)
                myListViewItem.EnsureVisible()

            Next
        End If

    End Sub


    Private Sub Ftp2_Trace(ByVal sender As Object, ByVal e As Dart.PowerTCP.SecureFtp.SegmentEventArgs) Handles Ftp2.Trace
        FTPLogString = e.Segment.ToString
        Dim CRLFposition As Integer
        CRLFposition = FTPLogString.IndexOf(CarriageReturn)
        If CRLFposition >= 0 Then
            FTPLogString = FTPLogString.Substring(0, CRLFposition)
        End If

        myListViewItem = lvwFTPServerMessages.Items.Add(FTPLogString)
        myListViewItem.EnsureVisible()

        If IsNumeric(FTPLogString.Substring(0, 3)) Then
            If FTPLogString.Substring(0, 1) = "5" Then
                myListViewItem.ForeColor = Color.Red
            Else
                myListViewItem.ForeColor = Color.Green
            End If
        Else
            myListViewItem.ForeColor = Color.Blue
        End If

    End Sub


    Private Sub Ftp2_ConnectedChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles Ftp2.ConnectedChanged
        'sbFTP.Text = e.ToString()
    End Sub


    Private Sub Ftp2Close()

        If Ftp2.Connected Then

            outputMessage = "Disconnecting from FTP: " + Ftp2.Server.ToString
            myListViewItem = lvwFTPServerMessages.Items.Add(outputMessage)
            myListViewItem.EnsureVisible()
            myListViewItem.ForeColor = Color.Blue

            Dim FTPSecureinvoke As Dart.PowerTCP.SecureFtp.Invoke

            Try
                FTPSecureinvoke = Ftp2.Close()
            Catch ex As Exception
                outputMessage = "Error on ftp close. Error: " + ex.Message.ToString
                myListViewItem = lvwFTPServerMessages.Items.Add(outputMessage)
                myListViewItem.EnsureVisible()
                myListViewItem.ForeColor = Color.Red

            End Try

            If Ftp2.Connected Then
                Ftp2.Dispose()
                outputMessage = "Unable to QUIT, connection aborted."
                myListViewItem = lvwFTPServerMessages.Items.Add(outputMessage)
                myListViewItem.EnsureVisible()
                myListViewItem.ForeColor = Color.Red

            Else
                outputMessage = "Disconnected from FTP: " + Ftp2.Server.ToString
                myListViewItem = lvwFTPServerMessages.Items.Add(outputMessage)
                myListViewItem.EnsureVisible()
                myListViewItem.ForeColor = Color.Green

                outputMessage = "Close successful."
                myListViewItem = lvwFTPServerMessages.Items.Add(outputMessage)
                myListViewItem.EnsureVisible()
                myListViewItem.ForeColor = Color.Green

            End If

        Else
            outputMessage = "Not connected to FTP"
            myListViewItem = lvwFTPServerMessages.Items.Add(outputMessage)
            myListViewItem.EnsureVisible()

        End If

    End Sub


    Public Sub PrepareLogin()

        startFolder = ""
        sbFTP.Text = ""

        Ftp2.Server = FTPServer
        Ftp2.Username = FTPUsername
        Ftp2.Password = FTPPassword
        Ftp2.Passive = FTPPassive
        Ftp2.ServerPort = FTPServerPort
        'Keeps GUI responsive
        Ftp2.DoEvents = True

        If useSSL Then
            'Here are the 2 commands needed to run the client in SSL mode
            ' "Disable" security checks
            Ftp2.UseAuthentication = False
            ' Set the desired security/authentication to explicit. 
            Ftp2.Security = Dart.PowerTCP.SecureFtp.Security.Explicit
        End If

        outputMessage = "Connecting to " + Ftp2.Server.ToString + _
            " on port " + Ftp2.ServerPort.ToString
        myListViewItem = lvwFTPServerMessages.Items.Add(outputMessage)
        myListViewItem.EnsureVisible()
        myListViewItem.ForeColor = Color.Blue

        sbFTP.Text = "Connecting to FTP"

        If Ftp2.Passive Then
            outputMessage = "Passive connection requested"
        Else
            outputMessage = "Active connection requested"
        End If
        myListViewItem = lvwFTPServerMessages.Items.Add(outputMessage)
        myListViewItem.EnsureVisible()
        myListViewItem.ForeColor = Color.Blue
        outputMessage = "Username : " + Ftp2.Username
        myListViewItem = lvwFTPServerMessages.Items.Add(outputMessage)
        myListViewItem.EnsureVisible()
        myListViewItem.ForeColor = Color.Blue
        outputMessage = "Password : " + Ftp2.Password
        myListViewItem = lvwFTPServerMessages.Items.Add(outputMessage)
        myListViewItem.EnsureVisible()
        myListViewItem.ForeColor = Color.Blue

    End Sub


    Private Sub btnFTPCommandExecute_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnFTPCommandExecute.Click

        If tbxFTPCommandInput.Text = "" Then
            sbFTP.Text = "Enter a command to FTP server"
            Exit Sub
        End If

        FTPCommandString = tbxFTPCommandInput.Text
        ExecuteFTPCommand()

    End Sub


    Public Sub ExecuteFTPCommand()

        Try
            Ftp2.Invoke(Dart.PowerTCP.SecureFtp.FtpCommand.Null, FTPCommandString)
        Catch ex As System.Net.ProtocolViolationException
            exceptionType = "System.Net.ProtocolViolationException"
            FTPException(exceptionType, ex)
        Catch ex As Exception
            exceptionType = "Exception"
            FTPException(exceptionType, ex)
        End Try

    End Sub


    Public Sub FTPException(ByVal exceptionType As String, ByVal ex As Exception)

        Select Case exceptionType
            Case "System.Net.ProtocolViolationException"
            Case "System.Net.Sockets.SocketException"
            Case Else   'Exception'
        End Select

        exArray = ex.ToString.Split(LineFeed)
        excounter = 0
        While excounter < exArray.Length
            exString = exArray(excounter)
            exString = exString.Replace(CarriageReturn, " ")
            exString = exString.Replace(LineFeed, " ")
            If exString.Length < 2 Then
                Exit While
            End If

            myListViewItem = lvwFTPServerMessages.Items.Add(exString)
            myListViewItem.EnsureVisible()
            myListViewItem.ForeColor = Color.Red

            excounter += 1
        End While

    End Sub


    Private Sub SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles TabControl1.SelectedIndexChanged

        'Only show this menuitem when we are on the tab Log in Tabcontrol1
        If TabControl1.SelectedTab.Text = "Log" Then
            miCopy.Visible = True
            miClearlog.Visible = True
        Else
            miCopy.Visible = False
            miClearlog.Visible = False
        End If
    End Sub

    Private Sub miCopy_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles miCopy.Click

        Dim indexes As ListView.SelectedIndexCollection = lvwFTPServerMessages.SelectedIndices
        Dim indexToSelectedLine As Integer
        Dim selectedString As String = ""
        Dim selectCounter As Integer = 0

        For Each indexToSelectedLine In indexes
            selectedString = selectedString + _
            lvwFTPServerMessages.Items(indexToSelectedLine).SubItems(0).Text + _
            CarriageReturn + LineFeed
            selectCounter += 1
        Next
        If selectCounter > 0 Then
            Clipboard.SetDataObject(selectedString)
        Else
            sbFTP.Text = "Select at least one line to copy to clipboard"
        End If

    End Sub


    Private Sub miClearlog_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles miClearlog.Click

        If TabControl1.SelectedTab.Text = "Log" Then
            lvwFTPServerMessages.Items.Clear()
        End If
    End Sub


End Class

