Imports System
Imports System.IO
Imports System.Security.Cryptography
Imports System.Threading
Imports MySql.Data.MySqlClient



Public Class frmNewList
    Inherits System.Windows.Forms.Form


#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call

        'CODE THAT IS NOT GENERATED AUTOMATICALLY - START
        InitializeExtendedStatusBar()
        'CODE THAT IS NOT GENERATED AUTOMATICALLY - END

        Dim myToolTip As New ToolTip
        myToolTip.InitialDelay = 500
        myToolTip.AutoPopDelay = 5000
        myToolTip.ReshowDelay = 500
        ' ToolTip text to be displayed whether form is active or not.
        myToolTip.ShowAlways = True
        myToolTip.SetToolTip(Me.btnSelectOne, "Select directory")
        myToolTip.SetToolTip(Me.btnSelectRecursive, "Select directory and all below")
        myToolTip.SetToolTip(Me.btnRemoveOne, "Remove selected directory")
        myToolTip.SetToolTip(Me.btnRemoveAll, "Remove all directories")
        myToolTip.SetToolTip(Me.btnCreateList, "Update database")

        'Default starting values
        cbxScrollog.Checked = True
        ScrollList = True

    End Sub

    'Form overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If

        MyBase.Dispose(disposing)
    End Sub

    'Required by the Windows Form Designer
    Private components As System.ComponentModel.IContainer

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    Friend WithEvents btnCancel As System.Windows.Forms.Button
    Friend WithEvents ImageList1 As System.Windows.Forms.ImageList
    Friend WithEvents trvDirectory As System.Windows.Forms.TreeView
    Friend WithEvents lvwDirectories As System.Windows.Forms.ListView
    Friend WithEvents ImageList2 As System.Windows.Forms.ImageList
    Friend WithEvents btnSelectOne As System.Windows.Forms.Button
    Friend WithEvents btnSelectRecursive As System.Windows.Forms.Button
    Friend WithEvents btnRemoveOne As System.Windows.Forms.Button
    Friend WithEvents btnRemoveAll As System.Windows.Forms.Button
    Friend WithEvents btnCreateList As System.Windows.Forms.Button
    Friend WithEvents Panel2 As System.Windows.Forms.Panel
    Friend WithEvents tabControl1 As System.Windows.Forms.TabControl
    Friend WithEvents TabPage1 As System.Windows.Forms.TabPage
    Friend WithEvents TabPage2 As System.Windows.Forms.TabPage
    Friend WithEvents lvwUpdateLog As System.Windows.Forms.ListView
    Friend WithEvents cbxScrollList As System.Windows.Forms.CheckBox
    Friend WithEvents Panel1 As System.Windows.Forms.Panel
    Friend WithEvents cbxScrollog As System.Windows.Forms.CheckBox
    Friend WithEvents ColumnHeader1 As System.Windows.Forms.ColumnHeader
    Friend WithEvents btnExit As System.Windows.Forms.Button


    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.components = New System.ComponentModel.Container
        Dim resources As System.ComponentModel.ComponentResourceManager = New System.ComponentModel.ComponentResourceManager(GetType(frmNewList))
        Me.trvDirectory = New System.Windows.Forms.TreeView
        Me.ImageList1 = New System.Windows.Forms.ImageList(Me.components)
        Me.btnCancel = New System.Windows.Forms.Button
        Me.lvwDirectories = New System.Windows.Forms.ListView
        Me.ImageList2 = New System.Windows.Forms.ImageList(Me.components)
        Me.btnSelectOne = New System.Windows.Forms.Button
        Me.btnSelectRecursive = New System.Windows.Forms.Button
        Me.btnRemoveOne = New System.Windows.Forms.Button
        Me.btnRemoveAll = New System.Windows.Forms.Button
        Me.btnCreateList = New System.Windows.Forms.Button
        Me.Panel2 = New System.Windows.Forms.Panel
        Me.btnExit = New System.Windows.Forms.Button
        Me.tabControl1 = New System.Windows.Forms.TabControl
        Me.TabPage1 = New System.Windows.Forms.TabPage
        Me.TabPage2 = New System.Windows.Forms.TabPage
        Me.lvwUpdateLog = New System.Windows.Forms.ListView
        Me.ColumnHeader1 = New System.Windows.Forms.ColumnHeader
        Me.cbxScrollList = New System.Windows.Forms.CheckBox
        Me.Panel1 = New System.Windows.Forms.Panel
        Me.cbxScrollog = New System.Windows.Forms.CheckBox
        Me.Panel2.SuspendLayout()
        Me.tabControl1.SuspendLayout()
        Me.TabPage1.SuspendLayout()
        Me.TabPage2.SuspendLayout()
        Me.Panel1.SuspendLayout()
        Me.SuspendLayout()
        '
        'trvDirectory
        '
        Me.trvDirectory.Anchor = CType((((System.Windows.Forms.AnchorStyles.Top Or System.Windows.Forms.AnchorStyles.Bottom) _
                    Or System.Windows.Forms.AnchorStyles.Left) _
                    Or System.Windows.Forms.AnchorStyles.Right), System.Windows.Forms.AnchorStyles)
        Me.trvDirectory.HotTracking = True
        Me.trvDirectory.ImageIndex = 0
        Me.trvDirectory.ImageList = Me.ImageList1
        Me.trvDirectory.Location = New System.Drawing.Point(3, 0)
        Me.trvDirectory.Name = "trvDirectory"
        Me.trvDirectory.SelectedImageIndex = 0
        Me.trvDirectory.ShowRootLines = False
        Me.trvDirectory.Size = New System.Drawing.Size(277, 421)
        Me.trvDirectory.TabIndex = 0
        '
        'ImageList1
        '
        Me.ImageList1.ImageStream = CType(resources.GetObject("ImageList1.ImageStream"), System.Windows.Forms.ImageListStreamer)
        Me.ImageList1.TransparentColor = System.Drawing.Color.Transparent
        Me.ImageList1.Images.SetKeyName(0, "")
        Me.ImageList1.Images.SetKeyName(1, "")
        Me.ImageList1.Images.SetKeyName(2, "")
        Me.ImageList1.Images.SetKeyName(3, "")
        Me.ImageList1.Images.SetKeyName(4, "")
        Me.ImageList1.Images.SetKeyName(5, "")
        Me.ImageList1.Images.SetKeyName(6, "")
        Me.ImageList1.Images.SetKeyName(7, "")
        '
        'btnCancel
        '
        Me.btnCancel.Anchor = CType((System.Windows.Forms.AnchorStyles.Bottom Or System.Windows.Forms.AnchorStyles.Right), System.Windows.Forms.AnchorStyles)
        Me.btnCancel.Location = New System.Drawing.Point(459, 459)
        Me.btnCancel.Name = "btnCancel"
        Me.btnCancel.Size = New System.Drawing.Size(88, 32)
        Me.btnCancel.TabIndex = 7
        Me.btnCancel.Text = "Cancel"
        '
        'lvwDirectories
        '
        Me.lvwDirectories.Anchor = CType(((System.Windows.Forms.AnchorStyles.Top Or System.Windows.Forms.AnchorStyles.Bottom) _
                    Or System.Windows.Forms.AnchorStyles.Right), System.Windows.Forms.AnchorStyles)
        Me.lvwDirectories.Location = New System.Drawing.Point(395, 0)
        Me.lvwDirectories.MultiSelect = False
        Me.lvwDirectories.Name = "lvwDirectories"
        Me.lvwDirectories.Size = New System.Drawing.Size(264, 425)
        Me.lvwDirectories.SmallImageList = Me.ImageList2
        Me.lvwDirectories.TabIndex = 8
        Me.lvwDirectories.UseCompatibleStateImageBehavior = False
        Me.lvwDirectories.View = System.Windows.Forms.View.SmallIcon
        '
        'ImageList2
        '
        Me.ImageList2.ImageStream = CType(resources.GetObject("ImageList2.ImageStream"), System.Windows.Forms.ImageListStreamer)
        Me.ImageList2.TransparentColor = System.Drawing.Color.Transparent
        Me.ImageList2.Images.SetKeyName(0, "")
        Me.ImageList2.Images.SetKeyName(1, "")
        '
        'btnSelectOne
        '
        Me.btnSelectOne.Anchor = CType(((System.Windows.Forms.AnchorStyles.Top Or System.Windows.Forms.AnchorStyles.Left) _
                    Or System.Windows.Forms.AnchorStyles.Right), System.Windows.Forms.AnchorStyles)
        Me.btnSelectOne.Image = CType(resources.GetObject("btnSelectOne.Image"), System.Drawing.Image)
        Me.btnSelectOne.Location = New System.Drawing.Point(8, 16)
        Me.btnSelectOne.Name = "btnSelectOne"
        Me.btnSelectOne.Size = New System.Drawing.Size(95, 48)
        Me.btnSelectOne.TabIndex = 2
        '
        'btnSelectRecursive
        '
        Me.btnSelectRecursive.Anchor = CType(((System.Windows.Forms.AnchorStyles.Top Or System.Windows.Forms.AnchorStyles.Left) _
                    Or System.Windows.Forms.AnchorStyles.Right), System.Windows.Forms.AnchorStyles)
        Me.btnSelectRecursive.Image = CType(resources.GetObject("btnSelectRecursive.Image"), System.Drawing.Image)
        Me.btnSelectRecursive.Location = New System.Drawing.Point(8, 80)
        Me.btnSelectRecursive.Name = "btnSelectRecursive"
        Me.btnSelectRecursive.Size = New System.Drawing.Size(95, 48)
        Me.btnSelectRecursive.TabIndex = 3
        '
        'btnRemoveOne
        '
        Me.btnRemoveOne.Anchor = CType(((System.Windows.Forms.AnchorStyles.Top Or System.Windows.Forms.AnchorStyles.Left) _
                    Or System.Windows.Forms.AnchorStyles.Right), System.Windows.Forms.AnchorStyles)
        Me.btnRemoveOne.Image = CType(resources.GetObject("btnRemoveOne.Image"), System.Drawing.Image)
        Me.btnRemoveOne.Location = New System.Drawing.Point(8, 144)
        Me.btnRemoveOne.Name = "btnRemoveOne"
        Me.btnRemoveOne.Size = New System.Drawing.Size(95, 48)
        Me.btnRemoveOne.TabIndex = 4
        '
        'btnRemoveAll
        '
        Me.btnRemoveAll.Anchor = CType(((System.Windows.Forms.AnchorStyles.Top Or System.Windows.Forms.AnchorStyles.Left) _
                    Or System.Windows.Forms.AnchorStyles.Right), System.Windows.Forms.AnchorStyles)
        Me.btnRemoveAll.Image = CType(resources.GetObject("btnRemoveAll.Image"), System.Drawing.Image)
        Me.btnRemoveAll.Location = New System.Drawing.Point(8, 208)
        Me.btnRemoveAll.Name = "btnRemoveAll"
        Me.btnRemoveAll.Size = New System.Drawing.Size(95, 48)
        Me.btnRemoveAll.TabIndex = 5
        '
        'btnCreateList
        '
        Me.btnCreateList.Anchor = CType(((System.Windows.Forms.AnchorStyles.Top Or System.Windows.Forms.AnchorStyles.Left) _
                    Or System.Windows.Forms.AnchorStyles.Right), System.Windows.Forms.AnchorStyles)
        Me.btnCreateList.Image = CType(resources.GetObject("btnCreateList.Image"), System.Drawing.Image)
        Me.btnCreateList.Location = New System.Drawing.Point(8, 354)
        Me.btnCreateList.Name = "btnCreateList"
        Me.btnCreateList.Size = New System.Drawing.Size(95, 48)
        Me.btnCreateList.TabIndex = 6
        '
        'Panel2
        '
        Me.Panel2.Anchor = CType(((System.Windows.Forms.AnchorStyles.Top Or System.Windows.Forms.AnchorStyles.Bottom) _
                    Or System.Windows.Forms.AnchorStyles.Right), System.Windows.Forms.AnchorStyles)
        Me.Panel2.BackColor = System.Drawing.SystemColors.Control
        Me.Panel2.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D
        Me.Panel2.Controls.Add(Me.btnSelectOne)
        Me.Panel2.Controls.Add(Me.btnSelectRecursive)
        Me.Panel2.Controls.Add(Me.btnRemoveOne)
        Me.Panel2.Controls.Add(Me.btnRemoveAll)
        Me.Panel2.Controls.Add(Me.btnCreateList)
        Me.Panel2.Location = New System.Drawing.Point(281, 0)
        Me.Panel2.Name = "Panel2"
        Me.Panel2.Size = New System.Drawing.Size(115, 421)
        Me.Panel2.TabIndex = 14
        '
        'btnExit
        '
        Me.btnExit.Anchor = CType((System.Windows.Forms.AnchorStyles.Bottom Or System.Windows.Forms.AnchorStyles.Right), System.Windows.Forms.AnchorStyles)
        Me.btnExit.Location = New System.Drawing.Point(562, 459)
        Me.btnExit.Name = "btnExit"
        Me.btnExit.Size = New System.Drawing.Size(88, 32)
        Me.btnExit.TabIndex = 15
        Me.btnExit.Text = "Exit"
        '
        'tabControl1
        '
        Me.tabControl1.Anchor = CType((((System.Windows.Forms.AnchorStyles.Top Or System.Windows.Forms.AnchorStyles.Bottom) _
                    Or System.Windows.Forms.AnchorStyles.Left) _
                    Or System.Windows.Forms.AnchorStyles.Right), System.Windows.Forms.AnchorStyles)
        Me.tabControl1.Controls.Add(Me.TabPage1)
        Me.tabControl1.Controls.Add(Me.TabPage2)
        Me.tabControl1.Location = New System.Drawing.Point(-3, 1)
        Me.tabControl1.Name = "tabControl1"
        Me.tabControl1.SelectedIndex = 0
        Me.tabControl1.Size = New System.Drawing.Size(667, 447)
        Me.tabControl1.TabIndex = 16
        '
        'TabPage1
        '
        Me.TabPage1.BackColor = System.Drawing.Color.Transparent
        Me.TabPage1.Controls.Add(Me.lvwDirectories)
        Me.TabPage1.Controls.Add(Me.trvDirectory)
        Me.TabPage1.Controls.Add(Me.Panel2)
        Me.TabPage1.Location = New System.Drawing.Point(4, 22)
        Me.TabPage1.Name = "TabPage1"
        Me.TabPage1.Padding = New System.Windows.Forms.Padding(3)
        Me.TabPage1.Size = New System.Drawing.Size(659, 421)
        Me.TabPage1.TabIndex = 0
        Me.TabPage1.Text = "Select folders"
        Me.TabPage1.UseVisualStyleBackColor = True
        '
        'TabPage2
        '
        Me.TabPage2.BackColor = System.Drawing.Color.Transparent
        Me.TabPage2.Controls.Add(Me.lvwUpdateLog)
        Me.TabPage2.Location = New System.Drawing.Point(4, 22)
        Me.TabPage2.Name = "TabPage2"
        Me.TabPage2.Padding = New System.Windows.Forms.Padding(3)
        Me.TabPage2.Size = New System.Drawing.Size(659, 421)
        Me.TabPage2.TabIndex = 1
        Me.TabPage2.Text = "Update log"
        Me.TabPage2.UseVisualStyleBackColor = True
        '
        'lvwUpdateLog
        '
        Me.lvwUpdateLog.Anchor = CType((((System.Windows.Forms.AnchorStyles.Top Or System.Windows.Forms.AnchorStyles.Bottom) _
                    Or System.Windows.Forms.AnchorStyles.Left) _
                    Or System.Windows.Forms.AnchorStyles.Right), System.Windows.Forms.AnchorStyles)
        Me.lvwUpdateLog.Columns.AddRange(New System.Windows.Forms.ColumnHeader() {Me.ColumnHeader1})
        Me.lvwUpdateLog.HeaderStyle = System.Windows.Forms.ColumnHeaderStyle.None
        Me.lvwUpdateLog.Location = New System.Drawing.Point(-4, 0)
        Me.lvwUpdateLog.Name = "lvwUpdateLog"
        Me.lvwUpdateLog.Size = New System.Drawing.Size(667, 418)
        Me.lvwUpdateLog.TabIndex = 0
        Me.lvwUpdateLog.UseCompatibleStateImageBehavior = False
        Me.lvwUpdateLog.View = System.Windows.Forms.View.Details
        '
        'ColumnHeader1
        '
        Me.ColumnHeader1.Width = 650
        '
        'cbxScrollList
        '
        Me.cbxScrollList.Anchor = CType((System.Windows.Forms.AnchorStyles.Bottom Or System.Windows.Forms.AnchorStyles.Left), System.Windows.Forms.AnchorStyles)
        Me.cbxScrollList.FlatStyle = System.Windows.Forms.FlatStyle.System
        Me.cbxScrollList.Location = New System.Drawing.Point(8, 8)
        Me.cbxScrollList.Name = "cbxScrollList"
        Me.cbxScrollList.Size = New System.Drawing.Size(88, 24)
        Me.cbxScrollList.TabIndex = 42
        Me.cbxScrollList.Text = "Scroll list"
        '
        'Panel1
        '
        Me.Panel1.Anchor = CType((System.Windows.Forms.AnchorStyles.Bottom Or System.Windows.Forms.AnchorStyles.Left), System.Windows.Forms.AnchorStyles)
        Me.Panel1.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D
        Me.Panel1.Controls.Add(Me.cbxScrollog)
        Me.Panel1.Location = New System.Drawing.Point(4, 454)
        Me.Panel1.Name = "Panel1"
        Me.Panel1.Size = New System.Drawing.Size(95, 40)
        Me.Panel1.TabIndex = 45
        '
        'cbxScrollog
        '
        Me.cbxScrollog.Anchor = CType((System.Windows.Forms.AnchorStyles.Bottom Or System.Windows.Forms.AnchorStyles.Left), System.Windows.Forms.AnchorStyles)
        Me.cbxScrollog.FlatStyle = System.Windows.Forms.FlatStyle.System
        Me.cbxScrollog.Location = New System.Drawing.Point(8, 8)
        Me.cbxScrollog.Name = "cbxScrollog"
        Me.cbxScrollog.Size = New System.Drawing.Size(80, 24)
        Me.cbxScrollog.TabIndex = 42
        Me.cbxScrollog.Text = "Scroll log"
        '
        'frmNewList
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.ClientSize = New System.Drawing.Size(662, 523)
        Me.Controls.Add(Me.Panel1)
        Me.Controls.Add(Me.tabControl1)
        Me.Controls.Add(Me.btnExit)
        Me.Controls.Add(Me.btnCancel)
        Me.Icon = CType(resources.GetObject("$this.Icon"), System.Drawing.Icon)
        Me.Name = "frmNewList"
        Me.Panel2.ResumeLayout(False)
        Me.tabControl1.ResumeLayout(False)
        Me.TabPage1.ResumeLayout(False)
        Me.TabPage2.ResumeLayout(False)
        Me.Panel1.ResumeLayout(False)
        Me.ResumeLayout(False)

    End Sub

#End Region

    'SPECIAL PARAMETERS - START
    'MD5 hash calculated on this length, might be necessary to change later

    'Size below which we don't look for duplicates of different length
    'Size of the MD5 hash to disk
    'Files smaller than this parameter will use the total of their size as input
    'for making the MD5 hash.
    'Determine this parameter and never change it in future releases of program
    Dim lengthToCheck As Long = 250000

    'TODO - Put this parameter in Options dialog!!!!!!!!!!!!!!!!!!!!!!!!!!
    'If files with different lengths have same MD5 hash, we will make a second
    'hash with this size. We still don't want to use the whole file for making
    'the MD5 hash as this takes too long.
    'If files are the same up until this length, but then differ, we will not
    'be able to detect that they are different.
    'This parameter could be changed in future releases of the program without
    'any damage.

    Dim secondLengthToCheck As Long = 20000000
    'SPECIAL PARAMETERS - END


    Public nameOfOpenedFile As String

    Public totalNumberOfFiles As Integer
    Public totalNumberOfDirectories As Integer

    Public arrMD5() As String

    Public arrFile() As String

    Public ChecksumsRequested As Boolean
    Public DuplicateCheckRequested As Boolean

    Public arrTrueDuplicatesTotal() As String

    Public totalSizeOfFiles As Long
    Public totalNumberOfTrueDuplicates As Integer
    Public totalNumberOfDuplicatesWithDifferentLength As Integer

    Public ContinueProcessing As Boolean

    Public fileType As String
    Public fileTypeCounter As Integer

    Dim fullPathName As String
    Dim directoryName As String

    Public sbNewList As New ExtendedStatusBar

    Dim fileSW As StreamWriter
    Dim directorySW As StreamWriter
    Dim myFileListStreamR As StreamReader
    Dim myDirListStreamR As StreamReader
    Dim mySLXListStream As StreamWriter

    Dim totalNumberOfFilesMD5 As Integer
    Dim totalSizeOfFilesInThatDir As Long
    Dim totalNumberOfFilesInThatDir As Integer

    Dim MD5hash As Byte()
    Dim MD5hashString As String
    Dim md5 As New MD5CryptoServiceProvider
    Dim currentFileInfo As FileInfo
    Dim bytearrayinput() As Byte
    Dim cString As String
    Dim changedString As String
    Dim directoryArray() As DirectoryInfo
    Dim currentDirectoryInfo As DirectoryInfo

    Dim lvwFileItem As ListViewItem
    Dim lvwDirItem As ListViewItem
    Dim lvwDuplicateItem As ListViewItem

    Dim lsvItem As ListViewItem

    Dim fldDelim As String = "|"

    Dim NotFirstTime As Boolean
    'Dim FirstTime As Boolean

    '2003 framework does not have native support for getting the drive
    'types until the upcoming 2005 framework. So we will have to use the 
    'api call below to do it for us.
    Private Declare Function GetDriveType Lib "kernel32" Alias "GetDriveTypeA" (ByVal nDrive As String) As Integer

    'will get the integer return value of the GetDriveType function. 
    Dim dType As Integer = Nothing

    'will contain the drive type in string format
    Dim tDrive As String = Nothing

    Dim intervalCount As Integer = 0
    'We will change value in statusbar every 100 files
    Dim intervalSize As Integer = 100

    Dim lastNode As New System.Windows.Forms.TreeNode

    Dim DuplicatesFound As Boolean

    Dim strMD5hash As String
    Dim strFileSize As String
    Dim strDirPointer As String
    Dim strFileName As String
    Dim strUpdateDate As String
    Dim strRecNumber As String

    Dim strSaveMD5hash As String

    Dim arrTrueDuplicates() As String
    Dim nameSplit As String() = Nothing
    Dim inline As String
    Dim nameSplit2 As String()
    Dim inline2 As String
    Dim at As Integer
    Dim arrIndex As Integer
    Dim arrDirIndex As Integer
    Dim arrFileIndex As Integer
    Dim fieldDelimiterString As String = "|"
    Dim fieldDelimiter As Char() = fieldDelimiterString.ToCharArray()
    Dim ThisMoment As Date

    Dim debugTotalSizeOfAllMD5hashes As Long
    Dim debugTotalSizeOfAllSpecialMD5hashes As Long

    Dim arrTrueDuplicatesTotalIndex As Integer

    Dim groupCounter As Integer

    'NEW for this program version
    Public CorrectFileType As Boolean
    Public WantedFileType As String
    Public htOptions As New Hashtable
    Public GetFiles As String()
    Public SpecialFieldDelimiter As String = ":"
    Public counter As Integer
    Public filenameToTest As String
    Public getString As String
    Public myConnection As MySqlConnection
    Public myCommand As MySqlCommand
    Public mySQLCommandString As String
    Public myConnectionString As String
    Public collectionTablename As String
    Public DBresult As Integer

    Public filename As String
    Public fileSize As Long
    Public filePath As String
    Public fileTime As String
    Public fileMD5 As String

    Public outputMessage As String
    Public myListViewItem As ListViewItem
    Public exceptionType As String
    Public ScrollList As Boolean

    Public LineFeed = Chr(10)
    Public CarriageReturn = Chr(13)
    Public exArray As String()
    Public excounter As Integer
    Public exString As String
    Public OpenSuccessful As Boolean

    Public smallString As String
    Public startposition As Integer
    Public endposition As Integer
    Public stringLength As Integer

    Public insertCount As Integer
    Public failCount As Integer


    Private Sub btnCancel_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnCancel.Click
        ContinueProcessing = False
    End Sub


    Private Sub btnExit_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnExit.Click
        Me.Close()
    End Sub


    Private Sub SelectDirectory_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Try

            Dim logicalDrives() = System.Environment.GetLogicalDrives
            Dim I As Integer

            Dim startNode As New System.Windows.Forms.TreeNode
            startNode.Text = ""
            startNode.ImageIndex = 4
            startNode.SelectedImageIndex = 4
            'startNode.Text = "My computer"
            trvDirectory.Nodes.Add(startNode)

            For I = 0 To logicalDrives.Length - 1
                Dim oNode As New System.Windows.Forms.TreeNode

                oNode.ImageIndex = 3
                oNode.SelectedImageIndex = 3
                oNode.Text = System.Environment.GetLogicalDrives(I)
                oNode.Text = oNode.Text.TrimEnd("\"c)

                dType = GetDriveType(oNode.Text)

                If dType = 0 Then
                    'oNode.Text = "Unknown Drive"
                ElseIf dType = 1 Then
                    'oNode.Text = "Drive Absent"
                ElseIf dType = 2 Then
                    oNode.ImageIndex = 5
                    oNode.SelectedImageIndex = 5
                ElseIf dType = 3 Then
                    'oNode.Text = "Local Disk"
                ElseIf dType = 4 Then
                    oNode.ImageIndex = 7
                    oNode.SelectedImageIndex = 8
                ElseIf dType = 5 Then
                    oNode.ImageIndex = 6
                    oNode.SelectedImageIndex = 6
                ElseIf dType = 6 Then
                    oNode.Text = "Ramdisk Drive"
                End If

                oNode.Nodes.Add("")
                trvDirectory.Nodes(0).Nodes.Add(oNode)
            Next I

            startNode.Expand() 'Shows top level node + next level

        Catch ex As Exception
            MsgBox("Cannot create initial node:")
            End
        End Try

    End Sub


    Private Sub trvDirectory_BeforeExpand(ByVal sender As Object, ByVal e As System.Windows.Forms.TreeViewCancelEventArgs) Handles trvDirectory.BeforeExpand
        If e.Node.ImageIndex = 2 Then Exit Sub 'Document icon, so can not be expanded

        Try
            If e.Node.GetNodeCount(False) = 1 And e.Node.Nodes(0).Text = "" Then
                e.Node.Nodes(0).Remove()
                EnumerateChildren(e.Node)
            End If
        Catch ex As Exception
            Dim Message As String = "Can't open"
            Dim Caption As String = "Access problem"
            MessageBox.Show(Me, Message, Caption, _
                MessageBoxButtons.OK, MessageBoxIcon.Hand)
        End Try


    End Sub

    Private Sub EnumerateChildren(ByVal oParent As System.Windows.Forms.TreeNode)

        Dim directoryName As String = oParent.FullPath & "\"
        'A \ is automatically added between tree nodes and since
        'we are using a dummy node at the top for My computer we
        'have to remove the \
        directoryName = directoryName.TrimStart("\"c)

        'sorting the directories, any smarter way?
        Dim oFS As New DirectoryInfo(directoryName)
        Dim oDir As DirectoryInfo

        Dim collSize As Integer = 0
        Dim collIndex As Integer = 0
        For Each oDir In oFS.GetDirectories()
            collSize = collSize + 1
        Next
        Dim dirArray(collSize - 1) As String
        For Each oDir In oFS.GetDirectories()
            dirArray(collIndex) = oDir.Name
            collIndex = collIndex + 1
        Next
        Array.Sort(dirArray)
        Dim arrString As String

        Try
            'For Each oDir In oFS.GetDirectories()
            For Each arrString In dirArray
                Dim oNode As New System.Windows.Forms.TreeNode
                'oNode.Text = oDir.Name
                oNode.Text = arrString
                oNode.ImageIndex = 0
                oNode.SelectedImageIndex = 0
                oParent.Nodes.Add(oNode)
                oNode.Nodes.Add("")
            Next
        Catch ex As Exception

            Dim Message As String = "Can't open"
            Dim Caption As String = "Access problem"
            'Docs say you can put messagebox in front of any object but
            'it doesn't work for me
            'Dim Result As System.Windows.Forms.DialogResult
            'Result = MessageBox.Show(Me, Message, Caption, MessageBoxButtons.YesNo, MessageBoxIcon.Question)
            MessageBox.Show(Me, Message, Caption, _
                MessageBoxButtons.OK, MessageBoxIcon.Hand)
            'If Result = System.Windows.Forms.DialogResult.Yes do something

        End Try

    End Sub


    Private Sub trvDirectory_BeforeCollapse(ByVal sender As Object, ByVal e As System.Windows.Forms.TreeViewCancelEventArgs) Handles trvDirectory.BeforeCollapse
        'Not used
        'e.Node.ImageIndex = 0
        'e.Node.SelectedImageIndex = 0
    End Sub


    Public Sub trvDirectory_BeforeSelect(ByVal sender As Object, ByVal e As System.Windows.Forms.TreeViewCancelEventArgs) Handles trvDirectory.BeforeSelect
        'Not used
        'tbxSelDir.Text() = e.Node.FullPath.TrimStart("\"c)
    End Sub


    Public Sub trvDirectory_AfterSelect(ByVal sender As Object, ByVal e As System.Windows.Forms.TreeViewEventArgs) Handles trvDirectory.AfterSelect
        'This allows single click to open folders.
        trvDirectory.SelectedNode.Expand()
    End Sub


    Private Sub btnSelectOne_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnSelectOne.Click

        Dim dirName As String = trvDirectory.SelectedNode.FullPath

        If dirName.Length = 0 Then
            Dim Message As String = "No directory selected"
            Dim Caption As String = "User action"
            MessageBox.Show(Me, Message, Caption, _
                MessageBoxButtons.OK, MessageBoxIcon.Hand)
            Exit Sub
        End If

        dirName = dirName.TrimStart("\"c) 'Remove leading \ - backslash
        Dim oldDirName As String
        Dim lsvItem

        For Each lsvItem In lvwDirectories.Items 'Check that directory is new to list
            oldDirName = lsvItem.Text.trimend 'Have to remove the spaces at end of name
            If oldDirName = dirName Then
                Dim Message As String = "Directory already selected"
                Dim Caption As String = "User action"
                MessageBox.Show(Me, Message, Caption, _
                    MessageBoxButtons.OK, MessageBoxIcon.Hand)
                Exit Sub
            End If
        Next

        Dim delimStr As String = "/\"
        Dim delimiter As Char() = delimStr.ToCharArray()

        Dim overlappingDirectories As Boolean
        Dim nameSplit As String() = Nothing
        nameSplit = dirName.Split(delimiter) 'Split the selected directory 

        For Each lsvItem In lvwDirectories.Items
            Dim count As Integer
            Dim x As Integer
            Dim oldNameSplit As String()

            overlappingDirectories = True
            oldDirName = lsvItem.Text.trimend 'Have to remove the spaces at end of name
            oldNameSplit = oldDirName.Split(delimiter)


            'lsvItem.ImageIndex 0 = only this directory, 1 = recursive listing

            'If name of directory is longer than the one in listview, and the the
            'name in listview is a "only this directory" listing, then it can not 
            'conflict
            If nameSplit.Length > oldNameSplit.Length And _
                lsvItem.imageindex = 1 Then

                count = oldNameSplit.Length

                x = 0
                Do While x < count
                    If nameSplit(x) <> oldNameSplit(x) Then
                        overlappingDirectories = False
                        Exit Do
                    End If
                    x = x + 1
                Loop

                If overlappingDirectories = True Then
                    Dim Message As String = "Overlapping directories selected"
                    Dim Caption As String = "User action"
                    MessageBox.Show(Me, Message, Caption, _
                        MessageBoxButtons.OK, MessageBoxIcon.Hand)

                    Exit Sub

                End If

            End If

        Next

        If dirName.Length = 2 Then
            dirName = dirName + "\" 'Backslash missing on toplevel names
        End If

        'Wanting to avoid 2 names on the same line
        lvwDirectories.Items.Add(dirName + "                                         ", 0)

    End Sub


    Private Sub btnSelectRecursive_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnSelectRecursive.Click

        'listview contains a collection in .items filled with listviewitems which
        'in turn can be filled with sublistitems

        Dim delimStr As String = "/\"
        Dim delimiter As Char() = delimStr.ToCharArray()

        Dim dirName As String = trvDirectory.SelectedNode.FullPath

        If dirName.Length = 0 Then
            Dim Message As String = "No directory selected"
            Dim Caption As String = "User action"
            MessageBox.Show(Me, Message, Caption, _
                MessageBoxButtons.OK, MessageBoxIcon.Hand)
            Exit Sub
        End If

        dirName = dirName.TrimStart("\"c) 'Remove leading \ - backslash
        Dim oldDirName As String
        Dim lsvItem As ListViewItem

        For Each lsvItem In lvwDirectories.Items ' Check that directory is new to list
            oldDirName = lsvItem.Text.TrimEnd
            'lsvImageIndex = lsvItem.ImageIndex
            If oldDirName = dirName Then
                Dim Message As String = "Directory already selected"
                Dim Caption As String = "User action"
                MessageBox.Show(Me, Message, Caption, _
                    MessageBoxButtons.OK, MessageBoxIcon.Hand)
                Exit Sub
            End If
        Next

        Dim overlappingDirectories As Boolean
        Dim nameSplit As String() = Nothing
        nameSplit = dirName.Split(delimiter) 'Split the selected directory 

        For Each lsvItem In lvwDirectories.Items
            Dim count As Integer
            Dim x As Integer
            Dim oldNameSplit As String()

            overlappingDirectories = True
            oldDirName = lsvItem.Text.TrimEnd
            oldNameSplit = oldDirName.Split(delimiter)

            If nameSplit.Length < oldNameSplit.Length Then 'use shortest name
                count = nameSplit.Length
            Else
                count = oldNameSplit.Length
            End If

            x = 0
            Do While x < count
                If nameSplit(x) <> oldNameSplit(x) Then
                    overlappingDirectories = False
                    Exit Do
                End If
                x = x + 1
            Loop

            If overlappingDirectories = True Then
                Dim Message As String = "Overlapping directories selected"
                Dim Caption As String = "User action"
                MessageBox.Show(Me, Message, Caption, _
                    MessageBoxButtons.OK, MessageBoxIcon.Hand)
                Exit Sub
            End If


        Next

        If dirName.Length = 2 Then
            dirName = dirName + "\" 'Backslash missing on toplevel names
        End If

        'Wanting to avoid 2 names on the same line
        lvwDirectories.Items.Add(dirName + "                                         ", 1)


    End Sub


    Private Sub btnRemoveOne_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnRemoveOne.Click
        If lvwDirectories.Items.Count = 0 Then
            Dim Message As String = "No directory to remove"
            Dim Caption As String = "User action"
            MessageBox.Show(Me, Message, Caption, _
                MessageBoxButtons.OK, MessageBoxIcon.Hand)
        Else
            Try
                lvwDirectories.Items.RemoveAt(lvwDirectories.SelectedIndices(0)) 'Det finns bara ett index
            Catch ex As System.Exception
                Dim Message As String = "No directory selected"
                Dim Caption As String = "User action"
                MessageBox.Show(Me, Message, Caption, _
                    MessageBoxButtons.OK, MessageBoxIcon.Hand)

            End Try
        End If
    End Sub


    Private Sub btnRemoveAll_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnRemoveAll.Click
        If lvwDirectories.Items.Count = 0 Then
            Dim Message As String = "No directories to remove"
            Dim Caption As String = "User action"
            MessageBox.Show(Me, Message, Caption, _
                MessageBoxButtons.OK, MessageBoxIcon.Hand)
        Else
            'lvwDirectories.Items.Clear() doesn't work
            Dim lineItem
            For Each lineItem In lvwDirectories.Items
                lvwDirectories.Items.RemoveAt(0)
            Next
        End If

    End Sub


    Private Sub btnCreateList_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnCreateList.Click

        'Boolean used to stop creation of list by pressing cancel button
        ContinueProcessing = True

        Dim workerThread As New Thread(New ThreadStart(AddressOf createWCFMoviesList))
        workerThread.Start()

    End Sub


    Private Sub createWCFMoviesList()

        If lvwDirectories.Items.Count = 0 Then
            Dim Message As String = "Select some directory to list"
            Dim Caption As String = "User action"
            MessageBox.Show(Me, Message, Caption, _
                MessageBoxButtons.OK, MessageBoxIcon.Hand)
            Exit Sub
        End If

        'Just a check at the beginning to see that database is available
        myListViewItem = lvwUpdateLog.Items.Add("Making sure database is available")
        myListViewItem.EnsureVisible()
        myListViewItem.ForeColor = Color.Blue

        OpenConnectionToDatabase()
        If Not OpenSuccessful Then
            sbNewList.Panels(0).Text = "Cant open database"
            Exit Sub
        End If

        CountFiles()

        If ContinueProcessing = True Then
            CalculateChecksums()
        End If

        If ContinueProcessing = True Then
            UpdateDatabase()
        End If

    End Sub


    Private Sub CountFiles()

        sbNewList.ShowPanels = True

        totalNumberOfFiles = 0

        arrDirIndex = 0
        arrFileIndex = 0
        ReDim arrFile(-1)

        'Setting up an array with the wanted string types
        If WantedFileType = "PICTURE" Then
            If htOptions.ContainsKey("getpictures") Then
                GetFiles = htOptions.Item("getpictures").Split(SpecialFieldDelimiter)
            End If
        Else
            If htOptions.ContainsKey("getmovies") Then
                GetFiles = htOptions.Item("getmovies").Split(SpecialFieldDelimiter)
            End If
        End If

        For Each lsvItem In lvwDirectories.Items

            If ContinueProcessing = False Then
                Exit For
            End If

            Dim dirInfo As New DirectoryInfo(lsvItem.Text)
            Dim filesArray As FileInfo() = dirInfo.GetFiles()
            Dim currentFileInfo As FileInfo
            For Each currentFileInfo In filesArray

                If ContinueProcessing = False Then
                    Exit For
                End If

                If arrFile.Length < (arrFileIndex + 1) Then
                    'the increment after arrFileIndex can be set to anything
                    'that works well, this is done to speed up the loop.
                    'Redim after every insertion slows down processing much
                    ReDim Preserve arrFile(arrFileIndex + 1000)
                End If

                Dim FileIsFreeToRead As Boolean = True
                Try
                    Dim fsInput As New FileStream(currentFileInfo.FullName, _
                                FileMode.Open, FileAccess.Read)
                    fsInput.Close()
                Catch ex As Exception
                    FileIsFreeToRead = False
                End Try


                'Check if this is a PICTURE or a MOVIE
                filenameToTest = currentFileInfo.Name
                CheckFileType()


                If FileIsFreeToRead And CorrectFileType Then
                    totalNumberOfFiles = totalNumberOfFiles + 1

                    arrFile(arrFileIndex) = currentFileInfo.Name + fldDelim + _
                                              currentFileInfo.Length.ToString + fldDelim + _
                                              currentFileInfo.LastWriteTime.Ticks.ToString + fldDelim + _
                                              dirInfo.FullName

                    arrFileIndex = arrFileIndex + 1
                End If

            Next

            sbNewList.Panels(0).Text = "Counting files - " + _
                             totalNumberOfFiles.ToString

            If lsvItem.ImageIndex = 1 Then ' 0 = only this directory, 1 = recursive listing
                Dim directoryArray() As DirectoryInfo
                directoryArray = dirInfo.GetDirectories
                Dim currentDirectoryInfo As DirectoryInfo
                For Each currentDirectoryInfo In directoryArray
                    RecurseCountFiles(currentDirectoryInfo, 1)
                Next
            End If
        Next

        ReDim Preserve arrFile(totalNumberOfFiles - 1)

    End Sub


    Private Function RecurseCountFiles(ByVal dirInfo As System.IO.DirectoryInfo, ByVal dirLevel As Integer)

        Dim filesArray As FileInfo() = dirInfo.GetFiles()
        Dim currentFileInfo As FileInfo

        For Each currentFileInfo In filesArray

            If ContinueProcessing = False Then
                Exit For
            End If

            If arrFile.Length < (arrFileIndex + 1) Then
                ReDim Preserve arrFile(arrFileIndex + 1000)
            End If

            Dim FileIsFreeToRead As Boolean = True
            Try
                Dim fsInput As New FileStream(currentFileInfo.FullName, _
                            FileMode.Open, FileAccess.Read)
                fsInput.Close()
            Catch ex As Exception
                FileIsFreeToRead = False
            End Try


            'Check if this is a PICTURE or a MOVIE
            filenameToTest = currentFileInfo.Name
            CheckFileType()


            If FileIsFreeToRead And CorrectFileType Then
                totalNumberOfFiles = totalNumberOfFiles + 1

                arrFile(arrFileIndex) = currentFileInfo.Name + fldDelim + _
                                          currentFileInfo.Length.ToString + fldDelim + _
                                          currentFileInfo.LastWriteTime.Ticks.ToString + fldDelim + _
                                          dirInfo.FullName

                arrFileIndex = arrFileIndex + 1
            End If

        Next

        sbNewList.Panels(0).Text = "Counting files - " + _
                         totalNumberOfFiles.ToString


        Dim directoryArray() As DirectoryInfo
        directoryArray = dirInfo.GetDirectories
        Dim currentDirectoryInfo As DirectoryInfo
        For Each currentDirectoryInfo In directoryArray
            RecurseCountFiles(currentDirectoryInfo, dirLevel + 1)
        Next

    End Function


    Private Sub CheckFileType()

        'Checking if this is a movie or picture with correct name
        filenameToTest = filenameToTest.ToLower

        CorrectFileType = False
        counter = 0
        While counter < GetFiles.Length
            getString = GetFiles(counter).ToLower
            If getString.Length > 0 Then
                If (filenameToTest.IndexOf(getString) >= 0) Then
                    CorrectFileType = True
                    Exit While
                End If
            End If
            counter += 1
        End While

    End Sub


    Private Sub CalculateChecksums()

        arrFileIndex = 0

        sbNewList.progressBar.Value = 0
        sbNewList.progressBar.Minimum = 0
        sbNewList.progressBar.Maximum = totalNumberOfFiles
        sbNewList.progressBar.BarColor1 = Color.ForestGreen

        sbNewList.Panels(0).Text = totalNumberOfFiles.ToString + _
                         " files. Calculating checksums."

        Dim fullFileName As String

        While arrFileIndex < arrFile.Length

            If ContinueProcessing = False Then
                Exit While
            End If

            '.Update is needed for this custom control
            sbNewList.progressBar.PerformStep()
            sbNewList.progressBar.Update()

            nameSplit = arrFile(arrFileIndex).Split(fieldDelimiter)
            fullFileName = nameSplit(3) + "\" + nameSplit(0)

            Dim fsInput As New FileStream(fullFileName, FileMode.Open, FileAccess.Read)
            If fsInput.Length > lengthToCheck Then
                ReDim bytearrayinput(lengthToCheck)
                debugTotalSizeOfAllMD5hashes = debugTotalSizeOfAllMD5hashes + lengthToCheck
            Else
                ReDim bytearrayinput(fsInput.Length - 1)
                debugTotalSizeOfAllMD5hashes = debugTotalSizeOfAllMD5hashes + fsInput.Length - 1
            End If
            fsInput.Read(bytearrayinput, 0, bytearrayinput.Length)
            fsInput.Close()
            MD5hash = md5.ComputeHash(bytearrayinput)
            MD5hashString = Convert.ToBase64String(MD5hash)
            MD5hashString = MD5hashString.Replace("w"c, "V"c)
            MD5hashString = MD5hashString.Replace("W"c, "V"c)

            arrFile(arrFileIndex) = arrFile(arrFileIndex) + fldDelim + _
                                    MD5hashString

            arrFileIndex = arrFileIndex + 1
        End While

    End Sub


    Private Sub UpdateDatabase()

        insertCount = 0
        failCount = 0

        arrFileIndex = 0

        sbNewList.progressBar.Value = 0
        sbNewList.progressBar.Minimum = 0
        sbNewList.progressBar.Maximum = totalNumberOfFiles
        sbNewList.progressBar.BarColor1 = Color.Red

        sbNewList.Panels(0).Text = totalNumberOfFiles.ToString + _
                         " files. Updating database"

        'Since it might take hours between preliminary open,
        'lets reopen DB just to play it safe
        OpenConnectionToDatabase()
        If Not OpenSuccessful Then
            Exit Sub
        End If

        While arrFileIndex < arrFile.Length

            If ContinueProcessing = False Then
                Exit While
            End If

            sbNewList.progressBar.PerformStep()
            sbNewList.progressBar.Update()

            nameSplit = arrFile(arrFileIndex).Split(fieldDelimiter)

            filename = nameSplit(0)
            fileSize = CLng(nameSplit(1))
            fileTime = nameSplit(2)
            filePath = nameSplit(3)
            fileMD5 = nameSplit(4)

            filePath = filePath.Replace("\", "\\")
            filePath = filePath.Replace("'", "\'")
            filename = filename.Replace("'", "\'")

            'This could be speeded up by using values and several lines of
            'data but not worth the effort at this time
            mySQLCommandString = "INSERT INTO " + collectionTablename + _
            " SET filename='" + filename + "'," + _
            " filesize = '" + fileSize.ToString + "'," + _
            " filepath = '" + filePath + "'," + _
            " filetime = '" + fileTime + "'," + _
            " fileMD5 = '" + fileMD5 + "';"

            Try

                myCommand = New MySqlCommand(mySQLCommandString)
                myCommand.Connection = myConnection

                DBresult = myCommand.ExecuteNonQuery()

                If DBresult < 1 Then
                    outputMessage = "Insert into database of " + filename + _
                    " failed"
                    myListViewItem = lvwUpdateLog.Items.Add(outputMessage)
                    myListViewItem.ForeColor = Color.Red
                    failCount += 1
                    If ScrollList = True Then
                        myListViewItem.EnsureVisible()
                    End If
                Else
                    insertCount += 1
                End If

            Catch ex As MySqlException
                exceptionType = "MySqlException"
                ExceptionToListView(exceptionType, ex)
                outputMessage = "CommandString :" + mySQLCommandString
                myListViewItem = lvwUpdateLog.Items.Add(outputMessage)
                myListViewItem.ForeColor = Color.Red
                If ScrollList = True Then
                    myListViewItem.EnsureVisible()
                End If
            Catch ex As System.Net.Sockets.SocketException
                exceptionType = "System.Net.Sockets.SocketException"
                ExceptionToListView(exceptionType, ex)
                outputMessage = "CommandString :" + mySQLCommandString
                myListViewItem = lvwUpdateLog.Items.Add(outputMessage)
                myListViewItem.ForeColor = Color.Red
                If ScrollList = True Then
                    myListViewItem.EnsureVisible()
                End If
            Catch ex As Exception
                exceptionType = "Exception"
                ExceptionToListView(exceptionType, ex)
                outputMessage = "CommandString :" + mySQLCommandString
                myListViewItem = lvwUpdateLog.Items.Add(outputMessage)
                myListViewItem.ForeColor = Color.Red
                If ScrollList = True Then
                    myListViewItem.EnsureVisible()
                End If
            End Try

            arrFileIndex = arrFileIndex + 1
        End While

        CloseConnection()

        sbNewList.Panels(0).Text = "Database update done. See statistics in log"

        myListViewItem = lvwUpdateLog.Items.Add("Filenames inserted in database :" + _
            insertCount.ToString)
        myListViewItem.ForeColor = Color.Black
        If ScrollList = True Then
            myListViewItem.EnsureVisible()
        End If

        myListViewItem = lvwUpdateLog.Items.Add("Filenames failed to insert in database :" + _
            failCount.ToString)
        myListViewItem.ForeColor = Color.Black
        If ScrollList = True Then
            myListViewItem.EnsureVisible()
        End If




    End Sub


    Public Sub ExceptionToListView(ByVal exceptionType As String, ByVal ex As Exception)

        exArray = ex.ToString.Split(LineFeed)
        excounter = 0
        While excounter < exArray.Length
            exString = exArray(excounter)
            exString = exString.Replace(CarriageReturn, " ")
            exString = exString.Replace(LineFeed, " ")
            If exString.Length < 2 Then
                Exit While
            End If

            myListViewItem = lvwUpdateLog.Items.Add(exString)
            myListViewItem.ForeColor = Color.Red
            If ScrollList = True Then
                myListViewItem.EnsureVisible()
            End If

            excounter += 1
        End While

    End Sub


    Private Sub OpenConnectionToDatabase()

        OpenSuccessful = False

        'If we forgot to close any old connection, do it now, and open a fresh one
        If Not myConnection Is Nothing Then
            Try
                myConnection.Close()
                myConnection.Dispose()
            Catch ex As Exception
                exceptionType = "Exception"
                ExceptionToListView(exceptionType, ex)
                Exit Sub
            End Try
        End If

        myListViewItem = lvwUpdateLog.Items.Add(myConnectionString)
        myListViewItem.EnsureVisible()
        myListViewItem.ForeColor = Color.Blue

        Try
            myConnection = New MySqlConnection(myConnectionString)
            myConnection.Open()

            myListViewItem = lvwUpdateLog.Items.Add("Connection opened to database")
            myListViewItem.EnsureVisible()
            myListViewItem.ForeColor = Color.Green

        Catch ex As MySqlException
            exceptionType = "MySqlException"
            ExceptionToListView(exceptionType, ex)
        Catch ex As System.Net.Sockets.SocketException
            exceptionType = "System.Net.Sockets.SocketException"
            ExceptionToListView(exceptionType, ex)
        Catch ex As Exception
            exceptionType = "Exception"
            ExceptionToListView(exceptionType, ex)
        End Try

        If Not myConnection Is Nothing Then
            If myConnection.State = ConnectionState.Open Then
                OpenSuccessful = True
            End If
        End If

    End Sub


    Private Sub CloseConnection()

        Try
            If Not myConnection Is Nothing Then

                myListViewItem = lvwUpdateLog.Items.Add("Close connection")
                myListViewItem.ForeColor = Color.Blue
                If ScrollList = True Then
                    myListViewItem.EnsureVisible()
                End If

                myConnection.Close()
                myConnection.Dispose()
                myConnection = Nothing

                myListViewItem = lvwUpdateLog.Items.Add("Connection closed")
                myListViewItem.ForeColor = Color.Green
                If ScrollList = True Then
                    myListViewItem.EnsureVisible()
                End If
            End If

        Catch ex As MySqlException
            exceptionType = "MySqlException"
            ExceptionToListView(exceptionType, ex)
        Catch ex As System.Net.Sockets.SocketException
            'Port errors
            exceptionType = "System.Net.Sockets.SocketException"
            ExceptionToListView(exceptionType, ex)
        Catch ex As Exception
            'Syntax errors
            exceptionType = "Exception"
            ExceptionToListView(exceptionType, ex)
        End Try

    End Sub


    Private Sub InitializeExtendedStatusBar()

        'TODO Problems to insert and position extra panels, can it be fixed?

        Dim sbText = New System.Windows.Forms.StatusBarPanel
        Dim sbProgress = New System.Windows.Forms.StatusBarPanel

        'Progressbar gets width 200
        sbText.Width = 470

        sbProgress.AutoSize = _
           System.Windows.Forms.StatusBarPanelAutoSize.Spring

        With sbNewList
            .Panels.Add(sbText)
            .Panels.Add(sbProgress)

            .ShowPanels = True

            'Initial settings for custom progressbar
            .setProgressBar = 1
            .progressBar.Minimum = 0
            .progressBar.Value = 0

            'Give a stylish look to this control which we don't use
            '.progressBar.BackColorStyle = SPB.SmoothProgressBar.ColorStyle.Gradient
            '.progressBar.BackGradientMode = Drawing2D.LinearGradientMode.Vertical
            '.progressBar.BackSigmaMode = SPB.SmoothProgressBar.SigmaMode.SigmaBell
            '.progressBar.BarColorStyle = SPB.SmoothProgressBar.ColorStyle.Gradient
            '.progressBar.BarGradientMode = Drawing2D.LinearGradientMode.Vertical
            '.progressBar.BarSigmaMode = SPB.SmoothProgressBar.SigmaMode.SigmaBell

            .progressBar.TabStop = False
            .progressBar.BorderStyle = BorderStyle.None

        End With

        Me.Controls.Add(sbNewList)

    End Sub


    Private Sub cbxScrollog_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cbxScrollog.CheckedChanged
        'Control the automatic scrolling of the listview
        If cbxScrollList.Checked = True Then
            ScrollList = True
        Else
            ScrollList = False
        End If
    End Sub
End Class
