Imports System
Imports System.IO
Imports System.Drawing
Imports System.Drawing.Imaging
Imports System.Security.Cryptography
Imports System.Timers
Imports System.Net
Imports System.Threading
Imports DexterLib
Imports MySql.Data.MySqlClient


Public Class frmPictureStatus
    Inherits System.Windows.Forms.Form

#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()

        Control.CheckForIllegalCrossThreadCalls = False

        'Add any initialization after the InitializeComponent() call

        'CODE THAT IS NOT GENERATED AUTOMATICALLY - START
        InitializeExtendedStatusBar()
        ProgramDefaultDirectory = Environment.CurrentDirectory

        Dim myToolTip As New ToolTip
        myToolTip.InitialDelay = 500
        myToolTip.AutoPopDelay = 8000
        myToolTip.ReshowDelay = 500
        ' ToolTip text to be displayed whether form is active or not.
        myToolTip.ShowAlways = True

        ' ToolTip text to be displayed whether form is active or not.
        myToolTip.ShowAlways = True

        'myToolTip.SetToolTip(Me.btnLoginCheck, "Login to current FTP, set avoid directories and start directory " + _
        '            "if necessary")

        myToolTip.SetToolTip(Me.btnClearAllLists, "Clear all created lists for current FTP site")

        DownloadActive = False

        AddHandler Me.LoginEvent, AddressOf OnLoginEvent

        typeOfSpeed = 1

        'Only sort the list on initial download from ftp and when refreshing list
        'with new filelist from ftp
        FirstTimeSortOfList = False

        cbxScrollList.Checked = True
        ScrollList = True

        'CODE THAT IS NOT GENERATED AUTOMATICALLY - END

    End Sub

    'Form overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If

        MyBase.Dispose(disposing)

    End Sub

    'Required by the Windows Form Designer
    Private components As System.ComponentModel.IContainer

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    Friend WithEvents btnStatusExit As System.Windows.Forms.Button
    Friend WithEvents lvwStatus As System.Windows.Forms.ListView
    Friend WithEvents clhStatus As System.Windows.Forms.ColumnHeader
    Friend WithEvents btnClearAllLists As System.Windows.Forms.Button
    Friend WithEvents spbTotal As SPB.SmoothProgressBar
    Friend WithEvents clhFileName As System.Windows.Forms.ColumnHeader
    Friend WithEvents clhFilePath As System.Windows.Forms.ColumnHeader
    Friend WithEvents btnDownload As System.Windows.Forms.Button
    Friend WithEvents btnSearchFTPAgain As System.Windows.Forms.Button
    Friend WithEvents clhFileSize As System.Windows.Forms.ColumnHeader
    Friend WithEvents Viewer1 As FTPHoover.Viewer
    Friend WithEvents GroupBox1 As System.Windows.Forms.GroupBox
    Friend WithEvents tbxFoundDuplicates As System.Windows.Forms.TextBox
    Friend WithEvents gbxTotalProgress As System.Windows.Forms.GroupBox
    Friend WithEvents GroupBox2 As System.Windows.Forms.GroupBox
    Friend WithEvents tbxFTPListTotalCount As System.Windows.Forms.TextBox
    Friend WithEvents clhDuplicatePath As System.Windows.Forms.ColumnHeader
    Friend WithEvents cbxScrollList As System.Windows.Forms.CheckBox
    Friend WithEvents GroupBox3 As System.Windows.Forms.GroupBox
    Friend WithEvents tbxDownloading As System.Windows.Forms.TextBox
    Friend WithEvents Panel1 As System.Windows.Forms.Panel
    Friend WithEvents ctxMenu As System.Windows.Forms.ContextMenu
    Friend WithEvents TabControl1 As System.Windows.Forms.TabControl
    Friend WithEvents tabDownload As System.Windows.Forms.TabPage
    Friend WithEvents tabLog As System.Windows.Forms.TabPage
    Friend WithEvents lvwUpdateLog As System.Windows.Forms.ListView
    Friend WithEvents btnAnalyzeAgain As System.Windows.Forms.Button
    Friend WithEvents Ftp2 As Dart.PowerTCP.SecureFtp.Ftp
    Friend WithEvents ColumnHeader1 As System.Windows.Forms.ColumnHeader
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.components = New System.ComponentModel.Container
        Dim resources As System.ComponentModel.ComponentResourceManager = New System.ComponentModel.ComponentResourceManager(GetType(frmPictureStatus))
        Me.btnStatusExit = New System.Windows.Forms.Button
        Me.lvwStatus = New System.Windows.Forms.ListView
        Me.clhFileSize = New System.Windows.Forms.ColumnHeader
        Me.clhStatus = New System.Windows.Forms.ColumnHeader
        Me.clhFileName = New System.Windows.Forms.ColumnHeader
        Me.clhFilePath = New System.Windows.Forms.ColumnHeader
        Me.clhDuplicatePath = New System.Windows.Forms.ColumnHeader
        Me.ctxMenu = New System.Windows.Forms.ContextMenu
        Me.btnDownload = New System.Windows.Forms.Button
        Me.btnClearAllLists = New System.Windows.Forms.Button
        Me.spbTotal = New SPB.SmoothProgressBar
        Me.gbxTotalProgress = New System.Windows.Forms.GroupBox
        Me.btnSearchFTPAgain = New System.Windows.Forms.Button
        Me.GroupBox1 = New System.Windows.Forms.GroupBox
        Me.tbxFoundDuplicates = New System.Windows.Forms.TextBox
        Me.GroupBox2 = New System.Windows.Forms.GroupBox
        Me.tbxFTPListTotalCount = New System.Windows.Forms.TextBox
        Me.cbxScrollList = New System.Windows.Forms.CheckBox
        Me.GroupBox3 = New System.Windows.Forms.GroupBox
        Me.tbxDownloading = New System.Windows.Forms.TextBox
        Me.Panel1 = New System.Windows.Forms.Panel
        Me.TabControl1 = New System.Windows.Forms.TabControl
        Me.tabDownload = New System.Windows.Forms.TabPage
        Me.tabLog = New System.Windows.Forms.TabPage
        Me.lvwUpdateLog = New System.Windows.Forms.ListView
        Me.ColumnHeader1 = New System.Windows.Forms.ColumnHeader
        Me.btnAnalyzeAgain = New System.Windows.Forms.Button
        Me.Ftp2 = New Dart.PowerTCP.SecureFtp.Ftp(Me.components)
        Me.Viewer1 = New FTPHoover.Viewer
        Me.gbxTotalProgress.SuspendLayout()
        Me.GroupBox1.SuspendLayout()
        Me.GroupBox2.SuspendLayout()
        Me.GroupBox3.SuspendLayout()
        Me.Panel1.SuspendLayout()
        Me.TabControl1.SuspendLayout()
        Me.tabDownload.SuspendLayout()
        Me.tabLog.SuspendLayout()
        Me.SuspendLayout()
        '
        'btnStatusExit
        '
        Me.btnStatusExit.Anchor = CType((System.Windows.Forms.AnchorStyles.Bottom Or System.Windows.Forms.AnchorStyles.Right), System.Windows.Forms.AnchorStyles)
        Me.btnStatusExit.FlatStyle = System.Windows.Forms.FlatStyle.System
        Me.btnStatusExit.Location = New System.Drawing.Point(682, 512)
        Me.btnStatusExit.Name = "btnStatusExit"
        Me.btnStatusExit.Size = New System.Drawing.Size(88, 32)
        Me.btnStatusExit.TabIndex = 1
        Me.btnStatusExit.Text = "Exit"
        '
        'lvwStatus
        '
        Me.lvwStatus.Anchor = CType((((System.Windows.Forms.AnchorStyles.Top Or System.Windows.Forms.AnchorStyles.Bottom) _
                    Or System.Windows.Forms.AnchorStyles.Left) _
                    Or System.Windows.Forms.AnchorStyles.Right), System.Windows.Forms.AnchorStyles)
        Me.lvwStatus.Columns.AddRange(New System.Windows.Forms.ColumnHeader() {Me.clhFileSize, Me.clhStatus, Me.clhFileName, Me.clhFilePath, Me.clhDuplicatePath})
        Me.lvwStatus.ContextMenu = Me.ctxMenu
        Me.lvwStatus.FullRowSelect = True
        Me.lvwStatus.Location = New System.Drawing.Point(0, 0)
        Me.lvwStatus.Name = "lvwStatus"
        Me.lvwStatus.Size = New System.Drawing.Size(784, 304)
        Me.lvwStatus.TabIndex = 2
        Me.lvwStatus.UseCompatibleStateImageBehavior = False
        Me.lvwStatus.View = System.Windows.Forms.View.Details
        '
        'clhFileSize
        '
        Me.clhFileSize.Text = "File size"
        Me.clhFileSize.Width = 80
        '
        'clhStatus
        '
        Me.clhStatus.Text = "Status"
        Me.clhStatus.Width = 100
        '
        'clhFileName
        '
        Me.clhFileName.Text = "File name"
        Me.clhFileName.Width = 160
        '
        'clhFilePath
        '
        Me.clhFilePath.Text = "Path"
        Me.clhFilePath.Width = 210
        '
        'clhDuplicatePath
        '
        Me.clhDuplicatePath.Text = "Duplicate path"
        Me.clhDuplicatePath.Width = 210
        '
        'ctxMenu
        '
        '
        'btnDownload
        '
        Me.btnDownload.Anchor = CType((System.Windows.Forms.AnchorStyles.Bottom Or System.Windows.Forms.AnchorStyles.Left), System.Windows.Forms.AnchorStyles)
        Me.btnDownload.FlatStyle = System.Windows.Forms.FlatStyle.System
        Me.btnDownload.Location = New System.Drawing.Point(320, 512)
        Me.btnDownload.Name = "btnDownload"
        Me.btnDownload.Size = New System.Drawing.Size(88, 32)
        Me.btnDownload.TabIndex = 28
        '
        'btnClearAllLists
        '
        Me.btnClearAllLists.Anchor = CType((System.Windows.Forms.AnchorStyles.Bottom Or System.Windows.Forms.AnchorStyles.Left), System.Windows.Forms.AnchorStyles)
        Me.btnClearAllLists.FlatStyle = System.Windows.Forms.FlatStyle.System
        Me.btnClearAllLists.Location = New System.Drawing.Point(320, 440)
        Me.btnClearAllLists.Name = "btnClearAllLists"
        Me.btnClearAllLists.Size = New System.Drawing.Size(88, 32)
        Me.btnClearAllLists.TabIndex = 29
        Me.btnClearAllLists.Text = "Clear list"
        '
        'spbTotal
        '
        Me.spbTotal.Anchor = CType(((System.Windows.Forms.AnchorStyles.Bottom Or System.Windows.Forms.AnchorStyles.Left) _
                    Or System.Windows.Forms.AnchorStyles.Right), System.Windows.Forms.AnchorStyles)
        Me.spbTotal.Location = New System.Drawing.Point(8, 16)
        Me.spbTotal.Name = "spbTotal"
        Me.spbTotal.Size = New System.Drawing.Size(184, 20)
        Me.spbTotal.TabIndex = 32
        '
        'gbxTotalProgress
        '
        Me.gbxTotalProgress.Anchor = CType(((System.Windows.Forms.AnchorStyles.Bottom Or System.Windows.Forms.AnchorStyles.Left) _
                    Or System.Windows.Forms.AnchorStyles.Right), System.Windows.Forms.AnchorStyles)
        Me.gbxTotalProgress.Controls.Add(Me.spbTotal)
        Me.gbxTotalProgress.Location = New System.Drawing.Point(440, 496)
        Me.gbxTotalProgress.Name = "gbxTotalProgress"
        Me.gbxTotalProgress.Size = New System.Drawing.Size(200, 48)
        Me.gbxTotalProgress.TabIndex = 35
        Me.gbxTotalProgress.TabStop = False
        Me.gbxTotalProgress.Text = "Total progress"
        '
        'btnSearchFTPAgain
        '
        Me.btnSearchFTPAgain.Anchor = CType((System.Windows.Forms.AnchorStyles.Bottom Or System.Windows.Forms.AnchorStyles.Left), System.Windows.Forms.AnchorStyles)
        Me.btnSearchFTPAgain.FlatStyle = System.Windows.Forms.FlatStyle.System
        Me.btnSearchFTPAgain.Location = New System.Drawing.Point(320, 388)
        Me.btnSearchFTPAgain.Name = "btnSearchFTPAgain"
        Me.btnSearchFTPAgain.Size = New System.Drawing.Size(88, 32)
        Me.btnSearchFTPAgain.TabIndex = 37
        Me.btnSearchFTPAgain.Text = "Search FTP again"
        '
        'GroupBox1
        '
        Me.GroupBox1.Anchor = CType((System.Windows.Forms.AnchorStyles.Bottom Or System.Windows.Forms.AnchorStyles.Left), System.Windows.Forms.AnchorStyles)
        Me.GroupBox1.Controls.Add(Me.tbxFoundDuplicates)
        Me.GroupBox1.FlatStyle = System.Windows.Forms.FlatStyle.System
        Me.GroupBox1.Location = New System.Drawing.Point(440, 384)
        Me.GroupBox1.Name = "GroupBox1"
        Me.GroupBox1.Size = New System.Drawing.Size(120, 48)
        Me.GroupBox1.TabIndex = 40
        Me.GroupBox1.TabStop = False
        Me.GroupBox1.Text = "Found duplicates"
        '
        'tbxFoundDuplicates
        '
        Me.tbxFoundDuplicates.Anchor = CType((System.Windows.Forms.AnchorStyles.Bottom Or System.Windows.Forms.AnchorStyles.Left), System.Windows.Forms.AnchorStyles)
        Me.tbxFoundDuplicates.BackColor = System.Drawing.SystemColors.Window
        Me.tbxFoundDuplicates.Location = New System.Drawing.Point(8, 16)
        Me.tbxFoundDuplicates.Name = "tbxFoundDuplicates"
        Me.tbxFoundDuplicates.ReadOnly = True
        Me.tbxFoundDuplicates.Size = New System.Drawing.Size(104, 20)
        Me.tbxFoundDuplicates.TabIndex = 0
        '
        'GroupBox2
        '
        Me.GroupBox2.Anchor = CType((System.Windows.Forms.AnchorStyles.Bottom Or System.Windows.Forms.AnchorStyles.Left), System.Windows.Forms.AnchorStyles)
        Me.GroupBox2.Controls.Add(Me.tbxFTPListTotalCount)
        Me.GroupBox2.FlatStyle = System.Windows.Forms.FlatStyle.System
        Me.GroupBox2.Location = New System.Drawing.Point(440, 440)
        Me.GroupBox2.Name = "GroupBox2"
        Me.GroupBox2.Size = New System.Drawing.Size(120, 48)
        Me.GroupBox2.TabIndex = 41
        Me.GroupBox2.TabStop = False
        Me.GroupBox2.Text = "FTP files evaluated"
        '
        'tbxFTPListTotalCount
        '
        Me.tbxFTPListTotalCount.Anchor = CType((System.Windows.Forms.AnchorStyles.Bottom Or System.Windows.Forms.AnchorStyles.Left), System.Windows.Forms.AnchorStyles)
        Me.tbxFTPListTotalCount.BackColor = System.Drawing.SystemColors.Window
        Me.tbxFTPListTotalCount.Location = New System.Drawing.Point(8, 16)
        Me.tbxFTPListTotalCount.Name = "tbxFTPListTotalCount"
        Me.tbxFTPListTotalCount.ReadOnly = True
        Me.tbxFTPListTotalCount.Size = New System.Drawing.Size(104, 20)
        Me.tbxFTPListTotalCount.TabIndex = 0
        '
        'cbxScrollList
        '
        Me.cbxScrollList.Anchor = CType((System.Windows.Forms.AnchorStyles.Bottom Or System.Windows.Forms.AnchorStyles.Left), System.Windows.Forms.AnchorStyles)
        Me.cbxScrollList.FlatStyle = System.Windows.Forms.FlatStyle.System
        Me.cbxScrollList.Location = New System.Drawing.Point(8, 8)
        Me.cbxScrollList.Name = "cbxScrollList"
        Me.cbxScrollList.Size = New System.Drawing.Size(73, 24)
        Me.cbxScrollList.TabIndex = 42
        Me.cbxScrollList.Text = "Scroll list"
        '
        'GroupBox3
        '
        Me.GroupBox3.Anchor = CType((System.Windows.Forms.AnchorStyles.Bottom Or System.Windows.Forms.AnchorStyles.Left), System.Windows.Forms.AnchorStyles)
        Me.GroupBox3.Controls.Add(Me.tbxDownloading)
        Me.GroupBox3.FlatStyle = System.Windows.Forms.FlatStyle.System
        Me.GroupBox3.Location = New System.Drawing.Point(440, 328)
        Me.GroupBox3.Name = "GroupBox3"
        Me.GroupBox3.Size = New System.Drawing.Size(120, 48)
        Me.GroupBox3.TabIndex = 43
        Me.GroupBox3.TabStop = False
        Me.GroupBox3.Text = "Downloading"
        '
        'tbxDownloading
        '
        Me.tbxDownloading.Anchor = CType((System.Windows.Forms.AnchorStyles.Bottom Or System.Windows.Forms.AnchorStyles.Left), System.Windows.Forms.AnchorStyles)
        Me.tbxDownloading.BackColor = System.Drawing.SystemColors.Window
        Me.tbxDownloading.Location = New System.Drawing.Point(8, 16)
        Me.tbxDownloading.Name = "tbxDownloading"
        Me.tbxDownloading.ReadOnly = True
        Me.tbxDownloading.Size = New System.Drawing.Size(104, 20)
        Me.tbxDownloading.TabIndex = 0
        '
        'Panel1
        '
        Me.Panel1.Anchor = CType((System.Windows.Forms.AnchorStyles.Bottom Or System.Windows.Forms.AnchorStyles.Right), System.Windows.Forms.AnchorStyles)
        Me.Panel1.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D
        Me.Panel1.Controls.Add(Me.cbxScrollList)
        Me.Panel1.Location = New System.Drawing.Point(682, 344)
        Me.Panel1.Name = "Panel1"
        Me.Panel1.Size = New System.Drawing.Size(88, 40)
        Me.Panel1.TabIndex = 44
        '
        'TabControl1
        '
        Me.TabControl1.Anchor = CType((((System.Windows.Forms.AnchorStyles.Top Or System.Windows.Forms.AnchorStyles.Bottom) _
                    Or System.Windows.Forms.AnchorStyles.Left) _
                    Or System.Windows.Forms.AnchorStyles.Right), System.Windows.Forms.AnchorStyles)
        Me.TabControl1.ContextMenu = Me.ctxMenu
        Me.TabControl1.Controls.Add(Me.tabDownload)
        Me.TabControl1.Controls.Add(Me.tabLog)
        Me.TabControl1.Location = New System.Drawing.Point(0, 0)
        Me.TabControl1.Name = "TabControl1"
        Me.TabControl1.SelectedIndex = 0
        Me.TabControl1.Size = New System.Drawing.Size(792, 328)
        Me.TabControl1.TabIndex = 45
        '
        'tabDownload
        '
        Me.tabDownload.Controls.Add(Me.lvwStatus)
        Me.tabDownload.Location = New System.Drawing.Point(4, 22)
        Me.tabDownload.Name = "tabDownload"
        Me.tabDownload.Size = New System.Drawing.Size(784, 302)
        Me.tabDownload.TabIndex = 0
        Me.tabDownload.Text = "Download queue"
        '
        'tabLog
        '
        Me.tabLog.Controls.Add(Me.lvwUpdateLog)
        Me.tabLog.Location = New System.Drawing.Point(4, 22)
        Me.tabLog.Name = "tabLog"
        Me.tabLog.Size = New System.Drawing.Size(784, 302)
        Me.tabLog.TabIndex = 1
        Me.tabLog.Text = "Log"
        '
        'lvwUpdateLog
        '
        Me.lvwUpdateLog.Anchor = CType((((System.Windows.Forms.AnchorStyles.Top Or System.Windows.Forms.AnchorStyles.Bottom) _
                    Or System.Windows.Forms.AnchorStyles.Left) _
                    Or System.Windows.Forms.AnchorStyles.Right), System.Windows.Forms.AnchorStyles)
        Me.lvwUpdateLog.Columns.AddRange(New System.Windows.Forms.ColumnHeader() {Me.ColumnHeader1})
        Me.lvwUpdateLog.HeaderStyle = System.Windows.Forms.ColumnHeaderStyle.None
        Me.lvwUpdateLog.Location = New System.Drawing.Point(0, 8)
        Me.lvwUpdateLog.Name = "lvwUpdateLog"
        Me.lvwUpdateLog.Size = New System.Drawing.Size(784, 288)
        Me.lvwUpdateLog.TabIndex = 0
        Me.lvwUpdateLog.UseCompatibleStateImageBehavior = False
        Me.lvwUpdateLog.View = System.Windows.Forms.View.Details
        '
        'ColumnHeader1
        '
        Me.ColumnHeader1.Width = 780
        '
        'btnAnalyzeAgain
        '
        Me.btnAnalyzeAgain.Anchor = CType((System.Windows.Forms.AnchorStyles.Bottom Or System.Windows.Forms.AnchorStyles.Left), System.Windows.Forms.AnchorStyles)
        Me.btnAnalyzeAgain.FlatStyle = System.Windows.Forms.FlatStyle.System
        Me.btnAnalyzeAgain.Location = New System.Drawing.Point(320, 337)
        Me.btnAnalyzeAgain.Name = "btnAnalyzeAgain"
        Me.btnAnalyzeAgain.Size = New System.Drawing.Size(88, 32)
        Me.btnAnalyzeAgain.TabIndex = 46
        Me.btnAnalyzeAgain.Text = "Analyze list again"
        '
        'Ftp2
        '
        Me.Ftp2.ClientDataPort = ""
        '
        '
        '
        Me.Ftp2.Connection.DoEvents = False
        Me.Ftp2.Editor = Me.Ftp2
        Me.Ftp2.Password = ""
        Me.Ftp2.Server = ""
        Me.Ftp2.Username = ""
        '
        'Viewer1
        '
        Me.Viewer1.Anchor = CType((System.Windows.Forms.AnchorStyles.Bottom Or System.Windows.Forms.AnchorStyles.Left), System.Windows.Forms.AnchorStyles)
        Me.Viewer1.BackColor = System.Drawing.Color.Black
        Me.Viewer1.ForeColor = System.Drawing.SystemColors.ControlText
        Me.Viewer1.Image = Nothing
        Me.Viewer1.ImageSizeMode = FTPHoover.SizeMode.RatioStretch
        Me.Viewer1.Location = New System.Drawing.Point(8, 336)
        Me.Viewer1.Name = "Viewer1"
        Me.Viewer1.Size = New System.Drawing.Size(296, 216)
        Me.Viewer1.TabIndex = 39
        '
        'frmPictureStatus
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.ClientSize = New System.Drawing.Size(792, 581)
        Me.Controls.Add(Me.btnAnalyzeAgain)
        Me.Controls.Add(Me.TabControl1)
        Me.Controls.Add(Me.Panel1)
        Me.Controls.Add(Me.GroupBox3)
        Me.Controls.Add(Me.GroupBox2)
        Me.Controls.Add(Me.GroupBox1)
        Me.Controls.Add(Me.Viewer1)
        Me.Controls.Add(Me.btnSearchFTPAgain)
        Me.Controls.Add(Me.gbxTotalProgress)
        Me.Controls.Add(Me.btnClearAllLists)
        Me.Controls.Add(Me.btnDownload)
        Me.Controls.Add(Me.btnStatusExit)
        Me.Icon = CType(resources.GetObject("$this.Icon"), System.Drawing.Icon)
        Me.Name = "frmPictureStatus"
        Me.gbxTotalProgress.ResumeLayout(False)
        Me.GroupBox1.ResumeLayout(False)
        Me.GroupBox1.PerformLayout()
        Me.GroupBox2.ResumeLayout(False)
        Me.GroupBox2.PerformLayout()
        Me.GroupBox3.ResumeLayout(False)
        Me.GroupBox3.PerformLayout()
        Me.Panel1.ResumeLayout(False)
        Me.TabControl1.ResumeLayout(False)
        Me.tabDownload.ResumeLayout(False)
        Me.tabLog.ResumeLayout(False)
        Me.ResumeLayout(False)

    End Sub

#End Region

    'Delegate and Event declaration
    Public Delegate Sub LoginEventHandler(ByVal sender As Object, ByVal e As LoginEventArgs)
    Public Event LoginEvent As LoginEventHandler

    'Download strategy for pictures controlled by MySQL database:
    '
    '1. Check if combination of filename + filesize exists in DB.
    '       In that case, don't download file, it is a duplicate with 99% certainty.
    '2. After download of file, calculate checksum and check if that checksum exists in DB.
    '       If so, see if downloaded file is bigger than files already download, if so
    '       it is a more complete picture while the already downloaded ones probably
    '       are corrupt. Keep it.
    '       If it is smaller, delete it.
    '       In both cases, insert file info into database, so we can identify the
    '       duplicate next time.

    'Special problem
    'If you run the programs too fast during testing you can get kernel errors

    'SPECIAL PARAMETERS - START
    'MD5 hash calculated on this length, might be necessary to change later

    'Size below which we don't look for duplicates of different length
    'Size of the MD5 hash to disk
    'Files smaller than this parameter will use the total of their size as input
    'for making the MD5 hash.
    'Determine this parameter and never change it in future releases of program
    Dim lengthToCheck As Long = 250000

    'Params from main BELOW

    Public Shared parentRef As frmMain

    Public FTPServerName As String
    Public FTPServer As String
    Public FTPUsername As String
    Public FTPPassword As String
    Public FTPServerPort As Integer
    Public FTPPassive As Boolean
    Public serverType As String
    Public useSSL As Boolean

    Public FTPStartFolder As String
    Public FTPAvoidFolders As String()
    Public FTPHotList As String()

    Public SystemDownloadDirectory As String
    Public SystemCollectionFile As String
    Public SystemAvoidCollectionFile As String
    Public listDirectory As String

    Public myConnectionString As String
    Public collectionTablename As String

    Public pictureMaxSize As Integer

    'Params from main ABOVE

    Public mySQLCommandString As String

    Public onlyDirectoryPath As String

    Public md As MediaDetClass
    Public img As Image
    Public mdFilename As String

    Public FTPLoginOK As Boolean
    Public lvwStatusChanged As Boolean
    Public DownloadActive As Boolean

    Public ThisIsANewFile As Boolean
    Public ThisIsAResume As Boolean

    Public lvwItem As ListViewItem
    Public lvwItemIndex As Integer
    Public myListViewItem As ListViewItem

    Public CancelDownloadRequested As Boolean
    Public CancelLoginRequested As Boolean
    Public FileIsInteresting As Boolean
    Public arrFilePath() As String
    Public arrRecord() As String

    Public analyzeListCount As Integer
    Public downloadCount As Integer

    Public ProgramDefaultDirectory As String

    Public sbStatus As New ExtendedStatusBar
    Public indexToSelectedLine As Integer

    Public lvwDuplicateItem As ListViewItem
    Public lvwDuplicateItem2 As ListViewItem
    Public cstring As String
    Public cstring2 As String
    Public cstring3 As String
    Public sizeOfDownload As Long
    Public counter As Integer
    Public getString As String

    Public UserOK As Boolean
    Public messageToFTPUser As String

    Public ListExists As Boolean

    Public exArray As String()

    Public publicAvoidDirectoryString As String
    Public publicGetFileString As String

    Public HorizontalTab = Chr(9)
    Public LineFeed = Chr(10)
    Public CarriageReturn = Chr(13)

    Public passiveConnection As String
    Public avoidDirectoryString As String = ""
    Public getFileString As String = ""
    Public noteString As String = ""
    Public giveftpaccess As String

    Public soundClip As String

    Public downloadSpeed As Integer
    Public timeToDownload As Integer
    Public downloadDirectory As String

    Public FTPSecureinvoke As Dart.PowerTCP.SecureFtp.Invoke
    Public FTPSecurelisting As Dart.PowerTCP.SecureFtp.Listing

    Public FTPListStreamWriter As StreamWriter
    Public FTPListStreamReader As StreamReader

    Public DownloadPicturesListStreamWriter As StreamWriter
    Public DownloadPicturesListStreamReader As StreamReader
    Public WCFListStreamReader As StreamReader
    Public CourtesyStreamWriter As StreamWriter

    'Fields in DownloadPicturesList.txt
    Public fileSize As Long
    Public fileStatus As String
    Public fileName As String
    Public filePath As String
    Public fileLocalName As String
    Public fileLocalPath As String
    Public fileLocalSize As Long

    Public collectionFileName As String
    Public collectionFilePath As String
    Public collectionFileSize As Long

    Public downloadSize As Long
    Public sizeDifference As Long

    Public nowEnteringDirectory As String
    Public currentDirectory As String
    Public saveCurrentDirectory As String

    Dim fullRemotePath As String
    Dim fullLocalPath As String
    Dim fullLocalOutputPath As String

    Public MoreRecordsToRead As Boolean
    Public FTPListRecord As String
    Public OptionsRecord As String
    Public FieldDelimiter As String = "|"
    Public SpecialFieldDelimiter As String = ":"
    Public fieldSplit As String()

    Public FTPFilesCount As Long
    Public listedFilesCount As Long
    Public listedFilesSize As Long

    Public MoreToReadFromWCF As Boolean
    Public MoreFileNamesToRead As Boolean
    Public WCFListRecord As String

    'htOldCollection is used when reading the FTP a second time to look for new
    'files, then the downloadlist is read, and if the file is new, we add it
    Public htOldCollection As New Hashtable
    Public htOptions As New Hashtable
    Public htFTPSite As New Hashtable
    Public FTPSiteRecord As String

    Public DownloadOK As Boolean
    Public RadioButtonsActivated As Boolean
    Public FTPLogString As String
    Public DownloadPicturesListRecord As String

    Public listviewUpdateCounter As Integer
    Public typeOfSpeed As Integer

    Public dHours As Integer
    Public dMinutes As Integer

    Public FirstTimeSortOfList As Boolean
    Public onQueueCount As Integer
    Public FTPGetFiles As String()
    Public FTPAvoidFiles As String()
    Public htKey As String
    Public numberOfFilesInListview As Integer
    Public WeWantThisFile As Boolean = False
    Public FTPString As String

    Public downloadlocalpath As String

    Public bytearrayinput() As Byte
    Public MD5hashstring As String
    Public MD5hash As Byte()
    Public MD5 As New MD5CryptoServiceProvider
    Public MD5DuplicateDeleted As Boolean
    Public checkFileInfo As FileInfo

    Public myConnection As MySqlConnection
    Public myCommand As MySqlCommand

    Public foundDuplicatesCount As Integer
    Public ANewDirectoryWasCreated As Boolean
    Public downloadlocaldirectory As String

    Public ScrollList As Boolean
    Public FTPFilesEvaluatedCount As Integer

    Public ReportSpecialError As Boolean
    Public FTPRecord As String
    Public FTPStreamReader As StreamReader
    Public FTPStreamWriter As StreamWriter

    Public pathLength As Integer
    Public duplicateFilePath As String

    Public searchFilename As String

    Public presentDownloadCount As Integer
    Public analyzeFoundCount As Integer

    Public outputMessage As String
    Public exceptionType As String

    Public exString As String
    Public excounter As Integer

    Public theSize As String
    Public SpaceCharacter As String = " "

    Dim ItsAHotListFile As Boolean
    Dim checkThisFileName As String
    Dim removeIndex As Integer

    Public ExitPressed As Boolean = False

    Private Sub btnDownload_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnDownload.Click
        If btnDownload.Text = "Start download" Then
            btnDownload.Text = "Stop download"
            btnAnalyzeAgain.Enabled = False
            btnSearchFTPAgain.Enabled = False
            btnClearAllLists.Enabled = False
            StartDownload()
        Else
            btnDownload.Text = "Start download"
            btnAnalyzeAgain.Enabled = True
            btnSearchFTPAgain.Enabled = True
            btnClearAllLists.Enabled = True

            Viewer1.Image = Nothing

            StopDownload()
        End If
    End Sub

    Private Sub btnSearchFTPAgain_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnSearchFTPAgain.Click
        CancelDownloadRequested = False
        GetFileListFromFTP()

        'All this becasue the counter won't update
        AnalyzeOnButtonSearchAgainJob()

    End Sub

    Private Sub AnalyzeOnButtonSearchAgainJob()
        Dim analyzesearchagainThread As New Thread(New ThreadStart(AddressOf AnalyzeOnButtonSearchAgain))
        analyzesearchagainThread.Start()
    End Sub

    Private Sub AnalyzeOnButtonSearchAgain()
        AnalyzeFTPList()
        LoadDownloadListInListView()
        SaveListViewToFile()

        If analyzeFoundCount > 0 Then
            btnDownload.Enabled = True
            sbStatus.Panels(0).Text = analyzeFoundCount.ToString + " new files found"
        Else
            sbStatus.Panels(0).Text = "No new files to download found"
        End If
    End Sub


    Private Sub btnStatusExit_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnStatusExit.Click

        If DownloadActive = True Then
            DownloadActive = False
            CancelDownloadRequested = True
            ExitPressed = True
            Try
                Ftp2.AbortTransfer()
                Ftp2Close()
            Catch ex As Exception
            End Try

            Try
                FTPListStreamWriter.Close()
            Catch ex As Exception
            End Try
        Else
            Me.Dispose()
        End If

    End Sub


    Public Sub StartDownload()
        DownloadActive = True
        CancelDownloadRequested = False
        CancelLoginRequested = False
        FirstTimeSortOfList = False
        GroupBox3.Text = "Downloading"

        lvwUpdateLog.Items.Clear()

        CheckForList()
        If ListExists Then
            GetOnQueuecount()
            StartDownloadJob()
        Else
            GetFileListFromFTP()
            AnalyzeOnStartDownloadJob()
        End If

    End Sub


    Private Sub AnalyzeOnStartDownloadJob()
        Dim analyzeonstartThread As New Thread(New ThreadStart(AddressOf AnalyzeOnStartDownload))
        analyzeonstartThread.Start()
    End Sub


    Private Sub AnalyzeOnStartDownload()
        AnalyzeFTPList()
        LoadDownloadListInListView()
        SaveListViewToFile()
        sbStatus.Panels(0).Text = analyzeFoundCount.ToString + " new files found"

        If Not CancelDownloadRequested Then
            StartDownloadJob()
        End If

    End Sub


    Private Sub CheckForList()
        If Not Directory.Exists(listDirectory) Then
            Directory.CreateDirectory(listDirectory)
        End If

        ListExists = False
        If File.Exists(listDirectory + "\" + "DownloadPicturesList.txt") Then
            ListExists = True
        End If
    End Sub


    Private Sub StartDownloadJob()
        Dim downloadThread As New Thread(New ThreadStart(AddressOf DownloadJob))
        downloadThread.Start()
    End Sub


    Private Sub StopDownload()
        DownloadActive = False
        CancelDownloadRequested = True
        CancelLoginRequested = True
        GroupBox3.Text = "Downloaded"
        Try
            Ftp2.AbortTransfer()
            'Ftp2Close()
        Catch ex As Exception
        End Try

        sbStatus.Panels(0).Text = "Stopping download. Wait"
        'sbStatus.Panels(0).Text = "Download stopped."

    End Sub


    Public Sub GetFileListFromFTP()
        'If FTP server shuts down during listing, program will backtrack in the
        '   recursed loops and then it quits, it doesn't take very long. This
        '   could be supplemented by a boolean and some error reporting/action

        sbStatus.Panels(0).Text = "Create file list"

        listedFilesCount = 0
        listedFilesSize = 0

        'Create the directory for output of lists concerning specific ftp site
        Try
            If Not Directory.Exists(listDirectory) Then
                Directory.CreateDirectory(listDirectory)
            End If
        Catch ex As Exception
            sbStatus.Panels(0).Text = "Couldn't create directory, review download directory setting"
            Exit Sub
        End Try

        FTPListStreamWriter = New StreamWriter(listDirectory + "\" + "FTPPicturesList.txt")

        'Got Operation in progress exception when aborting download
        If Ftp2.Busy Then
            Ftp2.Abort()
        End If

        Ftp2.Server = FTPServer
        Ftp2.Username = FTPUsername
        Ftp2.Password = FTPPassword
        Ftp2.ServerPort = FTPServerPort
        If FTPPassive Then
            Ftp2.Passive = True
        Else
            Ftp2.Passive = False
        End If
        'Just to make sure GUI remains responsive
        Ftp2.DoEvents = True

        If useSSL Then
            'Here are the 2 commands needed to run the client in SSL mode
            ' "Disable" security checks
            Ftp2.UseAuthentication = False
            ' Set the desired security/authentication to explicit. 
            Ftp2.Security = Dart.PowerTCP.SecureFtp.Security.Explicit
        End If

        sbStatus.Panels(0).Text = "Connecting to FTP"

        'This change makes it possible to use folderstructure to avoid
        'folders, lilke /foldera/folderc
        Try
            nowEnteringDirectory = Ftp2.GetDirectory + "/" + FTPStartFolder
        Catch ex As Exception
            exceptionType = "Exception"
            FTPException(exceptionType, ex)
            sbStatus.Panels(0).Text = "Connect failed. See log for details"
            CancelDownloadRequested = True
            FTPListStreamWriter.Close()
            Exit Sub
        End Try

        nowEnteringDirectory = nowEnteringDirectory.Replace("//", "/")
        FTPString = nowEnteringDirectory.ToLower

        counter = 0
        While counter < FTPAvoidFolders.Length
            getString = FTPAvoidFolders(counter).ToLower
            If getString.Length > 0 Then
                If (FTPString.IndexOf(getString) >= 0) Then

                    'Close file and exit, nothing listed top folder avoided
                    FTPListStreamWriter.Close()

                    If htOptions.Item("sound") = "on" Then
                        If htOptions.ContainsKey("soundactioncompleted") Then
                            If htOptions.Item("soundactioncompleted") <> "" Then
                                soundClip = htOptions.Item("soundactioncompleted")
                                playSoundClip()
                            End If
                        End If
                    End If

                    Exit Sub
                End If
            End If
            counter += 1
        End While

        'If a startfolder has been entered go there
        If FTPStartFolder.Length > 0 Then
            Try
                FTPSecureinvoke = Ftp2.Invoke(Dart.PowerTCP.SecureFtp.FtpCommand.ChangeDir, FTPStartFolder)
            Catch ex As System.Net.ProtocolViolationException
                'Better handling later
                exceptionType = "System.Net.ProtocolViolationException"
                FTPException(exceptionType, ex)
                sbStatus.Panels(0).Text = "Change to start folder " + _
                    FTPStartFolder + " probably OK"
            Catch ex As System.Net.Sockets.SocketException
                exceptionType = "System.Net.Sockets.SocketException"
                FTPException(exceptionType, ex)
                sbStatus.Panels(0).Text = "Change to start folder " + _
                    FTPStartFolder + " unsuccessful"
                FTPListStreamWriter.Close()
                Ftp2Close()
                Exit Sub
            Catch ex As Exception
                exceptionType = "Exception"
                FTPException(exceptionType, ex)
                sbStatus.Panels(0).Text = "Change to start folder " + _
                    FTPStartFolder + " unsuccessful"
                FTPListStreamWriter.Close()
                Ftp2Close()
                Exit Sub
            End Try
        End If

        Try
            'Problem with this style of listing on Cerberus FTP Server, use it as a fallback
            'FTPSecurelisting = Ftp2.List("*", True)
            FTPSecurelisting = Ftp2.List("", True)
        Catch ex As Exception
            exceptionType = "Exception"
            FTPException(exceptionType, ex)
            outputMessage = "Listing command failed"
            'lvwMovieLog.Items.Add(outputMessage)
            myListViewItem = lvwUpdateLog.Items.Add(outputMessage)
            'myListViewItem.EnsureVisible()
            myListViewItem.ForeColor = Color.Red
            If ScrollList = True Then
                myListViewItem.EnsureVisible()
            End If

            Ftp2Close()
            sbStatus.Panels(0).Text = "Failed to list folder"
            FTPListStreamWriter.Close()
            Ftp2Close()
            Exit Sub
        End Try

        If FTPSecurelisting.Format <> Dart.PowerTCP.SecureFtp.ListingFormat.Unknown Then
            Dim le As Dart.PowerTCP.SecureFtp.ListEntry

            currentDirectory = Ftp2.GetDirectory

            For Each le In FTPSecurelisting

                If CancelDownloadRequested = True Then
                    Exit For
                End If

                'le.Path is empty will only have a value if 
                'server supports The List call is for a recursive listing: Ftp.List("-R", true) 
                'le.TimeStamp gives last changed date
                If le.Type = Dart.PowerTCP.SecureFtp.EntryType.File Then
                    fileSize = le.Size

                    'Sometimes a file has size 0 and that causes trouble later
                    If le.Size > 0 Then
                        FTPListStreamWriter.WriteLine(le.Name + FieldDelimiter + _
                            le.Size.ToString + FieldDelimiter + _
                            currentDirectory)

                        'This should keep output records intact
                        'Just a safety measure, if a half line is written and program
                        '   continues, it will dump since half of the record is gone.
                        FTPListStreamWriter.Flush()

                        listedFilesCount += 1
                        listedFilesSize += le.Size
                    End If

                End If

                If le.Type = Dart.PowerTCP.SecureFtp.EntryType.Directory Then

                    Call RecurseFileList(le)

                End If

                If le.Type = Dart.PowerTCP.SecureFtp.EntryType.Link Then

                    Call RecurseFileList(le)

                End If

            Next

            If CancelDownloadRequested = True Then
                FTPListStreamWriter.Close()
                Ftp2Close()
                sbStatus.Panels(0).Text = "Listing cancelled"
                Exit Sub
            Else
                sbStatus.Panels(0).Text = listedFilesCount.ToString + " - " + _
                  currentDirectory
            End If


        Else
            'parentRef.lbxResponse.Items.Add("Listing format is unknown. You must parse it yourself.")
        End If

        FTPListStreamWriter.Close()

        Ftp2Close()

        If htOptions.Item("sound") = "on" Then
            If htOptions.ContainsKey("soundactioncompleted") Then
                If htOptions.Item("soundactioncompleted") <> "" Then
                    soundClip = htOptions.Item("soundactioncompleted")
                    playSoundClip()
                End If
            End If
        End If

    End Sub


    Public Function RecurseFileList(ByVal le As Dart.PowerTCP.SecureFtp.ListEntry)

        If CancelDownloadRequested = True Then
            Exit Function
        End If

        'This change makes it possible to use folderstructure to avoid
        'folders, lilke /foldera/folderc
        Try
            If le.Type = Dart.PowerTCP.SecureFtp.EntryType.Directory Then
                nowEnteringDirectory = Ftp2.GetDirectory + "/" + le.Name
            Else
                nowEnteringDirectory = Ftp2.GetDirectory + "/" + le.Destination
            End If
        Catch ex As Exception
            Exit Function
        End Try

        nowEnteringDirectory = nowEnteringDirectory.Replace("//", "/")
        FTPString = nowEnteringDirectory.ToLower

        counter = 0
        While counter < FTPAvoidFolders.Length
            getString = FTPAvoidFolders(counter).ToLower
            If getString.Length > 0 Then
                If (FTPString.IndexOf(getString) >= 0) Then
                    Exit Function
                End If
            End If
            counter += 1
        End While

        Try
            If le.Type = Dart.PowerTCP.SecureFtp.EntryType.Directory Then

                FTPSecureinvoke = Ftp2.Invoke(Dart.PowerTCP.SecureFtp.FtpCommand.ChangeDir, le.Name)
            Else
                FTPSecureinvoke = Ftp2.Invoke(Dart.PowerTCP.SecureFtp.FtpCommand.ChangeDir, le.Destination)
            End If
        Catch ex As System.Net.ProtocolViolationException
            'Why is it thrown here, but action is OK
            'Remove this displays if it works
            'parentRef.lbxResponse.Items.Add("ChangeDir Command probably ok with change to " + le.Name)
            'lvwMovieLog.Items.Add(ex.Message)
        Catch ex As System.Net.Sockets.SocketException
            'parentRef.lbxResponse.Items.Add("ChangeDir Command failed when trying to change to " + le.Name)
            Exit Function
        Catch ex As Exception
            'If list arrives to quickly we get "too many kernel references to some
            'objects", can it be slowed down and recovered?
            'probably mostly a problem when testing against localhost
            'parentRef.lbxResponse.Items.Add("ChangeDir Command failed when trying to change to " + le.Name)
            Exit Function
        End Try

        Dim FTPsublisting As Dart.PowerTCP.SecureFtp.Listing
        Try
            'FTPsublisting = Ftp2.List("*", True)
            FTPsublisting = Ftp2.List("", True)
        Catch ex As Exception

            exceptionType = "Exception"
            FTPException(exceptionType, ex)

            outputMessage = "Listing command failed"
            myListViewItem = lvwUpdateLog.Items.Add(outputMessage)
            myListViewItem.ForeColor = Color.Red
            If ScrollList = True Then
                myListViewItem.EnsureVisible()
            End If

            'If pressing exit button, this will dump the program if not
            'exeption is handled
            Try
                sbStatus.Panels(0).Text = ""
            Catch ex2 As Exception
            End Try

            Exit Function

        End Try

        If CancelDownloadRequested = True Then
            Exit Function
        End If
        currentDirectory = Ftp2.GetDirectory

        If FTPsublisting.Format <> Dart.PowerTCP.SecureFtp.ListingFormat.Unknown Then
            Dim suble As Dart.PowerTCP.SecureFtp.ListEntry

            For Each suble In FTPsublisting

                If suble.Type = Dart.PowerTCP.SecureFtp.EntryType.File Then

                    fileSize = suble.Size

                    'Sometimes file size = 0 and that causes problems later
                    If suble.Size > 0 Then
                        FTPListStreamWriter.WriteLine(suble.Name + FieldDelimiter + _
                            suble.Size.ToString + FieldDelimiter + _
                            currentDirectory)
                        FTPListStreamWriter.Flush()

                        listedFilesCount += 1
                        listedFilesSize += suble.Size
                    End If

                End If

                If suble.Type = Dart.PowerTCP.SecureFtp.EntryType.Directory Then

                    Call RecurseFileList(suble)

                End If

                If suble.Type = Dart.PowerTCP.SecureFtp.EntryType.Link Then

                    Call RecurseFileList(suble)

                End If

            Next

            If CancelDownloadRequested = True Then
                Exit Function
            End If

            sbStatus.Panels(0).Text = listedFilesCount.ToString + " - " + _
                  currentDirectory

        Else
            'parentRef.lbxResponse.Items.Add("Listing format is unknown. You must parse it yourself.")
        End If


        Try
            If le.Type = Dart.PowerTCP.SecureFtp.EntryType.Directory Then
                FTPSecureinvoke = Ftp2.Invoke(Dart.PowerTCP.SecureFtp.FtpCommand.ChangeDirUp, le.Name)
            Else
                FTPSecureinvoke = Ftp2.Invoke(Dart.PowerTCP.SecureFtp.FtpCommand.ChangeDirUp, le.Destination)
            End If

            currentDirectory = Ftp2.GetDirectory

        Catch ex As System.Net.ProtocolViolationException
            'Why is it thrown here, but action is OK
        Catch ex As System.Net.Sockets.SocketException
            'parentRef.lbxResponse.Items.Add("ChangeDirUp Command failed")

            exceptionType = "System.Net.Sockets.SocketException"
            FTPException(exceptionType, ex)

            'outputMessage = ex.Message
            'lvwMovieLog.Items.Add(outputMessage)
            'myListViewItem = lvwUpdateLog.Items.Add(outputMessage)
            'myListViewItem.EnsureVisible()
            'myListViewItem.ForeColor = Color.Red

            Exit Function
        Catch ex As Exception
            'parentRef.lbxResponse.Items.Add("ChangeDirUp Command failed")

            exceptionType = "Exception"
            FTPException(exceptionType, ex)

            'outputMessage = ex.ToString
            'lvwMovieLog.Items.Add(outputMessage)
            'myListViewItem = lvwUpdateLog.Items.Add(outputMessage)
            'myListViewItem.EnsureVisible()
            'myListViewItem.ForeColor = Color.Red

            Exit Function
        End Try
        'parentRef.lbxResponse.Items.Add("ChangeDirUp successful")
        'parentRef.lbxResponse.Items.Add("Current directory " + Ftp2.GetDirectory)

    End Function


    Private Sub AnalyzeFTPList()

        'Only exists when we are adding files
        loadHashTableOldCollection()

        analyzeListCount = 0

        listedFilesSize = 0
        Dim analyzeFileSize As Long = 0
        analyzeFoundCount = 0

        FTPListStreamReader = New StreamReader(listDirectory + "\" + "FTPPicturesList.txt")

        'Append on existing file, create if not there
        Dim DownloadPicturesListPath As String
        DownloadPicturesListPath = listDirectory + "\" + "DownloadPicturesList.txt"

        Dim DoOldCollectionCheck As Boolean = False

        If File.Exists(DownloadPicturesListPath) Then
            DoOldCollectionCheck = True
            Try
                DownloadPicturesListStreamWriter = File.AppendText(DownloadPicturesListPath)
            Catch ex As Exception
                sbStatus.Panels(0).Text = "Couldn't open existing " + _
                DownloadPicturesListPath + " for append. Error was " + ex.ToString
                Exit Sub
            End Try
        Else
            Try
                DownloadPicturesListStreamWriter = New StreamWriter(DownloadPicturesListPath)
            Catch ex As Exception
                sbStatus.Panels(0).Text = "Couldn't open new " + _
                DownloadPicturesListPath + " for write. Error was " + ex.ToString
                Exit Sub
            End Try
        End If

        MoreRecordsToRead = True

        GetNextFTPListRecord()
        Do While (MoreRecordsToRead)

            analyzeListCount += 1

            sbStatus.Panels(0).Text = "Analyzing file " + analyzeListCount.ToString + _
            " of " + listedFilesCount.ToString + " in list"

            fieldSplit = FTPListRecord.Split(FieldDelimiter)

            fileName = fieldSplit(0)
            fileSize = CLng(fieldSplit(1))
            filePath = fieldSplit(2)

            listedFilesSize += fileSize

            FTPString = fileName.ToLower

            FileIsInteresting = True

            'There is a max size to picture files
            If fileSize > pictureMaxSize Then
                FileIsInteresting = False
            End If

            'Only certain filetypes are interesting
            If FileIsInteresting Then
                WeWantThisFile = False
                counter = 0
                While counter < FTPGetFiles.Length
                    getString = FTPGetFiles(counter).ToLower
                    If getString.Length > 0 Then
                        If (FTPString.IndexOf(getString) >= 0) Then
                            WeWantThisFile = True
                            Exit While
                        End If
                    End If
                    counter += 1
                End While
                If Not WeWantThisFile Then
                    FileIsInteresting = False
                End If
            End If

            'Avoiding certain files
            If FileIsInteresting Then
                counter = 0
                While counter < FTPAvoidFiles.Length
                    getString = FTPAvoidFiles(counter).ToLower
                    If getString.Length > 0 Then
                        If (FTPString.IndexOf(getString) >= 0) Then
                            FileIsInteresting = False
                            Exit While
                        End If
                    End If
                    counter += 1
                End While
            End If

            'Found file with '?' in name, program dumps when that happens
            If FileIsInteresting Then
                If (FTPString.IndexOf("?") >= 0) Then
                    FileIsInteresting = False
                End If
            End If

            htKey = fieldSplit(0) + "+" + fieldSplit(1)
            'Don't mind small or big letters
            htKey = htKey.ToLower

            'If we have a DownloadPicturesList already, we will try to avoid to fill it up
            'with duplicates if we ask for a second scanning of the ftp
            If FileIsInteresting = True And DoOldCollectionCheck Then
                checkFileAgainstDownloadPicturesList()
            End If

            If FileIsInteresting Then
                'Read on index filename + filesize if this record exists in DB
                checkIfWeHaveFileAlreadyInDatabase()
            End If

            'If the file passes all tests, it will be written to output file
            If FileIsInteresting Then
                analyzeFileSize += fileSize
                analyzeFoundCount += 1

                cstring = Format(CLng(fileSize), "###,###,###,###,###")

                DownloadPicturesListRecord = cstring + FieldDelimiter + _
                "On queue" + FieldDelimiter + _
                fileName + FieldDelimiter + _
                filePath + FieldDelimiter

                DownloadPicturesListStreamWriter.WriteLine(DownloadPicturesListRecord)
            End If

            GetNextFTPListRecord()
        Loop

        CloseConnectionToDatabase()

        FTPFilesEvaluatedCount = analyzeListCount

        FTPListStreamReader.Close()
        DownloadPicturesListStreamWriter.Close()

        If htOptions.Item("sound") = "on" Then
            If htOptions.ContainsKey("soundactioncompleted") Then
                If htOptions.Item("soundactioncompleted") <> "" Then
                    soundClip = htOptions.Item("soundactioncompleted")
                    playSoundClip()
                End If
            End If
        End If

        FirstTimeSortOfList = True

        htOldCollection.Clear()

    End Sub


    Private Sub checkIfWeHaveFileAlreadyInDatabase()

        Dim result As Integer

        Try
            If myConnection Is Nothing Then
                OpenConnectionToDatabase()
            End If

            'Some filenames contain apostrophes
            'searchFilename = fileName.Replace("'", "''")
            searchFilename = fileName.Replace("'", "\'")

            mySQLCommandString = "SELECT COUNT(*) FROM " + collectionTablename + _
            " WHERE filename='" + searchFilename + _
            "' AND filesize='" + fileSize.ToString + "';"

            myCommand = New MySqlCommand(mySQLCommandString)
            myCommand.Connection = myConnection

            result = myCommand.ExecuteScalar

            'File exists in database with same name and size so we don't want it
            If result > 0 Then
                FileIsInteresting = False
            End If

        Catch ex As MySqlException
            exceptionType = "MySqlException"
            FTPException(exceptionType, ex)
            outputMessage = "CommandString :" + mySQLCommandString
            myListViewItem = lvwUpdateLog.Items.Add(outputMessage)
            myListViewItem.ForeColor = Color.Red
            If ScrollList = True Then
                myListViewItem.EnsureVisible()
            End If
        Catch ex As System.Net.Sockets.SocketException
            exceptionType = "System.Net.Sockets.SocketException"
            FTPException(exceptionType, ex)
            outputMessage = "CommandString :" + mySQLCommandString
            myListViewItem = lvwUpdateLog.Items.Add(outputMessage)
            myListViewItem.ForeColor = Color.Red
            If ScrollList = True Then
                myListViewItem.EnsureVisible()
            End If
        Catch ex As Exception
            exceptionType = "Exception"
            FTPException(exceptionType, ex)
            outputMessage = "CommandString :" + mySQLCommandString
            myListViewItem = lvwUpdateLog.Items.Add(outputMessage)
            myListViewItem.ForeColor = Color.Red
            If ScrollList = True Then
                myListViewItem.EnsureVisible()
            End If
        End Try

    End Sub


    Private Sub loadHashTableOldCollection()
        htOldCollection.Clear()
        If File.Exists(listDirectory + "\" + "DownloadPicturesList.txt") Then
            DownloadPicturesListStreamReader = New StreamReader(listDirectory + "\" + "DownloadPicturesList.txt")
            MoreRecordsToRead = True
            GetNextDownloadPicturesListRecord()
            Do While (MoreRecordsToRead)
                fieldSplit = DownloadPicturesListRecord.Split(FieldDelimiter)
                fileSize = CLng(fieldSplit(0))
                htKey = fieldSplit(2) + "+" + fileSize.ToString
                htKey = htKey.ToLower

                'Using filename and fileSize as key
                Try
                    htOldCollection.Add(htKey, "")
                Catch ex As Exception
                    'Not foolproof, there might be name/size duplicates, but 99%
                End Try
                GetNextDownloadPicturesListRecord()
            Loop
            DownloadPicturesListStreamReader.Close()
        End If
    End Sub


    Private Sub checkFileAgainstDownloadPicturesList()
        'If we have a file with the same file name and same file size, 
        'assume that we have it already. Not foolproof, but 99 percent 
        'and it allows partner to move files around and rename folders

        If htOldCollection.ContainsKey(htKey) Then
            FileIsInteresting = False
        End If
    End Sub


    Public Sub GetFTPFilesEvaluatedCount()
        FTPFilesEvaluatedCount = 0
        FTPListStreamReader = New StreamReader(listDirectory + "\" + "FTPPicturesList.txt")
        MoreRecordsToRead = True
        GetNextFTPListRecord()
        Do While (MoreRecordsToRead)
            FTPFilesEvaluatedCount += 1
            GetNextFTPListRecord()
        Loop
        FTPListStreamReader.Close()
    End Sub


    Private Sub DownloadJob()

        Dim InitialScroll As Boolean = True
        Dim textboxCounter As Integer

        downloadCount = 0

        ReportSpecialError = False

        'Write listview to file every 25th download
        listviewUpdateCounter = 0

        lvwStatusChanged = False

        'Second progressbar to report on total download activity
        spbTotal.Visible = True
        spbTotal.BarColor1 = Color.Red
        spbTotal.Minimum = 0
        spbTotal.Value = 0
        'spbTotal.Maximum = 100
        spbTotal.Maximum = onQueueCount
        spbTotal.Update()

        Dim lvwEnumerator As IEnumerator = lvwStatus.Items.GetEnumerator
        While lvwEnumerator.MoveNext()

            'Starting from the beginning when doing a change to the listview
            ' by the right-click menu
            If lvwStatusChanged = True Then
                lvwStatusChanged = False
                lvwEnumerator = lvwStatus.Items.GetEnumerator
                If Not lvwEnumerator.MoveNext Then
                    Exit While
                End If
            End If

            lvwItem = lvwEnumerator.Current
            If Not InitialScroll Then
                If ScrollList = True Then
                    lvwItem.EnsureVisible()
                End If
            End If
            lvwItemIndex = lvwItem.Index

            If CancelDownloadRequested = True Then
                Exit While
            End If

            fileSize = CLng(lvwItem.SubItems(0).Text)
            fileStatus = lvwItem.SubItems(1).Text
            fileName = lvwItem.SubItems(2).Text
            filePath = lvwItem.SubItems(3).Text

            If lvwItem.SubItems(1).Text = "On queue" Then
                'This avoids the scrolling during start of download
                If InitialScroll Then
                    InitialScroll = False
                    If ScrollList = True Then
                        lvwItem.EnsureVisible()
                    End If
                End If

                DownloadFile()
            End If

        End While

        SaveListViewToFile()

        CloseConnectionToDatabase()

        'This is the emergency exit
        If ExitPressed = True Then
            Me.Dispose()
        End If

        Dim tradeReport As String
        Dim ThisMoment As Date
        Dim myShortTime As String
        ThisMoment = Now
        myShortTime = ThisMoment.ToShortTimeString
        myShortTime = myShortTime.Replace(":", ".")

        textboxCounter = parentRef.tbxNote.Lines.Length

        If downloadCount = 1 Then
            If textboxCounter = 0 Then
                tradeReport = downloadCount.ToString + _
                " picture download at " + _
                ThisMoment.ToShortDateString + " " + _
                myShortTime
            Else
                tradeReport = Environment.NewLine + downloadCount.ToString + _
                " picture download at " + _
                ThisMoment.ToShortDateString + " " + _
                myShortTime
            End If
        Else
            If textboxCounter = 0 Then
                tradeReport = downloadCount.ToString + _
                " pictures download at " + _
                ThisMoment.ToShortDateString + " " + _
                myShortTime
            Else
                tradeReport = Environment.NewLine + downloadCount.ToString + _
                " pictures download at " + _
                ThisMoment.ToShortDateString + " " + _
                myShortTime
            End If
        End If

        'There might be a special condition that needs reporting, if not,
        '   use normal message
        If Not ReportSpecialError Then

            'Only disable user account on ftp when the whole download has been done
            If CancelDownloadRequested = False Then
                If htOptions.ContainsKey("ftpdone") Then
                    If htOptions.Item("ftpdone") = "yes" Then
                        outputMessage = "All files downloaded. Give user the bum's rush"
                        myListViewItem = lvwUpdateLog.Items.Add(outputMessage)
                        myListViewItem.ForeColor = Color.Green
                        If ScrollList = True Then
                            myListViewItem.EnsureVisible()
                        End If

                        giveUserTheBumsRush()
                        sbStatus.Panels(0).Text = "Download complete. " + _
                          "User account " + FTPServerName + " disabled. "
                        GroupBox3.Text = "Downloaded"
                        tbxDownloading.Text = downloadCount.ToString
                        btnDownload.Enabled = False

                        If downloadCount > 0 Then
                            parentRef.tbxNote.AppendText(tradeReport + " - Done.")
                            parentRef.SpecialNoteSave()
                        End If

                    Else
                        GroupBox3.Text = "Downloaded"
                        tbxDownloading.Text = downloadCount.ToString
                        sbStatus.Panels(0).Text = "Download complete."
                        btnDownload.Enabled = False

                        If downloadCount > 0 Then
                            parentRef.tbxNote.AppendText(tradeReport + " - Done.")
                            parentRef.SpecialNoteSave()
                        End If

                    End If
                Else
                    GroupBox3.Text = "Downloaded"
                    tbxDownloading.Text = downloadCount.ToString
                    sbStatus.Panels(0).Text = "Download complete."
                    btnDownload.Enabled = False

                    If downloadCount > 0 Then
                        parentRef.tbxNote.AppendText(tradeReport + " - Done.")
                        parentRef.SpecialNoteSave()
                    End If

                End If
            Else
                Try
                    GroupBox3.Text = "Downloaded"
                    tbxDownloading.Text = downloadCount.ToString
                    sbStatus.Panels(0).Text = "Download stopped"

                    If downloadCount > 0 Then
                        parentRef.tbxNote.AppendText(tradeReport)
                        parentRef.SpecialNoteSave()
                    End If

                Catch ex As Exception
                    'Ugly, but panel is empty when exiting with Exit button
                End Try
            End If
        Else
            'Lots of errors makes reporting here impracticable
            'If downloadCount > 0 Then
            'parentRef.tbxNote.AppendText(tradeReport)
            'parentRef.SpecialNoteSave()
            'End If

        End If

        sbStatus.progressBar.Value = 0
        sbStatus.progressBar.Update()

        If DownloadOK Then
            btnDownload.Text = "Start download"
            btnAnalyzeAgain.Enabled = True
            btnSearchFTPAgain.Enabled = True
            btnClearAllLists.Enabled = True
        End If

        DownloadActive = False


    End Sub


    Private Sub DownloadFile()

        Dim remotePath As String
        Dim saveDirectory As String
        Dim receivingFileName As String

        Dim sizeToDownload As Long

        Dim OKToTryToDownload As Boolean

        sbStatus.progressBar.BarColor1 = Color.ForestGreen

        Ftp2.Server = FTPServer
        Ftp2.Username = FTPUsername
        Ftp2.Password = FTPPassword
        Ftp2.ServerPort = FTPServerPort
        'Binary transfer
        Ftp2.FileType = Dart.PowerTCP.SecureFtp.FileType.Image
        If FTPPassive Then
            Ftp2.Passive = True
        Else
            Ftp2.Passive = False
        End If
        'Just to make sure GUI remains responsive
        Ftp2.DoEvents = True
        'To signal we want to resume
        Ftp2.Restart = True
        'Size of blocks between progress event is raised
        Ftp2.BlockSize = 8096

        If useSSL Then
            'Here are the 2 commands needed to run the client in SSL mode
            ' "Disable" security checks
            Ftp2.UseAuthentication = False
            ' Set the desired security/authentication to explicit. 
            Ftp2.Security = Dart.PowerTCP.SecureFtp.Security.Explicit
        End If

        remotePath = filePath + "/" + fileName
        remotePath = remotePath.Replace("//", "/")

        'Check if this filename is in the hotlist, if so, put it on top of the 
        'download list. Exact filenames can be specified on the hotlist, parts of 
        'the filename can be speciefied, or even picture-000-000 can be specified, 
        'which will then find all combinations of numbers.

        checkThisFileName = fileName.ToLower

        ItsAHotListFile = False
        counter = 0
        While counter < FTPHotList.Length
            getString = FTPHotList(counter).ToLower

            'First testing against the name as it is, this is an exact match
            If getString.Length > 0 Then
                If (checkThisFileName.IndexOf(getString) >= 0) Then
                    ItsAHotListFile = True
                    Exit While
                End If
            End If
            counter += 1
        End While

        'Then try to match the is the search-string is in the form of pict-000-000
        If Not ItsAHotListFile Then
            checkThisFileName = checkThisFileName.Replace("1", "0")
            checkThisFileName = checkThisFileName.Replace("2", "0")
            checkThisFileName = checkThisFileName.Replace("3", "0")
            checkThisFileName = checkThisFileName.Replace("4", "0")
            checkThisFileName = checkThisFileName.Replace("5", "0")
            checkThisFileName = checkThisFileName.Replace("6", "0")
            checkThisFileName = checkThisFileName.Replace("7", "0")
            checkThisFileName = checkThisFileName.Replace("8", "0")
            checkThisFileName = checkThisFileName.Replace("9", "0")
            counter = 0
            While counter < FTPHotList.Length
                getString = FTPHotList(counter).ToLower


                If getString.Length > 0 Then
                    If (checkThisFileName.IndexOf(getString) >= 0) Then
                        ItsAHotListFile = True
                        Exit While
                    End If
                End If
                counter += 1
            End While
        End If

        If ItsAHotListFile Then
            onlyDirectoryPath = SystemDownloadDirectory + "\" + _
                    "Pictures" + "\" + _
                    FTPServerName + "\" + _
                     "PRIORITY-DOWNLOAD"
        Else
            onlyDirectoryPath = SystemDownloadDirectory + "\" + _
                "Pictures" + "\" + _
                FTPServerName
        End If

        saveDirectory = filePath
        saveDirectory = saveDirectory.Replace("/", "\")
        saveDirectory = saveDirectory.Replace(":", "-drive")
        downloadlocaldirectory = onlyDirectoryPath + "\" + saveDirectory
        downloadlocaldirectory = downloadlocaldirectory.Replace("\\", "\")

        ANewDirectoryWasCreated = False
        If Not Directory.Exists(downloadlocaldirectory) Then
            Try
                Directory.CreateDirectory(downloadlocaldirectory)
                ANewDirectoryWasCreated = True
            Catch ex As Exception
                sbStatus.Panels(0).Text = "Can't create directory " + downloadlocaldirectory
                Exit Sub
            End Try
        End If
        downloadlocalpath = downloadlocaldirectory + "\" + fileName

        receivingFileName = fileName
        sizeToDownload = fileSize

        'Create the directory for output of lists concerning specific ftp site
        If Not Directory.Exists(onlyDirectoryPath) Then
            Directory.CreateDirectory(onlyDirectoryPath)
        End If

        OKToTryToDownload = True

        'Have to avoid files if path becomes too long, so keep
        'download directory name within reasonable limits
        pathLength = downloadlocalpath.Length
        If pathLength > 259 Then
            outputMessage = "The path name " + downloadlocalpath + _
            " is too long. It has to be less than 260 characters but was " + _
            pathLength.ToString + " characters long"
            myListViewItem = lvwUpdateLog.Items.Add(outputMessage)
            myListViewItem.ForeColor = Color.Red
            If ScrollList = True Then
                myListViewItem.EnsureVisible()
            End If

            lvwItem.SubItems(1).Text() = "Don't download"
            lvwItem.ForeColor = Color.Gray
            onQueueCount -= 1
            Exit Sub
        End If

        checkFileInfo = New FileInfo(downloadlocalpath)
        If File.Exists(downloadlocalpath) Then
            If fileSize > checkFileInfo.Length Then
                'Don't update listview if download wasnt complete
            Else
                lvwItem.SubItems(1).Text() = "Have file"
                lvwItem.ForeColor = Color.Red
                onQueueCount -= 1
                foundDuplicatesCount += 1
                OKToTryToDownload = False
            End If
        End If

        'Avoiding certain files.
        'This check has already been done once in Analyzelist but user might have changed
        '   settings in response to results
        If OKToTryToDownload Then
            counter = 0
            While counter < FTPAvoidFiles.Length
                getString = FTPAvoidFiles(counter).ToLower
                If getString.Length > 0 Then
                    FTPString = fileName.ToLower
                    If (FTPString.IndexOf(getString) >= 0) Then
                        OKToTryToDownload = False
                        lvwItem.SubItems(1).Text() = "Don't download"
                        lvwItem.ForeColor = Color.Gray
                        onQueueCount -= 1
                        Exit While
                    End If
                End If
                counter += 1
            End While
        End If

        If OKToTryToDownload Then

            DownloadOK = True
            sbStatus.Panels(0).Text = "Downloading " + fileName

            presentDownloadCount = downloadCount + 1
            tbxDownloading.Text = presentDownloadCount.ToString + "/" + onQueueCount.ToString

            Dim getFile As Dart.PowerTCP.SecureFtp.FtpFile
            Try
                getFile = Ftp2.Get(remotePath, downloadlocalpath)
            Catch ex As Exception
                exceptionType = "Exception"
                FTPException(exceptionType, ex)

                'If the file was moved, we are going to note it and continue downloading
                Dim exString As String
                exString = FTPLogString
                exString = exString.Replace(CarriageReturn, " ")
                exString = exString.Replace(LineFeed, " ")

                exString = exString.ToLower

                'Some errors will not lead to relogin attempts
                If (exString.IndexOf("no such file") >= 0) Or _
                    (exString.IndexOf("file not found") >= 0) Then
                    lvwUpdateLog.Items.Add("File " + remotePath + _
                    " was going to be downloaded but file can't be found")
                    lvwItem.SubItems(1).Text() = "File missing"
                    lvwItem.ForeColor = Color.Red
                    If ScrollList = True Then
                        myListViewItem.EnsureVisible()
                    End If
                    onQueueCount -= 1
                    Exit Sub
                End If

                If exString.IndexOf("no permission") >= 0 Then
                    lvwUpdateLog.Items.Add("File " + remotePath + _
                    " was going to be downloaded but no permission to download")
                    lvwItem.SubItems(1).Text() = "No permission"
                    lvwItem.ForeColor = Color.Red
                    If ScrollList = True Then
                        myListViewItem.EnsureVisible()
                    End If
                    onQueueCount -= 1
                    Exit Sub
                End If

                DownloadOK = False
                FTPLogString = ""
            End Try

            'If download fails, this Downloadjob will be terminated
            'and another thread starts which tries to login. If the
            'login succeeds, a new Downloadjob will be created.
            If Not DownloadOK Then
                'Cancel button might have been pressed
                If DownloadActive = True Then
                    sbStatus.Panels(0).Text = "Trying to login again"
                    Ftp2.AbortTransfer()
                    Ftp2Close()
                    SaveListViewToFile()
                    ReportSpecialError = True
                    CancelDownloadRequested = True
                    TryToLoginToFTP()
                    Exit Sub
                End If
            End If

            checkFileInfo = New FileInfo(downloadlocalpath)
            If File.Exists(downloadlocalpath) Then
                If fileSize > checkFileInfo.Length Then
                    'Don't update listview if download wasnt complete
                Else
                    MD5DuplicateDeleted = False
                    'Create MD5 of downloaded file and check if file exists in collection.
                    'If so delete it. 
                    'If it is a new file, insert the fileinfo in database
                    CheckIfMD5ExistsInDatabase()

                    If Not MD5DuplicateDeleted Then

                        lvwItem.SubItems(1).Text() = "File downloaded"
                        lvwItem.ForeColor = Color.ForestGreen
                        downloadCount += 1

                        DisplayPicture()

                        If htOptions.Item("sound") = "on" Then
                            If htOptions.ContainsKey("soundpicturedownloaded") Then
                                If htOptions.Item("soundpicturedownloaded") <> "" Then
                                    soundClip = htOptions.Item("soundpicturedownloaded")
                                    playSoundClip()
                                End If
                            End If
                        End If

                    End If

                End If

            Else
                outputMessage = "File " + downloadlocalpath + " cant be found."
                myListViewItem = lvwUpdateLog.Items.Add(outputMessage)
                If ScrollList = True Then
                    myListViewItem.EnsureVisible()
                End If
                myListViewItem.ForeColor = Color.Red

            End If

        End If

        If foundDuplicatesCount > 0 Then
            tbxFoundDuplicates.Text = foundDuplicatesCount.ToString
        Else
            tbxFoundDuplicates.Text = ""
        End If

        spbTotal.Value = presentDownloadCount
        spbTotal.Maximum = onQueueCount
        spbTotal.Update()

    End Sub


    Private Sub DisplayPicture()

        Dim myImage As Image

        'Weirdorama - seems at program start the Viewer1 wont stretch picture
        'properly so we send a second call and it works fine. That's why code
        'looks funny.
        Try
            myImage = Image.FromFile(downloadlocalpath)
            Try
                Viewer1.Image = myImage
                Viewer1.ImageSizeMode = SizeMode.RatioStretch
            Catch ex As Exception
                Try
                    Viewer1.Image = myImage
                    Viewer1.ImageSizeMode = SizeMode.RatioStretch
                Catch ex2 As Exception
                    outputMessage = "Failed to display picture. Exception message :" + ex2.Message
                    myListViewItem = lvwUpdateLog.Items.Add(outputMessage)
                    If ScrollList = True Then
                        myListViewItem.EnsureVisible()
                    End If
                End Try
            End Try


        Catch ex As Exception
            outputMessage = "Failed to create picture. Exception message :" + ex.Message
            myListViewItem = lvwUpdateLog.Items.Add(outputMessage)
            If ScrollList = True Then
                myListViewItem.EnsureVisible()
            End If
        End Try

    End Sub


    Private Sub CheckIfMD5ExistsInDatabase()

        Dim myReader As MySqlDataReader
        Dim result As Integer
        Dim DownloadWasADuplicate As Boolean

        Dim MySQL_Filename As String
        Dim MySQL_Filesize As Long
        Dim MySQL_Filepath As String
        Dim save_Filename As String
        Dim save_Filepath As String
        Dim save_Filesize As Long
        Dim localFullPath As String

        DownloadWasADuplicate = False

        Dim fsInput As New FileStream(downloadlocalpath, FileMode.Open, FileAccess.Read)
        If fsInput.Length > lengthToCheck Then
            ReDim bytearrayinput(lengthToCheck)
        Else
            ReDim bytearrayinput(fsInput.Length - 1)
        End If
        fsInput.Read(bytearrayinput, 0, bytearrayinput.Length)
        fsInput.Close()
        MD5hash = MD5.ComputeHash(bytearrayinput)
        MD5hashstring = Convert.ToBase64String(MD5hash)
        MD5hashstring = MD5hashstring.Replace("w"c, "V"c)
        MD5hashstring = MD5hashstring.Replace("W"c, "V"c)

        If myConnection Is Nothing Then
            OpenConnectionToDatabase()
        End If

        Try
            mySQLCommandString = "SELECT * FROM " + collectionTablename + _
            " WHERE fileMD5='" + MD5hashstring + "';"

            myCommand = New MySqlCommand(mySQLCommandString)
            myCommand.Connection = myConnection

            save_Filesize = 0

            myReader = myCommand.ExecuteReader()
            While myReader.Read()

                DownloadWasADuplicate = True

                MySQL_Filename = myReader.GetString(0)
                MySQL_Filesize = myReader.GetInt64(1)
                MySQL_Filepath = myReader.GetString(2)

                If MySQL_Filesize > save_Filesize Then
                    save_Filename = MySQL_Filename
                    save_Filesize = MySQL_Filesize
                    save_Filepath = MySQL_Filepath
                End If

            End While

            myReader.Close()

            'MD5 exists in database, so we don't save this download
            If DownloadWasADuplicate = True Then

                'provided that the downloaded file is not bigger than already
                'downloaded files
                'If a corrupt pic of 300K is downloaded, we want the complete
                '600K picture to be saved
                If checkFileInfo.Length <= save_Filesize Then

                    Try
                        File.Delete(downloadlocalpath)
                        sbStatus.Panels(0).Text = downloadlocalpath + _
                            " downloaded but was found to be a duplicate. Deleted"
                        lvwItem.SubItems(1).Text() = "Have file"
                        lvwItem.ForeColor = Color.Red
                        MD5DuplicateDeleted = True
                        foundDuplicatesCount += 1
                        onQueueCount -= 1

                        'The duplicate's path is shown
                        localFullPath = save_Filepath + "\" + save_Filename
                        lvwItem.SubItems(4).Text() = localFullPath

                        'If a directory was created for this file, it must be empty after
                        'delete of the file, in that case, remove the directory so we don't end
                        'up with any empty directories
                        If ANewDirectoryWasCreated = True Then
                            Try
                                Directory.Delete(downloadlocaldirectory)
                            Catch ex As Exception
                                sbStatus.Panels(0).Text = "Can't delete directory " + downloadlocaldirectory
                            End Try
                        End If

                    Catch ex As Exception
                    End Try
                Else
                    'This test is only interesting for pictures that are over the limit, currently
                    '250.000 bytes

                    DownloadWasADuplicate = False

                    outputMessage = "Same checksum but downloaded file is bigger : " + checkFileInfo.Name
                    myListViewItem = lvwUpdateLog.Items.Add(outputMessage)
                    myListViewItem.ForeColor = Color.Red
                    If ScrollList = True Then
                        myListViewItem.EnsureVisible()
                    End If

                End If
            End If

            'Downloaded file info is inserted into database
            'If MD5 existed, means that file was a rename, save that info also to avoid 
            '   further downloads of that duplicate
            save_Filepath = checkFileInfo.DirectoryName.Replace("\", "\\")

            searchFilename = checkFileInfo.Name.Replace("'", "\'")


            'Dont save path info for duplicates
            If DownloadWasADuplicate = True Then
                mySQLCommandString = "INSERT INTO " + collectionTablename + _
                " SET filename='" + searchFilename + "'," + _
                " filesize = '" + checkFileInfo.Length.ToString + "'," + _
                " filepath = ''," + _
                " filetime = ''," + _
                " fileMD5 = '" + MD5hashstring + "';"
            Else

                mySQLCommandString = "INSERT INTO " + collectionTablename + _
                " SET filename='" + searchFilename + "'," + _
                " filesize = '" + checkFileInfo.Length.ToString + "'," + _
                " filepath = '" + save_Filepath + "'," + _
                " filetime = '" + checkFileInfo.LastWriteTime.Ticks.ToString() + "'," + _
                " fileMD5 = '" + MD5hashstring + "';"
            End If

            myCommand.CommandText = mySQLCommandString

            result = myCommand.ExecuteNonQuery()

            If result < 1 Then
                outputMessage = "Insert into database failed of " + checkFileInfo.Name
                'lvwMovieLog.Items.Add(outputMessage)
                myListViewItem = lvwUpdateLog.Items.Add(outputMessage)
                'myListViewItem.EnsureVisible()
                myListViewItem.ForeColor = Color.Red
                If ScrollList = True Then
                    myListViewItem.EnsureVisible()
                End If

            End If

        Catch ex As MySqlException
            exceptionType = "MySqlException"
            FTPException(exceptionType, ex)

            'outputMessage = "MySQLException :" + ex.Message
            'lvwMovieLog.Items.Add(outputMessage)
            'myListViewItem = lvwUpdateLog.Items.Add(outputMessage)
            'myListViewItem.EnsureVisible()
            'myListViewItem.ForeColor = Color.Red

            outputMessage = "CommandString :" + mySQLCommandString
            myListViewItem = lvwUpdateLog.Items.Add(outputMessage)
            myListViewItem.ForeColor = Color.Red
            If ScrollList = True Then
                myListViewItem.EnsureVisible()
            End If

        Catch ex As System.Net.Sockets.SocketException

            exceptionType = "System.Net.Sockets.SocketException"
            FTPException(exceptionType, ex)

            'outputMessage = "SocketException :" + ex.Message
            'lvwMovieLog.Items.Add(outputMessage)
            'myListViewItem = lvwUpdateLog.Items.Add(outputMessage)
            'myListViewItem.EnsureVisible()
            'myListViewItem.ForeColor = Color.Red

            outputMessage = "CommandString :" + mySQLCommandString
            myListViewItem = lvwUpdateLog.Items.Add(outputMessage)
            myListViewItem.ForeColor = Color.Red
            If ScrollList = True Then
                myListViewItem.EnsureVisible()
            End If

        Catch ex As Exception

            exceptionType = "Exception"
            FTPException(exceptionType, ex)

            'Syntax errors
            'outputMessage = "Exception :" + ex.Message
            'lvwMovieLog.Items.Add(outputMessage)
            'myListViewItem = lvwUpdateLog.Items.Add(outputMessage)
            'myListViewItem.EnsureVisible()
            'myListViewItem.ForeColor = Color.Red

            outputMessage = "CommandString :" + mySQLCommandString
            myListViewItem = lvwUpdateLog.Items.Add(outputMessage)
            myListViewItem.ForeColor = Color.Red
            If ScrollList = True Then
                myListViewItem.EnsureVisible()
            End If

        End Try

    End Sub


    Public Sub SaveListViewToFile()

        Dim picturesToDownloadCount As Integer
        picturesToDownloadCount = 0

        If lvwStatus.Items.Count > 0 Then

            Dim HandleOK As Boolean = True

            Try
                DownloadPicturesListStreamWriter = New StreamWriter(listDirectory + "\" + "DownloadPicturesList.txt")
            Catch ex As Exception
                HandleOK = False
                lvwUpdateLog.Items.Add("Couldnt open DownloadPicturesList.txt for save." + ex.ToString)
            End Try

            If HandleOK Then
                For Each lvwItem In lvwStatus.Items

                    If lvwItem.SubItems(1).Text = "On queue" Then
                        picturesToDownloadCount += 1
                    End If

                    DownloadPicturesListRecord = lvwItem.SubItems(0).Text + FieldDelimiter + _
                    lvwItem.SubItems(1).Text + FieldDelimiter + _
                    lvwItem.SubItems(2).Text + FieldDelimiter + _
                    lvwItem.SubItems(3).Text + FieldDelimiter + _
                    lvwItem.SubItems(4).Text
                    DownloadPicturesListStreamWriter.WriteLine(DownloadPicturesListRecord)
                Next
                DownloadPicturesListStreamWriter.Close()
            End If

        End If

        lvwUpdateLog.Items.Add("DownloadPicturesList.txt saved")

        If picturesToDownloadCount = 0 Then
            parentRef.btnDownloadPictures.Text = "Download pictures"
        Else
            parentRef.btnDownloadPictures.Text = "Download " + _
            picturesToDownloadCount.ToString + " pictures"
        End If

    End Sub


    Public Sub LoadDownloadListInListView()
        'Load list in listview

        GetFTPFilesEvaluatedCount()
        If FTPFilesEvaluatedCount > 0 Then
            tbxFTPListTotalCount.Text = FTPFilesEvaluatedCount.ToString
        Else
            tbxFTPListTotalCount.Text = ""
        End If

        sbStatus.Panels(0).Text = "Reading filelist"

        Dim onQCounter As Integer
        onQCounter = 0

        numberOfFilesInListview = 0

        ReDim arrFilePath(-1)
        ReDim arrRecord(-1)

        lvwStatus.Items.Clear()

        DownloadPicturesListStreamReader = New StreamReader(listDirectory + "\" + "DownloadPicturesList.txt")

        MoreRecordsToRead = True

        GetNextDownloadPicturesListRecord()
        Do While (MoreRecordsToRead)

            'Extract file path and file name which will be used as sorting keys
            fieldSplit = DownloadPicturesListRecord.Split(FieldDelimiter)

            'Empty lines at end of list
            If fieldSplit.Length = 1 Then
                Exit Do
            End If

            filePath = fieldSplit(3)
            fileName = fieldSplit(2)

            If fieldSplit(1) = "On queue" Then
                onQCounter += 1
            End If

            ReDim Preserve arrFilePath(numberOfFilesInListview)
            arrFilePath(numberOfFilesInListview) = filePath + fileName

            ReDim Preserve arrRecord(numberOfFilesInListview)
            arrRecord(numberOfFilesInListview) = DownloadPicturesListRecord

            numberOfFilesInListview += 1
            GetNextDownloadPicturesListRecord()
        Loop

        DownloadPicturesListStreamReader.Close()

        If onQCounter > 0 Then
            tbxDownloading.Text = onQCounter.ToString
        Else
            tbxDownloading.Text = ""
        End If


        'Only sort when list is new, then we might want to rearrange lines
        If FirstTimeSortOfList = True Then
            Array.Sort(arrFilePath, arrRecord)
        End If

        MoveArrayToListview()

    End Sub


    Private Sub MoveArrayToListview()

        onQueueCount = 0
        foundDuplicatesCount = 0

        sbStatus.Panels(0).Text = "Building display"

        'Flicker free, especially when coming here after analyzeftplist which is
        'done in a separate thread now, when doing just a load of the the listview
        'it doesnt flicker that much
        lvwStatus.Visible = False

        For Each DownloadPicturesListRecord In arrRecord
            fieldSplit = DownloadPicturesListRecord.Split(FieldDelimiter)
            Try
                fileSize = CLng(fieldSplit(0))
            Catch ex As Exception
            End Try
            fileStatus = fieldSplit(1)
            fileName = fieldSplit(2)
            filePath = fieldSplit(3)
            duplicateFilePath = fieldSplit(4)

            If fieldSplit(1) = "On queue" Then
                onQueueCount += 1
            End If

            cstring = Format(CLng(fileSize), "###,###,###,###,###")
            lvwDuplicateItem = lvwStatus.Items.Add(cstring)
            lvwDuplicateItem.SubItems.Add(fileStatus)
            lvwDuplicateItem.SubItems.Add(fileName)
            lvwDuplicateItem.SubItems.Add(filePath)
            lvwDuplicateItem.SubItems.Add(duplicateFilePath)
            lvwDuplicateItem.SubItems.Add("")

            If fieldSplit(1) = "File downloaded" Then
                lvwDuplicateItem.ForeColor = Color.ForestGreen
            Else
                If fieldSplit(1) = "Have file" Then
                    lvwDuplicateItem.ForeColor = Color.Red
                    foundDuplicatesCount += 1
                Else
                    If fieldSplit(1) = "Don't download" Then
                        lvwDuplicateItem.ForeColor = Color.Gray
                    Else
                        If fieldSplit(1) = "File missing" Then
                            lvwDuplicateItem.ForeColor = Color.Red
                        Else
                            If fieldSplit(1) = "No permission" Then
                                lvwDuplicateItem.ForeColor = Color.Red
                            End If
                        End If
                    End If
                End If
            End If


            'Only put the priority downloads on top of the list if it is the first time
            '   if this is an old list, they are already there
            If FirstTimeSortOfList = True Then

                'Check if this filename is in the hotlist, if so, put it on top of the 
                'download list. Exact filenames can be specified on the hotlist, parts of 
                'the filename can be speciefied, or even picture-000-000 can be specified, 
                'which will then find all combinations of numbers.

                checkThisFileName = fileName.ToLower

                ItsAHotListFile = False
                counter = 0
                While counter < FTPHotList.Length
                    getString = FTPHotList(counter).ToLower

                    'First testing against the name as it is, this is an exact match
                    If getString.Length > 0 Then
                        If (checkThisFileName.IndexOf(getString) >= 0) Then
                            ItsAHotListFile = True
                            Exit While
                        End If
                    End If
                    counter += 1
                End While

                'Then try to match the is the search-string is in the form of pict-000-000
                If Not ItsAHotListFile Then
                    checkThisFileName = checkThisFileName.Replace("1", "0")
                    checkThisFileName = checkThisFileName.Replace("2", "0")
                    checkThisFileName = checkThisFileName.Replace("3", "0")
                    checkThisFileName = checkThisFileName.Replace("4", "0")
                    checkThisFileName = checkThisFileName.Replace("5", "0")
                    checkThisFileName = checkThisFileName.Replace("6", "0")
                    checkThisFileName = checkThisFileName.Replace("7", "0")
                    checkThisFileName = checkThisFileName.Replace("8", "0")
                    checkThisFileName = checkThisFileName.Replace("9", "0")
                    counter = 0
                    While counter < FTPHotList.Length
                        getString = FTPHotList(counter).ToLower


                        If getString.Length > 0 Then
                            If (checkThisFileName.IndexOf(getString) >= 0) Then
                                ItsAHotListFile = True
                                Exit While
                            End If
                        End If
                        counter += 1
                    End While
                End If

                If ItsAHotListFile Then
                    removeIndex = lvwDuplicateItem.Index
                    lvwDuplicateItem = lvwStatus.Items(removeIndex).Clone
                    lvwStatus.Items(removeIndex).Remove()
                    lvwStatus.Items.Insert(0, lvwDuplicateItem)
                End If

            End If

        Next

        sbStatus.Panels(0).Text = ""

        lvwStatus.Visible = True

    End Sub


    Private Sub GetOnQueuecount()
        'Counting how many files are going to be download
        onQueueCount = 0
        Dim lvwEnumerator As IEnumerator = lvwStatus.Items.GetEnumerator
        While lvwEnumerator.MoveNext()
            lvwItem = lvwEnumerator.Current
            fileStatus = lvwItem.SubItems(1).Text
            If lvwItem.SubItems(1).Text = "On queue" Then
                onQueueCount += 1
            End If
        End While
    End Sub


    Private Sub InitializeExtendedStatusBar()

        'TODO Problems to insert and position extra panels, can it be fixed?

        Dim sbText = New System.Windows.Forms.StatusBarPanel
        Dim sbProgress = New System.Windows.Forms.StatusBarPanel

        sbText.AutoSize = _
           System.Windows.Forms.StatusBarPanelAutoSize.Spring
        sbProgress.Width = 200

        With sbStatus
            .Panels.Add(sbText)
            .Panels.Add(sbProgress)

            .ShowPanels = True

            'Initial settings for custom progressbar
            .setProgressBar = 1
            .progressBar.Minimum = 0
            .progressBar.Value = 0

            'Give a stylish look to this control which we don't use
            '.progressBar.BackColorStyle = SPB.SmoothProgressBar.ColorStyle.Gradient
            '.progressBar.BackGradientMode = Drawing2D.LinearGradientMode.Vertical
            '.progressBar.BackSigmaMode = SPB.SmoothProgressBar.SigmaMode.SigmaBell
            '.progressBar.BarColorStyle = SPB.SmoothProgressBar.ColorStyle.Gradient
            '.progressBar.BarGradientMode = Drawing2D.LinearGradientMode.Vertical
            '.progressBar.BarSigmaMode = SPB.SmoothProgressBar.SigmaMode.SigmaBell

            .progressBar.TabStop = False
            .progressBar.BorderStyle = BorderStyle.None

        End With

        Me.Controls.Add(sbStatus)

    End Sub


    Private Sub btnClearAllLists_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnClearAllLists.Click

        Dim msg As String
        Dim title As String
        Dim response As String
        Dim style As MsgBoxStyle

        title = "Confirm delete of download list"
        msg = "Are you sure you want to delete the download list?"
        style = MsgBoxStyle.OkCancel
        response = MsgBox(msg, style, title)
        If (response = MsgBoxResult.Ok) Then

            lvwStatus.Items.Clear()
            tbxDownloading.Text = ""
            tbxFoundDuplicates.Text = ""
            tbxFTPListTotalCount.Text = ""
            spbTotal.Value = 0
            spbTotal.Update()

            If SystemDownloadDirectory <> "" And FTPServerName <> "" Then

                If Directory.Exists(listDirectory) Then
                    If File.Exists(listDirectory + "\" + "FTPPicturesList.txt") Then
                        Try
                            File.Delete(listDirectory + "\" + "FTPPicturesList.txt")
                        Catch ex As Exception
                        End Try
                    End If

                    If File.Exists(listDirectory + "\" + "DownloadPicturesList.txt") Then
                        Try
                            File.Delete(listDirectory + "\" + "DownloadPicturesList.txt")
                        Catch ex As Exception
                        End Try
                    End If
                End If


            End If
        End If

        btnDownload.Enabled = True
        btnClearAllLists.Enabled = False
        btnAnalyzeAgain.Enabled = False
        btnSearchFTPAgain.Enabled = False

        onQueueCount = 0

        sbStatus.Panels(0).Text = ""

    End Sub


    Private Sub Ftp2_Progress(ByVal sender As Object, ByVal e As Dart.PowerTCP.SecureFtp.FtpProgressEventArgs) Handles Ftp2.Progress

        sbStatus.progressBar.Minimum = 0
        sbStatus.progressBar.Value = e.Position
        sbStatus.progressBar.Maximum = e.Length
        sbStatus.progressBar.Update()

    End Sub


    Private Sub Ftp2_Trace(ByVal sender As Object, ByVal e As Dart.PowerTCP.SecureFtp.SegmentEventArgs) Handles Ftp2.Trace
        'Dump command conversation with FTP to window
        FTPLogString = e.Segment.ToString
        Dim CRLFposition As Integer
        'Look for a CarriageReturn character and remove it and the linefeed following
        'Items.Add will take care of line breaks by itself
        CRLFposition = FTPLogString.IndexOf(CarriageReturn)
        If CRLFposition >= 0 Then
            FTPLogString = FTPLogString.Substring(0, CRLFposition)
        End If

        myListViewItem = lvwUpdateLog.Items.Add(FTPLogString)
        If ScrollList = True Then
            myListViewItem.EnsureVisible()
        End If

        'Guarding against empty strings
        Try
            If IsNumeric(FTPLogString.Substring(0, 3)) Then
                If FTPLogString.Substring(0, 1) = "5" Then
                    myListViewItem.ForeColor = Color.Red
                Else
                    myListViewItem.ForeColor = Color.Green
                End If
            Else
                myListViewItem.ForeColor = Color.Blue
            End If
        Catch ex As Exception

        End Try

    End Sub


    Private Sub Ftp2_ConnectedChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles Ftp2.ConnectedChanged

        outputMessage = e.ToString()
        myListViewItem = lvwUpdateLog.Items.Add(outputMessage)
        myListViewItem.ForeColor = Color.Green
        If ScrollList = True Then
            myListViewItem.EnsureVisible()
        End If

    End Sub


    Private Sub Ftp2Close()

        If Ftp2.Connected Then

            ' Close method returns an Invoke object
            Dim FTPSecureinvoke As Dart.PowerTCP.SecureFtp.Invoke

            Try
                FTPSecureinvoke = Ftp2.Close()
            Catch ex As Exception
                exceptionType = "Exception"
                FTPException(exceptionType, ex)
            End Try

            If Ftp2.Connected Then
                ' For some reason the Close method did not work. Just perform a harsh abort
                Ftp2.Dispose()
                outputMessage = "Unable to QUIT, connection aborted"
                myListViewItem = lvwUpdateLog.Items.Add(outputMessage)
                myListViewItem.ForeColor = Color.Red
                If ScrollList = True Then
                    myListViewItem.EnsureVisible()
                End If
            Else
                outputMessage = "Close successful."
                myListViewItem = lvwUpdateLog.Items.Add(outputMessage)
                myListViewItem.ForeColor = Color.Green
                If ScrollList = True Then
                    myListViewItem.EnsureVisible()
                End If

                'outputMessage = FTPSecureinvoke.Response.Code.ToString()
                'lvwMovieLog.Items.Add("Response Code From Server: " + outputMessage)
                'myListViewItem = lvwUpdateLog.Items.Add(outputMessage)
                'myListViewItem.EnsureVisible()
                'myListViewItem.ForeColor = Color.Green

                'outputMessage = FTPSecureinvoke.Response.Text.ToString
                'lvwMovieLog.Items.Add("Response Text From Server: " + FTPSecureinvoke.Response.Text.ToString)
                'myListViewItem = lvwUpdateLog.Items.Add(outputMessage)
                'myListViewItem.EnsureVisible()
                'myListViewItem.ForeColor = Color.Green
            End If
        Else
            outputMessage = "No need to close connection. It is not active."
            myListViewItem = lvwUpdateLog.Items.Add(outputMessage)
            myListViewItem.ForeColor = Color.Green
            If ScrollList = True Then
                myListViewItem.EnsureVisible()
            End If

        End If

    End Sub


    Private Sub playSoundClip()
        If Not (modPlaySound.LoadMP3((soundClip)) = True) Then
            'parentRef.lbxResponse.Items.Add("Can't load  soundclip " + soundClip)
        Else
            If Not (modPlaySound.PlayMP3() = True) Then
                'parentRef.lbxResponse.Items.Add("Can't play  soundclip " + soundClip)
            End If
        End If
    End Sub


    Private Sub GetNextFTPListRecord()
        If (FTPListStreamReader.Peek() >= 0) Then
            FTPListRecord = FTPListStreamReader.ReadLine
        Else
            MoreRecordsToRead = False
        End If
    End Sub


    Private Sub GetNextWCFListRecord()
        If (WCFListStreamReader.Peek() >= 0) Then
            WCFListRecord = WCFListStreamReader.ReadLine
        Else
            MoreToReadFromWCF = False
        End If
    End Sub


    Private Sub GetNextDownloadPicturesListRecord()
        If (DownloadPicturesListStreamReader.Peek() >= 0) Then
            DownloadPicturesListRecord = DownloadPicturesListStreamReader.ReadLine
        Else
            MoreRecordsToRead = False
        End If
    End Sub


    Public Sub TryToLoginToFTP()

        Dim loginThread As New Thread(New ThreadStart(AddressOf LoginLoop))
        loginThread.Start()
        Exit Sub

    End Sub


    Public Sub LoginLoop()

        Dim e As LoginEventArgs
        Dim excounter As Integer = 0
        Dim loginCount As Integer = 1

        Ftp2.Server = FTPServer
        Ftp2.Username = FTPUsername
        Ftp2.Password = FTPPassword
        Ftp2.ServerPort = FTPServerPort
        If FTPPassive Then
            Ftp2.Passive = True
        Else
            Ftp2.Passive = False
        End If
        Ftp2.DoEvents = True

        If useSSL Then
            'Here are the 2 commands needed to run the client in SSL mode
            ' "Disable" security checks
            Ftp2.UseAuthentication = False
            ' Set the desired security/authentication to explicit. 
            Ftp2.Security = Dart.PowerTCP.SecureFtp.Security.Explicit
        End If

        Dim partnerRetries As Integer
        partnerRetries = htOptions.Item("partnerretries")

        Dim partnerInterval As Integer
        partnerInterval = htOptions.Item("partnerinterval")

        counter = 0
        While counter < partnerRetries

            If CancelLoginRequested Then
                btnDownload.Text = "Start download"
                btnDownload.Enabled = True
                btnAnalyzeAgain.Enabled = True
                btnSearchFTPAgain.Enabled = True
                btnClearAllLists.Enabled = True
                sbStatus.Panels(0).Text = "Login attempts stopped"
                Exit Sub
            End If

            sbStatus.Panels(0).Text = "Attempt " + loginCount.ToString + _
                " to login to FTP"

            outputMessage = "Attempt " + loginCount.ToString + _
                " to login to " + FTPServer
            myListViewItem = lvwUpdateLog.Items.Add(outputMessage)
            myListViewItem.ForeColor = Color.Green
            If ScrollList = True Then
                myListViewItem.EnsureVisible()
            End If

            FTPLoginOK = True
            Try
                ' Send NoOp to force a logon 
                Ftp2.Invoke(Dart.PowerTCP.SecureFtp.FtpCommand.NoOp)
            Catch ex As System.Net.ProtocolViolationException
                FTPLoginOK = False
                exceptionType = "System.Net.ProtocolViolationException"
                FTPException(exceptionType, ex)
            Catch ex As System.Net.Sockets.SocketException
                FTPLoginOK = False
                exceptionType = "System.Net.Sockets.SocketException"
                FTPException(exceptionType, ex)
            Catch ex As Exception
                FTPLoginOK = False
                exceptionType = "Exception"
                FTPException(exceptionType, ex)
            End Try

            If FTPLoginOK Then
                'Success before time was up so we exit and boolean is correct
                e = New LoginEventArgs(True)
                RaiseEvent LoginEvent(Me, e)
                Exit Sub
            Else

                sbStatus.Panels(0).Text = "Attempt " + loginCount.ToString + _
                    " to login to FTP failed"

                outputMessage = "Attempt " + loginCount.ToString + _
                    " to login to " + FTPServer + " failed"
                myListViewItem = lvwUpdateLog.Items.Add(outputMessage)
                myListViewItem.ForeColor = Color.Red
                If ScrollList = True Then
                    myListViewItem.EnsureVisible()
                End If

                Thread.Sleep(partnerInterval * 1000)
            End If

            counter += 1
            loginCount += 1
        End While

        'Failed to login 
        e = New LoginEventArgs(False)
        RaiseEvent LoginEvent(Me, e)

        'Retrying to login to FTP didn't work
        'If ban requested, the other side is banned from own ftp
        If htOptions.ContainsKey("ftpban") Then
            If htOptions.Item("ftpban") = "yes" Then
                outputMessage = "Give user the bums rush"
                myListViewItem = lvwUpdateLog.Items.Add(outputMessage)
                myListViewItem.ForeColor = Color.Red
                If ScrollList = True Then
                    myListViewItem.EnsureVisible()
                End If
                giveUserTheBumsRush()
                sbStatus.Panels(0).Text = "Failed to login. Disabled user account " + _
                    FTPServerName
            End If
        End If

    End Sub


    Public Sub giveUserTheBumsRush()
        'Setup FTP server with events onEvery5minutes and onFileDownloaded
        'to reset the user.ini file with command "server.exe -reload"
        'This will have the effect to kick a user whose FTP stopped working

        Dim FTPuserfile As String
        Dim FTPuserfileOut As String
        Dim searchUserString As String
        Dim RecordChanged As Boolean

        RecordChanged = False

        Select Case serverType
            Case "BPFTP"
                FTPuserfile = htOptions.Item("ftpdirectory") + "\Users.ini"
                FTPuserfileOut = htOptions.Item("ftpdirectory") + "\Users-new.ini"
                searchUserString = "[" + FTPServerName + "]"
            Case "Gene6"
                FTPuserfile = htOptions.Item("ftpdirectory") + "\" + _
                    FTPServerName + ".ini"
                FTPuserfileOut = htOptions.Item("ftpdirectory") + "\" + _
                    FTPServerName + "-new.ini"
                searchUserString = "Enabled=-1"
            Case Else
                'Default is BPFTP
                FTPuserfile = htOptions.Item("ftpdirectory") + "\Users.ini"
                FTPuserfileOut = htOptions.Item("ftpdirectory") + "\Users-new.ini"
                searchUserString = "[" + FTPServerName + "]"
        End Select

        FTPStreamReader = New StreamReader(FTPuserfile)
        FTPStreamWriter = New StreamWriter(FTPuserfileOut)

        MoreRecordsToRead = True

        GetNextFTPRecord()
        Do While (MoreRecordsToRead)

            Select Case serverType
                Case "BPFTP"
                    'Adding one line
                    FTPStreamWriter.WriteLine(FTPRecord)
                    FTPStreamWriter.Flush()
                    If (FTPRecord.IndexOf(searchUserString) >= 0) Then
                        FTPStreamWriter.WriteLine("Enabled=0")
                    End If
                Case "Gene6"
                    If RecordChanged Then
                        FTPStreamWriter.WriteLine(FTPRecord)
                        FTPStreamWriter.Flush()
                    Else
                        'Replacing line
                        If (FTPRecord.IndexOf(searchUserString) >= 0) Then
                            FTPStreamWriter.WriteLine("Enabled=0")
                            RecordChanged = True
                        Else
                            FTPStreamWriter.WriteLine(FTPRecord)
                            FTPStreamWriter.Flush()
                        End If
                    End If
                Case Else
                    'Default is BPFTP
                    'Adding one line
                    FTPStreamWriter.WriteLine(FTPRecord)
                    FTPStreamWriter.Flush()
                    If (FTPRecord.IndexOf(searchUserString) >= 0) Then
                        FTPStreamWriter.WriteLine("Enabled=0")
                    End If
            End Select

            GetNextFTPRecord()
        Loop

        FTPStreamReader.Close()
        FTPStreamWriter.Close()

        Try
            File.Copy(FTPuserfileOut, FTPuserfile, True)
        Catch ex As Exception
            outputMessage = "Failed to overwrite " + FTPuserfile + " with changes"
            myListViewItem = lvwUpdateLog.Items.Add(outputMessage)
            myListViewItem.ForeColor = Color.Red
            If ScrollList = True Then
                myListViewItem.EnsureVisible()
            End If

            outputMessage = "Error : " + ex.ToString
            myListViewItem = lvwUpdateLog.Items.Add(outputMessage)
            myListViewItem.ForeColor = Color.Red
            If ScrollList = True Then
                myListViewItem.EnsureVisible()
            End If
            Exit Sub
        End Try

        If serverType = "Gene6" Then
            Try
                File.Delete(FTPuserfileOut)
            Catch ex As Exception
                outputMessage = "Failed to delete " + FTPuserfileOut
                myListViewItem = lvwUpdateLog.Items.Add(outputMessage)
                myListViewItem.ForeColor = Color.Red
                If ScrollList = True Then
                    myListViewItem.EnsureVisible()
                End If
                Exit Sub
            End Try
        End If

    End Sub


    Private Sub GetNextFTPRecord()
        If (FTPStreamReader.Peek() >= 0) Then
            FTPRecord = FTPStreamReader.ReadLine
        Else
            MoreRecordsToRead = False
        End If
    End Sub


    Class LoginEventArgs
        Inherits EventArgs
        Private boolean_LoginSucceeded As Boolean
        Public Sub New(ByVal LoginSucceeded As Boolean)
            boolean_LoginSucceeded = LoginSucceeded
        End Sub

        Public ReadOnly Property LoginSucceeded() As Boolean
            Get
                Return boolean_LoginSucceeded
            End Get
        End Property
    End Class


    Public Sub OnLoginEvent(ByVal sender As Object, ByVal e As LoginEventArgs)
        sbStatus.Panels(0).Text = "Automatic login succeeded :" + e.LoginSucceeded.ToString

        If e.LoginSucceeded Then
            DownloadActive = True
            CancelDownloadRequested = False

            btnDownload.Text = "Stop download"
            btnDownload.Enabled = True
            btnAnalyzeAgain.Enabled = False
            btnSearchFTPAgain.Enabled = False
            btnClearAllLists.Enabled = False

            StartDownloadJob()
        End If

    End Sub


    Private Sub OpenConnectionToDatabase()

        Try
            If Not myConnection Is Nothing Then
                myConnection.Close()
                myConnection.Dispose()
            End If

            outputMessage = "ConnectionString : " + myConnectionString
            myListViewItem = lvwUpdateLog.Items.Add(outputMessage)
            myListViewItem.ForeColor = Color.Blue
            If ScrollList = True Then
                myListViewItem.EnsureVisible()
            End If

            myConnection = New MySqlConnection(myConnectionString)

            myConnection.Open()

            outputMessage = "Database opened"
            myListViewItem = lvwUpdateLog.Items.Add(outputMessage)
            myListViewItem.ForeColor = Color.Green
            If ScrollList = True Then
                myListViewItem.EnsureVisible()
            End If

            outputMessage = "Data Source      : " + myConnection.DataSource
            myListViewItem = lvwUpdateLog.Items.Add(outputMessage)
            myListViewItem.ForeColor = Color.Green
            If ScrollList = True Then
                myListViewItem.EnsureVisible()
            End If

            outputMessage = "Server Version   : " + myConnection.ServerVersion
            myListViewItem = lvwUpdateLog.Items.Add(outputMessage)
            myListViewItem.ForeColor = Color.Green
            If ScrollList = True Then
                myListViewItem.EnsureVisible()
            End If

            outputMessage = "Current Database : " + myConnection.Database
            myListViewItem = lvwUpdateLog.Items.Add(outputMessage)
            myListViewItem.ForeColor = Color.Green
            If ScrollList = True Then
                myListViewItem.EnsureVisible()
            End If

            outputMessage = "State            : " + myConnection.State.ToString
            myListViewItem = lvwUpdateLog.Items.Add(outputMessage)
            myListViewItem.ForeColor = Color.Green
            If ScrollList = True Then
                myListViewItem.EnsureVisible()
            End If

        Catch ex As MySqlException
            outputMessage = "MySqlException. Message : " + ex.Message
            myListViewItem = lvwUpdateLog.Items.Add(outputMessage)
            myListViewItem.ForeColor = Color.Red
            If ScrollList = True Then
                myListViewItem.EnsureVisible()
            End If
        Catch ex As System.Net.Sockets.SocketException
            outputMessage = "SocketException. Message : " + ex.Message
            myListViewItem = lvwUpdateLog.Items.Add(outputMessage)
            myListViewItem.ForeColor = Color.Red
            If ScrollList = True Then
                myListViewItem.EnsureVisible()
            End If
        Catch ex As Exception
            outputMessage = "Exception. Message : " + ex.Message
            myListViewItem = lvwUpdateLog.Items.Add(outputMessage)
            myListViewItem.ForeColor = Color.Red
            If ScrollList = True Then
                myListViewItem.EnsureVisible()
            End If
        End Try

    End Sub


    Private Sub CloseConnectionToDatabase()

        Try
            If Not myConnection Is Nothing Then
                myConnection.Close()
                myConnection.Dispose()
                myConnection = Nothing

                outputMessage = "Connection to MySQL server closed"
                myListViewItem = lvwUpdateLog.Items.Add(outputMessage)
                myListViewItem.ForeColor = Color.Green
                If ScrollList = True Then
                    myListViewItem.EnsureVisible()
                End If

                outputMessage = ""
                myListViewItem = lvwUpdateLog.Items.Add(outputMessage)
                If ScrollList = True Then
                    myListViewItem.EnsureVisible()
                End If

            End If

        Catch ex As MySqlException
            outputMessage = "MySqlException. Message :" + ex.Message
            myListViewItem = lvwUpdateLog.Items.Add(outputMessage)
            myListViewItem.ForeColor = Color.Red
            If ScrollList = True Then
                myListViewItem.EnsureVisible()
            End If
        Catch ex As System.Net.Sockets.SocketException
            outputMessage = "SocketException. Message :" + ex.Message
            myListViewItem = lvwUpdateLog.Items.Add(outputMessage)
            myListViewItem.ForeColor = Color.Red
            If ScrollList = True Then
                myListViewItem.EnsureVisible()
            End If
        Catch ex As Exception
            outputMessage = "Exception. Message :" + ex.Message
            myListViewItem = lvwUpdateLog.Items.Add(outputMessage)
            myListViewItem.ForeColor = Color.Red
            If ScrollList = True Then
                myListViewItem.EnsureVisible()
            End If
        End Try

    End Sub


    Private Sub cbxScrollList_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cbxScrollList.CheckedChanged
        'Control the automatic scrolling of the listview
        If cbxScrollList.Checked = True Then
            ScrollList = True
        Else
            ScrollList = False
        End If
    End Sub


    Private Sub ctxmenu_Popup(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ctxMenu.Popup
        ctxMenu.MenuItems.Clear()
        If TabControl1.SelectedTab.Text = "Log" Then
            ctxMenu.MenuItems.Add("Copy", New EventHandler(AddressOf CopyLogLinesToClipboard))
            ctxMenu.MenuItems.Add("Clear log", New EventHandler(AddressOf Clearlog))
        Else
            ctxMenu.MenuItems.Add("Don't download", New EventHandler(AddressOf ChangeStatusToDontDownload))
            ctxMenu.MenuItems.Add("Download", New EventHandler(AddressOf ChangeStatusToDownload))
        End If
    End Sub


    Private Sub CopyLogLinesToClipboard(ByVal sender As System.Object, ByVal e As System.EventArgs)
        Dim indexes As ListView.SelectedIndexCollection = lvwUpdateLog.SelectedIndices
        Dim indexToSelectedLine As Integer
        Dim selectedString As String = ""
        Dim selectCounter As Integer = 0
        For Each indexToSelectedLine In indexes
            selectedString = selectedString + _
            lvwUpdateLog.Items(indexToSelectedLine).SubItems(0).Text + _
            CarriageReturn + LineFeed
            selectCounter += 1
        Next
        If selectCounter > 0 Then
            Clipboard.SetDataObject(selectedString)
        Else
            sbStatus.Panels(0).Text = "Select at least one line to copy to clipboard"
        End If

    End Sub


    Private Sub Clearlog(ByVal sender As System.Object, ByVal e As System.EventArgs)
        If TabControl1.SelectedTab.Text = "Log" Then
            lvwUpdateLog.Items.Clear()
        End If
    End Sub


    Private Sub ChangeStatusToDontDownload(ByVal sender As System.Object, ByVal e As System.EventArgs)
        'Context menu item - Change "on queue"-status to "don't dowload"-status

        Dim indexes As ListView.SelectedIndexCollection = _
            lvwStatus.SelectedIndices
        Dim indexToSelectedLine As Integer

        For Each indexToSelectedLine In indexes
            If lvwStatus.Items(indexToSelectedLine).SubItems(1).Text = "On queue" Then
                lvwStatus.Items(indexToSelectedLine).SubItems(1).Text = "Don't download"
                lvwStatus.Items(indexToSelectedLine).ForeColor = Color.Gray
                onQueueCount -= 1
            End If
        Next

        presentDownloadCount = downloadCount + 1
        If DownloadActive Then
            tbxDownloading.Text = presentDownloadCount.ToString + "/" + onQueueCount.ToString
        Else
            tbxDownloading.Text = onQueueCount.ToString
        End If

    End Sub


    Private Sub ChangeStatusToDownload(ByVal sender As System.Object, ByVal e As System.EventArgs)
        'Context menu item - Change "don't download"-status to "on queue" status

        Dim indexes As ListView.SelectedIndexCollection = _
            lvwStatus.SelectedIndices

        Dim indexToSelectedLine As Integer

        For Each indexToSelectedLine In indexes
            If ((lvwStatus.Items(indexToSelectedLine).SubItems(1).Text = "Don't download") Or _
            (lvwStatus.Items(indexToSelectedLine).SubItems(1).Text = "No permission")) Then
                lvwStatus.Items(indexToSelectedLine).SubItems(1).Text = "On queue"
                lvwStatus.Items(indexToSelectedLine).ForeColor = Color.Black

                onQueueCount += 1

            End If
        Next

        presentDownloadCount = downloadCount + 1
        If DownloadActive Then
            tbxDownloading.Text = presentDownloadCount.ToString + "/" + onQueueCount.ToString
        Else
            tbxDownloading.Text = onQueueCount.ToString
        End If

    End Sub


    Public Sub FTPException(ByVal exceptionType As String, ByVal ex As Exception)

        exArray = ex.ToString.Split(LineFeed)
        excounter = 0
        While excounter < exArray.Length
            exString = exArray(excounter)
            exString = exString.Replace(CarriageReturn, " ")
            exString = exString.Replace(LineFeed, " ")
            If exString.Length < 2 Then
                Exit While
            End If

            myListViewItem = lvwUpdateLog.Items.Add(exString)
            myListViewItem.ForeColor = Color.Red
            If ScrollList = True Then
                myListViewItem.EnsureVisible()
            End If

            excounter += 1
        End While

    End Sub


    'NOT IN USE
    ' Implements the manual sorting of items by columns.
    'How about integer sorting, some problem there ?????????????????
    Class ListViewItemComparer
        Implements IComparer

        Private col As Integer

        Public Sub New()
            col = 0
        End Sub

        Public Sub New(ByVal column As Integer)
            'Sorting on another column
            col = column
        End Sub

        'The sort
        Public Function Compare(ByVal x As Object, ByVal y As Object) As Integer _
           Implements IComparer.Compare
            'Objects are listviewitems

            Dim compareResult As Integer

            ' Treading objects as long 
            'Return [String].Compare(CType(x, ListViewItem).SubItems(col).Text, CType(y, ListViewItem).SubItems(col).Text)
            Dim longA As Long
            Dim longB As Long
            longA = CLng(x.Text)
            longB = CLng(y.Text)

            If longA < longB Then
                compareResult = -1
            Else
                If longA > longB Then
                    compareResult = 1
                Else
                    compareResult = 0
                End If
            End If

            Return compareResult

        End Function

        'This would be used to take care of sorting on columns by clicking on them
        ' ColumnClick event handler.
        'Private Sub ColumnClick(ByVal o As Object, ByVal e As ColumnClickEventArgs)
        ' Set the ListViewItemSorter property to a new ListViewItemComparer 
        ' object. Setting this property immediately sorts the 
        ' ListView using the ListViewItemComparer object.
        'Me.listView1.ListViewItemSorter = New ListViewItemComparer(e.Column)

    End Class


    Private Sub btnAnalyzeAgain_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnAnalyzeAgain.Click
        Dim checkAgainThread As New Thread(New ThreadStart(AddressOf CheckAgain))
        checkAgainThread.Start()
        Exit Sub
    End Sub

    Private Sub CheckAgain()

        Dim recordCount As Integer
        Dim listCount As Integer
        recordCount = 0
        listCount = 0

        sbStatus.Panels(0).Text = "Checking list again"

        'Count the list
        Dim lvwEnumerator As IEnumerator = lvwStatus.Items.GetEnumerator
        While lvwEnumerator.MoveNext()
            recordCount += 1
        End While

        listCount = 0

        lvwEnumerator = lvwStatus.Items.GetEnumerator
        While lvwEnumerator.MoveNext()

            listCount += 1
            sbStatus.Panels(0).Text = "Analyzing file " + listCount.ToString + _
                " of " + recordCount.ToString + " in list"

            lvwItem = lvwEnumerator.Current
            lvwItemIndex = lvwItem.Index

            fileStatus = lvwItem.SubItems(1).Text
            fileName = lvwItem.SubItems(2).Text
            fileSize = CLng(lvwItem.SubItems(0).Text)

            If fileStatus = "On queue" Then
                FileIsInteresting = True
                checkIfWeHaveFileAlreadyInDatabase()
                If Not FileIsInteresting Then
                    lvwItem.SubItems(1).Text() = "Have file"
                    lvwItem.ForeColor = Color.Red
                End If
            End If

        End While

        SaveListViewToFile()
        sbStatus.Panels(0).Text = ""

    End Sub


End Class
