Imports System
Imports System.IO
Imports System.Drawing
Imports System.Drawing.Imaging
Imports System.Security.Cryptography
Imports System.Timers
Imports System.Net
Imports System.Threading
Imports DexterLib
Imports MySql.Data.MySqlClient


Public Class frmStatus
    Inherits System.Windows.Forms.Form

#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()

        Control.CheckForIllegalCrossThreadCalls = False

        'Add any initialization after the InitializeComponent() call

        'CODE THAT IS NOT GENERATED AUTOMATICALLY - START
        InitializeExtendedStatusBar()
        ProgramDefaultDirectory = Environment.CurrentDirectory

        Dim myToolTip As New ToolTip
        myToolTip.InitialDelay = 500
        myToolTip.AutoPopDelay = 8000
        myToolTip.ReshowDelay = 500
        ' ToolTip text to be displayed whether form is active or not.
        myToolTip.ShowAlways = True

        ' ToolTip text to be displayed whether form is active or not.
        myToolTip.ShowAlways = True

        'myToolTip.SetToolTip(Me.btnLoginCheck, "Login to current FTP, set avoid directories and start directory " + _
        '            "if necessary")

        myToolTip.SetToolTip(Me.btnClearAllLists, "Clear all created lists for current FTP site")
        'myToolTip.SetToolTip(Me.tbxDownloadSpeed, "Show speed as Kb/s - kilobits per second, KB/s " + _
        '"- kiloBytes per second or MB/h - megabytes per hour")


        DownloadActive = False

        AddHandler Me.LoginEvent, AddressOf OnLoginEvent

        typeOfSpeed = 1

        'Only sort the list on initial download from ftp and when refreshing list
        'with new filelist from ftp
        FirstTimeSortOfList = False

        cbDownloadSpeed.Items.Clear()
        cbDownloadSpeed.Items.Add("")
        cbDownloadSpeed.Items.Add("")
        cbDownloadSpeed.Items.Add("")
        cbDownloadSpeed.SelectedIndex = 0


        'CODE THAT IS NOT GENERATED AUTOMATICALLY - END

    End Sub

    'Form overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    'Required by the Windows Form Designer
    Private components As System.ComponentModel.IContainer

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    Friend WithEvents btnStatusExit As System.Windows.Forms.Button
    Friend WithEvents lvwStatus As System.Windows.Forms.ListView
    Friend WithEvents clhStatus As System.Windows.Forms.ColumnHeader
    Friend WithEvents clhMD5Checksum As System.Windows.Forms.ColumnHeader
    Friend WithEvents clhLocalName As System.Windows.Forms.ColumnHeader
    Friend WithEvents clhLocalPath As System.Windows.Forms.ColumnHeader
    Friend WithEvents clhLocalSize As System.Windows.Forms.ColumnHeader
    Friend WithEvents btnClearAllLists As System.Windows.Forms.Button
    Friend WithEvents spbTotal As SPB.SmoothProgressBar
    Friend WithEvents GroupBox1 As System.Windows.Forms.GroupBox
    Friend WithEvents GroupBox2 As System.Windows.Forms.GroupBox
    Friend WithEvents tbxTimeToComplete As System.Windows.Forms.TextBox
    Friend WithEvents GroupBox3 As System.Windows.Forms.GroupBox
    Friend WithEvents ctxMenu As System.Windows.Forms.ContextMenu
    Friend WithEvents clhSizeOfDownload As System.Windows.Forms.ColumnHeader
    Friend WithEvents clhFileName As System.Windows.Forms.ColumnHeader
    Friend WithEvents clhFilePath As System.Windows.Forms.ColumnHeader
    Friend WithEvents clhFileSize As System.Windows.Forms.ColumnHeader
    Friend WithEvents btnDownload As System.Windows.Forms.Button
    Friend WithEvents btnSearchFTPAgain As System.Windows.Forms.Button
    Friend WithEvents GroupBox4 As System.Windows.Forms.GroupBox
    Friend WithEvents tbxFilesLeft As System.Windows.Forms.TextBox
    Friend WithEvents TabControl1 As System.Windows.Forms.TabControl
    Friend WithEvents tabDownload As System.Windows.Forms.TabPage
    Friend WithEvents tabLog As System.Windows.Forms.TabPage
    Friend WithEvents lvwMovieLog As System.Windows.Forms.ListView
    Friend WithEvents btnAnalyzeAgain As System.Windows.Forms.Button
    Friend WithEvents cbDownloadSpeed As System.Windows.Forms.ComboBox
    Friend WithEvents Ftp2 As Dart.PowerTCP.SecureFtp.Ftp
    Friend WithEvents ColumnHeader1 As System.Windows.Forms.ColumnHeader
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.components = New System.ComponentModel.Container
        Dim resources As System.ComponentModel.ComponentResourceManager = New System.ComponentModel.ComponentResourceManager(GetType(frmStatus))
        Me.btnStatusExit = New System.Windows.Forms.Button
        Me.lvwStatus = New System.Windows.Forms.ListView
        Me.clhSizeOfDownload = New System.Windows.Forms.ColumnHeader
        Me.clhStatus = New System.Windows.Forms.ColumnHeader
        Me.clhFileName = New System.Windows.Forms.ColumnHeader
        Me.clhFileSize = New System.Windows.Forms.ColumnHeader
        Me.clhFilePath = New System.Windows.Forms.ColumnHeader
        Me.clhMD5Checksum = New System.Windows.Forms.ColumnHeader
        Me.clhLocalName = New System.Windows.Forms.ColumnHeader
        Me.clhLocalSize = New System.Windows.Forms.ColumnHeader
        Me.clhLocalPath = New System.Windows.Forms.ColumnHeader
        Me.ctxMenu = New System.Windows.Forms.ContextMenu
        Me.btnDownload = New System.Windows.Forms.Button
        Me.btnClearAllLists = New System.Windows.Forms.Button
        Me.spbTotal = New SPB.SmoothProgressBar
        Me.GroupBox1 = New System.Windows.Forms.GroupBox
        Me.cbDownloadSpeed = New System.Windows.Forms.ComboBox
        Me.GroupBox2 = New System.Windows.Forms.GroupBox
        Me.tbxTimeToComplete = New System.Windows.Forms.TextBox
        Me.GroupBox3 = New System.Windows.Forms.GroupBox
        Me.btnSearchFTPAgain = New System.Windows.Forms.Button
        Me.GroupBox4 = New System.Windows.Forms.GroupBox
        Me.tbxFilesLeft = New System.Windows.Forms.TextBox
        Me.TabControl1 = New System.Windows.Forms.TabControl
        Me.tabDownload = New System.Windows.Forms.TabPage
        Me.tabLog = New System.Windows.Forms.TabPage
        Me.lvwMovieLog = New System.Windows.Forms.ListView
        Me.ColumnHeader1 = New System.Windows.Forms.ColumnHeader
        Me.btnAnalyzeAgain = New System.Windows.Forms.Button
        Me.Ftp2 = New Dart.PowerTCP.SecureFtp.Ftp(Me.components)
        Me.GroupBox1.SuspendLayout()
        Me.GroupBox2.SuspendLayout()
        Me.GroupBox3.SuspendLayout()
        Me.GroupBox4.SuspendLayout()
        Me.TabControl1.SuspendLayout()
        Me.tabDownload.SuspendLayout()
        Me.tabLog.SuspendLayout()
        Me.SuspendLayout()
        '
        'btnStatusExit
        '
        Me.btnStatusExit.Anchor = CType((System.Windows.Forms.AnchorStyles.Bottom Or System.Windows.Forms.AnchorStyles.Right), System.Windows.Forms.AnchorStyles)
        Me.btnStatusExit.FlatStyle = System.Windows.Forms.FlatStyle.System
        Me.btnStatusExit.Location = New System.Drawing.Point(924, 520)
        Me.btnStatusExit.Name = "btnStatusExit"
        Me.btnStatusExit.Size = New System.Drawing.Size(86, 32)
        Me.btnStatusExit.TabIndex = 1
        Me.btnStatusExit.Text = "Exit"
        '
        'lvwStatus
        '
        Me.lvwStatus.Anchor = CType((((System.Windows.Forms.AnchorStyles.Top Or System.Windows.Forms.AnchorStyles.Bottom) _
                    Or System.Windows.Forms.AnchorStyles.Left) _
                    Or System.Windows.Forms.AnchorStyles.Right), System.Windows.Forms.AnchorStyles)
        Me.lvwStatus.Columns.AddRange(New System.Windows.Forms.ColumnHeader() {Me.clhSizeOfDownload, Me.clhStatus, Me.clhFileName, Me.clhFileSize, Me.clhFilePath, Me.clhMD5Checksum, Me.clhLocalName, Me.clhLocalSize, Me.clhLocalPath})
        Me.lvwStatus.FullRowSelect = True
        Me.lvwStatus.Location = New System.Drawing.Point(0, 0)
        Me.lvwStatus.Name = "lvwStatus"
        Me.lvwStatus.Size = New System.Drawing.Size(1022, 384)
        Me.lvwStatus.TabIndex = 2
        Me.lvwStatus.UseCompatibleStateImageBehavior = False
        Me.lvwStatus.View = System.Windows.Forms.View.Details
        '
        'clhSizeOfDownload
        '
        Me.clhSizeOfDownload.Text = "Size of download"
        Me.clhSizeOfDownload.Width = 114
        '
        'clhStatus
        '
        Me.clhStatus.Text = "Status"
        Me.clhStatus.Width = 120
        '
        'clhFileName
        '
        Me.clhFileName.Text = "File name"
        Me.clhFileName.Width = 160
        '
        'clhFileSize
        '
        Me.clhFileSize.Text = "File size"
        Me.clhFileSize.Width = 104
        '
        'clhFilePath
        '
        Me.clhFilePath.Text = "Path"
        Me.clhFilePath.Width = 90
        '
        'clhMD5Checksum
        '
        Me.clhMD5Checksum.Text = "MD5 checksum"
        Me.clhMD5Checksum.Width = 150
        '
        'clhLocalName
        '
        Me.clhLocalName.Text = "Local Name"
        Me.clhLocalName.Width = 94
        '
        'clhLocalSize
        '
        Me.clhLocalSize.Text = "LocalSize"
        Me.clhLocalSize.Width = 64
        '
        'clhLocalPath
        '
        Me.clhLocalPath.Text = "Local Path"
        Me.clhLocalPath.Width = 79
        '
        'ctxMenu
        '
        '
        'btnDownload
        '
        Me.btnDownload.Anchor = CType((System.Windows.Forms.AnchorStyles.Bottom Or System.Windows.Forms.AnchorStyles.Left), System.Windows.Forms.AnchorStyles)
        Me.btnDownload.FlatStyle = System.Windows.Forms.FlatStyle.System
        Me.btnDownload.Location = New System.Drawing.Point(12, 520)
        Me.btnDownload.Name = "btnDownload"
        Me.btnDownload.Size = New System.Drawing.Size(88, 32)
        Me.btnDownload.TabIndex = 28
        '
        'btnClearAllLists
        '
        Me.btnClearAllLists.Anchor = CType((System.Windows.Forms.AnchorStyles.Bottom Or System.Windows.Forms.AnchorStyles.Left), System.Windows.Forms.AnchorStyles)
        Me.btnClearAllLists.FlatStyle = System.Windows.Forms.FlatStyle.System
        Me.btnClearAllLists.Location = New System.Drawing.Point(131, 520)
        Me.btnClearAllLists.Name = "btnClearAllLists"
        Me.btnClearAllLists.Size = New System.Drawing.Size(88, 32)
        Me.btnClearAllLists.TabIndex = 29
        Me.btnClearAllLists.Text = "Clear list"
        '
        'spbTotal
        '
        Me.spbTotal.Anchor = CType(((System.Windows.Forms.AnchorStyles.Bottom Or System.Windows.Forms.AnchorStyles.Left) _
                    Or System.Windows.Forms.AnchorStyles.Right), System.Windows.Forms.AnchorStyles)
        Me.spbTotal.Location = New System.Drawing.Point(16, 24)
        Me.spbTotal.Name = "spbTotal"
        Me.spbTotal.Size = New System.Drawing.Size(188, 20)
        Me.spbTotal.TabIndex = 32
        '
        'GroupBox1
        '
        Me.GroupBox1.Anchor = CType((System.Windows.Forms.AnchorStyles.Bottom Or System.Windows.Forms.AnchorStyles.Left), System.Windows.Forms.AnchorStyles)
        Me.GroupBox1.Controls.Add(Me.cbDownloadSpeed)
        Me.GroupBox1.FlatStyle = System.Windows.Forms.FlatStyle.System
        Me.GroupBox1.Location = New System.Drawing.Point(275, 496)
        Me.GroupBox1.Name = "GroupBox1"
        Me.GroupBox1.Size = New System.Drawing.Size(144, 56)
        Me.GroupBox1.TabIndex = 33
        Me.GroupBox1.TabStop = False
        Me.GroupBox1.Text = "Download speed"
        '
        'cbDownloadSpeed
        '
        Me.cbDownloadSpeed.FormattingEnabled = True
        Me.cbDownloadSpeed.Location = New System.Drawing.Point(16, 24)
        Me.cbDownloadSpeed.Name = "cbDownloadSpeed"
        Me.cbDownloadSpeed.Size = New System.Drawing.Size(112, 21)
        Me.cbDownloadSpeed.TabIndex = 42
        '
        'GroupBox2
        '
        Me.GroupBox2.Anchor = CType(((System.Windows.Forms.AnchorStyles.Bottom Or System.Windows.Forms.AnchorStyles.Left) _
                    Or System.Windows.Forms.AnchorStyles.Right), System.Windows.Forms.AnchorStyles)
        Me.GroupBox2.Controls.Add(Me.tbxTimeToComplete)
        Me.GroupBox2.FlatStyle = System.Windows.Forms.FlatStyle.System
        Me.GroupBox2.Location = New System.Drawing.Point(453, 424)
        Me.GroupBox2.Name = "GroupBox2"
        Me.GroupBox2.Size = New System.Drawing.Size(220, 56)
        Me.GroupBox2.TabIndex = 34
        Me.GroupBox2.TabStop = False
        Me.GroupBox2.Text = "Time to complete"
        '
        'tbxTimeToComplete
        '
        Me.tbxTimeToComplete.Anchor = CType(((System.Windows.Forms.AnchorStyles.Bottom Or System.Windows.Forms.AnchorStyles.Left) _
                    Or System.Windows.Forms.AnchorStyles.Right), System.Windows.Forms.AnchorStyles)
        Me.tbxTimeToComplete.BackColor = System.Drawing.SystemColors.Window
        Me.tbxTimeToComplete.Location = New System.Drawing.Point(16, 24)
        Me.tbxTimeToComplete.Name = "tbxTimeToComplete"
        Me.tbxTimeToComplete.ReadOnly = True
        Me.tbxTimeToComplete.Size = New System.Drawing.Size(188, 20)
        Me.tbxTimeToComplete.TabIndex = 35
        '
        'GroupBox3
        '
        Me.GroupBox3.Anchor = CType(((System.Windows.Forms.AnchorStyles.Bottom Or System.Windows.Forms.AnchorStyles.Left) _
                    Or System.Windows.Forms.AnchorStyles.Right), System.Windows.Forms.AnchorStyles)
        Me.GroupBox3.Controls.Add(Me.spbTotal)
        Me.GroupBox3.FlatStyle = System.Windows.Forms.FlatStyle.System
        Me.GroupBox3.Location = New System.Drawing.Point(453, 496)
        Me.GroupBox3.Name = "GroupBox3"
        Me.GroupBox3.Size = New System.Drawing.Size(220, 56)
        Me.GroupBox3.TabIndex = 35
        Me.GroupBox3.TabStop = False
        Me.GroupBox3.Text = "Total progress"
        '
        'btnSearchFTPAgain
        '
        Me.btnSearchFTPAgain.Anchor = CType((System.Windows.Forms.AnchorStyles.Bottom Or System.Windows.Forms.AnchorStyles.Left), System.Windows.Forms.AnchorStyles)
        Me.btnSearchFTPAgain.FlatStyle = System.Windows.Forms.FlatStyle.System
        Me.btnSearchFTPAgain.Location = New System.Drawing.Point(131, 472)
        Me.btnSearchFTPAgain.Name = "btnSearchFTPAgain"
        Me.btnSearchFTPAgain.Size = New System.Drawing.Size(88, 32)
        Me.btnSearchFTPAgain.TabIndex = 37
        Me.btnSearchFTPAgain.Text = "Search FTP again"
        '
        'GroupBox4
        '
        Me.GroupBox4.Anchor = CType((System.Windows.Forms.AnchorStyles.Bottom Or System.Windows.Forms.AnchorStyles.Left), System.Windows.Forms.AnchorStyles)
        Me.GroupBox4.Controls.Add(Me.tbxFilesLeft)
        Me.GroupBox4.FlatStyle = System.Windows.Forms.FlatStyle.System
        Me.GroupBox4.Location = New System.Drawing.Point(275, 424)
        Me.GroupBox4.Name = "GroupBox4"
        Me.GroupBox4.Size = New System.Drawing.Size(144, 56)
        Me.GroupBox4.TabIndex = 38
        Me.GroupBox4.TabStop = False
        Me.GroupBox4.Text = "Files left to download"
        '
        'tbxFilesLeft
        '
        Me.tbxFilesLeft.Anchor = CType((System.Windows.Forms.AnchorStyles.Bottom Or System.Windows.Forms.AnchorStyles.Left), System.Windows.Forms.AnchorStyles)
        Me.tbxFilesLeft.BackColor = System.Drawing.SystemColors.Window
        Me.tbxFilesLeft.Location = New System.Drawing.Point(16, 24)
        Me.tbxFilesLeft.Name = "tbxFilesLeft"
        Me.tbxFilesLeft.ReadOnly = True
        Me.tbxFilesLeft.Size = New System.Drawing.Size(112, 20)
        Me.tbxFilesLeft.TabIndex = 0
        '
        'TabControl1
        '
        Me.TabControl1.Anchor = CType((((System.Windows.Forms.AnchorStyles.Top Or System.Windows.Forms.AnchorStyles.Bottom) _
                    Or System.Windows.Forms.AnchorStyles.Left) _
                    Or System.Windows.Forms.AnchorStyles.Right), System.Windows.Forms.AnchorStyles)
        Me.TabControl1.ContextMenu = Me.ctxMenu
        Me.TabControl1.Controls.Add(Me.tabDownload)
        Me.TabControl1.Controls.Add(Me.tabLog)
        Me.TabControl1.Location = New System.Drawing.Point(0, 0)
        Me.TabControl1.Name = "TabControl1"
        Me.TabControl1.SelectedIndex = 0
        Me.TabControl1.Size = New System.Drawing.Size(1028, 408)
        Me.TabControl1.TabIndex = 39
        '
        'tabDownload
        '
        Me.tabDownload.Controls.Add(Me.lvwStatus)
        Me.tabDownload.Location = New System.Drawing.Point(4, 22)
        Me.tabDownload.Name = "tabDownload"
        Me.tabDownload.Size = New System.Drawing.Size(1020, 382)
        Me.tabDownload.TabIndex = 0
        Me.tabDownload.Text = "Download queue"
        '
        'tabLog
        '
        Me.tabLog.Controls.Add(Me.lvwMovieLog)
        Me.tabLog.Location = New System.Drawing.Point(4, 22)
        Me.tabLog.Name = "tabLog"
        Me.tabLog.Size = New System.Drawing.Size(1020, 382)
        Me.tabLog.TabIndex = 1
        Me.tabLog.Text = "Log"
        '
        'lvwMovieLog
        '
        Me.lvwMovieLog.Anchor = CType((((System.Windows.Forms.AnchorStyles.Top Or System.Windows.Forms.AnchorStyles.Bottom) _
                    Or System.Windows.Forms.AnchorStyles.Left) _
                    Or System.Windows.Forms.AnchorStyles.Right), System.Windows.Forms.AnchorStyles)
        Me.lvwMovieLog.Columns.AddRange(New System.Windows.Forms.ColumnHeader() {Me.ColumnHeader1})
        Me.lvwMovieLog.HeaderStyle = System.Windows.Forms.ColumnHeaderStyle.None
        Me.lvwMovieLog.Location = New System.Drawing.Point(0, 0)
        Me.lvwMovieLog.Name = "lvwMovieLog"
        Me.lvwMovieLog.Size = New System.Drawing.Size(1022, 376)
        Me.lvwMovieLog.TabIndex = 0
        Me.lvwMovieLog.UseCompatibleStateImageBehavior = False
        Me.lvwMovieLog.View = System.Windows.Forms.View.Details
        '
        'ColumnHeader1
        '
        Me.ColumnHeader1.Width = 600
        '
        'btnAnalyzeAgain
        '
        Me.btnAnalyzeAgain.Anchor = CType((System.Windows.Forms.AnchorStyles.Bottom Or System.Windows.Forms.AnchorStyles.Left), System.Windows.Forms.AnchorStyles)
        Me.btnAnalyzeAgain.FlatStyle = System.Windows.Forms.FlatStyle.System
        Me.btnAnalyzeAgain.Location = New System.Drawing.Point(131, 424)
        Me.btnAnalyzeAgain.Name = "btnAnalyzeAgain"
        Me.btnAnalyzeAgain.Size = New System.Drawing.Size(88, 32)
        Me.btnAnalyzeAgain.TabIndex = 40
        Me.btnAnalyzeAgain.Text = "Analyze list again"
        '
        'Ftp2
        '
        Me.Ftp2.ClientDataPort = ""
        '
        '
        '
        Me.Ftp2.Connection.DoEvents = False
        Me.Ftp2.Editor = Me.Ftp2
        Me.Ftp2.Password = ""
        Me.Ftp2.Server = ""
        Me.Ftp2.Username = ""
        '
        'frmStatus
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.ClientSize = New System.Drawing.Size(1028, 581)
        Me.Controls.Add(Me.btnAnalyzeAgain)
        Me.Controls.Add(Me.TabControl1)
        Me.Controls.Add(Me.GroupBox4)
        Me.Controls.Add(Me.btnSearchFTPAgain)
        Me.Controls.Add(Me.GroupBox3)
        Me.Controls.Add(Me.GroupBox2)
        Me.Controls.Add(Me.GroupBox1)
        Me.Controls.Add(Me.btnClearAllLists)
        Me.Controls.Add(Me.btnDownload)
        Me.Controls.Add(Me.btnStatusExit)
        Me.Icon = CType(resources.GetObject("$this.Icon"), System.Drawing.Icon)
        Me.Name = "frmStatus"
        Me.GroupBox1.ResumeLayout(False)
        Me.GroupBox2.ResumeLayout(False)
        Me.GroupBox2.PerformLayout()
        Me.GroupBox3.ResumeLayout(False)
        Me.GroupBox4.ResumeLayout(False)
        Me.GroupBox4.PerformLayout()
        Me.TabControl1.ResumeLayout(False)
        Me.tabDownload.ResumeLayout(False)
        Me.tabLog.ResumeLayout(False)
        Me.ResumeLayout(False)

    End Sub

#End Region


    'Download strategy for movies controlled by MySQL database:
    '
    '1. Check if combination of filename + filesize exists in DB.
    '       In that case, don't download file, it is a duplicate with 99% certainty.
    '2. After download of 250 kb testchunk, calculate checksum and check if it exists in DB.
    '       If not exists, new, so download file and insert file info in DB
    '       If exists, resume file with biggest file size 
    '       RESUMES require that the files are in the places the path points to in DB
    '           if they are not, the file info will be ignored, so ==> KEEP MOVIE POINTERS
    '           UPDATED

    'STANDARD VALUES SET HERE
    Public minimumFileSize As Long = 250000
    'STANDARD VALUES SET HERE

    Public Delegate Sub LoginEventHandler(ByVal sender As Object, ByVal e As LoginEventArgs)
    Public Event LoginEvent As LoginEventHandler

    'Params from main BELOW

    Public Shared parentRef As frmMain

    Public FTPServerName As String
    Public FTPServer As String
    Public FTPUsername As String
    Public FTPPassword As String
    Public FTPServerPort As Integer
    Public FTPPassive As Boolean
    Public serverType As String
    Public useSSL As Boolean

    Public FTPStartFolder As String
    Public FTPAvoidFolders As String()
    Public FTPGetFiles As String()

    Public biggerThanThis As Long

    Public SystemDownloadDirectory As String
    Public SystemCollectionFile As String
    Public SystemAvoidCollectionFile As String
    Public listDirectory As String

    Public totalNumberOfBytesToDownload As Long
    Public totalBytesDownloadedSoFar As Long
    Public bytesLeftToDownload As Long

    Public myConnectionString As String
    Public collectionTablename As String

    Public LookForResumesFirst As Boolean

    'Params from main ABOVE

    Public SameNameFileFound As Boolean
    Public ResumeFound As Boolean

    Public onlyDirectoryPath As String

    Public md As MediaDetClass
    Public img As Image
    Public mdFilename As String

    Public FTPLoginOK As Boolean
    Public lvwStatusChanged As Boolean
    Public DownloadActive As Boolean

    Public ThisIsANewFile As Boolean
    Public ThisIsAResume As Boolean

    Public lvwItem As ListViewItem
    Public lvwItemIndex As Integer

    Public CancelDownloadRequested As Boolean
    Public CancelLoginRequested As Boolean
    Public FileIsInteresting As Boolean
    Public arrSize() As Long
    Public arrRecord() As String

    Public listCount As Integer
    Public downloadCount As Integer

    Public ProgramDefaultDirectory As String

    Public sbStatus As New ExtendedStatusBar
    Public indexToSelectedLine As Integer

    Public lvwDuplicateItem As ListViewItem
    Public lvwDuplicateItem2 As ListViewItem
    Public cstring As String
    Public cstring2 As String
    Public cstring3 As String
    Public sizeOfDownload As Long
    Public counter As Integer
    Public getString As String

    Public UserOK As Boolean
    Public messageToFTPUser As String

    Public ReportSpecialError As Boolean
    Public ListExists As Boolean

    Public publicAvoidDirectoryString As String
    Public publicGetFileString As String

    Public CutForMD5hash As Boolean

    Public HorizontalTab = Chr(9)
    Public LineFeed = Chr(10)
    Public CarriageReturn = Chr(13)

    Public passiveConnection As String
    Public avoidDirectoryString As String = ""
    Public getFileString As String = ""
    Public noteString As String = ""
    Public giveftpaccess As String

    Public soundClip As String

    Public downloadSpeed As Integer
    Public downloadSpeed1 As Integer
    Public downloadSpeed2 As Integer
    Public downloadSpeed3 As Integer
    Public timeToDownload As Integer
    Public downloadDirectory As String

    Public FTPSecureinvoke As Dart.PowerTCP.SecureFtp.Invoke
    Public FTPSecurelisting As Dart.PowerTCP.SecureFtp.Listing

    Public FTPListStreamWriter As StreamWriter
    Public FTPListStreamReader As StreamReader

    Public DownloadListStreamWriter As StreamWriter
    Public DownloadListStreamReader As StreamReader
    Public WCFListStreamReader As StreamReader
    Public CourtesyStreamWriter As StreamWriter

    'Fields in DownloadList.txt
    Public fileSizeOfDownload As Long
    Public fileStatus As String
    Public fileName As String
    Public fileSize As Long
    Public filePath As String
    Public fileMD5 As String
    Public fileLocalName As String
    Public fileLocalPath As String
    Public fileLocalSize As Long

    Public collectionFileName As String
    Public collectionFilePath As String
    Public collectionFileSize As Long

    Public downloadSize As Long
    Public sizeDifference As Long

    Public currentDirectory As String
    Public saveCurrentDirectory As String

    Dim fullRemotePath As String
    Dim fullLocalPath As String
    Dim fullLocalOutputPath As String

    Public MoreRecordsToRead As Boolean
    Public FTPListRecord As String
    Public OptionsRecord As String
    Public FieldDelimiter As String = "|"
    Public SpecialFieldDelimiter As String = ":"
    Public fieldSplit As String()

    Public FTPFilesCount As Long
    Public listedFilesCount As Long
    Public listedFilesSize As Long

    Public MoreToReadFromWCF As Boolean
    Public MoreFileNamesToRead As Boolean
    Public WCFListRecord As String

    Public htMD5 As New Hashtable
    Public htAvoidMD5 As New Hashtable
    Public htOldCollection As New Hashtable
    Public htOptions As New Hashtable
    Public htFTPSite As New Hashtable
    Public FTPSiteRecord As String

    Public DownloadOK As Boolean
    Public RadioButtonsActivated As Boolean
    Public FTPLogString As String
    Public DownloadListRecord As String

    Public listviewUpdateCounter As Integer

    Public typeOfSpeed As Integer

    Public dHours As Integer
    Public dMinutes As Integer

    Public FirstTimeSortOfList As Boolean

    Public filesLeftToDownload As Integer

    Public myConnection As MySqlConnection
    Public myCommand As MySqlCommand

    Public htKey As String
    Public mySQLCommandString As String

    Public bytearrayinput() As Byte
    Public MD5hashstring As String
    Public MD5hash As Byte()
    Public MD5 As New MD5CryptoServiceProvider
    Public MD5DuplicateDeleted As Boolean
    Public checkFileInfo As FileInfo

    Dim downloadlocalpath As String

    Public FTPRecord As String
    Public FTPStreamReader As StreamReader
    Public FTPStreamWriter As StreamWriter

    Public searchFilename As String

    Public nowEnteringDirectory As String
    Public FTPString As String

    Dim pathLength As Integer

    Public analyzeFoundCount As Integer

    Public outputMessage As String
    Public exceptionType As String

    Public exArray As String()
    Public exString As String
    Public excounter As Integer
    Public myListViewItem As ListViewItem



    Private Sub btnDownload_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnDownload.Click
        If btnDownload.Text = "Start download" Then
            btnDownload.Text = "Stop download"
            btnAnalyzeAgain.Enabled = False
            btnSearchFTPAgain.Enabled = False
            btnClearAllLists.Enabled = False
            StartDownload()
        Else
            btnDownload.Text = "Start download"
            btnAnalyzeAgain.Enabled = True
            btnSearchFTPAgain.Enabled = True
            btnClearAllLists.Enabled = True
            StopDownload()
        End If
    End Sub


    Private Sub btnSearchFTPAgain_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnSearchFTPAgain.Click
        CancelDownloadRequested = False
        GetFileListFromFTP()
        AnalyzeFTPList()
        LoadDownLoadListInListView()
        SaveListViewToFile()

        If analyzeFoundCount > 0 Then
            btnDownload.Enabled = True
            sbStatus.Panels(0).Text = analyzeFoundCount.ToString + " new files found"
        Else
            sbStatus.Panels(0).Text = "No new files to download found"
        End If

    End Sub


    Private Sub btnStatusExit_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnStatusExit.Click

        'We seem to loose the downloading file when we go to exit like this
        'But then, this is exit, not stop download, which keeps it, and takes 
        'some time to complete

        If DownloadActive = True Then
            DownloadActive = False
            CancelDownloadRequested = True
            Try
                Ftp2.AbortTransfer()
                Ftp2Close()
            Catch ex As Exception
            End Try
        End If

        Try
            FTPListStreamWriter.Close()
        Catch ex As Exception
        End Try

        Me.Dispose()

    End Sub


    Public Sub StartDownload()
        DownloadActive = True
        CancelDownloadRequested = False
        CancelLoginRequested = False
        FirstTimeSortOfList = False
        filesLeftToDownload = 0

        lvwMovieLog.Items.Clear()

        CheckForList()
        If ListExists Then
            'LoadDownLoadListInListView()
            Getfileslefttodownload()
            StartDownloadJob()
        Else
            GetFileListFromFTP()
            AnalyzeFTPList()
            LoadDownLoadListInListView()
            SaveListViewToFile()

            If Not CancelDownloadRequested Then
                StartDownloadJob()
            End If
        End If

    End Sub


    Private Sub CheckForList()
        If Not Directory.Exists(listDirectory) Then
            Directory.CreateDirectory(listDirectory)
        End If

        ListExists = False
        If File.Exists(listDirectory + "\" + "DownloadList.txt") Then
            ListExists = True
        End If
    End Sub


    Private Sub StartDownloadJob()
        Dim downloadThread As New Thread(New ThreadStart(AddressOf DownloadJob))
        downloadThread.Start()
    End Sub


    Private Sub StopDownload()
        DownloadActive = False
        CancelDownloadRequested = True
        CancelLoginRequested = True

        Try
            Ftp2.AbortTransfer()
            'Ftp2Close()
        Catch ex As Exception

        End Try

        sbStatus.Panels(0).Text = "Stopping download. Wait"
    End Sub


    Public Sub GetFileListFromFTP()
        'If FTP server shuts down during listing, program will backtrack in the
        '   recursed loops and then it quits, it doesn't take very long. This
        '   could be supplemented by a boolean and some error reporting/action

        sbStatus.Panels(0).Text = "Create file list"

        listedFilesCount = 0
        listedFilesSize = 0

        'Create the directory for output of lists concerning specific ftp site
        Try
            If Not Directory.Exists(listDirectory) Then
                Directory.CreateDirectory(listDirectory)
            End If
        Catch ex As Exception
            sbStatus.Panels(0).Text = "Couldn't create directory, review download directory setting"
            Exit Sub
        End Try

        FTPListStreamWriter = New StreamWriter(listDirectory + "\" + "FTPList.txt")

        'Got Operation in progress exception when aborting download
        If Ftp2.Busy Then
            Ftp2.Abort()
        End If
        Ftp2.Server = FTPServer
        Ftp2.Username = FTPUsername
        Ftp2.Password = FTPPassword
        Ftp2.ServerPort = FTPServerPort
        If FTPPassive Then
            Ftp2.Passive = True
        Else
            Ftp2.Passive = False
        End If
        'Just to make sure GUI remains responsive
        Ftp2.DoEvents = True

        If useSSL Then
            'Here are the 2 commands needed to run the client in SSL mode
            ' "Disable" security checks
            Ftp2.UseAuthentication = False
            ' Set the desired security/authentication to explicit. 
            Ftp2.Security = Dart.PowerTCP.SecureFtp.Security.Explicit
            'sbStatus.Panels(0).Text = "Connecting to " + Ftp2.Server.ToString
        End If

        sbStatus.Panels(0).Text = "Connecting to FTP"

        'This change makes it possible to use folderstructure to avoid
        'folders, lilke /foldera/folderc
        'nowEnteringDirectory = Ftp2.GetDirectory + "/" + FTPStartFolder

        Try
            nowEnteringDirectory = Ftp2.GetDirectory + "/" + FTPStartFolder
        Catch ex As Exception
            exceptionType = "Exception"
            FTPException(exceptionType, ex)
            'Exit button might have been pressed
            If DownloadActive = True Then
                sbStatus.Panels(0).Text = "Connect failed. See log for details"
            End If
            CancelDownloadRequested = True
            FTPListStreamWriter.Close()
            Exit Sub
        End Try

        nowEnteringDirectory = nowEnteringDirectory.Replace("//", "/")
        FTPString = nowEnteringDirectory.ToLower

        counter = 0
        While counter < FTPAvoidFolders.Length
            getString = FTPAvoidFolders(counter).ToLower
            If getString.Length > 0 Then
                If (FTPString.IndexOf(getString) >= 0) Then

                    'Close file and exit, nothing listed top folder avoided
                    FTPListStreamWriter.Close()

                    If htOptions.Item("sound") = "on" Then
                        If htOptions.ContainsKey("soundactioncompleted") Then
                            If htOptions.Item("soundactioncompleted") <> "" Then
                                soundClip = htOptions.Item("soundactioncompleted")
                                playSoundClip()
                            End If
                        End If
                    End If

                    Exit Sub
                End If
            End If
            counter += 1
        End While

        'If a startfolder has been entered go there
        If FTPStartFolder.Length > 0 Then
            Try
                FTPSecureinvoke = Ftp2.Invoke(Dart.PowerTCP.SecureFtp.FtpCommand.ChangeDir, FTPStartFolder)
            Catch ex As System.Net.ProtocolViolationException
                'Better handling later

                exceptionType = "System.Net.ProtocolViolationException"
                FTPException(exceptionType, ex)

                sbStatus.Panels(0).Text = "Change to start folder " + _
                    FTPStartFolder + " probably OK"
            Catch ex As System.Net.Sockets.SocketException

                exceptionType = "System.Net.Sockets.SocketException"
                FTPException(exceptionType, ex)

                sbStatus.Panels(0).Text = "Change to start folder " + _
                    FTPStartFolder + " unsuccessful"
                FTPListStreamWriter.Close()
                Ftp2Close()
                Exit Sub
            Catch ex As Exception

                exceptionType = "Exception"
                FTPException(exceptionType, ex)

                sbStatus.Panels(0).Text = "Change to start folder " + _
                    FTPStartFolder + " unsuccessful"
                FTPListStreamWriter.Close()
                Ftp2Close()
                Exit Sub
            End Try
        End If

        Try
            'Problem with this style of listing on Cerberus FTP Server, use it as a fallback
            'FTPSecurelisting = Ftp2.List("*", True)
            FTPSecurelisting = Ftp2.List("", True)
        Catch ex As Exception

            exceptionType = "System.Net.Sockets.SocketException"
            FTPException(exceptionType, ex)

            outputMessage = "Listing command failed"
            myListViewItem = lvwMovieLog.Items.Add(outputMessage)
            myListViewItem.EnsureVisible()
            myListViewItem.ForeColor = Color.Red

            Ftp2Close()
            sbStatus.Panels(0).Text = "Failed to list folder"
            FTPListStreamWriter.Close()
            Ftp2Close()
            Exit Sub
        End Try

        If FTPSecurelisting.Format <> Dart.PowerTCP.SecureFtp.ListingFormat.Unknown Then
            Dim le As Dart.PowerTCP.SecureFtp.ListEntry

            If CancelDownloadRequested = True Then
                Exit Sub
            End If
            currentDirectory = Ftp2.GetDirectory

            For Each le In FTPSecurelisting

                If CancelDownloadRequested = True Then
                    Exit For
                End If

                'le.Path is empty will only have a value if 
                'server supports The List call is for a recursive listing: Ftp.List("-R", true) 
                'le.TimeStamp gives last changed date
                If le.Type = Dart.PowerTCP.SecureFtp.EntryType.File Then

                    fileSize = le.Size

                    'Sometimes a file has size 0 and that causes trouble later
                    If le.Size > 0 Then
                        'Write this list to file
                        FTPListStreamWriter.WriteLine(le.Name + FieldDelimiter + _
                            le.Size.ToString + FieldDelimiter + _
                            currentDirectory)

                        'This should keep output records intact
                        'Just a safety measure, if a half line is written and program
                        '   continues, it will dump since half of the record is gone.
                        FTPListStreamWriter.Flush()

                        listedFilesCount += 1
                        listedFilesSize += le.Size
                    End If

                End If

                If le.Type = Dart.PowerTCP.SecureFtp.EntryType.Directory Then

                    Call RecurseFileList(le)

                End If


                If le.Type = Dart.PowerTCP.SecureFtp.EntryType.Link Then

                    Call RecurseFileList(le)

                End If


            Next

            If CancelDownloadRequested = True Then
                FTPListStreamWriter.Close()
                Ftp2Close()
                sbStatus.Panels(0).Text = "Listing cancelled"
                Exit Sub
            End If
            sbStatus.Panels(0).Text = listedFilesCount.ToString + " - " + _
                currentDirectory

        Else
            'parentRef.lbxResponse.Items.Add("Listing format is unknown. You must parse it yourself.")
        End If

        FTPListStreamWriter.Close()

        Ftp2Close()

        If htOptions.Item("sound") = "on" Then
            If htOptions.ContainsKey("soundactioncompleted") Then
                If htOptions.Item("soundactioncompleted") <> "" Then
                    soundClip = htOptions.Item("soundactioncompleted")
                    playSoundClip()
                End If
            End If
        End If

    End Sub


    Public Function RecurseFileList(ByVal le As Dart.PowerTCP.SecureFtp.ListEntry)

        If CancelDownloadRequested = True Then
            Exit Function
        End If

        'This change makes it possible to use folderstructure to avoid
        'folders, lilke /foldera/folderc
        Try
            If le.Type = Dart.PowerTCP.SecureFtp.EntryType.Directory Then
                nowEnteringDirectory = Ftp2.GetDirectory + "/" + le.Name
            Else
                nowEnteringDirectory = Ftp2.GetDirectory + "/" + le.Destination
            End If
        Catch ex As Exception
            Exit Function
        End Try

        nowEnteringDirectory = nowEnteringDirectory.Replace("//", "/")
        FTPString = nowEnteringDirectory.ToLower

        counter = 0
        While counter < FTPAvoidFolders.Length
            getString = FTPAvoidFolders(counter).ToLower
            If getString.Length > 0 Then
                If (FTPString.IndexOf(getString) >= 0) Then
                    Exit Function
                End If
            End If
            counter += 1
        End While

        Try
            If le.Type = Dart.PowerTCP.SecureFtp.EntryType.Directory Then
                FTPSecureinvoke = Ftp2.Invoke(Dart.PowerTCP.SecureFtp.FtpCommand.ChangeDir, le.Name)
            Else
                FTPSecureinvoke = Ftp2.Invoke(Dart.PowerTCP.SecureFtp.FtpCommand.ChangeDir, le.Destination)
            End If
        Catch ex As System.Net.ProtocolViolationException
            'Why is it thrown here, but action is OK
            'Remove this displays if it works
            'parentRef.lbxResponse.Items.Add("ChangeDir Command probably ok with change to " + le.Name)
            'lvwMovieLog.Items.Add(ex.Message)
        Catch ex As System.Net.Sockets.SocketException
            'parentRef.lbxResponse.Items.Add("ChangeDir Command failed when trying to change to " + le.Name)
            Exit Function
        Catch ex As Exception
            'parentRef.lbxResponse.Items.Add("ChangeDir Command failed when trying to change to " + le.Name)
            Exit Function
        End Try


        Dim FTPsublisting As Dart.PowerTCP.SecureFtp.Listing
        Try
            'FTPsublisting = Ftp2.List("*", True)
            FTPsublisting = Ftp2.List("", True)
        Catch ex As Exception

            exceptionType = "Exception"
            FTPException(exceptionType, ex)

            outputMessage = "Listing command failed"
            myListViewItem = lvwMovieLog.Items.Add(outputMessage)
            myListViewItem.EnsureVisible()
            myListViewItem.ForeColor = Color.Red
            Try
                sbStatus.Panels(0).Text = ""
            Catch ex2 As Exception
            End Try
            Exit Function
        End Try

        If CancelDownloadRequested = True Then
            Exit Function
        End If
        currentDirectory = Ftp2.GetDirectory

        If FTPsublisting.Format <> Dart.PowerTCP.SecureFtp.ListingFormat.Unknown Then
            Dim suble As Dart.PowerTCP.SecureFtp.ListEntry

            For Each suble In FTPsublisting

                If suble.Type = Dart.PowerTCP.SecureFtp.EntryType.File Then

                    fileSize = suble.Size

                    'Sometimes file size = 0 and that causes problems later
                    If suble.Size > 0 Then
                        FTPListStreamWriter.WriteLine(suble.Name + FieldDelimiter + _
                            suble.Size.ToString + FieldDelimiter + _
                            currentDirectory)
                        FTPListStreamWriter.Flush()

                        listedFilesCount += 1
                        listedFilesSize += suble.Size
                    End If

                End If

                If suble.Type = Dart.PowerTCP.SecureFtp.EntryType.Directory Then

                    Call RecurseFileList(suble)

                End If

                If suble.Type = Dart.PowerTCP.SecureFtp.EntryType.Link Then

                    Call RecurseFileList(suble)

                End If

            Next

            If CancelDownloadRequested = True Then
                Exit Function
            End If
            sbStatus.Panels(0).Text = listedFilesCount.ToString + " - " + _
            currentDirectory

        Else
            'parentRef.lbxResponse.Items.Add("Listing format is unknown. You must parse it yourself.")
        End If

        Try
            If le.Type = Dart.PowerTCP.SecureFtp.EntryType.Directory Then
                FTPSecureinvoke = Ftp2.Invoke(Dart.PowerTCP.SecureFtp.FtpCommand.ChangeDirUp, le.Name)
            Else
                FTPSecureinvoke = Ftp2.Invoke(Dart.PowerTCP.SecureFtp.FtpCommand.ChangeDirUp, le.Destination)
            End If

            currentDirectory = Ftp2.GetDirectory

        Catch ex As System.Net.ProtocolViolationException
            'Why is it thrown here, but action is OK
        Catch ex As System.Net.Sockets.SocketException
            'parentRef.lbxResponse.Items.Add("ChangeDirUp Command failed")
            lvwMovieLog.Items.Add(ex.Message)
            Exit Function
        Catch ex As Exception
            'parentRef.lbxResponse.Items.Add("ChangeDirUp Command failed")
            lvwMovieLog.Items.Add(ex.ToString)
            Exit Function
        End Try
        'parentRef.lbxResponse.Items.Add("ChangeDirUp successful")
        'parentRef.lbxResponse.Items.Add("Current directory " + Ftp2.GetDirectory)

    End Function


    Private Sub AnalyzeFTPList()

        sbStatus.Panels(0).Text = "Analyzing list"

        loadHashTableOldCollection()

        listCount = 0
        analyzeFoundCount = 0

        listedFilesSize = 0
        Dim analyzeFileSize As Long = 0

        FTPListStreamReader = New StreamReader(listDirectory + "\" + "FTPList.txt")

        'Append on existing file, create if not there
        Dim downloadListPath As String
        downloadListPath = listDirectory + "\" + "DownloadList.txt"

        Dim DoOldCollectionCheck As Boolean = False

        If File.Exists(downloadListPath) Then
            DoOldCollectionCheck = True
            Try
                DownloadListStreamWriter = File.AppendText(downloadListPath)
            Catch ex As Exception
                sbStatus.Panels(0).Text = "Couldn't open existing " + _
                downloadListPath + " for append. Error was " + ex.ToString
                'parentRef.lbxResponse.Items.Add("Couldn't open existing " + _
                'downloadListPath + " for append. Error was " + ex.ToString)
                Exit Sub
            End Try
        Else
            Try
                DownloadListStreamWriter = New StreamWriter(downloadListPath)
            Catch ex As Exception
                sbStatus.Panels(0).Text = "Couldn't open new " + _
                downloadListPath + " for write. Error was " + ex.ToString
                'parentRef.lbxResponse.Items.Add("Couldn't open new " + _
                'downloadListPath + " for write. Error was " + ex.ToString)
                Exit Sub
            End Try
        End If

        MoreRecordsToRead = True

        GetNextFTPListRecord()
        Do While (MoreRecordsToRead)

            listCount += 1

            sbStatus.Panels(0).Text = "Analyzing file " + listCount.ToString + _
            " of " + listedFilesCount.ToString + " in list"

            fieldSplit = FTPListRecord.Split(FieldDelimiter)

            fileName = fieldSplit(0)
            fileSize = CLng(fieldSplit(1))
            filePath = fieldSplit(2)

            listedFilesSize += fileSize

            FileIsInteresting = True

            'We will say which files we are interested in
            Dim WeWantThisFile As Boolean = False
            Dim FTPString As String
            counter = 0
            While counter < FTPGetFiles.Length
                getString = FTPGetFiles(counter).ToLower
                If getString.Length > 0 Then
                    FTPString = fileName.ToLower
                    If (FTPString.IndexOf(getString) >= 0) Then
                        WeWantThisFile = True
                        Exit While
                    End If
                End If
                counter += 1
            End While
            If Not WeWantThisFile Then
                FileIsInteresting = False
            End If

            'If we have a downloadlist already, we will try to avoid to fill it up
            'with duplicates
            If FileIsInteresting = True Then
                If DoOldCollectionCheck = True Then
                    checkFileAgainstDownloadList()
                End If
            End If

            If FileIsInteresting = True Then
                'Read on index filename + filesize if this record exists in DB
                'Don't mind small or big letters
                htKey = fieldSplit(0) + "+" + fieldSplit(1)
                htKey = htKey.ToLower
                checkIfWeHaveFileAlreadyInDatabase()
            End If

            'If the file passes all tests, it will be written to output file
            If FileIsInteresting Then
                analyzeFileSize += fileSize
                analyzeFoundCount += 1

                cstring = Format(CLng(fileSize), "###,###,###,###,###")

                DownloadListRecord = cstring + FieldDelimiter + _
                "On queue" + FieldDelimiter + _
                fileName + FieldDelimiter + _
                cstring + FieldDelimiter + _
                filePath + FieldDelimiter + _
                "" + FieldDelimiter + _
                "" + FieldDelimiter + _
                "" + FieldDelimiter + _
                "" + FieldDelimiter
                DownloadListStreamWriter.WriteLine(DownloadListRecord)
            End If

            GetNextFTPListRecord()
        Loop

        FTPListStreamReader.Close()
        DownloadListStreamWriter.Close()

        If htOptions.Item("sound") = "on" Then
            If htOptions.ContainsKey("soundactioncompleted") Then
                If htOptions.Item("soundactioncompleted") <> "" Then
                    soundClip = htOptions.Item("soundactioncompleted")
                    playSoundClip()
                End If
            End If
        End If

        FirstTimeSortOfList = True

    End Sub


    Private Sub checkIfWeHaveFileAlreadyInDatabase()

        Dim result As Integer

        Try
            If myConnection Is Nothing Then
                OpenConnectionToDatabase()
            End If

            'Some filenames contain apostrophes
            'searchFilename = fileName.Replace("'", "''")
            searchFilename = fileName.Replace("'", "\'")

            mySQLCommandString = "SELECT COUNT(*) FROM " + collectionTablename + _
            " WHERE filename='" + searchFilename + _
            "' AND filesize='" + fileSize.ToString + "';"

            myCommand = New MySqlCommand(mySQLCommandString)
            myCommand.Connection = myConnection

            result = myCommand.ExecuteScalar

            'File exists in database with same name and size so we don't want it
            If result > 0 Then
                FileIsInteresting = False
            End If

        Catch ex As MySqlException
            lvwMovieLog.Items.Add("MySQLException :" + ex.Message)
            lvwMovieLog.Items.Add("CommandString :" + mySQLCommandString)
        Catch ex As System.Net.Sockets.SocketException
            'Port errors
            lvwMovieLog.Items.Add("SocketException :" + ex.Message)
            lvwMovieLog.Items.Add("CommandString :" + mySQLCommandString)
        Catch ex As Exception
            'Syntax errors
            lvwMovieLog.Items.Add("Exception :" + ex.Message)
            lvwMovieLog.Items.Add("CommandString :" + mySQLCommandString)
        End Try

    End Sub


    Private Sub loadHashTableOldCollection()
        htOldCollection.Clear()
        If File.Exists(listDirectory + "\" + "DownloadList.txt") Then
            DownloadListStreamReader = New StreamReader(listDirectory + "\" + "DownloadList.txt")
            MoreRecordsToRead = True
            GetNextDownloadListRecord()
            Do While (MoreRecordsToRead)
                fieldSplit = DownloadListRecord.Split(FieldDelimiter)
                'Using filename as key, and filesize as content
                Try
                    htOldCollection.Add(fieldSplit(2), fieldSplit(3))
                Catch ex As Exception
                    'Not foolproof, there might be name duplicates, but 99%
                End Try
                GetNextDownloadListRecord()
            Loop
            DownloadListStreamReader.Close()
        End If
    End Sub


    Private Sub checkFileAgainstDownloadList()
        'If we have a file with the same filename and same filesize, we will
        'assume that we have it already. Not foolproof, but 99 percent and it
        'allows partner to move files around and rename folders
        Dim listFileSize As Long
        Dim fieldSplit2 As String()

        If htOldCollection.ContainsKey(fileName) Then
            fieldSplit2 = htOldCollection.Item(fileName).Split(FieldDelimiter)
            listFileSize = CLng(fieldSplit2(0))
            'If we have an entry in this partners downloadlist with same filename
            'and filesize, we assume that we have this entry already
            If fileSize = listFileSize Then
                FileIsInteresting = False
            End If
        End If
    End Sub


    Private Sub DownloadJob()

        Dim textboxCounter As Integer

        downloadCount = 0
        ReportSpecialError = False

        'Write listview to file every 25th download
        listviewUpdateCounter = 0

        lvwStatusChanged = False

        'Second progressbar to report on total download activity
        spbTotal.Visible = True
        spbTotal.BarColor1 = Color.Red
        spbTotal.Minimum = 0
        spbTotal.Value = 0
        spbTotal.Maximum = 100
        spbTotal.Update()

        Dim lvwEnumerator As IEnumerator = lvwStatus.Items.GetEnumerator
        While lvwEnumerator.MoveNext()

            'Starting from the beginning when doing a change to the listview
            ' by the right-click menu
            If lvwStatusChanged = True Then
                lvwStatusChanged = False
                lvwEnumerator = lvwStatus.Items.GetEnumerator
                If Not lvwEnumerator.MoveNext Then
                    Exit While
                End If
            End If

            lvwItem = lvwEnumerator.Current
            lvwItemIndex = lvwItem.Index

            If CancelDownloadRequested = True Then
                Exit While
            End If

            fileSizeOfDownload = CLng(lvwItem.SubItems(0).Text)
            fileStatus = lvwItem.SubItems(1).Text
            fileName = lvwItem.SubItems(2).Text
            fileSize = CLng(lvwItem.SubItems(3).Text)
            filePath = lvwItem.SubItems(4).Text

            If lvwItem.SubItems(1).Text = "On queue" Then

                If fileSize > biggerThanThis Then

                    'Experimental - this would make it possible to download the
                    'resumes only, naw, resumes are often renamed anyway, dont
                    'implement this
                    'If LookForResumesFirst
                    '  CheckForSameNameFile()
                    '  If SameNameFileFound
                    '    If lvwItem.SubItems(5).Text = "" Then
                    '      DownloadMD5Checksum()
                    '    End If
                    '    CheckForResume()
                    '    If ResumeFound
                    '      If lvwItem.SubItems(5).Text <> "" Then
                    '        MD5hashstring = lvwItem.SubItems(5).Text
                    '        HandleListViewItem()
                    '      End If
                    '    End If
                    '  End If
                    'Else

                    If lvwItem.SubItems(5).Text = "" Then
                        DownloadMD5Checksum()
                    End If

                    'End If

                    If lvwItem.SubItems(5).Text <> "" Then
                        MD5hashstring = lvwItem.SubItems(5).Text
                        HandleListViewItem()
                    End If

                End If

            End If

        End While

        SaveListViewToFile()

        CloseConnectionToDatabase()

        sbStatus.progressBar.Value = 0
        sbStatus.progressBar.Update()
        cbDownloadSpeed.Text = ""
        tbxTimeToComplete.Text = ""

        Dim tradeReport As String
        Dim ThisMoment As Date
        Dim myShortTime As String
        ThisMoment = Now
        myShortTime = ThisMoment.ToShortTimeString
        myShortTime = myShortTime.Replace(":", ".")


        textboxCounter = parentRef.tbxNote.Lines.Length

        If downloadCount = 1 Then
            If textboxCounter = 0 Then
                tradeReport = downloadCount.ToString + _
                " movie download at " + _
                ThisMoment.ToShortDateString + " " + _
                myShortTime
            Else
                tradeReport = Environment.NewLine + downloadCount.ToString + _
                " movie download at " + _
                ThisMoment.ToShortDateString + " " + _
                myShortTime
            End If
        Else
            If textboxCounter = 0 Then
                tradeReport = downloadCount.ToString + _
                " movies download at " + _
                ThisMoment.ToShortDateString + " " + _
                myShortTime
            Else
                tradeReport = Environment.NewLine + downloadCount.ToString + _
                " movies download at " + _
                ThisMoment.ToShortDateString + " " + _
                myShortTime
            End If
        End If

        'There might be a special condition that needs reporting, if not,
        '   use normal message
        If Not ReportSpecialError Then

            'Only disable user account on ftp when the whole download has been done
            If CancelDownloadRequested = False Then
                If htOptions.ContainsKey("ftpdone") Then
                    If htOptions.Item("ftpdone") = "yes" Then
                        lvwMovieLog.Items.Add("All files downloaded. Give user the bum's rush")
                        giveUserTheBumsRush()
                        sbStatus.Panels(0).Text = "Download complete. Files downloaded: " + _
                            downloadCount.ToString + _
                            ". User account " + FTPServerName + " disabled."
                        btnDownload.Enabled = False

                        If downloadCount > 0 Then
                            parentRef.tbxNote.AppendText(tradeReport + " - Done.")
                            parentRef.SpecialNoteSave()
                        End If

                    Else
                        sbStatus.Panels(0).Text = "Download complete. Files downloaded: " + _
                            downloadCount.ToString
                        btnDownload.Enabled = False

                        If downloadCount > 0 Then
                            parentRef.tbxNote.AppendText(tradeReport + " - Done.")
                            parentRef.SpecialNoteSave()
                        End If

                    End If
                Else
                    sbStatus.Panels(0).Text = "Download complete. Files downloaded: " + _
                        downloadCount.ToString
                    btnDownload.Enabled = False

                    If downloadCount > 0 Then
                        parentRef.tbxNote.AppendText(tradeReport + " - Done.")
                        parentRef.SpecialNoteSave()
                    End If
                End If

            Else
                Try
                    If downloadCount = 0 Then
                        sbStatus.Panels(0).Text = "No files downloaded"
                    Else
                        sbStatus.Panels(0).Text = "Files downloaded: " + downloadCount.ToString
                    End If

                    If downloadCount > 0 Then
                        parentRef.tbxNote.AppendText(tradeReport)
                        parentRef.SpecialNoteSave()
                    End If

                Catch ex As Exception
                    'Ugly, but panel is empty when exiting with Exit button
                End Try
            End If
        Else
            'Lots of errors makes reporting here impracticable
            'If downloadCount > 0 Then
            'parentRef.tbxNote.AppendText(tradeReport)
            'parentRef.SpecialNoteSave()
            'End If

        End If

        If DownloadOK Then
            btnDownload.Text = "Start download"
            btnAnalyzeAgain.Enabled = True
            btnSearchFTPAgain.Enabled = True
            btnClearAllLists.Enabled = True
        End If


    End Sub


    Private Sub DownloadMD5Checksum()

        CutForMD5hash = True

        Dim md5 As New MD5CryptoServiceProvider
        Dim bytearrayinput() As Byte
        ReDim bytearrayinput(minimumFileSize)
        Dim MD5hash As Byte()
        Dim remotePath As String
        Dim FileReadOK As Boolean

        sbStatus.progressBar.BarColor1 = Color.Yellow

        Ftp2.Server = FTPServer
        Ftp2.Username = FTPUsername
        Ftp2.Password = FTPPassword
        Ftp2.ServerPort = FTPServerPort
        If FTPPassive Then
            Ftp2.Passive = True
        Else
            Ftp2.Passive = False
        End If
        'Just to make sure GUI remains responsive
        Ftp2.DoEvents = True
        ' Set FtpProgressEvent to raise every 1024 K processed (default is 8096).
        Ftp2.BlockSize = 1024

        If useSSL Then
            'Here are the 2 commands needed to run the client in SSL mode
            ' "Disable" security checks
            Ftp2.UseAuthentication = False
            ' Set the desired security/authentication to explicit. 
            Ftp2.Security = Dart.PowerTCP.SecureFtp.Security.Explicit
        End If

        remotePath = filePath + "/" + fileName
        remotePath = remotePath.Replace("//", "/")

        sbStatus.Panels(0).Text = "Retrieve MD5 checksum for " + fileName

        'Reading remote file into memory, problem with tempofile delete prompts this solution
        Dim getStream As New System.IO.MemoryStream

        FileReadOK = True
        Dim getFile As Dart.PowerTCP.SecureFtp.FtpFile
        Try
            getFile = Ftp2.Get(remotePath, getStream)
        Catch ex As System.Net.ProtocolViolationException
            FileReadOK = False
            'For some reason, this exception is thrown
            'Might be because of the PASV command that is sent automatically by
            '   the software, which might effect the stability of the connection
            'As an experiment, ignore this exception and see if the download
            'works, can't ignore this
            'parentRef.lbxResponse.Items.Add("ProtocolViolationException when trying " + _
            '"to read file for MD5 checksum.")

            exceptionType = "System.Net.ProtocolViolationException"
            FTPException(exceptionType, ex)

            outputMessage = "Listing command failed"
            myListViewItem = lvwMovieLog.Items.Add(outputMessage)
            myListViewItem.EnsureVisible()
            myListViewItem.ForeColor = Color.Red


        Catch ex As Exception
            FileReadOK = False

            Dim counter As Integer = 0
            Dim exString As String
            exArray = ex.ToString.Split(LineFeed)
            While counter < exArray.Length
                'exString = exArray(counter)
                exString = FTPLogString
                exString = exString.Replace(CarriageReturn, " ")
                exString = exString.Replace(LineFeed, " ")
                counter += 1

                lvwMovieLog.Items.Add("Exception message " + exString)

                'Some errors will not lead to relogin attempts
                exString = exString.ToLower
                'File might have been moved
                If (exString.IndexOf("no such file") >= 0) Or _
                    (exString.IndexOf("file not found") >= 0) Then
                    lvwMovieLog.Items.Add("MD5 checksum for file " + remotePath + _
                    " was going to be downloaded but file can't be found")
                    lvwItem.SubItems(1).Text() = "File missing"
                    lvwItem.ForeColor = Color.Red
                    Exit Sub
                End If

                If exString.IndexOf("no permission") >= 0 Then
                    lvwMovieLog.Items.Add("File " + remotePath + _
                    " was going to be downloaded but no permission to download")
                    lvwItem.SubItems(1).Text() = "No permission"
                    lvwItem.ForeColor = Color.Red
                    Exit Sub
                End If

            End While
            'parentRef.lbxResponse.Items.Add(" ")
        End Try

        If Not FileReadOK Then
            'Cancel button might have been pressed
            If DownloadActive = True Then
                sbStatus.Panels(0).Text = "Trying to login again"
                Ftp2.AbortTransfer()
                Ftp2Close()
                SaveListViewToFile()
                ReportSpecialError = True
                CancelDownloadRequested = True
                TryToLoginToFTP()
                Exit Sub
            End If
        End If

        If FileReadOK Then
            If htOptions.Item("sound") = "on" Then
                If htOptions.ContainsKey("soundchecksumdownloaded") Then
                    If htOptions.Item("soundchecksumdownloaded") <> "" Then
                        soundClip = htOptions.Item("soundchecksumdownloaded")
                        playSoundClip()
                    End If
                End If
            End If

            sbStatus.progressBar.Value = minimumFileSize
            sbStatus.progressBar.Update()

            Dim streamLength As Long = getStream.Length

            'Sometimes a MD5 download is interrupted and wrong MD5 calculated
            'It is rare, but could happen if user presses Cancel button
            'Taken care of here
            If fileSize > minimumFileSize Then
                If streamLength < minimumFileSize Then
                    Exit Sub
                End If
            End If

            getStream.Seek(0, SeekOrigin.Begin)
            counter = 0
            While ((counter < (minimumFileSize + 1)) And (counter < streamLength))
                bytearrayinput(counter) = Convert.ToByte(getStream.ReadByte())
                counter += 1
            End While
            getStream.Close()

            MD5hash = md5.ComputeHash(bytearrayinput)
            MD5hashstring = Convert.ToBase64String(MD5hash)
            MD5hashstring = MD5hashstring.Replace("w"c, "V"c)
            MD5hashstring = MD5hashstring.Replace("W"c, "V"c)

            lvwStatus.Items(lvwItemIndex).SubItems(5).Text() = MD5hashstring

        End If

        'Save listview occassionally to file
        listviewUpdateCounter += 1
        If listviewUpdateCounter > 25 Then
            listviewUpdateCounter = 0
            SaveListViewToFile()
        End If

    End Sub


    Private Sub HandleListViewItem()

        ThisIsANewFile = False
        ThisIsAResume = False

        CheckMD5AgainstDatabase()

        If ThisIsANewFile Or ThisIsAResume Then
            DownloadFile()
        End If

    End Sub


    Private Sub CheckMD5AgainstDatabase()

        'Check if file with this checksum exists in database, and if so, select the 
        'biggest file, which will be used for resume if incoming file is bigger than the
        'biggest we already have

        Dim myReader As MySqlDataReader
        Dim result As Integer
        Dim MySQL_Filename As String
        Dim MySQL_Filesize As Long
        Dim MySQL_Filepath As String
        Dim save_Filename As String
        Dim save_Filesize As Long
        Dim save_Filepath As String
        Dim localfullpath As String
        Dim MD5found As Boolean
        Dim correctedFileName As String

        If myConnection Is Nothing Then
            OpenConnectionToDatabase()
        End If

        MD5found = False
        save_Filesize = 0

        Try
            mySQLCommandString = "SELECT * FROM " + collectionTablename + _
            " WHERE fileMD5='" + MD5hashstring + "';"

            myCommand = New MySqlCommand(mySQLCommandString)
            myCommand.Connection = myConnection

            myReader = myCommand.ExecuteReader()
            While myReader.Read()

                MySQL_Filename = myReader.GetString(0)
                MySQL_Filesize = myReader.GetInt64(1)
                MySQL_Filepath = myReader.GetString(2)

                'We save info about files with same MD5 as already downloaded files
                'but we don't save any path info, since there is no file on our disk
                'and there is no possibility of resuming from such a file
                If MySQL_Filepath <> "" Then

                    localfullpath = MySQL_Filepath + "\" + MySQL_Filename

                    If Not File.Exists(localfullpath) Then
                        'If file in database doesn't exist on its supposed location, the file
                        'must have been renamed, moved or deleted, and we have to continue to look
                    Else
                        MD5found = True
                        If MySQL_Filesize > save_Filesize Then
                            save_Filename = MySQL_Filename
                            save_Filesize = MySQL_Filesize
                            save_Filepath = MySQL_Filepath
                        End If
                    End If

                End If

            End While
            myReader.Close()

            If MD5found Then
                'Determine if new or resume download
                If fileSize > save_Filesize Then
                    ThisIsAResume = True
                    collectionFileName = save_Filename
                    collectionFileSize = save_Filesize
                    collectionFilePath = save_Filepath
                Else
                    'We get here if incoming file is smaller than what we have already
                    lvwItem.SubItems(1).Text() = "Have file"
                    lvwItem.ForeColor = Color.Red

                    lvwItem.SubItems(6).Text = save_Filename
                    cstring2 = Format(CLng(save_Filesize), "###,###,###,###,###")
                    lvwItem.SubItems(7).Text = cstring2
                    lvwItem.SubItems(8).Text = save_Filepath

                    'Save info about file in DB, so we can avoid it in the future
                    Try
                        If myConnection Is Nothing Then
                            OpenConnectionToDatabase()
                        End If

                        correctedFileName = fileName.Replace("'", "\'")

                        mySQLCommandString = "INSERT INTO " + collectionTablename + _
                        " SET filename='" + correctedFileName + "'," + _
                        " filesize = '" + fileSize.ToString + "'," + _
                        " filepath = ''," + _
                        " filetime = ''," + _
                        " fileMD5 = '" + MD5hashstring + "';"

                        myCommand.CommandText = mySQLCommandString

                        result = myCommand.ExecuteNonQuery()

                        If result < 1 Then
                            lvwMovieLog.Items.Add("Insert into database failed of " + _
                                correctedFileName)
                        End If

                    Catch ex As MySqlException
                        lvwMovieLog.Items.Add("MySQLException :" + ex.Message)
                        lvwMovieLog.Items.Add("CommandString :" + mySQLCommandString)
                    Catch ex As System.Net.Sockets.SocketException
                        'Port errors
                        lvwMovieLog.Items.Add("SocketException :" + ex.Message)
                        lvwMovieLog.Items.Add("CommandString :" + mySQLCommandString)
                    Catch ex As Exception
                        'Syntax errors
                        lvwMovieLog.Items.Add("Exception :" + ex.Message)
                        lvwMovieLog.Items.Add("CommandString :" + mySQLCommandString)
                    End Try


                    filesLeftToDownload -= 1
                    If filesLeftToDownload = 0 Then
                        tbxFilesLeft.Text = ""
                    Else
                        tbxFilesLeft.Text = filesLeftToDownload.ToString
                    End If

                    'Updating progressbar since this was thought to be a download
                    totalBytesDownloadedSoFar = totalBytesDownloadedSoFar + fileSize
                    spbTotal.Value = (totalBytesDownloadedSoFar / totalNumberOfBytesToDownload) * 100
                    spbTotal.Update()

                End If
            Else
                ThisIsANewFile = True
            End If

        Catch ex As MySqlException
            lvwMovieLog.Items.Add("MySQLException :" + ex.Message)
            lvwMovieLog.Items.Add("CommandString :" + mySQLCommandString)
        Catch ex As System.Net.Sockets.SocketException
            'Port errors
            lvwMovieLog.Items.Add("SocketException :" + ex.Message)
            lvwMovieLog.Items.Add("CommandString :" + mySQLCommandString)
        Catch ex As Exception
            'Syntax errors
            lvwMovieLog.Items.Add("Exception :" + ex.Message)
            lvwMovieLog.Items.Add("CommandString :" + mySQLCommandString)
        End Try

    End Sub


    Private Sub DownloadFile()
        CutForMD5hash = False

        Dim localPath As String
        Dim remotePath As String
        Dim receivingFileName As String

        Dim sizeToDownload As Long

        Dim OKToTryToDownload As Boolean

        sbStatus.progressBar.BarColor1 = Color.ForestGreen

        Ftp2.Server = FTPServer
        Ftp2.Username = FTPUsername
        Ftp2.Password = FTPPassword
        Ftp2.ServerPort = FTPServerPort
        'Binary transfer
        Ftp2.FileType = Dart.PowerTCP.SecureFtp.FileType.Image
        If FTPPassive Then
            Ftp2.Passive = True
        Else
            Ftp2.Passive = False
        End If
        'Just to make sure GUI remains responsive
        Ftp2.DoEvents = True
        'To signal we want to resume
        Ftp2.Restart = True
        'Size of blocks between progress event is raised
        Ftp2.BlockSize = 8096

        If useSSL Then
            'Here are the 2 commands needed to run the client in SSL mode
            ' "Disable" security checks
            Ftp2.UseAuthentication = False
            ' Set the desired security/authentication to explicit. 
            Ftp2.Security = Dart.PowerTCP.SecureFtp.Security.Explicit
        End If

        remotePath = filePath + "/" + fileName
        remotePath = remotePath.Replace("//", "/")

        If ThisIsANewFile Then
            onlyDirectoryPath = SystemDownloadDirectory + "\" + _
                    "NewMovies" + "\" + _
                    FTPServerName
            downloadlocalpath = onlyDirectoryPath + "\" + fileName
            receivingFileName = fileName
            sizeToDownload = fileSize
        Else
            onlyDirectoryPath = SystemDownloadDirectory + "\" + _
                    "ResumedMovies" + "\" + _
                    FTPServerName
            localPath = collectionFilePath + "\" + collectionFileName
            downloadlocalpath = onlyDirectoryPath + "\" + collectionFileName
            receivingFileName = collectionFileName

            sizeToDownload = fileSize - collectionFileSize
            cstring = Format(CLng(sizeToDownload), "###,###,###,###,###")
            lvwItem.SubItems(0).Text = cstring
            If fileName <> collectionFileName Then
                lvwItem.SubItems(6).Text = collectionFileName
            End If
            cstring2 = Format(CLng(collectionFileSize), "###,###,###,###,###")
            lvwItem.SubItems(7).Text = cstring2
            lvwItem.SubItems(8).Text = collectionFilePath
        End If

        'Create the directory for output of lists concerning specific ftp site
        If Not Directory.Exists(onlyDirectoryPath) Then
            Directory.CreateDirectory(onlyDirectoryPath)
        End If

        OKToTryToDownload = True

        'Have to avoid files if path becomes too long, so keep
        'download directory name within reasonable limits
        pathLength = downloadlocalpath.Length
        If pathLength > 259 Then
            lvwMovieLog.Items.Add("The path name " + downloadlocalpath + _
            " is too long. It has to be less than 260 characters but was " + _
            pathLength.ToString + " characters long")
            lvwItem.SubItems(1).Text() = "Don't download"
            lvwItem.ForeColor = Color.Gray

            filesLeftToDownload -= 1
            If filesLeftToDownload = 0 Then
                tbxFilesLeft.Text = ""
            Else
                tbxFilesLeft.Text = filesLeftToDownload.ToString
            End If

            Exit Sub
        End If

        checkFileInfo = New FileInfo(downloadlocalpath)
        If File.Exists(downloadlocalpath) Then

            If fileSize > checkFileInfo.Length Then
                'parentRef.lbxResponse.Items.Add("File " + downloadlocalpath + _
                '" exists but still is not complete, download proceeding")
                'parentRef.lbxResponse.Items.Add("Full file size is " + fileSize.ToString + _
                '" but found a filesize of " + checkFileInfo.Length.ToString)
            Else
                lvwItem.SubItems(1).Text() = "Have file"
                lvwItem.ForeColor = Color.Red

                filesLeftToDownload -= 1
                If filesLeftToDownload = 0 Then
                    tbxFilesLeft.Text = ""
                Else
                    tbxFilesLeft.Text = filesLeftToDownload.ToString
                End If

                'parentRef.lbxResponse.Items.Add("File " + localPath + _
                '        " exists and has probably been resumed already")
                'parentRef.lbxResponse.Items.Add("Download cancelled")
                'parentRef.lbxResponse.Items.Add("")
                OKToTryToDownload = False
            End If
        Else
            If ThisIsAResume Then
                Try
                    sbStatus.Panels(0).Text = "Copying " + localPath + _
                    " for resume"
                    File.Copy(localPath, downloadlocalpath, False)
                Catch
                    'parentRef.lbxResponse.Items.Add("Problem to copy file " + localPath + _
                    '        " to " + downloadlocalpath)
                    'parentRef.lbxResponse.Items.Add("Download cancelled")
                    'parentRef.lbxResponse.Items.Add("")
                End Try
            End If
        End If

        If OKToTryToDownload Then

            If ThisIsAResume Then
                sbStatus.Panels(0).Text = "Resuming " + collectionFileName
            Else
                sbStatus.Panels(0).Text = "Downloading " + fileName
            End If

            DownloadOK = True

            Dim getFile As Dart.PowerTCP.SecureFtp.FtpFile
            Try
                getFile = Ftp2.Get(remotePath, downloadlocalpath)
            Catch ex As Exception
                'parentRef.lbxResponse.Items.Add("Couldn't complete download to " + downloadlocalpath + _
                '" with remote file " + fileName)
                'parentRef.lbxResponse.Items.Add(" Message   :" + ex.Message.ToString)
                'Dim counter As Integer = 0
                Dim exString As String
                exString = FTPLogString
                exString = exString.Replace(CarriageReturn, " ")
                exString = exString.Replace(LineFeed, " ")
                'parentRef.lbxResponse.Items.Add(" Exception :" + exString)
                'counter += 1

                lvwMovieLog.Items.Add("Exception message " + exString)


                'Some errors will not lead to relogin attempts
                exString = exString.ToLower
                'File might have been moved
                If (exString.IndexOf("no such file") >= 0) Or _
                    (exString.IndexOf("file not found") >= 0) Then
                    lvwMovieLog.Items.Add("File " + remotePath + _
                        " was going to be downloaded but file can't be found")
                    lvwItem.SubItems(1).Text() = "File missing"
                    lvwItem.ForeColor = Color.Red
                    lvwItem.EnsureVisible()

                    filesLeftToDownload -= 1
                    If filesLeftToDownload = 0 Then
                        tbxFilesLeft.Text = ""
                    Else
                        tbxFilesLeft.Text = filesLeftToDownload.ToString
                    End If

                    Exit Sub
                End If


                If exString.IndexOf("no permission") >= 0 Then
                    lvwMovieLog.Items.Add("File " + remotePath + _
                    " was going to be downloaded but no permission to download")
                    lvwItem.SubItems(1).Text() = "No permission"
                    lvwItem.ForeColor = Color.Red

                    filesLeftToDownload -= 1
                    If filesLeftToDownload = 0 Then
                        tbxFilesLeft.Text = ""
                    Else
                        tbxFilesLeft.Text = filesLeftToDownload.ToString
                    End If

                    Exit Sub
                End If


                'End While
                'parentRef.lbxResponse.Items.Add(" ")
                FTPLogString = ""
                DownloadOK = False
            End Try

            If Not DownloadOK Then
                'Cancel button might have been pressed
                If DownloadActive = True Then
                    sbStatus.Panels(0).Text = "Trying to login again"
                    Ftp2.AbortTransfer()
                    Ftp2Close()
                    SaveListViewToFile()
                    ReportSpecialError = True
                    CancelDownloadRequested = True
                    TryToLoginToFTP()
                    Exit Sub
                End If
            End If

            checkFileInfo = New FileInfo(downloadlocalpath)
            If File.Exists(downloadlocalpath) Then
                If fileSize > checkFileInfo.Length Then

                    'If we get here because of an interrupted download lvwitem will
                    'not point to the right item. The stopdownload sub has read through
                    'all items in listview and points to the end. So we use a saved pointer.
                    sizeToDownload = fileSize - checkFileInfo.Length
                    cstring = Format(CLng(sizeToDownload), "###,###,###,###,###")

                    lvwStatus.Items(lvwItemIndex).SubItems(0).Text() = cstring

                    If ThisIsANewFile Then
                        cstring2 = Format(CLng(checkFileInfo.Length), "###,###,###,###,###")
                        lvwStatus.Items(lvwItemIndex).SubItems(7).Text() = cstring2

                        lvwStatus.Items(lvwItemIndex).SubItems(8).Text() = onlyDirectoryPath
                    End If

                    'parentRef.lbxResponse.Items.Add("File " + downloadlocalpath + _
                    '" has not been completely downloaded")
                    'parentRef.lbxResponse.Items.Add("Full file size is " + fileSize.ToString + _
                    '" but found a filesize of " + checkFileInfo.Length.ToString)

                Else
                    lvwItem.SubItems(1).Text() = "File downloaded"
                    lvwItem.ForeColor = Color.ForestGreen
                    downloadCount += 1

                    filesLeftToDownload -= 1
                    If filesLeftToDownload = 0 Then
                        tbxFilesLeft.Text = ""
                    Else
                        tbxFilesLeft.Text = filesLeftToDownload.ToString
                    End If

                    If htOptions.Item("sound") = "on" Then
                        If htOptions.ContainsKey("soundmoviedownloaded") Then
                            If htOptions.Item("soundmoviedownloaded") <> "" Then
                                soundClip = htOptions.Item("soundmoviedownloaded")
                                playSoundClip()
                            End If
                        End If
                    End If

                End If

                totalBytesDownloadedSoFar = totalBytesDownloadedSoFar + fileSize
                'Showing the progress of totally downloaded bytes in second progressbar
                spbTotal.Value = (totalBytesDownloadedSoFar / totalNumberOfBytesToDownload) * 100
                spbTotal.Update()

                'If download has been done, insert info about downloaded file into database
                insertFileinfoIntoDatabase()

            Else
                'parentRef.lbxResponse.Items.Add("File " + downloadlocalpath + _
                '" was going to be downloaded but can't be found")
            End If

        End If

        sbStatus.progressBar.Value = 0
        sbStatus.progressBar.Update()

        cbDownloadSpeed.Text = ""
        tbxTimeToComplete.Text = ""

    End Sub


    Private Sub insertFileinfoIntoDatabase()

        Dim result As Integer
        Dim save_Filepath As String

        Try
            If myConnection Is Nothing Then
                OpenConnectionToDatabase()
            End If

            save_Filepath = checkFileInfo.DirectoryName.Replace("\", "\\")
            searchFilename = checkFileInfo.Name.Replace("'", "\'")

            mySQLCommandString = "INSERT INTO " + collectionTablename + _
            " SET filename='" + searchFilename + "'," + _
            " filesize = '" + checkFileInfo.Length.ToString + "'," + _
            " filepath = '" + save_Filepath + "'," + _
            " filetime = '" + checkFileInfo.LastWriteTime.Ticks.ToString() + "'," + _
            " fileMD5 = '" + MD5hashstring + "';"

            myCommand.CommandText = mySQLCommandString

            result = myCommand.ExecuteNonQuery()

            If result < 1 Then
                lvwMovieLog.Items.Add("Insert into database failed of " + _
                    checkFileInfo.Name)
            End If

        Catch ex As MySqlException
            lvwMovieLog.Items.Add("MySQLException :" + ex.Message)
            lvwMovieLog.Items.Add("CommandString :" + mySQLCommandString)
        Catch ex As System.Net.Sockets.SocketException
            'Port errors
            lvwMovieLog.Items.Add("SocketException :" + ex.Message)
            lvwMovieLog.Items.Add("CommandString :" + mySQLCommandString)
        Catch ex As Exception
            'Syntax errors
            lvwMovieLog.Items.Add("Exception :" + ex.Message)
            lvwMovieLog.Items.Add("CommandString :" + mySQLCommandString)
        End Try

    End Sub


    Private Sub FillMD5HashTableCollection()
        htMD5.Clear()

        WCFListStreamReader = New StreamReader(SystemCollectionFile)

        MoreToReadFromWCF = True

        Dim fieldSplit2 As String()
        Dim savedFileSize As Long

        'WCFListRecord
        'file name
        'file size
        'directory name
        'file time
        'MD5 checksum

        GetNextWCFListRecord()
        Do While (MoreToReadFromWCF)
            If WCFListRecord.Length > 0 Then
                fieldSplit = WCFListRecord.Split(FieldDelimiter)

                If htMD5.ContainsKey(fieldSplit(4)) Then
                    fieldSplit2 = htMD5.Item(fieldSplit(4)).Split(FieldDelimiter)
                    savedFileSize = CLng(fieldSplit2(1))

                    If fileSize > savedFileSize Then
                        Dim RemoveMD5OK As Boolean
                        RemoveMD5OK = True
                        Try
                            htMD5.Remove(fieldSplit(4))
                        Catch ex As Exception
                            RemoveMD5OK = False
                            lvwMovieLog.Items.Add("Couldn't remove record from hashtable htMD5. Error:" + _
                                ex.ToString)
                        End Try
                        If RemoveMD5OK Then
                            Try
                                htMD5.Add(fieldSplit(4), WCFListRecord)
                            Catch ex As Exception
                                lvwMovieLog.Items.Add("Couldn't add record to hashtable htMD5 after " + _
                                    "successful remove of previous entry. Error:" + _
                                    ex.ToString)
                            End Try
                        End If
                    End If
                Else
                    Try
                        htMD5.Add(fieldSplit(4), WCFListRecord)
                    Catch ex As Exception
                        lvwMovieLog.Items.Add("Couldn't add record to hashtable htMD5. Error:" + _
                            ex.ToString)
                    End Try
                End If

            End If

            GetNextWCFListRecord()
        Loop

        WCFListStreamReader.Close()

    End Sub


    Private Sub FillMD5HashTableAvoidCollection()
        htAvoidMD5.Clear()

        WCFListStreamReader = New StreamReader(SystemAvoidCollectionFile)

        MoreToReadFromWCF = True

        Dim fieldSplit2 As String()
        Dim savedFileSize As Long

        'WCFListRecord
        'file name
        'file size
        'directory name
        'file time
        'MD5 checksum

        GetNextWCFListRecord()
        Do While (MoreToReadFromWCF)
            If WCFListRecord.Length > 0 Then
                fieldSplit = WCFListRecord.Split(FieldDelimiter)

                If htAvoidMD5.ContainsKey(fieldSplit(4)) Then
                    fieldSplit2 = htAvoidMD5.Item(fieldSplit(4)).Split(FieldDelimiter)
                    savedFileSize = CLng(fieldSplit2(1))

                    If fileSize > savedFileSize Then
                        Dim RemoveMD5OK As Boolean
                        RemoveMD5OK = True
                        Try
                            htAvoidMD5.Remove(fieldSplit(4))
                        Catch ex As Exception
                            RemoveMD5OK = False
                            lvwMovieLog.Items.Add("Couldn't remove record from hashtable htAvoidMD5. Error:" + _
                                ex.ToString)
                        End Try
                        If RemoveMD5OK Then
                            Try
                                htAvoidMD5.Add(fieldSplit(4), WCFListRecord)
                            Catch ex As Exception
                                lvwMovieLog.Items.Add("Couldn't add record to hashtable htAvoidMD5 after " + _
                                    "successful remove of previous entry. Error:" + _
                                    ex.ToString)
                            End Try
                        End If
                    End If
                Else
                    Try
                        htAvoidMD5.Add(fieldSplit(4), WCFListRecord)
                    Catch ex As Exception
                        lvwMovieLog.Items.Add("Couldn't add record to hashtable htAvoidMD5. Error:" + _
                            ex.ToString)
                    End Try
                End If

            End If

            GetNextWCFListRecord()
        Loop

        WCFListStreamReader.Close()

    End Sub


    Public Sub SaveListViewToFile()

        Dim moviesToDownloadCount As Integer
        moviesToDownloadCount = 0

        If lvwStatus.Items.Count > 0 Then

            Dim HandleOK As Boolean = True

            Try
                DownloadListStreamWriter = New StreamWriter(listDirectory + "\" + "DownloadList.txt")
            Catch ex As Exception
                HandleOK = False
                lvwMovieLog.Items.Add("Couldnt open DownloadList.txt for save." + ex.ToString)
            End Try

            If HandleOK Then
                For Each lvwItem In lvwStatus.Items

                    If lvwItem.SubItems(1).Text = "On queue" Then
                        moviesToDownloadCount += 1
                    End If

                    DownloadListRecord = lvwItem.SubItems(0).Text + FieldDelimiter + _
                    lvwItem.SubItems(1).Text + FieldDelimiter + _
                    lvwItem.SubItems(2).Text + FieldDelimiter + _
                    lvwItem.SubItems(3).Text + FieldDelimiter + _
                    lvwItem.SubItems(4).Text + FieldDelimiter + _
                    lvwItem.SubItems(5).Text + FieldDelimiter + _
                    lvwItem.SubItems(6).Text + FieldDelimiter + _
                    lvwItem.SubItems(7).Text + FieldDelimiter + _
                    lvwItem.SubItems(8).Text + FieldDelimiter
                    DownloadListStreamWriter.WriteLine(DownloadListRecord)
                Next
                DownloadListStreamWriter.Close()
            End If

        End If

        lvwMovieLog.Items.Add("DownloadList.txt saved")

        If moviesToDownloadCount = 0 Then
            parentRef.btnStartDownload.Text = "Download movies"
        Else
            parentRef.btnStartDownload.Text = "Download " + _
            moviesToDownloadCount.ToString + " movies"
        End If

    End Sub


    Public Sub LoadDownLoadListInListView()
        'Load list in listview

        sbStatus.Panels(0).Text = "Reading filelist"

        Dim recordCount As Integer = 0

        ReDim arrSize(-1)
        ReDim arrRecord(-1)

        lvwStatus.Items.Clear()

        DownloadListStreamReader = New StreamReader(listDirectory + "\" + "DownloadList.txt")

        MoreRecordsToRead = True

        GetNextDownloadListRecord()
        Do While (MoreRecordsToRead)

            'Extract size which will be used as sorting key
            fieldSplit = DownloadListRecord.Split(FieldDelimiter)

            'Empty lines at end of list
            If fieldSplit.Length = 1 Then
                Exit Do
            End If

            fileSizeOfDownload = CLng(fieldSplit(0))

            ReDim Preserve arrSize(recordCount)
            arrSize(recordCount) = fileSizeOfDownload

            ReDim Preserve arrRecord(recordCount)
            arrRecord(recordCount) = DownloadListRecord

            recordCount += 1
            GetNextDownloadListRecord()
        Loop

        DownloadListStreamReader.Close()

        'Only sort when list is new, then we might want to rearrange lines
        If FirstTimeSortOfList = True Then
            Array.Sort(arrSize, arrRecord)
        End If

        MoveArrayToListview()

    End Sub


    Private Sub MoveArrayToListview()

        sbStatus.Panels(0).Text = "Building display"

        totalNumberOfBytesToDownload = 0
        totalBytesDownloadedSoFar = 0

        filesLeftToDownload = 0

        For Each DownloadListRecord In arrRecord
            'Extract fields
            fieldSplit = DownloadListRecord.Split(FieldDelimiter)
            fileSizeOfDownload = CLng(fieldSplit(0))
            fileStatus = fieldSplit(1)
            fileName = fieldSplit(2)
            fileSize = CLng(fieldSplit(3))

            filePath = fieldSplit(4)

            fileMD5 = fieldSplit(5)
            fileLocalName = fieldSplit(6)
            fileLocalPath = fieldSplit(8)

            If fieldSplit(1) = "On queue" Then
                totalNumberOfBytesToDownload = totalNumberOfBytesToDownload + fileSize
                filesLeftToDownload += 1
            End If

            'Fill listview
            cstring = Format(CLng(fileSizeOfDownload), "###,###,###,###,###")
            lvwDuplicateItem = lvwStatus.Items.Add(cstring)
            lvwDuplicateItem.SubItems.Add(fileStatus)
            lvwDuplicateItem.SubItems.Add(fileName)
            cstring = Format(CLng(fileSize), "###,###,###,###,###")
            lvwDuplicateItem.SubItems.Add(cstring)
            lvwDuplicateItem.SubItems.Add(filePath)

            lvwDuplicateItem.SubItems.Add(fieldSplit(5))
            lvwDuplicateItem.SubItems.Add(fieldSplit(6))

            If fieldSplit(7) = "" Then
                lvwDuplicateItem.SubItems.Add("")
            Else
                cstring = Format(CLng(fieldSplit(7)), "###,###,###,###,###")
                lvwDuplicateItem.SubItems.Add(cstring)
            End If

            lvwDuplicateItem.SubItems.Add(fileLocalPath)

            If fieldSplit(1) = "File downloaded" Then
                lvwDuplicateItem.ForeColor = Color.ForestGreen
            Else
                If fieldSplit(1) = "Have file" Then
                    lvwDuplicateItem.ForeColor = Color.Red
                Else
                    If fieldSplit(1) = "Don't download" Then
                        lvwDuplicateItem.ForeColor = Color.Gray
                    Else
                        If fieldSplit(1) = "File missing" Then
                            lvwDuplicateItem.ForeColor = Color.Red
                        Else
                            If fieldSplit(1) = "No permission" Then
                                lvwDuplicateItem.ForeColor = Color.Red
                            End If
                        End If
                    End If
                End If
            End If

        Next

        If filesLeftToDownload = 0 Then
            tbxFilesLeft.Text = ""
        Else
            tbxFilesLeft.Text = filesLeftToDownload.ToString
        End If

        sbStatus.Panels(0).Text = """"

    End Sub


    Private Sub Getfileslefttodownload()
        'Counting how many files are left to download
        filesLeftToDownload = 0
        totalNumberOfBytesToDownload = 0
        Dim lvwEnumerator As IEnumerator = lvwStatus.Items.GetEnumerator
        While lvwEnumerator.MoveNext()
            lvwItem = lvwEnumerator.Current
            fileSizeOfDownload = CLng(lvwItem.SubItems(0).Text)
            fileStatus = lvwItem.SubItems(1).Text
            If lvwItem.SubItems(1).Text = "On queue" Then
                filesLeftToDownload += 1
                totalNumberOfBytesToDownload = totalNumberOfBytesToDownload + fileSizeOfDownload
            End If
        End While
    End Sub


    Private Sub ctxmenu_Popup(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ctxMenu.Popup
        ctxMenu.MenuItems.Clear()
        If TabControl1.SelectedTab.Text = "Log" Then
            ctxMenu.MenuItems.Add("Copy", New EventHandler(AddressOf CopyLogLinesToClipboard))
            ctxMenu.MenuItems.Add("Clear log", New EventHandler(AddressOf Clearlog))
        Else
            ctxMenu.MenuItems.Add("Move to top", New EventHandler(AddressOf ChangeStatusToMoveToTop))
            ctxMenu.MenuItems.Add("Move one step up", New EventHandler(AddressOf ChangeStatusToMoveOneStepUp))
            ctxMenu.MenuItems.Add("Move one step down", New EventHandler(AddressOf ChangeStatusToMoveOneStepDown))
            ctxMenu.MenuItems.Add("Move to bottom", New EventHandler(AddressOf ChangeStatusToMoveToBottom))
            ctxMenu.MenuItems.Add("Don't download", New EventHandler(AddressOf ChangeStatusToDontDownload))
            ctxMenu.MenuItems.Add("Download", New EventHandler(AddressOf ChangeStatusToDownload))
            ctxMenu.MenuItems.Add("Copy MD5 to clipboard", New EventHandler(AddressOf CopyMD5ToClipboard))
        End If
    End Sub

    Private Sub CopyLogLinesToClipboard(ByVal sender As System.Object, ByVal e As System.EventArgs)
        Dim indexes As ListView.SelectedIndexCollection = lvwMovieLog.SelectedIndices
        Dim indexToSelectedLine As Integer
        Dim selectedString As String = ""
        Dim selectCounter As Integer = 0
        For Each indexToSelectedLine In indexes
            selectedString = selectedString + _
            lvwMovieLog.Items(indexToSelectedLine).SubItems(0).Text + _
            CarriageReturn + LineFeed
            selectCounter += 1
        Next

        If selectCounter > 0 Then
            Clipboard.SetDataObject(selectedString)
        Else
            sbStatus.Panels(0).Text = "Select at least one line to copy to clipboard"
        End If

    End Sub


    Private Sub Clearlog(ByVal sender As System.Object, ByVal e As System.EventArgs)
        If TabControl1.SelectedTab.Text = "Log" Then
            lvwMovieLog.Items.Clear()
        End If
    End Sub


    'Context menu, right click in list
    Private Sub ChangeStatusToMoveToTop(ByVal sender As System.Object, ByVal e As System.EventArgs)
        sbStatus.Panels(0).Text = ""
        Dim indexes As ListView.SelectedIndexCollection = _
            lvwStatus.SelectedIndices
        Dim indexCounter As Integer
        Dim indexToSelectedLine As Integer
        indexCounter = indexes.Count

        While indexCounter > 0
            indexCounter -= 1
            lvwStatusChanged = True
            indexToSelectedLine = indexes(indexCounter)
            lvwDuplicateItem = lvwStatus.Items(indexToSelectedLine).Clone
            lvwStatus.Items(indexToSelectedLine).Remove()
            lvwStatus.Items.Insert(0, lvwDuplicateItem)
        End While
    End Sub

    Private Sub ChangeStatusToMoveOneStepUp(ByVal sender As System.Object, ByVal e As System.EventArgs)
        sbStatus.Panels(0).Text = ""
        Dim indexes As ListView.SelectedIndexCollection = _
            lvwStatus.SelectedIndices
        If indexes.Count > 1 Then
            sbStatus.Panels(0).Text = "Only one file can be moved one step up at a time"
        Else
            indexToSelectedLine = lvwStatus.SelectedIndices.Item(0)
            If indexToSelectedLine > 0 Then
                lvwStatusChanged = True
                lvwDuplicateItem = lvwStatus.Items(indexToSelectedLine).Clone
                lvwStatus.Items(indexToSelectedLine).Remove()
                lvwStatus.Items.Insert(indexToSelectedLine - 1, lvwDuplicateItem)
            End If
        End If
    End Sub

    Private Sub ChangeStatusToMoveOneStepDown(ByVal sender As System.Object, ByVal e As System.EventArgs)
        sbStatus.Panels(0).Text = ""
        Dim indexes As ListView.SelectedIndexCollection = _
            lvwStatus.SelectedIndices
        If indexes.Count > 1 Then
            sbStatus.Panels(0).Text = "Only one file can be moved one step down at a time"
        Else
            indexToSelectedLine = lvwStatus.SelectedIndices.Item(0)
            If (indexToSelectedLine + 1) < lvwStatus.Items.Count Then
                lvwStatusChanged = True
                lvwDuplicateItem = lvwStatus.Items(indexToSelectedLine).Clone
                lvwStatus.Items(indexToSelectedLine).Remove()
                lvwStatus.Items.Insert(indexToSelectedLine + 1, lvwDuplicateItem)
            End If
        End If
    End Sub

    Private Sub ChangeStatusToMoveToBottom(ByVal sender As System.Object, ByVal e As System.EventArgs)
        sbStatus.Panels(0).Text = ""
        Dim indexes As ListView.SelectedIndexCollection = _
            lvwStatus.SelectedIndices
        Dim indexCounter As Integer
        Dim indexToSelectedLine As Integer
        indexCounter = 0

        While indexCounter < indexes.Count
            indexToSelectedLine = indexes(indexCounter)
            lvwDuplicateItem = lvwStatus.Items(indexToSelectedLine).Clone
            lvwStatus.Items(indexToSelectedLine).Remove()
            lvwStatus.Items.Insert(lvwStatus.Items.Count, lvwDuplicateItem)
        End While
    End Sub

    Private Sub ChangeStatusToDontDownload(ByVal sender As System.Object, ByVal e As System.EventArgs)
        sbStatus.Panels(0).Text = ""
        Dim indexes As ListView.SelectedIndexCollection = _
            lvwStatus.SelectedIndices
        Dim indexToSelectedLine As Integer
        Dim thisDownloadSize As Long

        For Each indexToSelectedLine In indexes
            If lvwStatus.Items(indexToSelectedLine).SubItems(1).Text = "On queue" Then
                lvwStatus.Items(indexToSelectedLine).SubItems(1).Text = "Don't download"
                lvwStatus.Items(indexToSelectedLine).ForeColor = Color.Gray
                If lvwStatus.Items(indexToSelectedLine).SubItems(2).Text = fileName Then
                    Ftp2.AbortTransfer()
                End If

                filesLeftToDownload -= 1
                If filesLeftToDownload = 0 Then
                    tbxFilesLeft.Text = ""
                Else
                    tbxFilesLeft.Text = filesLeftToDownload.ToString
                End If

                thisDownloadSize = CLng(lvwStatus.Items(indexToSelectedLine).SubItems(0).Text)
                totalNumberOfBytesToDownload = totalNumberOfBytesToDownload - thisDownloadSize

            End If
        Next
    End Sub

    Private Sub ChangeStatusToDownload(ByVal sender As System.Object, ByVal e As System.EventArgs)
        'Download - changed mind about "Don't download" status
        sbStatus.Panels(0).Text = ""
        Dim indexes As ListView.SelectedIndexCollection = _
            lvwStatus.SelectedIndices
        Dim thisDownloadSize As Long

        Dim indexToSelectedLine As Integer

        For Each indexToSelectedLine In indexes
            If ((lvwStatus.Items(indexToSelectedLine).SubItems(1).Text = "Don't download") Or _
            (lvwStatus.Items(indexToSelectedLine).SubItems(1).Text = "No permission")) Then
                lvwStatus.Items(indexToSelectedLine).SubItems(1).Text = "On queue"
                lvwStatus.Items(indexToSelectedLine).ForeColor = Color.Black

                filesLeftToDownload += 1
                If filesLeftToDownload = 0 Then
                    tbxFilesLeft.Text = ""
                Else
                    tbxFilesLeft.Text = filesLeftToDownload.ToString
                End If

                thisDownloadSize = CLng(lvwStatus.Items(indexToSelectedLine).SubItems(0).Text)
                totalNumberOfBytesToDownload = totalNumberOfBytesToDownload + thisDownloadSize

            End If
        Next
    End Sub

    Private Sub CopyMD5ToClipboard(ByVal sender As System.Object, ByVal e As System.EventArgs)
        Dim indexes As ListView.SelectedIndexCollection = lvwStatus.SelectedIndices
        Dim indexToSelectedLine As Integer
        Dim selectedString As String = ""
        Dim selectCounter As Integer = 0
        For Each indexToSelectedLine In indexes
            If selectCounter = 0 Then
                selectedString = selectedString + _
                lvwStatus.Items(indexToSelectedLine).SubItems(5).Text
                selectCounter += 1
            End If
        Next

        If selectCounter > 0 Then
            Clipboard.SetDataObject(selectedString)
        Else
            sbStatus.Panels(0).Text = "Select one line to copy MD5 to clipboard"
        End If

    End Sub

    Private Sub InitializeExtendedStatusBar()

        'TODO Problems to insert and position extra panels, can it be fixed?

        Dim sbText = New System.Windows.Forms.StatusBarPanel
        Dim sbProgress = New System.Windows.Forms.StatusBarPanel

        sbText.AutoSize = _
           System.Windows.Forms.StatusBarPanelAutoSize.Spring
        sbProgress.Width = 200

        With sbStatus
            .Panels.Add(sbText)
            .Panels.Add(sbProgress)

            .ShowPanels = True

            'Initial settings for custom progressbar
            .setProgressBar = 1
            .progressBar.Minimum = 0
            .progressBar.Value = 0

            'Give a stylish look to this control which we don't use
            '.progressBar.BackColorStyle = SPB.SmoothProgressBar.ColorStyle.Gradient
            '.progressBar.BackGradientMode = Drawing2D.LinearGradientMode.Vertical
            '.progressBar.BackSigmaMode = SPB.SmoothProgressBar.SigmaMode.SigmaBell
            '.progressBar.BarColorStyle = SPB.SmoothProgressBar.ColorStyle.Gradient
            '.progressBar.BarGradientMode = Drawing2D.LinearGradientMode.Vertical
            '.progressBar.BarSigmaMode = SPB.SmoothProgressBar.SigmaMode.SigmaBell

            .progressBar.TabStop = False
            .progressBar.BorderStyle = BorderStyle.None

        End With

        Me.Controls.Add(sbStatus)

    End Sub


    Private Sub btnClearAllLists_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnClearAllLists.Click

        Dim msg As String
        Dim title As String
        Dim response As String
        Dim style As MsgBoxStyle

        title = "Confirm delete of download list"
        msg = "Are you sure you want to delete the download list?"
        style = MsgBoxStyle.OkCancel
        response = MsgBox(msg, style, title)
        If (response = MsgBoxResult.Ok) Then

            lvwStatus.Items.Clear()

            tbxFilesLeft.Text = ""
            tbxTimeToComplete.Text = ""
            cbDownloadSpeed.Text = ""
            spbTotal.Value = 0
            spbTotal.Update()

            If SystemDownloadDirectory <> "" And FTPServerName <> "" Then

                If Directory.Exists(listDirectory) Then
                    If File.Exists(listDirectory + "\" + "FTPList.txt") Then
                        Try
                            File.Delete(listDirectory + "\" + "FTPList.txt")
                        Catch ex As Exception
                        End Try
                    End If

                    If File.Exists(listDirectory + "\" + "DownloadList.txt") Then
                        Try
                            File.Delete(listDirectory + "\" + "DownloadList.txt")
                        Catch ex As Exception
                        End Try
                    End If

                End If
            End If

            btnDownload.Enabled = True
            btnClearAllLists.Enabled = False
            btnAnalyzeAgain.Enabled = False
            btnSearchFTPAgain.Enabled = False

            filesLeftToDownload = 0
            filesLeftToDownload = 0
            tbxFilesLeft.Text = ""

            sbStatus.Panels(0).Text = ""


        End If

    End Sub


    Private Sub tbxDownloadSpeed_doubleClick(ByVal sender As Object, ByVal e As System.EventArgs)
        '1 = Kb/s - kilobits per second
        '2 = KB/s - kilobytes per second
        '3 = MB/h - megabytes per hour
        typeOfSpeed += 1
        If typeOfSpeed > 3 Then
            typeOfSpeed = 1
        End If
    End Sub



    Private Sub Ftp2_Progress(ByVal sender As Object, ByVal e As Dart.PowerTCP.SecureFtp.FtpProgressEventArgs) Handles Ftp2.Progress
        'FtpProgressEventArgs.Length (which is the length of the currently 
        '   transferring file)
        'ProgressBar.Value will equal FtpProgressEventArgs.Position (which is 
        '   the marker within the file at which the transfer is occurring).
        '1 KB/s is equal to 8.19 Kbps
        'Kbps - kilobits per second
        'KB/s - kilobytes per second

        'If you are telling someone how fast your connection is use 
        '    metric or Bits per second (bps), Kilobits per second (Kbps), 
        '   Megabits per second (Mbps), Gigabits per second (Gbps).
        'If you are telling someone how fast a file transferred 
        '    use standard or Bytes per second (B/s), Kilobytes per second (KB/s), 
        '    Megabytes per second (MB/s), Gigabytes per second (GB/s).


        If CutForMD5hash Then
            'MD5 checksum download which will be aborted after the checksum has been downloaded
            If e.Position > minimumFileSize Then
                'Abort is a more abrupt alternative if this doesn't work
                Ftp2.AbortTransfer()
            Else
                downloadSpeed1 = (e.TransferRate / 1000) * 8.19
                cbDownloadSpeed.Items.Item(0) = downloadSpeed1.ToString + " Kb/s"
                downloadSpeed2 = (e.TransferRate / 1000)
                cbDownloadSpeed.Items.Item(1) = downloadSpeed2.ToString + " KB/s"
                downloadSpeed3 = ((e.TransferRate * 3600) \ 1000000)
                cbDownloadSpeed.Items.Item(2) = downloadSpeed3.ToString + " MB/h"
                Select Case cbDownloadSpeed.SelectedIndex
                    Case 0
                        cbDownloadSpeed.Text = downloadSpeed1.ToString + " Kb/s"
                    Case 1
                        cbDownloadSpeed.Text = downloadSpeed2.ToString + " KB/s"
                    Case 2
                        cbDownloadSpeed.Text = downloadSpeed3.ToString + " MB/h"
                End Select

                sbStatus.progressBar.Minimum = 0
                sbStatus.progressBar.Value = e.Position
                sbStatus.progressBar.Maximum = minimumFileSize
                sbStatus.progressBar.Update()
            End If
        Else
            downloadSpeed1 = (e.TransferRate / 1000) * 8.19
            cbDownloadSpeed.Items.Item(0) = downloadSpeed1.ToString + " Kb/s"
            downloadSpeed2 = (e.TransferRate / 1000)
            cbDownloadSpeed.Items.Item(1) = downloadSpeed2.ToString + " KB/s"
            downloadSpeed3 = ((e.TransferRate * 3600) \ 1000000)
            cbDownloadSpeed.Items.Item(2) = downloadSpeed3.ToString + " MB/h"
            Select Case cbDownloadSpeed.SelectedIndex
                Case 0
                    cbDownloadSpeed.Text = downloadSpeed1.ToString + " Kb/s"
                Case 1
                    cbDownloadSpeed.Text = downloadSpeed2.ToString + " KB/s"
                Case 2
                    cbDownloadSpeed.Text = downloadSpeed3.ToString + " MB/h"
            End Select

            bytesLeftToDownload = totalNumberOfBytesToDownload - totalBytesDownloadedSoFar

            If e.TransferRate > 0 Then
                'minutes to download = (byteslefttodownload \ bytes/sec) / 60
                timeToDownload = (bytesLeftToDownload \ e.TransferRate) / 60
                dHours = timeToDownload / 60
                dMinutes = timeToDownload Mod 60

                If dHours = 0 Then
                    If dMinutes = 1 Then
                        tbxTimeToComplete.Text = dMinutes.ToString + " minute"
                    Else
                        tbxTimeToComplete.Text = dMinutes.ToString + " minutes"
                    End If
                Else
                    tbxTimeToComplete.Text = dHours.ToString + "h " + _
                        dMinutes.ToString + "min"
                End If
            End If

            sbStatus.progressBar.Minimum = 0
            sbStatus.progressBar.Value = e.Position
            sbStatus.progressBar.Maximum = e.Length
            sbStatus.progressBar.Update()
        End If

    End Sub


    Private Sub Ftp2_Trace(ByVal sender As Object, ByVal e As Dart.PowerTCP.SecureFtp.SegmentEventArgs) Handles Ftp2.Trace
        'Dump command conversation with FTP to window
        FTPLogString = e.Segment.ToString
        Dim CRLFposition As Integer
        'Look for a CarriageReturn character and remove it and the linefeed following
        'Items.Add will take care of line breaks by itself
        CRLFposition = FTPLogString.IndexOf(CarriageReturn)
        If CRLFposition >= 0 Then
            FTPLogString = FTPLogString.Substring(0, CRLFposition)
        End If

        myListViewItem = lvwMovieLog.Items.Add(FTPLogString)
        myListViewItem.EnsureVisible()

        'Guarding against empty strings
        Try
            If IsNumeric(FTPLogString.Substring(0, 3)) Then
                If FTPLogString.Substring(0, 1) = "5" Then
                    myListViewItem.ForeColor = Color.Red
                Else
                    myListViewItem.ForeColor = Color.Green
                End If
            Else
                myListViewItem.ForeColor = Color.Blue
            End If
        Catch ex As Exception

        End Try

    End Sub


    Private Sub Ftp2_ConnectedChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles Ftp2.ConnectedChanged
        outputMessage = e.ToString()
        myListViewItem = lvwMovieLog.Items.Add(outputMessage)
        myListViewItem.EnsureVisible()
        myListViewItem.ForeColor = Color.Green
    End Sub


    Private Sub Ftp2Close()

        If Ftp2.Connected Then

            ' Close method returns an Invoke object
            Dim FTPSecureinvoke As Dart.PowerTCP.SecureFtp.Invoke

            Try
                FTPSecureinvoke = Ftp2.Close()
            Catch ex As Exception
                exceptionType = "Exception"
                FTPException(exceptionType, ex)
            End Try

            If Ftp2.Connected Then
                ' For some reason the Close method did not work. Just perform a harsh abort
                Ftp2.Dispose()
                outputMessage = "Unable to QUIT, connection aborted"
                myListViewItem = lvwMovieLog.Items.Add(outputMessage)
                myListViewItem.EnsureVisible()
                myListViewItem.ForeColor = Color.Red
            Else
                outputMessage = "Close successful."
                myListViewItem = lvwMovieLog.Items.Add(outputMessage)
                myListViewItem.EnsureVisible()
                myListViewItem.ForeColor = Color.Green
            End If
        Else
            lvwMovieLog.Items.Add("No need to close connection. It is not active.")
        End If

    End Sub


    Private Sub playSoundClip()
        If Not (modPlaySound.LoadMP3((soundClip)) = True) Then
            'parentRef.lbxResponse.Items.Add("Can't load  soundclip " + soundClip)
        Else
            If Not (modPlaySound.PlayMP3() = True) Then
                'parentRef.lbxResponse.Items.Add("Can't play  soundclip " + soundClip)
            End If
        End If
    End Sub


    Private Sub GetNextFTPListRecord()
        If (FTPListStreamReader.Peek() >= 0) Then
            FTPListRecord = FTPListStreamReader.ReadLine
        Else
            MoreRecordsToRead = False
        End If
    End Sub


    Private Sub GetNextWCFListRecord()
        If (WCFListStreamReader.Peek() >= 0) Then
            WCFListRecord = WCFListStreamReader.ReadLine
        Else
            MoreToReadFromWCF = False
        End If
    End Sub


    Private Sub GetNextDownloadListRecord()
        If (DownloadListStreamReader.Peek() >= 0) Then
            DownloadListRecord = DownloadListStreamReader.ReadLine
        Else
            MoreRecordsToRead = False
        End If
    End Sub


    'TODO - fix or delete
    'picturebox removed so have to fix gui to make is work, to begin with
    'would be good if image was in memory and not in tempofile
    Private Sub showExtractedPicture()
        'Number of seconds in stream
        Dim streamLength As Integer
        Dim streamMiddleLocation As Long
        Dim counter As Integer
        Dim bitMapInputName As String
        Dim bitMapOutputName As String
        Dim bitMapOutputDirectory As String
        Dim bitMapJPGOutputName As String

        'Keep bitmapimage in memory would be better

        bitMapInputName = ProgramDefaultDirectory + "\" + "tempofile"
        bitMapOutputDirectory = onlyDirectoryPath + "\" + "snaps"
        bitMapOutputName = bitMapOutputDirectory + "\" + fileName + ".bmp"

        'Check that output directory exists
        Dim DirectoryOK As Boolean = True
        Try
            If Not Directory.Exists(bitMapOutputDirectory) Then
                Directory.CreateDirectory(bitMapOutputDirectory)
            End If
        Catch ex As Exception
            DirectoryOK = False
        End Try

        If DirectoryOK Then
            Try
                md = New MediaDetClass
                'set mdFileName before calling this Sub
                md.Filename = bitMapInputName
                md.CurrentStream = 0
                streamLength = CInt(md.StreamLength)
                'Show a picture in the middle of the 250k start
                streamMiddleLocation = streamLength / 2
                'md.WriteBitmapBits(streamMiddleLocation, 320, 240, bitMapOutputName)
                md.WriteBitmapBits(streamMiddleLocation, 160, 120, bitMapOutputName)

                'TODO - have to activate this to make it start
                'PictureBox1.Image = New Bitmap(bitMapOutputName)

                'Keep and show if clicking on the line, can't delete anyway, locked
                'Try
                'System.IO.File.Delete(bitMapOutputName)
                'Catch ex As Exception
                'Can't delete file
                'End Try

                counter = 0
                While counter < streamLength
                    counter += 1

                    bitMapJPGOutputName = onlyDirectoryPath + "\" + "snaps" + "\" + fileName + _
                        "-" + counter.ToString
                    md.WriteBitmapBits(counter, 320, 240, bitMapJPGOutputName)
                    img = Image.FromFile(bitMapJPGOutputName)
                    img.Save(bitMapJPGOutputName + ".jpg", ImageFormat.Jpeg)
                    img.Dispose()
                    Try
                        System.IO.File.Delete(bitMapJPGOutputName)
                    Catch ex As Exception
                        'Can't delete file
                    End Try
                End While
            Catch ex As Exception
                'Couldn't create a picture
                'PictureBox1.Image.Dispose()
            End Try
        End If

    End Sub


    Public Sub TryToLoginToFTP()

        Dim loginThread As New Thread(New ThreadStart(AddressOf LoginLoop))
        loginThread.Start()
        Exit Sub

    End Sub


    Public Sub LoginLoop()

        Dim e As LoginEventArgs
        Dim excounter As Integer = 0
        Dim loginCount As Integer = 1

        Ftp2.Server = FTPServer
        Ftp2.Username = FTPUsername
        Ftp2.Password = FTPPassword
        Ftp2.ServerPort = FTPServerPort
        If FTPPassive Then
            Ftp2.Passive = True
        Else
            Ftp2.Passive = False
        End If
        Ftp2.DoEvents = True

        If useSSL Then
            'Here are the 2 commands needed to run the client in SSL mode
            ' "Disable" security checks
            Ftp2.UseAuthentication = False
            ' Set the desired security/authentication to explicit. 
            Ftp2.Security = Dart.PowerTCP.SecureFtp.Security.Explicit
        End If

        Dim partnerRetries As Integer
        partnerRetries = htOptions.Item("partnerretries")

        Dim partnerInterval As Integer
        partnerInterval = htOptions.Item("partnerinterval")

        counter = 0
        While counter < partnerRetries

            If CancelLoginRequested Then
                btnDownload.Text = "Start download"
                btnDownload.Enabled = True
                btnAnalyzeAgain.Enabled = True
                btnSearchFTPAgain.Enabled = True
                btnClearAllLists.Enabled = True
                sbStatus.Panels(0).Text = "Login attempts stopped"
                Exit Sub
            End If

            sbStatus.Panels(0).Text = "Attempt " + loginCount.ToString + _
                 " to login to FTP"

            outputMessage = "Attempt " + loginCount.ToString + _
                " to login to " + FTPServer
            myListViewItem = lvwMovieLog.Items.Add(outputMessage)
            myListViewItem.EnsureVisible()
            myListViewItem.ForeColor = Color.Green

            FTPLoginOK = True
            Try
                ' Send NoOp to force a logon 
                Ftp2.Invoke(Dart.PowerTCP.SecureFtp.FtpCommand.NoOp)
            Catch ex As System.Net.ProtocolViolationException
                FTPLoginOK = False
                exceptionType = "System.Net.ProtocolViolationException"
                FTPException(exceptionType, ex)
            Catch ex As System.Net.Sockets.SocketException
                FTPLoginOK = False
                exceptionType = "System.Net.Sockets.SocketException"
                FTPException(exceptionType, ex)
            Catch ex As Exception
                FTPLoginOK = False
                exceptionType = "Exception"
                FTPException(exceptionType, ex)
            End Try

            If FTPLoginOK Then
                'Success before time was up so we exit and boolean is correct
                e = New LoginEventArgs(True)
                RaiseEvent LoginEvent(Me, e)
                Exit Sub
            Else
                sbStatus.Panels(0).Text = "Attempt " + loginCount.ToString + _
                    " to login to FTP failed"

                outputMessage = "Attempt " + loginCount.ToString + _
                    " to login to " + FTPServer + " failed"
                myListViewItem = lvwMovieLog.Items.Add(outputMessage)
                myListViewItem.EnsureVisible()
                myListViewItem.ForeColor = Color.Red

                Thread.Sleep(partnerInterval * 1000)
            End If

            counter += 1
            loginCount += 1
        End While

        'Failed to login 
        e = New LoginEventArgs(False)
        RaiseEvent LoginEvent(Me, e)

        'Retrying to login to FTP didn't work
        'If ban requested, the other side is banned from own ftp
        If htOptions.ContainsKey("ftpban") Then
            If htOptions.Item("ftpban") = "yes" Then
                outputMessage = "Give user the bums rush"
                myListViewItem = lvwMovieLog.Items.Add(outputMessage)
                myListViewItem.EnsureVisible()
                myListViewItem.ForeColor = Color.Red
                giveUserTheBumsRush()
                sbStatus.Panels(0).Text = "Failed to login. Disabled user account " + _
                    FTPServerName
            End If
        End If


    End Sub


    Public Sub giveUserTheBumsRush()
        'Setup FTP server with events onEvery5minutes and onFileDownloaded
        'to reset the user.ini file with command "server.exe -reload"
        'This will have the effect to kick a user whose FTP stopped working

        Dim FTPuserfile As String
        Dim FTPuserfileOut As String
        Dim searchUserString As String
        Dim RecordChanged As Boolean

        RecordChanged = False

        Select Case serverType
            Case "BPFTP"
                FTPuserfile = htOptions.Item("ftpdirectory") + "\Users.ini"
                FTPuserfileOut = htOptions.Item("ftpdirectory") + "\Users-new.ini"
                searchUserString = "[" + FTPServerName + "]"
            Case "Gene6"
                FTPuserfile = htOptions.Item("ftpdirectory") + "\" + _
                   FTPServerName + ".ini"
                FTPuserfileOut = htOptions.Item("ftpdirectory") + "\" + _
                    FTPServerName + "-new.ini"
                searchUserString = "Enabled=-1"
            Case Else 'Default is BPFTP
                FTPuserfile = htOptions.Item("ftpdirectory") + "\Users.ini"
                FTPuserfileOut = htOptions.Item("ftpdirectory") + "\Users-new.ini"
                searchUserString = "[" + FTPServerName + "]"
        End Select

        FTPStreamReader = New StreamReader(FTPuserfile)
        FTPStreamWriter = New StreamWriter(FTPuserfileOut)

        MoreRecordsToRead = True

        GetNextFTPRecord()
        Do While (MoreRecordsToRead)
            Select Case serverType
                Case "BPFTP"
                    'Adding one line
                    FTPStreamWriter.WriteLine(FTPRecord)
                    FTPStreamWriter.Flush()
                    If (FTPRecord.IndexOf(searchUserString) >= 0) Then
                        FTPStreamWriter.WriteLine("Enabled=0")
                    End If
                Case "Gene6"
                    If RecordChanged Then
                        FTPStreamWriter.WriteLine(FTPRecord)
                        FTPStreamWriter.Flush()
                    Else
                        'Replacing line
                        If (FTPRecord.IndexOf(searchUserString) >= 0) Then
                            FTPStreamWriter.WriteLine("Enabled=0")
                            RecordChanged = True
                        Else
                            FTPStreamWriter.WriteLine(FTPRecord)
                            FTPStreamWriter.Flush()
                        End If
                    End If
                Case Else 'Default is BPFTP
                    'Adding one line
                    FTPStreamWriter.WriteLine(FTPRecord)
                    FTPStreamWriter.Flush()
                    If (FTPRecord.IndexOf(searchUserString) >= 0) Then
                        FTPStreamWriter.WriteLine("Enabled=0")
                    End If
            End Select

            GetNextFTPRecord()
        Loop

        FTPStreamReader.Close()
        FTPStreamWriter.Close()

        Try
            File.Copy(FTPuserfileOut, FTPuserfile, True)
        Catch ex As Exception
            outputMessage = "Failed to overwrite " + FTPuserfile + " with changes"
            myListViewItem = lvwMovieLog.Items.Add(outputMessage)
            myListViewItem.ForeColor = Color.Red

            outputMessage = "Error : " + ex.ToString
            myListViewItem = lvwMovieLog.Items.Add(outputMessage)
            myListViewItem.ForeColor = Color.Red
            Exit Sub
        End Try

        If serverType = "Gene6" Then
            Try
                File.Delete(FTPuserfileOut)
            Catch ex As Exception
                outputMessage = "Failed to delete " + FTPuserfileOut
                myListViewItem = lvwMovieLog.Items.Add(outputMessage)
                myListViewItem.ForeColor = Color.Red
                Exit Sub
            End Try
        End If


    End Sub


    Private Sub GetNextFTPRecord()
        If (FTPStreamReader.Peek() >= 0) Then
            FTPRecord = FTPStreamReader.ReadLine
        Else
            MoreRecordsToRead = False
        End If
    End Sub


    Class LoginEventArgs
        Inherits EventArgs
        Private boolean_LoginSucceeded As Boolean
        Public Sub New(ByVal LoginSucceeded As Boolean)
            boolean_LoginSucceeded = LoginSucceeded
        End Sub

        Public ReadOnly Property LoginSucceeded() As Boolean
            Get
                Return boolean_LoginSucceeded
            End Get
        End Property
    End Class


    Public Sub OnLoginEvent(ByVal sender As Object, ByVal e As LoginEventArgs)
        sbStatus.Panels(0).Text = "Automatic login succeeded :" + e.LoginSucceeded.ToString

        If e.LoginSucceeded Then
            DownloadActive = True
            CancelDownloadRequested = False

            btnDownload.Text = "Stop download"
            btnDownload.Enabled = True
            btnAnalyzeAgain.Enabled = False
            btnSearchFTPAgain.Enabled = False
            btnClearAllLists.Enabled = False

            StartDownloadJob()
        End If

    End Sub


    Private Sub OpenConnectionToDatabase()

        Try
            If Not myConnection Is Nothing Then
                myConnection.Close()
                myConnection.Dispose()
            End If

            outputMessage = "ConnectionString : " + myConnectionString
            myListViewItem = lvwMovieLog.Items.Add(outputMessage)
            myListViewItem.EnsureVisible()
            myListViewItem.ForeColor = Color.Blue
            myConnection = New MySqlConnection(myConnectionString)

            myConnection.Open()
            outputMessage = "Database opened"
            myListViewItem = lvwMovieLog.Items.Add(outputMessage)
            myListViewItem.EnsureVisible()
            myListViewItem.ForeColor = Color.Green

            outputMessage = "Data Source      : " + myConnection.DataSource
            myListViewItem = lvwMovieLog.Items.Add(outputMessage)
            myListViewItem.EnsureVisible()
            myListViewItem.ForeColor = Color.Green

            outputMessage = "Server Version   : " + myConnection.ServerVersion
            myListViewItem = lvwMovieLog.Items.Add(outputMessage)
            myListViewItem.EnsureVisible()
            myListViewItem.ForeColor = Color.Green

            outputMessage = "Current Database : " + myConnection.Database
            myListViewItem = lvwMovieLog.Items.Add(outputMessage)
            myListViewItem.EnsureVisible()
            myListViewItem.ForeColor = Color.Green

            outputMessage = "State            : " + myConnection.State.ToString
            myListViewItem = lvwMovieLog.Items.Add(outputMessage)
            myListViewItem.EnsureVisible()
            myListViewItem.ForeColor = Color.Green

        Catch ex As MySqlException
            lvwMovieLog.Items.Add("MySqlException. Message : " + ex.Message)
            myListViewItem.EnsureVisible()
            myListViewItem.ForeColor = Color.Red
        Catch ex As System.Net.Sockets.SocketException
            'Port errors
            lvwMovieLog.Items.Add("SocketException. Message : " + ex.Message)
            myListViewItem.EnsureVisible()
            myListViewItem.ForeColor = Color.Red
        Catch ex As Exception
            'Syntax errors
            lvwMovieLog.Items.Add("Exception. Message : " + ex.Message)
            myListViewItem.EnsureVisible()
            myListViewItem.ForeColor = Color.Red
        End Try

    End Sub


    Private Sub CloseConnectionToDatabase()

        Try
            If Not myConnection Is Nothing Then
                myConnection.Close()
                myConnection.Dispose()
                myConnection = Nothing

                outputMessage = "Connection to MySQL server closed"
                myListViewItem = lvwMovieLog.Items.Add(outputMessage)
                myListViewItem.EnsureVisible()
                myListViewItem.ForeColor = Color.Green

                outputMessage = ""
                myListViewItem = lvwMovieLog.Items.Add(outputMessage)
                myListViewItem.EnsureVisible()
            End If

        Catch ex As MySqlException
            lvwMovieLog.Items.Add("MySqlException. Message :" + ex.Message)
            myListViewItem.EnsureVisible()
            myListViewItem.ForeColor = Color.Red
        Catch ex As System.Net.Sockets.SocketException
            lvwMovieLog.Items.Add("SocketException. Message :" + ex.Message)
            myListViewItem.EnsureVisible()
            myListViewItem.ForeColor = Color.Red
        Catch ex As Exception
            lvwMovieLog.Items.Add("Exception. Message :" + ex.Message)
            myListViewItem.EnsureVisible()
            myListViewItem.ForeColor = Color.Red
        End Try

    End Sub


    Public Sub FTPException(ByVal exceptionType As String, ByVal ex As Exception)

        Select Case exceptionType
            Case "System.Net.ProtocolViolationException"
            Case "System.Net.Sockets.SocketException"
            Case "MySqlException"
            Case Else   'Exception'
        End Select

        exArray = ex.ToString.Split(LineFeed)
        excounter = 0
        While excounter < exArray.Length
            exString = exArray(excounter)
            exString = exString.Replace(CarriageReturn, " ")
            exString = exString.Replace(LineFeed, " ")
            If exString.Length < 2 Then
                Exit While
            End If

            myListViewItem = lvwMovieLog.Items.Add(exString)
            myListViewItem.EnsureVisible()
            myListViewItem.ForeColor = Color.Red

            excounter += 1
        End While

    End Sub


    'NOT IN USE
    ' Implements the manual sorting of items by columns.
    'How about integer sorting, some problem there ?????????????????
    Class ListViewItemComparer
        Implements IComparer

        Private col As Integer

        Public Sub New()
            col = 0
        End Sub

        Public Sub New(ByVal column As Integer)
            'Sorting on another column
            col = column
        End Sub

        'The sort
        Public Function Compare(ByVal x As Object, ByVal y As Object) As Integer _
           Implements IComparer.Compare
            'Objects are listviewitems

            Dim compareResult As Integer

            ' Treading objects as long 
            'Return [String].Compare(CType(x, ListViewItem).SubItems(col).Text, CType(y, ListViewItem).SubItems(col).Text)
            Dim longA As Long
            Dim longB As Long
            longA = CLng(x.Text)
            longB = CLng(y.Text)
            If longA < longB Then
                compareResult = -1
            Else
                If longA > longB Then
                    compareResult = 1
                Else
                    compareResult = 0
                End If
            End If

            Return compareResult

        End Function

        'This would be used to take care of sorting on columns by clicking on them
        ' ColumnClick event handler.
        'Private Sub ColumnClick(ByVal o As Object, ByVal e As ColumnClickEventArgs)
        ' Set the ListViewItemSorter property to a new ListViewItemComparer 
        ' object. Setting this property immediately sorts the 
        ' ListView using the ListViewItemComparer object.
        'Me.listView1.ListViewItemSorter = New ListViewItemComparer(e.Column)

    End Class


    Private Sub btnAnalyzeAgain_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnAnalyzeAgain.Click

        Dim checkAgainThread As New Thread(New ThreadStart(AddressOf CheckAgain))
        checkAgainThread.Start()
        Exit Sub


    End Sub


    Private Sub CheckAgain()

        Dim recordCount As Integer = 0

        sbStatus.Panels(0).Text = "Checking list again"

        'Count the list
        Dim lvwEnumerator As IEnumerator = lvwStatus.Items.GetEnumerator
        While lvwEnumerator.MoveNext()
            recordCount += 1
        End While

        listCount = 0

        lvwEnumerator = lvwStatus.Items.GetEnumerator
        While lvwEnumerator.MoveNext()

            listCount += 1
            sbStatus.Panels(0).Text = "Analyzing file " + listCount.ToString + _
                " of " + recordCount.ToString + " in list"

            lvwItem = lvwEnumerator.Current
            lvwItemIndex = lvwItem.Index

            fileStatus = lvwItem.SubItems(1).Text
            fileName = lvwItem.SubItems(2).Text
            fileSize = CLng(lvwItem.SubItems(3).Text)

            If fileStatus = "On queue" Then
                FileIsInteresting = True
                checkIfWeHaveFileAlreadyInDatabase()
                If Not FileIsInteresting Then
                    lvwItem.SubItems(1).Text() = "Have file"
                    lvwItem.ForeColor = Color.Red
                End If
            End If

        End While

        SaveListViewToFile()
        sbStatus.Panels(0).Text = ""

    End Sub


End Class
