Option Strict Off
Option Explicit On
Module modPlaySound

    Private DSAudio As QuartzTypeLib.IBasicAudio
    Private DSEvent As QuartzTypeLib.IMediaEvent
    Private DSControl As QuartzTypeLib.IMediaControl
    Public DSPosition As QuartzTypeLib.IMediaPosition
    Public DSEventEx As QuartzTypeLib.IMediaEventEx

    Private Const WM_APP As System.Int32 = &H0
    Private WM_GRAPHNOTIFY As System.Int32 = WM_APP + 1
    Private Const EC_COMPLETE As System.Int32 = &H1


    Public Function TerminateEngine() As Boolean
        On Error GoTo BailOut

        TerminateEngine = True
        Exit Function
BailOut:
        TerminateEngine = False
    End Function


    Public Function LoadMP3(ByRef FileName As String) As Boolean
        On Error GoTo BailOut

        If Not (TerminateEngine() = True) Then GoTo BailOut

        DSControl = New QuartzTypeLib.FilgraphManager
        Call DSControl.RenderFile(FileName)

        DSAudio = DSControl
        DSAudio.Volume = 0
        DSAudio.Balance = 0

        DSEvent = DSControl
        DSPosition = DSControl
        DSPosition.Rate = 1.0
        DSPosition.CurrentPosition = 0

        LoadMP3 = True
        Exit Function
BailOut:
        LoadMP3 = False
    End Function


    Public Function SetPlayBackSpeed(ByRef Speed As Single) As Boolean
        On Error GoTo BailOut

        SetPlayBackSpeed = True
        Exit Function
BailOut:
        SetPlayBackSpeed = False
    End Function


    Public Function SetPlayBackVolume(ByRef Volume As Integer) As Boolean
        On Error GoTo BailOut

        SetPlayBackVolume = True
        Exit Function
BailOut:
        SetPlayBackVolume = False
    End Function


    Public Function SetPlayBackBalance(ByRef Balance As Integer) As Boolean
        On Error GoTo BailOut

        SetPlayBackBalance = True
        Exit Function
BailOut:
        SetPlayBackBalance = False
    End Function


    Public Function PlayMP3() As Boolean
        On Error GoTo BailOut

        DSControl.Run()

        PlayMP3 = True
        Exit Function
BailOut:
        PlayMP3 = False
    End Function


    Public Function StopMP3() As Boolean
        On Error GoTo BailOut

        DSControl.Stop()
        DSPosition.CurrentPosition = 0 'set it back to the beginning

        StopMP3 = True
        Exit Function
BailOut:
        StopMP3 = False
    End Function


    Public Function PauseMP3() As Boolean
        On Error GoTo BailOut

        DSControl.Stop()

        PauseMP3 = True
        Exit Function
BailOut:
        PauseMP3 = False
    End Function


End Module