// ============================================================================
// This is a Servlet sample for the G-WAN Web Server (http://www.trustleap.com)
// ----------------------------------------------------------------------------
// factal.c: illustrating that 'hello world' was kinder to benchmark ASP.Net
//
//           Ruby, Io, PHP, Python, Lua, Java, Perl, Applescript, TCL, ELisp, 
//           Javascript, OCaml, Ghostscript and C++ benchmarks can be found
//           here: http://www.timestretch.com/FractalBenchmark.html
//
// ============================================================================
#include "xbuffer.h" // G-WAN dynamic buffers
#include "gwan.h"    // G-WAN exported functions

// Top of our HTML page
static char top[]=
     "<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\">"
     "<html lang=\"en\"><head><title>Benchmarking C</title><meta http-equiv"
     "=\"Content-Type\" content=\"text/html; charset=utf-8\">"
     "<link href=\"imgs/style.css\" rel=\"stylesheet\" type=\"text/css\">"
     "</head><body><h1>Benchmarking C</h1>";
// ----------------------------------------------------------------------------
int mandelbrot(char *str, int width, int height)
{
   char    *p=str, *q;
   int     wd2=width/2, hd2=height/2, x, y=-hd2, i;
   double  X, Y, cr, ci, zr, zi, temp, zr2, zi2;

   while(y++<hd2)
   {
      q=p+wd2;
      x=wd2;
      while(x--)
      {
         X  = (double)x/(double)wd2;
         Y  = (double)y/(double)hd2;
         cr = Y-0.5;
         ci = X;
         zi = 0.0;
         zr = 0.0;
         i  = 1000;

         while(i--)
         {
            temp = zr * zi;
            zr2  = zr * zr;
            zi2  = zi * zi;
            zr   = zr2  - zi2  + cr;
            zi   = temp + temp + ci;
            if(zi2 + zr2 > 16)
               break;
         }

         *p++ = *(q+x) = (i>=16)?'_':'#';
      }
      p+=wd2;
      q=p-4; *q++='<',*q++='b',*q++='r',*q++='>'; // HTML CRLF
   }
   *p=0; // close the zero-terminated string
}
// ----------------------------------------------------------------------------
// imported functions:
//   get_reply(): get a pointer on the 'reply' dynamic buffer from the server
//   set_reply(): send back the 'reply' dynamic buffer's pointer to the server
//    xbuf_cat(): like strcat(), but it works in the specified dynamic buffer 
// ----------------------------------------------------------------------------
int main(int argc, char *argv[])
{
   xbuf_ctx reply; get_reply(argv, &reply);

   // ---- format the top of our HTML page with a title
   xbuf_cat(&reply, top);
   
   // -------- time Mandelbrot calculations
   char buffer[4000];
   int  i=1, man=clock();
   while(i--)
      mandelbrot(buffer, 80, 40);

   man=clock()-man;

   // ---- write how many CPU cycles these operations took
   xbuf_xcat(&reply, "<br><table width=440px style=\"border:1px solid"
   " #cccccc; margin-left:20px; padding:5px 5px 5px 5px; text-align:right;\">"
   "<tr><th>code section</th><th>execution time (in miliseconds)</th></tr>"
   "<tr><td>Mandelbrot</td><td>%u</td></tr>"
   "</tr></table><table width=440px>"
   "</table><br><pre>%s</pre></body></html>", 
   man, buffer);

   set_reply(argv, &reply); return(200); // return an HTTP code (200:'OK')
}
// ============================================================================
// End of Source Code
// ============================================================================
