// ============================================================================
// This is a Servlet sample for the G-WAN Web Server (http://www.trustleap.com)
// ----------------------------------------------------------------------------
// getheaders.c: get the headers from a given URL and Web Server
//
//            May be handy to see what a web server is practicing. Here is the
//            output we got from apache.org:
//
//            HTTP/1.1 200 OK
//            Date: Wed, 13 May 2009 14:20:58 GMT
//            Server: Apache/2.2.9 (Unix)
//            Last-Modified: Thu, 16 Apr 2009 04:33:51 GMT
//            ETag: "17a484c-5686-467a4922469c0"
//            Accept-Ranges: bytes
//            Content-Length: 22150
//            Cache-Control: max-age=86400
//            Expires: Thu, 14 May 2009 14:20:58 GMT
//            Vary: Accept-Encoding
//            Connection: close
//            Content-Type: text/html
//
// ============================================================================
#include "xbuffer.h" // G-WAN dynamic buffers

// Title of our HTML page
static char title[]="Getting Headers";

// Top of our HTML page
static char top[]="<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\">"
     "<html lang=\"en\"><head><title>%s</title><meta http-equiv"
     "=\"Content-Type\" content=\"text/html; charset=utf-8\">"
     "<link href=\"imgs/style.css\" rel=\"stylesheet\" type=\"text/css\">"
     "</head><body><h1>%s</h1>";

// ----------------------------------------------------------------------------
// imported functions:
//   get_reply(): get a pointer on the 'reply' dynamic buffer from the server
//   set_reply(): send back the 'reply' dynamic buffer's pointer to the server
//  xbuf_reset(): (re)initiatize a dynamic buffer object
//  xbuf_frurl(): make an Http request, and store results in a dynamic buffer
//   xbuf_ncat(): like strncat(), but in the specified dynamic buffer 
//   xbuf_xcat(): formatted strcat() (a la printf) in a given dynamic buffer 
//   xbuf_free(): release the memory allocated for a dynamic buffer
// ----------------------------------------------------------------------------
// The Http methods we can use with xbuf_frurl()
static enum  s_Methods {HTTP_BAD=0, HTTP_GET, HTTP_HEAD, HTTP_PUT, HTTP_POST};

// ----------------------------------------------------------------------------
int main(int argc, char *argv[])
{
   int code=0;
   char *pHost="127.0.0.1", *pURL="/";
   xbuf_ctx buf;
   xbuf_reset(&buf);

   // create a dynamic buffer and get a pointer on the server response buffer
   xbuf_ctx reply; get_reply(argv, &reply);
   
   // ---- format the top of our HTML page with a title
   xbuf_xcat(&reply, top, title, title);

   // ---- write static text
   xbuf_cat(&reply, "<br>The reply of your HEAD request is:<br><br>");

   // ---- if no query parameters are provided, try "http://127.0.0.1/"
   if(argc<2)
   {
      get_arg("host=", &pHost, argc, argv);
      get_arg("url=",  &pURL,  argc, argv);
   }

   // ---- send the Http request (1000 ms timeout)
   code=xbuf_frurl(&buf, pHost, 80, HTTP_HEAD, pURL, 1000, 0);

   // ---- success (we can now use this data to write into our html page)
   if(code==200)
   {
      // Apache.org sends "\r" instead of "\r\n"
      while(xbuf_repl(&buf, "\r", "<br>"));
      xbuf_ncat(&reply, buf.ptr, buf.len);
   }
   else // failure
   {
      xbuf_xcat(&reply, "The request failed and returned: %u<br><br>%s", 
                        code,
                        (buf.len)?buf.ptr:"could not reach server<br>");
   }

   // ---- release memory
   xbuf_free(&buf);

   // ---- close our HTML page
   xbuf_xcat(&reply, "</body></html>");

   // confirm the reply's dynamic buffer address and size to the server
   // (they have changed when more memory is allocated during formatting)
   set_reply(argv, &reply); return(200); // return an HTTP code (200:'OK')
}
// ============================================================================
// End of Source Code
// ============================================================================
