// ============================================================================
// 
// gwan.h: functions exported by G-WAN and made available to C servlets
//
// ----------------------------------------------------------------------------
//
//                          PROPRIETARY INFORMATION
//   This software is supplied under the terms of a license agreement or
//   nondisclosure agreement with PIERRE GAUTHIER and may not be copied
//   or disclosed except in accordance with the terms of that agreement.
//     (c) Copyright 2007-2009 PIERRE GAUTHIER. All Rights Reserved.
//            http://www.trustleap.com   pierre@trustleap.com
//
// ============================================================================

#ifndef __SHORT_TYPES__
#define __SHORT_TYPES__

typedef   signed char       s8;
typedef unsigned char       u8;
typedef   signed short int s16;
typedef unsigned short int u16;
typedef   signed int       s32;
typedef unsigned int       u32;

#endif 

u32     cycles  (void);
//__int64 cycles64(void);
                  
void get_arg  (char *name, char **value, s32 argc, char *argv[]);
void get_reply(char *argv[], xbuf_ctx *reply);
void set_reply(char *argv[], xbuf_ctx *reply);
s32  get_env  (char *argv[], int name, char **inval);

u32  url_encode   (u8 *dst, u8 *src, u32 maxdstlen);
u32  escape_html  (u8 *dst, u8 *src, u32 size);
u32  unescape_html(u8 *str);
s32  html2txt     (u8 *html, u8 *text, s32 txlen);

int s_snprintf(char *str, u32 str_m, const char *fmt, ...);

struct tm {
  int tm_sec;     // seconds after the minute - [0,59] 
  int tm_min;     // minutes after the hour   - [0,59] 
  int tm_hour;    // hours since midnight     - [0,23] 
  int tm_mday;    // day of the month         - [1,31] 
  int tm_mon;     // months since January     - [0,11] 
  int tm_year;    // years since 1900 
  int tm_wday;    // days since Sunday        - [0,6] 
  int tm_yday;    // days since January 1     - [0,365] 
  int tm_isdst;   // daylight savings time flag 
};

u32        s_time     (void); // replace time(0);
struct tm *s_gmtime   (u32 t, struct tm *ts);
struct tm *s_localtime(u32 t, struct tm *y);
char      *s_asctime  (char *buf);
u32        rfc2time   (char *s);
char      *time2rfc   (u32 t, char *buf);

// ============================================================================
// End of Source Code
// ============================================================================
