// ============================================================================
// This is a Servlet sample for the G-WAN Web Server (http://www.trustleap.com)
// ----------------------------------------------------------------------------
// headers.c: build a complete HTTP reply -including custom response headers
//            (this may be mandatory for some applications)
//
//            You can insert new response headers to match your needs.
// ----------------------------------------------------------------------------
#include "xbuffer.h" // G-WAN dynamic buffers

// ----------------------------------------------------------------------------
// imported functions:
//   get_reply(): get a pointer on the 'reply' dynamic buffer from the server
//   set_reply(): send back the 'reply' dynamic buffer's pointer to the server
//  xbuf_reset(): (re)initiatize a dynamic buffer object
//   xbuf_xcat(): formatted strcat() (a la printf) in a given dynamic buffer 
//   xbuf_free(): release the memory allocated for a dynamic buffer
//     get_env(): get connection's 'environment' variables from the server:
// ----------------------------------------------------------------------------
enum HTTP_Env {
   REQUEST=0,      // char  *REQUEST;         // "GET / HTTP/1.1\r\n..."
   REQUEST_METHOD, // int    REQUEST_METHOD;  // 1=GET, 2=HEAD, 3=PUT, 4=POST
   QUERY_STRING,	 // char  *QUERY_STRING     // Request URL after '?'
   CONTENT_TYPE,   // int    CONTENT_TYPE;    // 1="x-www-form-urlencoded"
   CONTENT_LENGTH, // int    CONTENT_LENGTH;  // body length provided by client
   SESSION_ID,     // int    SESSION_ID;      // 12345678 (range: 0-4294967295)
   AUTH_TYPE,
   REMOTE_ADDR,    // char  *REMOTE_ADDR;     // "192.168.54.128"
   REMOTE_PORT,    // int    REMOTE_PORT;     // 1460 (range: 1024-65535)
   REMOTE_PROTOCOL,// int    REMOTE_PROTOCOL; // ((HTTP_major*1000)+HTTP_minor)
   REMOTE_USER,
   SERVER_SOFTWARE,// char  *SERVER_SOFTWARE  // "G-WAN/1.0.2"
   SERVER_NAME,    // char  *SERVER_NAME;     // "domain.com"
   SERVER_ADDR,    // char  *SERVER_ADDR;     // "192.168.10.14"
   SERVER_PORT,    // int    SERVER_PORT;     // 80 (443, 8080, etc.)
   SERVER_DATE,    // char  *SERVER_DATE;     // "Sun, 06 Nov 1994 08:49:37 GMT"
   SERVER_PROTOCOL,// int    SERVER_PROTOCOL; // ((HTTP_major*1000)+HTTP_minor)
   WWW_ROOT,       // char  *WWW_ROOT;        // the HTML pages root folder
   CSP_ROOT,       // char  *CSP_ROOT;        // the CSP .C files folder
};

// Title of our HTML page
static char title[]="Setting response headers";

// Top of our HTML page
static char top[]=
     "<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\">"
     "<html lang=\"en\"><head><title>%s</title><meta http-equiv"
     "=\"Content-Type\" content=\"text/html; charset=utf-8\">"
     "<link href=\"imgs/style.css\" rel=\"stylesheet\" type=\"text/css\">"
     "</head><body><h1>%s</h1>";

static char body[]="<br>Put your text here.<br></body></html>";

static char msk[]= "HTTP/1.1 %s\r\n"
                   "Date: %s\r\n"
                   "Last-Modified: %s\r\n"
                   "Content-type: text/html\r\n"
                   "Content-Length: %u\r\n"
                   // << insert your custom headers here
                   "Connection: close\r\n\r\n%s";
// ----------------------------------------------------------------------------
int main(int argc, char *argv[])
{
   char    *p="200 OK", *date;
   xbuf_ctx buf;
   xbuf_reset(&buf);

   // create a dynamic buffer and get a pointer on the server response buffer
   xbuf_ctx reply; get_reply(argv, &reply);

   // ---- format the top of our HTML page with a title
   xbuf_xcat(&buf, top, title, title);

   // ---- write static text (do whatever your application needs)
   xbuf_ncat(&buf, body, sizeof(body)-1);

   // ---- get the current HTTP date (like "Sun, 06 Nov 1994 08:49:37 GMT")
   get_env(argv, SERVER_DATE, &date);

   // ---- create response headers and append our HTML
   xbuf_xcat(&reply, msk, 
             p,            // "200 OK"
             date, date,   // "Sun, 06 Nov 1994 08:49:37 GMT"
             buf.len,      // "Content-Length: %u" (length of HTML)
             buf.ptr);     // HTML
   
   xbuf_free(&buf);

   // confirm the reply's dynamic buffer address and size to the server
   // (they have changed when more memory is allocated during formatting)
   set_reply(argv, &reply); return(200); // return an HTTP code (200:'OK')
}
// ============================================================================
// End of Source Code
// ============================================================================
