// ============================================================================
//
// xbuffer.h: a growing buffer, with handy functions
//
// ----------------------------------------------------------------------------
//
//                          PROPRIETARY INFORMATION
//   This software is supplied under the terms of a license agreement or
//   nondisclosure agreement with PIERRE GAUTHIER and may not be copied
//   or disclosed except in accordance with the terms of that agreement.
//     (c) Copyright 2007-2009 PIERRE GAUTHIER. All Rights Reserved.
//            http://www.trustleap.com   pierre@trustleap.com
//
// ============================================================================

typedef   signed char       s8;
typedef unsigned char       u8;
typedef   signed short int s16;
typedef unsigned short int u16;
typedef   signed int       s32;
typedef unsigned int       u32;

typedef struct _xbuf_ctx
{
	char *ptr;       // data buffer
	u32   allocated; // memory allocated
	u32   len;       // memory used
	u32   growby;    // memory increment
}xbuf_ctx;

void  xbuf_frfile  (xbuf_ctx *ctx, char *szFile);
void  xbuf_tofile  (xbuf_ctx *ctx, char *szFile);
u32   xbuf_growby  (xbuf_ctx *ctx, u32 len);
void  xbuf_empty   (xbuf_ctx *ctx);
char *xbuf_getend  (xbuf_ctx *ctx);
void  xbuf_attach  (xbuf_ctx *ctx, char *ptr, s32 size, s32 len);
char *xbuf_detach  (xbuf_ctx *ctx);
void  xbuf_free    (xbuf_ctx *ctx);
void  xbuf_clear   (xbuf_ctx *ctx);
void  xbuf_reset   (xbuf_ctx *ctx);
char *xbuf_ncat    (xbuf_ctx *ctx, char *pIn, s32 nInLength);
char *xbuf_cat     (xbuf_ctx *ctx, char *str);
char *xbuf_xcat    (xbuf_ctx *ctx, char *src, ...);
void  xbuf_sort    (xbuf_ctx *ctx, char Separator, s32 RemoveDuplicates);
s32   xbuf_findstr (xbuf_ctx *ctx, char *SearchValue);
s32   xbuf_repl    (xbuf_ctx *ctx, char *Search, char *New);
s32   xbuf_replfrto(xbuf_ctx *ctx, char *beg, char *end, char *Search, char *New);
void  xbuf_truncptr(xbuf_ctx *ctx, char *Ptr);
void  xbuf_trunclen(xbuf_ctx *ctx, s32 Len);
s32   xbuf_getln   (xbuf_ctx *ctx, char *pBuffer, s32 nSize);
s32   xbuf_pull    (xbuf_ctx *ctx, char *pBuffer, s32 nSize);
void  xbuf_delete  (xbuf_ctx *ctx, char *pos, s32 Len, char *bytes);
s32   xbuf_insert  (xbuf_ctx *ctx, char *pos, s32 Len, char *bytes);
s32   xbuf_http    (xbuf_ctx *ctx, s32 code, char *body);
s32   xbuf_frurl   (xbuf_ctx *ctx, char *host, u32 port, u32 method, char *uri, 
                    u32 mstimeout, char *params);
