/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.headertoolbar.actions;

import java.util.List;
import net.sf.jasperreports.components.headertoolbar.actions.EditColumnHeaderData;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.StandardColumn;
import net.sf.jasperreports.components.table.StandardTable;
import net.sf.jasperreports.components.table.util.TableUtil;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignStaticText;
import net.sf.jasperreports.engine.design.JRDesignTextElement;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.type.HorizontalAlignEnum;
import net.sf.jasperreports.engine.util.JRColorUtil;
import net.sf.jasperreports.web.commands.Command;

public class EditColumnHeaderCommand
implements Command {
    private StandardTable table;
    private EditColumnHeaderData editColumnHeaderData;
    private EditColumnHeaderData oldEditColumnHeaderData;
    private JRDesignTextElement textElement;
    private String oldText;

    public EditColumnHeaderCommand(StandardTable table, EditColumnHeaderData editColumnHeaderData) {
        this.table = table;
        this.editColumnHeaderData = editColumnHeaderData;
    }

    @Override
    public void execute() {
        List<BaseColumn> tableColumns = TableUtil.getAllColumns(this.table);
        StandardColumn column = (StandardColumn)tableColumns.get(this.editColumnHeaderData.getColumnIndex());
        this.textElement = TableUtil.getColumnHeaderTextElement(column);
        if (this.textElement != null) {
            this.oldEditColumnHeaderData = new EditColumnHeaderData();
            this.oldEditColumnHeaderData.setFontName(this.textElement.getFontName());
            this.oldEditColumnHeaderData.setFontSize(String.valueOf(this.textElement.getFontSize()));
            this.oldEditColumnHeaderData.setFontBold(this.textElement.isBold());
            this.oldEditColumnHeaderData.setFontItalic(this.textElement.isItalic());
            this.oldEditColumnHeaderData.setFontUnderline(this.textElement.isUnderline());
            this.oldEditColumnHeaderData.setFontColor(JRColorUtil.getColorHexa(this.textElement.getForecolor()));
            this.oldEditColumnHeaderData.setFontHAlign(this.textElement.getHorizontalAlignmentValue().getName());
            this.applyColumnHeaderData(this.editColumnHeaderData, this.textElement, true);
        }
    }

    private void applyColumnHeaderData(EditColumnHeaderData headerData, JRDesignTextElement textElement, boolean execute) {
        if (textElement instanceof JRDesignTextField) {
            JRDesignTextField designTextField = (JRDesignTextField)textElement;
            if (execute) {
                if (this.oldText == null) {
                    this.oldText = ((JRDesignExpression)designTextField.getExpression()).getText();
                }
                ((JRDesignExpression)designTextField.getExpression()).setText("\"" + headerData.getHeadingName() + "\"");
            } else {
                ((JRDesignExpression)designTextField.getExpression()).setText(this.oldText);
            }
        } else if (textElement instanceof JRDesignStaticText) {
            JRDesignStaticText staticText = (JRDesignStaticText)textElement;
            if (execute) {
                if (this.oldText == null) {
                    this.oldText = staticText.getText();
                }
                staticText.setText(headerData.getHeadingName());
            } else {
                staticText.setText(this.oldText);
            }
        }
        textElement.setFontName(headerData.getFontName());
        textElement.setFontSize(Integer.valueOf(headerData.getFontSize()));
        textElement.setBold(headerData.getFontBold());
        textElement.setItalic(headerData.getFontItalic());
        textElement.setUnderline(headerData.getFontUnderline());
        textElement.setForecolor(JRColorUtil.getColor("#" + headerData.getFontColor(), textElement.getForecolor()));
        textElement.setHorizontalAlignment(HorizontalAlignEnum.getByName(headerData.getFontHAlign()));
    }

    @Override
    public void undo() {
        if (this.oldEditColumnHeaderData != null) {
            this.applyColumnHeaderData(this.oldEditColumnHeaderData, this.textElement, false);
        }
    }

    @Override
    public void redo() {
        this.applyColumnHeaderData(this.editColumnHeaderData, this.textElement, true);
    }
}

