/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.googlecharts.jasper.geomap;

import java.awt.Color;
import java.util.List;
import net.sf.dynamicreports.googlecharts.jasper.geomap.GeoMapComponent;
import net.sf.dynamicreports.googlecharts.jasper.geomap.GeoMapFillDataset;
import net.sf.dynamicreports.googlecharts.jasper.geomap.GeoMapPrintElement;
import net.sf.dynamicreports.googlecharts.report.geomap.GeoMapDataMode;
import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.component.BaseFillComponent;
import net.sf.jasperreports.engine.component.FillPrepareResult;
import net.sf.jasperreports.engine.fill.JRFillElementDataset;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRTemplateGenericElement;
import net.sf.jasperreports.engine.fill.JRTemplateGenericPrintElement;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.util.JRStringUtil;

public class GeoMapFillComponent
extends BaseFillComponent {
    private GeoMapComponent geoMapComponent;
    private Boolean showLegend;
    private GeoMapDataMode dataMode;
    private String region;
    private String valueLabel;
    private List<Color> colors;
    private GeoMapFillDataset dataset;

    public GeoMapFillComponent(GeoMapComponent component, JRFillObjectFactory factory) {
        this.geoMapComponent = component;
        this.dataset = new GeoMapFillDataset(component.getDataset(), factory);
        factory.registerElementDataset((JRFillElementDataset)this.dataset);
    }

    protected GeoMapComponent getGeoMap() {
        return this.geoMapComponent;
    }

    public void evaluate(byte evaluation) throws JRException {
        if (this.isEvaluateNow()) {
            this.evaluateGeoMap(evaluation);
        }
    }

    private void evaluateGeoMap(byte evaluation) throws JRException {
        this.showLegend = this.geoMapComponent.getShowLegend();
        this.dataMode = this.geoMapComponent.getDataMode();
        this.region = JRStringUtil.getString((Object)this.fillContext.evaluate(this.geoMapComponent.getRegionExpression(), evaluation));
        this.valueLabel = JRStringUtil.getString((Object)this.fillContext.evaluate(this.geoMapComponent.getValueLabelExpression(), evaluation));
        this.colors = this.geoMapComponent.getColors();
        this.dataset.evaluateDatasetRun(evaluation);
        this.dataset.finishDataset();
    }

    private boolean isEvaluateNow() {
        return this.geoMapComponent.getEvaluationTime() == EvaluationTimeEnum.NOW;
    }

    public FillPrepareResult prepare(int availableHeight) {
        return FillPrepareResult.PRINT_NO_STRETCH;
    }

    public JRPrintElement fill() {
        JRComponentElement element = this.fillContext.getComponentElement();
        JRTemplateGenericElement template = new JRTemplateGenericElement(this.fillContext.getElementOrigin(), this.fillContext.getDefaultStyleProvider(), GeoMapPrintElement.GEOMAP_ELEMENT_TYPE);
        JRTemplateGenericPrintElement printElement = new JRTemplateGenericPrintElement(template, this.elementId);
        printElement.setX(element.getX());
        printElement.setY(this.fillContext.getElementPrintY());
        printElement.setWidth(element.getWidth());
        printElement.setHeight(element.getHeight());
        if (this.isEvaluateNow()) {
            this.copy((JRGenericPrintElement)printElement);
        } else {
            this.fillContext.registerDelayedEvaluation((JRPrintElement)printElement, this.geoMapComponent.getEvaluationTime(), this.geoMapComponent.getEvaluationGroup());
        }
        return printElement;
    }

    public void evaluateDelayedElement(JRPrintElement element, byte evaluation) throws JRException {
        this.evaluateGeoMap(evaluation);
        this.copy((JRGenericPrintElement)element);
    }

    private void copy(JRGenericPrintElement printElement) {
        printElement.setParameterValue("showLegend", (Object)this.showLegend);
        printElement.setParameterValue("dataMode", (Object)this.dataMode);
        printElement.setParameterValue("region", (Object)this.region);
        printElement.setParameterValue("valueLabel", (Object)this.valueLabel);
        printElement.setParameterValue("colors", this.colors);
        printElement.setParameterValue("dataset", this.dataset.getCustomDataset());
    }
}

