/*
 * Decompiled with CFR 0.152.
 */
package pnp.resthandler;

import java.sql.Date;
import java.util.ArrayList;
import pnp.resthandler.authenticationmanager.RestHandlerInterface;
import pnp.resthandler.converters.ObjectConverter;
import pnp.resthandler.converters.SubscriptionConverter;
import pnp.services.authenticationmanager.AuthenticationManagerServices;
import pnp.services.authenticationmanager.SubscriptionManager;
import pnp.services.datatypes.webservices.DBPassword;
import pnp.services.datatypes.webservices.EbayAccountTemp;
import pnp.services.datatypes.webservices.Ebayaccount;
import pnp.services.datatypes.webservices.PaypalAccountTemp;
import pnp.services.datatypes.webservices.Paypalaccount;
import pnp.services.datatypes.webservices.Permissions;
import pnp.services.datatypes.webservices.SubscriptionTemp;
import pnp.services.listener.GenericListener;
import pnp.services.listenermanager.ListenerManager;
import pnp.services.util.ErrorsUtil;

public class AuthenticationManagerServicesImpl
implements AuthenticationManagerServices {
    private String quickEncode(String variable) {
        if (null == variable) {
            return variable;
        }
        return DBPassword.getInstance().encryptPassword(variable, DBPassword.getInstance().getDBSecretKey());
    }

    public boolean createEbayAccount(EbayAccountTemp account) {
        boolean status = SubscriptionManager.getInstance().createEbayAccount(account);
        if (status) {
            this.communicate("createEbayAccount", account.getEbayToken(), account.getUsername(), null);
        }
        return status;
    }

    public ArrayList<EbayAccountTemp> getEbayAccounts() {
        return SubscriptionManager.getInstance().getEbayAccounts();
    }

    public boolean removeEbayAccount(String username) {
        boolean status = SubscriptionManager.getInstance().removeEbayAccount(username);
        if (status) {
            this.communicate("removeEbayAccount", username, null, null);
        }
        return status;
    }

    public void removeAllEbayAccounts() {
        SubscriptionManager.getInstance().removeAllEBayAccounts();
    }

    public Object communicate(String keyword, String argument1, String argument2, String argument3) {
        String userName = SubscriptionManager.getInstance().getUserName();
        String password = SubscriptionManager.getInstance().getPassword();
        Object response = null;
        if (null != userName && null != password && !userName.isEmpty() && !password.isEmpty()) {
            try {
                response = RestHandlerInterface.getInstance().communicate(this.quickEncode(userName), this.quickEncode(password), this.quickEncode(keyword), this.quickEncode(argument1), this.quickEncode(argument2), this.quickEncode(argument3));
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
                response = null;
            }
            if (response != null) {
                if (keyword.equalsIgnoreCase("createPaypalAccount")) {
                    response = SubscriptionConverter.convertXml((String)response);
                    this.createPaypalAccount((SubscriptionTemp)response);
                } else if (keyword.equalsIgnoreCase("createEbayAccount")) {
                    response = SubscriptionConverter.convertXml((String)response);
                    this.createEbayAccount((SubscriptionTemp)response);
                } else if (keyword.equalsIgnoreCase("validateSubscription")) {
                    response = SubscriptionConverter.convertXml((String)response);
                    this.validateSubscription((SubscriptionTemp)response);
                } else {
                    response = ObjectConverter.convertXml((String)response);
                }
            } else if (keyword.equalsIgnoreCase("validateSubscription")) {
                this.validateSubscription(new SubscriptionTemp());
            }
        }
        return response;
    }

    public void validateSubscription(SubscriptionTemp response) {
        SubscriptionManager newInstance = SubscriptionManager.getInstance();
        newInstance.setLicense(response.getLicense());
        newInstance.setCurrent(response.getCurrent().booleanValue());
        newInstance.setMessage(response.getMessage());
        if (!response.getCustomerUserName().equals("")) {
            for (Permissions permission : response.getPermissionsCollection()) {
                if (!permission.getEnabled().booleanValue()) continue;
                String orderManager = "Order Manager";
                String paypalManager = "PayPal Manager";
                String printManager = "Print Manager";
                String inventoryManager = "Inventory Manager";
                String financeManager = "Finance Manager";
                String multipleEbayUsers = "Multiple Third-Party Accounts";
                String websiteManager = "Website Manager";
                if (permission.getDatatypeID().getName().equals(financeManager)) {
                    newInstance.setFinancialsActive(true);
                    continue;
                }
                if (permission.getDatatypeID().getName().equals(inventoryManager)) {
                    newInstance.setInventoryActive(true);
                    continue;
                }
                if (permission.getDatatypeID().getName().equals(websiteManager)) {
                    newInstance.setWebsiteActive(true);
                    continue;
                }
                if (permission.getDatatypeID().getName().equals(multipleEbayUsers)) {
                    newInstance.setMultiActive(true);
                    continue;
                }
                if (permission.getDatatypeID().getName().equals(paypalManager)) {
                    newInstance.setPaypalActive(true);
                    continue;
                }
                if (!permission.getDatatypeID().getName().equals(printManager)) continue;
                newInstance.setPrintActive(true);
            }
            newInstance.setLicense(response.getLicense());
            newInstance.setExpire(new Date(response.getExpire().getTime()));
            SubscriptionManager.getInstance().removeAllEBayAccounts();
            for (Ebayaccount account : response.getEbayaccountCollection()) {
                SubscriptionManager.getInstance().createEbayAccount(new EbayAccountTemp(account.getUserToken(), account.getEbayAccountID()));
            }
            SubscriptionManager.getInstance().removeAllPaypalAccounts();
            for (Ebayaccount account : response.getPaypalaccountCollection()) {
                SubscriptionManager.getInstance().createPaypalAccount(new PaypalAccountTemp(account.getAccessToken(), account.getTokenSecret(), account.getPaypalAccountID()));
            }
            ListenerManager.getInstance().notify((GenericListener)ListenerManager.EBAY_ACCOUNT_LISTENER);
            ListenerManager.getInstance().notify((GenericListener)ListenerManager.PAYPAL_ACCOUNT_LISTENER);
        }
    }

    public void createEbayAccount(SubscriptionTemp response) {
        SubscriptionManager.getInstance().removeAllEBayAccounts();
        for (Ebayaccount account : response.getEbayaccountCollection()) {
            SubscriptionManager.getInstance().createEbayAccount(new EbayAccountTemp(account.getUserToken(), account.getEbayAccountID()));
        }
        ListenerManager.getInstance().notify((GenericListener)ListenerManager.EBAY_ACCOUNT_LISTENER);
    }

    public void createPaypalAccount(SubscriptionTemp response) {
        SubscriptionManager.getInstance().removeAllPaypalAccounts();
        for (Paypalaccount account : response.getPaypalaccountCollection()) {
            SubscriptionManager.getInstance().createPaypalAccount(new PaypalAccountTemp(account.getAccessToken(), account.getTokenSecret(), account.getPaypalAccountID()));
        }
        ListenerManager.getInstance().notify((GenericListener)ListenerManager.PAYPAL_ACCOUNT_LISTENER);
    }
}

