/*
 * Decompiled with CFR 0.152.
 */
package pnp.resthandler.converters;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.Date;
import pnp.services.datatypes.webservices.SubscriptionTemp;
import pnp.services.util.ErrorsUtil;

public class SubscriptionConverter {
    public static SubscriptionTemp convertXml(String xml) {
        SubscriptionTemp result = null;
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Date.class, (Object)new JsonDeserializer<Date>(){

            public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                Date newDate = null;
                try {
                    newDate = new Date(json.getAsJsonPrimitive().getAsLong());
                }
                catch (Exception ex) {
                    ErrorsUtil.getInstance().logError(ex);
                    try {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                        newDate = sdf.parse(json.getAsJsonPrimitive().getAsString());
                    }
                    catch (Exception ex1) {
                        ErrorsUtil.getInstance().logError(ex1);
                    }
                }
                return newDate;
            }
        });
        Gson gson = builder.create();
        Type subscriptionType = new TypeToken<SubscriptionTemp>(){}.getType();
        result = (SubscriptionTemp)gson.fromJson(xml, subscriptionType);
        return result;
    }
}

