/*
 * Decompiled with CFR 0.152.
 */
package pnp.resthandler.websites;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import pnp.services.util.ErrorsUtil;

public class InventoryClient {
    private WebResource webResource;
    private Client client;

    public InventoryClient(String uri) {
        DefaultClientConfig config = new DefaultClientConfig();
        this.client = Client.create((ClientConfig)config);
        this.webResource = this.client.resource(uri).path("entity.inventory");
    }

    public boolean edit_XML(Object requestEntity) throws UniformInterfaceException {
        boolean success = true;
        try {
            this.webResource.type("application/xml").put(requestEntity);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
            success = false;
        }
        return success;
    }

    public boolean edit_JSON(Object requestEntity) throws UniformInterfaceException {
        boolean success = true;
        try {
            this.webResource.type("application/json").put(requestEntity);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
            success = false;
        }
        return success;
    }

    public boolean addInventory_XML(Object requestEntity) throws UniformInterfaceException {
        boolean success = true;
        try {
            this.webResource.type("application/xml").put(requestEntity);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
            success = false;
        }
        return success;
    }

    public boolean addInventory_JSON(Object requestEntity) throws UniformInterfaceException {
        boolean success = true;
        try {
            this.webResource.type("application/json").post(requestEntity);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
            success = false;
        }
        return success;
    }

    public void close() {
        this.client.destroy();
    }
}

