/*
 * Decompiled with CFR 0.152.
 */
package pnp.resthandler.websites;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import java.text.MessageFormat;
import java.util.ArrayList;
import pnp.resthandler.converters.OrderDetailsConverter;
import pnp.resthandler.datatypes.Orderdetails;
import pnp.services.util.ErrorsUtil;
import pnp.services.util.GenericFunctions;

public class OrderDetailsClient {
    private WebResource webResource;
    private Client client;

    public OrderDetailsClient(String uri) {
        DefaultClientConfig config = new DefaultClientConfig();
        this.client = Client.create((ClientConfig)config);
        this.webResource = this.client.resource(uri).path("entity.orderdetails");
    }

    public void remove(String id) throws UniformInterfaceException {
        this.webResource.path(GenericFunctions.getInstance().fixWebsitePath(MessageFormat.format("{0}", id))).delete();
    }

    public <T> T findAll_XML(Class<T> responseType) throws UniformInterfaceException {
        try {
            WebResource resource = this.webResource;
            return (T)resource.accept(new String[]{"application/xml"}).get(responseType);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
            return null;
        }
    }

    public <T> T findAll_JSON(Class<T> responseType) throws UniformInterfaceException {
        try {
            WebResource resource = this.webResource;
            return (T)resource.accept(new String[]{"application/json"}).get(responseType);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
            return null;
        }
    }

    public void edit_XML(Object requestEntity) throws UniformInterfaceException {
        try {
            this.webResource.type("application/xml").put(requestEntity);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    public void edit_JSON(Object requestEntity) throws UniformInterfaceException {
        try {
            this.webResource.type("application/json").put(requestEntity);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    public <T> T findOrders_XML(Class<T> responseType, String id) throws UniformInterfaceException {
        try {
            WebResource resource = this.webResource;
            resource = resource.path(GenericFunctions.getInstance().fixWebsitePath(MessageFormat.format("{0}", id)));
            return (T)resource.accept(new String[]{"application/xml"}).get(responseType);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
            return null;
        }
    }

    public ArrayList<Orderdetails> findOrders_JSON(Integer id) throws UniformInterfaceException {
        try {
            int orderID = -1;
            try {
                if (id != null) {
                    orderID = Integer.parseInt(id.toString().replace(",", ""));
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
            if (orderID >= 0) {
                WebResource resource = this.webResource;
                resource = resource.path(GenericFunctions.getInstance().fixWebsitePath(MessageFormat.format("{0}", orderID)));
                String result = (String)resource.accept(new String[]{"application/json"}).get(String.class);
                return OrderDetailsConverter.convertXml(result);
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        return null;
    }

    public void create_XML(Object requestEntity) throws UniformInterfaceException {
        try {
            this.webResource.type("application/xml").post(requestEntity);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    public void create_JSON(Object requestEntity) throws UniformInterfaceException {
        try {
            this.webResource.type("application/json").post(requestEntity);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    public boolean updateOrderDetails_JSON(String transactionID, String shipDate, String tracking) throws UniformInterfaceException {
        boolean success = true;
        try {
            WebResource resource = this.webResource;
            resource = resource.path(MessageFormat.format("{0}&{1}&{2}", transactionID, shipDate, tracking));
            String result = (String)resource.accept(new String[]{"application/json"}).get(String.class);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
            success = false;
        }
        return success;
    }

    public void close() {
        this.client.destroy();
    }
}

