/*
 * Decompiled with CFR 0.152.
 */
package pnp.resthandler.websites;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import java.util.ArrayList;
import pnp.resthandler.converters.PromoCodesConverter;
import pnp.services.datatypes.webservices.Promocodes;
import pnp.services.util.ErrorsUtil;

public class PromoCodesClient {
    private WebResource webResource;
    private Client client;

    public PromoCodesClient(String uri) {
        DefaultClientConfig config = new DefaultClientConfig();
        this.client = Client.create((ClientConfig)config);
        this.webResource = this.client.resource(uri).path("entity.promocodes");
    }

    public void addPromoCode_JSON(Object requestEntity) throws UniformInterfaceException {
        try {
            this.webResource.type("application/json").post(requestEntity);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    public ArrayList<Promocodes> findAll_JSON() throws UniformInterfaceException {
        try {
            WebResource resource = this.webResource;
            String result = (String)resource.accept(new String[]{"application/json"}).get(String.class);
            return PromoCodesConverter.convertXml(result);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
            return null;
        }
    }

    public void close() {
        this.client.destroy();
    }
}

