/*
 * Decompiled with CFR 0.152.
 */
package pnp.resthandler.websites;

import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JOptionPane;
import pnp.resthandler.converters.CategoriesConverter;
import pnp.resthandler.converters.InventoryConverter;
import pnp.resthandler.converters.ItemsConverter;
import pnp.resthandler.converters.ProductsConverter;
import pnp.resthandler.converters.PromoCodesConverter;
import pnp.resthandler.datatypes.Categories;
import pnp.resthandler.datatypes.Inventory;
import pnp.resthandler.datatypes.Items;
import pnp.resthandler.datatypes.Orderdetails;
import pnp.resthandler.datatypes.OrderdetailsV2;
import pnp.resthandler.datatypes.Products;
import pnp.resthandler.websites.CategoriesClient;
import pnp.resthandler.websites.InventoryClient;
import pnp.resthandler.websites.ItemsClient;
import pnp.resthandler.websites.OrderDetailsClient;
import pnp.resthandler.websites.OrderDetailsClientV2;
import pnp.resthandler.websites.ProductsClient;
import pnp.resthandler.websites.PromoCodesClient;
import pnp.services.datatypes.Category;
import pnp.services.datatypes.CompleteOrder;
import pnp.services.datatypes.Customer;
import pnp.services.datatypes.Order;
import pnp.services.datatypes.OrderDetails;
import pnp.services.datatypes.OrderStatus;
import pnp.services.datatypes.webservices.Promocodes;
import pnp.services.datatypes.webservices.Website;
import pnp.services.datatypes.webservices.WebsiteCategories;
import pnp.services.datatypes.webservices.WebsiteProduct;
import pnp.services.listener.GenericListener;
import pnp.services.listener.WebsiteListListener;
import pnp.services.listenermanager.ListenerManager;
import pnp.services.manager.ManagerIF;
import pnp.services.util.ErrorsUtil;
import pnp.services.util.LookupServicesUtil;
import pnp.services.util.MathParser;

public class WebsiteClientManager
implements ManagerIF,
WebsiteListListener {
    private static WebsiteClientManager _instance;
    private final Object _lock = new Object();
    private OrderStatus _newStatus;
    private HashMap<Integer, WebsiteBundle> _websites = new HashMap();

    private WebsiteClientManager() {
        this._newStatus = new OrderStatus(0, "New");
        for (OrderStatus orderStatus : LookupServicesUtil.getDBServices().getOrderStatusList()) {
            if (!orderStatus.getOrderStatusType().equals("New")) continue;
            this._newStatus = orderStatus;
            break;
        }
        Website[] websites = LookupServicesUtil.getDBServices().getWebsites();
        for (int i = 0; i < websites.length; ++i) {
            if (websites[i].isWebsiteActive() && !this._websites.containsKey(websites[i].getWebsiteID())) {
                WebsiteBundle bundle = new WebsiteBundle(websites[i]);
                this._websites.put(websites[i].getWebsiteID(), bundle);
                continue;
            }
            if (websites[i].isWebsiteActive() || !this._websites.containsKey(websites[i].getWebsiteID())) continue;
            this._websites.remove(websites[i].getWebsiteID());
        }
        ListenerManager.getInstance().subscribe((GenericListener)this);
    }

    public void updateWebsiteProducts() {
        WebsiteProduct[] products = LookupServicesUtil.getDBServices().getWebsiteProductList().values().toArray(new WebsiteProduct[0]);
        LookupServicesUtil.getDBServices().refreshInventory("", true, true, true, false, new ArrayList().toArray(new String[0]), false);
        HashMap<Integer, String> categories = new HashMap<Integer, String>();
        Category[] categoryArray = LookupServicesUtil.getDBServices().getCategories();
        for (int i = 0; i < categoryArray.length; ++i) {
            categories.put(categoryArray[i].getCategoryID(), categoryArray[i].getCategoryName());
        }
        ArrayList<Items> itemsList = new ArrayList<Items>();
        ArrayList<Inventory> inventoryList = new ArrayList<Inventory>();
        ArrayList<Products> productList = new ArrayList<Products>();
        ArrayList<Categories> categoryList = new ArrayList<Categories>();
        for (int i = 0; i < products.length; ++i) {
            float calculatedWholesalePrice;
            if (!products[i].getWebsiteElement().isEnabled() || products[i].getItem().getItemName().length() <= 0 || products[i].getItem().isDiscontinued()) continue;
            String itemID = products[i].getItem().getItemID();
            if (itemID.contains("zen437")) {
                boolean catch3 = false;
            }
            float regularPrice = products[i].getWebsiteElement().getPriceRetail();
            float wholesalePrice = products[i].getWebsiteElement().getPrice();
            if (wholesalePrice < (calculatedWholesalePrice = LookupServicesUtil.getDBServices().getMaxWholesaleCost(itemID))) {
                wholesalePrice = calculatedWholesalePrice;
            }
            Items item = new Items();
            item.setItemID(itemID);
            item.setItemWeight(Float.valueOf(products[i].getItem().getItemWeight()));
            itemsList.add(item);
            Inventory inventory = new Inventory();
            String itemPrice = MathParser.isDollarAmount((String)String.valueOf(products[i].getInventoryElement().getItemCost()));
            if (null != itemPrice) {
                inventory.setItemCost(Float.valueOf(itemPrice));
            } else {
                inventory.setItemCost(Float.valueOf(0.0f));
            }
            inventory.setInventoryID(products[i].getInventoryElement().getInventoryID());
            inventory.setItemID(products[i].getInventoryElement().getItemID());
            inventory.setItemQuantity(products[i].getInventoryElement().getItemQuantity());
            inventory.setInStock(!products[i].getInventoryElement().isOosItem());
            inventoryList.add(inventory);
            Products product = new Products();
            product.setBriefDescription(products[i].getWebsiteElement().getBriefDescription());
            product.setCategory((String)categories.get(products[i].getWebsiteElement().getCategoryID()));
            product.setDescription(products[i].getWebsiteElement().getDescription());
            product.setEnabled(products[i].getWebsiteElement().isEnabled());
            product.setFeatured(products[i].getWebsiteElement().isFeatured());
            product.setItemID(products[i].getWebsiteElement().getItemID());
            product.setItemTitle(products[i].getItem().getItemName());
            product.setKeyWords(products[i].getWebsiteElement().getKeywords());
            product.setOem(products[i].getWebsiteElement().getOem());
            product.setPhoto1(products[i].getWebsiteElement().getPhoto1());
            product.setPhoto2(products[i].getWebsiteElement().getPhoto2());
            product.setPhoto3(products[i].getWebsiteElement().getPhoto3());
            product.setPrice(Float.valueOf(wholesalePrice));
            product.setPriceRetail(Float.valueOf(regularPrice));
            product.setThumbnail(products[i].getWebsiteElement().getThumbnail());
            productList.add(product);
        }
        WebsiteBundle[] websitesArray = this._websites.values().toArray(new WebsiteBundle[0]);
        for (int i = 0; i < websitesArray.length; ++i) {
            String xmlString;
            WebsiteCategories[] websiteCategories = LookupServicesUtil.getDBServices().getWebsiteCategories();
            categoryList.clear();
            for (int j = 0; j < websiteCategories.length; ++j) {
                if (websiteCategories[j].getWebsiteID() != websitesArray[i].getWebsite().getWebsiteID()) continue;
                Iterator categoryIter = websiteCategories[j].getCategories().iterator();
                while (categoryIter.hasNext()) {
                    Categories category = new Categories();
                    category.setCategoryID((Integer)categoryIter.next());
                    category.setCategoryName((String)categories.get(category.getCategoryID()));
                    category.setEnabled(true);
                    categoryList.add(category);
                }
            }
            try {
                xmlString = CategoriesConverter.convertToXml(categoryList);
                websitesArray[i].getCategoriesClient().addCategories_JSON(xmlString);
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
            try {
                xmlString = ItemsConverter.convertToXml(itemsList);
                websitesArray[i].getItemsClient().addItems_JSON(xmlString);
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
            try {
                xmlString = ProductsConverter.convertToXml(productList);
                websitesArray[i].getProductsClient().addProducts_JSON(xmlString);
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
            try {
                xmlString = InventoryConverter.convertToXml(inventoryList);
                websitesArray[i].getInventoryClient().addInventory_JSON(xmlString);
                continue;
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
    }

    public void updateOrderDetails(int websiteID, OrderDetails orderDetails) {
        WebsiteBundle websiteBundle = this._websites.get(websiteID);
        if (null != websiteBundle) {
            long shipDate = 0L;
            shipDate = null == orderDetails.getShipDate() ? System.currentTimeMillis() : orderDetails.getShipDate().getTime();
            if (!websiteBundle.getOrderDetailsClient().updateOrderDetails_JSON(orderDetails.getTransactionID(), String.valueOf(shipDate), orderDetails.getTrackingNumber())) {
                JOptionPane.showMessageDialog(null, "Problem communicating with website, please check connection. \n\nWebsite URI: " + websiteBundle.getWebsite().getWebsiteURI());
            }
        }
    }

    public void addPromoCode(Promocodes promocode) {
        WebsiteBundle[] websitesArray = this._websites.values().toArray(new WebsiteBundle[0]);
        for (int i = 0; i < websitesArray.length; ++i) {
            if (!websitesArray[i].getWebsite().getWebsiteName().contains("Bandaru")) continue;
            String xmlString = PromoCodesConverter.convertToXml(promocode);
            websitesArray[i].getPromoCodesClient().addPromoCode_JSON(promocode);
        }
    }

    public void getWebsiteTransactions() {
        WebsiteBundle[] websitesArray;
        HashMap<Integer, CompleteOrder> completeOrders = new HashMap<Integer, CompleteOrder>();
        ArrayList<Integer> orderDetailsParsed = new ArrayList<Integer>();
        for (WebsiteBundle websiteItem : websitesArray = this._websites.values().toArray(new WebsiteBundle[0])) {
            CompleteOrder[] orderArray;
            long lastOrderID = 0L;
            Website currentWebsite = websiteItem.getWebsite();
            if (currentWebsite.getWebsiteURI().toLowerCase().contains("bandaru")) {
                ArrayList<Orderdetails> orderDetailsList = websiteItem.getOrderDetailsClient().findOrders_JSON((int)currentWebsite.getLastUpdate());
                if (null == orderDetailsList) continue;
                lastOrderID = currentWebsite.getLastUpdate();
                for (Orderdetails orderdetails : orderDetailsList) {
                    orderDetailsParsed.add(orderdetails.getOrderDetailsID());
                    CompleteOrder completeOrder = (CompleteOrder)completeOrders.get(orderdetails.getOrderID().getOrderID());
                    if (lastOrderID < (long)orderdetails.getOrderID().getOrderID().intValue()) {
                        lastOrderID = orderdetails.getOrderID().getOrderID().intValue();
                    }
                    if (null == completeOrder) {
                        completeOrder = new CompleteOrder();
                        Order order = new Order();
                        Customer customer = LookupServicesUtil.getDBServices().getCustomerByEmail(orderdetails.getOrderID().getCustomerUserName().getCustomerEmail());
                        if (null == customer) {
                            customer = new Customer();
                            customer.setCustomerEmail(orderdetails.getOrderID().getCustomerUserName().getCustomerEmail());
                            customer.setCustomerUserName(orderdetails.getOrderID().getCustomerUserName().getCustomerUserName());
                        }
                        customer.setCustomerAddress(orderdetails.getOrderID().getCustomerUserName().getCustomerAddress());
                        customer.setCustomerCity(orderdetails.getOrderID().getCustomerUserName().getCustomerCity());
                        if (orderdetails.getOrderID().getCustomerUserName().getCustomerCountry().contains("United States")) {
                            customer.setCustomerCountry("United States");
                        } else {
                            customer.setCustomerCountry(orderdetails.getOrderID().getCustomerUserName().getCustomerCountry());
                        }
                        customer.setCustomerName(orderdetails.getOrderID().getCustomerUserName().getCustomerFirstName() + " " + orderdetails.getOrderID().getCustomerUserName().getCustomerLastName());
                        customer.setCustomerState(orderdetails.getOrderID().getCustomerUserName().getCustomerState());
                        customer.setCustomerZipcode(orderdetails.getOrderID().getCustomerUserName().getCustomerZipCode());
                        order.setCustomer(customer);
                        order.setOrderComments(orderdetails.getOrderID().getOrderComments());
                        order.setOrderDate(new Date(orderdetails.getOrderID().getOrderDate().getTime()));
                        order.setOrderStatus(this._newStatus);
                        order.setOrderTotal(orderdetails.getOrderID().getOrderTotal().floatValue());
                        order.setShippingCost(orderdetails.getOrderID().getShippingCost().floatValue());
                        order.setShippingMethodName(orderdetails.getOrderID().getShippingMethodID());
                        order.setShippingPaid(orderdetails.getOrderID().getShippingPaid().floatValue());
                        completeOrder.setOrder(order);
                        completeOrders.put(orderdetails.getOrderID().getOrderID(), completeOrder);
                    }
                    OrderDetails orderDetails = new OrderDetails();
                    orderDetails.setAccountName(currentWebsite.getWebsiteName());
                    orderDetails.setBackordered(orderdetails.getBackordered().booleanValue());
                    orderDetails.setCarrier(orderdetails.getCarrier());
                    orderDetails.setDeleted(orderdetails.getDeleted().booleanValue());
                    orderDetails.setInhouse(orderdetails.getInhouse().booleanValue());
                    orderDetails.setItemCost(orderdetails.getItemCost().floatValue());
                    orderDetails.setItemID(orderdetails.getItemID());
                    orderDetails.setOrderDescription(orderdetails.getOrderDescription());
                    orderDetails.setOrderNumber(orderdetails.getOrderNumber());
                    orderDetails.setSalesPrice(orderdetails.getSalesPrice().floatValue());
                    orderDetails.setTransactionID(orderdetails.getTransactionID());
                    completeOrder.getOrderDetails().add(orderDetails);
                }
                for (CompleteOrder orderArray1 : orderArray = completeOrders.values().toArray(new CompleteOrder[0])) {
                    LookupServicesUtil.getDBServices().updateOrder(orderArray1);
                }
                currentWebsite.setLastUpdate(lastOrderID);
                LookupServicesUtil.getDBServices().updateWebsite(currentWebsite);
                continue;
            }
            ArrayList<OrderdetailsV2> orderDetailsListV2 = websiteItem.getOrderDetailsClientV2().findOrders_JSON(0);
            if (null == orderDetailsListV2) continue;
            for (OrderdetailsV2 orderdetailsV2 : orderDetailsListV2) {
                orderDetailsParsed.add(orderdetailsV2.getOrderDetailsID());
                CompleteOrder completeOrder = (CompleteOrder)completeOrders.get(orderdetailsV2.getOrderID().getOrderID());
                if (null == completeOrder) {
                    completeOrder = new CompleteOrder();
                    Order order = new Order();
                    String email = "";
                    email = orderdetailsV2.getOrderID().getCustomerUserName() != null && orderdetailsV2.getOrderID().getCustomerUserName().getCustomerEmail() != null && !orderdetailsV2.getOrderID().getCustomerUserName().getCustomerEmail().isEmpty() ? orderdetailsV2.getOrderID().getCustomerUserName().getCustomerEmail() : orderdetailsV2.getOrderID().getOrderEmail();
                    Customer customer = LookupServicesUtil.getDBServices().getCustomerByEmail(email);
                    if (null == customer) {
                        customer = new Customer();
                        String customerUserName = orderdetailsV2.getOrderID().getCustomerUserName().getCustomerUserName();
                        if (email.contains("AUTOMATIC-WEBSITE")) {
                            customerUserName = email = email.trim().replace("AUTOMATIC-WEBSITE", "");
                        }
                        customer.setCustomerEmail(email);
                        customer.setCustomerUserName(customerUserName);
                    }
                    customer.setCustomerAddress(orderdetailsV2.getOrderID().getOrderAddress());
                    customer.setCustomerCity(orderdetailsV2.getOrderID().getOrderCity());
                    if (orderdetailsV2.getOrderID().getOrderCountry().contains("United States")) {
                        customer.setCustomerCountry("United States");
                    } else {
                        customer.setCustomerCountry(orderdetailsV2.getOrderID().getOrderCountry());
                    }
                    customer.setCustomerName(orderdetailsV2.getOrderID().getOrderFirstName() + " " + orderdetailsV2.getOrderID().getOrderLastName());
                    customer.setCustomerState(orderdetailsV2.getOrderID().getOrderState());
                    customer.setCustomerZipcode(orderdetailsV2.getOrderID().getOrderZipCode());
                    order.setCustomer(customer);
                    order.setOrderComments(orderdetailsV2.getOrderID().getOrderComments());
                    order.setOrderDate(new Date(orderdetailsV2.getOrderID().getOrderDate().getTime()));
                    order.setOrderStatus(this._newStatus);
                    order.setOrderTotal(orderdetailsV2.getOrderID().getOrderTotal().floatValue());
                    order.setShippingCost(orderdetailsV2.getOrderID().getShippingCost().floatValue());
                    order.setShippingMethodName(orderdetailsV2.getOrderID().getShippingMethodID());
                    order.setShippingPaid(orderdetailsV2.getOrderID().getShippingPaid().floatValue());
                    completeOrder.setOrder(order);
                    completeOrders.put(orderdetailsV2.getOrderID().getOrderID(), completeOrder);
                }
                OrderDetails orderDetails = new OrderDetails();
                orderDetails.setAccountName(currentWebsite.getWebsiteName());
                orderDetails.setBackordered(orderdetailsV2.getBackordered().booleanValue());
                orderDetails.setCarrier(orderdetailsV2.getCarrier());
                orderDetails.setDeleted(orderdetailsV2.getDeleted().booleanValue());
                orderDetails.setInhouse(orderdetailsV2.getInhouse().booleanValue());
                orderDetails.setItemCost(orderdetailsV2.getItemCost().floatValue());
                orderDetails.setItemID(orderdetailsV2.getItemID());
                orderDetails.setOrderDescription(orderdetailsV2.getOrderDescription());
                orderDetails.setOrderNumber(orderdetailsV2.getOrderNumber());
                orderDetails.setSalesPrice(orderdetailsV2.getSalesPrice().floatValue());
                orderDetails.setTransactionID(orderdetailsV2.getTransactionID());
                completeOrder.getOrderDetails().add(orderDetails);
            }
            for (CompleteOrder orderArray1 : orderArray = completeOrders.values().toArray(new CompleteOrder[0])) {
                LookupServicesUtil.getDBServices().updateOrder(orderArray1);
            }
            Iterator iterator = orderDetailsParsed.iterator();
            while (iterator.hasNext()) {
                int orderID = (Integer)iterator.next();
                websiteItem.getOrderDetailsClientV2().receivedOrders_JSON(orderID);
            }
            currentWebsite.setLastUpdate(0L);
            LookupServicesUtil.getDBServices().updateWebsite(currentWebsite);
        }
    }

    public static WebsiteClientManager getInstance() {
        if (null == _instance) {
            _instance = new WebsiteClientManager();
        }
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this._lock;
        synchronized (object) {
            WebsiteBundle[] websitesArray = this._websites.values().toArray(new WebsiteBundle[0]);
            for (int i = 0; i < websitesArray.length; ++i) {
                websitesArray[i].getCategoriesClient().close();
                websitesArray[i].getInventoryClient().close();
                websitesArray[i].getItemsClient().close();
                websitesArray[i].getOrderDetailsClient().close();
                websitesArray[i].getProductsClient().close();
            }
        }
    }

    public void websiteListUpdated() {
        Website[] websites = LookupServicesUtil.getDBServices().getWebsites();
        for (int i = 0; i < websites.length; ++i) {
            if (websites[i].isWebsiteActive() && !this._websites.containsKey(websites[i].getWebsiteID())) {
                WebsiteBundle bundle = new WebsiteBundle(websites[i]);
                this._websites.put(websites[i].getWebsiteID(), bundle);
                continue;
            }
            if (websites[i].isWebsiteActive() || !this._websites.containsKey(websites[i].getWebsiteID())) continue;
            this._websites.remove(websites[i].getWebsiteID());
        }
    }

    private class WebsiteBundle {
        private OrderDetailsClient _orderDetailsClient;
        private OrderDetailsClientV2 _orderDetailsClientV2;
        private InventoryClient _inventoryClient;
        private ItemsClient _itemsClient;
        private CategoriesClient _categoriesClient;
        private ProductsClient _productsClient;
        private PromoCodesClient _promocodesClient;
        private Website website;

        public WebsiteBundle(Website website) {
            this.website = website;
            this._orderDetailsClientV2 = new OrderDetailsClientV2(website.getWebsiteURI());
            this._orderDetailsClient = new OrderDetailsClient(website.getWebsiteURI());
            this._inventoryClient = new InventoryClient(website.getWebsiteURI());
            this._itemsClient = new ItemsClient(website.getWebsiteURI());
            this._productsClient = new ProductsClient(website.getWebsiteURI());
            this._categoriesClient = new CategoriesClient(website.getWebsiteURI());
            this._promocodesClient = new PromoCodesClient(website.getWebsiteURI());
        }

        public Website getWebsite() {
            return this.website;
        }

        public CategoriesClient getCategoriesClient() {
            return this._categoriesClient;
        }

        public InventoryClient getInventoryClient() {
            return this._inventoryClient;
        }

        public ItemsClient getItemsClient() {
            return this._itemsClient;
        }

        public OrderDetailsClient getOrderDetailsClient() {
            return this._orderDetailsClient;
        }

        public ProductsClient getProductsClient() {
            return this._productsClient;
        }

        public PromoCodesClient getPromoCodesClient() {
            return this._promocodesClient;
        }

        public OrderDetailsClientV2 getOrderDetailsClientV2() {
            return this._orderDetailsClientV2;
        }
    }
}

