/*
 * Decompiled with CFR 0.152.
 */
package pnp.comm.ebay;

import com.ebay.marketplace.search.v1.services.AckValue;
import com.ebay.marketplace.search.v1.services.FindItemsAdvancedRequest;
import com.ebay.marketplace.search.v1.services.FindItemsAdvancedResponse;
import com.ebay.marketplace.search.v1.services.FindingService;
import com.ebay.marketplace.search.v1.services.FindingServicePortType;
import com.ebay.marketplace.search.v1.services.PaginationInput;
import com.ebay.marketplace.search.v1.services.SearchItem;
import com.ebay.marketplace.search.v1.services.SortOrderType;
import com.ebay.sdk.ApiAccount;
import com.ebay.sdk.ApiCall;
import com.ebay.sdk.ApiContext;
import com.ebay.sdk.ApiCredential;
import com.ebay.sdk.ApiLogging;
import com.ebay.soap.eBLBaseComponents.AbstractRequestType;
import com.ebay.soap.eBLBaseComponents.AbstractResponseType;
import com.ebay.soap.eBLBaseComponents.AckCodeType;
import com.ebay.soap.eBLBaseComponents.AmountType;
import com.ebay.soap.eBLBaseComponents.BuyerPaymentMethodCodeType;
import com.ebay.soap.eBLBaseComponents.BuyerProtectionCodeType;
import com.ebay.soap.eBLBaseComponents.BuyerRequirementDetailsType;
import com.ebay.soap.eBLBaseComponents.CalculatedShippingRateType;
import com.ebay.soap.eBLBaseComponents.CategoryType;
import com.ebay.soap.eBLBaseComponents.CompleteSaleRequestType;
import com.ebay.soap.eBLBaseComponents.CompleteSaleResponseType;
import com.ebay.soap.eBLBaseComponents.CountryCodeType;
import com.ebay.soap.eBLBaseComponents.CurrencyCodeType;
import com.ebay.soap.eBLBaseComponents.DetailLevelCodeType;
import com.ebay.soap.eBLBaseComponents.EndItemRequestType;
import com.ebay.soap.eBLBaseComponents.EndReasonCodeType;
import com.ebay.soap.eBLBaseComponents.FeeType;
import com.ebay.soap.eBLBaseComponents.FetchTokenRequestType;
import com.ebay.soap.eBLBaseComponents.FetchTokenResponseType;
import com.ebay.soap.eBLBaseComponents.GetItemRequestType;
import com.ebay.soap.eBLBaseComponents.GetItemResponseType;
import com.ebay.soap.eBLBaseComponents.GetOrdersRequestType;
import com.ebay.soap.eBLBaseComponents.GetOrdersResponseType;
import com.ebay.soap.eBLBaseComponents.GetSellerListRequestType;
import com.ebay.soap.eBLBaseComponents.GetSellerListResponseType;
import com.ebay.soap.eBLBaseComponents.GetSellerTransactionsRequestType;
import com.ebay.soap.eBLBaseComponents.GetSellerTransactionsResponseType;
import com.ebay.soap.eBLBaseComponents.GetSessionIDRequestType;
import com.ebay.soap.eBLBaseComponents.GetSessionIDResponseType;
import com.ebay.soap.eBLBaseComponents.GeteBayOfficialTimeRequestType;
import com.ebay.soap.eBLBaseComponents.GranularityLevelCodeType;
import com.ebay.soap.eBLBaseComponents.HitCounterCodeType;
import com.ebay.soap.eBLBaseComponents.InternationalShippingServiceOptionsType;
import com.ebay.soap.eBLBaseComponents.InventoryStatusType;
import com.ebay.soap.eBLBaseComponents.ItemType;
import com.ebay.soap.eBLBaseComponents.ListingDurationCodeType;
import com.ebay.soap.eBLBaseComponents.ListingStatusCodeType;
import com.ebay.soap.eBLBaseComponents.ListingTypeCodeType;
import com.ebay.soap.eBLBaseComponents.MaximumUnpaidItemStrikesInfoType;
import com.ebay.soap.eBLBaseComponents.MeasureType;
import com.ebay.soap.eBLBaseComponents.MeasurementSystemCodeType;
import com.ebay.soap.eBLBaseComponents.OrderIDArrayType;
import com.ebay.soap.eBLBaseComponents.PaginationType;
import com.ebay.soap.eBLBaseComponents.PeriodCodeType;
import com.ebay.soap.eBLBaseComponents.PictureDetailsType;
import com.ebay.soap.eBLBaseComponents.ReturnPolicyType;
import com.ebay.soap.eBLBaseComponents.ReviseInventoryStatusRequestType;
import com.ebay.soap.eBLBaseComponents.SalesTaxType;
import com.ebay.soap.eBLBaseComponents.ShipmentTrackingDetailsType;
import com.ebay.soap.eBLBaseComponents.ShipmentType;
import com.ebay.soap.eBLBaseComponents.ShippingCarrierCodeType;
import com.ebay.soap.eBLBaseComponents.ShippingDetailsType;
import com.ebay.soap.eBLBaseComponents.ShippingPackageCodeType;
import com.ebay.soap.eBLBaseComponents.ShippingServiceOptionsType;
import com.ebay.soap.eBLBaseComponents.ShippingTypeCodeType;
import com.ebay.soap.eBLBaseComponents.SiteCodeType;
import com.ebay.soap.eBLBaseComponents.TransactionArrayType;
import com.ebay.soap.eBLBaseComponents.TransactionType;
import com.ebay.soap.eBLBaseComponents.VariationType;
import com.ebay.soap.eBLBaseComponents.VerifyAddItemRequestType;
import com.ebay.soap.eBLBaseComponents.VerifyAddItemResponseType;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.net.URI;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.xml.ws.BindingProvider;
import pnp.services.datatypes.CompleteOrder;
import pnp.services.datatypes.Listing;
import pnp.services.datatypes.OrderDetails;
import pnp.services.datatypes.ebaysync.EBayAccountContainer;
import pnp.services.datatypes.ebaysync.EBayListingPair;
import pnp.services.datatypes.ebaysync.EbayListingContainer;
import pnp.services.datatypes.ebaysync.SyncListingContainer;
import pnp.services.datatypes.filefilters.TextFileFilter;
import pnp.services.datatypes.webservices.EbayAccountTemp;
import pnp.services.listener.EbayAccountListener;
import pnp.services.listener.GenericListener;
import pnp.services.listenermanager.ListenerManager;
import pnp.services.preferencemanager.Preferences;
import pnp.services.util.ErrorsUtil;
import pnp.services.util.LookupServicesUtil;

public class EbayConnectionManager
implements EbayAccountListener {
    private static EbayConnectionManager _instance;
    private HashMap<String, ApiContext> contextMapping = new HashMap();
    ArrayList<EbayAccountTemp> ebayAccounts = new ArrayList();
    private long timeOffset = 60000L;
    private boolean updatePending = false;
    private long updatePercentage = 0L;
    private static final int MAX_REVISION_STACK_SIZE = 4;
    private static final String RU_NAME = "Hands_Up_Soluti-HandsUpS-05a8-4-jxotxhnr";
    private static final String DEV_ID = "2c0a99ed-6820-42af-ae38-34a3efcf4f38";
    private static final String APP_ID = "HandsUpS-05a8-4387-a4d4-7463c6d3b5a8";
    private static final String CERT_ID = "a3792849-af70-4dad-b5d9-d7a59aba5085";
    private boolean cancelAction = false;
    private FindingServicePortType port = null;

    private EbayConnectionManager() {
        ListenerManager.getInstance().subscribe((GenericListener)this);
        ListenerManager.getInstance().notify((GenericListener)ListenerManager.EBAY_ACCOUNT_LISTENER);
    }

    public boolean isCancelAction() {
        return this.cancelAction;
    }

    public void setCancelAction(boolean cancelAction) {
        this.cancelAction = cancelAction;
    }

    private ApiContext createContext() {
        ApiContext context = new ApiContext();
        ApiAccount account = new ApiAccount();
        account.setDeveloper(DEV_ID);
        account.setApplication(APP_ID);
        account.setCertificate(CERT_ID);
        ApiCredential credential = new ApiCredential();
        credential.setApiAccount(account);
        credential.seteBayAccount(null);
        context.setApiCredential(credential);
        context.setApiServerUrl("https://api.ebay.com/wsapi");
        context.setTimeout(180000);
        context.setWSDLVersion("883");
        ApiLogging logging = new ApiLogging();
        logging.setLogSOAPMessages(false);
        logging.setLogExceptions(true);
        context.setApiLogging(logging);
        return context;
    }

    public static EbayConnectionManager getInstance() {
        if (null == _instance) {
            _instance = new EbayConnectionManager();
        }
        return _instance;
    }

    public String getCurrentTime() {
        String currentTime = "UNKNOWN";
        if (!this.contextMapping.isEmpty()) {
            ApiCall call = new ApiCall(this.contextMapping.get(this.ebayAccounts.get(0).getUsername()));
            GeteBayOfficialTimeRequestType request = new GeteBayOfficialTimeRequestType();
            try {
                AbstractResponseType response = call.executeByApiName("GeteBayOfficialTime", (AbstractRequestType)request);
                if (response.getAck().equals((Object)AckCodeType.SUCCESS)) {
                    Calendar cal = response.getTimestamp();
                    SimpleDateFormat formatter = new SimpleDateFormat("dd MMM yyyy HH:mm:ss");
                    currentTime = formatter.format(cal.getTime());
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return currentTime;
    }

    public TransactionType[] getSellerTransactions(String refreshTime, Calendar endTime) {
        this.updatePercentage = 0L;
        this.updatePending = true;
        this.notifyUpdateListeners();
        long expirationTime = 0L;
        ArrayList<TransactionType> transactionList = new ArrayList<TransactionType>();
        GetSellerTransactionsRequestType request = new GetSellerTransactionsRequestType();
        Calendar previousRead = Calendar.getInstance();
        long timeStamp = 0L;
        if (null != LookupServicesUtil.getDBServices()) {
            timeStamp = LookupServicesUtil.getDBServices().getAccountPreferences().getEbayLastUpdate();
        }
        if (timeStamp != 0L) {
            long startTime = refreshTime.contains("1 Day") ? System.currentTimeMillis() - 86400000L : (refreshTime.contains("2 Days") ? System.currentTimeMillis() - 172800000L : (refreshTime.contains("7 Days") ? System.currentTimeMillis() - 604800000L : timeStamp - 0x6DDD00L));
            previousRead.setTimeInMillis(startTime);
            expirationTime = timeStamp - 432000000L;
            request.setModTimeFrom(previousRead);
            request.setModTimeTo(endTime);
        } else {
            expirationTime = System.currentTimeMillis() - 432000000L;
            request.setNumberOfDays(Integer.valueOf(1));
        }
        this.updatePercentage = 5L;
        this.notifyUpdateListeners();
        boolean errorCondition = false;
        Iterator<EbayAccountTemp> accounts = this.ebayAccounts.iterator();
        while (accounts.hasNext() && !errorCondition) {
            EbayAccountTemp account = accounts.next();
            ArrayList<TransactionType> result = this.getSellerTransactions(this.contextMapping.get(account.getUsername()), request, expirationTime, account.getUsername());
            if (null != result && !errorCondition) {
                transactionList.addAll(result);
                continue;
            }
            errorCondition = true;
        }
        this.updatePercentage = 95L;
        this.notifyUpdateListeners();
        if (null != LookupServicesUtil.getDBServices() && !this.getCurrentTime().equals("UNKNOWN") && !errorCondition) {
            Preferences.getInstance().getAccountPreferences().setEbayLastUpdate(endTime.getTimeInMillis() - this.timeOffset);
            Preferences.getInstance().updateAccountPreferences();
            return transactionList.toArray(new TransactionType[0]);
        }
        return null;
    }

    public void setLastUpdate(Calendar lastRefreshTime) {
        Preferences.getInstance().getAccountPreferences().setEbayLastUpdate(lastRefreshTime.getTimeInMillis() - this.timeOffset);
        Preferences.getInstance().updateAccountPreferences();
    }

    public void refreshShipping(CompleteOrder completeOrder) {
        try {
            OrderDetails orderDetails = (OrderDetails)completeOrder.getOrderDetails().get(0);
            ApiContext context = this.contextMapping.get(orderDetails.getAccountName());
            if (null != context) {
                ApiCall call = new ApiCall(context);
                GetOrdersRequestType getOrderRequest = new GetOrdersRequestType();
                OrderIDArrayType orderArray = new OrderIDArrayType();
                if (orderDetails.getTransactionID().contains("-")) {
                    orderArray.setOrderID(new String[]{orderDetails.getTransactionID()});
                } else {
                    orderArray.setOrderID(new String[]{orderDetails.getOrderNumber() + "-" + orderDetails.getTransactionID()});
                }
                getOrderRequest.setOrderIDArray(orderArray);
                GetOrdersResponseType GetOrdersResponse = (GetOrdersResponseType)call.executeByApiName("GetOrders", (AbstractRequestType)getOrderRequest);
                if (GetOrdersResponse.getAck() == AckCodeType.SUCCESS && GetOrdersResponse.getOrderArray().getOrder().length > 0) {
                    completeOrder.getOrder().setShippingMethodName(GetOrdersResponse.getOrderArray().getOrder()[0].getShippingServiceSelected().getShippingService());
                    LookupServicesUtil.getDBServices().updateOrder(completeOrder);
                }
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    public ArrayList<TransactionType> getSellerTransactions(ApiContext context, GetSellerTransactionsRequestType request, long expirationTime, String username) {
        ApiCall call = new ApiCall(context);
        TransactionArrayType transactionsArray = null;
        int page = 1;
        PaginationType pagination = new PaginationType();
        pagination.setEntriesPerPage(Integer.valueOf(200));
        pagination.setPageNumber(Integer.valueOf(page));
        request.setPagination(pagination);
        DetailLevelCodeType[] detailLevel = new DetailLevelCodeType[]{DetailLevelCodeType.ITEM_RETURN_DESCRIPTION};
        request.setDetailLevel(detailLevel);
        ArrayList<TransactionType> transactionList = null;
        try {
            boolean complete = false;
            boolean error = false;
            transactionList = new ArrayList<TransactionType>();
            while (!complete && !error) {
                AbstractResponseType response = call.executeByApiName("GetSellerTransactions", (AbstractRequestType)request);
                if (response instanceof GetSellerTransactionsResponseType) {
                    GetSellerTransactionsResponseType sellerTransactions = (GetSellerTransactionsResponseType)response;
                    long newPercentage = sellerTransactions.getPaginationResult().getTotalNumberOfPages() == 0 ? this.updatePercentage + (long)(90 / this.ebayAccounts.size()) : this.updatePercentage + (long)(90 / this.ebayAccounts.size() / sellerTransactions.getPaginationResult().getTotalNumberOfPages());
                    this.updatePercentage = newPercentage < 95L ? newPercentage : 95L;
                    this.notifyUpdateListeners();
                    if (sellerTransactions.getAck().equals((Object)AckCodeType.SUCCESS)) {
                        transactionsArray = sellerTransactions.getTransactionArray();
                        if (null != transactionsArray) {
                            for (TransactionType transaction : transactionsArray.getTransaction()) {
                                Date orderDate = new Date(transaction.getCreatedDate().getTime().getTime());
                                Object[] newObject = new Object[]{orderDate.getTime() <= expirationTime};
                                transaction.setAny(newObject);
                                ItemType item = this.getItem(transaction.getItem().getItemID(), context);
                                if (null != item) {
                                    transaction.setItem(item);
                                }
                                if (transaction.getItem().getVariations() != null && transaction.getVariation() == null) {
                                    try {
                                        OrderIDArrayType orderIDArray = new OrderIDArrayType();
                                        String[] orders = new String[]{transaction.getItem().getItemID() + "-" + transaction.getTransactionID()};
                                        orderIDArray.setOrderID(orders);
                                        GetOrdersRequestType orderRequest = new GetOrdersRequestType();
                                        orderRequest.setOrderIDArray(orderIDArray);
                                        response = call.executeByApiName("GetOrders", (AbstractRequestType)orderRequest);
                                        GetOrdersResponseType orderResponse = (GetOrdersResponseType)response;
                                        if (orderResponse != null && orderResponse.getOrderArray().getOrderLength() == 1 && orderResponse.getAck().equals((Object)AckCodeType.SUCCESS) && orderResponse.getOrderArray().getOrder(0).getTransactionArray().getTransactionLength() == 1) {
                                            transaction.setVariation(orderResponse.getOrderArray().getOrder(0).getTransactionArray().getTransaction(0).getVariation());
                                        }
                                    }
                                    catch (Exception ex) {
                                        ErrorsUtil.getInstance().logError(ex);
                                    }
                                }
                                transaction.setBuyerMessage(username);
                                transactionList.add(transaction);
                            }
                        }
                        if (sellerTransactions.isHasMoreTransactions().booleanValue()) {
                            pagination.setPageNumber(Integer.valueOf(++page));
                            continue;
                        }
                        complete = true;
                        continue;
                    }
                    error = true;
                    transactionList = null;
                    continue;
                }
                complete = true;
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        return transactionList;
    }

    private ItemType getItem(String itemID, ApiContext context) {
        ApiCall call = new ApiCall(context);
        ItemType item = null;
        GetItemRequestType itemRequest = new GetItemRequestType();
        itemRequest.setItemID(itemID);
        try {
            GetItemResponseType itemResponse;
            AbstractResponseType response = call.executeByApiName("GetItem", (AbstractRequestType)itemRequest);
            if (response instanceof GetItemResponseType && (itemResponse = (GetItemResponseType)response).getAck().equals((Object)AckCodeType.SUCCESS)) {
                item = itemResponse.getItem();
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        return item;
    }

    private ArrayList<ItemType> getSellerList(ApiContext context) {
        ApiCall call = new ApiCall(context);
        Object item = null;
        GetSellerListRequestType listRequest = new GetSellerListRequestType();
        listRequest.setGranularityLevel(GranularityLevelCodeType.FINE);
        Calendar endTimeFrom = Calendar.getInstance();
        listRequest.setIncludeVariations(Boolean.valueOf(true));
        endTimeFrom.setTimeInMillis(System.currentTimeMillis());
        listRequest.setEndTimeFrom(endTimeFrom);
        Calendar endTimeTo = Calendar.getInstance();
        endTimeTo.setTimeInMillis(System.currentTimeMillis() + 3888000000L);
        listRequest.setEndTimeTo(endTimeTo);
        int page = 1;
        PaginationType pagination = new PaginationType();
        pagination.setEntriesPerPage(Integer.valueOf(200));
        pagination.setPageNumber(Integer.valueOf(page));
        listRequest.setPagination(pagination);
        ArrayList<ItemType> itemList = new ArrayList<ItemType>();
        try {
            boolean complete = false;
            while (!complete) {
                AbstractResponseType response = call.executeByApiName("GetSellerList", (AbstractRequestType)listRequest);
                if (response instanceof GetSellerListResponseType) {
                    GetSellerListResponseType listResponse = (GetSellerListResponseType)response;
                    if (response.getAck().equals((Object)AckCodeType.SUCCESS)) {
                        ItemType[] items = listResponse.getItemArray().getItem();
                        for (int i = 0; i < items.length; ++i) {
                            if (null != items[i].getVariations() && items[i].getVariations().getVariationLength() > 0) {
                                GetItemRequestType itemRequestType = new GetItemRequestType();
                                itemRequestType.setItemID(items[i].getItemID());
                                try {
                                    response = call.executeByApiName("GetItem", (AbstractRequestType)itemRequestType);
                                    GetItemResponseType itemResponseType = (GetItemResponseType)response;
                                    if (itemResponseType.getAck() != AckCodeType.SUCCESS) continue;
                                    itemList.add(itemResponseType.getItem());
                                }
                                catch (Exception ex) {
                                    ErrorsUtil.getInstance().logError(ex);
                                    itemList.add(items[i]);
                                }
                                continue;
                            }
                            itemList.add(items[i]);
                        }
                        if (listResponse.isHasMoreItems().booleanValue()) {
                            pagination.setPageNumber(Integer.valueOf(++page));
                            continue;
                        }
                        complete = true;
                        continue;
                    }
                    complete = true;
                    itemList = null;
                    continue;
                }
                complete = true;
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        return itemList;
    }

    ArrayList<ArrayList<ItemType>> getActiveItems() {
        ArrayList<ArrayList<ItemType>> list = new ArrayList<ArrayList<ItemType>>();
        boolean errorCondition = false;
        Iterator<EbayAccountTemp> iter = this.ebayAccounts.iterator();
        while (iter.hasNext() && !errorCondition) {
            ArrayList<ItemType> result = this.getSellerList(this.contextMapping.get(iter.next().getUsername()));
            if (result != null) {
                list.add(result);
                continue;
            }
            errorCondition = true;
            list = null;
        }
        return list;
    }

    public boolean createUser(String username) {
        ApiContext context = this.createContext();
        ApiCall call = new ApiCall(context);
        GetSessionIDRequestType sessionIDRequest = new GetSessionIDRequestType();
        sessionIDRequest.setRuName(RU_NAME);
        boolean success = false;
        try {
            GetSessionIDResponseType sessionIDResponse;
            AbstractResponseType response = call.executeByApiName("GetSessionID", (AbstractRequestType)sessionIDRequest);
            if (response instanceof GetSessionIDResponseType && (sessionIDResponse = (GetSessionIDResponseType)response).getAck().equals((Object)AckCodeType.SUCCESS)) {
                String sessionID = sessionIDResponse.getSessionID();
                Desktop desktop = Desktop.getDesktop();
                String eBayURI = "https://signin.ebay.com/ws/eBayISAPI.dll?SignIn&RuName=Hands_Up_Soluti-HandsUpS-05a8-4-jxotxhnr&SessID=" + sessionID;
                URI uri = new URI(eBayURI);
                desktop.browse(uri);
                FetchTokenRequestType fetchTokenRequest = new FetchTokenRequestType();
                fetchTokenRequest.setSessionID(sessionID);
                int numberOfTries = 0;
                while (!success && numberOfTries < 5) {
                    JOptionPane.showMessageDialog(null, "Linking eBay account with Gamut, press OK when finished.");
                    ++numberOfTries;
                    try {
                        FetchTokenResponseType fetchTokenResponse;
                        response = call.executeByApiName("FetchToken", (AbstractRequestType)fetchTokenRequest);
                        if (!(response instanceof FetchTokenResponseType) || !(fetchTokenResponse = (FetchTokenResponseType)response).getAck().equals((Object)AckCodeType.SUCCESS)) continue;
                        success = true;
                        context.getApiCredential().seteBayToken(fetchTokenResponse.getEBayAuthToken());
                        this.contextMapping.put(username, context);
                        EbayAccountTemp account = new EbayAccountTemp(fetchTokenResponse.getEBayAuthToken(), username);
                        boolean unique = true;
                        for (EbayAccountTemp currentAccount : this.ebayAccounts) {
                            if (!currentAccount.getUsername().equals(account.getUsername())) continue;
                            unique = false;
                            break;
                        }
                        if (!unique) continue;
                        LookupServicesUtil.getAuthenticationManagerServices().createEbayAccount(account);
                    }
                    catch (Exception ex) {
                        ErrorsUtil.getInstance().logError(ex);
                    }
                }
                if (!success) {
                    JOptionPane.showMessageDialog(null, "There was a problem linking your account to Gamut; Please try again using the User Manager in the File menu or contact support at: support@gamut.com");
                }
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
            JOptionPane.showMessageDialog(null, "There was a problem linking your account to Gamut; Please try again using the User Manager in the File menu or contact support at: support@gamut.com");
        }
        return success;
    }

    public boolean updateTracking(OrderDetails orderDetails) {
        ApiContext context = this.contextMapping.get(orderDetails.getAccountName());
        boolean success = false;
        if (null != context) {
            try {
                ApiCall call = new ApiCall(context);
                OrderIDArrayType orderIDArray = new OrderIDArrayType();
                String[] orders = new String[]{orderDetails.getOrderNumber() + "-" + orderDetails.getTransactionID()};
                orderIDArray.setOrderID(orders);
                CompleteSaleRequestType completeSaleRequest = new CompleteSaleRequestType();
                if (orderDetails.getTransactionID().contains("-")) {
                    completeSaleRequest.setOrderID(orderDetails.getTransactionID());
                } else {
                    completeSaleRequest.setOrderID(orderDetails.getOrderNumber() + "-" + orderDetails.getTransactionID());
                }
                ShipmentType shipmentInfo = new ShipmentType();
                ShipmentTrackingDetailsType[] shipmentTracking = new ShipmentTrackingDetailsType[]{new ShipmentTrackingDetailsType()};
                shipmentTracking[0].setShipmentTrackingNumber(orderDetails.getTrackingNumber());
                shipmentTracking[0].setShippingCarrierUsed(ShippingCarrierCodeType.USPS.value());
                if (orderDetails.getCarrier() != null && !orderDetails.getCarrier().trim().isEmpty()) {
                    if (orderDetails.getCarrier().trim().equalsIgnoreCase("UPS")) {
                        shipmentTracking[0].setShippingCarrierUsed(ShippingCarrierCodeType.UPS.value());
                    } else if (orderDetails.getCarrier().trim().equalsIgnoreCase("UPS-MI")) {
                        shipmentTracking[0].setShippingCarrierUsed("UPS-MI");
                    }
                }
                shipmentInfo.setShipmentTrackingDetails(shipmentTracking);
                completeSaleRequest.setShipment(shipmentInfo);
                AbstractResponseType response = call.executeByApiName("CompleteSale", (AbstractRequestType)completeSaleRequest);
                CompleteSaleResponseType completeSaleResponse = (CompleteSaleResponseType)response;
                if (completeSaleResponse.getAck() == AckCodeType.SUCCESS) {
                    success = true;
                } else {
                    JOptionPane.showMessageDialog(null, "Ack Code:" + completeSaleResponse.getAck().value() + "Message:" + completeSaleResponse.getMessage());
                }
            }
            catch (Exception ex) {
                if (ex.getMessage().contains("One or more tracking number(s) in the request already exists either for a different buyer or for a different seller")) {
                    ErrorsUtil.getInstance().logError(ex, false);
                }
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return success;
    }

    public void eBayAccountChange() {
        this.ebayAccounts = LookupServicesUtil.getAuthenticationManagerServices().getEbayAccounts();
        this.contextMapping.clear();
        for (EbayAccountTemp ebayAccount : this.ebayAccounts) {
            ApiContext context = this.createContext();
            context.getApiCredential().seteBayToken(ebayAccount.getEbayToken());
            this.contextMapping.put(ebayAccount.getUsername(), context);
        }
    }

    public void setUpdatePending(boolean updatePending) {
        this.updatePending = updatePending;
    }

    public boolean isUpdatePending() {
        return this.updatePending;
    }

    public long getUpdatePercentage() {
        return this.updatePercentage;
    }

    public void notifyUpdateListeners() {
        ListenerManager.getInstance().notify((GenericListener)ListenerManager.UPDATE_STATUS_LISTENER);
    }

    public ArrayList<SyncListingContainer> generateSyncListings(ArrayList<String> oosItems, HashMap<String, EbayListingContainer> listingMap, boolean instockToggle) {
        String errorMessage = "";
        HashMap<String, GetItemResponseType> itemResponseMap = new HashMap<String, GetItemResponseType>();
        ArrayList<SyncListingContainer> syncListingsList = new ArrayList<SyncListingContainer>();
        Iterator<String> oosIter = oosItems.iterator();
        boolean listingFound = true;
        while (oosIter.hasNext()) {
            String oosItem = oosIter.next();
            if (!listingMap.containsKey(oosItem)) continue;
            int itemQuantity = LookupServicesUtil.getDBServices().getItemQuantity(oosItem, false);
            EbayListingContainer listingObject = listingMap.get(oosItem);
            for (EbayAccountTemp userAccount : this.ebayAccounts) {
                float avgPrice;
                AmountType itemPrice;
                AbstractResponseType response;
                GetItemResponseType itemResponseType;
                EBayListingPair eBayListingPair;
                boolean ignoreListing;
                EBayAccountContainer account = listingObject.getEBayAccount(userAccount.getUsername());
                if (null == account) continue;
                ApiContext context = this.contextMapping.get(userAccount.getUsername());
                ApiCall call = new ApiCall(context);
                ArrayList listings = account.getUnmatchedListings();
                Iterator listingIterator = listings.iterator();
                while (listingIterator.hasNext()) {
                    ignoreListing = false;
                    eBayListingPair = (EBayListingPair)listingIterator.next();
                    if (itemResponseMap.containsKey(eBayListingPair.getItemID())) {
                        itemResponseType = (GetItemResponseType)itemResponseMap.get(eBayListingPair.getItemID());
                    } else {
                        GetItemRequestType itemRequestType = new GetItemRequestType();
                        itemRequestType.setItemID(eBayListingPair.getItemID());
                        try {
                            response = call.executeByApiName("GetItem", (AbstractRequestType)itemRequestType);
                            itemResponseType = (GetItemResponseType)response;
                            if (itemResponseType.getAck() == AckCodeType.SUCCESS) {
                                itemResponseMap.put(eBayListingPair.getItemID(), itemResponseType);
                            }
                        }
                        catch (Exception ex) {
                            ErrorsUtil.getInstance().logError(ex);
                            itemResponseType = null;
                        }
                    }
                    if (null == itemResponseType || itemResponseType.getItem().getSellingStatus().getListingStatus() != ListingStatusCodeType.ACTIVE) continue;
                    boolean adjustQuantity = true;
                    itemPrice = null;
                    listingFound = true;
                    if (null != itemResponseType.getItem().getVariations()) {
                        int i;
                        adjustQuantity = false;
                        VariationType[] variations = itemResponseType.getItem().getVariations().getVariation();
                        listingFound = false;
                        if (instockToggle) {
                            ignoreListing = true;
                            for (i = 0; i < variations.length; ++i) {
                                if (null == variations[i].getSKU() || !variations[i].getSKU().equals(eBayListingPair.getProductID())) continue;
                                if (variations[i].getQuantity() - variations[i].getSellingStatus().getQuantitySold() == 0) {
                                    adjustQuantity = true;
                                    ignoreListing = false;
                                } else {
                                    ignoreListing = true;
                                    itemPrice = variations[i].getStartPrice();
                                    if (itemPrice.getValue() <= 0.0) {
                                        errorMessage = errorMessage + "Item SKU: " + eBayListingPair.getProductID() + " ; Reference Number: " + eBayListingPair.getItemID() + "\n";
                                    }
                                    if ((avgPrice = LookupServicesUtil.getDBServices().getAverageWholesaleCost(oosItem) + 2.0f) != 0.0f && itemPrice.getValue() / (double)avgPrice > 12.0) {
                                        itemPrice.setValue(itemPrice.getValue() / 10.0);
                                        ignoreListing = false;
                                    }
                                }
                                listingFound = true;
                            }
                        } else {
                            for (i = 0; i < variations.length; ++i) {
                                if (null != variations[i].getSKU() && variations[i].getSKU().equals(eBayListingPair.getProductID())) {
                                    if (variations[i].getQuantity() - variations[i].getSellingStatus().getQuantitySold() == 0) {
                                        ignoreListing = true;
                                    }
                                    listingFound = true;
                                    itemPrice = variations[i].getStartPrice();
                                    if (itemPrice.getValue() <= 0.0) {
                                        errorMessage = errorMessage + "Item SKU: " + eBayListingPair.getProductID() + " ; Reference Number: " + eBayListingPair.getItemID() + "\n";
                                    }
                                    itemPrice.setValue(itemPrice.getValue() * 10.0);
                                    continue;
                                }
                                if (null == variations[i] || null == variations[i].getQuantity() || variations[i].getQuantity() <= 0) continue;
                                adjustQuantity = true;
                            }
                        }
                    } else {
                        adjustQuantity = false;
                        itemPrice = itemResponseType.getItem().getStartPrice();
                        if (itemPrice.getValue() <= 0.0) {
                            errorMessage = errorMessage + "Item SKU: " + eBayListingPair.getProductID() + " ; Reference Number: " + eBayListingPair.getItemID() + "\n";
                        }
                        if (instockToggle) {
                            ignoreListing = true;
                            float avgPrice2 = LookupServicesUtil.getDBServices().getAverageWholesaleCost(oosItem) + 2.0f;
                            if (itemPrice.getValue() / (double)avgPrice2 > 12.0 && avgPrice2 != 0.0f) {
                                itemPrice.setValue(itemPrice.getValue() / 10.0);
                                ignoreListing = false;
                            }
                        } else {
                            itemPrice.setValue(itemPrice.getValue() * 10.0);
                        }
                    }
                    if (ignoreListing || !listingFound) continue;
                    InventoryStatusType inventoryStatus = new InventoryStatusType();
                    inventoryStatus.setItemID(eBayListingPair.getItemID());
                    inventoryStatus.setSKU(eBayListingPair.getProductID());
                    if (!adjustQuantity && null != itemPrice) {
                        inventoryStatus.setStartPrice(itemPrice);
                        if (instockToggle) {
                            inventoryStatus.setQuantity(Integer.valueOf(itemQuantity));
                        }
                    } else if (instockToggle) {
                        if (itemQuantity > 0) {
                            inventoryStatus.setQuantity(Integer.valueOf(itemQuantity));
                        } else {
                            inventoryStatus.setQuantity(Integer.valueOf(30));
                        }
                    } else {
                        inventoryStatus.setQuantity(Integer.valueOf(0));
                    }
                    SyncListingContainer syncListingContainer = new SyncListingContainer(false, userAccount.getUsername(), inventoryStatus);
                    syncListingsList.add(syncListingContainer);
                }
                listings = account.getListings();
                listingIterator = listings.iterator();
                while (listingIterator.hasNext()) {
                    boolean adjustQuantity;
                    ignoreListing = false;
                    eBayListingPair = (EBayListingPair)listingIterator.next();
                    if (itemResponseMap.containsKey(eBayListingPair.getItemID())) {
                        itemResponseType = (GetItemResponseType)itemResponseMap.get(eBayListingPair.getItemID());
                    } else {
                        GetItemRequestType itemRequestType = new GetItemRequestType();
                        itemRequestType.setItemID(eBayListingPair.getItemID());
                        try {
                            response = call.executeByApiName("GetItem", (AbstractRequestType)itemRequestType);
                            itemResponseType = (GetItemResponseType)response;
                            if (itemResponseType.getAck() == AckCodeType.SUCCESS) {
                                itemResponseMap.put(eBayListingPair.getItemID(), itemResponseType);
                            }
                        }
                        catch (Exception ex) {
                            ErrorsUtil.getInstance().logError(ex);
                            itemResponseType = null;
                        }
                    }
                    if (null == itemResponseType || itemResponseType.getItem().getSellingStatus().getListingStatus() != ListingStatusCodeType.ACTIVE) continue;
                    itemPrice = null;
                    listingFound = true;
                    if (null != itemResponseType.getItem().getVariations()) {
                        int i;
                        adjustQuantity = false;
                        VariationType[] variations = itemResponseType.getItem().getVariations().getVariation();
                        listingFound = false;
                        if (instockToggle) {
                            ignoreListing = true;
                            for (i = 0; i < variations.length; ++i) {
                                if (null == variations[i].getSKU() || !variations[i].getSKU().equals(eBayListingPair.getProductID())) continue;
                                if (variations[i].getQuantity() - variations[i].getSellingStatus().getQuantitySold() == 0) {
                                    adjustQuantity = true;
                                    ignoreListing = false;
                                } else {
                                    ignoreListing = true;
                                    itemPrice = variations[i].getStartPrice();
                                    if (itemPrice.getValue() <= 0.0) {
                                        errorMessage = errorMessage + "Item SKU: " + eBayListingPair.getProductID() + " ; Reference Number: " + eBayListingPair.getItemID() + "\n";
                                    }
                                    avgPrice = LookupServicesUtil.getDBServices().getAverageWholesaleCost(oosItem) + 2.0f;
                                    if (itemPrice.getValue() / (double)avgPrice > 12.0 && avgPrice != 0.0f) {
                                        itemPrice.setValue(itemPrice.getValue() / 10.0);
                                        ignoreListing = false;
                                    }
                                }
                                listingFound = true;
                            }
                        } else {
                            for (i = 0; i < variations.length; ++i) {
                                if (null != variations[i].getSKU() && variations[i].getSKU().equals(eBayListingPair.getProductID())) {
                                    if (null == variations[i] || null == variations[i].getQuantity() || variations[i].getQuantity() - variations[i].getSellingStatus().getQuantitySold() == 0) {
                                        ignoreListing = true;
                                    }
                                    listingFound = true;
                                    itemPrice = variations[i].getStartPrice();
                                    if (itemPrice.getValue() <= 0.0) {
                                        errorMessage = errorMessage + "Item SKU: " + eBayListingPair.getProductID() + " ; Reference Number: " + eBayListingPair.getItemID() + "\n";
                                    }
                                    itemPrice.setValue(itemPrice.getValue() * 10.0);
                                    continue;
                                }
                                if (null == variations[i] || null == variations[i].getQuantity() || variations[i].getQuantity() <= 0) continue;
                                adjustQuantity = true;
                            }
                        }
                    } else {
                        adjustQuantity = false;
                        itemPrice = itemResponseType.getItem().getStartPrice();
                        if (itemPrice.getValue() <= 0.0) {
                            errorMessage = errorMessage + "Item SKU: " + eBayListingPair.getProductID() + " ; Reference Number: " + eBayListingPair.getItemID() + "\n";
                        }
                        if (instockToggle) {
                            ignoreListing = true;
                            float avgPrice3 = LookupServicesUtil.getDBServices().getAverageWholesaleCost(oosItem) + 2.0f;
                            if (itemPrice.getValue() / (double)avgPrice3 > 12.0 && avgPrice3 != 0.0f) {
                                itemPrice.setValue(itemPrice.getValue() / 10.0);
                                ignoreListing = false;
                            }
                        } else {
                            itemPrice.setValue(itemPrice.getValue() * 10.0);
                        }
                    }
                    if (ignoreListing || !listingFound) continue;
                    InventoryStatusType inventoryStatus = new InventoryStatusType();
                    inventoryStatus.setItemID(eBayListingPair.getItemID());
                    inventoryStatus.setSKU(eBayListingPair.getProductID());
                    if (!adjustQuantity && null != itemPrice) {
                        inventoryStatus.setStartPrice(itemPrice);
                        if (instockToggle) {
                            inventoryStatus.setQuantity(Integer.valueOf(itemQuantity));
                        }
                    } else if (instockToggle) {
                        if (itemQuantity > 0) {
                            inventoryStatus.setQuantity(Integer.valueOf(itemQuantity));
                        } else {
                            inventoryStatus.setQuantity(Integer.valueOf(30));
                        }
                    } else {
                        inventoryStatus.setQuantity(Integer.valueOf(0));
                    }
                    SyncListingContainer syncListingContainer = new SyncListingContainer(true, userAccount.getUsername(), inventoryStatus);
                    syncListingsList.add(syncListingContainer);
                }
            }
        }
        if (!errorMessage.isEmpty()) {
            errorMessage = "Some results may have been corrupted:\n" + errorMessage;
            JOptionPane.showMessageDialog(null, errorMessage);
        }
        return syncListingsList;
    }

    public synchronized HashMap<String, ArrayList<SyncListingContainer>> createSyncAccountContainers(ArrayList<SyncListingContainer> syncListingsList) {
        HashMap<String, ArrayList<SyncListingContainer>> container = new HashMap<String, ArrayList<SyncListingContainer>>();
        for (SyncListingContainer item : syncListingsList) {
            if (!container.containsKey(item.getAccountName())) {
                container.put(item.getAccountName(), new ArrayList());
            }
            container.get(item.getAccountName()).add(item);
        }
        return container;
    }

    public synchronized String endListing(ArrayList<InventoryStatusType> revisionChunk, int counter, ApiCall call, boolean resync) {
        String userMessage = "";
        boolean hasMore = false;
        try {
            InventoryStatusType item = revisionChunk.get(counter);
            item.setQuantity(Integer.valueOf(0));
            GetItemRequestType itemRequestType = new GetItemRequestType();
            itemRequestType.setItemID(item.getItemID());
            GetItemResponseType itemResponseType = (GetItemResponseType)call.executeByApiName("GetItem", (AbstractRequestType)itemRequestType);
            if (itemResponseType != null && itemResponseType.getItem() != null && itemResponseType.getItem().getVariations() != null && itemResponseType.getItem().getVariations().getVariation() != null) {
                for (VariationType variation : itemResponseType.getItem().getVariations().getVariation()) {
                    if (variation.getQuantity() <= 0 || variation.getSKU() == null || variation.getSKU().equalsIgnoreCase(item.getSKU())) continue;
                    hasMore = true;
                    break;
                }
            }
            if (!hasMore || resync) {
                EndItemRequestType endRequest = new EndItemRequestType();
                endRequest.setItemID(item.getItemID());
                endRequest.setEndingReason(EndReasonCodeType.NOT_AVAILABLE);
                try {
                    AbstractResponseType response = call.executeByApiName("EndItem", (AbstractRequestType)endRequest);
                    revisionChunk.remove(counter);
                }
                catch (Exception ex) {
                    ErrorsUtil.getInstance().logError(ex);
                    userMessage = userMessage + "Failed to end listing for Item: " + item.getItemID() + ", SKU: " + item.getSKU() + ". Price will be adjusted instead.\n" + "Reason for failure: " + ex.getMessage() + "\n";
                }
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
            userMessage = userMessage + ex.getMessage() + "\n";
        }
        return userMessage;
    }

    public synchronized boolean doChanges(boolean awaitBatch, ApiCall call, ArrayList<InventoryStatusType> itemRevisionChunk) throws Exception {
        if (!awaitBatch && itemRevisionChunk != null && !itemRevisionChunk.isEmpty()) {
            try {
                ReviseInventoryStatusRequestType reviseInventoryStatusRequest = new ReviseInventoryStatusRequestType();
                reviseInventoryStatusRequest.setInventoryStatus(itemRevisionChunk.toArray(new InventoryStatusType[0]));
                call.executeByApiName("ReviseInventoryStatus", (AbstractRequestType)reviseInventoryStatusRequest);
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
                if (ex.getMessage().contains("At least one of the variations associated with this listing must have a quantity greater than 0")) {
                    boolean bl = false;
                    return bl;
                }
                throw ex;
            }
            finally {
                itemRevisionChunk.clear();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String performSync(ArrayList<SyncListingContainer> syncListingsList, boolean instockToggle, boolean useStockQty, int defaultQuantity, int batch, boolean endListing, boolean resync) {
        String userMessage = "";
        ArrayList<InventoryStatusType> itemRevisionChunk = null;
        HashMap<String, ArrayList<SyncListingContainer>> individualAccounts = this.createSyncAccountContainers(syncListingsList);
        ArrayList<SyncListingContainer> lastBatch = new ArrayList<SyncListingContainer>();
        for (String account : individualAccounts.keySet()) {
            try {
                if (this.cancelAction) break;
                ApiContext context = this.contextMapping.get(account);
                ApiCall call = new ApiCall(context);
                int batchCounter = 0;
                ArrayList<SyncListingContainer> accountSyncList = individualAccounts.get(account);
                for (SyncListingContainer listingContainer : accountSyncList) {
                    try {
                        if (this.cancelAction) break;
                        ListenerManager.getInstance().notify((GenericListener)ListenerManager.SYNC_LISTENER);
                        if (batchCounter == 0) {
                            lastBatch = new ArrayList();
                            itemRevisionChunk = new ArrayList<InventoryStatusType>();
                        }
                        lastBatch.add(listingContainer);
                        itemRevisionChunk.add(listingContainer.getInventoryStatus());
                        if (instockToggle) {
                            if (!useStockQty) {
                                ((InventoryStatusType)itemRevisionChunk.get(itemRevisionChunk.size() - 1)).setQuantity(Integer.valueOf(defaultQuantity));
                            }
                        } else if (endListing) {
                            userMessage = userMessage + this.endListing(itemRevisionChunk, itemRevisionChunk.size() - 1, call, resync);
                        }
                        if (this.doChanges(batchCounter != batch - 1, call, itemRevisionChunk) || !endListing || resync) continue;
                        for (SyncListingContainer container : lastBatch) {
                            ArrayList<SyncListingContainer> newList = new ArrayList<SyncListingContainer>();
                            newList.add(container);
                            this.performSync(newList, instockToggle, useStockQty, defaultQuantity, batch, endListing, lastBatch.size() == 1);
                        }
                    }
                    catch (Exception ex) {
                        ErrorsUtil.getInstance().logError(ex);
                        userMessage = userMessage + ex.getMessage() + "\n";
                    }
                    finally {
                        batchCounter = (batchCounter + 1) % batch;
                    }
                }
                if (this.doChanges(false, call, itemRevisionChunk) || !endListing || resync) continue;
                for (SyncListingContainer container : lastBatch) {
                    ArrayList<SyncListingContainer> newList = new ArrayList<SyncListingContainer>();
                    newList.add(container);
                    this.performSync(newList, instockToggle, useStockQty, defaultQuantity, batch, endListing, lastBatch.size() == 1);
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
                userMessage = userMessage + ex.getMessage() + "\n";
            }
        }
        return userMessage;
    }

    public void checkDuplicates() {
        block42: {
            HashMap<String, ItemHolder> pnp_itemList = new HashMap<String, ItemHolder>();
            HashMap<String, ItemHolder> plug_itemList = new HashMap<String, ItemHolder>();
            HashMap<String, ItemHolder> goth_itemList = new HashMap<String, ItemHolder>();
            HashMap<String, ItemHolder> matchedListings = new HashMap<String, ItemHolder>();
            try {
                int i;
                String orderLine;
                JFileChooser importLocation = new JFileChooser(".\\");
                importLocation.setDialogTitle("Select Active Items List");
                importLocation.setFileFilter((FileFilter)new TextFileFilter());
                int returnVal = importLocation.showOpenDialog(null);
                if (returnVal != 0) break block42;
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter("DuplicateList.txt"));
                FileInputStream fstream = new FileInputStream(importLocation.getSelectedFile());
                DataInputStream in = new DataInputStream(fstream);
                BufferedReader br = new BufferedReader(new InputStreamReader(in));
                ArrayList<String> accountNameList = new ArrayList<String>();
                while ((orderLine = br.readLine()) != null) {
                    String[] tokens;
                    if (orderLine.contains("ProductID")) {
                        tokens = orderLine.split("\t");
                        for (int i2 = 0; i2 < tokens.length; ++i2) {
                            if (!tokens[i2].contains("Item(s)")) continue;
                            String accountName = tokens[i2].substring(0, tokens[i2].indexOf("Item(s)")).trim();
                            accountNameList.add(accountName);
                        }
                        continue;
                    }
                    tokens = orderLine.split("\t");
                    for (int accountPos = 0; accountPos < accountNameList.size() && accountPos * 3 + 2 < tokens.length; ++accountPos) {
                        String[] itemIDs = tokens[accountPos * 3 + 2].split("\\|");
                        String[] productIDs = tokens[accountPos * 3 + 3].split("\\|");
                        for (i = 0; i < itemIDs.length; ++i) {
                            ItemHolder holder;
                            if (productIDs[i].isEmpty()) continue;
                            if (((String)accountNameList.get(accountPos)).equals("pnp_inc")) {
                                if (pnp_itemList.containsKey(itemIDs[i])) {
                                    ((ItemHolder)pnp_itemList.get(itemIDs[i])).getSKUs().put(productIDs[i], "pnp_inc");
                                    continue;
                                }
                                holder = new ItemHolder();
                                holder.setItemID(itemIDs[i]);
                                holder.getSKUs().put(productIDs[i], "pnp_inc");
                                pnp_itemList.put(itemIDs[i], holder);
                                continue;
                            }
                            if (((String)accountNameList.get(accountPos)).equals("plugandplaytoyz")) {
                                if (plug_itemList.containsKey(itemIDs[i])) {
                                    ((ItemHolder)plug_itemList.get(itemIDs[i])).getSKUs().put(productIDs[i], "plugandplaytoyz");
                                    continue;
                                }
                                holder = new ItemHolder();
                                holder.setItemID(itemIDs[i]);
                                holder.getSKUs().put(productIDs[i], "plugandplaytoyz");
                                plug_itemList.put(itemIDs[i], holder);
                                continue;
                            }
                            if (!((String)accountNameList.get(accountPos)).equals("gothfashions")) continue;
                            if (goth_itemList.containsKey(itemIDs[i])) {
                                ((ItemHolder)goth_itemList.get(itemIDs[i])).getSKUs().put(productIDs[i], "gothfashions");
                                continue;
                            }
                            holder = new ItemHolder();
                            holder.setItemID(itemIDs[i]);
                            holder.getSKUs().put(productIDs[i], "gothfashions");
                            goth_itemList.put(itemIDs[i], holder);
                        }
                    }
                }
                ItemHolder[] pnpItems = pnp_itemList.values().toArray(new ItemHolder[0]);
                ItemHolder[] plugItems = plug_itemList.values().toArray(new ItemHolder[0]);
                ItemHolder[] gothItems = goth_itemList.values().toArray(new ItemHolder[0]);
                for (int i3 = 0; i3 < pnpItems.length - 1; ++i3) {
                    ItemHolder matchedItem;
                    String sku2;
                    Iterator<String> secondIter;
                    String sku1;
                    Iterator<String> firstIter;
                    boolean found;
                    int j;
                    for (j = 1; j < pnpItems.length; ++j) {
                        found = true;
                        firstIter = pnpItems[i3].getSKUs().keySet().iterator();
                        while (firstIter.hasNext() && found) {
                            sku1 = firstIter.next();
                            secondIter = pnpItems[j].getSKUs().keySet().iterator();
                            while (secondIter.hasNext() && found) {
                                sku2 = secondIter.next();
                                if (sku1.contains(sku2) || sku2.contains(sku1)) continue;
                                found = false;
                            }
                        }
                        if (!found) {
                            found = true;
                            firstIter = pnpItems[j].getSKUs().keySet().iterator();
                            while (firstIter.hasNext() && found) {
                                sku1 = firstIter.next();
                                secondIter = pnpItems[i3].getSKUs().keySet().iterator();
                                while (secondIter.hasNext() && found) {
                                    sku2 = secondIter.next();
                                    if (sku1.contains(sku2) || sku2.contains(sku1)) continue;
                                    found = false;
                                }
                            }
                        }
                        if (!found) continue;
                        if (matchedListings.containsKey(pnpItems[i3].getItemID())) {
                            ((ItemHolder)matchedListings.get(pnpItems[i3].getItemID())).getSKUs().put(pnpItems[j].getItemID(), "pnp_inc");
                            continue;
                        }
                        matchedItem = new ItemHolder();
                        matchedItem.getSKUs().put(pnpItems[j].getItemID(), "pnp_inc");
                        matchedItem.setItemID(pnpItems[i3].getItemID());
                        matchedListings.put(pnpItems[i3].getItemID(), matchedItem);
                    }
                    for (j = 0; j < gothItems.length; ++j) {
                        found = true;
                        firstIter = pnpItems[i3].getSKUs().keySet().iterator();
                        while (firstIter.hasNext() && found) {
                            sku1 = firstIter.next();
                            secondIter = gothItems[j].getSKUs().keySet().iterator();
                            while (secondIter.hasNext() && found) {
                                sku2 = secondIter.next();
                                if (sku1.contains(sku2) || sku2.contains(sku1)) continue;
                                found = false;
                            }
                        }
                        if (!found) {
                            found = true;
                            firstIter = gothItems[j].getSKUs().keySet().iterator();
                            while (firstIter.hasNext() && found) {
                                sku1 = firstIter.next();
                                secondIter = pnpItems[i3].getSKUs().keySet().iterator();
                                while (secondIter.hasNext() && found) {
                                    sku2 = secondIter.next();
                                    if (sku1.contains(sku2) || sku2.contains(sku1)) continue;
                                    found = false;
                                }
                            }
                        }
                        if (!found) continue;
                        if (matchedListings.containsKey(pnpItems[i3].getItemID())) {
                            ((ItemHolder)matchedListings.get(pnpItems[i3].getItemID())).getSKUs().put(gothItems[j].getItemID(), "gothfashions");
                            continue;
                        }
                        matchedItem = new ItemHolder();
                        matchedItem.getSKUs().put(gothItems[j].getItemID(), "gothfashions");
                        matchedItem.setItemID(pnpItems[i3].getItemID());
                        matchedListings.put(pnpItems[i3].getItemID(), matchedItem);
                    }
                    for (j = 0; j < plugItems.length; ++j) {
                        found = true;
                        firstIter = pnpItems[i3].getSKUs().keySet().iterator();
                        while (firstIter.hasNext() && found) {
                            sku1 = firstIter.next();
                            secondIter = plugItems[j].getSKUs().keySet().iterator();
                            while (secondIter.hasNext() && found) {
                                sku2 = secondIter.next();
                                if (sku1.contains(sku2) || sku2.contains(sku1)) continue;
                                found = false;
                            }
                        }
                        if (!found) {
                            found = true;
                            firstIter = plugItems[j].getSKUs().keySet().iterator();
                            while (firstIter.hasNext() && found) {
                                sku1 = firstIter.next();
                                secondIter = pnpItems[i3].getSKUs().keySet().iterator();
                                while (secondIter.hasNext() && found) {
                                    sku2 = secondIter.next();
                                    if (sku1.contains(sku2) || sku2.contains(sku1)) continue;
                                    found = false;
                                }
                            }
                        }
                        if (!found) continue;
                        if (matchedListings.containsKey(pnpItems[i3].getItemID())) {
                            ((ItemHolder)matchedListings.get(pnpItems[i3].getItemID())).getSKUs().put(plugItems[j].getItemID(), "plugandplaytoyz");
                            continue;
                        }
                        matchedItem = new ItemHolder();
                        matchedItem.getSKUs().put(plugItems[j].getItemID(), "plugandplaytoyz");
                        matchedItem.setItemID(pnpItems[i3].getItemID());
                        matchedListings.put(pnpItems[i3].getItemID(), matchedItem);
                    }
                }
                ItemHolder[] items = matchedListings.values().toArray(new ItemHolder[0]);
                for (i = 0; i < items.length; ++i) {
                    Iterator duplicateIter;
                    Iterator<String> itemIter = items[i].getSKUs().keySet().iterator();
                    ArrayList<String> adultListings = new ArrayList<String>();
                    ArrayList<String> nonAdultListings = new ArrayList<String>();
                    while (itemIter.hasNext()) {
                        String itemID = itemIter.next();
                        String accountName = items[i].getSKUs().get(itemID);
                        ApiContext context = this.contextMapping.get(accountName);
                        ApiCall call = new ApiCall(context);
                        GetItemRequestType itemRequestType = new GetItemRequestType();
                        itemRequestType.setItemID(itemID);
                        try {
                            AbstractResponseType response = call.executeByApiName("GetItem", (AbstractRequestType)itemRequestType);
                            GetItemResponseType itemResponseType = (GetItemResponseType)response;
                            if (itemResponseType.getItem().getListingDetails().isAdult().booleanValue()) {
                                adultListings.add(itemID);
                                continue;
                            }
                            nonAdultListings.add(itemID);
                        }
                        catch (Exception ex) {
                            ErrorsUtil.getInstance().logError(ex);
                        }
                    }
                    if (adultListings.size() > 1) {
                        duplicateIter = adultListings.iterator();
                        while (duplicateIter.hasNext()) {
                            bufferedWriter.write((String)duplicateIter.next() + " ");
                        }
                        bufferedWriter.newLine();
                    }
                    if (nonAdultListings.size() <= 1) continue;
                    duplicateIter = nonAdultListings.iterator();
                    while (duplicateIter.hasNext()) {
                        bufferedWriter.write((String)duplicateIter.next() + " ");
                    }
                    bufferedWriter.newLine();
                }
                bufferedWriter.close();
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
    }

    private void createHandlers() {
        String strBaseURL = "http://svcs.ebay.com/services/search/FindingService/v1";
        FindingService service = new FindingService();
        this.port = service.getFindingServiceSOAPPort();
        BindingProvider bp = (BindingProvider)this.port;
        Map requestProperties = bp.getRequestContext();
        HashMap<String, List<String>> httpHeaders = new HashMap<String, List<String>>();
        httpHeaders.put("X-EBAY-SOA-MESSAGE-PROTOCOL", Collections.singletonList("SOAP12"));
        httpHeaders.put("X-EBAY-SOA-OPERATION-NAME", Collections.singletonList("findItemsAdvanced"));
        httpHeaders.put("X-EBAY-SOA-SECURITY-APPNAME", Collections.singletonList(APP_ID));
        requestProperties.put("javax.xml.ws.http.request.headers", httpHeaders);
        requestProperties.put("javax.xml.ws.service.endpoint.address", strBaseURL);
    }

    public ArrayList<SearchItem> findItem(String itemName, Float pricePoint, int entries) {
        if (this.port == null) {
            this.createHandlers();
        }
        FindItemsAdvancedRequest request = new FindItemsAdvancedRequest();
        request.setSortOrder(SortOrderType.PRICE_PLUS_SHIPPING_LOWEST);
        PaginationInput pi = new PaginationInput();
        pi.setEntriesPerPage(Integer.valueOf(entries));
        request.setPaginationInput(pi);
        request.setKeywords(itemName);
        request.getCategoryId().add("176992");
        request.getCategoryId().add("176997");
        request.getCategoryId().add("176996");
        FindItemsAdvancedResponse result = this.port.findItemsAdvanced(request);
        ArrayList<SearchItem> searchResults = new ArrayList<SearchItem>();
        if (result.getAck().equals((Object)AckValue.SUCCESS)) {
            for (SearchItem searchItem : result.getSearchResult().getItem()) {
                if (searchItem.getListingInfo() == null || !searchItem.getListingInfo().isBuyItNowAvailable().booleanValue()) continue;
                searchResults.add(searchItem);
            }
        }
        return searchResults;
    }

    public void addItem(Listing newListing) {
        try {
            ItemType item = newListing.finalizeAndCreateListing();
            if (item != null && this.contextMapping.containsKey(newListing.getAccountName())) {
                ApiContext context = this.contextMapping.get(newListing.getAccountName());
                ApiCall call = new ApiCall(context);
                VerifyAddItemRequestType request = new VerifyAddItemRequestType();
                request.setItem(item);
                VerifyAddItemResponseType response = (VerifyAddItemResponseType)call.executeByApiName("VerifyAddItem", (AbstractRequestType)request);
                float totalCost = 0.0f;
                for (FeeType fee : response.getFees().getFee()) {
                    totalCost = (float)((double)totalCost + fee.getFee().getValue());
                }
                if (response.getAck().equals((Object)AckCodeType.SUCCESS)) {
                    boolean catch3 = false;
                } else {
                    boolean catch3 = false;
                }
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    private ItemType createItem() {
        CurrencyCodeType mainCurrency = CurrencyCodeType.USD;
        CountryCodeType country = CountryCodeType.US;
        int maxDispatchTime = 3;
        BuyerPaymentMethodCodeType[] paymentMethods = new BuyerPaymentMethodCodeType[]{BuyerPaymentMethodCodeType.PAY_PAL};
        String paypalEmail = "sales@plugnplaytoyz.com";
        String zipCode = "33716";
        SiteCodeType ebaySite = SiteCodeType.US;
        boolean categoryMappingAllowed = true;
        String returnPolicyDescription = "If you are not satisfied, return the book for refund.";
        String returnsPaidBy = "Buyer";
        String returnsAcceptedOption = "ReturnsAccepted";
        String refundOption = "MoneyBack";
        String returnsWithinOption = "Days_30";
        ListingDurationCodeType listingDuration = ListingDurationCodeType.GTC;
        ListingTypeCodeType listingType = ListingTypeCodeType.FIXED_PRICE_ITEM;
        ShippingTypeCodeType shippingType = ShippingTypeCodeType.FLAT;
        int shippingServicePriority = 1;
        double shippingCostValue = 2.5;
        String shippingServiceName = "USPSMedia";
        String title = "Harry Potter and the Philosopher's Stone";
        String description = "This is the first book in the Harry Potter series. In excellent condition!";
        String primaryCategory = "377";
        Object secondaryCategory = null;
        double startPrice = 1.0;
        int conditionID = 1000;
        int quantity = 7;
        String[] pictures = new String[]{"http://i1.sandbox.ebayimg.com/03/i/00/30/07/20_1.JPG?set_id=8800005007"};
        ItemType item = new ItemType();
        item.setCountry(country);
        item.setCurrency(mainCurrency);
        item.setConditionID(Integer.valueOf(conditionID));
        item.setDispatchTimeMax(Integer.valueOf(maxDispatchTime));
        item.setListingDuration(listingDuration.name());
        item.setListingType(listingType);
        item.setPaymentMethods(paymentMethods);
        item.setPayPalEmailAddress(paypalEmail);
        item.setPostalCode(zipCode);
        item.setQuantity(Integer.valueOf(quantity));
        item.setSite(ebaySite);
        item.setTitle(title);
        item.setDescription(description);
        PictureDetailsType pictureDetailsType = new PictureDetailsType();
        pictureDetailsType.setPictureURL(pictures);
        item.setPictureDetails(pictureDetailsType);
        CategoryType primaryCategoryType = new CategoryType();
        primaryCategoryType.setCategoryID(primaryCategory);
        item.setPrimaryCategory(primaryCategoryType);
        AmountType startPriceType = new AmountType();
        startPriceType.setCurrencyID(mainCurrency);
        startPriceType.setValue(startPrice);
        item.setStartPrice(startPriceType);
        item.setCategoryMappingAllowed(Boolean.valueOf(categoryMappingAllowed));
        ReturnPolicyType returnPolicy = new ReturnPolicyType();
        returnPolicy.setReturnsAcceptedOption(returnsAcceptedOption);
        returnPolicy.setRefundOption(refundOption);
        returnPolicy.setReturnsWithinOption(returnsWithinOption);
        returnPolicy.setDescription(returnPolicyDescription);
        returnPolicy.setShippingCostPaidByOption(returnsPaidBy);
        item.setReturnPolicy(returnPolicy);
        ShippingDetailsType shippingDetails = new ShippingDetailsType();
        shippingDetails.setShippingType(shippingType);
        ShippingServiceOptionsType shippingType1 = new ShippingServiceOptionsType();
        shippingType1.setShippingServicePriority(Integer.valueOf(shippingServicePriority));
        AmountType shippingCost = new AmountType();
        shippingCost.setCurrencyID(mainCurrency);
        shippingCost.setValue(shippingCostValue);
        AmountType shippingCostAdd = new AmountType();
        shippingCostAdd.setCurrencyID(mainCurrency);
        shippingCostAdd.setValue(0.0);
        shippingType1.setShippingServiceCost(shippingCost);
        shippingType1.setShippingService(shippingServiceName);
        shippingType1.setShippingServiceAdditionalCost(shippingCost);
        ShippingServiceOptionsType[] shippingServiceOptions = new ShippingServiceOptionsType[]{shippingType1};
        shippingDetails.setShippingServiceOptions(shippingServiceOptions);
        item.setShippingDetails(shippingDetails);
        String itemSku = "aa100";
        item.setItemID(itemSku);
        item.setSKU(itemSku);
        return item;
    }

    private ItemType testThing() {
        ItemType test = new ItemType();
        test.setAutoPay(Boolean.TRUE);
        test.setBuyerProtection(BuyerProtectionCodeType.ITEM_ELIGIBLE);
        test.setCountry(CountryCodeType.US);
        test.setCurrency(CurrencyCodeType.USD);
        test.setHitCounter(HitCounterCodeType.HIDDEN_STYLE);
        test.setListingDuration(ListingDurationCodeType.GTC.name());
        test.setListingType(ListingTypeCodeType.FIXED_PRICE_ITEM);
        test.setPayPalEmailAddress("pnp.inc.ebay@gmail.com");
        test.setPrivateListing(Boolean.TRUE);
        test.setQuantity(Integer.valueOf(122));
        test.setSite(SiteCodeType.US);
        test.setTitle("One Pierceless Nipple Ring Sexy Jewelry Metal New Light Erotic Nipple Clamp ");
        test.setDescription("Test Description");
        test.setGetItFast(Boolean.FALSE);
        test.setSKU("ac370");
        test.setPostalCode("33742");
        test.setDispatchTimeMax(Integer.valueOf(1));
        test.setProxyItem(Boolean.FALSE);
        test.setConditionID(Integer.valueOf(1000));
        test.setPictureDetails(new PictureDetailsType());
        test.getPictureDetails().setPictureURL(new String[]{"http://i1.sandbox.ebayimg.com/03/i/00/30/07/20_1.JPG?set_id=8800005007"});
        test.setBuyItNowPrice(new AmountType());
        test.getBuyItNowPrice().setCurrencyID(CurrencyCodeType.USD);
        test.getBuyItNowPrice().setValue(0.0);
        test.setReservePrice(new AmountType());
        test.getReservePrice().setCurrencyID(CurrencyCodeType.USD);
        test.getReservePrice().setValue(0.0);
        test.setStartPrice(new AmountType());
        test.getStartPrice().setCurrencyID(CurrencyCodeType.USD);
        test.getStartPrice().setValue(5.2);
        test.setBuyerGuaranteePrice(new AmountType());
        test.getBuyerGuaranteePrice().setCurrencyID(CurrencyCodeType.USD);
        test.getBuyerGuaranteePrice().setValue(200000.0);
        test.setShipToLocations(new String[]{"US", "CA", "AU"});
        test.setPaymentMethods(new BuyerPaymentMethodCodeType[]{BuyerPaymentMethodCodeType.PAY_PAL});
        test.setBuyerRequirementDetails(new BuyerRequirementDetailsType());
        test.getBuyerRequirementDetails().setMaximumUnpaidItemStrikesInfo(new MaximumUnpaidItemStrikesInfoType());
        test.getBuyerRequirementDetails().getMaximumUnpaidItemStrikesInfo().setCount(Integer.valueOf(2));
        test.getBuyerRequirementDetails().getMaximumUnpaidItemStrikesInfo().setPeriod(PeriodCodeType.DAYS_180);
        test.getBuyerRequirementDetails().setShipToRegistrationCountry(Boolean.TRUE);
        test.setReturnPolicy(new ReturnPolicyType());
        test.getReturnPolicy().setRefundOption("MoneyBackOrExchange");
        test.getReturnPolicy().setDescription("With the exception of defective items, returns will only be accepted on unused/unopened items. For opened items which are defective we will exchange for same item. For certain non-adult / non-intimate items we will allow exchanges for different sizes at buyers expense. Refund will be given of item price minus our actual shipping costs, regardless of whether or not item is listed with free shipping.");
        test.getReturnPolicy().setRefund("Money back or exchange (buyer's choice)");
        test.getReturnPolicy().setReturnsAccepted("Returns Accepted");
        test.getReturnPolicy().setReturnsAcceptedOption("ReturnsAccepted");
        test.getReturnPolicy().setReturnsWithin("14 Days");
        test.getReturnPolicy().setReturnsWithinOption("Days_14");
        test.getReturnPolicy().setShippingCostPaidBy("Buyer");
        test.getReturnPolicy().setShippingCostPaidByOption("Buyer");
        test.setPrimaryCategory(new CategoryType());
        test.getPrimaryCategory().setCategoryID("176997");
        test.setShippingDetails(new ShippingDetailsType());
        test.getShippingDetails().setApplyShippingDiscount(Boolean.FALSE);
        test.getShippingDetails().setExcludeShipToLocation(new String[]{"Africa", "Middle East", "KH", "ID", "LA", "MO", "MY", "MX"});
        test.getShippingDetails().setInternationalShippingDiscountProfileID("0");
        InternationalShippingServiceOptionsType USPSFirstClassMailInternational = new InternationalShippingServiceOptionsType();
        USPSFirstClassMailInternational.setShipToLocation(new String[]{"CA"});
        USPSFirstClassMailInternational.setShippingService("USPSFirstClassMailInternational");
        USPSFirstClassMailInternational.setShippingServicePriority(Integer.valueOf(1));
        InternationalShippingServiceOptionsType USPSPriorityMailInternational = new InternationalShippingServiceOptionsType();
        USPSPriorityMailInternational.setShipToLocation(new String[]{"CA"});
        USPSPriorityMailInternational.setShippingService("USPSPriorityMailInternational");
        USPSPriorityMailInternational.setShippingServicePriority(Integer.valueOf(2));
        InternationalShippingServiceOptionsType USPSExpressMailInternational = new InternationalShippingServiceOptionsType();
        USPSExpressMailInternational.setShipToLocation(new String[]{"CA"});
        USPSExpressMailInternational.setShippingService("USPSExpressMailInternational");
        USPSExpressMailInternational.setShippingServicePriority(Integer.valueOf(3));
        test.getShippingDetails().setInternationalShippingServiceOption(new InternationalShippingServiceOptionsType[]{USPSFirstClassMailInternational, USPSPriorityMailInternational, USPSExpressMailInternational});
        test.getShippingDetails().setSalesTax(new SalesTaxType());
        test.getShippingDetails().getSalesTax().setSalesTaxPercent(Float.valueOf(7.0f));
        test.getShippingDetails().getSalesTax().setSalesTaxState("FL");
        test.getShippingDetails().getSalesTax().setShippingIncludedInTax(Boolean.FALSE);
        test.getShippingDetails().setSellerExcludeShipToLocationsPreference(Boolean.TRUE);
        test.getShippingDetails().setShippingDiscountProfileID("0");
        test.getShippingDetails().setShippingType(ShippingTypeCodeType.CALCULATED);
        ShippingServiceOptionsType USPSFirstClass = new ShippingServiceOptionsType();
        USPSFirstClass.setExpeditedService(Boolean.FALSE);
        USPSFirstClass.setFreeShipping(Boolean.TRUE);
        USPSFirstClass.setShippingService("USPSFirstClass");
        USPSFirstClass.setShippingServicePriority(Integer.valueOf(1));
        USPSFirstClass.setShippingTimeMax(Integer.valueOf(5));
        USPSFirstClass.setShippingTimeMin(Integer.valueOf(2));
        ShippingServiceOptionsType USPSPriority = new ShippingServiceOptionsType();
        USPSPriority.setExpeditedService(Boolean.FALSE);
        USPSPriority.setShippingService("USPSPriority");
        USPSPriority.setShippingServicePriority(Integer.valueOf(2));
        USPSPriority.setShippingTimeMax(Integer.valueOf(3));
        USPSPriority.setShippingTimeMin(Integer.valueOf(1));
        ShippingServiceOptionsType USPSExpressMail = new ShippingServiceOptionsType();
        USPSExpressMail.setExpeditedService(Boolean.FALSE);
        USPSExpressMail.setShippingService("USPSExpressMail");
        USPSExpressMail.setShippingServicePriority(Integer.valueOf(3));
        USPSExpressMail.setShippingTimeMax(Integer.valueOf(1));
        USPSExpressMail.setShippingTimeMin(Integer.valueOf(1));
        test.getShippingDetails().setShippingServiceOptions(new ShippingServiceOptionsType[]{USPSFirstClass, USPSPriority, USPSExpressMail});
        test.getShippingDetails().setCalculatedShippingRate(new CalculatedShippingRateType());
        test.getShippingDetails().getCalculatedShippingRate().setInternationalPackagingHandlingCosts(new AmountType());
        test.getShippingDetails().getCalculatedShippingRate().getInternationalPackagingHandlingCosts().setCurrencyID(CurrencyCodeType.USD);
        test.getShippingDetails().getCalculatedShippingRate().getInternationalPackagingHandlingCosts().setValue(3.0);
        test.getShippingDetails().getCalculatedShippingRate().setOriginatingPostalCode("33742");
        test.getShippingDetails().getCalculatedShippingRate().setShippingIrregular(Boolean.FALSE);
        test.getShippingDetails().getCalculatedShippingRate().setShippingPackage(ShippingPackageCodeType.PACKAGE_THICK_ENVELOPE);
        BigDecimal Three = new BigDecimal(3);
        BigDecimal Six = new BigDecimal(6);
        BigDecimal Eight = new BigDecimal(8);
        test.getShippingDetails().getCalculatedShippingRate().setPackageDepth(new MeasureType());
        test.getShippingDetails().getCalculatedShippingRate().getPackageDepth().setMeasurementSystem(MeasurementSystemCodeType.ENGLISH);
        test.getShippingDetails().getCalculatedShippingRate().getPackageDepth().setUnit("inches");
        test.getShippingDetails().getCalculatedShippingRate().getPackageDepth().setValue(BigDecimal.ZERO);
        test.getShippingDetails().getCalculatedShippingRate().setPackageLength(new MeasureType());
        test.getShippingDetails().getCalculatedShippingRate().getPackageLength().setMeasurementSystem(MeasurementSystemCodeType.ENGLISH);
        test.getShippingDetails().getCalculatedShippingRate().getPackageLength().setUnit("inches");
        test.getShippingDetails().getCalculatedShippingRate().getPackageLength().setValue(BigDecimal.ZERO);
        test.getShippingDetails().getCalculatedShippingRate().setPackageWidth(new MeasureType());
        test.getShippingDetails().getCalculatedShippingRate().getPackageWidth().setMeasurementSystem(MeasurementSystemCodeType.ENGLISH);
        test.getShippingDetails().getCalculatedShippingRate().getPackageWidth().setUnit("inches");
        test.getShippingDetails().getCalculatedShippingRate().getPackageWidth().setValue(BigDecimal.ZERO);
        test.getShippingDetails().getCalculatedShippingRate().setPackagingHandlingCosts(new AmountType());
        test.getShippingDetails().getCalculatedShippingRate().getPackagingHandlingCosts().setCurrencyID(CurrencyCodeType.USD);
        test.getShippingDetails().getCalculatedShippingRate().getPackagingHandlingCosts().setValue(0.0);
        test.getShippingDetails().getCalculatedShippingRate().setWeightMajor(new MeasureType());
        test.getShippingDetails().getCalculatedShippingRate().getWeightMajor().setMeasurementSystem(MeasurementSystemCodeType.ENGLISH);
        test.getShippingDetails().getCalculatedShippingRate().getWeightMajor().setUnit("lbs");
        test.getShippingDetails().getCalculatedShippingRate().getWeightMajor().setValue(BigDecimal.ZERO);
        test.getShippingDetails().getCalculatedShippingRate().setWeightMinor(new MeasureType());
        test.getShippingDetails().getCalculatedShippingRate().getWeightMinor().setMeasurementSystem(MeasurementSystemCodeType.ENGLISH);
        test.getShippingDetails().getCalculatedShippingRate().getWeightMinor().setUnit("oz");
        test.getShippingDetails().getCalculatedShippingRate().getWeightMinor().setValue(Three);
        return test;
    }

    private class ItemHolder {
        String itemID;
        HashMap<String, String> SKUs = new HashMap();

        public HashMap<String, String> getSKUs() {
            return this.SKUs;
        }

        public void setSKUs(HashMap<String, String> SKUs) {
            this.SKUs = SKUs;
        }

        public String getItemID() {
            return this.itemID;
        }

        public void setItemID(String itemID) {
            this.itemID = itemID;
        }
    }
}

