/*
 * Decompiled with CFR 0.152.
 */
package pnp.comm.ebay;

import com.ebay.marketplace.search.v1.services.SearchItem;
import com.ebay.soap.eBLBaseComponents.ItemType;
import com.ebay.soap.eBLBaseComponents.TransactionType;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import javax.swing.JOptionPane;
import pnp.comm.ebay.EbayConnectionManager;
import pnp.services.datatypes.CompleteOrder;
import pnp.services.datatypes.Listing;
import pnp.services.datatypes.OrderDetails;
import pnp.services.datatypes.ebaysync.EbayListingContainer;
import pnp.services.datatypes.ebaysync.SyncListingContainer;
import pnp.services.ebay.EbayServices;
import pnp.services.util.ErrorsUtil;
import pnp.services.util.LookupServicesUtil;

public class EbayServicesImpl
implements EbayServices {
    public String getCurrentTime() {
        String currentTime = EbayConnectionManager.getInstance().getCurrentTime();
        if (null == currentTime || currentTime.equals("UNKNOWN")) {
            JOptionPane.showMessageDialog(null, "Error communicating with eBay, please wait a moment and then try again. \n\n If problem persists please contact support@handsupsolutions.com.");
        }
        return currentTime;
    }

    public void refreshTransactions(String refreshTime) {
        if (!EbayConnectionManager.getInstance().isUpdatePending()) {
            EbayConnectionManager.getInstance().setUpdatePending(true);
            final String refreshPoint = refreshTime;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Calendar endTime = Calendar.getInstance();
                        endTime.setTimeInMillis(System.currentTimeMillis());
                        TransactionType[] transactions = EbayConnectionManager.getInstance().getSellerTransactions(refreshPoint, endTime);
                        if (null == transactions) {
                            JOptionPane.showMessageDialog(null, "Error refreshing transactions, please wait a moment and then try again. \n\n If problem persists please contact support@handsupsolutions.com.");
                        }
                        LookupServicesUtil.getDBServices().processTransactionUpdate(transactions);
                    }
                    catch (Exception ex) {
                        ErrorsUtil.getInstance().logError(ex);
                    }
                    EbayConnectionManager.getInstance().setUpdatePending(false);
                    EbayConnectionManager.getInstance().notifyUpdateListeners();
                }
            }).start();
        }
    }

    public void refreshShipping(CompleteOrder completeOrder) {
        EbayConnectionManager.getInstance().refreshShipping(completeOrder);
    }

    public ArrayList<ArrayList<ItemType>> getActiveItems() {
        ArrayList<ArrayList<ItemType>> activeItems = EbayConnectionManager.getInstance().getActiveItems();
        if (null == activeItems) {
            JOptionPane.showMessageDialog(null, "Error retrieving active listings, please wait a moment and then try again. \n\n If problem persists please contact support@handsupsolutions.com.");
        }
        return activeItems;
    }

    public boolean updateTracking(OrderDetails orderDetails) {
        return EbayConnectionManager.getInstance().updateTracking(orderDetails);
    }

    public boolean createUser(String username) {
        return EbayConnectionManager.getInstance().createUser(username);
    }

    public long getUpdatePercentage() {
        return EbayConnectionManager.getInstance().getUpdatePercentage();
    }

    public boolean updatePending() {
        return EbayConnectionManager.getInstance().isUpdatePending();
    }

    public ArrayList<SyncListingContainer> generateSyncListings(ArrayList<String> oosItems, HashMap<String, EbayListingContainer> listingMap, boolean instockToggle) {
        return EbayConnectionManager.getInstance().generateSyncListings(oosItems, listingMap, instockToggle);
    }

    public String performSync(ArrayList<SyncListingContainer> syncListingsList, boolean instockToggle, boolean useStockQty, int defaultQuantity, int batch, boolean endListing) {
        return EbayConnectionManager.getInstance().performSync(syncListingsList, instockToggle, useStockQty, defaultQuantity, batch, endListing, false);
    }

    public ArrayList<SearchItem> findItem(String itemName, Float pricePoint, int entries) {
        return EbayConnectionManager.getInstance().findItem(itemName, pricePoint, entries);
    }

    public void addItem(Listing newListing) {
        EbayConnectionManager.getInstance().addItem(newListing);
    }
}

