/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.adhoc;

import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.dynamicreports.adhoc.configuration.AdhocConfiguration;
import net.sf.dynamicreports.adhoc.configuration.AdhocReport;
import net.sf.dynamicreports.adhoc.report.AdhocReportCustomizer;
import net.sf.dynamicreports.adhoc.report.DefaultAdhocReportCustomizer;
import net.sf.dynamicreports.adhoc.transformation.AdhocToXmlTransform;
import net.sf.dynamicreports.adhoc.transformation.XmlToAdhocTransform;
import net.sf.dynamicreports.adhoc.xmlconfiguration.ObjectFactory;
import net.sf.dynamicreports.adhoc.xmlconfiguration.XmlAdhocConfiguration;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.ReportBuilder;
import net.sf.dynamicreports.report.exception.DRException;

public class AdhocManager {
    private static AdhocToXmlTransform adhocToXmlTransform = new AdhocToXmlTransform();
    private static XmlToAdhocTransform xmlToAdhocTransform = new XmlToAdhocTransform();

    public static JasperReportBuilder createReport(AdhocReport adhocReport) throws DRException {
        return AdhocManager.createReport(adhocReport, new DefaultAdhocReportCustomizer());
    }

    public static JasperReportBuilder createReport(AdhocReport adhocReport, AdhocReportCustomizer adhocReportCustomizer) throws DRException {
        JasperReportBuilder report = DynamicReports.report();
        adhocReportCustomizer.customize((ReportBuilder<?>)report, adhocReport);
        return report;
    }

    public static void saveConfiguration(AdhocConfiguration adhocConfiguration, OutputStream os) throws DRException {
        XmlAdhocConfiguration xmlAdhocConfiguration = adhocToXmlTransform.transform(adhocConfiguration);
        try {
            Marshaller marshaller = JAXBContext.newInstance((Class[])new Class[]{XmlAdhocConfiguration.class}).createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            JAXBElement<XmlAdhocConfiguration> element = new ObjectFactory().createConfiguration(xmlAdhocConfiguration);
            marshaller.marshal(element, (Result)new StreamResult(os));
        }
        catch (JAXBException e) {
            throw new DRException((Throwable)e);
        }
    }

    public static AdhocConfiguration loadConfiguration(InputStream is) throws DRException {
        try {
            Unmarshaller unmarshaller = JAXBContext.newInstance((Class[])new Class[]{XmlAdhocConfiguration.class}).createUnmarshaller();
            JAXBElement element = unmarshaller.unmarshal((Source)new StreamSource(is), XmlAdhocConfiguration.class);
            XmlAdhocConfiguration xmlAdhocConfiguration = (XmlAdhocConfiguration)element.getValue();
            AdhocConfiguration adhocConfiguration = xmlToAdhocTransform.transform(xmlAdhocConfiguration);
            return adhocConfiguration;
        }
        catch (JAXBException e) {
            throw new DRException((Throwable)e);
        }
    }
}

