/*
 * Decompiled with CFR 0.152.
 */
package pnp.comms.db;

import com.ebay.soap.eBLBaseComponents.TransactionType;
import java.sql.Date;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import pnp.comms.db.EBayTransactionManager;
import pnp.comms.db.PNPDatabaseManager;
import pnp.comms.db.lists.AccountPreferencesList;
import pnp.comms.db.lists.AmazonAccountsList;
import pnp.comms.db.lists.CategoryAssociationsList;
import pnp.comms.db.lists.CategoryList;
import pnp.comms.db.lists.CheckDetailsList;
import pnp.comms.db.lists.CompletedOrderList;
import pnp.comms.db.lists.CustomFeeList;
import pnp.comms.db.lists.DistributorList;
import pnp.comms.db.lists.EtsyAccountsList;
import pnp.comms.db.lists.ExpenseList;
import pnp.comms.db.lists.ExpenseReasonsList;
import pnp.comms.db.lists.InventoryList;
import pnp.comms.db.lists.OOSList;
import pnp.comms.db.lists.OrderList;
import pnp.comms.db.lists.OrderStatusList;
import pnp.comms.db.lists.PrintDetailsList;
import pnp.comms.db.lists.RESTList;
import pnp.comms.db.lists.RMAList;
import pnp.comms.db.lists.RMAReasonList;
import pnp.comms.db.lists.RMAStatusList;
import pnp.comms.db.lists.ShippingMethodList;
import pnp.comms.db.lists.WebsiteCategoriesList;
import pnp.comms.db.lists.WebsiteInventoryList;
import pnp.comms.db.lists.WebsiteList;
import pnp.services.datatypes.AccountPreferences;
import pnp.services.datatypes.AmazonAccount;
import pnp.services.datatypes.Category;
import pnp.services.datatypes.CategoryAssociation;
import pnp.services.datatypes.CheckDetails;
import pnp.services.datatypes.CompleteOrder;
import pnp.services.datatypes.CustomFee;
import pnp.services.datatypes.Customer;
import pnp.services.datatypes.Distributor;
import pnp.services.datatypes.EtsyAccount;
import pnp.services.datatypes.EtsyOrder;
import pnp.services.datatypes.Expense;
import pnp.services.datatypes.ExpenseReason;
import pnp.services.datatypes.InventoryElement;
import pnp.services.datatypes.Item;
import pnp.services.datatypes.Order;
import pnp.services.datatypes.OrderDetails;
import pnp.services.datatypes.OrderStatus;
import pnp.services.datatypes.PaypalDetails;
import pnp.services.datatypes.PrintDetails;
import pnp.services.datatypes.RESTData;
import pnp.services.datatypes.RMADetails;
import pnp.services.datatypes.RMAReason;
import pnp.services.datatypes.RMAStatus;
import pnp.services.datatypes.SalesTax;
import pnp.services.datatypes.ShippingMethod;
import pnp.services.datatypes.webservices.Website;
import pnp.services.datatypes.webservices.WebsiteCategories;
import pnp.services.datatypes.webservices.WebsiteElement;
import pnp.services.datatypes.webservices.WebsiteProduct;
import pnp.services.db.DBServices;
import pnp.services.listener.GenericListener;
import pnp.services.listenermanager.ListenerManager;
import pnp.services.util.DatabaseConnector;
import pnp.services.util.ErrorsUtil;
import pnp.services.util.GenericFunctions;

public class DBServicesImpl
implements DBServices {
    public static String currentProfile = "DEFAULT";

    public void addAmazonOrders(Collection<CompleteOrder> amazonOrderList) {
        PNPDatabaseManager.getInstance().addAmazonOrders(amazonOrderList);
        ListenerManager.getInstance().notify((GenericListener)ListenerManager.TRANSACTION_LISTENER);
    }

    public void addEtsyOrders(HashMap<String, EtsyOrder> etsyOrderList) {
        PNPDatabaseManager.getInstance().addEtsyOrders(etsyOrderList);
        ListenerManager.getInstance().notify((GenericListener)ListenerManager.TRANSACTION_LISTENER);
    }

    public void updateAmazonAccount(AmazonAccount account) {
        AmazonAccountsList.getInstance().updateAmazonAccount(account);
    }

    public AmazonAccount getAmazonAccountAccount() {
        return AmazonAccountsList.getInstance().getAmazonAccount();
    }

    public void updateEtsyAccount(EtsyAccount account) {
        EtsyAccountsList.getInstance().updateEtsyAccount(account);
    }

    public void deleteEtsyAccount(String etsyStore, String etsyLogin) {
        EtsyAccountsList.getInstance().deleteEtsyAccount(etsyStore, etsyLogin);
    }

    public ArrayList<EtsyAccount> getEtsyAccounts() {
        return EtsyAccountsList.getInstance().getEtsyAccounts();
    }

    public boolean startup() {
        this.refreshExpenseReasonList(true);
        this.refreshDistributorList(true);
        this.refreshWebsiteList(true);
        return true;
    }

    public void updateRESTData(RESTData restData) {
        RESTList.getInstance().updateRESTData(restData);
    }

    public RESTData getRESTData(String userName) {
        return RESTList.getInstance().getRESTdata(userName);
    }

    public String getLicense() {
        ResultSet rs = PNPDatabaseManager.getInstance().getLicense();
        String license = null;
        if (rs != null) {
            try {
                if (rs.next()) {
                    license = rs.getString("License");
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        DatabaseConnector.removeObject((ResultSet)rs);
        return license;
    }

    public void setLicense(String license) {
        PNPDatabaseManager.getInstance().setLicense(license);
    }

    public DBServicesImpl() {
        PNPDatabaseManager.getInstance();
        EBayTransactionManager.getInstance();
    }

    public boolean renameCompany(String companySelected, String companyRenamed) {
        return AccountPreferencesList.getInstance().renameCompany(companySelected, companyRenamed);
    }

    public boolean massChangeCompany(String companySelected, String companyRenamed) {
        return AccountPreferencesList.getInstance().massChangeCompany(companySelected, companyRenamed);
    }

    public HashMap<Integer, CheckDetails> getCheckDetails(String orderID) {
        return CheckDetailsList.getInstance().getCheckDetails(orderID);
    }

    public void deleteCheckDetails(String orderID) {
        CheckDetailsList.getInstance().deleteCheckDetails(orderID);
    }

    public void insertCheckDetails(CheckDetails checkDetails) {
        CheckDetailsList.getInstance().insertCheckDetails(checkDetails);
    }

    public AccountPreferences getAccountPreferences(String profile) {
        currentProfile = profile;
        return AccountPreferencesList.getInstance().getAccountPreferences(profile);
    }

    public String combineComments(String first, String second) {
        return OrderList.getInstance().combineComments(first, second);
    }

    public AccountPreferences getAccountPreferences() {
        return AccountPreferencesList.getInstance().getAccountPreferences(currentProfile);
    }

    public void updateAccountPreferences(AccountPreferences preference) {
        AccountPreferencesList.getInstance().updateAccountPreferences(preference);
    }

    public ArrayList<PaypalDetails> getPaypalDetails(String isLinked) {
        return PNPDatabaseManager.getInstance().getPaypalDetails(isLinked);
    }

    public void deletePrintDetails(String OrderID) {
        PrintDetailsList.getInstance().deletePrintDetails(OrderID);
    }

    public HashMap<String, PrintDetails> getPrintDetails() {
        return PrintDetailsList.getInstance().getPrintDetails();
    }

    public int getLastPrintID() {
        return PrintDetailsList.getInstance().getLastPrintID();
    }

    public PrintDetails getPrintDetails(String orderID) {
        return PrintDetailsList.getInstance().getPrintDetails(orderID);
    }

    public HashMap<String, PrintDetails> searchPrintDetails(String searchString) {
        return PrintDetailsList.getInstance().searchPrintDetails(searchString.trim());
    }

    public void insertPrintDetails(PrintDetails newDetails) {
        PrintDetailsList.getInstance().insertPrintDetails(newDetails);
    }

    public void setPaypalLinked(PaypalDetails newDetails) {
        PNPDatabaseManager.getInstance().setPaypalLinked(newDetails);
    }

    public void deletePaypalTransaction(String transactionID) {
        PNPDatabaseManager.getInstance().deletePaypalTransaction(transactionID);
    }

    public void setPaypalDetails(PaypalDetails newDetails) {
        PNPDatabaseManager.getInstance().setPaypalDetails(newDetails);
    }

    public void processTransactionUpdate(TransactionType[] transactions) {
        EBayTransactionManager.getInstance().processTransactionUpdate(transactions);
    }

    public void setOrderFilters(Integer[] filterArray) {
        OrderList.getInstance().useStatusFilters(filterArray);
    }

    public HashMap<OrderStatus, Integer> getFilterQuantities() {
        return OrderList.getInstance().getFilterQuantities();
    }

    public void setFilterQuantities(HashMap<OrderStatus, Integer> filterQuantities) {
        OrderList.getInstance().setFilterQuantities(filterQuantities);
    }

    public HashMap<String, OrderStatus> getAvailableFilters() {
        HashMap<String, OrderStatus> statusFilters = new HashMap<String, OrderStatus>();
        statusFilters.put("New", OrderStatusList.getInstance().getNewOrderStatus());
        statusFilters.put("Pending Print", OrderStatusList.getInstance().getPendingPrintStatus());
        statusFilters.put("Complete", OrderStatusList.getInstance().getCompletedOrderStatus());
        statusFilters.put("Canceled", OrderStatusList.getInstance().getCanceledOrderStatus());
        statusFilters.put("Pending", OrderStatusList.getInstance().getPendingOrderStatus());
        statusFilters.put("Pending MO", OrderStatusList.getInstance().getPendingMOStatus());
        statusFilters.put("Pending E-Check", OrderStatusList.getInstance().getPendingECheckStatus());
        statusFilters.put("NPB", OrderStatusList.getInstance().getNpbOrderStatus());
        statusFilters.put("OOS", OrderStatusList.getInstance().getOosOrderStatus());
        statusFilters.put("Export Labels", OrderStatusList.getInstance().getExportLabelsStatus());
        statusFilters.put("Admin Hold", OrderStatusList.getInstance().getAdminHoldStatus());
        return statusFilters;
    }

    public HashMap<String, RMAReason> getAvailableRMAReasons() {
        HashMap<String, RMAReason> reasonFilters = new HashMap<String, RMAReason>();
        reasonFilters.put("", RMAReasonList.getInstance().getNoReason());
        reasonFilters.put("Changed Mind", RMAReasonList.getInstance().getChangedMindReason());
        reasonFilters.put("Defective", RMAReasonList.getInstance().getDefectiveReason());
        reasonFilters.put("Wrong Item", RMAReasonList.getInstance().getWrongItemReason());
        reasonFilters.put("Wrong Size", RMAReasonList.getInstance().getWrongSizeReason());
        return reasonFilters;
    }

    public HashMap<String, RMAStatus> getAvailableRMAStatuses() {
        HashMap<String, RMAStatus> statusFilters = new HashMap<String, RMAStatus>();
        statusFilters.put("New RMA", RMAStatusList.getInstance().getNewRmaStatus());
        statusFilters.put("Exchanging", RMAStatusList.getInstance().getExchangingStatus());
        statusFilters.put("Pending Response", RMAStatusList.getInstance().getPendingResponseStatus());
        statusFilters.put("Refunded", RMAStatusList.getInstance().getRefundedStatus());
        statusFilters.put("Reshipped", RMAStatusList.getInstance().getReshippedStatus());
        statusFilters.put("Returning", RMAStatusList.getInstance().getReturningStatus());
        statusFilters.put("Return Label Issued", RMAStatusList.getInstance().getReturnLabelStatus());
        statusFilters.put("Return Processed", RMAStatusList.getInstance().getReturnProcessedStatus());
        return statusFilters;
    }

    public void deleteRMA(RMADetails rmaDetails) {
        RMAList.getInstance().deleteRMA(rmaDetails);
    }

    public RMADetails updateRMA(RMADetails rmaDetails) {
        return RMAList.getInstance().updateRMA(rmaDetails);
    }

    public RMAReason getRMAReason(int rmaReasonID) {
        return RMAReasonList.getInstance().getRMAReason(rmaReasonID);
    }

    public RMAStatus getRMAStatus(int rmaStatusID) {
        return RMAStatusList.getInstance().getRMAStatus(rmaStatusID);
    }

    public void setRmaFilters(Integer[] statusFilters, Integer[] reasonFilters) {
        RMAList.getInstance().refreshRMAList(statusFilters, reasonFilters);
    }

    public void searchRMADetails(String searchString, long from, long to) {
        RMAList.getInstance().searchRMADetails(searchString, from, to);
    }

    public RMADetails[] getRMAList() {
        return RMAList.getInstance().getRMAList();
    }

    public void setTrackingOverride(boolean enabled) {
        OrderList.getInstance().setTrackingOverride(enabled);
    }

    public void setMultiOrders(boolean enabled) {
        OrderList.getInstance().setMultiOrders(enabled);
    }

    public void setNoInventory(boolean enabled) {
        OrderList.getInstance().setNoInventory(enabled);
    }

    public HashMap<Integer, CompleteOrder> getOrderList(boolean cached) {
        return OrderList.getInstance().getOrderList(cached);
    }

    public void setRefresh(boolean refresh) {
        OrderList.getInstance().setRefresh(refresh);
    }

    public HashMap<Integer, CompleteOrder> getOrdersForTracking() {
        return OrderList.getInstance().getOrdersForTracking();
    }

    public HashMap<Integer, CompleteOrder> getBaseOrders() {
        return OrderList.getInstance().getBaseOrders();
    }

    public HashMap<Integer, CompleteOrder> getOrders(Integer[] statusFilters) {
        return OrderList.getInstance().getOrders(statusFilters);
    }

    public HashMap<Integer, CompleteOrder> getOrders(String searchString, OrderStatus[] filters, long from, long to, String results) {
        return OrderList.getInstance().getOrders(searchString, filters, from, to, results);
    }

    public HashMap<Integer, CompleteOrder> getCompletedOrders(long searchFrom, long searchTo) {
        return OrderList.getInstance().getCompletedOrders(searchFrom, searchTo);
    }

    public CompleteOrder[] getOosOrderList() {
        return OOSList.getInstance().getOosOrderList();
    }

    public void searchOrders(String searchString, OrderStatus[] filters, long from, long to, String results) {
        OrderList.getInstance().searchOrders(searchString, filters, from, to, results);
    }

    public void refreshCachedOrderList() {
        OrderList.getInstance().refreshCachedOrderList();
    }

    public void refreshInventory(String searchString, boolean instock, boolean oos, boolean inhouse, boolean discontinued, String[] distributorsFilter, boolean fullText) {
        InventoryList.getInstance().refreshInventoryList(searchString, instock, oos, inhouse, discontinued, distributorsFilter, fullText);
    }

    public CompleteOrder mergeOrders(ArrayList<CompleteOrder> mergeList) {
        return OrderList.getInstance().mergeOrders(mergeList);
    }

    public void unmergeOrders(HashMap<CompleteOrder, ArrayList<OrderDetails>> unmergeList) {
        OrderList.getInstance().unmergeOrders(unmergeList);
    }

    public void updateOrder(CompleteOrder completeOrder) {
        OrderList.getInstance().updateOrder(completeOrder.getOrder());
        for (OrderDetails orderDetail : completeOrder.getOrderDetails()) {
            orderDetail.setOrderID(completeOrder.getOrder().getOrderID());
            OrderList.getInstance().updateOrderDetails(orderDetail);
        }
    }

    public void deleteOrderDetail(CompleteOrder completeOrder, OrderDetails details) {
        OrderList.getInstance().deleteOrderDetails(completeOrder, details);
    }

    public void deleteExpense(Expense expense) {
        ExpenseList.getInstance().deleteExpense(expense);
    }

    public Customer getCustomerByUsername(String username) {
        ResultSet rs = PNPDatabaseManager.getInstance().getCustomerByUsername(username);
        Customer customer = null;
        try {
            if (null != rs && rs.next()) {
                customer = new Customer();
                customer.setCustomerAddress(rs.getString("CustomerAddress"));
                customer.setCustomerCity(rs.getString("CustomerCity"));
                customer.setCustomerCountry(rs.getString("CustomerCountry"));
                customer.setCustomerEmail(rs.getString("CustomerEmail"));
                customer.setCustomerName(rs.getString("CustomerName"));
                customer.setCustomerState(rs.getString("CustomerState"));
                customer.setCustomerUserName(rs.getString("CustomerUserName"));
                customer.setCustomerZipcode(rs.getString("CustomerZipCode"));
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        DatabaseConnector.removeObject((ResultSet)rs);
        return customer;
    }

    public ArrayList<PaypalDetails> searchPaypalOrders(String searchString) {
        ResultSet rs = PNPDatabaseManager.getInstance().searchPaypalOrders(searchString.trim());
        ArrayList<PaypalDetails> searchDetails = new ArrayList<PaypalDetails>();
        try {
            while (null != rs && rs.next()) {
                PaypalDetails newDetails = new PaypalDetails();
                newDetails.setPaypalTransactionID(rs.getString("PaypalTransactionID"));
                newDetails.setEmail(rs.getString("EmailAddress"));
                newDetails.setFirstName(rs.getString("FirstName"));
                newDetails.setLastName(rs.getString("LastName"));
                newDetails.setCountryCode(rs.getString("CountryCode"));
                newDetails.setCountryName(rs.getString("CountryName"));
                newDetails.setStreet1(rs.getString("Street1"));
                newDetails.setStreet2(rs.getString("Street2"));
                newDetails.setCityName(rs.getString("CityName"));
                newDetails.setStateOrProvince(rs.getString("StateOrProvince"));
                newDetails.setPostalCode(rs.getString("PostalCode"));
                newDetails.setTransactionType(rs.getString("TransactionType"));
                newDetails.setPaymentType(rs.getString("PaymentType"));
                newDetails.setPaymentDate(rs.getString("PaymentDate"));
                newDetails.setGrossAmount(Float.valueOf(rs.getFloat("GrossAmount")));
                newDetails.setPaymentStatus(rs.getString("PaymentStatus"));
                newDetails.setShippingMethod(rs.getString("ShippingMethod"));
                newDetails.setCustom(rs.getString("Custom"));
                try {
                    newDetails.setMemo(rs.getString("Memo"));
                }
                catch (Exception ex) {
                    ErrorsUtil.getInstance().logError(ex, false);
                }
                newDetails.setBuyerID(rs.getString("BuyerID"));
                newDetails.setClosingDate(rs.getString("ClosingDate"));
                newDetails.setMultiItem(rs.getString("MultiItem"));
                newDetails.setLinked(rs.getBoolean("Linked"));
                newDetails.setTax(Float.valueOf(rs.getFloat("Tax")));
                newDetails.setCurrencyCode(rs.getString("CurrencyCode"));
                newDetails.setShippingAmount(Float.valueOf(rs.getFloat("ShippingAmount")));
                newDetails.setPaypalAccount(rs.getString("PayPalAccount"));
                newDetails.setEbayItems(PNPDatabaseManager.getInstance().getEbayTransactions(newDetails.getPaypalTransactionID()));
                searchDetails.add(newDetails);
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        DatabaseConnector.removeObject((ResultSet)rs);
        return searchDetails;
    }

    public Customer getCustomerByEmail(String email) {
        ResultSet rs = PNPDatabaseManager.getInstance().getCustomerByEmail(email);
        Customer customer = null;
        try {
            if (null != rs && rs.next()) {
                customer = new Customer();
                customer.setCustomerAddress(rs.getString("CustomerAddress"));
                customer.setCustomerCity(rs.getString("CustomerCity"));
                customer.setCustomerCountry(rs.getString("CustomerCountry"));
                customer.setCustomerEmail(rs.getString("CustomerEmail"));
                customer.setCustomerName(rs.getString("CustomerName"));
                customer.setCustomerState(rs.getString("CustomerState"));
                customer.setCustomerUserName(rs.getString("CustomerUserName"));
                customer.setCustomerZipcode(rs.getString("CustomerZipCode"));
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        DatabaseConnector.removeObject((ResultSet)rs);
        return customer;
    }

    public ArrayList<ShippingMethod> getAvaliableShippingMethods() {
        return ShippingMethodList.getInstance().getShippingMethodList();
    }

    public Item getItem(String itemID) {
        return InventoryList.getInstance().getItem(itemID);
    }

    public void setItem(Item item) {
        InventoryList.getInstance().setItem(item);
    }

    public HashMap<Integer, CompleteOrder> getCompletedOrders() {
        return CompletedOrderList.getInstance().getOrderList();
    }

    public Expense[] getExpenses() {
        return ExpenseList.getInstance().getExpenses();
    }

    public void updateExpense(Expense expense) {
        ExpenseList.getInstance().updateExpense(expense);
    }

    public void updateDistributor(Distributor distributor) {
        DistributorList.getInstance().setDistributor(distributor);
    }

    public void refreshCompletedOrders(long searchfrom, long searchTo) {
        CompletedOrderList.getInstance().refreshOrders(searchfrom, searchTo);
    }

    public Expense[] getSnapshotExpenses(long searchFrom, long searchTo, String companyName) {
        ArrayList<Integer> blankList = new ArrayList<Integer>();
        ResultSet rs = PNPDatabaseManager.getInstance().getExpenses(searchFrom, searchTo, blankList, null, companyName);
        ArrayList<Expense> expenseList = new ArrayList<Expense>();
        try {
            if (null != rs) {
                while (rs.next()) {
                    Expense element = new Expense();
                    element.setExpenseComment(rs.getString("ExpenseComment"));
                    element.setExpenseCost(rs.getFloat("ExpenseCost"));
                    element.setExpenseDate(rs.getDate("ExpenseDate"));
                    element.setExpenseID(rs.getInt("ExpenseID"));
                    element.setExpenseReason(rs.getString("ExpenseReason"));
                    element.setCompanyName(rs.getString("CompanyName"));
                    expenseList.add(element);
                }
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        DatabaseConnector.removeObject((ResultSet)rs);
        return expenseList.toArray(new Expense[0]);
    }

    public CompleteOrder[] getSnapshotOrders(long searchFrom, long searchTo, String companyName) {
        ResultSet rs;
        HashMap<Integer, CompleteOrder> orderList;
        block8: {
            orderList = new HashMap<Integer, CompleteOrder>();
            rs = PNPDatabaseManager.getInstance().getCompletedOrders(searchFrom, searchTo, companyName);
            try {
                if (null == rs) break block8;
                while (rs.next()) {
                    if (rs.getBoolean("OrderDetails.Deleted")) continue;
                    CompleteOrder completeOrder = new CompleteOrder();
                    if (!orderList.containsKey(rs.getInt("Orders.OrderID"))) {
                        Order orderElement = new Order();
                        try {
                            orderElement.setOrderComments(rs.getString("Orders.OrderComments"));
                        }
                        catch (Exception ex) {
                            ErrorsUtil.getInstance().logError(ex, false);
                        }
                        orderElement.setOrderDate(rs.getDate("Orders.OrderDate"));
                        orderElement.setOrderID(rs.getInt("Orders.OrderID"));
                        orderElement.setOrderStatus(OrderStatusList.getInstance().getOrderStatus(rs.getInt("Orders.OrderStatusID")));
                        orderElement.setOrderTotal(rs.getFloat("Orders.OrderTotal"));
                        orderElement.setShippingCost(rs.getFloat("Orders.ShippingCost"));
                        orderElement.setShippingMethodName(rs.getString("Orders.ShippingMethodID"));
                        orderElement.setShippingPaid(rs.getFloat("Orders.ShippingPaid"));
                        orderElement.setPaypalAccount(rs.getString("Orders.OrderPaypal"));
                        completeOrder.setOrder(orderElement);
                        Customer customer = new Customer();
                        customer.setCustomerAddress(rs.getString("Customers.CustomerAddress"));
                        customer.setCustomerCity(rs.getString("Customers.CustomerCity"));
                        customer.setCustomerCountry(rs.getString("Customers.CustomerCountry"));
                        customer.setCustomerEmail(rs.getString("Customers.CustomerEmail"));
                        customer.setCustomerName(rs.getString("Customers.CustomerName"));
                        customer.setCustomerState(rs.getString("Customers.CustomerState"));
                        customer.setCustomerUserName(rs.getString("Customers.CustomerUserName"));
                        customer.setCustomerZipcode(rs.getString("Customers.CustomerZipCode"));
                        completeOrder.getOrder().setCustomer(customer);
                    } else {
                        completeOrder = (CompleteOrder)orderList.get(rs.getInt("Orders.OrderID"));
                    }
                    OrderDetails orderDetailsElement = new OrderDetails();
                    orderDetailsElement.setItemID(rs.getString("OrderDetails.ItemID"));
                    orderDetailsElement.setOrderDetailsID(rs.getInt("OrderDetails.OrderDetailsID"));
                    orderDetailsElement.setOrderID(rs.getInt("OrderDetails.OrderID"));
                    orderDetailsElement.setBackordered(rs.getBoolean("OrderDetails.Backordered"));
                    orderDetailsElement.setOrderNumber(rs.getString("OrderDetails.OrderNumber"));
                    orderDetailsElement.setSalesPrice(rs.getFloat("OrderDetails.Salesprice"));
                    orderDetailsElement.setItemCost(rs.getFloat("OrderDetails.ItemCost"));
                    Date date = rs.getDate("OrderDetails.ShipDate");
                    if (null != date) {
                        orderDetailsElement.setShipDate(date);
                    }
                    orderDetailsElement.setTransactionID(rs.getString("OrderDetails.TransactionID"));
                    orderDetailsElement.setInhouse(rs.getBoolean("OrderDetails.Inhouse"));
                    orderDetailsElement.setOrderDescription(rs.getString("OrderDetails.OrderDescription"));
                    orderDetailsElement.setEbayWeight(rs.getFloat("OrderDetails.EbayWeight"));
                    ArrayList orderDetailsArrayList = completeOrder.getOrderDetails();
                    orderDetailsArrayList.add(orderDetailsElement);
                    orderList.put(rs.getInt("Orders.OrderID"), completeOrder);
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        DatabaseConnector.removeObject((ResultSet)rs);
        return orderList.values().toArray(new CompleteOrder[0]);
    }

    public void refreshExpenses(long searchfrom, long searchTo, ArrayList<Integer> filteredList, String searchString) {
        ExpenseList.getInstance().refreshExpenses(searchfrom, searchTo, filteredList, searchString);
    }

    public Collection<ArrayList<InventoryElement>> getInventoryList() {
        return InventoryList.getInstance().getInventory();
    }

    public ArrayList<InventoryElement> findFromFullInventory(String itemID) {
        itemID = GenericFunctions.getInstance().prepareString(itemID);
        HashMap<String, ArrayList<InventoryElement>> inventory = InventoryList.getInstance().getFullInventoryList();
        if (!itemID.isEmpty() && inventory != null && !inventory.isEmpty() && inventory.containsKey(itemID)) {
            return inventory.get(itemID);
        }
        return new ArrayList<InventoryElement>();
    }

    public Distributor[] getDistributors() {
        return DistributorList.getInstance().getDistributors();
    }

    public void refreshDistributorList(boolean notify) {
        DistributorList.getInstance().refreshDistributorList(notify);
    }

    public OrderDetails[] getOosOrderDetails() {
        return OOSList.getInstance().getOosOrderDetailsList();
    }

    public void updateOosOrder(OrderDetails order) {
        OOSList.getInstance().updateOosOrderDetails(order);
    }

    public InventoryElement[] getOosInventory() {
        return OOSList.getInstance().getOosInventoryList();
    }

    public void setInventoryElementChain(ArrayList<InventoryElement> inventoryElement) {
        InventoryList.getInstance().setInventoryElementChain(inventoryElement);
    }

    public void setInventoryElement(InventoryElement inventoryElement) {
        InventoryList.getInstance().setInventoryElement(inventoryElement);
    }

    public Collection<ArrayList<InventoryElement>> getInventoryList(String searchString, boolean instock, boolean oos, boolean inhouse, String[] distributorsFilter, boolean fullText) {
        HashMap<String, ArrayList> inventory = new HashMap<String, ArrayList>();
        ResultSet rs = PNPDatabaseManager.getInstance().getInventoryList(searchString, instock, oos, inhouse, false, distributorsFilter, fullText);
        try {
            while (null != rs && !rs.isClosed() && rs.next()) {
                ArrayList elementArrayList;
                InventoryElement element = new InventoryElement();
                element.setInventoryID(rs.getInt("InventoryID"));
                element.setItemQuantity(rs.getInt("ItemQuantity"));
                element.setItemCost(rs.getFloat("ItemCost"));
                element.setItemID(rs.getString("ItemID"));
                element.setOosItem(rs.getBoolean("OOSItem"));
                if (inventory.containsKey(element.getItemID())) {
                    elementArrayList = (ArrayList)inventory.get(element.getItemID());
                    if (element.isOosItem()) {
                        elementArrayList.add(0, element);
                    } else {
                        elementArrayList.add(element);
                    }
                } else {
                    elementArrayList = new ArrayList();
                    if (element.isOosItem()) {
                        elementArrayList.add(0, element);
                    } else {
                        elementArrayList.add(element);
                    }
                }
                inventory.put(element.getItemID(), elementArrayList);
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        DatabaseConnector.removeObject((ResultSet)rs);
        return inventory.values();
    }

    public void deleteInventoryElement(InventoryElement inventoryElement) {
        PNPDatabaseManager.getInstance().deleteAllInventoryElements(inventoryElement);
    }

    public HashMap<String, Integer> getAllItemsQuantity() {
        HashMap<String, Integer> itemQuantities = new HashMap<String, Integer>();
        for (ArrayList<InventoryElement> element : this.getInventoryList("", false, false, false, new String[0], false)) {
            for (InventoryElement indElement : element) {
                if (!itemQuantities.containsKey(indElement.getItemID())) {
                    itemQuantities.put(indElement.getItemID(), indElement.getItemQuantity());
                    continue;
                }
                itemQuantities.put(indElement.getItemID(), itemQuantities.get(indElement.getItemID()) + indElement.getItemQuantity());
            }
        }
        return itemQuantities;
    }

    public int getItemQuantity(String itemID, boolean cached) {
        int quantity = 0;
        if (cached) {
            quantity = InventoryList.getInstance().getItemQuantity(itemID);
        } else {
            Collection<ArrayList<InventoryElement>> inventoryList = this.getInventoryList(itemID, false, false, false, new String[0], false);
            ArrayList<InventoryElement> inventoryElements = null;
            boolean found = false;
            Iterator<ArrayList<InventoryElement>> iter = inventoryList.iterator();
            while (iter.hasNext() && !found) {
                inventoryElements = iter.next();
                if (inventoryElements == null || !inventoryElements.get(0).getItemID().equals(itemID)) continue;
                found = true;
            }
            if (found) {
                Iterator inventoryIter = inventoryElements.iterator();
                while (inventoryIter.hasNext()) {
                    quantity += ((InventoryElement)inventoryIter.next()).getItemQuantity();
                }
            }
        }
        return quantity;
    }

    public HashMap<String, Integer> getReorderList(long searchfrom, long searchTo) {
        HashMap<String, Integer> itemList = new HashMap<String, Integer>();
        ResultSet rs = PNPDatabaseManager.getInstance().getReorderList(searchfrom, searchTo);
        try {
            if (null != rs) {
                while (rs.next()) {
                    String itemID = rs.getString("ItemID");
                    if (itemList.containsKey(itemID)) {
                        itemList.put(itemID, itemList.get(itemID) + 1);
                        continue;
                    }
                    itemList.put(itemID, 1);
                }
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        DatabaseConnector.removeObject((ResultSet)rs);
        return itemList;
    }

    public void updateWebsiteElement(WebsiteElement websiteElement) {
        WebsiteInventoryList.getInstance().setWebsiteElement(websiteElement);
    }

    public HashMap<String, WebsiteProduct> getWebsiteProductList() {
        return WebsiteInventoryList.getInstance().getWebsiteList();
    }

    public void refreshWebsiteProductList(String searchString, boolean enabled, boolean hideOOS) {
        WebsiteInventoryList.getInstance().refreshWebsiteList(searchString, enabled, hideOOS);
    }

    public void refreshWebsiteProductList() {
        WebsiteInventoryList.getInstance().refreshWebsiteList();
    }

    public ArrayList<OrderStatus> getOrderStatusList() {
        return OrderStatusList.getInstance().getOrderStatusList();
    }

    public void updateCategory(Category category) {
        CategoryList.getInstance().setCategory(category);
    }

    public void removeCategory(int categoryID) {
        CategoryList.getInstance().removeCategory(categoryID);
    }

    public void mergeCategory(int selectedCategory, int movedToCategory) {
        CategoryList.getInstance().mergeCategory(selectedCategory, movedToCategory);
    }

    public Category[] getCategories() {
        return CategoryList.getInstance().getCategories();
    }

    public void updateWebsite(Website website) {
        WebsiteList.getInstance().updateWebsite(website);
    }

    public Website[] getWebsites() {
        return WebsiteList.getInstance().getWebsites();
    }

    public void refreshWebsiteList(boolean notify) {
        WebsiteList.getInstance().refreshWebsiteList(notify);
    }

    public void updateWebsiteCategories(WebsiteCategories websiteCategories) {
        WebsiteCategoriesList.getInstance().setWebsiteCategories(websiteCategories);
    }

    public WebsiteCategories[] getWebsiteCategories() {
        return WebsiteCategoriesList.getInstance().getWebsiteCategories();
    }

    public void updateExpenseReason(ExpenseReason reason) {
        ExpenseReasonsList.getInstance().setExpenseReasons(reason);
    }

    public ExpenseReason[] getExpenseReasons() {
        return ExpenseReasonsList.getInstance().getExpenseReasons();
    }

    public void refreshExpenseReasonList(boolean notify) {
        ExpenseReasonsList.getInstance().refreshExpenseReasonList(notify);
    }

    public void splitOrders(HashMap<CompleteOrder, ArrayList<OrderDetails>> splitList) {
        OrderList.getInstance().splitOrders(splitList);
    }

    public ArrayList<OrderDetails> splitOrders(OrderDetails orderDetails) {
        return OrderList.getInstance().splitOrders(orderDetails, false);
    }

    public void setSalesTax(String Abbreviation, String Identifier, Float Cost) {
        PNPDatabaseManager.getInstance().setSalesTax(Abbreviation, Identifier, Cost);
    }

    public ArrayList<SalesTax> getSalesTax() {
        ArrayList<SalesTax> taxArray = new ArrayList<SalesTax>();
        ResultSet rs = null;
        try {
            rs = PNPDatabaseManager.getInstance().getSalesTax();
            while (null != rs && rs.next()) {
                taxArray.add(new SalesTax(rs.getString("Abbreviation"), rs.getString("Identifier"), Float.valueOf(rs.getFloat("Cost")), rs.getBoolean("Enabled")));
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        DatabaseConnector.removeObject((ResultSet)rs);
        return taxArray;
    }

    public float getAverageWholesaleCost(String itemID) {
        int quantity = 0;
        float wholesalePrice = 0.0f;
        Collection<ArrayList<InventoryElement>> inventoryList = this.getInventoryList(itemID, false, false, false, new String[0], false);
        ArrayList<InventoryElement> inventoryElements = null;
        boolean found = false;
        Iterator<ArrayList<InventoryElement>> iter = inventoryList.iterator();
        while (iter.hasNext() && !found) {
            inventoryElements = iter.next();
            if (inventoryElements == null || !inventoryElements.get(0).getItemID().equals(itemID)) continue;
            found = true;
        }
        if (found) {
            for (InventoryElement inventoryElement : inventoryElements) {
                if (inventoryElement.getItemQuantity() <= 0) continue;
                quantity += inventoryElement.getItemQuantity();
                wholesalePrice += inventoryElement.getItemCost() * (float)inventoryElement.getItemQuantity();
            }
        }
        if (quantity != 0) {
            wholesalePrice /= (float)quantity;
        }
        return wholesalePrice;
    }

    public float getMaxWholesaleCost(String itemID) {
        float wholesaleCost = 0.0f;
        try {
            for (InventoryElement inventoryElement : this.findFromFullInventory(itemID)) {
                if (!inventoryElement.getItemID().equalsIgnoreCase(itemID) || inventoryElement.getItemQuantity() <= 0 || !(inventoryElement.getItemCost() > wholesaleCost)) continue;
                wholesaleCost = inventoryElement.getItemCost();
            }
            if (wholesaleCost > 0.0f) {
                wholesaleCost = this.createProfit(wholesaleCost);
            }
        }
        catch (Exception ex) {
            wholesaleCost = 0.0f;
            ErrorsUtil.getInstance().logError(ex);
        }
        return wholesaleCost;
    }

    private float createProfit(float wholesaleCost) {
        wholesaleCost = wholesaleCost < 5.0f ? (wholesaleCost += 1.75f) : (wholesaleCost < 10.0f ? (wholesaleCost += 2.25f) : (wholesaleCost < 20.0f ? (wholesaleCost += 3.0f) : (wholesaleCost < 30.0f ? (wholesaleCost += 4.0f) : (float)((double)wholesaleCost * 1.2))));
        return wholesaleCost;
    }

    public ArrayList<CustomFee> getCustomFeeList() {
        CustomFee[] customFeeArray = CustomFeeList.getInstance().getCustomFees();
        ArrayList<CustomFee> customFeeArrayList = new ArrayList<CustomFee>();
        for (int i = 0; i < customFeeArray.length; ++i) {
            customFeeArrayList.add(customFeeArray[i]);
        }
        return customFeeArrayList;
    }

    public void updateCustomFee(CustomFee customFee) {
        CustomFeeList.getInstance().setCustomFee(customFee);
    }

    public void removeCustomFee(CustomFee customFee) {
        CustomFeeList.getInstance().removeCustomFee(customFee);
    }

    public void setOrderComments(boolean enabled) {
        OrderList.getInstance().setOrderComments(enabled);
    }

    public HashMap<Integer, CategoryAssociation> getCategoryAssociations() {
        return CategoryAssociationsList.getInstance().getCategoryAssociations();
    }

    public void updateCategoryAssociations(CategoryAssociation association) {
        CategoryAssociationsList.getInstance().updateCategoryAssociations(association);
    }
}

