/*
 * Decompiled with CFR 0.152.
 */
package pnp.comms.db;

import com.ebay.soap.eBLBaseComponents.CheckoutStatusCodeType;
import com.ebay.soap.eBLBaseComponents.CurrencyCodeType;
import com.ebay.soap.eBLBaseComponents.ShippingServiceCodeType;
import com.ebay.soap.eBLBaseComponents.TransactionType;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import pnp.comms.db.PNPDatabaseManager;
import pnp.comms.db.lists.InventoryList;
import pnp.comms.db.lists.OrderList;
import pnp.comms.db.lists.OrderStatusList;
import pnp.comms.db.lists.ShippingMethodList;
import pnp.services.datatypes.AccountPreferences;
import pnp.services.datatypes.Customer;
import pnp.services.datatypes.InventoryElement;
import pnp.services.datatypes.Item;
import pnp.services.datatypes.Order;
import pnp.services.datatypes.OrderDetails;
import pnp.services.datatypes.webservices.Promocodes;
import pnp.services.listener.GenericListener;
import pnp.services.listenermanager.ListenerManager;
import pnp.services.preferencemanager.Preferences;
import pnp.services.util.CreationTools;
import pnp.services.util.CurrencyConverter;
import pnp.services.util.DatabaseConnector;
import pnp.services.util.ErrorsUtil;
import pnp.services.util.LookupServicesUtil;
import pnp.services.util.MathParser;

public class EBayTransactionManager {
    private HashMap<String, Integer> _transactionList;
    private HashMap<String, Integer> _newTransactionList;
    private HashMap<String, String> _trackingList;
    private final Object _lock = new Object();
    private static EBayTransactionManager _instance;
    private Promocodes _promocode;
    private String inventoryWarningMessage;

    private EBayTransactionManager() {
        this._transactionList = new HashMap();
        this._newTransactionList = new HashMap();
        this._trackingList = new HashMap();
        this._promocode = new Promocodes();
        this._promocode.setDiscount(Float.valueOf(0.15f));
        this._promocode.setPermanent(Boolean.valueOf(true));
        this._promocode.setOneUse(Boolean.valueOf(true));
        this.inventoryWarningMessage = "";
    }

    public static EBayTransactionManager getInstance() {
        if (null == _instance) {
            _instance = new EBayTransactionManager();
        }
        return _instance;
    }

    public void processTransactionUpdate(TransactionType[] transactions) {
        this.inventoryWarningMessage = "";
        this.getOrderDetailsList();
        int orderID = 0;
        if (null != transactions) {
            DatabaseConnector.push();
            for (TransactionType transaction : transactions) {
                try {
                    String transactionID = transaction.getTransactionID().equals("0") ? transaction.getOrderLineItemID() : transaction.getTransactionID();
                    if (this._newTransactionList.containsKey(transactionID)) {
                        orderID = this.updateTransaction(transactionID, transaction);
                        this._newTransactionList.remove(transactionID);
                        this._transactionList.put(transactionID, orderID);
                    } else if (!this._transactionList.containsKey(transactionID) && !((Boolean)transaction.getAny()[0]).booleanValue()) {
                        orderID = this.processNewTransaction(transaction);
                        this._transactionList.put(transactionID, orderID);
                    }
                    if (null == transaction.getShippingDetails() || transaction.getShippingDetails().getShipmentTrackingDetailsLength() <= 0 || this._trackingList.containsKey(transactionID)) continue;
                    this.updateTracking(transaction);
                    this._trackingList.put(transactionID, transactionID);
                }
                catch (Exception ex) {
                    ErrorsUtil.getInstance().logError(ex);
                }
            }
            DatabaseConnector.pop();
        }
        this._transactionList.clear();
        this._newTransactionList.clear();
        ListenerManager.getInstance().notify((GenericListener)ListenerManager.TRANSACTION_LISTENER);
        this.createMessageAndLog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createMessageAndLog() {
        JTextArea textField = new JTextArea();
        textField.setEditable(false);
        textField.setText(this.inventoryWarningMessage);
        if (!this.inventoryWarningMessage.trim().isEmpty()) {
            OutputStreamWriter writer = null;
            try {
                writer = new FileWriter(CreationTools.createFileSpace(null, (String)"Logs", (String)"StockNotification", (String)"txt"));
                textField.write(writer);
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
            finally {
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (Exception ex) {
                    ErrorsUtil.getInstance().logError(ex);
                }
            }
            textField.setText("Log file saved under 'Logs'. \n" + textField.getText());
            JOptionPane.showMessageDialog(null, textField);
        }
    }

    private int processNewTransaction(TransactionType transaction) {
        Order order = new Order();
        int orderID = 0;
        if (null != transaction.getBuyer() && null != transaction.getBuyer().getUserID()) {
            float amount;
            order.setCustomer(this.createCustomer(transaction));
            order.setOrderDate(new Date(transaction.getCreatedDate().getTime().getTime()));
            order.setOrderComments("");
            order.setOrderStatus(OrderStatusList.getInstance().getNewOrderStatus());
            order.setOrderTotal((float)transaction.getTransactionPrice().getValue() * (float)transaction.getQuantityPurchased().intValue());
            if (!transaction.getItem().getCurrency().equals((Object)CurrencyCodeType.USD)) {
                amount = CurrencyConverter.convertCurrency((String)transaction.getItem().getCurrency().value(), (float)order.getOrderTotal());
                amount = Float.valueOf(MathParser.isDollarAmount((String)String.valueOf(amount))).floatValue();
                order.setOrderTotal(amount);
            }
            this.updateShipping(transaction, order);
            if (!transaction.getItem().getCurrency().equals((Object)CurrencyCodeType.USD)) {
                amount = CurrencyConverter.convertCurrency((String)transaction.getItem().getCurrency().value(), (float)order.getShippingPaid());
                amount = Float.valueOf(MathParser.isDollarAmount((String)String.valueOf(amount))).floatValue();
                order.setShippingPaid(amount);
            }
            order.setShippingCost(0.0f);
            String transactionID = transaction.getTransactionID().equals("0") ? transaction.getOrderLineItemID() : transaction.getTransactionID();
            orderID = this.createOrderDetails(transaction, order, transactionID);
            transaction.setBuyerMessage("");
            for (int i = 1; i < transaction.getQuantityPurchased(); ++i) {
                this.createOrderDetails(transaction, order, UUID.randomUUID().toString());
            }
        }
        return orderID;
    }

    private int updateTransaction(String transactionID, TransactionType transaction) {
        Order order = new Order();
        try {
            order.setOrderID(Integer.valueOf(this._newTransactionList.get(transactionID)).intValue());
            if (null != transaction.getBuyer() && null != transaction.getBuyer().getUserID()) {
                this.createCustomer(transaction);
                this.updateShipping(transaction, order);
                if (!transaction.getItem().getCurrency().equals((Object)CurrencyCodeType.USD)) {
                    float amount = CurrencyConverter.convertCurrency((String)transaction.getItem().getCurrency().value(), (float)order.getShippingPaid());
                    amount = Float.valueOf(MathParser.isDollarAmount((String)String.valueOf(amount))).floatValue();
                    order.setShippingPaid(amount);
                }
                this.updateNewOrder(order);
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        return order.getOrderID();
    }

    private Customer createCustomer(TransactionType transaction) {
        Customer customer = new Customer();
        String address = "";
        if (null != transaction.getBuyer().getBuyerInfo().getShippingAddress().getStreet()) {
            address = transaction.getBuyer().getBuyerInfo().getShippingAddress().getStreet();
        }
        if (null != transaction.getBuyer().getBuyerInfo().getShippingAddress().getStreet1()) {
            address = address.equals("") ? transaction.getBuyer().getBuyerInfo().getShippingAddress().getStreet1() : address + ", " + transaction.getBuyer().getBuyerInfo().getShippingAddress().getStreet1();
        }
        if (null != transaction.getBuyer().getBuyerInfo().getShippingAddress().getStreet2()) {
            address = address.equals("") ? transaction.getBuyer().getBuyerInfo().getShippingAddress().getStreet2() : address + ", " + transaction.getBuyer().getBuyerInfo().getShippingAddress().getStreet2();
        }
        customer.setCustomerAddress(this.sanitize(address));
        customer.setCustomerCity(this.sanitize(transaction.getBuyer().getBuyerInfo().getShippingAddress().getCityName()));
        customer.setCustomerCountry(this.sanitize(transaction.getBuyer().getBuyerInfo().getShippingAddress().getCountryName()));
        customer.setCustomerEmail(this.sanitize(transaction.getBuyer().getEmail()));
        customer.setCustomerName(this.sanitize(transaction.getBuyer().getBuyerInfo().getShippingAddress().getName()));
        customer.setCustomerState(this.sanitize(transaction.getBuyer().getBuyerInfo().getShippingAddress().getStateOrProvince()));
        customer.setCustomerUserName(this.sanitize(transaction.getBuyer().getUserID()));
        customer.setCustomerZipcode(this.sanitize(transaction.getBuyer().getBuyerInfo().getShippingAddress().getPostalCode()));
        this.updateCustomer(customer);
        return customer;
    }

    private int createOrderDetails(TransactionType transaction, Order order, String transactionID) {
        OrderDetails orderDetails = new OrderDetails();
        if (null != transaction.getVariation() && null != transaction.getVariation().getSKU()) {
            orderDetails.setItemID(transaction.getVariation().getSKU().toLowerCase().trim());
        } else if (null != transaction.getItem().getSKU()) {
            orderDetails.setItemID(transaction.getItem().getSKU().toLowerCase().trim());
        } else {
            orderDetails.setItemID("");
        }
        if (orderDetails.getItemID().contains("pros") || orderDetails.getItemID().contains("band")) {
            this._promocode.setPromoCode(order.getCustomer().getCustomerUserName());
            LookupServicesUtil.getRESTHandlerServices().addPromoCode(this._promocode);
        }
        orderDetails.setSalesPrice((float)transaction.getTransactionPrice().getValue());
        if (!transaction.getItem().getCurrency().equals((Object)CurrencyCodeType.USD)) {
            float amount = CurrencyConverter.convertCurrency((String)transaction.getItem().getCurrency().value(), (float)orderDetails.getSalesPrice());
            amount = Float.valueOf(MathParser.isDollarAmount((String)String.valueOf(amount))).floatValue();
            orderDetails.setSalesPrice(amount);
        }
        orderDetails.setTransactionID(transactionID);
        orderDetails.setOrderDescription(this.sanitize(transaction.getItem().getTitle()));
        orderDetails.setOrderNumber(transaction.getItem().getItemID());
        orderDetails.setOrderID(this.updateOrder(order));
        orderDetails.setAccountName(transaction.getBuyerMessage());
        orderDetails.setEbaySite(transaction.getItem().getSite().value());
        if (transaction.getShippingDetails() != null && transaction.getShippingDetails().getCalculatedShippingRate() != null && transaction.getShippingDetails().getCalculatedShippingRate().getWeightMinor() != null && transaction.getShippingDetails().getCalculatedShippingRate().getWeightMinor().getValue() != null) {
            orderDetails.setEbayWeight(transaction.getShippingDetails().getCalculatedShippingRate().getWeightMinor().getValue().floatValue());
        }
        boolean splitOrders = Preferences.getInstance().getAccountPreferences().isGenSplitRefresh();
        boolean updateInventory = Preferences.getInstance().getAccountPreferences().isGenInventoryRefresh();
        if (updateInventory && !splitOrders) {
            this.updateInventoryStatus(orderDetails);
        }
        if (splitOrders) {
            ArrayList<OrderDetails> detailList = OrderList.getInstance().splitOrders(orderDetails, false);
            for (OrderDetails detail : detailList) {
                if (updateInventory) {
                    this.updateInventoryStatus(detail);
                }
                this.updateOrderDetails(detail);
            }
        } else {
            this.updateOrderDetails(orderDetails);
        }
        return orderDetails.getOrderID();
    }

    private void updateShipping(TransactionType transaction, Order order) {
        if (transaction.getStatus().getCheckoutStatus().equals((Object)CheckoutStatusCodeType.CHECKOUT_COMPLETE)) {
            if (transaction.getShippingServiceSelected() != null) {
                double shippingCost = 0.0;
                if (null != transaction.getShippingServiceSelected().getShippingServiceCost()) {
                    shippingCost = transaction.getShippingServiceSelected().getShippingServiceCost().getValue();
                }
                if (null != transaction.getShippingServiceSelected().getShippingSurcharge()) {
                    shippingCost += transaction.getShippingServiceSelected().getShippingSurcharge().getValue();
                }
                if (null != transaction.getShippingServiceSelected().getShippingServiceAdditionalCost()) {
                    shippingCost += transaction.getShippingServiceSelected().getShippingServiceAdditionalCost().getValue();
                }
                order.setShippingPaid((float)shippingCost);
                if (null == transaction.getShippingServiceSelected().getShippingService()) {
                    order.setShippingMethodName(ShippingMethodList.getInstance().getStandardMethod().getShippingMethodName());
                } else if (transaction.getShippingServiceSelected().getShippingService().equals(ShippingServiceCodeType.SHIPPING_METHOD_STANDARD.value())) {
                    order.setShippingMethodName(ShippingMethodList.getInstance().getStandardMethod().getShippingMethodName());
                } else if (transaction.getShippingServiceSelected().getShippingService().equals(ShippingServiceCodeType.SHIPPING_METHOD_EXPRESS.value())) {
                    order.setShippingMethodName("Priority");
                } else if (transaction.getShippingServiceSelected().getShippingService().equals(ShippingServiceCodeType.UPS_2_ND_DAY.value())) {
                    order.setShippingMethodName(ShippingMethodList.getInstance().get2DayMethod().getShippingMethodName());
                } else {
                    order.setShippingMethodName(transaction.getShippingServiceSelected().getShippingService());
                }
            } else if (transaction.getShippingDetails().getShippingServiceOptions().length > 0) {
                double shippingCost = transaction.getShippingDetails().getShippingServiceOptions(0).getShippingServiceCost().getValue();
                if (null != transaction.getShippingDetails().getShippingServiceOptions(0).getShippingSurcharge()) {
                    shippingCost += transaction.getShippingDetails().getShippingServiceOptions(0).getShippingSurcharge().getValue();
                }
                if (null != transaction.getShippingDetails().getShippingServiceOptions(0).getShippingServiceAdditionalCost()) {
                    shippingCost += transaction.getShippingDetails().getShippingServiceOptions(0).getShippingServiceAdditionalCost().getValue();
                }
                order.setShippingPaid((float)shippingCost);
                if (transaction.getShippingDetails().getShippingServiceOptions(0).getShippingService().equals(ShippingServiceCodeType.SHIPPING_METHOD_STANDARD.value())) {
                    order.setShippingMethodName(ShippingMethodList.getInstance().getStandardMethod().getShippingMethodName());
                } else if (transaction.getShippingDetails().getShippingServiceOptions(0).getShippingService().equals(ShippingServiceCodeType.SHIPPING_METHOD_EXPRESS.value())) {
                    order.setShippingMethodName(ShippingMethodList.getInstance().getExpeditedMethod().getShippingMethodName());
                } else if (transaction.getShippingDetails().getShippingServiceOptions(0).getShippingService().equals(ShippingServiceCodeType.UPS_2_ND_DAY.value())) {
                    order.setShippingMethodName(ShippingMethodList.getInstance().get2DayMethod().getShippingMethodName());
                } else {
                    order.setShippingMethodName(transaction.getShippingDetails().getShippingServiceOptions(0).getShippingService());
                }
            }
            order.setOrderStatus(OrderStatusList.getInstance().getPendingOrderStatus());
        } else {
            order.setOrderStatus(OrderStatusList.getInstance().getNewOrderStatus());
            order.setShippingPaid(0.0f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getOrderDetailsList() {
        ResultSet rs = null;
        Object object = this._lock;
        synchronized (object) {
            try {
                this._transactionList.clear();
                this._transactionList.put("0", 0);
                Statement stmt = DatabaseConnector.createStatement((String)"getOrderDetailsList");
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
                long dateRange = System.currentTimeMillis() - 2592000000L;
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(dateRange);
                String sql = "SELECT * FROM Orders INNER JOIN OrderDetails ON Orders.OrderID = OrderDetails.OrderID WHERE OrderDate >= '" + formatter.format(calendar.getTime()) + "' " + "AND Orders.OrderStatusID!=" + OrderStatusList.getInstance().getNewOrderStatus().getOrderStatusID();
                rs = DatabaseConnector.createStatementResultSet((Statement)stmt, (String)sql, (String)"getOrderDetailsList1");
                if (null != rs) {
                    while (rs.next()) {
                        this._transactionList.put(rs.getString("TransactionID"), rs.getInt("OrderID"));
                    }
                    DatabaseConnector.removeObject((ResultSet)rs);
                }
                DatabaseConnector.removeObject((Statement)stmt);
                this._newTransactionList.clear();
                stmt = DatabaseConnector.createStatement((String)"getOrderDetailsList2");
                sql = "SELECT * FROM Orders INNER JOIN OrderDetails ON Orders.OrderID = OrderDetails.OrderID WHERE Orders.OrderStatusID=" + OrderStatusList.getInstance().getNewOrderStatus().getOrderStatusID() + " AND (OrderDetails.Deleted != TRUE OR OrderDetails.Deleted IS NULL)";
                rs = DatabaseConnector.createStatementResultSet((Statement)stmt, (String)sql, (String)"getOrderDetailsList2");
                if (null != rs) {
                    while (rs.next()) {
                        this._newTransactionList.put(rs.getString("TransactionID"), rs.getInt("OrderID"));
                    }
                    DatabaseConnector.removeObject((ResultSet)rs);
                }
                DatabaseConnector.removeObject((Statement)stmt);
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
    }

    private String createSubstring(String name, int length) {
        if (name.length() > length) {
            name = name.substring(0, length);
        }
        return name;
    }

    private void condenseStrings(Customer customer) {
        if (customer.getCustomerAddress() != null) {
            customer.setCustomerAddress(this.createSubstring(customer.getCustomerAddress(), 255));
        }
        if (customer.getCustomerCity() != null) {
            customer.setCustomerCity(this.createSubstring(customer.getCustomerCity(), 80));
        }
        if (customer.getCustomerCountry() != null) {
            customer.setCustomerCountry(this.createSubstring(customer.getCustomerCountry(), 32));
        }
        if (customer.getCustomerEmail() != null) {
            customer.setCustomerEmail(this.createSubstring(customer.getCustomerEmail(), 80));
        }
        if (customer.getCustomerName() != null) {
            customer.setCustomerName(this.createSubstring(customer.getCustomerName(), 255));
        }
        if (customer.getCustomerState() != null) {
            customer.setCustomerState(this.createSubstring(customer.getCustomerState(), 32));
        }
        if (customer.getCustomerUserName() != null) {
            customer.setCustomerUserName(this.createSubstring(customer.getCustomerUserName(), 80));
        }
        if (customer.getCustomerZipcode() != null) {
            customer.setCustomerZipcode(this.createSubstring(customer.getCustomerZipcode(), 12));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCustomer(Customer customer) {
        Object object = this._lock;
        synchronized (object) {
            try {
                this.condenseStrings(customer);
                String sql = "UPDATE Customers SET CustomerUserName= ?, CustomerEmail= ? , CustomerName= ? , CustomerCountry= ? , CustomerAddress= ? , CustomerCity= ? , CustomerState= ? , CustomerZipCode= ?  WHERE CustomerUserName= ? ";
                PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"updateCustomer");
                stmt.setString(1, customer.getCustomerUserName());
                stmt.setString(2, customer.getCustomerEmail());
                stmt.setString(3, customer.getCustomerName());
                stmt.setString(4, customer.getCustomerCountry());
                stmt.setString(5, customer.getCustomerAddress());
                stmt.setString(6, customer.getCustomerCity());
                stmt.setString(7, customer.getCustomerState());
                stmt.setString(8, customer.getCustomerZipcode());
                stmt.setString(9, customer.getCustomerUserName());
                DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                if (0 == stmt.getUpdateCount()) {
                    DatabaseConnector.removeObject((PreparedStatement)stmt);
                    sql = "INSERT INTO Customers  (CustomerUserName, CustomerEmail, CustomerName, CustomerCountry, CustomerAddress, CustomerCity, CustomerState, CustomerZipCode)Values (?, ?, ?, ?, ?, ?, ?, ?)";
                    stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"updateCustomer1");
                    stmt.setString(1, customer.getCustomerUserName());
                    stmt.setString(2, customer.getCustomerEmail());
                    stmt.setString(3, customer.getCustomerName());
                    stmt.setString(4, customer.getCustomerCountry());
                    stmt.setString(5, customer.getCustomerAddress());
                    stmt.setString(6, customer.getCustomerCity());
                    stmt.setString(7, customer.getCustomerState());
                    stmt.setString(8, customer.getCustomerZipcode());
                    DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                    DatabaseConnector.removeObject((PreparedStatement)stmt);
                } else {
                    DatabaseConnector.removeObject((PreparedStatement)stmt);
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateOrder(Order order) {
        int orderID = order.getOrderID();
        Object object = this._lock;
        synchronized (object) {
            try {
                if (0 != order.getOrderID()) {
                    String sql = "UPDATE Orders SET CustomerUserName=? , OrderDate= ? , OrderTotal= ? , ShippingMethodID= ? , ShippingCost= ? , ShippingPaid= ? , OrderStatusID= ? , OrderComments= ? , OrderPaypal= ?  WHERE OrderID= ? ";
                    PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"updateOrder");
                    stmt.setString(1, order.getCustomer().getCustomerUserName());
                    stmt.setDate(2, order.getOrderDate());
                    stmt.setFloat(3, order.getOrderTotal());
                    stmt.setString(4, order.getShippingMethodName());
                    stmt.setFloat(5, order.getShippingCost());
                    stmt.setFloat(6, order.getShippingPaid());
                    stmt.setInt(7, order.getOrderStatusID());
                    stmt.setString(8, order.getOrderComments());
                    stmt.setString(9, order.getPaypalAccount());
                    stmt.setInt(10, order.getOrderID());
                    DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                    DatabaseConnector.removeObject((PreparedStatement)stmt);
                } else {
                    String sql = "INSERT INTO Orders (CustomerUserName, OrderDate, OrderTotal, ShippingMethodID, ShippingCost, ShippingPaid, OrderStatusID, OrderComments, OrderPaypal) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
                    PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (int)1, (String)"updateOrder1");
                    stmt.setString(1, order.getCustomer().getCustomerUserName());
                    stmt.setDate(2, order.getOrderDate());
                    stmt.setFloat(3, order.getOrderTotal());
                    stmt.setString(4, order.getShippingMethodName());
                    stmt.setFloat(5, order.getShippingCost());
                    stmt.setFloat(6, order.getShippingPaid());
                    stmt.setInt(7, order.getOrderStatusID());
                    stmt.setString(8, order.getOrderComments());
                    stmt.setString(9, order.getPaypalAccount());
                    DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                    ResultSet rs = DatabaseConnector.createGeneratedKeys((Statement)stmt, (String)"updateOrder3");
                    if (null != rs && rs.next()) {
                        order.setOrderID(rs.getInt(1));
                        DatabaseConnector.removeObject((ResultSet)rs);
                    }
                    DatabaseConnector.removeObject((PreparedStatement)stmt);
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return order.getOrderID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateNewOrder(Order order) {
        Object object = this._lock;
        synchronized (object) {
            try {
                if (0 != order.getOrderID()) {
                    String sql = "UPDATE Orders SET ShippingPaid= ? , ShippingMethodID= ?, OrderStatusID= ?, OrderPaypal= ?  WHERE OrderID= ? ";
                    PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"updateNewOrder");
                    stmt.setFloat(1, order.getShippingPaid());
                    stmt.setString(2, order.getShippingMethodName());
                    stmt.setInt(3, order.getOrderStatusID());
                    stmt.setString(4, order.getPaypalAccount());
                    stmt.setInt(5, order.getOrderID());
                    DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                    DatabaseConnector.removeObject((PreparedStatement)stmt);
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return order.getOrderID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateOrderDetails(OrderDetails orderDetails) {
        int orderDetailsID = orderDetails.getOrderDetailsID();
        Object object = this._lock;
        synchronized (object) {
            try {
                String sql = "UPDATE OrderDetails SET TransactionID= ?, OrderID= ?, OrderNumber= ?";
                if (null != orderDetails.getShipDate() && !orderDetails.getShipDate().toString().equals("")) {
                    sql = sql + ", ShipDate= ?";
                }
                sql = sql + ", ItemID= ?, AccountName= ?, SalesPrice= ?, ItemCost= ?, Inhouse= ?, Backordered= ?, Deleted= ?, OrderDescription= ?, EbaySite= ?, EbayWeight = ? WHERE TransactionID= ?";
                PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"updateOrderDetails1");
                int index = 1;
                stmt.setString(index++, orderDetails.getTransactionID());
                stmt.setInt(index++, orderDetails.getOrderID());
                stmt.setString(index++, orderDetails.getOrderNumber());
                if (null != orderDetails.getShipDate() && !orderDetails.getShipDate().toString().equals("")) {
                    stmt.setDate(index++, orderDetails.getShipDate());
                }
                stmt.setString(index++, orderDetails.getItemID());
                stmt.setString(index++, orderDetails.getAccountName());
                stmt.setFloat(index++, orderDetails.getSalesPrice());
                stmt.setFloat(index++, orderDetails.getItemCost());
                stmt.setBoolean(index++, orderDetails.isInhouse());
                stmt.setBoolean(index++, orderDetails.isBackordered());
                stmt.setBoolean(index++, orderDetails.isDeleted());
                stmt.setString(index++, orderDetails.getOrderDescription());
                stmt.setString(index++, orderDetails.getEbaySite());
                stmt.setFloat(index++, orderDetails.getEbayWeight());
                stmt.setString(index++, orderDetails.getTransactionID());
                DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                if (0 == stmt.getUpdateCount()) {
                    DatabaseConnector.removeObject((PreparedStatement)stmt);
                    sql = "INSERT INTO OrderDetails  (TransactionID, OrderID, OrderNumber, Backordered, Deleted,";
                    if (null != orderDetails.getShipDate() && !orderDetails.getShipDate().toString().equals("")) {
                        sql = sql + "ShipDate, ";
                    }
                    sql = sql + "ItemID, AccountName, SalesPrice, ItemCost, Inhouse, OrderDescription, EbaySite, EbayWeight)Values (?, ?, ?, ?, ?, ";
                    if (null != orderDetails.getShipDate() && !orderDetails.getShipDate().toString().equals("")) {
                        sql = sql + "?, ";
                    }
                    sql = sql + "?, ?, ?, ?, ?, ?, ?, ?)";
                    stmt = DatabaseConnector.createPreparedStatement((String)sql, (int)1, (String)"updateOrderDetails2");
                    index = 1;
                    stmt.setString(index++, orderDetails.getTransactionID());
                    stmt.setInt(index++, orderDetails.getOrderID());
                    stmt.setString(index++, orderDetails.getOrderNumber());
                    stmt.setBoolean(index++, orderDetails.isBackordered());
                    stmt.setBoolean(index++, orderDetails.isDeleted());
                    if (null != orderDetails.getShipDate() && !orderDetails.getShipDate().toString().equals("")) {
                        stmt.setDate(index++, orderDetails.getShipDate());
                    }
                    stmt.setString(index++, orderDetails.getItemID());
                    stmt.setString(index++, orderDetails.getAccountName());
                    stmt.setFloat(index++, orderDetails.getSalesPrice());
                    stmt.setFloat(index++, orderDetails.getItemCost());
                    stmt.setBoolean(index++, orderDetails.isInhouse());
                    stmt.setString(index++, orderDetails.getOrderDescription());
                    stmt.setString(index++, orderDetails.getEbaySite());
                    stmt.setFloat(index++, orderDetails.getEbayWeight());
                    DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                    ResultSet rs = DatabaseConnector.createGeneratedKeys((Statement)stmt, (String)"updateOrderDetails3");
                    if (null != rs && rs.next()) {
                        orderDetailsID = rs.getInt(1);
                        orderDetails.setOrderDetailsID(orderDetailsID);
                        DatabaseConnector.removeObject((ResultSet)rs);
                    }
                    DatabaseConnector.removeObject((PreparedStatement)stmt);
                } else {
                    DatabaseConnector.removeObject((PreparedStatement)stmt);
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return orderDetails.getOrderDetailsID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTracking(TransactionType transaction) {
        Object object = this._lock;
        synchronized (object) {
            try {
                String sql = "UPDATE OrderDetails SET TrackingNumber= ?, Carrier= ? WHERE TransactionID= ?";
                PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"updateTracking");
                int index = 1;
                stmt.setString(index++, transaction.getShippingDetails().getShipmentTrackingDetails()[0].getShipmentTrackingNumber());
                stmt.setString(index++, transaction.getShippingDetails().getShipmentTrackingDetails()[0].getShippingCarrierUsed());
                String transactionID = transaction.getTransactionID().equals("0") ? transaction.getOrderLineItemID() : transaction.getTransactionID();
                stmt.setString(index++, transactionID);
                DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                DatabaseConnector.removeObject((PreparedStatement)stmt);
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
    }

    public String sanitize(String uncleanString) {
        String sanitizedString = null != uncleanString ? uncleanString.replace("'", "") : "";
        return sanitizedString;
    }

    private Collection<ArrayList<InventoryElement>> getInventoryList(String searchString, boolean instock, boolean oos, boolean inhouse, String[] distributorsFilter, boolean fullText) {
        HashMap<String, ArrayList> inventory = new HashMap<String, ArrayList>();
        ResultSet rs = PNPDatabaseManager.getInstance().getInventoryList(searchString, instock, oos, inhouse, false, distributorsFilter, fullText);
        try {
            if (null != rs) {
                while (rs.next()) {
                    ArrayList elementArrayList;
                    InventoryElement element = new InventoryElement();
                    element.setInventoryID(rs.getInt("InventoryID"));
                    element.setItemQuantity(rs.getInt("ItemQuantity"));
                    element.setItemCost(rs.getFloat("ItemCost"));
                    element.setItemID(rs.getString("ItemID"));
                    element.setOosItem(rs.getBoolean("OOSItem"));
                    if (inventory.containsKey(element.getItemID())) {
                        elementArrayList = (ArrayList)inventory.get(element.getItemID());
                        if (element.isOosItem()) {
                            elementArrayList.add(0, element);
                        } else {
                            elementArrayList.add(element);
                        }
                    } else {
                        elementArrayList = new ArrayList();
                        if (element.isOosItem()) {
                            elementArrayList.add(0, element);
                        } else {
                            elementArrayList.add(element);
                        }
                    }
                    inventory.put(element.getItemID(), elementArrayList);
                }
                DatabaseConnector.removeObject((ResultSet)rs);
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        return inventory.values();
    }

    private void updateInventoryStatus(OrderDetails detail) {
        Item item;
        String itemName = detail.getItemID();
        Collection<ArrayList<InventoryElement>> inventoryElements = this.getInventoryList(itemName, false, false, false, new String[0], false);
        InventoryElement selectedInventoryItem = null;
        if (inventoryElements.size() == 1) {
            for (ArrayList<InventoryElement> inventorySubset : inventoryElements) {
                for (InventoryElement inventoryElement : inventorySubset) {
                    if (selectedInventoryItem == null) {
                        selectedInventoryItem = inventoryElement;
                    }
                    if (inventoryElement.getItemQuantity() <= 0 || selectedInventoryItem != null && !(selectedInventoryItem.getItemCost() > inventoryElement.getItemCost()) && selectedInventoryItem.getItemQuantity() > 0) continue;
                    selectedInventoryItem = inventoryElement;
                }
            }
        }
        if (null != selectedInventoryItem && (item = InventoryList.getInstance().getItem(selectedInventoryItem.getItemID())) != null && !item.isDropShipped()) {
            detail.setItemCost(selectedInventoryItem.getItemCost());
            detail.setItemID(selectedInventoryItem.getItemID());
            detail.setBackordered(selectedInventoryItem.isOosItem());
            detail.setInhouse(true);
            selectedInventoryItem.setItemQuantity(selectedInventoryItem.getItemQuantity() - 1);
            InventoryList.getInstance().setInventoryElement(selectedInventoryItem);
            int quantity = this.getItemQuantity(selectedInventoryItem.getItemID(), false);
            if (Preferences.getInstance().getAccountPreferences().getGenStockNotification() != AccountPreferences.NEVER) {
                if (quantity <= Preferences.getInstance().getAccountPreferences().getGenStockNotification() && quantity > 0 && Preferences.getInstance().getAccountPreferences().getGenStockNotification() != 0) {
                    this.inventoryWarningMessage = this.inventoryWarningMessage + itemName + ": running low on stock, time to reorder.\n";
                } else if (quantity == 0) {
                    this.inventoryWarningMessage = item.isDiscontinued() ? this.inventoryWarningMessage + itemName + ": consumed last item in stock. Item Discontinued, take auction down.\n" : this.inventoryWarningMessage + itemName + ": consumed last item in stock, time to reorder\n";
                }
            }
        }
    }

    private int getItemQuantity(String itemID, boolean cached) {
        int quantity = 0;
        if (cached) {
            quantity = InventoryList.getInstance().getItemQuantity(itemID);
        } else {
            Collection<ArrayList<InventoryElement>> inventoryList = this.getInventoryList(itemID, false, false, false, new String[0], false);
            ArrayList<InventoryElement> inventoryElements = null;
            boolean found = false;
            Iterator<ArrayList<InventoryElement>> iter = inventoryList.iterator();
            while (iter.hasNext() && !found) {
                inventoryElements = iter.next();
                if (inventoryElements == null || !inventoryElements.get(0).getItemID().equals(itemID)) continue;
                found = true;
            }
            if (found) {
                Iterator inventoryIter = inventoryElements.iterator();
                while (inventoryIter.hasNext()) {
                    quantity += ((InventoryElement)inventoryIter.next()).getItemQuantity();
                }
            }
        }
        return quantity;
    }
}

