/*
 * Decompiled with CFR 0.152.
 */
package pnp.comms.db;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import pnp.comms.db.lists.OrderStatusList;
import pnp.services.datatypes.AccountPreferences;
import pnp.services.datatypes.AmazonAccount;
import pnp.services.datatypes.Category;
import pnp.services.datatypes.CategoryAssociation;
import pnp.services.datatypes.CheckDetails;
import pnp.services.datatypes.CompanyInfo;
import pnp.services.datatypes.CompleteOrder;
import pnp.services.datatypes.CustomFee;
import pnp.services.datatypes.Customer;
import pnp.services.datatypes.Distributor;
import pnp.services.datatypes.EbayTransactions;
import pnp.services.datatypes.EtsyAccount;
import pnp.services.datatypes.EtsyOrder;
import pnp.services.datatypes.EtsyTransaction;
import pnp.services.datatypes.Expense;
import pnp.services.datatypes.ExpenseReason;
import pnp.services.datatypes.InventoryElement;
import pnp.services.datatypes.Item;
import pnp.services.datatypes.Order;
import pnp.services.datatypes.OrderDetails;
import pnp.services.datatypes.OrderStatus;
import pnp.services.datatypes.PaypalDetails;
import pnp.services.datatypes.PrintDetails;
import pnp.services.datatypes.RESTData;
import pnp.services.datatypes.RMADetails;
import pnp.services.datatypes.webservices.Ebayaccount;
import pnp.services.datatypes.webservices.Website;
import pnp.services.datatypes.webservices.WebsiteCategories;
import pnp.services.datatypes.webservices.WebsiteElement;
import pnp.services.localsettings.LocalSettings;
import pnp.services.preferencemanager.Preferences;
import pnp.services.util.DatabaseConnector;
import pnp.services.util.ErrorsUtil;
import pnp.services.util.MathParser;
import pnp.services.util.SQLUtil;

public class PNPDatabaseManager {
    private static PNPDatabaseManager _instance;
    private final Object _lock = new Object();
    private LocalSettings _localSettings = LocalSettings.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<String, Integer> getOrderDetailsList() {
        HashMap<String, Integer> transactionList = new HashMap<String, Integer>();
        Object object = this._lock;
        synchronized (object) {
            try {
                Statement stmt = DatabaseConnector.createStatement((String)"getOrderDetailsList");
                String sql = "SELECT * FROM Orders INNER JOIN OrderDetails ON Orders.OrderID = OrderDetails.OrderID WHERE Orders.OrderStatusID=" + OrderStatusList.getInstance().getNewOrderStatus().getOrderStatusID() + " AND (OrderDetails.Deleted != TRUE OR OrderDetails.Deleted IS NULL)";
                ResultSet rs = DatabaseConnector.createStatementResultSet((Statement)stmt, (String)sql, (String)"getOrderDetailsList");
                while (null != rs && rs.next()) {
                    transactionList.put(rs.getString("TransactionID"), rs.getInt("OrderID"));
                }
                DatabaseConnector.removeObject((ResultSet)rs);
                DatabaseConnector.removeObject((Statement)stmt);
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
                long dateRange = System.currentTimeMillis() - 2592000000L;
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(dateRange);
                stmt = DatabaseConnector.createStatement((String)"getOrderDetailsList");
                sql = "SELECT * FROM Orders INNER JOIN OrderDetails ON Orders.OrderID = OrderDetails.OrderID WHERE OrderDate >= '" + formatter.format(calendar.getTime()) + "' " + "AND Orders.OrderStatusID!=" + OrderStatusList.getInstance().getNewOrderStatus().getOrderStatusID();
                rs = DatabaseConnector.createStatementResultSet((Statement)stmt, (String)sql, (String)"getOrderDetailsList");
                while (null != rs && rs.next()) {
                    transactionList.put(rs.getString("TransactionID"), rs.getInt("OrderID"));
                }
                DatabaseConnector.removeObject((ResultSet)rs);
                DatabaseConnector.removeObject((Statement)stmt);
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return transactionList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEtsyOrders(HashMap<String, EtsyOrder> etsyOrderList) {
        Object object = this._lock;
        synchronized (object) {
            try {
                HashMap<String, Integer> transactionList = this.getOrderDetailsList();
                for (EtsyOrder etsyOrder : etsyOrderList.values()) {
                    boolean orderAdded = false;
                    int orderID = 0;
                    for (EtsyTransaction etsyTransaction : etsyOrder.getTransactions()) {
                        if (transactionList != null && transactionList.containsKey(etsyTransaction.getTransactionID())) continue;
                        if (!orderAdded) {
                            Customer customer = new Customer();
                            String fullAddress = etsyOrder.getStreet1() + " " + etsyOrder.getStreet2();
                            customer.setCustomerAddress(fullAddress.trim());
                            customer.setCustomerCity(etsyOrder.getCity());
                            customer.setCustomerComments("");
                            customer.setCustomerCountry(etsyOrder.getCountryName());
                            customer.setCustomerEmail(etsyOrder.getCustomerEmail());
                            customer.setCustomerName(etsyOrder.getCustomerName());
                            customer.setCustomerState(etsyOrder.getState());
                            customer.setCustomerUserName(etsyOrder.getCustomerEmail());
                            customer.setCustomerZipcode(etsyOrder.getZip());
                            Order order = new Order();
                            if (etsyOrder.getStoreName().contains("Bandaru")) {
                                order.setPaypalAccount("Bandaru");
                            } else if (etsyOrder.getStoreName().contains("621")) {
                                order.setPaypalAccount("621 Fashions");
                            }
                            order.setCustomerUserName(etsyOrder.getCustomerEmail());
                            if (etsyTransaction.getCreationDate() != null) {
                                order.setOrderDate(new Date(etsyTransaction.getCreationDate().getTime()));
                            }
                            if (etsyOrder.isPaid()) {
                                order.setOrderStatus(OrderStatusList.getInstance().getPendingPrintStatus());
                            } else {
                                order.setOrderStatus(OrderStatusList.getInstance().getNewOrderStatus());
                            }
                            order.setOrderTotal(etsyOrder.getTotalPrice().floatValue());
                            order.setShippingPaid(etsyOrder.getTotalShipping().floatValue());
                            order.setCustomer(customer);
                            order.setOrderComments("Etsy Order");
                            order.setOrderID(0);
                            if (customer.getCustomerCountry().equals("USA") || customer.getCustomerCountry().equals("US") || customer.getCustomerCountry().equals("United States")) {
                                float baseShipping;
                                int shippingOffset = 0;
                                if (etsyOrder.getTotalItems() > 1) {
                                    shippingOffset = etsyOrder.getTotalItems() - 1;
                                }
                                if ((double)(baseShipping = etsyOrder.getTotalShipping().floatValue() - (float)shippingOffset) > 20.0) {
                                    order.setShippingMethodName("USPSExpressMail");
                                } else if ((double)baseShipping > 2.5) {
                                    order.setShippingMethodName("USPSPriority");
                                } else {
                                    order.setShippingMethodName("USPSFirstClass");
                                }
                            } else {
                                order.setShippingMethodName("USPSFirstClassMailInternational");
                            }
                            orderID = this.updateOrder(order);
                            orderAdded = true;
                        }
                        for (int i = 0; i < etsyTransaction.getQuantity(); ++i) {
                            OrderDetails orderDetails = new OrderDetails();
                            orderDetails.setAccountName(etsyOrder.getStoreName());
                            orderDetails.setEbaySite("Etsy");
                            orderDetails.setEbayWeight(0.0f);
                            orderDetails.setItemID(etsyTransaction.getItemSKU());
                            orderDetails.setOrderDescription(etsyTransaction.getTitle());
                            orderDetails.setOrderID(orderID);
                            orderDetails.setOrderNumber(etsyTransaction.getReceiptID());
                            orderDetails.setItemCost(0.0f);
                            orderDetails.setSalesPrice(etsyTransaction.getPrice().floatValue());
                            orderDetails.setOrderDetailsID(0);
                            orderDetails.setTransactionID(etsyTransaction.getTransactionID());
                            if (i != 0) {
                                orderDetails.setTransactionID(etsyTransaction.getTransactionID() + "-" + i);
                            }
                            if (etsyTransaction.getShippedDate() != null) {
                                orderDetails.setShipDate(new Date(etsyTransaction.getShippedDate().getTime()));
                            }
                            this.updateOrderDetails(orderDetails);
                        }
                    }
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAmazonOrders(Collection<CompleteOrder> amazonOrderList) {
        Object object = this._lock;
        synchronized (object) {
            try {
                HashMap<String, Integer> transactionList = this.getOrderDetailsList();
                for (CompleteOrder amazonOrder : amazonOrderList) {
                    if (transactionList != null && transactionList.containsKey(((OrderDetails)amazonOrder.getOrderDetails().get(0)).getTransactionID())) continue;
                    amazonOrder.getOrder().setOrderStatus(OrderStatusList.getInstance().getPendingPrintStatus());
                    amazonOrder.getOrder().setOrderID(0);
                    int orderID = this.updateOrder(amazonOrder.getOrder());
                    for (int i = 0; i < amazonOrder.getOrderDetails().size(); ++i) {
                        ((OrderDetails)amazonOrder.getOrderDetails().get(i)).setOrderID(orderID);
                        ((OrderDetails)amazonOrder.getOrderDetails().get(i)).setOrderDetailsID(0);
                        this.updateOrderDetails((OrderDetails)amazonOrder.getOrderDetails().get(i));
                    }
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
    }

    private PNPDatabaseManager() {
    }

    public static PNPDatabaseManager getInstance() {
        if (null == _instance) {
            _instance = new PNPDatabaseManager();
        }
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRESTData(RESTData restData) {
        Object object = this._lock;
        synchronized (object) {
            try {
                PreparedStatement stmt;
                String userName = restData.getSubscription().getCustomerUserName();
                Statement truncateStmt = DatabaseConnector.createStatement((String)"updateRESTData");
                String sql = "TRUNCATE TABLE EbayAccount";
                DatabaseConnector.executeUpdate((Statement)truncateStmt, (String)sql);
                sql = "TRUNCATE TABLE PaypalAccount";
                DatabaseConnector.executeUpdate((Statement)truncateStmt, (String)sql);
                sql = "TRUNCATE TABLE Subscription";
                DatabaseConnector.executeUpdate((Statement)truncateStmt, (String)sql);
                DatabaseConnector.removeObject((Statement)truncateStmt);
                for (Ebayaccount account : restData.getSubscription().getEbayaccountCollection()) {
                    sql = "UPDATE EbayAccount SET EbayAccountID = ?, UserToken = ? WHERE EbayAccountNumber = ?";
                    stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"updateRESTData Update Ebayaccount");
                    stmt.setString(1, account.getEbayAccountID());
                    stmt.setString(2, account.getUserToken());
                    stmt.setInt(3, account.getEbayAccountNumber());
                    DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                    if (0 == stmt.getUpdateCount()) {
                        DatabaseConnector.removeObject((PreparedStatement)stmt);
                        sql = "INSERT INTO EbayAccount (EbayAccountID, UserToken, UserName)Values(?, ?, ?)";
                        stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"updateRESTData Insert Ebayaccount");
                        stmt.setString(1, account.getEbayAccountID());
                        stmt.setString(2, account.getUserToken());
                        stmt.setString(3, userName);
                        DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                        DatabaseConnector.removeObject((PreparedStatement)stmt);
                        continue;
                    }
                    DatabaseConnector.removeObject((PreparedStatement)stmt);
                }
                for (Ebayaccount account : restData.getSubscription().getPaypalaccountCollection()) {
                    sql = "UPDATE PaypalAccount SET PaypalAccountID = ?, AccessToken = ?, TokenSecret = ? WHERE PaypalAccountNumber = ?";
                    stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"updateRESTData Update PaypalAccount");
                    stmt.setString(1, account.getPaypalAccountID());
                    stmt.setString(2, account.getAccessToken());
                    stmt.setString(3, account.getTokenSecret());
                    stmt.setInt(4, account.getPaypalAccountNumber());
                    DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                    if (0 == stmt.getUpdateCount()) {
                        DatabaseConnector.removeObject((PreparedStatement)stmt);
                        sql = "INSERT INTO PaypalAccount (PaypalAccountID, AccessToken, TokenSecret, UserName)Values(?, ?, ?, ?)";
                        stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"updateRESTData Insert PaypalAccount");
                        stmt.setString(1, account.getPaypalAccountID());
                        stmt.setString(2, account.getAccessToken());
                        stmt.setString(3, account.getTokenSecret());
                        stmt.setString(4, userName);
                        DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                        DatabaseConnector.removeObject((PreparedStatement)stmt);
                        continue;
                    }
                    DatabaseConnector.removeObject((PreparedStatement)stmt);
                }
                sql = "UPDATE Subscription SET Finance = ?, Inventory = ?, Website = ?, Multi = ?, Paypal = ?, Print = ?, Current = ?, Expire = ?, Offline = ?, Timer = ?, Password = ?,License = ?  WHERE UserName = ?";
                stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"updateRESTData Update Subscription");
                stmt.setBoolean(1, restData.isFinance());
                stmt.setBoolean(2, restData.isInventory());
                stmt.setBoolean(3, restData.isWebsite());
                stmt.setBoolean(4, restData.isMulti());
                stmt.setBoolean(5, restData.isPaypal());
                stmt.setBoolean(6, restData.isPrint());
                stmt.setBoolean(7, restData.isCurrent());
                stmt.setDate(8, restData.getExpire());
                stmt.setBoolean(9, restData.isOffline());
                stmt.setDate(10, restData.getTimer());
                stmt.setString(11, restData.getPassword());
                stmt.setString(12, restData.getLicense());
                stmt.setString(13, userName);
                DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                if (0 == stmt.getUpdateCount()) {
                    DatabaseConnector.removeObject((PreparedStatement)stmt);
                    sql = "INSERT INTO Subscription (Finance,Inventory,Website,Multi,Paypal,Print,Current,Expire,UserName,Offline, Timer, Password, License)Values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                    stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"updateRESTData Insert Subscription");
                    stmt.setBoolean(1, restData.isFinance());
                    stmt.setBoolean(2, restData.isInventory());
                    stmt.setBoolean(3, restData.isWebsite());
                    stmt.setBoolean(4, restData.isMulti());
                    stmt.setBoolean(5, restData.isPaypal());
                    stmt.setBoolean(6, restData.isPrint());
                    stmt.setBoolean(7, restData.isCurrent());
                    stmt.setDate(8, restData.getExpire());
                    stmt.setString(9, userName);
                    stmt.setBoolean(10, restData.isOffline());
                    stmt.setDate(11, restData.getTimer());
                    stmt.setString(12, restData.getPassword());
                    stmt.setString(13, restData.getLicense());
                    DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                    DatabaseConnector.removeObject((PreparedStatement)stmt);
                } else {
                    DatabaseConnector.removeObject((PreparedStatement)stmt);
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getLicense() {
        ResultSet rs = null;
        Object object = this._lock;
        synchronized (object) {
            try {
                String sql = "SELECT * FROM License";
                Statement stmt = DatabaseConnector.createStatement((String)"getLicense");
                rs = DatabaseConnector.createStatementResultSet((Statement)stmt, (String)sql, (String)"getLicense1");
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getEbayAccount(String userName) {
        ResultSet rs = null;
        Object object = this._lock;
        synchronized (object) {
            try {
                String sql = "SELECT * FROM EbayAccount WHERE UserName= ? ";
                PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"getEbayAccount");
                stmt.setString(1, userName);
                rs = DatabaseConnector.createPreparedStatementResultSet((PreparedStatement)stmt, (String)"getEbayAccount1");
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getPaypalAccount(String userName) {
        ResultSet rs = null;
        Object object = this._lock;
        synchronized (object) {
            try {
                String sql = "SELECT * FROM PaypalAccount WHERE UserName= ? ";
                PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"getPaypalAccount");
                stmt.setString(1, userName);
                rs = DatabaseConnector.createPreparedStatementResultSet((PreparedStatement)stmt, (String)"getPaypalAccount1");
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getAmazonAccount(String userName) {
        ResultSet rs = null;
        Object object = this._lock;
        synchronized (object) {
            try {
                String sql = "SELECT * FROM AmazonAccount WHERE UserName= ? ";
                PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"getAmazonAccount");
                stmt.setString(1, userName);
                rs = DatabaseConnector.createPreparedStatementResultSet((PreparedStatement)stmt, (String)"getAmazonAccount1");
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getSubscription(String userName) {
        ResultSet rs = null;
        Object object = this._lock;
        synchronized (object) {
            try {
                String sql = "SELECT * FROM Subscription WHERE UserName= ? ";
                PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"getSubscription");
                stmt.setString(1, userName);
                rs = DatabaseConnector.createPreparedStatementResultSet((PreparedStatement)stmt, (String)"getSubscription1");
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLicense(String license) {
        Object object = this._lock;
        synchronized (object) {
            try {
                String sql = "UPDATE License SET License = ?";
                PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"setLicense");
                stmt.setString(1, license);
                DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                if (0 == stmt.getUpdateCount()) {
                    DatabaseConnector.removeObject((PreparedStatement)stmt);
                    sql = "INSERT INTO License (License)Values(?)";
                    stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"setLicense1");
                    stmt.setString(1, license);
                    DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                    DatabaseConnector.removeObject((PreparedStatement)stmt);
                } else {
                    DatabaseConnector.removeObject((PreparedStatement)stmt);
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getCheckDetails(String orderID) {
        ResultSet rs = null;
        Object object = this._lock;
        synchronized (object) {
            try {
                String sql = "SELECT * FROM CheckDetails WHERE OrderID= ? ";
                PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"getCheckDetails");
                stmt.setString(1, orderID);
                rs = DatabaseConnector.createPreparedStatementResultSet((PreparedStatement)stmt, (String)"getCheckDetails");
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteCheckDetails(String orderID) {
        Object object = this._lock;
        synchronized (object) {
            try {
                String sql = "DELETE FROM CheckDetails WHERE OrderID= ?";
                PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"deleteCheckDetails");
                stmt.setString(1, orderID);
                DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                DatabaseConnector.removeObject((PreparedStatement)stmt);
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertCheckDetails(CheckDetails checkDetails) {
        Object object = this._lock;
        synchronized (object) {
            try {
                int counter = 1;
                if (checkDetails.getCheckID() == -1) {
                    String sql = "INSERT INTO CheckDetails (OrderID, OrderDetailsID, Weight, PackedWeight, PayPalAccount, Discontinued, QuantityRemaining, ItemID)Values(?, ?, ?, ?, ?, ?, ?, ?)";
                    PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"insertCheckDetails");
                    stmt.setString(counter++, checkDetails.getOrderID());
                    stmt.setInt(counter++, checkDetails.getOrderDetailsID());
                    stmt.setFloat(counter++, checkDetails.getWeight());
                    stmt.setFloat(counter++, checkDetails.getPackedWeight());
                    stmt.setString(counter++, checkDetails.getPaypalAccount());
                    stmt.setBoolean(counter++, checkDetails.isDiscontinued());
                    stmt.setInt(counter++, checkDetails.getQuantityLeft());
                    stmt.setString(counter++, checkDetails.getItemID());
                    DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                    DatabaseConnector.removeObject((PreparedStatement)stmt);
                } else {
                    String sql = "UPDATE CheckDetails SET Weight = ?, PackedWeight = ?, PayPalAccount = ?,Discontinued = ?, QuantityRemaining = ?,ItemID = ? WHERE CheckID = ? ";
                    counter = 1;
                    PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"insertCheckDetails1");
                    stmt.setFloat(counter++, checkDetails.getWeight());
                    stmt.setFloat(counter++, checkDetails.getPackedWeight());
                    stmt.setString(counter++, checkDetails.getPaypalAccount());
                    stmt.setBoolean(counter++, checkDetails.isDiscontinued());
                    stmt.setInt(counter++, checkDetails.getQuantityLeft());
                    stmt.setString(counter++, checkDetails.getItemID());
                    stmt.setInt(counter++, checkDetails.getCheckID());
                    DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                    DatabaseConnector.removeObject((PreparedStatement)stmt);
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getAccountPreferences(String profile) {
        ResultSet rs = null;
        Object object = this._lock;
        synchronized (object) {
            try {
                String sql = "SELECT * FROM AccountPreferences WHERE GenProfile= ? ";
                PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"getAccountPreferences");
                stmt.setString(1, profile);
                rs = DatabaseConnector.createPreparedStatementResultSet((PreparedStatement)stmt, (String)"getAccountPreferences");
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getCompanyInfo() {
        ResultSet rs = null;
        Object object = this._lock;
        synchronized (object) {
            try {
                String sql = "SELECT * FROM Companies";
                PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"getCompanyInfo");
                rs = DatabaseConnector.createPreparedStatementResultSet((PreparedStatement)stmt, (String)"getCompanyInfo");
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return rs;
    }

    public String updateGeneric(String table, String[] values) {
        String sql = "";
        String whereClause = "";
        if (table != null && !table.isEmpty() && values != null && values.length > 0) {
            sql = "UPDATE " + table + " SET ";
            boolean first = true;
            for (String value : values) {
                if (value == null || value.trim().isEmpty()) continue;
                if (!first) {
                    sql = sql + ",";
                }
                sql = sql + value.trim() + "=?";
                first = false;
            }
            whereClause = " WHERE " + values[0] + "=?";
        }
        return sql + whereClause;
    }

    public String insertGeneric(String table, String[] values) {
        String sql = "";
        String endingSQL = "";
        if (table != null && !table.isEmpty() && values != null && values.length > 0) {
            sql = "INSERT INTO " + table + " (";
            boolean first = true;
            for (String value : values) {
                if (value == null || value.trim().isEmpty()) continue;
                if (!first) {
                    sql = sql + ",";
                    endingSQL = endingSQL + ",";
                } else {
                    endingSQL = endingSQL + ")Values(";
                }
                sql = sql + value.trim();
                endingSQL = endingSQL + "?";
                first = false;
            }
            endingSQL = endingSQL + ")";
        }
        return sql + endingSQL;
    }

    private boolean setStatementCompanyInfo(String sql, CompanyInfo specificCompany, boolean update) {
        boolean updateSuccessful = false;
        try {
            PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"setStatementCompanyInfo");
            int itemIndex = 1;
            stmt.setString(itemIndex++, specificCompany.getCompanyName());
            stmt.setString(itemIndex++, specificCompany.getCompanyWebsite());
            stmt.setString(itemIndex++, specificCompany.getCompanyComments());
            stmt.setString(itemIndex++, specificCompany.getCompanyAddress());
            stmt.setString(itemIndex++, specificCompany.getCompanyCity());
            stmt.setString(itemIndex++, specificCompany.getCompanyCountry());
            stmt.setString(itemIndex++, specificCompany.getCompanyFullName());
            stmt.setString(itemIndex++, specificCompany.getCompanyPhoneNumber());
            stmt.setString(itemIndex++, specificCompany.getCompanyPostalCode());
            stmt.setString(itemIndex++, specificCompany.getCompanyState());
            if (update) {
                stmt.setString(itemIndex++, specificCompany.getCompanyName());
            }
            DatabaseConnector.executeUpdate((PreparedStatement)stmt);
            updateSuccessful = 0 != stmt.getUpdateCount();
            DatabaseConnector.removeObject((PreparedStatement)stmt);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        return updateSuccessful;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean convertCompanyNameOrders(String companySelected, String companyRenamed) {
        boolean updateSuccessful = false;
        Object object = this._lock;
        synchronized (object) {
            try {
                String errorMessage = "";
                String sql = "UPDATE Orders SET OrderPaypal= ? WHERE OrderPaypal = ?";
                PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"convertCompanyNameOrders");
                int itemIndex = 1;
                stmt.setString(itemIndex++, companyRenamed);
                stmt.setString(itemIndex++, companySelected);
                DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                DatabaseConnector.removeObject((PreparedStatement)stmt);
                sql = "UPDATE Expenses SET CompanyName= ? WHERE CompanyName = ?";
                stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"convertCompanyNameOrders1");
                itemIndex = 1;
                stmt.setString(itemIndex++, companyRenamed);
                stmt.setString(itemIndex++, companySelected);
                DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                DatabaseConnector.removeObject((PreparedStatement)stmt);
                updateSuccessful = true;
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return updateSuccessful;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean renameCompany(String companySelected, String companyRenamed) {
        boolean updateSuccessful = false;
        Object object = this._lock;
        synchronized (object) {
            try {
                String sql = "UPDATE Companies SET CompanyName = ? WHERE CompanyName = ?";
                PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"renameCompany");
                int itemIndex = 1;
                stmt.setString(itemIndex++, companyRenamed);
                stmt.setString(itemIndex++, companySelected);
                DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                updateSuccessful = 0 != stmt.getUpdateCount();
                DatabaseConnector.removeObject((PreparedStatement)stmt);
                if (updateSuccessful) {
                    this.convertCompanyNameOrders(companySelected, companyRenamed);
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return updateSuccessful;
    }

    private boolean setProfile(String sql, String profile, boolean update) {
        boolean updateSuccessful = true;
        try {
            PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"setProfile");
            int itemIndex = 1;
            stmt.setString(itemIndex++, profile);
            if (update) {
                stmt.setString(itemIndex++, profile);
            }
            DatabaseConnector.executeUpdate((PreparedStatement)stmt);
            if (0 == stmt.getUpdateCount()) {
                updateSuccessful = false;
            }
            DatabaseConnector.removeObject((PreparedStatement)stmt);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        return updateSuccessful;
    }

    public void updateProfiles(List<String> profiles) {
        if (profiles != null && !profiles.isEmpty()) {
            for (String profile : profiles) {
                String updateSQL = this.updateGeneric("Profiles", new String[]{"Profile"});
                String insertSQL = this.insertGeneric("Profiles", new String[]{"Profile"});
                if (this.setProfile(updateSQL, profile, true)) continue;
                this.setProfile(insertSQL, profile, false);
            }
        }
    }

    private boolean setCompanyLinks(String sql, String companyName, ArrayList<String> companyLinks, boolean update) {
        boolean updateSuccessful = true;
        try {
            PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"setCompanyLinks");
            for (String link : companyLinks) {
                int itemIndex = 1;
                stmt.setString(itemIndex++, link);
                stmt.setString(itemIndex++, companyName);
                if (update) {
                    stmt.setString(itemIndex++, link);
                }
                DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                if (0 != stmt.getUpdateCount()) continue;
                updateSuccessful = false;
            }
            DatabaseConnector.removeObject((PreparedStatement)stmt);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        return updateSuccessful;
    }

    public void updateCompanyLinks(CompanyInfo specificCompany) {
        String companyName = specificCompany.getCompanyName();
        if (companyName != null && !companyName.trim().isEmpty() && !companyName.equalsIgnoreCase("Default")) {
            companyName = companyName.trim();
            ArrayList companyLinks = specificCompany.getCompanyPaypalLinks();
            String updateSQL = this.updateGeneric("CompanyLinks", new String[]{"PayPalLink", "CompanyName"});
            String insertSQL = this.insertGeneric("CompanyLinks", new String[]{"PayPalLink", "CompanyName"});
            if (!this.setCompanyLinks(updateSQL, companyName, companyLinks, true)) {
                this.setCompanyLinks(insertSQL, companyName, companyLinks, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateCompanyInfo(AccountPreferences preferences) {
        Object object = this._lock;
        synchronized (object) {
            try {
                String[] values = new String[]{"CompanyName", "CompanyWebsite", "CompanyComments", "CompanyAddress", "CompanyCity", "CompanyCountry", "CompanyFullName", "CompanyPhoneNumber", "CompanyPostalCode", "CompanyState"};
                String table = "Companies";
                String updateSQL = this.updateGeneric(table, values);
                String insertSQL = this.insertGeneric(table, values);
                for (String companyName : preferences.getCompanyInformation().keySet()) {
                    CompanyInfo specificCompany = preferences.getSpecificCompany(companyName);
                    if (specificCompany == null) continue;
                    if (!this.setStatementCompanyInfo(updateSQL, specificCompany, true)) {
                        this.setStatementCompanyInfo(insertSQL, specificCompany, false);
                    }
                    this.updateCompanyLinks(specificCompany);
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getPayPalAccounts() {
        Object object = this._lock;
        synchronized (object) {
            try {
                String sql = "SELECT * FROM PayPalAccounts";
                Statement queryStmt = DatabaseConnector.createStatement((String)"getPayPalAccounts");
                return DatabaseConnector.createStatementResultSet((Statement)queryStmt, (String)sql, (String)"getPayPalAccounts");
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getProfiles() {
        Object object = this._lock;
        synchronized (object) {
            try {
                String sql = "SELECT * FROM Profiles";
                Statement queryStmt = DatabaseConnector.createStatement((String)"getProfiles");
                return DatabaseConnector.createStatementResultSet((Statement)queryStmt, (String)sql, (String)"getProfiles");
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getCompanyLinks() {
        Object object = this._lock;
        synchronized (object) {
            try {
                String sql = "SELECT * FROM CompanyLinks";
                Statement queryStmt = DatabaseConnector.createStatement((String)"getCompanyLinks");
                return DatabaseConnector.createStatementResultSet((Statement)queryStmt, (String)sql, (String)"getCompanyLinks");
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updatePayPalAccounts(ArrayList<String> paypalAccounts) {
        Object object = this._lock;
        synchronized (object) {
            try {
                Statement stmtDelete = DatabaseConnector.createStatement((String)"updatePayPalAccounts");
                int test = DatabaseConnector.executeUpdate((Statement)stmtDelete, (String)"TRUNCATE TABLE PayPalAccounts");
                DatabaseConnector.removeObject((Statement)stmtDelete);
                for (String paypalAccount : paypalAccounts) {
                    String sql = "INSERT INTO PayPalAccounts (PayPalAccount)Values(?)";
                    PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"updatePayPalAccounts");
                    stmt.setString(1, paypalAccount);
                    try {
                        DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                    }
                    catch (Exception ex) {
                        ErrorsUtil.getInstance().logError(ex);
                    }
                    finally {
                        DatabaseConnector.removeObject((PreparedStatement)stmt);
                    }
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateAccountPreferences(AccountPreferences preferences) {
        Object object = this._lock;
        synchronized (object) {
            try {
                this.updateFilterList(preferences);
                this.updateCompanyInfo(preferences);
                if (!preferences.getGenProfile().isEmpty()) {
                    String sql = "SELECT * FROM AccountPreferences WHERE GenProfile ='" + preferences.getGenProfile() + "'";
                    Statement queryStmt = DatabaseConnector.createStatement((String)"updateAccountPreferences");
                    ResultSet rs = DatabaseConnector.createStatementResultSet((Statement)queryStmt, (String)sql, (String)"updateAccountPreferences");
                    this.updateProfiles(preferences.getGenProfiles());
                    if (rs.first()) {
                        sql = "UPDATE AccountPreferences SET GenNegativeNotification =?, GenRefreshBehavior =?, GenSalesPeriod =?, GenStockNotification =?, GenTrackingNotify =?, GenUnmergeNotify =?, GenBusinessName =?, GenInvoiceComments =?, GenWebsiteAddress =?, GenVersion = ?,GenSyncNotification = ?,GenSplitRefresh = ?,GenInventoryRefresh = ?,GenBetaUpdates = ?,SubOfflineMode =?, SubSaveCredentials =?, SubLicense =?, SubPassword =?, SubUsername =?, EbayLastUpdate =?, PaypalLastUpdate=?,PaypalAutoLink =?, PaypalDomesticAddon =?, PaypalDomesticFee =?, PaypalInternationalAddon =?, PaypalInternationalFee =?, StampsSaveCredentials =?, StampsSignatureConfirm =?, StampsAddress =?, StampsCity =?, StampsCountry =?, StampsFullName =?, StampsImageLocation =?, StampsPassword =?, StampsPhoneNumber =?, StampsPostalCode =?, StampsState =?,StampsUsername=?,StampsLabelStatus=?,StampsPrintLabels=?,StampsPurchaseLabels=?,StampsSaveLabels=?,StampsTracking=?,StampsPrintOptions=?,StampsPageOptions=?,StampsHideNotification=?,StampsStorageDays=?,StampsDateNotification=?,StampsPackedWeight=?,StampsAutoPurchase=?,StampsAutoPurchaseLimit=?,StampsAutoPurchaseWarning=?,StampsPurchaseDateNotification=?,StampsComments=?,StampsMixedInventoryNotification=?,StampsNIAFilter=?,StampsInvalidPackageNotification=?, StampsAccount=?, StampsEndiciaUsername=?, StampsEndiciaPassword=?,StampsCommercialPlus=?,CompanyDefaultCompany=?, StampsUPSUsername=?, StampsUPSPassword=?, StampsUPSAccessKey=?, StampsUPSAccountNumber=?, StampsInternationalWarning=?,StampsDiscoWarning=?,StampsOOSWarning=?,StampsInternationalWarningPrice=? WHERE GenProfile= ? ";
                        PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"updateAccountPreferences1");
                        int itemCounter = 1;
                        stmt.setBoolean(itemCounter++, preferences.isGenNegativeNotification());
                        stmt.setBoolean(itemCounter++, preferences.isGenRefreshBehavior());
                        stmt.setInt(itemCounter++, preferences.getGenSalesPeriod());
                        stmt.setInt(itemCounter++, preferences.getGenStockNotification());
                        stmt.setBoolean(itemCounter++, preferences.isGenTrackingNotify());
                        stmt.setBoolean(itemCounter++, preferences.isGenUnmergeNotify());
                        stmt.setString(itemCounter++, preferences.getGenBusinessName());
                        stmt.setString(itemCounter++, preferences.getGenInvoiceComments());
                        stmt.setString(itemCounter++, preferences.getGenWebsiteAddress());
                        stmt.setInt(itemCounter++, preferences.getGenVersion());
                        stmt.setBoolean(itemCounter++, preferences.isGenSyncNotification());
                        stmt.setBoolean(itemCounter++, preferences.isGenSplitRefresh());
                        stmt.setBoolean(itemCounter++, preferences.isGenInventoryRefresh());
                        stmt.setBoolean(itemCounter++, preferences.isGenBetaUpdates());
                        stmt.setBoolean(itemCounter++, preferences.isSubOfflineMode());
                        stmt.setBoolean(itemCounter++, preferences.isSubSaveCredentials());
                        stmt.setString(itemCounter++, preferences.getSubLicense());
                        stmt.setString(itemCounter++, preferences.getSubPassword());
                        stmt.setString(itemCounter++, preferences.getSubUsername());
                        stmt.setLong(itemCounter++, preferences.getEbayLastUpdate());
                        stmt.setLong(itemCounter++, preferences.getPaypalLastUpdate());
                        stmt.setBoolean(itemCounter++, preferences.isPaypalAutoLink());
                        stmt.setDouble(itemCounter++, preferences.getPaypalDomesticAddon());
                        stmt.setDouble(itemCounter++, preferences.getPaypalDomesticFee());
                        stmt.setDouble(itemCounter++, preferences.getPaypalInternationalAddon());
                        stmt.setDouble(itemCounter++, preferences.getPaypalInternationalFee());
                        stmt.setBoolean(itemCounter++, preferences.isStampsSaveCredentials());
                        stmt.setBoolean(itemCounter++, preferences.isStampsSignatureConfirm());
                        stmt.setString(itemCounter++, preferences.getStampsAddress());
                        stmt.setString(itemCounter++, preferences.getStampsCity());
                        stmt.setString(itemCounter++, preferences.getStampsCountry());
                        stmt.setString(itemCounter++, preferences.getStampsFullName());
                        stmt.setString(itemCounter++, preferences.getStampsImageLocation());
                        stmt.setString(itemCounter++, preferences.getStampsPassword());
                        stmt.setString(itemCounter++, preferences.getStampsPhoneNumber());
                        stmt.setString(itemCounter++, preferences.getStampsPostalCode());
                        stmt.setString(itemCounter++, preferences.getStampsState());
                        stmt.setString(itemCounter++, preferences.getStampsUsername());
                        stmt.setString(itemCounter++, preferences.getStampsLabelStatus());
                        stmt.setBoolean(itemCounter++, preferences.isStampsPrintLabels());
                        stmt.setBoolean(itemCounter++, preferences.isStampsPurchaseLabels());
                        stmt.setBoolean(itemCounter++, preferences.isStampsSaveLabels());
                        stmt.setBoolean(itemCounter++, preferences.isStampsTracking());
                        stmt.setString(itemCounter++, preferences.getStampsPrintOptions());
                        stmt.setString(itemCounter++, preferences.getStampsPageOptions());
                        stmt.setBoolean(itemCounter++, preferences.isStampsHideNotification());
                        stmt.setInt(itemCounter++, preferences.getStampsStorageDays());
                        stmt.setBoolean(itemCounter++, preferences.isStampsDateNotification());
                        stmt.setBoolean(itemCounter++, preferences.isStampsPackedWeight());
                        stmt.setBoolean(itemCounter++, preferences.isStampsAutoPurchase());
                        stmt.setFloat(itemCounter++, preferences.getStampsAutoPurchaseLimit());
                        stmt.setBoolean(itemCounter++, preferences.isStampsAutoPurchaseWarning());
                        stmt.setBoolean(itemCounter++, preferences.isStampsPurchaseDateNotification());
                        stmt.setBoolean(itemCounter++, preferences.isStampsComments());
                        stmt.setBoolean(itemCounter++, preferences.isStampsMixedInventoryNotification());
                        stmt.setBoolean(itemCounter++, preferences.isStampsNIAFilter());
                        stmt.setBoolean(itemCounter++, preferences.isStampsInvalidPackageNotification());
                        stmt.setString(itemCounter++, preferences.getStampsAccount());
                        stmt.setString(itemCounter++, preferences.getStampsEndiciaUserName());
                        stmt.setString(itemCounter++, preferences.getStampsEndiciaPassword());
                        stmt.setBoolean(itemCounter++, preferences.isStampsCommercialPlus());
                        this.updatePayPalAccounts(preferences.getPaypalAccounts());
                        stmt.setString(itemCounter++, preferences.getCompanyDefaultCompany());
                        stmt.setString(itemCounter++, preferences.getStampsUPSUserName());
                        stmt.setString(itemCounter++, preferences.getStampsUPSPassword());
                        stmt.setString(itemCounter++, preferences.getStampsUPSAccessKey());
                        stmt.setString(itemCounter++, preferences.getStampsUPSAccountNumber());
                        stmt.setBoolean(itemCounter++, preferences.isStampsInternationalWarning());
                        stmt.setString(itemCounter++, preferences.getStampsDiscoWarning());
                        stmt.setString(itemCounter++, preferences.getStampsOOSWarning());
                        stmt.setFloat(itemCounter++, preferences.getStampsInternationalWarningPrice());
                        stmt.setString(itemCounter++, preferences.getGenProfile());
                        DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                        DatabaseConnector.removeObject((PreparedStatement)stmt);
                    } else {
                        sql = "INSERT INTO AccountPreferences (GenProfile , GenNegativeNotification , GenRefreshBehavior , GenSalesPeriod, GenStockNotification, GenTrackingNotify , GenUnmergeNotify , GenBusinessName , GenInvoiceComments , GenWebsiteAddress , GenVersion, GenSyncNotification, GenSplitRefresh, GenInventoryRefresh, GenBetaUpdates, SubOfflineMode , SubSaveCredentials , SubLicense , SubPassword , SubUsername , EbayLastUpdate, PaypalLastUpdate,PaypalAutoLink , PaypalDomesticAddon , PaypalDomesticFee , PaypalInternationalAddon , PaypalInternationalFee , StampsSaveCredentials , StampsSignatureConfirm , StampsAddress , StampsCity , StampsCountry , StampsFullName , StampsImageLocation , StampsPassword , StampsPhoneNumber , StampsPostalCode, StampsState ,StampsUsername,StampsLabelStatus,StampsPrintLabels,StampsPurchaseLabels ,StampsSaveLabels,StampsTracking,StampsPrintOptions,StampsPageOptions,StampsHideNotification,StampsStorageDays,StampsDateNotification,StampsPackedWeight,StampsAutoPurchase,StampsAutoPurchaseLimit,StampsAutoPurchaseWarning,StampsInvalidPackageNotification,StampsPurchaseDateNotification,StampsComments,StampsNIAFilter,StampsMixedInventoryNotification,StampsAccount, StampsEndiciaUsername, StampsEndiciaPassword,StampsCommercialPlus,CompanyDefaultCompany,StampsUPSUsername, StampsUPSPassword, StampsUPSAccessKey, StampsUPSAccountNumber,StampsInternationalWarning,StampsInternationalWarningPrice,StampsDiscoWarning,StampsOOSWarning)Values( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,  ?, ?, ?, ?, ?,  ?,  ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?, ?, ?,?,?)";
                        PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"updateAccountPreferences2");
                        int itemCounter = 1;
                        stmt.setString(itemCounter++, preferences.getGenProfile());
                        stmt.setBoolean(itemCounter++, preferences.isGenNegativeNotification());
                        stmt.setBoolean(itemCounter++, preferences.isGenRefreshBehavior());
                        stmt.setInt(itemCounter++, preferences.getGenSalesPeriod());
                        stmt.setInt(itemCounter++, preferences.getGenStockNotification());
                        stmt.setBoolean(itemCounter++, preferences.isGenTrackingNotify());
                        stmt.setBoolean(itemCounter++, preferences.isGenUnmergeNotify());
                        stmt.setString(itemCounter++, preferences.getGenBusinessName());
                        stmt.setString(itemCounter++, preferences.getGenInvoiceComments());
                        stmt.setString(itemCounter++, preferences.getGenWebsiteAddress());
                        stmt.setInt(itemCounter++, preferences.getGenVersion());
                        stmt.setBoolean(itemCounter++, preferences.isGenSyncNotification());
                        stmt.setBoolean(itemCounter++, preferences.isGenSplitRefresh());
                        stmt.setBoolean(itemCounter++, preferences.isGenInventoryRefresh());
                        stmt.setBoolean(itemCounter++, preferences.isGenBetaUpdates());
                        stmt.setBoolean(itemCounter++, preferences.isSubOfflineMode());
                        stmt.setBoolean(itemCounter++, preferences.isSubSaveCredentials());
                        stmt.setString(itemCounter++, preferences.getSubLicense());
                        stmt.setString(itemCounter++, preferences.getSubPassword());
                        stmt.setString(itemCounter++, preferences.getSubUsername());
                        stmt.setLong(itemCounter++, preferences.getEbayLastUpdate());
                        stmt.setLong(itemCounter++, preferences.getPaypalLastUpdate());
                        stmt.setBoolean(itemCounter++, preferences.isPaypalAutoLink());
                        stmt.setDouble(itemCounter++, preferences.getPaypalDomesticAddon());
                        stmt.setDouble(itemCounter++, preferences.getPaypalDomesticFee());
                        stmt.setDouble(itemCounter++, preferences.getPaypalInternationalAddon());
                        stmt.setDouble(itemCounter++, preferences.getPaypalInternationalFee());
                        stmt.setBoolean(itemCounter++, preferences.isStampsSaveCredentials());
                        stmt.setBoolean(itemCounter++, preferences.isStampsSignatureConfirm());
                        stmt.setString(itemCounter++, preferences.getStampsAddress());
                        stmt.setString(itemCounter++, preferences.getStampsCity());
                        stmt.setString(itemCounter++, preferences.getStampsCountry());
                        stmt.setString(itemCounter++, preferences.getStampsFullName());
                        stmt.setString(itemCounter++, preferences.getStampsImageLocation());
                        stmt.setString(itemCounter++, preferences.getStampsPassword());
                        stmt.setString(itemCounter++, preferences.getStampsPhoneNumber());
                        stmt.setString(itemCounter++, preferences.getStampsPostalCode());
                        stmt.setString(itemCounter++, preferences.getStampsState());
                        stmt.setString(itemCounter++, preferences.getStampsUsername());
                        stmt.setString(itemCounter++, preferences.getStampsLabelStatus());
                        stmt.setBoolean(itemCounter++, preferences.isStampsPrintLabels());
                        stmt.setBoolean(itemCounter++, preferences.isStampsPurchaseLabels());
                        stmt.setBoolean(itemCounter++, preferences.isStampsSaveLabels());
                        stmt.setBoolean(itemCounter++, preferences.isStampsTracking());
                        stmt.setString(itemCounter++, preferences.getStampsPrintOptions());
                        stmt.setString(itemCounter++, preferences.getStampsPageOptions());
                        stmt.setBoolean(itemCounter++, preferences.isStampsHideNotification());
                        stmt.setInt(itemCounter++, preferences.getStampsStorageDays());
                        stmt.setBoolean(itemCounter++, preferences.isStampsDateNotification());
                        stmt.setBoolean(itemCounter++, preferences.isStampsPackedWeight());
                        stmt.setBoolean(itemCounter++, preferences.isStampsAutoPurchase());
                        stmt.setFloat(itemCounter++, preferences.getStampsAutoPurchaseLimit());
                        stmt.setBoolean(itemCounter++, preferences.isStampsAutoPurchaseWarning());
                        stmt.setBoolean(itemCounter++, preferences.isStampsInvalidPackageNotification());
                        stmt.setBoolean(itemCounter++, preferences.isStampsPurchaseDateNotification());
                        stmt.setBoolean(itemCounter++, preferences.isStampsComments());
                        stmt.setBoolean(itemCounter++, preferences.isStampsMixedInventoryNotification());
                        stmt.setBoolean(itemCounter++, preferences.isStampsNIAFilter());
                        stmt.setString(itemCounter++, preferences.getStampsAccount());
                        stmt.setString(itemCounter++, preferences.getStampsEndiciaUserName());
                        stmt.setString(itemCounter++, preferences.getStampsEndiciaPassword());
                        stmt.setBoolean(itemCounter++, preferences.isStampsCommercialPlus());
                        this.updatePayPalAccounts(preferences.getPaypalAccounts());
                        stmt.setString(itemCounter++, preferences.getCompanyDefaultCompany());
                        stmt.setString(itemCounter++, preferences.getStampsUPSUserName());
                        stmt.setString(itemCounter++, preferences.getStampsUPSPassword());
                        stmt.setString(itemCounter++, preferences.getStampsUPSAccessKey());
                        stmt.setString(itemCounter++, preferences.getStampsUPSAccountNumber());
                        stmt.setBoolean(itemCounter++, preferences.isStampsInternationalWarning());
                        stmt.setFloat(itemCounter++, preferences.getStampsInternationalWarningPrice());
                        stmt.setString(itemCounter++, preferences.getStampsDiscoWarning());
                        stmt.setString(itemCounter++, preferences.getStampsOOSWarning());
                        DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                        DatabaseConnector.removeObject((PreparedStatement)stmt);
                    }
                    DatabaseConnector.removeObject((ResultSet)rs);
                    DatabaseConnector.removeObject((Statement)queryStmt);
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet searchPrintDetails(String searchString) {
        ResultSet rs = null;
        Object object = this._lock;
        synchronized (object) {
            try {
                if (null != searchString && !searchString.trim().equals("")) {
                    String firstString = "9999ZZZZZZ99999XXZCXCzxc";
                    String secondString = "9999ZZZZZZ99999XXZCXCzxc";
                    if (searchString.contains(" ")) {
                        firstString = searchString.split(" ")[0].trim().toUpperCase();
                        secondString = searchString.split(" ")[1].trim().toUpperCase();
                    }
                    searchString = "%" + searchString.toUpperCase() + "%";
                    String sql = "SELECT * FROM PrintDetails WHERE ((UPPER(FirstName) Like ? And UPPER(LastName) Like ?) OR (UPPER(LastName) Like ? And UPPER(FirstName) Like ?) OR UPPER(OrderID) LIKE ? OR UPPER(Customer) LIKE ? OR UPPER(Email) LIKE ? OR UPPER(FirstName) LIKE ? OR UPPER(LastName) LIKE ? OR UPPER(CountryCode) LIKE ? OR UPPER(Street1) LIKE ? OR UPPER(Street2) LIKE ? OR UPPER(City) LIKE ? OR UPPER(State) LIKE ? OR UPPER(PostalCode) LIKE ? OR UPPER(Tracking) LIKE ? )";
                    PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"searchPrintDetails");
                    int counter = 0;
                    stmt.setString(++counter, firstString);
                    stmt.setString(++counter, secondString);
                    stmt.setString(++counter, firstString);
                    stmt.setString(++counter, secondString);
                    stmt.setString(++counter, searchString);
                    stmt.setString(++counter, searchString);
                    stmt.setString(++counter, searchString);
                    stmt.setString(++counter, searchString);
                    stmt.setString(++counter, searchString);
                    stmt.setString(++counter, searchString);
                    stmt.setString(++counter, searchString);
                    stmt.setString(++counter, searchString);
                    stmt.setString(++counter, searchString);
                    stmt.setString(++counter, searchString);
                    stmt.setString(++counter, searchString);
                    stmt.setString(++counter, searchString);
                    rs = DatabaseConnector.createPreparedStatementResultSet((PreparedStatement)stmt, (String)"searchPrintDetails1");
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return rs;
    }

    public ResultSet getPrintDetails() {
        ResultSet rs = null;
        try {
            Statement stmt = DatabaseConnector.createStatement((String)"getPrintDetails");
            String sql = "SELECT * FROM PrintDetails WHERE Scan = FALSE";
            rs = DatabaseConnector.createStatementResultSet((Statement)stmt, (String)sql, (String)"getPrintDetails");
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        return rs;
    }

    public ResultSet getPrintDetails(String orderID) {
        ResultSet rs = null;
        try {
            String sql = "SELECT * FROM PrintDetails WHERE OrderID = ?";
            PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"getPrintDetails");
            stmt.setString(1, orderID);
            rs = DatabaseConnector.createPreparedStatementResultSet((PreparedStatement)stmt, (String)"getPrintDetails");
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertPrintDetails(PrintDetails newDetails) {
        Object object = this._lock;
        synchronized (object) {
            try {
                Date dateEntered = null;
                String sql = "UPDATE PrintDetails SET Customer=? , Email=? , FirstName=? , LastName=? , CountryCode=? , Street1=? , Street2=? , City=? , State=? , PostalCode=? , Weight=? , ShippingType=? , PackageType=? , StampsID=? , Tracking=? , URL=? , Cost=?, Scan=?, Error=?, Canceled=?, Printed=?, LabelInstructions=?, DateEntered=?, Copies=?, ParentOrderID=?, OrderTotal=?, ShipDate=?, PackedWeight=?, IndiciumID=?, ActualErrorDetails=?, DeclaredValue=?, PrintDate=?, PrintID=?, PrintPage=?, PayPalAccount=? WHERE OrderID=? ";
                PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"insertPrintDetails");
                int itemCounter = 0;
                stmt.setString(++itemCounter, newDetails.getCustomer());
                stmt.setString(++itemCounter, newDetails.getEmail());
                stmt.setString(++itemCounter, newDetails.getFirstName());
                stmt.setString(++itemCounter, newDetails.getLastName());
                stmt.setString(++itemCounter, newDetails.getCountryCode());
                stmt.setString(++itemCounter, newDetails.getStreet1());
                stmt.setString(++itemCounter, newDetails.getStreet2());
                stmt.setString(++itemCounter, newDetails.getCity());
                stmt.setString(++itemCounter, newDetails.getState());
                stmt.setString(++itemCounter, newDetails.getPostalCode());
                stmt.setDouble(++itemCounter, newDetails.getWeight());
                stmt.setString(++itemCounter, newDetails.getShipping());
                stmt.setString(++itemCounter, newDetails.getPackageType());
                stmt.setString(++itemCounter, newDetails.getStampsID(true));
                stmt.setString(++itemCounter, newDetails.getTracking());
                stmt.setString(++itemCounter, newDetails.getUrl());
                stmt.setDouble(++itemCounter, newDetails.getCost());
                stmt.setBoolean(++itemCounter, newDetails.isScan());
                stmt.setBoolean(++itemCounter, newDetails.isError());
                stmt.setBoolean(++itemCounter, newDetails.isCanceled());
                stmt.setBoolean(++itemCounter, newDetails.isPrinted());
                stmt.setString(++itemCounter, newDetails.getLabelInstructions());
                stmt.setDate(++itemCounter, dateEntered);
                stmt.setInt(++itemCounter, newDetails.getCopies());
                stmt.setString(++itemCounter, newDetails.getParentOrderID());
                stmt.setDouble(++itemCounter, newDetails.getOrderTotal());
                if (newDetails.getShipDate() != null) {
                    Date shipDate = new Date(newDetails.getShipDate().getTime());
                    stmt.setDate(++itemCounter, shipDate);
                } else {
                    stmt.setDate(++itemCounter, null);
                }
                stmt.setDouble(++itemCounter, newDetails.getPackedWeight());
                stmt.setString(++itemCounter, newDetails.getErrorDetails());
                stmt.setString(++itemCounter, newDetails.getActualErrorDetails());
                stmt.setDouble(++itemCounter, newDetails.getDeclaredWeight());
                if (newDetails.getPrintDate() != null) {
                    Timestamp timeStampDate = new Timestamp(newDetails.getPrintDate().getTime());
                    stmt.setTimestamp(++itemCounter, timeStampDate);
                } else {
                    stmt.setTimestamp(++itemCounter, null);
                }
                stmt.setInt(++itemCounter, newDetails.getPrintID());
                stmt.setInt(++itemCounter, newDetails.getPrintPage());
                stmt.setString(++itemCounter, newDetails.getPaypalAccount());
                stmt.setString(++itemCounter, newDetails.getOrderID());
                int updateCount = DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                DatabaseConnector.removeObject((PreparedStatement)stmt);
                if (updateCount == 0) {
                    sql = "INSERT INTO PrintDetails  (OrderID, Customer, Email, FirstName, LastName, CountryCode, Street1, Street2, City, State, PostalCode, Weight, ShippingType, PackageType, IndiciumID, StampsID, Tracking, URL, Cost, Scan, Error, Canceled, Printed, LabelInstructions, DateEntered, Copies, ParentOrderID, OrderTotal, ShipDate, PackedWeight, ActualErrorDetails, DeclaredValue, PrintDate, PrintID, PrintPage, PayPalAccount) Values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                    stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"insertPrintDetails");
                    itemCounter = 0;
                    stmt.setString(++itemCounter, newDetails.getOrderID());
                    stmt.setString(++itemCounter, newDetails.getCustomer());
                    stmt.setString(++itemCounter, newDetails.getEmail());
                    stmt.setString(++itemCounter, newDetails.getFirstName());
                    stmt.setString(++itemCounter, newDetails.getLastName());
                    stmt.setString(++itemCounter, newDetails.getCountryCode());
                    stmt.setString(++itemCounter, newDetails.getStreet1());
                    stmt.setString(++itemCounter, newDetails.getStreet2());
                    stmt.setString(++itemCounter, newDetails.getCity());
                    stmt.setString(++itemCounter, newDetails.getState());
                    stmt.setString(++itemCounter, newDetails.getPostalCode());
                    stmt.setDouble(++itemCounter, newDetails.getWeight());
                    stmt.setString(++itemCounter, newDetails.getShipping());
                    stmt.setString(++itemCounter, newDetails.getPackageType());
                    stmt.setString(++itemCounter, newDetails.getErrorDetails());
                    stmt.setString(++itemCounter, newDetails.getStampsID(true));
                    stmt.setString(++itemCounter, newDetails.getTracking());
                    stmt.setString(++itemCounter, newDetails.getUrl());
                    stmt.setDouble(++itemCounter, newDetails.getCost());
                    stmt.setBoolean(++itemCounter, newDetails.isScan());
                    stmt.setBoolean(++itemCounter, newDetails.isError());
                    stmt.setBoolean(++itemCounter, newDetails.isCanceled());
                    stmt.setBoolean(++itemCounter, newDetails.isPrinted());
                    stmt.setString(++itemCounter, newDetails.getLabelInstructions());
                    dateEntered = new Date(newDetails.getDateEntered().getTime());
                    stmt.setDate(++itemCounter, dateEntered);
                    stmt.setInt(++itemCounter, newDetails.getCopies());
                    stmt.setString(++itemCounter, newDetails.getParentOrderID());
                    stmt.setDouble(++itemCounter, newDetails.getOrderTotal());
                    if (newDetails.getShipDate() != null) {
                        Date shipDate = new Date(newDetails.getShipDate().getTime());
                        stmt.setDate(++itemCounter, shipDate);
                    } else {
                        stmt.setDate(++itemCounter, null);
                    }
                    stmt.setDouble(++itemCounter, newDetails.getPackedWeight());
                    stmt.setString(++itemCounter, newDetails.getActualErrorDetails());
                    stmt.setDouble(++itemCounter, newDetails.getDeclaredWeight());
                    if (newDetails.getPrintDate() != null) {
                        Timestamp timeStampDate = new Timestamp(newDetails.getPrintDate().getTime());
                        stmt.setTimestamp(++itemCounter, timeStampDate);
                    } else {
                        stmt.setTimestamp(++itemCounter, null);
                    }
                    stmt.setInt(++itemCounter, newDetails.getPrintID());
                    stmt.setInt(++itemCounter, newDetails.getPrintPage());
                    stmt.setString(++itemCounter, newDetails.getPaypalAccount());
                    DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                    DatabaseConnector.removeObject((PreparedStatement)stmt);
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
    }

    public void deletePrintDetails(String orderID) {
        try {
            Statement stmt = DatabaseConnector.createStatement((String)"deletePrintDetails");
            String sql = "DELETE FROM PrintDetails WHERE OrderID='" + orderID + "'";
            DatabaseConnector.executeUpdate((Statement)stmt, (String)sql);
            DatabaseConnector.removeObject((Statement)stmt);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet searchPaypalOrders(String searchString) {
        ResultSet rs = null;
        Object object = this._lock;
        synchronized (object) {
            block12: {
                try {
                    if (null == searchString || searchString.trim().equals("")) break block12;
                    String exactMatch = searchString;
                    String firstString = "";
                    String secondString = "";
                    String addOn = ")";
                    boolean isFloatable = false;
                    searchString = "%" + searchString.toUpperCase().trim() + "%";
                    if (searchString.contains(" ")) {
                        firstString = searchString.split(" ")[0];
                        secondString = searchString.split(" ")[1];
                    } else {
                        firstString = "9999ZZZZZZ99999XXZCXCzxc";
                        secondString = "9999ZZZZZZ99999XXZCXCzxc";
                    }
                    try {
                        if (exactMatch.length() >= 11) {
                            isFloatable = false;
                        } else {
                            Float.parseFloat(exactMatch);
                            addOn = "OR ROUND(GrossAmount, 2) LIKE ? OR ROUND(Tax, 2) LIKE ? OR ROUND(Cost, 2) LIKE ? OR ROUND(Quantity, 2) LIKE ? OR ROUND(ShippingAmount, 2) LIKE ? )";
                            isFloatable = true;
                        }
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    String sql = "SELECT * FROM PaypalTransactions LEFT JOIN EbayTransactions ON PaypalTransactions.PaypalTransactionID = EbayTransactions.PaypalTransactionID WHERE(UPPER(PaypalTransactions.PaypalTransactionID) LIKE ? OR UPPER(EmailAddress) LIKE ? OR (UPPER(FirstName) Like ? And UPPER(LastName) Like ?) OR (UPPER(LastName) Like ? And UPPER(FirstName) Like ?) OR UPPER(FirstName) LIKE ? OR UPPER(LastName) LIKE ? OR UPPER(CountryCode) LIKE ? OR UPPER(CountryName) LIKE ? OR UPPER(Street1) LIKE ? OR UPPER(Street2) LIKE ? OR UPPER(CityName) LIKE ? OR UPPER(StateOrProvince) LIKE ? OR UPPER(PostalCode) LIKE ? OR UPPER(TransactionType) LIKE ? OR UPPER(PaymentType) LIKE ? OR UPPER(PaymentDate) LIKE ? OR UPPER(PaymentStatus) LIKE ? OR UPPER(ShippingMethod) LIKE ? OR UPPER(Custom) LIKE ? OR UPPER(Memo) LIKE ? OR UPPER(BuyerID) LIKE ? OR UPPER(ClosingDate) LIKE ? OR UPPER(MultiItem) LIKE ? OR UPPER(EbayTransactionID) LIKE ? OR UPPER(AuctionName) LIKE ? OR UPPER(ReferenceNumber) LIKE ? OR UPPER(CurrencyCode) LIKE ? OR UPPER(PayPalAccount) LIKE ?";
                    sql = sql + addOn;
                    sql = sql + "ORDER BY PaymentDate DESC ";
                    PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"searchPaypalOrders");
                    int counter = 0;
                    stmt.setString(++counter, searchString);
                    stmt.setString(++counter, searchString);
                    stmt.setString(++counter, firstString);
                    stmt.setString(++counter, secondString);
                    stmt.setString(++counter, firstString);
                    stmt.setString(++counter, secondString);
                    stmt.setString(++counter, searchString);
                    stmt.setString(++counter, searchString);
                    stmt.setString(++counter, searchString);
                    stmt.setString(++counter, searchString);
                    stmt.setString(++counter, searchString);
                    stmt.setString(++counter, searchString);
                    stmt.setString(++counter, searchString);
                    stmt.setString(++counter, searchString);
                    stmt.setString(++counter, searchString);
                    stmt.setString(++counter, searchString);
                    stmt.setString(++counter, searchString);
                    stmt.setString(++counter, searchString);
                    stmt.setString(++counter, searchString);
                    stmt.setString(++counter, searchString);
                    stmt.setString(++counter, searchString);
                    stmt.setString(++counter, searchString);
                    stmt.setString(++counter, searchString);
                    stmt.setString(++counter, searchString);
                    stmt.setString(++counter, searchString);
                    stmt.setString(++counter, searchString);
                    stmt.setString(++counter, searchString);
                    stmt.setString(++counter, searchString);
                    stmt.setString(++counter, searchString);
                    if (isFloatable) {
                        stmt.setString(++counter, exactMatch);
                        stmt.setString(++counter, exactMatch);
                        stmt.setString(++counter, exactMatch);
                        stmt.setString(++counter, exactMatch);
                        stmt.setString(++counter, exactMatch);
                    }
                    stmt.setString(++counter, searchString);
                    rs = DatabaseConnector.createPreparedStatementResultSet((PreparedStatement)stmt, (String)"searchPaypalOrders");
                }
                catch (Exception ex) {
                    ErrorsUtil.getInstance().logError(ex);
                }
            }
        }
        return rs;
    }

    public void deletePaypalTransaction(String transactionID) {
        try {
            Statement stmt = DatabaseConnector.createStatement((String)"deletePaypalTransaction");
            String sql = "DELETE FROM EbayTransactions WHERE PaypalTransactionID='" + transactionID + "'";
            DatabaseConnector.executeUpdate((Statement)stmt, (String)sql);
            sql = "DELETE FROM PaypalTransactions WHERE PaypalTransactionID='" + transactionID + "'";
            DatabaseConnector.executeUpdate((Statement)stmt, (String)sql);
            DatabaseConnector.removeObject((Statement)stmt);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    public List<EbayTransactions> getEbayTransactions(String transactionID) {
        ArrayList<EbayTransactions> newTransactions = new ArrayList<EbayTransactions>();
        try {
            Statement stmt = DatabaseConnector.createStatement((String)"getEbayTransactions");
            String sql = "SELECT * FROM EbayTransactions WHERE PaypalTransactionID='" + transactionID + "'";
            ResultSet rs = DatabaseConnector.createStatementResultSet((Statement)stmt, (String)sql, (String)"getEbayTransactions");
            while (null != rs && rs.next()) {
                newTransactions.add(new EbayTransactions(rs.getString("EbayTransactionID"), rs.getString("AuctionName"), rs.getInt("Quantity"), Float.valueOf(rs.getFloat("Cost")), rs.getString("ReferenceNumber")));
            }
            DatabaseConnector.removeObject((ResultSet)rs);
            DatabaseConnector.removeObject((Statement)stmt);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        return newTransactions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<PaypalDetails> getPaypalDetails(String isLinked) {
        Object object = this._lock;
        synchronized (object) {
            ArrayList<PaypalDetails> newDetailsList = new ArrayList<PaypalDetails>();
            try {
                Statement stmt = DatabaseConnector.createStatement((String)"getPaypalDetails");
                String linkedStatement = isLinked.equalsIgnoreCase("unlinked") ? "WHERE Linked = FALSE" : (isLinked.equalsIgnoreCase("linked") ? "WHERE Linked = TRUE" : "");
                String sql = "SELECT * FROM PaypalTransactions " + linkedStatement + " ORDER BY PaymentDate DESC ";
                ResultSet rs = DatabaseConnector.createStatementResultSet((Statement)stmt, (String)sql, (String)"getPaypalDetails");
                while (null != rs && rs.next()) {
                    PaypalDetails newDetails = new PaypalDetails();
                    newDetails.setPaypalTransactionID(rs.getString("PaypalTransactionID"));
                    newDetails.setEmail(rs.getString("EmailAddress"));
                    newDetails.setFirstName(rs.getString("FirstName"));
                    newDetails.setLastName(rs.getString("LastName"));
                    newDetails.setCountryCode(rs.getString("CountryCode"));
                    newDetails.setCountryName(rs.getString("CountryName"));
                    newDetails.setStreet1(rs.getString("Street1"));
                    newDetails.setStreet2(rs.getString("Street2"));
                    newDetails.setCityName(rs.getString("CityName"));
                    newDetails.setStateOrProvince(rs.getString("StateOrProvince"));
                    newDetails.setPostalCode(rs.getString("PostalCode"));
                    newDetails.setTransactionType(rs.getString("TransactionType"));
                    newDetails.setPaymentType(rs.getString("PaymentType"));
                    newDetails.setPaymentDate(rs.getString("PaymentDate"));
                    newDetails.setGrossAmount(Float.valueOf(rs.getFloat("GrossAmount")));
                    newDetails.setPaymentStatus(rs.getString("PaymentStatus"));
                    newDetails.setShippingMethod(rs.getString("ShippingMethod"));
                    newDetails.setCustom(rs.getString("Custom"));
                    try {
                        newDetails.setMemo(rs.getString("Memo"));
                    }
                    catch (Exception ex) {
                        ErrorsUtil.getInstance().logError(ex, false);
                    }
                    newDetails.setBuyerID(rs.getString("BuyerID"));
                    newDetails.setClosingDate(rs.getString("ClosingDate"));
                    newDetails.setMultiItem(rs.getString("MultiItem"));
                    newDetails.setLinked(rs.getBoolean("Linked"));
                    newDetails.setTax(Float.valueOf(rs.getFloat("Tax")));
                    newDetails.setCurrencyCode(rs.getString("CurrencyCode"));
                    newDetails.setShippingAmount(Float.valueOf(rs.getFloat("ShippingAmount")));
                    newDetails.setPaypalAccount(rs.getString("PayPalAccount"));
                    sql = "SELECT * FROM EbayTransactions WHERE PaypalTransactionID='" + newDetails.getPaypalTransactionID() + "'";
                    ResultSet rs1 = DatabaseConnector.createStatementResultSet((Statement)DatabaseConnector.createStatement((String)"getPaypalDetails2"), (String)sql, (String)"getPaypalDetails");
                    ArrayList<EbayTransactions> newTransactions = new ArrayList<EbayTransactions>();
                    while (null != rs1 && rs1.next()) {
                        newTransactions.add(new EbayTransactions(rs1.getString("EbayTransactionID"), rs1.getString("AuctionName"), rs1.getInt("Quantity"), Float.valueOf(rs1.getFloat("Cost")), rs1.getString("ReferenceNumber")));
                    }
                    DatabaseConnector.removeObject((ResultSet)rs1);
                    newDetails.setEbayItems(newTransactions);
                    newDetailsList.add(newDetails);
                }
                DatabaseConnector.removeObject((ResultSet)rs);
                DatabaseConnector.removeObject((Statement)stmt);
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
            return newDetailsList;
        }
    }

    public void setPaypalLinked(PaypalDetails newDetails) {
        try {
            String sql = "UPDATE PaypalTransactions SET Linked = ? WHERE PaypalTransactionID = ? ";
            PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"setPaypalLinked");
            stmt.setBoolean(1, newDetails.isLinked());
            stmt.setString(2, newDetails.getPaypalTransactionID());
            DatabaseConnector.executeUpdate((PreparedStatement)stmt);
            DatabaseConnector.removeObject((PreparedStatement)stmt);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    private void updatePaypalDetails(PaypalDetails newDetails) {
        try {
            String sql = "UPDATE PaypalTransactions SET EmailAddress=? ,FirstName=? ,LastName=? ,CountryCode=? ,CountryName=? ,Street1=? ,Street2=? ,CityName=? ,StateOrProvince=? ,PostalCode=? ,TransactionType=? ,PaymentType=? ,PaymentDate=? ,GrossAmount=? ,PaymentStatus=? ,ShippingMethod=? ,Custom=? ,Memo=? ,BuyerID=? ,ClosingDate=? ,MultiItem=? ,Tax=? ,CurrencyCode=? ,ShippingAmount=? ,PayPalAccount=?  WHERE PaypalTransactionID = ? ";
            PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"setPaypalDetails");
            int number = 0;
            stmt.setString(++number, newDetails.getEmail());
            stmt.setString(++number, newDetails.getFirstName());
            stmt.setString(++number, newDetails.getLastName());
            stmt.setString(++number, newDetails.getCountryCode());
            stmt.setString(++number, newDetails.getCountryName());
            stmt.setString(++number, newDetails.getStreet1());
            stmt.setString(++number, newDetails.getStreet2());
            stmt.setString(++number, newDetails.getCityName());
            stmt.setString(++number, newDetails.getStateOrProvince());
            stmt.setString(++number, newDetails.getPostalCode());
            stmt.setString(++number, newDetails.getTransactionType());
            stmt.setString(++number, newDetails.getPaymentType());
            stmt.setString(++number, newDetails.getPaymentDate());
            stmt.setFloat(++number, newDetails.getGrossAmount().floatValue());
            stmt.setString(++number, newDetails.getPaymentStatus());
            stmt.setString(++number, newDetails.getShippingMethod());
            stmt.setString(++number, newDetails.getCustom());
            stmt.setString(++number, newDetails.getMemo());
            stmt.setString(++number, newDetails.getBuyerID());
            stmt.setString(++number, newDetails.getClosingDate());
            stmt.setString(++number, newDetails.getMultiItem());
            stmt.setFloat(++number, newDetails.getTax().floatValue());
            stmt.setString(++number, newDetails.getCurrencyCode());
            stmt.setFloat(++number, newDetails.getShippingAmount().floatValue());
            stmt.setString(++number, newDetails.getPaypalAccount());
            stmt.setString(++number, newDetails.getPaypalTransactionID());
            int updateCount = DatabaseConnector.executeUpdate((PreparedStatement)stmt);
            DatabaseConnector.removeObject((PreparedStatement)stmt);
            if (updateCount == 0) {
                sql = "INSERT INTO PaypalTransactions  (PaypalTransactionID, EmailAddress, FirstName, LastName, CountryCode, CountryName, Street1, Street2, CityName, StateOrProvince, PostalCode, TransactionType, PaymentType, PaymentDate, GrossAmount, PaymentStatus, ShippingMethod, Custom, Memo, BuyerID, ClosingDate, MultiItem, Linked, Tax, CurrencyCode, ShippingAmount, PayPalAccount) Values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"setPaypalDetails");
                number = 0;
                stmt.setString(++number, newDetails.getPaypalTransactionID());
                stmt.setString(++number, newDetails.getEmail());
                stmt.setString(++number, newDetails.getFirstName());
                stmt.setString(++number, newDetails.getLastName());
                stmt.setString(++number, newDetails.getCountryCode());
                stmt.setString(++number, newDetails.getCountryName());
                stmt.setString(++number, newDetails.getStreet1());
                stmt.setString(++number, newDetails.getStreet2());
                stmt.setString(++number, newDetails.getCityName());
                stmt.setString(++number, newDetails.getStateOrProvince());
                stmt.setString(++number, newDetails.getPostalCode());
                stmt.setString(++number, newDetails.getTransactionType());
                stmt.setString(++number, newDetails.getPaymentType());
                stmt.setString(++number, newDetails.getPaymentDate());
                stmt.setFloat(++number, newDetails.getGrossAmount().floatValue());
                stmt.setString(++number, newDetails.getPaymentStatus());
                stmt.setString(++number, newDetails.getShippingMethod());
                stmt.setString(++number, newDetails.getCustom());
                stmt.setString(++number, newDetails.getMemo());
                stmt.setString(++number, newDetails.getBuyerID());
                stmt.setString(++number, newDetails.getClosingDate());
                stmt.setString(++number, newDetails.getMultiItem());
                stmt.setBoolean(++number, newDetails.isLinked());
                stmt.setFloat(++number, newDetails.getTax().floatValue());
                stmt.setString(++number, newDetails.getCurrencyCode());
                stmt.setFloat(++number, newDetails.getShippingAmount().floatValue());
                stmt.setString(++number, newDetails.getPaypalAccount());
                DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                DatabaseConnector.removeObject((PreparedStatement)stmt);
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    private void updateEbayTransactions(PaypalDetails newDetails) {
        if (newDetails.getEbayItems() != null) {
            for (EbayTransactions newTransaction : newDetails.getEbayItems()) {
                try {
                    String sql = "UPDATE EbayTransactions SET PaypalTransactionID=?, AuctionName=?, Quantity=?, Cost=?, ReferenceNumber=? WHERE EbayTransactionID=?";
                    PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"setPaypalDetails");
                    int itemCounter = 1;
                    stmt.setString(itemCounter++, newDetails.getPaypalTransactionID());
                    stmt.setString(itemCounter++, newTransaction.getAuctionName());
                    stmt.setInt(itemCounter++, newTransaction.getQuantity());
                    stmt.setFloat(itemCounter++, newTransaction.getCost().floatValue());
                    stmt.setString(itemCounter++, newTransaction.getReferenceNumber());
                    stmt.setString(itemCounter++, newTransaction.getEbayTransactionID());
                    int updateCount = DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                    DatabaseConnector.removeObject((PreparedStatement)stmt);
                    if (updateCount != 0) continue;
                    sql = "INSERT INTO EbayTransactions (EbayTransactionID, PaypalTransactionID, AuctionName, Quantity, Cost, ReferenceNumber) Values (?, ?, ?, ?, ?, ?)";
                    stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"setPaypalDetails");
                    itemCounter = 1;
                    stmt.setString(itemCounter++, newTransaction.getEbayTransactionID());
                    stmt.setString(itemCounter++, newDetails.getPaypalTransactionID());
                    stmt.setString(itemCounter++, newTransaction.getAuctionName());
                    stmt.setInt(itemCounter++, newTransaction.getQuantity());
                    stmt.setFloat(itemCounter++, newTransaction.getCost().floatValue());
                    stmt.setString(itemCounter++, newTransaction.getReferenceNumber());
                    DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                    DatabaseConnector.removeObject((PreparedStatement)stmt);
                }
                catch (Exception ex) {
                    ErrorsUtil.getInstance().logError(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPaypalDetails(PaypalDetails newDetails) {
        Object object = this._lock;
        synchronized (object) {
            this.updatePaypalDetails(newDetails);
            this.updateEbayTransactions(newDetails);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getInventoryList() {
        ResultSet rs = null;
        Object object = this._lock;
        synchronized (object) {
            try {
                Statement stmt = DatabaseConnector.createStatement((String)"getInventoryList");
                String sql = "SELECT * FROM Inventory";
                rs = DatabaseConnector.createStatementResultSet((Statement)stmt, (String)sql, (String)"getInventoryList");
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getInventoryList(String searchString, boolean instock, boolean oos, boolean inhouse, boolean discontinued, String[] distributorsFilter, boolean fullText) {
        ResultSet rs = null;
        Object object = this._lock;
        synchronized (object) {
            if (searchString == null && (null == distributorsFilter || distributorsFilter.length == 0)) {
                return null;
            }
            try {
                String sql = null == distributorsFilter || distributorsFilter.length == 0 ? "SELECT * FROM Inventory INNER JOIN Items ON Inventory.ItemID = Items.ItemID " : "SELECT * FROM Inventory INNER JOIN Items ON Inventory.ItemID = Items.ItemID INNER JOIN Distributors ON Distributors.DistributorID = Items.DistributorID ";
                if (null != searchString && !searchString.trim().equals("")) {
                    int i;
                    searchString = fullText ? "%" + searchString.toUpperCase() + "%" : searchString.toUpperCase() + "%";
                    String unionSql = "";
                    unionSql = this.createInventoryUnionAll(sql, unionSql, "ItemID", instock, oos, inhouse, discontinued, distributorsFilter);
                    unionSql = this.createInventoryUnionAll(sql, unionSql, "ItemName", instock, oos, inhouse, discontinued, distributorsFilter);
                    unionSql = this.createInventoryUnionAll(sql, unionSql, "ItemDescription", instock, oos, inhouse, discontinued, distributorsFilter);
                    unionSql = this.createInventoryUnionAll(sql, unionSql, "Location", instock, oos, inhouse, discontinued, distributorsFilter);
                    unionSql = this.createInventoryUnion(sql, unionSql, "DistributorProductID", instock, oos, inhouse, discontinued, distributorsFilter);
                    PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)unionSql, (String)"getInventoryList");
                    int counter = 1;
                    stmt.setString(counter++, searchString);
                    if (null != distributorsFilter) {
                        for (i = 0; i < distributorsFilter.length; ++i) {
                            stmt.setString(counter++, distributorsFilter[i]);
                        }
                    }
                    stmt.setString(counter++, searchString);
                    if (null != distributorsFilter) {
                        for (i = 0; i < distributorsFilter.length; ++i) {
                            stmt.setString(counter++, distributorsFilter[i]);
                        }
                    }
                    stmt.setString(counter++, searchString);
                    if (null != distributorsFilter) {
                        for (i = 0; i < distributorsFilter.length; ++i) {
                            stmt.setString(counter++, distributorsFilter[i]);
                        }
                    }
                    stmt.setString(counter++, searchString);
                    if (null != distributorsFilter) {
                        for (i = 0; i < distributorsFilter.length; ++i) {
                            stmt.setString(counter++, distributorsFilter[i]);
                        }
                    }
                    stmt.setString(counter++, searchString);
                    if (null != distributorsFilter) {
                        for (i = 0; i < distributorsFilter.length; ++i) {
                            stmt.setString(counter++, distributorsFilter[i]);
                        }
                    }
                    rs = DatabaseConnector.createPreparedStatementResultSet((PreparedStatement)stmt, (String)"getInventoryList");
                } else {
                    int i;
                    if (instock) {
                        sql = sql + "WHERE Inventory.ItemQuantity > 0 ";
                        if (inhouse) {
                            sql = sql + "AND Items.DropShipped = FALSE ";
                        }
                        if (discontinued) {
                            sql = sql + "AND Items.Discontinued = FALSE ";
                        }
                        if (null != distributorsFilter && distributorsFilter.length > 0) {
                            sql = sql + "AND (Distributors.DistributorName Like ? ";
                            for (i = 1; i < distributorsFilter.length; ++i) {
                                sql = sql + "OR Distributors.DistributorName Like ? ";
                            }
                            sql = sql + ") ";
                        }
                    } else if (oos) {
                        sql = sql + "WHERE Inventory.ItemQuantity <= 0 ";
                        if (inhouse) {
                            sql = sql + "AND Items.DropShipped = FALSE ";
                        }
                        if (null != distributorsFilter && distributorsFilter.length > 0) {
                            sql = sql + "AND (Distributors.DistributorName Like ? ";
                            for (i = 1; i < distributorsFilter.length; ++i) {
                                sql = sql + "OR Distributors.DistributorName Like ? ";
                            }
                            sql = sql + ") ";
                        }
                    } else if (inhouse) {
                        sql = sql + "Where Items.DropShipped = FALSE ";
                        if (discontinued) {
                            sql = sql + "AND Items.Discontinued = FALSE ";
                        }
                        if (null != distributorsFilter && distributorsFilter.length > 0) {
                            sql = sql + "AND (Distributors.DistributorName Like ? ";
                            for (i = 1; i < distributorsFilter.length; ++i) {
                                sql = sql + "OR Distributors.DistributorName Like ? ";
                            }
                            sql = sql + ") ";
                        }
                    } else if (discontinued) {
                        sql = sql + "Where Items.Discontinued = FALSE ";
                        if (null != distributorsFilter && distributorsFilter.length > 0) {
                            sql = sql + "AND (Distributors.DistributorName Like ? ";
                            for (i = 1; i < distributorsFilter.length; ++i) {
                                sql = sql + "OR Distributors.DistributorName Like ? ";
                            }
                            sql = sql + ") ";
                        }
                    } else if (null != distributorsFilter && distributorsFilter.length > 0) {
                        sql = sql + "Where (Distributors.DistributorName Like ? ";
                        for (i = 1; i < distributorsFilter.length; ++i) {
                            sql = sql + "OR Distributors.DistributorName Like ? ";
                        }
                        sql = sql + ") ";
                    }
                    sql = sql + "ORDER BY Items.ItemID DESC ";
                    PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"getInventoryList");
                    int counter = 1;
                    if (null != distributorsFilter) {
                        for (int i2 = 0; i2 < distributorsFilter.length; ++i2) {
                            stmt.setString(counter++, "%" + distributorsFilter[i2] + "%");
                        }
                    }
                    rs = DatabaseConnector.createPreparedStatementResultSet((PreparedStatement)stmt, (String)"getInventoryList");
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return rs;
    }

    public String createInventoryUnion(String sqlPrefix, String sqlChunk, String columnName, boolean instock, boolean oos, boolean inhouse, boolean discontinued, String[] distributorsFilter) {
        sqlChunk = sqlChunk.isEmpty() ? sqlPrefix : sqlChunk + " UNION " + sqlPrefix;
        sqlChunk = sqlChunk + "WHERE (UPPER(Items." + columnName + ") LIKE ?) ";
        if (instock) {
            sqlChunk = sqlChunk + "AND Inventory.ItemQuantity > 0 ";
        } else if (oos) {
            sqlChunk = sqlChunk + "AND Inventory.ItemQuantity <= 0 ";
        }
        if (inhouse) {
            sqlChunk = sqlChunk + "AND Items.DropShipped = FALSE ";
        }
        if (discontinued) {
            sqlChunk = sqlChunk + "AND Items.Discontinued = FALSE ";
        }
        if (null != distributorsFilter && distributorsFilter.length > 0) {
            sqlChunk = sqlChunk + "AND (Distributors.DistributorName Like ? ";
            for (int i = 1; i < distributorsFilter.length; ++i) {
                sqlChunk = sqlChunk + "OR Distributors.DistributorName Like ? ";
            }
            sqlChunk = sqlChunk + ") ";
        }
        return sqlChunk;
    }

    public String createInventoryUnionAll(String sqlPrefix, String sqlChunk, String columnName, boolean instock, boolean oos, boolean inhouse, boolean discontinued, String[] distributorsFilter) {
        sqlChunk = sqlChunk.isEmpty() ? sqlPrefix : sqlChunk + " UNION ALL " + sqlPrefix;
        sqlChunk = sqlChunk + "WHERE (UPPER(Items." + columnName + ") LIKE ?) ";
        if (instock) {
            sqlChunk = sqlChunk + "AND Inventory.ItemQuantity > 0 ";
        } else if (oos) {
            sqlChunk = sqlChunk + "AND Inventory.ItemQuantity <= 0 ";
        }
        if (inhouse) {
            sqlChunk = sqlChunk + "AND Items.DropShipped = FALSE ";
        }
        if (discontinued) {
            sqlChunk = sqlChunk + "AND Items.Discontinued = FALSE ";
        }
        if (null != distributorsFilter && distributorsFilter.length > 0) {
            sqlChunk = sqlChunk + "AND (Distributors.DistributorName Like ? ";
            for (int i = 1; i < distributorsFilter.length; ++i) {
                sqlChunk = sqlChunk + "OR Distributors.DistributorName Like ? ";
            }
            sqlChunk = sqlChunk + ") ";
        }
        return sqlChunk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getWebsiteList() {
        ResultSet rs = null;
        Object object = this._lock;
        synchronized (object) {
            try {
                String sql = "SELECT * FROM WebsiteProducts";
                PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"getWebsiteList");
                rs = DatabaseConnector.createPreparedStatementResultSet((PreparedStatement)stmt, (String)"getWebsiteList");
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getWebsiteList(String searchString, boolean enabled) {
        ResultSet rs = null;
        Object object = this._lock;
        synchronized (object) {
            try {
                String sql = "SELECT * FROM WebsiteProducts INNER JOIN Items ON WebsiteProducts.ItemID = Items.ItemID ";
                if (null != searchString && !searchString.trim().equals("")) {
                    sql = sql + " WHERE ";
                    searchString = "%" + searchString.toUpperCase().trim() + "%";
                    sql = sql + "(UPPER(WebsiteProducts.ItemID) LIKE ? OR UPPER(WebsiteProducts.OEM) LIKE ? OR UPPER(WebsiteProducts.BriefDescription) LIKE ? OR UPPER(WebsiteProducts.Description) LIKE ? OR UPPER(Items.ItemName) LIKE ? OR UPPER(Items.DistributorProductID) LIKE ? OR UPPER(WebsiteProducts.Gender) LIKE ? OR UPPER(WebsiteProducts.AgeGroup) LIKE ? OR UPPER(WebsiteProducts.keywords) LIKE ?) ";
                    if (enabled) {
                        sql = sql + "AND WebsiteProducts.Enabled = ?";
                    }
                    PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"getWebsiteList");
                    stmt.setString(1, searchString);
                    stmt.setString(2, searchString);
                    stmt.setString(3, searchString);
                    stmt.setString(4, searchString);
                    stmt.setString(5, searchString);
                    stmt.setString(6, searchString);
                    stmt.setString(7, searchString);
                    if (enabled) {
                        stmt.setBoolean(8, enabled);
                    }
                    rs = DatabaseConnector.createPreparedStatementResultSet((PreparedStatement)stmt, (String)"getWebsiteList");
                } else {
                    if (enabled) {
                        sql = sql + " WHERE WebsiteProducts.Enabled=true";
                    }
                    PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"getWebsiteList");
                    rs = DatabaseConnector.createPreparedStatementResultSet((PreparedStatement)stmt, (String)"getWebsiteList");
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getOosInventory() {
        ResultSet rs = null;
        Object object = this._lock;
        synchronized (object) {
            try {
                Statement stmt = DatabaseConnector.createStatement((String)"getOosInventory");
                String sql = "SELECT * FROM Inventory where OOSItem=true";
                rs = DatabaseConnector.createStatementResultSet((Statement)stmt, (String)sql, (String)"getOosInventory");
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateInventory(ArrayList<InventoryElement> inventoryElement) {
        Object object = this._lock;
        synchronized (object) {
            try {
                for (int i = 0; i < inventoryElement.size(); ++i) {
                    PreparedStatement stmt;
                    String sql;
                    if (0 != inventoryElement.get(i).getInventoryID()) {
                        sql = "UPDATE Inventory SET ItemID= ?, ItemCost=? , ItemQuantity=? , OOSItem=? ";
                        if (null != inventoryElement.get(i).getStockDate() && !inventoryElement.get(i).getStockDate().toString().equals("")) {
                            sql = sql + ", StockDate=? ";
                        }
                        sql = sql + " WHERE InventoryID =? ";
                        stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"updateInventory");
                        stmt.setString(1, inventoryElement.get(i).getItemID());
                        stmt.setFloat(2, inventoryElement.get(i).getItemCost());
                        stmt.setInt(3, inventoryElement.get(i).getItemQuantity());
                        stmt.setBoolean(4, inventoryElement.get(i).isOosItem());
                        if (null != inventoryElement.get(i).getStockDate() && !inventoryElement.get(i).getStockDate().toString().equals("")) {
                            stmt.setDate(5, inventoryElement.get(i).getStockDate());
                            stmt.setInt(6, inventoryElement.get(i).getInventoryID());
                        } else {
                            stmt.setInt(5, inventoryElement.get(i).getInventoryID());
                        }
                        DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                        DatabaseConnector.removeObject((PreparedStatement)stmt);
                        continue;
                    }
                    sql = null != inventoryElement.get(i).getStockDate() && !inventoryElement.get(i).getStockDate().toString().equals("") ? "INSERT INTO Inventory (ItemID, ItemCost, ItemQuantity, OOSItem, StockDate) VALUES(?, ?, ?, ?, ?)" : "INSERT INTO Inventory (ItemID, ItemCost, ItemQuantity, OOSItem) VALUES(?, ?, ?, ?)";
                    stmt = DatabaseConnector.createPreparedStatement((String)sql, (int)1, (String)"updateInventory");
                    stmt.setString(1, inventoryElement.get(i).getItemID());
                    stmt.setFloat(2, inventoryElement.get(i).getItemCost());
                    stmt.setInt(3, inventoryElement.get(i).getItemQuantity());
                    stmt.setBoolean(4, inventoryElement.get(i).isOosItem());
                    if (null != inventoryElement.get(i).getStockDate() && !inventoryElement.get(i).getStockDate().toString().equals("")) {
                        stmt.setDate(5, inventoryElement.get(i).getStockDate());
                    }
                    DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                    ResultSet rs = DatabaseConnector.createGeneratedKeys((Statement)stmt, (String)"updateInventory");
                    if (null != rs && rs.next()) {
                        inventoryElement.get(i).setInventoryID(rs.getInt(1));
                        DatabaseConnector.removeObject((ResultSet)rs);
                    }
                    DatabaseConnector.removeObject((PreparedStatement)stmt);
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateInventory(InventoryElement inventoryElement) {
        Object object = this._lock;
        synchronized (object) {
            try {
                if (0 != inventoryElement.getInventoryID()) {
                    String sql = "UPDATE Inventory SET ItemID= ?, ItemCost=? , ItemQuantity=? , OOSItem=? ";
                    if (null != inventoryElement.getStockDate() && !inventoryElement.getStockDate().toString().equals("")) {
                        sql = sql + ", StockDate= ?";
                    }
                    sql = sql + " WHERE InventoryID =? ";
                    PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"updateInventory");
                    stmt.setString(1, inventoryElement.getItemID());
                    stmt.setFloat(2, inventoryElement.getItemCost());
                    stmt.setInt(3, inventoryElement.getItemQuantity());
                    stmt.setBoolean(4, inventoryElement.isOosItem());
                    if (null != inventoryElement.getStockDate() && !inventoryElement.getStockDate().toString().equals("")) {
                        stmt.setDate(5, inventoryElement.getStockDate());
                        stmt.setInt(6, inventoryElement.getInventoryID());
                    } else {
                        stmt.setInt(5, inventoryElement.getInventoryID());
                    }
                    DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                    DatabaseConnector.removeObject((PreparedStatement)stmt);
                } else {
                    String sql = null != inventoryElement.getStockDate() && !inventoryElement.getStockDate().toString().equals("") ? "INSERT INTO Inventory (ItemID, ItemCost, ItemQuantity, OOSItem, StockDate) VALUES(?, ?, ?, ?, ?)" : "INSERT INTO Inventory (ItemID, ItemCost, ItemQuantity, OOSItem) VALUES(?, ?, ?, ?)";
                    PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (int)1, (String)"updateInventory");
                    stmt.setString(1, inventoryElement.getItemID());
                    stmt.setFloat(2, inventoryElement.getItemCost());
                    stmt.setInt(3, inventoryElement.getItemQuantity());
                    stmt.setBoolean(4, inventoryElement.isOosItem());
                    if (null != inventoryElement.getStockDate() && !inventoryElement.getStockDate().toString().equals("")) {
                        stmt.setDate(5, inventoryElement.getStockDate());
                    }
                    DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                    ResultSet rs = DatabaseConnector.createGeneratedKeys((Statement)stmt, (String)"updateInventory");
                    if (null != rs && rs.next()) {
                        inventoryElement.setInventoryID(rs.getInt(1));
                        DatabaseConnector.removeObject((ResultSet)rs);
                    }
                    DatabaseConnector.removeObject((PreparedStatement)stmt);
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateWebsiteElement(WebsiteElement websiteElement) {
        Object object = this._lock;
        synchronized (object) {
            try {
                String sql = "UPDATE WebsiteProducts SET Oem= ?, Price =? , PriceRetail =? , BriefDescription =? , Description =? , Thumbnail =? , Photo1 =? , Photo2 =? , Photo3 =? , CategoryID =? , KeyWords =? , Enabled =? , Featured =? , Gender =? , AgeGroup =?  WHERE ItemID =? ";
                PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"updateWebsiteElement");
                stmt.setString(1, websiteElement.getOem());
                stmt.setFloat(2, websiteElement.getPrice());
                stmt.setFloat(3, websiteElement.getPriceRetail());
                stmt.setString(4, websiteElement.getBriefDescription());
                stmt.setString(5, websiteElement.getDescription());
                stmt.setString(6, websiteElement.getThumbnail());
                stmt.setString(7, websiteElement.getPhoto1());
                stmt.setString(8, websiteElement.getPhoto2());
                stmt.setString(9, websiteElement.getPhoto3());
                stmt.setInt(10, websiteElement.getCategoryID());
                stmt.setString(11, websiteElement.getKeywords());
                stmt.setBoolean(12, websiteElement.isEnabled());
                stmt.setBoolean(13, websiteElement.isFeatured());
                stmt.setString(14, websiteElement.getGender());
                stmt.setString(15, websiteElement.getAgeGroup());
                stmt.setString(16, websiteElement.getItemID());
                DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                if (0 == stmt.getUpdateCount()) {
                    DatabaseConnector.removeObject((PreparedStatement)stmt);
                    sql = "INSERT INTO WebsiteProducts  (ItemID, Oem, Price, PriceRetail, BriefDescription, Description, Thumbnail, Photo1, Photo2, Photo3, CategoryID,Keywords, Enabled, Featured, Gender, AgeGroup) Values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                    stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"updateWebsiteElement");
                    stmt.setString(1, websiteElement.getItemID());
                    stmt.setString(2, websiteElement.getOem());
                    stmt.setFloat(3, websiteElement.getPrice());
                    stmt.setFloat(4, websiteElement.getPriceRetail());
                    stmt.setString(5, websiteElement.getBriefDescription());
                    stmt.setString(6, websiteElement.getDescription());
                    stmt.setString(7, websiteElement.getThumbnail());
                    stmt.setString(8, websiteElement.getPhoto1());
                    stmt.setString(9, websiteElement.getPhoto2());
                    stmt.setString(10, websiteElement.getPhoto3());
                    stmt.setInt(11, websiteElement.getCategoryID());
                    stmt.setString(12, websiteElement.getKeywords());
                    stmt.setBoolean(13, websiteElement.isEnabled());
                    stmt.setBoolean(14, websiteElement.isFeatured());
                    stmt.setString(15, websiteElement.getGender());
                    stmt.setString(16, websiteElement.getAgeGroup());
                    DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                    DatabaseConnector.removeObject((PreparedStatement)stmt);
                }
                DatabaseConnector.removeObject((PreparedStatement)stmt);
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getItemList() {
        ResultSet rs = null;
        Object object = this._lock;
        synchronized (object) {
            try {
                Statement stmt = DatabaseConnector.createStatement((String)"getItemList");
                String sql = "SELECT * FROM Items";
                rs = DatabaseConnector.createStatementResultSet((Statement)stmt, (String)sql, (String)"getItemList");
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateItem(Item item) {
        Object object = this._lock;
        synchronized (object) {
            try {
                String sql = "UPDATE Items SET ItemID= ?, DistributorProductID= ?, ItemName= ? , ItemWeight= ? , ItemDescription= ? , DistributorID= ? , DropShipped= ? , Location= ? , Discontinued= ? , PackedWeight= ?  WHERE ItemID= ? ";
                PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"updateItem");
                stmt.setString(1, item.getItemID());
                if (null != item.getDistributorProductID() && !item.getDistributorProductID().equals("")) {
                    stmt.setString(2, item.getDistributorProductID());
                } else {
                    item.setDistributorProductID(item.getItemID());
                    stmt.setString(2, item.getItemID());
                }
                stmt.setString(3, item.getItemName());
                stmt.setFloat(4, item.getItemWeight());
                stmt.setString(5, item.getItemDescription());
                stmt.setInt(6, item.getDistributorID());
                stmt.setBoolean(7, item.isDropShipped());
                stmt.setString(8, item.getLocation());
                stmt.setBoolean(9, item.isDiscontinued());
                stmt.setFloat(10, item.getPackedWeight());
                stmt.setString(11, item.getItemID());
                DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                if (0 == stmt.getUpdateCount()) {
                    DatabaseConnector.removeObject((PreparedStatement)stmt);
                    sql = "INSERT INTO Items  (ItemID, DistributorProductID, ItemName, ItemWeight, ItemDescription, DistributorID, DropShipped, Location, Discontinued, PackedWeight) Values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                    stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"updateItem");
                    stmt.setString(1, item.getItemID());
                    stmt.setString(2, item.getDistributorProductID());
                    stmt.setString(3, item.getItemName());
                    stmt.setFloat(4, item.getItemWeight());
                    stmt.setString(5, item.getItemDescription());
                    stmt.setInt(6, item.getDistributorID());
                    stmt.setBoolean(7, item.isDropShipped());
                    stmt.setString(8, item.getLocation());
                    stmt.setBoolean(9, item.isDiscontinued());
                    stmt.setFloat(10, item.getPackedWeight());
                    DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                    DatabaseConnector.removeObject((PreparedStatement)stmt);
                }
                DatabaseConnector.removeObject((PreparedStatement)stmt);
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
    }

    private String createSubstring(String name, int length) {
        if (name.length() > length) {
            name = name.substring(0, length);
        }
        return name;
    }

    private void condenseStrings(Customer customer) {
        if (customer.getCustomerAddress() != null) {
            customer.setCustomerAddress(this.createSubstring(customer.getCustomerAddress(), 255));
        }
        if (customer.getCustomerCity() != null) {
            customer.setCustomerCity(this.createSubstring(customer.getCustomerCity(), 80));
        }
        if (customer.getCustomerCountry() != null) {
            customer.setCustomerCountry(this.createSubstring(customer.getCustomerCountry(), 32));
        }
        if (customer.getCustomerEmail() != null) {
            customer.setCustomerEmail(this.createSubstring(customer.getCustomerEmail(), 80));
        }
        if (customer.getCustomerName() != null) {
            customer.setCustomerName(this.createSubstring(customer.getCustomerName(), 255));
        }
        if (customer.getCustomerState() != null) {
            customer.setCustomerState(this.createSubstring(customer.getCustomerState(), 32));
        }
        if (customer.getCustomerUserName() != null) {
            customer.setCustomerUserName(this.createSubstring(customer.getCustomerUserName(), 80));
        }
        if (customer.getCustomerZipcode() != null) {
            customer.setCustomerZipcode(this.createSubstring(customer.getCustomerZipcode(), 12));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCustomer(Customer customer) {
        Object object = this._lock;
        synchronized (object) {
            try {
                this.condenseStrings(customer);
                String sql = "UPDATE Customers SET CustomerUserName= ?, CustomerEmail= ? , CustomerName= ? , CustomerCountry= ? , CustomerAddress= ? , CustomerCity= ? , CustomerState= ? , CustomerZipCode= ? , CustomerComments= ?  WHERE CustomerUserName= ? ";
                PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"updateCustomer");
                stmt.setString(1, customer.getCustomerUserName());
                stmt.setString(2, customer.getCustomerEmail());
                stmt.setString(3, customer.getCustomerName());
                stmt.setString(4, customer.getCustomerCountry());
                stmt.setString(5, customer.getCustomerAddress());
                stmt.setString(6, customer.getCustomerCity());
                stmt.setString(7, customer.getCustomerState());
                stmt.setString(8, customer.getCustomerZipcode());
                stmt.setString(9, customer.getCustomerComments());
                stmt.setString(10, customer.getCustomerUserName());
                DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                if (0 == stmt.getUpdateCount()) {
                    DatabaseConnector.removeObject((PreparedStatement)stmt);
                    sql = "INSERT INTO Customers  (CustomerUserName, CustomerEmail, CustomerName, CustomerCountry, CustomerAddress, CustomerCity, CustomerState, CustomerZipCode, CustomerComments)Values (?, ?, ?, ?, ?, ?, ?, ?, ?)";
                    stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"updateCustomer");
                    stmt.setString(1, customer.getCustomerUserName());
                    stmt.setString(2, customer.getCustomerEmail());
                    stmt.setString(3, customer.getCustomerName());
                    stmt.setString(4, customer.getCustomerCountry());
                    stmt.setString(5, customer.getCustomerAddress());
                    stmt.setString(6, customer.getCustomerCity());
                    stmt.setString(7, customer.getCustomerState());
                    stmt.setString(8, customer.getCustomerZipcode());
                    stmt.setString(9, customer.getCustomerComments());
                    DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                    DatabaseConnector.removeObject((PreparedStatement)stmt);
                }
                DatabaseConnector.removeObject((PreparedStatement)stmt);
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet searchExpenses(long searchFrom, long searchTo, ArrayList<Integer> filteredList, String searchString) {
        ResultSet rs = null;
        Object object = this._lock;
        synchronized (object) {
            try {
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(searchFrom);
                searchString = "%" + searchString.toUpperCase() + "%";
                String sql = "SELECT * FROM Expenses WHERE (UPPER(ExpenseComment) LIKE ? OR UPPER(ExpenseReason) LIKE ? OR UPPER(ExpenseID) LIKE ? OR UPPER(ExpenseReasonID) LIKE ? OR UPPER(ExpenseDate) LIKE ? OR UPPER(ExpenseCost) LIKE ?) AND ";
                sql = sql + "(ExpenseDate >= '" + formatter.format(calendar.getTime()) + "' ";
                calendar.setTimeInMillis(searchTo);
                sql = sql + "AND ExpenseDate <= '" + formatter.format(calendar.getTime()) + "' )";
                if (filteredList.size() > 0) {
                    sql = sql + "AND (ExpenseReasonID=" + filteredList.get(0);
                    for (int i = 1; i < filteredList.size(); ++i) {
                        sql = sql + " OR ExpenseReasonID=" + filteredList.get(i);
                    }
                    sql = sql + ")";
                }
                sql = sql + " ORDER BY Expenses.ExpenseDate ASC";
                PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"searchExpenses");
                stmt.setString(1, searchString);
                stmt.setString(2, searchString);
                stmt.setString(3, searchString);
                stmt.setString(4, searchString);
                stmt.setString(5, searchString);
                stmt.setString(6, searchString);
                rs = DatabaseConnector.createPreparedStatementResultSet((PreparedStatement)stmt, (String)"searchExpenses");
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getExpenses(long searchFrom, long searchTo, ArrayList<Integer> filteredList, String searchString, String companyName) {
        ResultSet rs = null;
        Object object = this._lock;
        synchronized (object) {
            try {
                if (null != searchString && !searchString.trim().equals("")) {
                    rs = this.searchExpenses(searchFrom, searchTo, filteredList, searchString);
                } else {
                    Statement stmt = DatabaseConnector.createStatement((String)"getExpenses");
                    String sql = "SELECT * FROM Expenses WHERE ";
                    SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTimeInMillis(searchFrom);
                    sql = sql + "ExpenseDate >= '" + formatter.format(calendar.getTime()) + "' ";
                    calendar.setTimeInMillis(searchTo);
                    sql = sql + "AND ExpenseDate <= '" + formatter.format(calendar.getTime()) + "' ";
                    if (filteredList.size() > 0) {
                        sql = sql + "AND (ExpenseReasonID=" + filteredList.get(0);
                        for (int i = 1; i < filteredList.size(); ++i) {
                            sql = sql + " OR ExpenseReasonID=" + filteredList.get(i);
                        }
                        sql = sql + ")";
                    }
                    if (companyName != null && !companyName.trim().isEmpty()) {
                        sql = sql + " AND CompanyName='" + companyName + "'";
                    }
                    sql = sql + " ORDER BY Expenses.ExpenseDate ASC";
                    rs = DatabaseConnector.createStatementResultSet((Statement)stmt, (String)sql, (String)"getExpenses");
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return rs;
    }

    public ResultSet getCompletedOrders(long searchFrom, long searchTo, String companyName) {
        ResultSet rs = null;
        OrderStatus[] completedStatus = new OrderStatus[]{OrderStatusList.getInstance().getCompletedOrderStatus()};
        rs = this.getOrderList(completedStatus, searchFrom, searchTo, companyName);
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateExpense(Expense expense) {
        Object object = this._lock;
        synchronized (object) {
            try {
                if (expense.getCompanyName() == null || expense.getCompanyName().trim().isEmpty()) {
                    expense.setCompanyName(Preferences.getInstance().getAccountPreferences().getCompanyDefaultCompany());
                }
                if (expense.getExpenseID() != 0) {
                    String sql = "UPDATE Expenses SET ExpenseComment= ?, ExpenseCost= ?, ExpenseDate= ?, ExpenseReason= ?, ExpenseID = ?, ExpenseReasonID = ?, CompanyName = ? WHERE ExpenseID= ?";
                    PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"updateExpense");
                    stmt.setString(1, expense.getExpenseComment());
                    stmt.setFloat(2, expense.getExpenseCost());
                    stmt.setDate(3, expense.getExpenseDate());
                    stmt.setString(4, expense.getExpenseReason());
                    stmt.setInt(5, expense.getExpenseID());
                    stmt.setInt(6, expense.getExpenseReasonID());
                    stmt.setString(7, expense.getCompanyName());
                    stmt.setInt(8, expense.getExpenseID());
                    DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                    if (0 == stmt.getUpdateCount()) {
                        DatabaseConnector.removeObject((PreparedStatement)stmt);
                        sql = "INSERT INTO Expenses  (ExpenseComment, ExpenseCost, ExpenseDate, ExpenseReason, ExpenseReasonID, CompanyName)Values (?, ?, ?, ?, ?, ?)";
                        stmt = DatabaseConnector.createPreparedStatement((String)sql, (int)1, (String)"updateExpense");
                        stmt.setString(1, expense.getExpenseComment());
                        stmt.setFloat(2, expense.getExpenseCost());
                        stmt.setDate(3, expense.getExpenseDate());
                        stmt.setString(4, expense.getExpenseReason());
                        stmt.setInt(5, expense.getExpenseReasonID());
                        stmt.setString(6, expense.getCompanyName());
                        DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                        ResultSet rs = DatabaseConnector.createGeneratedKeys((Statement)stmt, (String)"updateExpense");
                        if (null != rs && rs.next()) {
                            expense.setExpenseID(rs.getInt(1));
                            DatabaseConnector.removeObject((ResultSet)rs);
                        }
                        DatabaseConnector.removeObject((PreparedStatement)stmt);
                    }
                    DatabaseConnector.removeObject((PreparedStatement)stmt);
                } else {
                    String sql = "INSERT INTO Expenses  (ExpenseComment, ExpenseCost, ExpenseDate, ExpenseReason, ExpenseReasonID, CompanyName)Values (?, ?, ?, ?, ?, ?)";
                    PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (int)1, (String)"updateExpense");
                    stmt.setString(1, expense.getExpenseComment());
                    stmt.setFloat(2, expense.getExpenseCost());
                    stmt.setDate(3, expense.getExpenseDate());
                    stmt.setString(4, expense.getExpenseReason());
                    stmt.setInt(5, expense.getExpenseReasonID());
                    stmt.setString(6, expense.getCompanyName());
                    DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                    ResultSet rs = DatabaseConnector.createGeneratedKeys((Statement)stmt, (String)"updateExpense");
                    if (null != rs && rs.next()) {
                        expense.setExpenseID(rs.getInt(1));
                        DatabaseConnector.removeObject((ResultSet)rs);
                    }
                    DatabaseConnector.removeObject((PreparedStatement)stmt);
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return expense.getExpenseID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getOosOrderDetailsList() {
        ResultSet rs = null;
        Object object = this._lock;
        synchronized (object) {
            try {
                Statement stmt = DatabaseConnector.createStatement((String)"getOosOrderDetailsList");
                String sql = "SELECT * FROM OrderDetails WHERE Backordered=TRUE";
                rs = DatabaseConnector.createStatementResultSet((Statement)stmt, (String)sql, (String)"getOosOrderDetailsList");
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getOrderListForTrackingCheck() {
        ResultSet rs = null;
        Object object = this._lock;
        synchronized (object) {
            try {
                Statement stmt = DatabaseConnector.createStatement((String)"getOrderListForTrackingCheck");
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
                long dateRange = System.currentTimeMillis() - 2592000000L;
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(dateRange);
                String sql = "SELECT * FROM Orders INNER JOIN OrderDetails ON Orders.OrderID = OrderDetails.OrderID INNER JOIN Customers ON Orders.CustomerUserName = Customers.CustomerUserName WHERE ";
                sql = sql + "Orders.OrderStatusID=" + OrderStatusList.getInstance().getCompletedOrderStatus().getOrderStatusID();
                sql = sql + " AND OrderDate >= '" + formatter.format(calendar.getTime()) + "'";
                sql = sql + " ORDER BY Orders.OrderDate DESC";
                rs = DatabaseConnector.createStatementResultSet((Statement)stmt, (String)sql, (String)"getOrderListForTrackingCheck");
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getOrderList(Integer[] statusFilters) {
        ResultSet rs = null;
        Object object = this._lock;
        synchronized (object) {
            try {
                if (statusFilters.length > 0) {
                    Statement stmt = DatabaseConnector.createStatement((String)"getOrderList");
                    String sql = "SELECT * FROM Orders INNER JOIN OrderDetails ON Orders.OrderID = OrderDetails.OrderID INNER JOIN Customers ON Orders.CustomerUserName = Customers.CustomerUserName WHERE ";
                    sql = sql + "Orders.OrderStatusID=" + statusFilters[0];
                    for (int i = 1; i < statusFilters.length; ++i) {
                        sql = sql + " OR Orders.OrderStatusID=" + statusFilters[i];
                    }
                    sql = sql + " ORDER BY Orders.OrderDate DESC";
                    rs = DatabaseConnector.createStatementResultSet((Statement)stmt, (String)sql, (String)"getOrderList");
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getOrderList(String searchString, OrderStatus[] searchFilters, long searchFrom, long searchTo, String results) {
        ResultSet rs = null;
        Object object = this._lock;
        synchronized (object) {
            try {
                if (null != searchString) {
                    String exactMatch = searchString.toUpperCase();
                    searchString = "%" + searchString.toUpperCase() + "%";
                    boolean isNumber = false;
                    String sql = "SELECT * FROM Orders INNER JOIN OrderDetails ON Orders.OrderID = OrderDetails.OrderID INNER JOIN Customers ON Orders.CustomerUserName = Customers.CustomerUserName WHERE (UPPER(Orders.OrderComments) LIKE ? OR UPPER(OrderDetails.OrderNumber) LIKE ? OR OrderDetails.OrderID LIKE ? OR UPPER(OrderDetails.ItemID) LIKE ? OR UPPER(OrderDetails.OrderDescription) LIKE ? OR UPPER(Customers.CustomerUserName) LIKE ? OR UPPER(Customers.CustomerEmail) LIKE ? OR UPPER(Customers.CustomerName) LIKE ? OR UPPER(Customers.CustomerAddress) LIKE ? OR UPPER(Customers.CustomerCountry) LIKE ? OR UPPER(Customers.CustomerCity) LIKE ? OR UPPER(Customers.CustomerZipcode) LIKE ? OR UPPER(Customers.CustomerState) LIKE ? ";
                    if (null != MathParser.isDollarAmount((String)searchString)) {
                        try {
                            Float.parseFloat(exactMatch);
                            sql = sql + "OR ROUND(Orders.OrderTotal,2) LIKE ? ) ";
                            isNumber = true;
                        }
                        catch (Exception ex) {
                            ErrorsUtil.getInstance().logError(ex);
                            sql = sql + ")";
                            isNumber = false;
                        }
                    } else {
                        sql = sql + ")";
                    }
                    if (null != searchFilters && searchFilters.length > 0) {
                        sql = sql + "AND (Orders.OrderStatusID=" + searchFilters[0].getOrderStatusID();
                        for (int i = 1; i < searchFilters.length; ++i) {
                            sql = sql + " OR Orders.OrderStatusID=" + searchFilters[i].getOrderStatusID();
                        }
                        sql = sql + ") ";
                    }
                    SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
                    Calendar calendar = Calendar.getInstance();
                    if (searchFrom != 0L) {
                        calendar.setTimeInMillis(searchFrom);
                        sql = sql + "AND OrderDate >= '" + formatter.format(calendar.getTime()) + "' ";
                    } else {
                        sql = sql + "AND OrderDate >= '2010-01-01' ";
                    }
                    if (searchTo != 0L) {
                        calendar.setTimeInMillis(searchTo);
                        sql = sql + "AND OrderDate <= '" + formatter.format(calendar.getTime()) + "' ";
                    } else {
                        java.util.Date newDate = new java.util.Date();
                        newDate.setDate(newDate.getDate() + 1);
                        calendar.setTimeInMillis(newDate.getTime());
                        sql = sql + "AND OrderDate <= '" + formatter.format(calendar.getTime()) + "' ";
                    }
                    sql = sql + "ORDER BY Orders.OrderDate DESC LIMIT " + results;
                    PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"getOrderList");
                    stmt.setString(1, searchString);
                    stmt.setString(2, searchString);
                    stmt.setString(3, searchString);
                    stmt.setString(4, searchString);
                    stmt.setString(5, searchString);
                    stmt.setString(6, searchString);
                    stmt.setString(7, searchString);
                    stmt.setString(8, searchString);
                    stmt.setString(9, searchString);
                    stmt.setString(10, searchString);
                    stmt.setString(11, searchString);
                    stmt.setString(12, searchString);
                    stmt.setString(13, searchString);
                    if (isNumber) {
                        stmt.setString(14, exactMatch);
                    }
                    rs = DatabaseConnector.createPreparedStatementResultSet((PreparedStatement)stmt, (String)"getOrderList");
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getOrderList(OrderStatus[] searchFilters, long searchFrom, long searchTo, String companyName) {
        ResultSet rs = null;
        Object object = this._lock;
        synchronized (object) {
            try {
                String sql = "SELECT * FROM Orders INNER JOIN OrderDetails ON Orders.OrderID = OrderDetails.OrderID INNER JOIN Customers ON Orders.CustomerUserName = Customers.CustomerUserName WHERE (Orders.OrderStatusID=" + searchFilters[0].getOrderStatusID();
                for (int i = 1; i < searchFilters.length; ++i) {
                    sql = sql + " OR Orders.OrderStatusID=" + searchFilters[i].getOrderStatusID();
                }
                sql = sql + ")";
                if (companyName != null && !companyName.trim().isEmpty()) {
                    sql = sql + " AND Orders.OrderPaypal='" + companyName.trim() + "'";
                }
                sql = sql + " ";
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
                Calendar calendar = Calendar.getInstance();
                if (searchFrom != 0L) {
                    calendar.setTimeInMillis(searchFrom);
                    sql = sql + "AND OrderDate >= '" + formatter.format(calendar.getTime()) + "' ";
                }
                if (searchTo != 0L) {
                    calendar.setTimeInMillis(searchTo);
                    sql = sql + "AND OrderDate <= '" + formatter.format(calendar.getTime()) + "' ";
                }
                sql = sql + "ORDER BY Orders.OrderDate DESC";
                PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"getOrderList");
                rs = DatabaseConnector.createPreparedStatementResultSet((PreparedStatement)stmt, (String)"getOrderList");
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getReorderList(long searchFrom, long searchTo) {
        ResultSet rs = null;
        Object object = this._lock;
        synchronized (object) {
            try {
                String sql = "SELECT ItemID FROM Orders INNER JOIN OrderDetails ON Orders.OrderID = OrderDetails.OrderID WHERE Orders.OrderStatusID=" + OrderStatusList.getInstance().getCompletedOrderStatus().getOrderStatusID();
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
                Calendar calendar = Calendar.getInstance();
                if (searchFrom != 0L) {
                    calendar.setTimeInMillis(searchFrom);
                    sql = sql + "AND OrderDate >= '" + formatter.format(calendar.getTime()) + "' ";
                }
                if (searchTo != 0L) {
                    calendar.setTimeInMillis(searchTo);
                    sql = sql + "AND OrderDate <= '" + formatter.format(calendar.getTime()) + "' ";
                }
                sql = sql + "ORDER BY ItemID ASC";
                PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"getReorderList");
                rs = DatabaseConnector.createPreparedStatementResultSet((PreparedStatement)stmt, (String)"getReorderList");
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getOosOrderList() {
        ResultSet rs = null;
        Object object = this._lock;
        synchronized (object) {
            try {
                String sql = "SELECT * FROM Orders INNER JOIN OrderDetails ON Orders.OrderID = OrderDetails.OrderID INNER JOIN Customers ON Orders.CustomerUserName = Customers.CustomerUserName WHERE OrderDetails.Backordered=TRUE ";
                sql = sql + "ORDER BY Orders.OrderDate DESC";
                PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"getOosOrderList");
                rs = DatabaseConnector.createPreparedStatementResultSet((PreparedStatement)stmt, (String)"getOosOrderList");
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getCustomerList(Integer[] statusFilters) {
        ResultSet rs = null;
        Object object = this._lock;
        synchronized (object) {
            try {
                if (statusFilters.length > 0) {
                    Statement stmt = DatabaseConnector.createStatement((String)"getCustomerList");
                    String sql = "SELECT * FROM Orders INNER JOIN Customers ON Orders.CustomerUserName = Customers.CustomerUserName WHERE ";
                    sql = sql + "Orders.OrderStatusID=" + statusFilters[0];
                    for (int i = 1; i < statusFilters.length; ++i) {
                        sql = sql + " OR Orders.OrderStatusID=" + statusFilters[i];
                    }
                    rs = DatabaseConnector.createStatementResultSet((Statement)stmt, (String)sql, (String)"getCustomerList");
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getOrderStatusList() {
        ResultSet rs = null;
        Object object = this._lock;
        synchronized (object) {
            try {
                Statement stmt = DatabaseConnector.createStatement((String)"getOrderStatusList");
                String sql = "SELECT * FROM OrderStatus";
                rs = DatabaseConnector.createStatementResultSet((Statement)stmt, (String)sql, (String)"getOrderStatusList");
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getRMAStatusList() {
        ResultSet rs = null;
        Object object = this._lock;
        synchronized (object) {
            try {
                Statement stmt = DatabaseConnector.createStatement((String)"getRMAStatusList");
                String sql = "SELECT * FROM RMAStatus";
                rs = DatabaseConnector.createStatementResultSet((Statement)stmt, (String)sql, (String)"getRMAStatusList");
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getRMAReasonList() {
        ResultSet rs = null;
        Object object = this._lock;
        synchronized (object) {
            try {
                Statement stmt = DatabaseConnector.createStatement((String)"getRMAReasonList");
                String sql = "SELECT * FROM RMAReason";
                rs = DatabaseConnector.createStatementResultSet((Statement)stmt, (String)sql, (String)"getRMAReasonList");
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRma(RMADetails rmaDetails) {
        Object object = this._lock;
        synchronized (object) {
            try {
                Statement stmt = DatabaseConnector.createStatement((String)"deleteRma");
                String sql = "DELETE FROM RMADetails WHERE RmaNumberID=" + rmaDetails.getRmaNumberID();
                DatabaseConnector.executeUpdate((Statement)stmt, (String)sql);
                DatabaseConnector.removeObject((Statement)stmt);
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateRMA(RMADetails rmaElement) {
        Object object = this._lock;
        synchronized (object) {
            try {
                String sql = "UPDATE RMADetails SET RmaNumberID= ?, RMAComments= ?, RMADate= ?, CustomerUserName= ?, OrderDetailsID= ?,ReplacementTracking= ?, ReturnTracking= ?, RmaReasonID= ?, RmaStatusID= ? WHERE RmaNumberID= ?";
                PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"updateRMA");
                int index = 1;
                stmt.setInt(index++, rmaElement.getRmaNumberID());
                stmt.setString(index++, rmaElement.getRmaComments());
                stmt.setDate(index++, rmaElement.getRmaDate());
                stmt.setString(index++, rmaElement.getCustomerUsername());
                stmt.setInt(index++, rmaElement.getOrderDetailsID());
                stmt.setString(index++, rmaElement.getReplacementTracking());
                stmt.setString(index++, rmaElement.getReturnTracking());
                stmt.setInt(index++, rmaElement.getRmaReasonID());
                stmt.setInt(index++, rmaElement.getRmaStatusID());
                stmt.setInt(index++, rmaElement.getRmaNumberID());
                DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                if (0 == stmt.getUpdateCount()) {
                    DatabaseConnector.removeObject((PreparedStatement)stmt);
                    sql = "INSERT INTO RMADetails (RMAComments, ";
                    if (null != rmaElement.getRmaDate() && !rmaElement.getRmaDate().toString().equals("")) {
                        sql = sql + "RMADate, ";
                    }
                    sql = sql + "CustomerUserName, OrderDetailsID,ReplacementTracking, ReturnTracking, RmaReasonID, RmaStatusID)Values (?, ";
                    if (null != rmaElement.getRmaDate() && !rmaElement.getRmaDate().toString().equals("")) {
                        sql = sql + "?, ";
                    }
                    sql = sql + "?, ?, ?, ?, ?, ?)";
                    stmt = DatabaseConnector.createPreparedStatement((String)sql, (int)1, (String)"updateRMA");
                    index = 1;
                    stmt.setString(index++, rmaElement.getRmaComments());
                    if (null != rmaElement.getRmaDate() && !rmaElement.getRmaDate().toString().equals("")) {
                        stmt.setDate(index++, rmaElement.getRmaDate());
                    }
                    stmt.setString(index++, rmaElement.getCustomerUsername());
                    stmt.setInt(index++, rmaElement.getOrderDetailsID());
                    stmt.setString(index++, rmaElement.getReplacementTracking());
                    stmt.setString(index++, rmaElement.getReturnTracking());
                    stmt.setInt(index++, rmaElement.getRmaReasonID());
                    stmt.setInt(index++, rmaElement.getRmaStatusID());
                    DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                    ResultSet rs = DatabaseConnector.createGeneratedKeys((Statement)stmt, (String)"updateRMA");
                    if (null != rs && rs.next()) {
                        rmaElement.setRmaNumberID(rs.getInt(1));
                        DatabaseConnector.removeObject((ResultSet)rs);
                    }
                    DatabaseConnector.removeObject((PreparedStatement)stmt);
                }
                DatabaseConnector.removeObject((PreparedStatement)stmt);
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return rmaElement.getRmaNumberID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getRMAList(String searchString, Collection<Integer> statusFilters, Collection<Integer> reasonFilters, long searchFrom, long searchTo) {
        ResultSet rs = null;
        boolean validQuery = false;
        Object object = this._lock;
        synchronized (object) {
            try {
                Iterator<Integer> reasonIter;
                Iterator<Integer> statusIter;
                String sql = "SELECT * FROM RMADetails INNER JOIN OrderDetails ON RMADetails.OrderDetailsID = OrderDetails.OrderDetailsID INNER JOIN Customers ON RMADetails.CustomerUserName = Customers.CustomerUserName ";
                int index = 1;
                if (null != searchString && !searchString.trim().equals("")) {
                    validQuery = true;
                    searchString = "%" + searchString.trim().toUpperCase() + "%";
                    sql = sql + "WHERE (UPPER(RMADetails.RMAComments) LIKE ? OR RMADetails.RmaNumberID LIKE ? OR UPPER(RMADetails.ReplacementTracking) LIKE ? OR UPPER(RMADetails.ReturnTracking) LIKE ? OR UPPER(OrderDetails.ItemID) LIKE ? OR UPPER(OrderDetails.OrderDescription) LIKE ? OR UPPER(Customers.CustomerUserName) LIKE ? OR UPPER(Customers.CustomerEmail) LIKE ? OR UPPER(Customers.CustomerName) LIKE ? OR UPPER(Customers.CustomerAddress) LIKE ? OR UPPER(Customers.CustomerCountry) LIKE ? OR UPPER(Customers.CustomerCity) LIKE ? OR UPPER(Customers.CustomerZipcode) LIKE ? OR UPPER(Customers.CustomerState) LIKE ? ) ";
                }
                if ((statusIter = statusFilters.iterator()).hasNext()) {
                    validQuery = true;
                    sql = null != searchString && !searchString.trim().equals("") ? sql + "AND (RMADetails.RmaStatusID=" + statusIter.next() : sql + "WHERE (RMADetails.RmaStatusID=" + statusIter.next();
                    while (statusIter.hasNext()) {
                        sql = sql + " OR RMADetails.RmaStatusID=" + statusIter.next();
                    }
                    sql = sql + ") ";
                }
                if ((reasonIter = reasonFilters.iterator()).hasNext()) {
                    validQuery = true;
                    sql = null != searchString && !searchString.trim().equals("") ? sql + "AND (RMADetails.RmaReasonID=" + reasonIter.next() : (statusFilters.size() > 0 ? sql + "AND (RMADetails.RmaReasonID=" + reasonIter.next() : sql + "WHERE (RMADetails.RmaReasonID=" + reasonIter.next());
                    while (reasonIter.hasNext()) {
                        sql = sql + " OR RMADetails.RmaReasonID=" + reasonIter.next();
                    }
                    sql = sql + ") ";
                }
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
                Calendar calendar = Calendar.getInstance();
                if (searchFrom != 0L) {
                    validQuery = true;
                    calendar.setTimeInMillis(searchFrom);
                    sql = null != searchString && !searchString.trim().equals("") ? sql + "AND RMADetails.RMADate >= '" + formatter.format(calendar.getTime()) + "' " : (statusFilters.size() > 0 ? sql + "AND RMADetails.RMADate >= '" + formatter.format(calendar.getTime()) + "' " : (reasonFilters.size() > 0 ? sql + "AND RMADetails.RMADate >= '" + formatter.format(calendar.getTime()) + "' " : sql + "WHERE RMADetails.RMADate >= '" + formatter.format(calendar.getTime()) + "' "));
                }
                if (searchTo != 0L) {
                    validQuery = true;
                    calendar.setTimeInMillis(searchTo);
                    sql = null != searchString && !searchString.trim().equals("") ? sql + "AND RMADetails.RMADate <= '" + formatter.format(calendar.getTime()) + "' " : (statusFilters.size() > 0 ? sql + "AND RMADetails.RMADate <= '" + formatter.format(calendar.getTime()) + "' " : (reasonFilters.size() > 0 ? sql + "AND RMADetails.RMADate <= '" + formatter.format(calendar.getTime()) + "' " : (searchFrom != 0L ? sql + "AND RMADetails.RMADate <= '" + formatter.format(calendar.getTime()) + "' " : sql + "WHERE RMADetails.RMADate <= '" + formatter.format(calendar.getTime()) + "' ")));
                }
                sql = sql + "ORDER BY RMADetails.RMADate DESC ";
                if (validQuery) {
                    PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"getRMAList");
                    if (null != searchString && !searchString.trim().equals("")) {
                        stmt.setString(index++, searchString);
                        stmt.setString(index++, searchString);
                        stmt.setString(index++, searchString);
                        stmt.setString(index++, searchString);
                        stmt.setString(index++, searchString);
                        stmt.setString(index++, searchString);
                        stmt.setString(index++, searchString);
                        stmt.setString(index++, searchString);
                        stmt.setString(index++, searchString);
                        stmt.setString(index++, searchString);
                        stmt.setString(index++, searchString);
                        stmt.setString(index++, searchString);
                        stmt.setString(index++, searchString);
                        stmt.setString(index++, searchString);
                    }
                    rs = DatabaseConnector.createPreparedStatementResultSet((PreparedStatement)stmt, (String)"getRMAList");
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getShippingMethodList() {
        ResultSet rs = null;
        Object object = this._lock;
        synchronized (object) {
            try {
                Statement stmt = DatabaseConnector.createStatement((String)"getShippingMethodList");
                String sql = "SELECT * FROM ShippingMethods";
                rs = DatabaseConnector.createStatementResultSet((Statement)stmt, (String)sql, (String)"getShippingMethodList");
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateOrderDetails(OrderDetails orderDetails) {
        int orderDetailsID = orderDetails.getOrderDetailsID();
        Object object = this._lock;
        synchronized (object) {
            try {
                String sql = "UPDATE OrderDetails SET TransactionID= ?, OrderID= ?, OrderNumber= ?";
                if (null != orderDetails.getShipDate() && !orderDetails.getShipDate().toString().equals("")) {
                    sql = sql + ", ShipDate= ?";
                }
                sql = sql + ", ItemID= ?, AccountName= ?, TrackingNumber= ?, Carrier= ?, SalesPrice= ?, ItemCost= ?, Inhouse= ?, Backordered= ?, Deleted= ?, OrderDescription= ?, EbaySite = ?, EbayWeight = ? WHERE TransactionID= ?";
                PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"updateOrderDetails");
                int index = 1;
                stmt.setString(index++, orderDetails.getTransactionID());
                stmt.setInt(index++, orderDetails.getOrderID());
                stmt.setString(index++, orderDetails.getOrderNumber());
                if (null != orderDetails.getShipDate() && !orderDetails.getShipDate().toString().equals("")) {
                    stmt.setDate(index++, orderDetails.getShipDate());
                }
                stmt.setString(index++, orderDetails.getItemID());
                stmt.setString(index++, orderDetails.getAccountName());
                stmt.setString(index++, orderDetails.getTrackingNumber());
                stmt.setString(index++, orderDetails.getCarrier());
                stmt.setFloat(index++, orderDetails.getSalesPrice());
                stmt.setFloat(index++, orderDetails.getItemCost());
                stmt.setBoolean(index++, orderDetails.isInhouse());
                stmt.setBoolean(index++, orderDetails.isBackordered());
                stmt.setBoolean(index++, orderDetails.isDeleted());
                stmt.setString(index++, orderDetails.getOrderDescription());
                stmt.setString(index++, orderDetails.getEbaySite());
                stmt.setFloat(index++, orderDetails.getEbayWeight());
                stmt.setString(index++, orderDetails.getTransactionID());
                DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                if (0 == stmt.getUpdateCount()) {
                    DatabaseConnector.removeObject((PreparedStatement)stmt);
                    sql = "INSERT INTO OrderDetails  (TransactionID, OrderID, OrderNumber, Backordered, ";
                    if (null != orderDetails.getShipDate() && !orderDetails.getShipDate().toString().equals("")) {
                        sql = sql + "ShipDate, ";
                    }
                    sql = sql + "ItemID, AccountName, TrackingNumber, Carrier, SalesPrice, ItemCost, Inhouse, OrderDescription, EbaySite, EbayWeight)Values (?, ?, ?, ?, ";
                    if (null != orderDetails.getShipDate() && !orderDetails.getShipDate().toString().equals("")) {
                        sql = sql + "?, ";
                    }
                    sql = sql + "?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                    stmt = DatabaseConnector.createPreparedStatement((String)sql, (int)1, (String)"updateOrderDetails");
                    index = 1;
                    stmt.setString(index++, orderDetails.getTransactionID());
                    stmt.setInt(index++, orderDetails.getOrderID());
                    stmt.setString(index++, orderDetails.getOrderNumber());
                    stmt.setBoolean(index++, orderDetails.isBackordered());
                    if (null != orderDetails.getShipDate() && !orderDetails.getShipDate().toString().equals("")) {
                        stmt.setDate(index++, orderDetails.getShipDate());
                    }
                    stmt.setString(index++, orderDetails.getItemID());
                    stmt.setString(index++, orderDetails.getAccountName());
                    stmt.setString(index++, orderDetails.getTrackingNumber());
                    stmt.setString(index++, orderDetails.getCarrier());
                    stmt.setFloat(index++, orderDetails.getSalesPrice());
                    stmt.setFloat(index++, orderDetails.getItemCost());
                    stmt.setBoolean(index++, orderDetails.isInhouse());
                    stmt.setString(index++, orderDetails.getOrderDescription());
                    stmt.setString(index++, orderDetails.getEbaySite());
                    stmt.setFloat(index++, orderDetails.getEbayWeight());
                    DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                    ResultSet rs = DatabaseConnector.createGeneratedKeys((Statement)stmt, (String)"updateOrderDetails");
                    if (null != rs && rs.next()) {
                        orderDetailsID = rs.getInt(1);
                        orderDetails.setOrderDetailsID(orderDetailsID);
                        DatabaseConnector.removeObject((ResultSet)rs);
                    }
                    DatabaseConnector.removeObject((PreparedStatement)stmt);
                } else {
                    DatabaseConnector.removeObject((PreparedStatement)stmt);
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return orderDetails.getOrderDetailsID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateOosOrderDetails(OrderDetails orderDetails) {
        Object object = this._lock;
        synchronized (object) {
            try {
                String sql = "UPDATE OrderDetails SET ItemCost= ?, Backordered= ? WHERE OrderDetailsID= ?";
                PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"updateOosOrderDetails");
                stmt.setFloat(1, orderDetails.getItemCost());
                stmt.setBoolean(2, orderDetails.isBackordered());
                stmt.setInt(3, orderDetails.getOrderDetailsID());
                DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                DatabaseConnector.removeObject((PreparedStatement)stmt);
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteOrder(Order order) {
        Object object = this._lock;
        synchronized (object) {
            try {
                Statement stmt = DatabaseConnector.createStatement((String)"deleteOrder");
                String sql = "DELETE FROM Orders WHERE OrderID=" + order.getOrderID();
                DatabaseConnector.executeUpdate((Statement)stmt, (String)sql);
                DatabaseConnector.removeObject((Statement)stmt);
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteInventoryElement(InventoryElement element) {
        Object object = this._lock;
        synchronized (object) {
            try {
                Statement stmt = DatabaseConnector.createStatement((String)"deleteInventoryElement");
                String sql = "DELETE FROM Inventory WHERE InventoryID=" + element.getInventoryID();
                DatabaseConnector.executeUpdate((Statement)stmt, (String)sql);
                DatabaseConnector.removeObject((Statement)stmt);
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllInventoryElements(InventoryElement element) {
        Object object = this._lock;
        synchronized (object) {
            try {
                Statement stmt = DatabaseConnector.createStatement((String)"deleteAllInventoryElements");
                String sql = "DELETE FROM Inventory WHERE ItemID='" + element.getItemID() + "'";
                DatabaseConnector.executeUpdate((Statement)stmt, (String)sql);
                DatabaseConnector.removeObject((Statement)stmt);
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteExpense(Expense expense) {
        Object object = this._lock;
        synchronized (object) {
            try {
                Statement stmt = DatabaseConnector.createStatement((String)"deleteExpense");
                String sql = "DELETE FROM Expenses WHERE ExpenseID=" + expense.getExpenseID();
                DatabaseConnector.executeUpdate((Statement)stmt, (String)sql);
                DatabaseConnector.removeObject((Statement)stmt);
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateOrder(Order order) {
        this.updateCustomer(order.getCustomer());
        Object object = this._lock;
        synchronized (object) {
            try {
                if (0 != order.getOrderID()) {
                    String sql = "UPDATE Orders SET CustomerUserName=? , OrderDate= ? , OrderTotal= ? , ShippingMethodID= ? , ShippingCost= ? , ShippingPaid= ? , OrderStatusID= ? , OrderComments= ? , OrderPaypal= ?  WHERE OrderID= ? ";
                    PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"updateOrder");
                    stmt.setString(1, order.getCustomer().getCustomerUserName());
                    stmt.setDate(2, order.getOrderDate());
                    stmt.setFloat(3, order.getOrderTotal());
                    stmt.setString(4, order.getShippingMethodName());
                    stmt.setFloat(5, order.getShippingCost());
                    stmt.setFloat(6, order.getShippingPaid());
                    stmt.setInt(7, order.getOrderStatusID());
                    stmt.setString(8, order.getOrderComments());
                    stmt.setString(9, order.getPaypalAccount());
                    stmt.setInt(10, order.getOrderID());
                    DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                    DatabaseConnector.removeObject((PreparedStatement)stmt);
                } else {
                    String sql = "INSERT INTO Orders (CustomerUserName, OrderDate, OrderTotal, ShippingMethodID, ShippingCost, ShippingPaid, OrderStatusID, OrderComments, OrderPaypal) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
                    PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (int)1, (String)"updateOrder");
                    stmt.setString(1, order.getCustomer().getCustomerUserName());
                    stmt.setDate(2, order.getOrderDate());
                    stmt.setFloat(3, order.getOrderTotal());
                    stmt.setString(4, order.getShippingMethodName());
                    stmt.setFloat(5, order.getShippingCost());
                    stmt.setFloat(6, order.getShippingPaid());
                    stmt.setInt(7, order.getOrderStatusID());
                    stmt.setString(8, order.getOrderComments());
                    stmt.setString(9, order.getPaypalAccount());
                    DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                    ResultSet rs = DatabaseConnector.createGeneratedKeys((Statement)stmt, (String)"updateOrder");
                    if (null != rs && rs.next()) {
                        order.setOrderID(rs.getInt(1));
                        DatabaseConnector.removeObject((ResultSet)rs);
                    }
                    DatabaseConnector.removeObject((PreparedStatement)stmt);
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return order.getOrderID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getCustomerByUsername(String username) {
        ResultSet rs = null;
        Object object = this._lock;
        synchronized (object) {
            try {
                String sql = "SELECT * FROM Customers WHERE CustomerUserName = ?";
                PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"getCustomerByUsername");
                stmt.setString(1, username);
                rs = DatabaseConnector.createPreparedStatementResultSet((PreparedStatement)stmt, (String)"getCustomerByUsername");
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getCustomerByEmail(String email) {
        ResultSet rs = null;
        Object object = this._lock;
        synchronized (object) {
            try {
                String sql = "SELECT * FROM Customers WHERE CustomerEmail = ?";
                PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"getCustomerByEmail");
                stmt.setString(1, email);
                rs = DatabaseConnector.createPreparedStatementResultSet((PreparedStatement)stmt, (String)"getCustomerByEmail");
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getDistributors() {
        ResultSet rs = null;
        Object object = this._lock;
        synchronized (object) {
            try {
                Statement stmt = DatabaseConnector.createStatement((String)"getDistributors");
                String sql = "SELECT * FROM Distributors";
                rs = DatabaseConnector.createStatementResultSet((Statement)stmt, (String)sql, (String)"getDistributors");
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getCustomFees() {
        ResultSet rs = null;
        Object object = this._lock;
        synchronized (object) {
            try {
                Statement stmt = DatabaseConnector.createStatement((String)"getCustomFees");
                String sql = "SELECT * FROM CustomFees";
                rs = DatabaseConnector.createStatementResultSet((Statement)stmt, (String)sql, (String)"getCustomFees");
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateDistributor(Distributor distributor) {
        Object object = this._lock;
        synchronized (object) {
            try {
                if (0 != distributor.getDistributorID()) {
                    String sql = "UPDATE Distributors SET DistributorName=? , DistributorContact= ? , DistributorPhone= ? , DistributorEmail= ? , DistributorWebsite= ?  WHERE DistributorID= ? ";
                    PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"updateDistributor");
                    stmt.setString(1, distributor.getDistributorName());
                    stmt.setString(2, distributor.getDistributorContact());
                    stmt.setString(3, distributor.getDistributorPhone());
                    stmt.setString(4, distributor.getDistributorEmail());
                    stmt.setString(5, distributor.getDistributorWebsite());
                    stmt.setInt(6, distributor.getDistributorID());
                    DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                    DatabaseConnector.removeObject((PreparedStatement)stmt);
                } else {
                    String sql = "INSERT INTO Distributors (DistributorName, DistributorContact, DistributorPhone, DistributorEmail, DistributorWebsite) VALUES (?, ?, ?, ?, ?)";
                    PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (int)1, (String)"updateDistributor");
                    stmt.setString(1, distributor.getDistributorName());
                    stmt.setString(2, distributor.getDistributorContact());
                    stmt.setString(3, distributor.getDistributorPhone());
                    stmt.setString(4, distributor.getDistributorEmail());
                    stmt.setString(5, distributor.getDistributorWebsite());
                    DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                    ResultSet rs = DatabaseConnector.createGeneratedKeys((Statement)stmt, (String)"updateDistributor");
                    if (null != rs && rs.next()) {
                        distributor.setDistributorID(rs.getInt(1));
                        DatabaseConnector.removeObject((ResultSet)rs);
                    }
                    DatabaseConnector.removeObject((PreparedStatement)stmt);
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return distributor.getDistributorID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCustomFee(CustomFee customFee) {
        Object object = this._lock;
        synchronized (object) {
            try {
                String sql = "DELETE FROM CustomFees WHERE CustomFeeID =" + customFee.getCustomFeeID();
                PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"removeCustomFee");
                DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                DatabaseConnector.removeObject((PreparedStatement)stmt);
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateCustomFee(CustomFee customFee) {
        Object object = this._lock;
        synchronized (object) {
            try {
                if (0 != customFee.getCustomFeeID()) {
                    String sql = "UPDATE CustomFees SET CustomFeeName=? , CustomFeePercentage= ? , CustomFeeFlatCost= ?  WHERE CustomFeeID= ? ";
                    PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"updateCustomFee");
                    stmt.setString(1, customFee.getFeeName());
                    stmt.setDouble(2, customFee.getFeePercentage());
                    stmt.setDouble(3, customFee.getFeeFlatCost());
                    stmt.setInt(4, customFee.getCustomFeeID());
                    DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                    DatabaseConnector.removeObject((PreparedStatement)stmt);
                } else {
                    String sql = "INSERT INTO CustomFees (CustomFeeName, CustomFeePercentage, CustomFeeFlatCost) VALUES (?, ?, ?)";
                    PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (int)1, (String)"updateCustomFee");
                    stmt.setString(1, customFee.getFeeName());
                    stmt.setDouble(2, customFee.getFeePercentage());
                    stmt.setDouble(3, customFee.getFeeFlatCost());
                    DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                    ResultSet rs = DatabaseConnector.createGeneratedKeys((Statement)stmt, (String)"updateCustomFee");
                    if (null != rs && rs.next()) {
                        customFee.setCustomFeeID(rs.getInt(1));
                        DatabaseConnector.removeObject((ResultSet)rs);
                    }
                    DatabaseConnector.removeObject((PreparedStatement)stmt);
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return customFee.getCustomFeeID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getCategories() {
        ResultSet rs = null;
        Object object = this._lock;
        synchronized (object) {
            try {
                Statement stmt = DatabaseConnector.createStatement((String)"getCategories");
                String sql = "SELECT * FROM Categories";
                rs = DatabaseConnector.createStatementResultSet((Statement)stmt, (String)sql, (String)"getCategories");
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateCategory(Category category) {
        Object object = this._lock;
        synchronized (object) {
            try {
                if (0 != category.getCategoryID()) {
                    String sql = "UPDATE Categories SET CategoryName=?  WHERE CategoryID= ? ";
                    PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"updateCategory");
                    stmt.setString(1, category.getCategoryName());
                    stmt.setInt(2, category.getCategoryID());
                    DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                    DatabaseConnector.removeObject((PreparedStatement)stmt);
                } else {
                    String sql = "INSERT INTO Categories (CategoryName) VALUES (?)";
                    PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (int)1, (String)"updateCategory");
                    stmt.setString(1, category.getCategoryName());
                    DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                    ResultSet rs = DatabaseConnector.createGeneratedKeys((Statement)stmt, (String)"updateCategory");
                    if (null != rs && rs.next()) {
                        category.setCategoryID(rs.getInt(1));
                        DatabaseConnector.removeObject((ResultSet)rs);
                    }
                    DatabaseConnector.removeObject((PreparedStatement)stmt);
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return category.getCategoryID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getWebsites() {
        ResultSet rs = null;
        Object object = this._lock;
        synchronized (object) {
            try {
                Statement stmt = DatabaseConnector.createStatement((String)"getWebsites");
                String sql = "SELECT * FROM Websites";
                rs = DatabaseConnector.createStatementResultSet((Statement)stmt, (String)sql, (String)"getWebsites");
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateWebsite(Website website) {
        Object object = this._lock;
        synchronized (object) {
            try {
                if (0 != website.getWebsiteID()) {
                    String sql = "UPDATE Websites SET WebsiteName=?, WebsiteURI=?, WebsiteActive=?, LastUpdate=?  WHERE WebsiteID= ? ";
                    PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"updateWebsite");
                    stmt.setString(1, website.getWebsiteName());
                    stmt.setString(2, website.getWebsiteURI());
                    stmt.setBoolean(3, website.isWebsiteActive());
                    stmt.setLong(4, website.getLastUpdate());
                    stmt.setInt(5, website.getWebsiteID());
                    DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                    DatabaseConnector.removeObject((PreparedStatement)stmt);
                } else {
                    String sql = "INSERT INTO Websites (WebsiteName, WebsiteURI, WebsiteActive, LastUpdate) VALUES (?,?,?,?)";
                    PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"updateWebsite");
                    stmt.setString(1, website.getWebsiteName());
                    stmt.setString(2, website.getWebsiteURI());
                    stmt.setBoolean(3, website.isWebsiteActive());
                    stmt.setLong(4, website.getLastUpdate());
                    DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                    DatabaseConnector.removeObject((PreparedStatement)stmt);
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return website.getWebsiteID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getWebsiteCategories() {
        ResultSet rs = null;
        Object object = this._lock;
        synchronized (object) {
            try {
                Statement stmt = DatabaseConnector.createStatement((String)"getWebsiteCategories");
                String sql = "SELECT * FROM WebsiteCategories";
                rs = DatabaseConnector.createStatementResultSet((Statement)stmt, (String)sql, (String)"getWebsiteCategories");
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateWebsiteCategories(WebsiteCategories websiteCategories) {
        Object object = this._lock;
        synchronized (object) {
            try {
                String sql = "DELETE FROM WebsiteCategories WHERE WebsiteID =" + websiteCategories.getWebsiteID();
                PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"updateWebsiteCategories");
                DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                DatabaseConnector.removeObject((PreparedStatement)stmt);
                Iterator iter = websiteCategories.getCategories().iterator();
                while (iter.hasNext()) {
                    int categoryID = (Integer)iter.next();
                    sql = "INSERT INTO WebsiteCategories (WebsiteID, CategoryID) VALUES (?, ?)";
                    stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"updateWebsiteCategories");
                    stmt.setInt(1, websiteCategories.getWebsiteID());
                    stmt.setInt(2, categoryID);
                    DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                    DatabaseConnector.removeObject((PreparedStatement)stmt);
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getExpenseReasonsList() {
        ResultSet rs = null;
        Object object = this._lock;
        synchronized (object) {
            try {
                String sql = "SELECT * FROM ExpenseReasons";
                PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"getExpenseReasonsList");
                rs = DatabaseConnector.createPreparedStatementResultSet((PreparedStatement)stmt, (String)"getExpenseReasonsList");
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateExpenseReason(ExpenseReason reason) {
        Object object = this._lock;
        synchronized (object) {
            try {
                if (0 != reason.getExpenseReasonID()) {
                    String sql = "UPDATE ExpenseReasons SET Reason=?  WHERE ExpenseReasonID= ? ";
                    PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"updateExpenseReason");
                    stmt.setString(1, reason.getReason());
                    stmt.setInt(2, reason.getExpenseReasonID());
                    DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                    DatabaseConnector.removeObject((PreparedStatement)stmt);
                } else {
                    String sql = "INSERT INTO ExpenseReasons (Reason) VALUES (?)";
                    PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (int)1, (String)"updateExpenseReason");
                    stmt.setString(1, reason.getReason());
                    DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                    ResultSet rs = DatabaseConnector.createGeneratedKeys((Statement)stmt, (String)"updateExpenseReason");
                    if (null != rs && rs.next()) {
                        reason.setExpenseReasonID(rs.getInt(1));
                        DatabaseConnector.removeObject((ResultSet)rs);
                    }
                    DatabaseConnector.removeObject((PreparedStatement)stmt);
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return reason.getExpenseReasonID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getSalesTax() {
        ResultSet rs = null;
        Object object = this._lock;
        synchronized (object) {
            try {
                String sql = "SELECT * FROM SalesTax";
                PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"getSalesTax");
                rs = DatabaseConnector.createPreparedStatementResultSet((PreparedStatement)stmt, (String)"getSalesTax");
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSalesTax(String Abbreviation, String Identifier, Float Cost) {
        Object object = this._lock;
        synchronized (object) {
            try {
                Statement stmt = DatabaseConnector.createStatement((String)"setSalesTax");
                Boolean Enabled = (double)Cost.floatValue() != 0.0;
                String sql = "UPDATE SalesTax SET Identifier = '" + Identifier + "', Cost = '" + Cost + "', Enabled = '" + Enabled + "' WHERE Abbreviation = '" + Abbreviation + "'";
                DatabaseConnector.executeUpdate((Statement)stmt, (String)sql);
                DatabaseConnector.removeObject((Statement)stmt);
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEtsyAccount(EtsyAccount account) {
        Object object = this._lock;
        synchronized (object) {
            PreparedStatement insertStatement = null;
            PreparedStatement updateStatment = null;
            try {
                boolean updateSuccess;
                String insertSQL = SQLUtil.getInstance().createInsertSQL("ETSYACCOUNTS", new String[]{"Token", "TokenSecret", "EtsyStore", "EtsyLogin"});
                String updateSQL = SQLUtil.getInstance().createUpdateSQL("ETSYACCOUNTS", new String[]{"Token", "TokenSecret"}, "EtsyStore", "EtsyLogin");
                updateStatment = DatabaseConnector.createPreparedStatement((String)updateSQL, (String)"updateEtsyAccount");
                int itemCounter = 1;
                updateStatment.setString(itemCounter++, account.getToken());
                updateStatment.setString(itemCounter++, account.getTokenSecret());
                updateStatment.setString(itemCounter++, account.getEtsyStore());
                updateStatment.setString(itemCounter++, account.getEtsyLogin());
                boolean bl = updateSuccess = DatabaseConnector.executeUpdate((PreparedStatement)updateStatment) != 0;
                if (!updateSuccess) {
                    insertStatement = DatabaseConnector.createPreparedStatement((String)insertSQL, (String)"updateEtsyAccount");
                    itemCounter = 1;
                    insertStatement.setString(itemCounter++, account.getToken());
                    insertStatement.setString(itemCounter++, account.getTokenSecret());
                    insertStatement.setString(itemCounter++, account.getEtsyStore());
                    insertStatement.setString(itemCounter++, account.getEtsyLogin());
                    DatabaseConnector.executeUpdate((PreparedStatement)insertStatement);
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
            DatabaseConnector.removeObject(updateStatment);
            DatabaseConnector.removeObject(insertStatement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAmazonAccount(AmazonAccount account) {
        Object object = this._lock;
        synchronized (object) {
            PreparedStatement insertStatement = null;
            PreparedStatement updateStatment = null;
            try {
                boolean updateSuccess;
                String insertSQL = SQLUtil.getInstance().createInsertSQL("AmazonAccount", new String[]{"UserName", "AmazonAccountID", "UserToken", "MwsAuthToken"});
                String updateSQL = SQLUtil.getInstance().createUpdateSQL("AmazonAccount", new String[]{"UserName", "AmazonAccountID", "UserToken", "MwsAuthToken"}, "AmazonAccountNumber");
                updateStatment = DatabaseConnector.createPreparedStatement((String)updateSQL, (String)"updateAmazonAccount");
                int itemCounter = 1;
                updateStatment.setString(itemCounter++, account.getAccountName());
                updateStatment.setString(itemCounter++, account.getMarketPlaceID());
                updateStatment.setString(itemCounter++, account.getSellerID());
                updateStatment.setString(itemCounter++, account.getMwsAuthToken());
                updateStatment.setInt(itemCounter++, account.getAmazonAccountNumber());
                boolean bl = updateSuccess = DatabaseConnector.executeUpdate((PreparedStatement)updateStatment) != 0;
                if (!updateSuccess) {
                    insertStatement = DatabaseConnector.createPreparedStatement((String)insertSQL, (String)"updateAmazonAccount");
                    itemCounter = 1;
                    insertStatement.setString(itemCounter++, account.getAccountName());
                    insertStatement.setString(itemCounter++, account.getMarketPlaceID());
                    insertStatement.setString(itemCounter++, account.getSellerID());
                    insertStatement.setString(itemCounter++, account.getMwsAuthToken());
                    DatabaseConnector.executeUpdate((PreparedStatement)insertStatement);
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
            DatabaseConnector.removeObject(updateStatment);
            DatabaseConnector.removeObject(insertStatement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteEtsyAccount(String etsyStore, String etsyLogin) {
        Object object = this._lock;
        synchronized (object) {
            try {
                String sql = "DELETE FROM ETSYACCOUNTS WHERE EtsyStore = ? AND EtsyLogin = ?";
                PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"deleteEtsyAccount");
                stmt.setString(1, etsyStore);
                stmt.setString(2, etsyLogin);
                DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                DatabaseConnector.removeObject((PreparedStatement)stmt);
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getEtsyAccounts() {
        Object object = this._lock;
        synchronized (object) {
            try {
                return DatabaseConnector.createStatementResultSet((Statement)DatabaseConnector.createStatement((String)"getEtsyAccounts"), (String)"SELECT * FROM ETSYACCOUNTS", (String)"getEtsyAccounts");
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getAmazonAccounts() {
        Object object = this._lock;
        synchronized (object) {
            try {
                return DatabaseConnector.createStatementResultSet((Statement)DatabaseConnector.createStatement((String)"getAmazonAccounts"), (String)"SELECT * FROM AmazonAccount", (String)"getAmazonAccounts");
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean categoryInUse(int categoryID) {
        Object object = this._lock;
        synchronized (object) {
            boolean inUse = true;
            try {
                String sql = "SELECT * FROM WebsiteProducts WHERE  CategoryID = ?";
                PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"categoryInUse");
                stmt.setInt(1, categoryID);
                ResultSet rs = DatabaseConnector.createPreparedStatementResultSet((PreparedStatement)stmt, (String)"categoryInUse");
                if (rs != null && !rs.isClosed() && !rs.next()) {
                    inUse = false;
                }
                DatabaseConnector.removeObject((ResultSet)rs);
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
            return inUse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCategory(int categoryID) {
        Object object = this._lock;
        synchronized (object) {
            try {
                if (!this.categoryInUse(categoryID)) {
                    String sql = "DELETE FROM Categories WHERE CategoryID = ?";
                    PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"removeCategory");
                    stmt.setInt(1, categoryID);
                    DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                    DatabaseConnector.removeObject((PreparedStatement)stmt);
                    sql = "DELETE FROM WebsiteCategories WHERE CategoryID = ?";
                    stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"removeCategory");
                    stmt.setInt(1, categoryID);
                    DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                    DatabaseConnector.removeObject((PreparedStatement)stmt);
                    sql = "UPDATE WebsiteProducts SET CategoryID = 0 WHERE CategoryID = ?";
                    stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"removeCategory");
                    stmt.setInt(1, categoryID);
                    DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                    DatabaseConnector.removeObject((PreparedStatement)stmt);
                    sql = "DELETE FROM Website_Category_Associations WHERE WebsiteCategoryID = ?";
                    stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"removeCategory");
                    stmt.setInt(1, categoryID);
                    DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                    DatabaseConnector.removeObject((PreparedStatement)stmt);
                } else {
                    JOptionPane.showMessageDialog(null, "Category In Use");
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeCategory(int selectedCategory, int movedToCategory) {
        Object object = this._lock;
        synchronized (object) {
            try {
                String sql = "UPDATE WebsiteProducts SET CategoryID = ? WHERE CategoryID = ?";
                PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"mergeCategory");
                stmt.setInt(1, movedToCategory);
                stmt.setInt(2, selectedCategory);
                DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                DatabaseConnector.removeObject((PreparedStatement)stmt);
                sql = "UPDATE WebsiteCategories SET CategoryID = ? WHERE CategoryID = ?";
                stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"mergeCategory");
                stmt.setInt(1, movedToCategory);
                stmt.setInt(2, selectedCategory);
                DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                DatabaseConnector.removeObject((PreparedStatement)stmt);
                this.removeCategory(selectedCategory);
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getPayPalFilters() {
        Object object = this._lock;
        synchronized (object) {
            try {
                return DatabaseConnector.createStatementResultSet((Statement)DatabaseConnector.createStatement((String)"getPayPalFilters"), (String)"SELECT * FROM PayPalFilterList", (String)"getPayPalFilters");
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFilterList(AccountPreferences preferences) {
        Object object = this._lock;
        synchronized (object) {
            try {
                Statement stmtDelete = DatabaseConnector.createStatement((String)"updateFilterList");
                DatabaseConnector.executeUpdate((Statement)stmtDelete, (String)"TRUNCATE TABLE PayPalFilterList");
                DatabaseConnector.removeObject((Statement)stmtDelete);
                for (String filter : preferences.getPaypalFilterList()) {
                    String sql = "INSERT INTO PayPalFilterList (FilterID)Values(?)";
                    PreparedStatement stmt = DatabaseConnector.createPreparedStatement((String)sql, (String)"updateFilterList");
                    stmt.setString(1, filter);
                    try {
                        DatabaseConnector.executeUpdate((PreparedStatement)stmt);
                    }
                    catch (Exception ex) {
                        ErrorsUtil.getInstance().logError(ex);
                    }
                    finally {
                        DatabaseConnector.removeObject((PreparedStatement)stmt);
                    }
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCategoryAssociation(CategoryAssociation association) {
        Object object = this._lock;
        synchronized (object) {
            PreparedStatement insertStatement = null;
            PreparedStatement updateStatment = null;
            try {
                boolean updateSuccess;
                String insertSQL = SQLUtil.getInstance().createInsertSQL("Website_Category_Associations", new String[]{"WebsiteCategoryID", "BingCategoryName", "GoogleCategoryName"});
                String updateSQL = SQLUtil.getInstance().createUpdateSQL("Website_Category_Associations", new String[]{"BingCategoryName", "GoogleCategoryName"}, "WebsiteCategoryID");
                updateStatment = DatabaseConnector.createPreparedStatement((String)updateSQL, (String)"updateCategoryAssociation");
                int itemCounter = 1;
                updateStatment.setString(itemCounter++, association.getBingCategoryName());
                updateStatment.setString(itemCounter++, association.getGoogleCategoryName());
                updateStatment.setInt(itemCounter++, association.getCategoryID());
                boolean bl = updateSuccess = DatabaseConnector.executeUpdate((PreparedStatement)updateStatment) != 0;
                if (!updateSuccess) {
                    insertStatement = DatabaseConnector.createPreparedStatement((String)insertSQL, (String)"updateCategoryAssociation");
                    itemCounter = 1;
                    insertStatement.setInt(itemCounter++, association.getCategoryID());
                    insertStatement.setString(itemCounter++, association.getBingCategoryName());
                    insertStatement.setString(itemCounter++, association.getGoogleCategoryName());
                    DatabaseConnector.executeUpdate((PreparedStatement)insertStatement);
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
            DatabaseConnector.removeObject(updateStatment);
            DatabaseConnector.removeObject(insertStatement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getCategoryAssociations() {
        Object object = this._lock;
        synchronized (object) {
            try {
                return DatabaseConnector.createStatementResultSet((Statement)DatabaseConnector.createStatement((String)"getCategoryAssociations"), (String)"SELECT * FROM Website_Category_Associations", (String)"getCategoryAssociations");
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return null;
    }
}

