/*
 * Decompiled with CFR 0.152.
 */
package pnp.comms.db.lists;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import pnp.comms.db.PNPDatabaseManager;
import pnp.services.datatypes.AccountPreferences;
import pnp.services.datatypes.CompanyInfo;
import pnp.services.util.DatabaseConnector;
import pnp.services.util.ErrorsUtil;
import pnp.services.util.LookupServicesUtil;

public class AccountPreferencesList {
    private static AccountPreferencesList _instance;

    private AccountPreferencesList() {
    }

    public static AccountPreferencesList getInstance() {
        if (null == _instance) {
            _instance = new AccountPreferencesList();
        }
        return _instance;
    }

    public AccountPreferences getAccountPreferences(String profile) {
        CompanyInfo info;
        DatabaseConnector.push();
        ResultSet rs = PNPDatabaseManager.getInstance().getAccountPreferences(profile);
        AccountPreferences preferences = new AccountPreferences();
        if (rs != null) {
            block33: {
                try {
                    if (!rs.next()) break block33;
                    if (!DatabaseConnector.usingSQLDB) {
                        preferences.setGenProfiles((List)rs.getObject("GenProfiles"));
                    }
                    preferences.setGenProfile(rs.getString("GenProfile"));
                    preferences.setGenNegativeNotification(rs.getBoolean("GenNegativeNotification"));
                    preferences.setGenRefreshBehavior(rs.getBoolean("GenRefreshBehavior"));
                    preferences.setGenSalesPeriod(rs.getInt("GenSalesPeriod"));
                    preferences.setGenStockNotification(rs.getInt("GenStockNotification"));
                    preferences.setGenTrackingNotify(rs.getBoolean("GenTrackingNotify"));
                    preferences.setGenUnmergeNotify(rs.getBoolean("GenUnmergeNotify"));
                    preferences.setGenBusinessName(rs.getString("GenBusinessName"));
                    try {
                        preferences.setGenInvoiceComments(rs.getString("GenInvoiceComments"));
                    }
                    catch (Exception ex) {
                        ErrorsUtil.getInstance().logError(ex, false);
                    }
                    preferences.setGenWebsiteAddress(rs.getString("GenWebsiteAddress"));
                    preferences.setGenVersion(rs.getInt("GenVersion"));
                    preferences.setGenSyncNotification(rs.getBoolean("GenSyncNotification"));
                    preferences.setGenSplitRefresh(rs.getBoolean("GenSplitRefresh"));
                    preferences.setGenInventoryRefresh(rs.getBoolean("GenInventoryRefresh"));
                    preferences.setGenBetaUpdates(rs.getBoolean("GenBetaUpdates"));
                    preferences.setSubOfflineMode(rs.getBoolean("SubOfflineMode"));
                    preferences.setSubSaveCredentials(rs.getBoolean("SubSaveCredentials"));
                    preferences.setSubLicense(rs.getString("SubLicense"));
                    preferences.setSubPassword(rs.getString("SubPassword"));
                    preferences.setSubUsername(rs.getString("SubUsername"));
                    preferences.setEbayLastUpdate(rs.getLong("EbayLastUpdate"));
                    preferences.setPaypalLastUpdate(rs.getLong("PaypalLastUpdate"));
                    if (preferences.getEbayLastUpdate() != 0L && preferences.getPaypalLastUpdate() == 0L) {
                        preferences.setPaypalLastUpdate(preferences.getEbayLastUpdate());
                    }
                    preferences.setPaypalAutoLink(rs.getBoolean("PaypalAutoLink"));
                    preferences.setPaypalDomesticAddon(Double.valueOf(rs.getDouble("PaypalDomesticAddon")));
                    preferences.setPaypalDomesticFee(Double.valueOf(rs.getDouble("PaypalDomesticFee")));
                    preferences.setPaypalInternationalAddon(Double.valueOf(rs.getDouble("PaypalInternationalAddon")));
                    preferences.setPaypalInternationalFee(Double.valueOf(rs.getDouble("PaypalInternationalFee")));
                    preferences.setStampsSaveCredentials(rs.getBoolean("StampsSaveCredentials"));
                    preferences.setStampsSignatureConfirm(rs.getBoolean("StampsSignatureConfirm"));
                    preferences.setStampsAddress(rs.getString("StampsAddress"));
                    preferences.setStampsCity(rs.getString("StampsCity"));
                    preferences.setStampsCountry(rs.getString("StampsCountry"));
                    preferences.setStampsFullName(rs.getString("StampsFullName"));
                    preferences.setStampsImageLocation(rs.getString("StampsImageLocation"));
                    preferences.setStampsPassword(rs.getString("StampsPassword"));
                    preferences.setStampsPhoneNumber(rs.getString("StampsPhoneNumber"));
                    preferences.setStampsPostalCode(rs.getString("StampsPostalCode"));
                    preferences.setStampsState(rs.getString("StampsState"));
                    preferences.setStampsUsername(rs.getString("StampsUsername"));
                    preferences.setStampsLabelStatus(rs.getString("StampsLabelStatus"));
                    preferences.setStampsPrintLabels(rs.getBoolean("StampsPrintLabels"));
                    preferences.setStampsPurchaseLabels(rs.getBoolean("StampsPurchaseLabels"));
                    preferences.setStampsSaveLabels(rs.getBoolean("StampsSaveLabels"));
                    preferences.setStampsTracking(rs.getBoolean("StampsTracking"));
                    preferences.setStampsPrintOptions(rs.getString("StampsPrintOptions"));
                    preferences.setStampsPageOptions(rs.getString("StampsPageOptions"));
                    preferences.setStampsHideNotification(rs.getBoolean("StampsHideNotification"));
                    preferences.setStampsStorageDays(rs.getInt("StampsStorageDays"));
                    preferences.setStampsDateNotification(rs.getBoolean("StampsDateNotification"));
                    preferences.setStampsPackedWeight(rs.getBoolean("StampsPackedWeight"));
                    preferences.setStampsAutoPurchase(rs.getBoolean("StampsAutoPurchase"));
                    preferences.setStampsAutoPurchaseLimit(rs.getFloat("StampsAutoPurchaseLimit"));
                    preferences.setStampsAutoPurchaseWarning(rs.getBoolean("StampsAutoPurchaseWarning"));
                    preferences.setStampsInvalidPackageNotification(rs.getBoolean("StampsInvalidPackageNotification"));
                    preferences.setStampsPurchaseDateNotification(rs.getBoolean("StampsPurchaseDateNotification"));
                    preferences.setStampsComments(rs.getBoolean("StampsComments"));
                    preferences.setStampsMixedInventoryNotification(rs.getBoolean("StampsMixedInventoryNotification"));
                    preferences.setStampsNIAFilter(rs.getBoolean("StampsNIAFilter"));
                    preferences.setStampsAccount(rs.getString("StampsAccount"));
                    preferences.setStampsEndiciaUserName(rs.getString("StampsEndiciaUsername"));
                    preferences.setStampsEndiciaPassword(rs.getString("StampsEndiciaPassword"));
                    preferences.setStampsCommercialPlus(rs.getBoolean("StampsCommercialPlus"));
                    preferences.setStampsUPSUserName(rs.getString("StampsUPSUsername"));
                    preferences.setStampsUPSPassword(rs.getString("StampsUPSPassword"));
                    preferences.setStampsUPSAccessKey(rs.getString("StampsUPSAccessKey"));
                    preferences.setStampsUPSAccountNumber(rs.getString("StampsUPSAccountNumber"));
                    preferences.setStampsInternationalWarning(rs.getBoolean("StampsInternationalWarning"));
                    preferences.setStampsInternationalWarningPrice(rs.getFloat("StampsInternationalWarningPrice"));
                    preferences.setStampsDiscoWarning(rs.getString("StampsDiscoWarning"));
                    preferences.setStampsOOSWarning(rs.getString("StampsOOSWarning"));
                    if (!DatabaseConnector.usingSQLDB) {
                        preferences.setPaypalAccounts((ArrayList)rs.getObject("PaypalAccounts"));
                    }
                    preferences.setCompanyDefaultCompany(rs.getString("CompanyDefaultCompany"));
                }
                catch (Exception ex) {
                    ErrorsUtil.getInstance().logError(ex);
                }
            }
            DatabaseConnector.removeObject((ResultSet)rs);
        }
        rs = PNPDatabaseManager.getInstance().getPayPalAccounts();
        ArrayList<String> paypalAccounts = new ArrayList<String>();
        if (rs != null) {
            try {
                while (rs.next()) {
                    paypalAccounts.add(rs.getString("PayPalAccount"));
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
            DatabaseConnector.removeObject((ResultSet)rs);
        }
        if (!paypalAccounts.isEmpty()) {
            preferences.setPaypalAccounts(paypalAccounts);
        }
        rs = PNPDatabaseManager.getInstance().getProfiles();
        ArrayList<String> genProfiles = new ArrayList<String>();
        if (rs != null) {
            try {
                while (rs.next()) {
                    genProfiles.add(rs.getString("Profile"));
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
            DatabaseConnector.removeObject((ResultSet)rs);
        }
        if (!genProfiles.isEmpty()) {
            preferences.setGenProfiles(genProfiles);
        }
        rs = PNPDatabaseManager.getInstance().getCompanyInfo();
        HashMap<String, CompanyInfo> companyInformation = new HashMap<String, CompanyInfo>();
        if (rs != null) {
            try {
                while (rs.next()) {
                    info = new CompanyInfo();
                    info.setCompanyAddress(rs.getString("CompanyAddress"));
                    info.setCompanyCity(rs.getString("CompanyCity"));
                    info.setCompanyComments(rs.getString("CompanyComments"));
                    info.setCompanyCountry(rs.getString("CompanyCountry"));
                    info.setCompanyFullName(rs.getString("CompanyFullName"));
                    info.setCompanyName(rs.getString("CompanyName"));
                    if (!DatabaseConnector.usingSQLDB) {
                        info.setCompanyPaypalLinks((ArrayList)rs.getObject("CompanyPaypalLinks"));
                    }
                    ArrayList<String> links = new ArrayList<String>();
                    ResultSet rs1 = PNPDatabaseManager.getInstance().getCompanyLinks();
                    if (rs1 != null) {
                        try {
                            while (rs1.next()) {
                                String payPalLink = rs1.getString("PayPalLink");
                                String companyName = rs1.getString("CompanyName");
                                if (!info.getCompanyName().equalsIgnoreCase(companyName)) continue;
                                links.add(payPalLink);
                            }
                        }
                        catch (Exception ex) {
                            ErrorsUtil.getInstance().logError(ex);
                        }
                        DatabaseConnector.removeObject((ResultSet)rs1);
                    }
                    if (!links.isEmpty()) {
                        info.setCompanyPaypalLinks(links);
                    }
                    info.setCompanyPhoneNumber(rs.getString("CompanyPhoneNumber"));
                    info.setCompanyPostalCode(rs.getString("CompanyPostalCode"));
                    info.setCompanyState(rs.getString("CompanyState"));
                    info.setCompanyWebsite(rs.getString("CompanyWebsite"));
                    String companyName = CompanyInfo.sanitizeString((String)info.getCompanyName());
                    if (companyName == null) continue;
                    companyInformation.put(companyName, info);
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
            DatabaseConnector.removeObject((ResultSet)rs);
        }
        if (!companyInformation.containsKey("default")) {
            info = new CompanyInfo();
            info.setCompanyAddress("");
            info.setCompanyCity("");
            info.setCompanyComments("Thank you for your Business!");
            info.setCompanyCountry("US");
            info.setCompanyFullName("");
            info.setCompanyName("Default");
            info.setCompanyPaypalLinks(preferences.getPaypalAccounts());
            info.setCompanyPhoneNumber("");
            info.setCompanyPostalCode("");
            info.setCompanyState("");
            info.setCompanyWebsite("");
            companyInformation.put("default", info);
        }
        preferences.setCompanyInformation(companyInformation);
        rs = PNPDatabaseManager.getInstance().getPayPalFilters();
        ArrayList<String> paypalFilters = new ArrayList<String>();
        if (rs != null) {
            try {
                while (rs.next()) {
                    paypalFilters.add(rs.getString("FilterID"));
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
            DatabaseConnector.removeObject((ResultSet)rs);
        }
        preferences.setPaypalFilterList(paypalFilters);
        DatabaseConnector.pop();
        LookupServicesUtil.getManagerServices().refreshPayPal();
        return preferences;
    }

    public boolean renameCompany(String companySelected, String companyRenamed) {
        return PNPDatabaseManager.getInstance().renameCompany(companySelected, companyRenamed);
    }

    public boolean massChangeCompany(String companySelected, String companyRenamed) {
        return PNPDatabaseManager.getInstance().convertCompanyNameOrders(companySelected, companyRenamed);
    }

    public void updateAccountPreferences(AccountPreferences accountPreferences) {
        PNPDatabaseManager.getInstance().updateAccountPreferences(accountPreferences);
    }
}

