/*
 * Decompiled with CFR 0.152.
 */
package pnp.comms.db.lists;

import java.sql.ResultSet;
import pnp.comms.db.PNPDatabaseManager;
import pnp.services.datatypes.AmazonAccount;
import pnp.services.util.DatabaseConnector;
import pnp.services.util.ErrorsUtil;

public class AmazonAccountsList {
    private static AmazonAccountsList _instance;

    public static AmazonAccountsList getInstance() {
        if (null == _instance) {
            _instance = new AmazonAccountsList();
        }
        return _instance;
    }

    public void updateAmazonAccount(AmazonAccount account) {
        PNPDatabaseManager.getInstance().updateAmazonAccount(account);
    }

    public AmazonAccount getAmazonAccount() {
        AmazonAccount amazonAccount = new AmazonAccount();
        ResultSet rs = PNPDatabaseManager.getInstance().getAmazonAccounts();
        try {
            if (rs != null && !rs.isClosed() && rs.next()) {
                amazonAccount.setAccountName(rs.getString("UserName"));
                amazonAccount.setMarketPlaceID(rs.getString("AmazonAccountID"));
                amazonAccount.setSellerID(rs.getString("UserToken"));
                amazonAccount.setAmazonAccountNumber(rs.getInt("AmazonAccountNumber"));
                amazonAccount.setMwsAuthToken(rs.getString("MwsAuthToken"));
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        DatabaseConnector.removeObject((ResultSet)rs);
        return amazonAccount;
    }
}

