/*
 * Decompiled with CFR 0.152.
 */
package pnp.comms.db.lists;

import java.sql.ResultSet;
import java.util.HashMap;
import pnp.comms.db.PNPDatabaseManager;
import pnp.services.datatypes.CategoryAssociation;
import pnp.services.util.ErrorsUtil;

public class CategoryAssociationsList {
    private static CategoryAssociationsList _instance;

    private CategoryAssociationsList() {
    }

    public static CategoryAssociationsList getInstance() {
        if (null == _instance) {
            _instance = new CategoryAssociationsList();
        }
        return _instance;
    }

    public HashMap<Integer, CategoryAssociation> getCategoryAssociations() {
        ResultSet rs = PNPDatabaseManager.getInstance().getCategoryAssociations();
        HashMap<Integer, CategoryAssociation> associations = new HashMap<Integer, CategoryAssociation>();
        try {
            while (rs != null && rs.next()) {
                CategoryAssociation newAssociation = new CategoryAssociation();
                newAssociation.setCategoryID(rs.getInt("WebsiteCategoryID"));
                newAssociation.setBingCategoryName(rs.getString("BingCategoryName"));
                newAssociation.setGoogleCategoryName(rs.getString("GoogleCategoryName"));
                associations.put(newAssociation.getCategoryID(), newAssociation);
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        return associations;
    }

    public void updateCategoryAssociations(CategoryAssociation association) {
        PNPDatabaseManager.getInstance().updateCategoryAssociation(association);
    }
}

