/*
 * Decompiled with CFR 0.152.
 */
package pnp.comms.db.lists;

import java.sql.ResultSet;
import java.util.HashMap;
import pnp.comms.db.PNPDatabaseManager;
import pnp.services.datatypes.Category;
import pnp.services.listener.GenericListener;
import pnp.services.listenermanager.ListenerManager;
import pnp.services.util.DatabaseConnector;
import pnp.services.util.ErrorsUtil;

public class CategoryList {
    private HashMap<Integer, Category> _categories = new HashMap();
    private static CategoryList _instance;

    private CategoryList() {
        this.refreshCategoryList(false);
    }

    public static CategoryList getInstance() {
        if (null == _instance) {
            _instance = new CategoryList();
        }
        return _instance;
    }

    private void refreshCategoryList(boolean notify) {
        this._categories.clear();
        ResultSet rs = PNPDatabaseManager.getInstance().getCategories();
        try {
            if (null != rs) {
                while (rs.next()) {
                    Category element = new Category();
                    element.setCategoryID(rs.getInt("CategoryID"));
                    element.setCategoryName(rs.getString("CategoryName"));
                    this._categories.put(element.getCategoryID(), element);
                }
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        DatabaseConnector.removeObject((ResultSet)rs);
        if (notify) {
            ListenerManager.getInstance().notify((GenericListener)ListenerManager.CATEGORY_LIST_LISTENER);
        }
    }

    public Category[] getCategories() {
        return this._categories.values().toArray(new Category[0]);
    }

    public void setCategory(Category category) {
        PNPDatabaseManager.getInstance().updateCategory(category);
        this.refreshCategoryList(true);
    }

    public void removeCategory(int categoryID) {
        PNPDatabaseManager.getInstance().removeCategory(categoryID);
        this.refreshCategoryList(true);
    }

    public void mergeCategory(int selectedCategory, int movedToCategory) {
        PNPDatabaseManager.getInstance().mergeCategory(selectedCategory, movedToCategory);
        this.refreshCategoryList(true);
    }
}

