/*
 * Decompiled with CFR 0.152.
 */
package pnp.comms.db.lists;

import java.sql.ResultSet;
import java.util.HashMap;
import pnp.comms.db.PNPDatabaseManager;
import pnp.services.datatypes.CheckDetails;
import pnp.services.util.DatabaseConnector;
import pnp.services.util.ErrorsUtil;

public class CheckDetailsList {
    private static CheckDetailsList _instance;

    private CheckDetailsList() {
    }

    public static CheckDetailsList getInstance() {
        if (null == _instance) {
            _instance = new CheckDetailsList();
        }
        return _instance;
    }

    public void insertCheckDetails(CheckDetails checkDetails) {
        PNPDatabaseManager.getInstance().insertCheckDetails(checkDetails);
    }

    public HashMap<Integer, CheckDetails> parseResultSet(ResultSet rs) {
        HashMap<Integer, CheckDetails> detailsHash = new HashMap<Integer, CheckDetails>();
        try {
            if (null != rs) {
                while (rs.next()) {
                    CheckDetails newDetails = new CheckDetails();
                    newDetails.setCheckID(rs.getInt("CheckID"));
                    newDetails.setOrderDetailsID(rs.getInt("OrderDetailsID"));
                    newDetails.setOrderID(rs.getString("OrderID"));
                    newDetails.setPackedWeight(rs.getFloat("PackedWeight"));
                    newDetails.setWeight(rs.getFloat("Weight"));
                    newDetails.setPaypalAccount(rs.getString("PayPalAccount"));
                    newDetails.setDiscontinued(rs.getBoolean("Discontinued"));
                    newDetails.setQuantityLeft(rs.getInt("QuantityRemaining"));
                    newDetails.setItemID(rs.getString("ItemID"));
                    detailsHash.put(newDetails.getOrderDetailsID(), newDetails);
                }
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        DatabaseConnector.removeObject((ResultSet)rs);
        return detailsHash;
    }

    public HashMap<Integer, CheckDetails> getCheckDetails(String orderID) {
        ResultSet rs = PNPDatabaseManager.getInstance().getCheckDetails(orderID);
        return this.parseResultSet(rs);
    }

    public void deleteCheckDetails(String orderID) {
        PNPDatabaseManager.getInstance().deleteCheckDetails(orderID);
    }
}

