/*
 * Decompiled with CFR 0.152.
 */
package pnp.comms.db.lists;

import java.util.HashMap;
import pnp.services.datatypes.CompleteOrder;
import pnp.services.listener.GenericListener;
import pnp.services.listener.TransactionListener;
import pnp.services.listenermanager.ListenerManager;
import pnp.services.util.LookupServicesUtil;

public class CompletedOrderList
implements TransactionListener {
    private HashMap<Integer, CompleteOrder> _orderList;
    private static CompletedOrderList _instance;
    private final Object _lock = new Object();
    private long _searchFrom;
    private long _searchTo;

    private CompletedOrderList() {
        this._orderList = new HashMap();
        ListenerManager.getInstance().subscribe((GenericListener)this);
    }

    public static CompletedOrderList getInstance() {
        if (null == _instance) {
            _instance = new CompletedOrderList();
        }
        return _instance;
    }

    public HashMap<Integer, CompleteOrder> getOrderList() {
        return this._orderList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshOrders(long from, long to) {
        Object object = this._lock;
        synchronized (object) {
            this._searchFrom = from;
            this._searchTo = to;
            this.newTransactionAvailable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newTransactionAvailable() {
        Object object = this._lock;
        synchronized (object) {
            this._orderList = LookupServicesUtil.getDBServices().getCompletedOrders(this._searchFrom, this._searchTo);
            ListenerManager.getInstance().notify((GenericListener)ListenerManager.COMPLETED_ORDER_LIST_LISTENER);
        }
    }
}

