/*
 * Decompiled with CFR 0.152.
 */
package pnp.comms.db.lists;

import java.sql.ResultSet;
import java.util.HashMap;
import pnp.comms.db.PNPDatabaseManager;
import pnp.services.datatypes.CustomFee;
import pnp.services.listener.GenericListener;
import pnp.services.listenermanager.ListenerManager;
import pnp.services.util.DatabaseConnector;
import pnp.services.util.ErrorsUtil;

public class CustomFeeList {
    private HashMap<Integer, CustomFee> _customFeeMap = new HashMap();
    private static CustomFeeList _instance;

    private CustomFeeList() {
        this.refreshCustomFeeList(false);
    }

    public static CustomFeeList getInstance() {
        if (null == _instance) {
            _instance = new CustomFeeList();
        }
        return _instance;
    }

    private void refreshCustomFeeList(boolean notify) {
        this._customFeeMap.clear();
        ResultSet rs = PNPDatabaseManager.getInstance().getCustomFees();
        try {
            if (null != rs) {
                while (rs.next()) {
                    CustomFee element = new CustomFee();
                    element.setFeeName(rs.getString("CustomFeeName"));
                    element.setFeePercentage(rs.getDouble("CustomFeePercentage"));
                    element.setFeeFlatCost(rs.getDouble("CustomFeeFlatCost"));
                    element.setCustomFeeID(rs.getInt("CustomFeeID"));
                    this._customFeeMap.put(element.getCustomFeeID(), element);
                }
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        DatabaseConnector.removeObject((ResultSet)rs);
        if (notify) {
            ListenerManager.getInstance().notify((GenericListener)ListenerManager.CUSTOM_FEE_LISTENER);
        }
    }

    public CustomFee[] getCustomFees() {
        return this._customFeeMap.values().toArray(new CustomFee[0]);
    }

    public void setCustomFee(CustomFee customFee) {
        PNPDatabaseManager.getInstance().updateCustomFee(customFee);
        this.refreshCustomFeeList(true);
    }

    public void removeCustomFee(CustomFee customFee) {
        PNPDatabaseManager.getInstance().removeCustomFee(customFee);
        this.refreshCustomFeeList(true);
    }
}

